
//#define BitFieldUsing
using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;
using System.Dynamic;
namespace ComiECAT
{
    [System.Security.SuppressUnmanagedCodeSecurity]
    public partial class SafeNativeMethods
    {
        const string dll = "ComiEcatSdk.dll";
        //====================== DLL LOAD/UNLOAD FUNCTIONS ======================================================//
        //EC_EXTERN t_success ecDll_Load (void);        
        //EC_EXTERN t_success ecDll_Unload (void);      
        //[DllImport(dll, EntryPoint = "ecDll_Unload")]
        //EC_EXTERN BOOL		ecDll_IsLoaded(void);

        ////====================== GENERAL FUNCTIONS ==============================================================//

        //EC_EXTERN t_success (CECAT_API *ecGn_LoadDevices) (t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_LoadDevice(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_UnloadDevices) (t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_UnloadDevices(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN BOOL		(CECAT_API *ecGn_IsDevLoaded) (t_i32 DevIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern unsafe bool ecGn_IsDevLoaded(
            [MarshalAs(UnmanagedType.I4)] int DevIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecGn_GetNumDevices) (t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecGn_GetNumDevices(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecGn_GetNumNetworks) (t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecGn_GetNumNetworks(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecGn_GetDevInfo) (t_i32 DevIdx, TEcDevInfo *pDevInfo, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_GetDevInfo(
            [MarshalAs(UnmanagedType.I4)] int DevIdx, 
            ref TEcDevInfo pDevInfo,  
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecGn_SetEnableTimerResolSet) (t_bool IsEnable, t_i32 *ErrCode); 
        // 라이브러리 내부에서 Sleep()을 적용할 때 타이머 분해능을 1msec로 조절하고 Sleep()할 것인지를 설정한다. 0-1msec분해능 조정 없이 Sleep, 1(default값)-1msec분해능으로 조정하고 Sleep후 분해능 복원,  
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_SetEnableTimerResolSet(
            [MarshalAs(UnmanagedType.I1)] bool IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecGn_GetEnableTimerResolSet) (t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_GetEnableTimerResolSet(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        //====================== GENERAL UNTILITY FUNCTIONS ============================================//
        //EC_EXTERN void		(CECAT_API *ecUtl_ShowError_A) (HWND hParentWnd, char *szFormat, ...);
        [DllImport(dll)]
        public static extern unsafe void ecUtl_ShowError_A(
            [MarshalAs(UnmanagedType.I4)] int hParentWnd, 
            char[] szFormat);

        //EC_EXTERN void		(CECAT_API *ecUtl_ShowError_W) (HWND hParentWnd, WCHAR *szFormat, ...);
        [DllImport(dll)]
        public static extern unsafe void ecUtl_ShowError_W(
            [MarshalAs(UnmanagedType.I4)] int hParentWnd, 
            [MarshalAs(UnmanagedType.LPWStr)] string szFormat);

        //EC_EXTERN void		(CECAT_API *ecUtl_ShowMessage_A) (HWND hParentWnd, WCHAR *szFormat, ...);
        [DllImport(dll)]
        public static extern unsafe void ecUtl_ShowMessage_A(
            [MarshalAs(UnmanagedType.I4)] int hParentWnd, 
            ref char[] szFormat);

        //EC_EXTERN void		(CECAT_API *ecUtl_ShowMessage_W) (HWND hParentWnd, WCHAR *szFormat, ...);
        [DllImport(dll)]
        public static extern unsafe void ecUtl_ShowMessage_W(
            [MarshalAs(UnmanagedType.I4)] int hParentWnd, 
            [MarshalAs(UnmanagedType.LPWStr)] string szFormat);

        //EC_EXTERN t_ui16	(CECAT_API *ecUtl_GetCntDiff_UI16) (t_ui16 PrvVal, t_ui16 CurVal);
        [DllImport(dll)]
        public static extern unsafe ushort ecUtl_GetCntDiff_UI16(
            [MarshalAs(UnmanagedType.U4)] uint PrvVal, 
            [MarshalAs(UnmanagedType.U4)] uint CurVal);

        //EC_EXTERN t_bool	(CECAT_API *ecUtl_IsTimeOut) (t_ui32 dwStartTime_ms, t_ui32 dwTimeOutVal_ms);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecUtl_IsTimeOut(
            [MarshalAs(UnmanagedType.U4)] uint dwStartTime_ms,
            [MarshalAs(UnmanagedType.U4)] uint dwTimeOutVal_ms);


        public static string ecUtl_GetErrorString(int errorCode)
        {
            switch (errorCode)
            {
                case -5: return "ecERR_DEVICE_NOT_LOADED (지정된 디바이스가 로드되지 않은 경우)";
                case -6: return "ecERR_WDM_VER_READ_FAIL (WDM 드라이버에서 버전 정보를 읽는데 실패한 경우)";
                case -7: return "ecERR_FW_VER_READ_FAIL (Firmware 버전 정보를 읽는데 실패한 경우)";
                case -8: return "ecERR_DEV_BOOT_TIMEOUT (Master Device가 지정된 시   간 안에 부팅이 완료되지 않은 경우)";
                case -9: return "ecERR_DEV_BOOT_NOT_COMPT (Master Device가 아직 부트업이 완료되지 않은 경우)";
                case -10: return "ecERR_INVALID_BOARDID";
                case -11: return "ecERR_INVALID_DEVIDX";
                case -12: return "ecERR_INVALID_VERSION (SDK(DLL), WDM 드라이버, 펌웨어(Firmware) 상호간에 버전이 호환되지 않는 경우)";
                case -20: return "ecERR_INVALID_NETID";
                case -25: return "ecERR_INVALID_SLAVEID (슬레이브 인덱스 또는 슬레이브 주소가 잘못된 경우)";
                case -30: return "ecERR_INVALID_CHANNEL (축번호 또는 채널번호 등이 잘못된 경우)";
                case -40: return "ecERR_INVALID_IXMAP_IDX (Motion 제어 기능에서 Interpolation 보간 맵 번호가 잘못된 경우)";
                case -50: return "ecERR_INVALID_IXMAP_AXES (IXMAP에 포함된 축의 구성이 잘못된 경우)";
                case -55: return "ecERR_INVALID_LMMAP_IDX (리스트모션 보간 맵 번호가 잘못된 경우)";
                case -60: return "ecERR_INVALID_FUNC_ARG (함수의 매개변수가 유효하지 않은 값인 경우)";
                case -65: return "ecERR_INVALID_HANDLE (Invalid handle value가 매개변수로 전달된 경우)";
                case -66: return "ecERR_INVALID_RESULT_DATA (결과 데이터가 유효하지 않은 경우)";
                case -67: return "ecERR_INVALID_SIZE_INFO (크기 관련 데이터 정보가 유효하지 않은 경우)";
                case -69: return "ecERR_NULL_DLLNETCTXT";
                case -70: return "ecERR_NULL_WDMNETCTXT (WDM 드라이버에서 제공하는 공유메모리 포인터가 NULL인 경)";
                case -71: return "ecERR_NULL_INPDOLMEM (WDM 드라이버에서 제공하는 InPDO용 논리메모리 포인터가 NULL인 경우)";
                case -72: return "ecERR_NULL_OUTPDOLMEM *WDM 드라이버에서 제공하는 OutPDO용 논리메모리 포인터가 NULL인 경우)";
                case -73: return "ecERR_INVALID_AXIS_INPDO_TYPE (현재 설정되어 있는 Axis InputPDO 형식이 원하는 데이터를 지원하지 않음)";
                case -80: return "ecERR_INVALID_SECTION_ID (PDO Section ID가 올바르지 않거나, 환경설정된 섹션 리스트에 없는 경우)";
                case -90: return "ecERR_INVALID_LOG_MEM_ADDR (Logical Memory의 주소값이 올바르지 않은 경우)";
                case -95: return "ecERR_INVALID_BUFFER (버퍼의 주소값이 유효하지 않은 경우)";
                case -100: return "ecERR_INVALID_IO_CHAN_MAP_DATA (I/O 채널 맵핑 데이터의 일부 멤버값이 올바르지 않은 경우)";
                case -110: return "ecERR_INVALID_FILE_PATH (지정한 파일의 경로가 잘못되었거나 파일이 없는 경우)";
                case -111: return "ecERR_INTERNAL_PROCESS_FAULT (내부 연산 오류)";
                case -112: return "ecERR_MUTEX_CREATE_FAIL (Mutex 생성 실패)";
                case -113: return "ecERR_EVENT_CREATE_FAIL (이벤트 핸들 생성 실패)";
                case -114: return "ecERR_THREAD_CREATE_FAIL (쓰레드 생성 실패)";
                case -120: return "ecERR_FILE_OPEN_FAIL";
                case -125: return "ecERR_FILE_NOT_FOUND (지정한 파일이 검색되지 않은 경우)";
                case -130: return "ecERR_FILE_READ_ERROR (파일을 읽는 과정에서 에러가 발생한 경우)";
                case -140: return "ecERR_FILE_VERIF_DATA_ERROR (CFG파일 Verfication을 수행했을 때 상호간의 데이터가 일치하지 않는 경우)";
                case -150: return "ecERR_MEM_ALLOC_FAIL (Memory Allocation fail)";
                case -160: return "ecERR_XML_POS_SAVE_ERR (XML 데이터 읽기할 때 현재의 TREE position을 저장하는데 오류가 발생한 경우)";
                case -165: return "ecERR_XML_ELEM_NOT_FOUND (XML 데이터 읽기할 때 지정한 Element가 검색되지 않은 경우)";
                case -166: return "ecERR_INVALID_ODLIST_LEN_INFO (슬레이브로부터 전달된 SDO Info. OD List의 크기 정보가 유효하지 않은 경우)";
                case -180: return "ecERR_INVALID_FIRMWARE_SIGN (마스터장치에 다운로드 되어 있는 펌웨어의 signature가 유효하지 않은 경우)";
                case -181: return "ecERR_FW_VERIF_DATA_MISMATCH (F/W Download를 한 후에 Verify 과정에서 데이터가 일치하지 않은 경우)";
                case -182: return "ecERR_EEPROM_WRITE_FAIL (ESC의 EEPROM에 데이터 쓰기 실패)";
                case -183: return "ecERR_IMPROPER_AL_STATE (AL-STATE가 적절하지 않은 경우)";
                case -184: return "ecERR_INVALID_CHANNEL_TYPE (유효하지 않은 채널 형식인 경우)";

                //Motion 제어 전용 에러
                case -1010: return "ecERR_MOT_SERVO_ALARM (Servo driver에 알람이 발생한 경우)";
                case -1020: return "ecERR_MOT_SEQ_SKIPPED (Motion command has been skipped because the axis is already running)";
                case -1030: return "ecERR_MOT_LM_QUE_FULL (ListMotion Queue가 꽉차서 리스트모션 커맨드를 Queueing할 수 없는 경우)";
                case -1040: return "ecERR_MOT_LM_INVALID_OWNERSHIP (동일한 ListMotion 맵에 대한 제어권을 다른 프로세스에서 가로챈 경우)";

                //WDM 드라이버 프로그램에서 발생하는 에러코드
                case -5001: return "ERR_INVALID_DSP_IDX (잘못된 DSP Index를 매개변수로 커맨드를 요청한 경우)";
                case -5005: return "ERR_DSPCMD_IRQ_TIMEOUT (DSP Command 요청 인터럽트 요청이 제한된 시간내에 성공하지 못한 경우)";
                case -5006: return "ERR_DSPCMD_ACK_CLR_TIMEOUT (DSP 가 PCI Command에 대한 Ack 플래그를 정해진 시간 내에 클리어하지 않은 경우)";
                case -5007: return "ERR_DSPCMD_ACK_SET_TIMEOUT (DSP 가 PCI Command에 대한 Ack 플래그를 정해진 시간 내에 셋하지 않은 경우)";
                case -5010: return "ERR_PENDEDIRP_ADDTOLIST_FAIL (특정 IRP를 PendingList에 등록하려했으나 실패)";
                case -5020: return "ERR_DSPCMD_ANS_TIMEOUT (DSP 커맨드가 제한된 시간 내에 응답을 하지 않음)";

                //ETHERCAT 통신 처리 관련 에러 
                case -10010: return "ecERR_GEN_INVAL_ARGUMENT (함수 호출 시에 매개변수값이 잘못된 경우)";
                case -10020: return "ecERR_GEN_DGRAM_OBJ_ALLOC_FAIL (Slave에서 DataGram 메모리를 할당하는데 실패함)";
                case -10025: return "ecERR_GEN_MCMD_ALLOC_FAIL (Slave에서 DataGram 메모리를 할당하는데 실패함)";
                case -10030: return "ecERR_GEN_MCMD_TIMEOUT (MasterCmd 처리 타임아웃)";
                case -10040: return "ecERR_GEN_MCMD_ITEM_NOT_FOUND ( 지정한 MCmdIdx에 대한 MasterCmd Item을 리스트에서 찾을 수 없는 경우)";
                case -10050: return "ecERR_GEN_BUF_SIZE_TOO_SMALL";
                case -10060: return "ecERR_GEN_SLV_PHYSADDR_NOT_SET (Slave에 Physical Address가 셋팅되지 않음)";
                case -10070: return "ecERR_GEN_INVAL_REG_RW_SIZE (Slave Register Read/Write 시에 허용된 크기보다 큰 데이터를 Read/Write한 경우)";
                case -10080: return "ecERR_GEN_INVAL_SLAVE_ID";
                case -10090: return "ecERR_GEN_ECSLV_OBJ_NOT_FOUND (TEcSlave 객체 포인터가 null인 경우)";
                case -10100: return "ecERR_GEN_STATE_CHANGE_FAIL (EcSlave 객체 포인터가 null인 경우)";

                //커맨드 에러    
                case -10210: return "ecERR_CMD_VENDID_READ_FAIL (Vendor ID 읽기 실패. 세부 실패 원인은 서브데이터 참고)";
                case -10220: return "ecERR_CMD_PRODCODE_READ_FAIL (Product Code 읽기 실패. 세부 실패 원인은 서브데이터 참고)";
                case -10230: return "ecERR_CMD_REVNO_READ_FAIL (Revision No. 읽기 실패. 세부 실패 원인은 서브데이터 참고)";
                case -10240: return "ecERR_CMD_SERNO_READ_FAIL (Serial No. 읽기 실패. 세부 실패 원인은 서브데이터 참고)";
                case -10250: return "ecERR_CMD_SET_PHY_ADDR_FAIL (Physical Address 셋팅 실패. 세부 실패 원인은 서브데이터 참고)";
                case -10260: return "ecERR_CMD_SET_DL_CTL_REG_FAIL (DL Control Register 셋팅 실패. 세부 실패 원인은 서브데이터 참고)";
                case -10265: return "ecERR_CMD_SET_AL_STATE_CHANGE_FAIL (AL State 변경 과정 중에 에러 발생)";
                case -10270: return "ecERR_CMD_PDOMAP_ASSIGN_FAIL (In/Out PDO Map Assign 실패. 세부 실패 원인은 서브데이터 참고)";
                case -10280: return "ecERR_CMD_FMMU_SETTING_FAIL (In/Out PDO Map Assign 실패. 세부 실패 원인은 서브데이터 참고)";
                case -10290: return "ecERR_CMD_PDO_SYNC_MODE_SET_FAIL (In/Out PDO Map Assign 실패. 세부 실패 원인은 서브데이터 참고)";

                //EtherCAT 통신관련 일반 에러
                case -10405: return "ecERR_ECG_DGRM_TIMEOUT (특정 EC 커맨드에 대해서 제한 시간 이내에 유효한 응답을 수신하지 못하  경우)";
                case -10410: return "ecERR_ECG_STATE_CHANGE_TIMEOUT (Slave의 State Change를 요청했으나 실제 변경하는데 제한된 시간을 초과한 경우)";
                case -10415: return "ecERR_ECG_SLAVE_DISCON (Slave가 disconnected 상태인 경우)";

                //Mailbox 통신관련 에러
                case -10610: return "ecERR_MBX_COE_NOT_SUPP (지정한  슬레이브가 CoE 프로토콜을 지원하지 않는 경우)";
                case -10620: return "ecERR_MBX_INVAL_SDO_RESP (SDO Command에 대한 응답 프레임이 올바르지 않음)";
                case -10630: return "ecERR_MBX_INVAL_SDO_SIZE (SDO의 Size 정보가 잘못된 경우)";
                case -10640: return "ecERR_MBX_SDO_DATA_SIZE_ERR (SDO 데이터가 제한된 크기보다 큰 경우)";
                case -10650: return "ecERR_MBX_INVAL_SLAVE_ID (Slave Id가 잘못 지정된 경우)";
                case -10660: return "ecERR_MBX_TXFER_ABORTED (Mailbox 통신이 abort됨, 이 때 Abort Code ID를 알려면 TEcSlave::LastErrSubData를 참조)";

                //PDO 통신관련에러
                case -10810: return "ecERR_INVALID_PDO_SIZE (PDO 크기 정보가 잘못된 경우)";
                case -10820: return "ecERR_PDO_BUF_ALLOC_FAIL (PDO 버퍼 할당 실패)";
                case -10830: return "ecERR_INVALID_OUTPDO_SM_IDX (OutPDO에 대한 SM 인덱스가 올바르지 않다)";
                case -10840: return "ecERR_INVALID_INPDO_SM_IDX (OutPDO에 대한 SM 인덱스가 올바르지 않다)";

                //---------------------------------------------------------------------------------------------------------------------------
                //			마스터장치내에서 APPLICATION 커맨드 처리 관련 에러코드
                //---------------------------------------------------------------------------------------------------------------------------

                // EcatApp 프로세서와의 IPC 통신 관련 에러 //
                case -11010: return "ecERR_IPC_MSGQ_HEAP_CRE_FAIL (IPC Message Que를 위한 Heap을 생성하는데 실패)";
                case -11020: return "ecERR_IPC_MSGQ_CRE_FAIL (IPC Message Que를 생성하느데 실패)";
                case -11030: return "ecERR_IPC_INVAL_ECM_DATASIZE (EcmCmd의 DataSize로 지정된 값이 너무 큰 경우)";
                case -11040: return "ecERR_IPC_MSGQ_PUT_FAIL (IPC Message Que에 메시지를 Put하는데 실패함 (MessageQ_put() 함수 실행 실패))";
                case -11050: return "ecERR_IPC_NOTIEVT_FAIL (IPC Notification event를 처리하는데 에러가 발생)";
                case -11060: return "ecERR_IPC_WAITACK_TIMEOUT (IPC Message 를 잘 받았다는 EcatMast측의 ACK 메시지 수신에 대한 타임아웃 발생)";

                // DSP1(APP)에서 사용하는 에러코드
                case -20010: return "eaERR_GEN_MALLOC_FAIL (memory allocation fail)";
                case -20030: return "eaERR_FLASH_DEV_OPEN_FAIL (Flash 메모리장치를 open하는데 에러가 발생한 경우)";
                case -20031: return "eaERR_FLASH_DEV_WRITE_FAIL (Flash 메모리장치에 데이터를 쓰기하는 과정에서 에러가 발생한 경우)";
                case -20032: return "eaERR_FLASH_DEV_READ_FAIL (Flash 메모리장치에 데이터를 읽기하는 과정에서 에러가 발생한 경우)";
                case -20035: return "eaERR_INVALID_FWU_SIGNATURE (Flash 메모리장치에 저장된 FW 정보가 유효하지 않은 경우)";
                case -20040: return "eaERR_INVALID_BUF_SIZE (Buffer size 정보가 잘못된 경우)";
                case -20041: return "eaERR_INVALID_BUFFER (지정된 버퍼가 NULL이거나 잘못된 버퍼가 지정된 경우)";

                // PCI 커맨드  처리 관련 에러 //
                case -20210: return "eaERR_PCICMD_TIMEOUT (PciCmd를 처리하는 과정에서 타임아웃 발생함. 이때 Error SubData는 CmdId를 나타낸다)";
                case -20220: return "eaERR_PCICMD_INVALID_CMDID (PciCmd의 CommandID가 유효하지 않음)";
                case -20230: return "eaERR_PCICMD_INVALID_ARG (PciCmd의 Argument가 유효하지 않음)";
                case -20240: return "eaERR_PCICMD_INVALID_SLVIDX (PciCmd의 SlaveIndex 가 잘못 전달된 경우)";
                case -20250: return "eaERR_PCICMD_INVALID_AXIS (Motion PciCmd의 Axis 매개변수가 잘못 전달된 경우)";
                case -20260: return "eaERR_PCICMD_INVALID_IXMAP_IDX (Motion PciCmd의 Axis 매개변수가 잘못 전달된 경우)";
                case -20270: return "eaERR_PCICMD_HOME_START_TIMEOUT (Homing을 시작시켰으나 서보드라이버가 Homing을 진행하지 않는 경우)";
                case -20280: return "eaERR_PCICMD_INVALID_AL_STATE (해당 커맨드를 실행할 수 있는 AL State가 아닌 경우)";

                // EcatMast(Net) 프로세서와의 IPC 통신 관련 에러 //
                case -20410: return "eaERR_IPC_MSGQ_HEAP_CRE_FAIL (IPC Message Que를 위한 Heap을 생성하는데 실패)";
                case -20420: return "eaERR_IPC_MSGQ_CRE_FAIL (IPC Message Que를 생성하느데 실패)";
                case -20430: return "eaERR_IPC_INVAL_EAPC_DATASIZE (EapCmd의 DataSize로 지정된 값이 너무 큰 경우)";
                case -20440: return "eaERR_IPC_MSGQ_PUT_FAIL (IPC Message Que에 메시지를 Put하는데 실패함 (MessageQ_put() 함수 실행 실패))";
                case -20450: return "eaERR_IPC_NOTIEVT_FAIL (IPC Notification event를 처리하는데 에러가 발생)";
                case -20460: return "eaERR_IPC_WAITACK_TIMEOUT (IPC Message 를 잘 받았다는 EcatMast측의 ACK 메시지 수신에 대한 타임아웃 발생)";

                // 모션제어 관련 에러코드 //
                case -21002: return "eaERR_AXIS_MOT_QUE_FULL (axis-motion-que가 꽉차서 모션을 예약하지 못하였음)";
                case -21010: return "eaERR_INVALID_PARAMETER (Some of the funcion parameters are invalid)";
                case -21011: return "eaERR_INVALID_AXIS (The axis setting parameter(s) is(are) invalid)";
                case -21012: return "eaERR_INVALID_SPEED_SET (Speed setting value is not valid)";
                case -21013: return "eaERR_INVALID_IXMAP (Invalid Interpolation Map)";
                case -21014: return "eaERR_INVALID_LMMAP (Invalid List-Motion Map)";
                case -21015: return "eaERR_INVALID_NUMAXIS (Invlaid number of axis(Mx))";
                case -21016: return "eaERR_INVALID_MAST_AXIS (Invlaid master axis settings for Master/Slave Motion)";
                case -21017: return "eaERR_INVALID_SPLINE_SETUP (SpineSetup() 함수가 수행되지 않은 상태에서 Spline보간 관련 다른 함수를 실행한 경우)";
                case -21038: return "eaERR_INVALID_POS_DATA (Position 데이터가 유효하지 않은 경우)";
                case -21030: return "eaERR_IX_AXES_NOT_DEFINED (보간 축 설정이 수행되지 않은 경우)";
                case -21035: return "eaERR_IX_OBJ_POOL_FULL (spline/MPRLin2X 등의  object 등록 pool에 현재 등록되어 있는 object가 최대 갯수만큼 등록되어서 더 이상 추가할 수 없는 경우)";
                case -21036: return "eaERR_IX_OBJ_NOT_FOUND (spline/MPRLin2X 등의  object pool에서 지정한 SPLINE OBJECT를 찾을 수 없음)";
                case -21037: return "eaERR_IX_OBJ_NOT_BUILDED (spline/MPRLin2X 등의  object Build를 수행하지 않고 이송 시작을 수행한 경우)";
                case -21047: return "eaERR_STOP_BY_COLLA (충돌방지조건에 의해서 정지된 경우)";
                case -21048: return "eaERR_STOP_BY_HEMG (HEMG(Hardware Emergnecy Input) 신호에 의해서 정지)";
                case -21049: return "eaERR_STOP_BY_SEMG (HEMG(Software Emergnecy Input) 신호에 의해서 정지)";
                case -21050: return "eaERR_STOP_BY_SLP (Abnormally stopped by positive soft limit)";
                case -21051: return "eaERR_STOP_BY_SLN (Abnormally stopped by negative soft limit)";
                case -21052: return "eaERR_STOP_BY_ELP (Abnormally stopped by (+) external limit)";
                case -21053: return "eaERR_STOP_BY_ELN (Abnormally stopped by (-) external limit)";
                case -21054: return "eaERR_STOP_BY_ALM (Abnormally stopped by alarm input signal)";
                case -21055: return "eaERR_STOP_BY_COMM_ERROR (Abnormally Stopped by communication error)";
                case -21056: return "eaERR_STOP_BY_OTHER_AXIS (다른 축과의 협업 이송 중에 다른 축의 에러에 의해서 정지된 경우)";
                case -21057: return "eaERR_STOP_BY_SVOFF (SERVO-OFF된 상태에서 이송명령이 내려진 경우, 또는 이송 중에 SERVO-OFF된 경우)";
                case -21060: return "eaERR_MOT_SEQ_SKIPPED (Motion command has been skipped because the axis is already running)";
                case -21062: return "eaERR_SKIPPED_BY_SERVO_FAULT (Motion Control Command is skipped because of servo-driver alarm)";
                case -21063: return "eaERR_SKIPPED_BY_SERVO_OFF (Motion Control Command is skipped because of 'Operation Enable(Servo-ON)' state is off)";
                case -21064: return "eaERR_SKIPPED_BY_SERVO_ON (서보온이 되어 있는 상태에서 처리할 수 없는 명령이 하달되어 해당 명령의 수행이 되지 않은 경우)";
                case -21070: return "eaERR_HOME_START_TIMEOUT (서보드라이버에 Homming start 명령을 내렸으나 지정된 시간 내에  Homming이 시작되지 않는 경우)";
                case -21071: return "eaERR_HOME_COMPT_FAIL (Servo driver의 Homing 작업을 완료하는 과정에서 에러가 발생함)";
                case -21072: return "eaERR_HOME_TPROBE_NOT_TRIGGERED (101번 이상의 원점복귀 모드를 수행할 때 Touch Probe가 정상적으로 Trigger되지 않은 경우.)";
                case -21080: return "eaERR_HOME_STEP_TIMEOUT0 (Touch Probe 셋팅이 제한시간내에 완료되지 않은 경우)";
                // 이 중간의에러코드는 HOME_STEP 번호에 따라서 매겨지므로 따로 정의하지 말것 //
                case -21099: return "eaERR_HOME_STEP_TIMEOUT19 (Touch Probe 셋팅이 제한시간내에 완료되지 않은 경우)";
                case -21110: return "eaERR_LM_QUE_FULL (리스트모션의 커맨드 큐가 꽉차서 커맨드를 등록하지 못한 경우)";
                case -21130: return "eaERR_PTM_QUE_FULL (PT모션의 커맨드 큐가 꽉차서 커맨드를 등록하지 못한 경우.)";
                case -21131: return "eaERR_PTM_MAP_DISABLED (PT모션 맵이 Begin(ecmLmCtl_Begin() 함수를 통해서 실행됨)되지 않은 상태에서 PT모션 관련 함수들을 실행한 경우.)";
                case -21150: return "eaERR_INAVLID_PDO_MAP (현재의 PDO Mapping에서 지원되지 않는 기능을 사용하려고 하는 경우)";


                //SW EtherCAT Only
                case -50001: return "secERR_NULL_FILENAME (파일 메모리 포인터가 NULL 인 경우)";
                case -50002: return "secERR_NULL_ECATMAINTASK (EcatCheckProc 쓰레드 생성 실패한 경우)";
                case -50003: return "secERR_NULL_ECATCHECKPROC (EcatCheckProc 쓰레드 생성 실패한 경우)";
                case -50004: return "secERR_NONE_NETADAPTER	(Network Adapter가 발견되지 않은 경우)";
                case -50005: return "secERR_NOT_OP_ALLSLAVE	(일부 또는 전체 Slave가 OP 상태에 있지 않는 경우)";

                case -50006: return "secERR_NULL_BUFFER	(버퍼가 NULL인 경우)";
                case -50007: return "secERR_EEPROM_READ	(EEPROM Read 실패한 경우)";
                case -50008: return "secERR_EEPROM_WRITE (EEPROM Write 실패한 경우)";
                case -50009: return "secERR_EEPROM_FILE	(EEPROM File 읽기가 실패한 경우)";
                case -50010: return "secERR_INVALID_EEPROM_RW_MODE	 지원되지 않는 EEPROM Read/Write Mode 요청시)";

                case -50011: return "secERR_OVERSIZE_FIRMWARE (펌웨어 크기가 너무 큰 경우)";
                case -50012: return "secERR_FOE_WRITE (FOE Write 실패한 경우)";
                case -50013: return "secERR_FIRMWARE_FILE (Firmware 파일 읽기가 실패한 경우)";
                case -50014: return "secERR_TIMEOUT_BOOTMODE (BOOT 모드로 요청에 대해 Timeout된 경우)";

                case -50015: return "secERR_SDO_READ (SDO Read 실패시)";
                case -50016: return "secERR_SDO_READ_TIMEOUT (SDO Read Timeout)";
                case -50017: return "secERR_SDO_WRITE (SDO Write 실패시)";
                case -50018: return "secERR_SDO_WRITE_TIMEOUT (SDO Write Timeout)";
                case -50019: return "secERR_NOT_SUPPORTED_DEVICE (지원되지 않는 Device)";

                case -50020: return "secERR_NET_CMD_SCAN (Scan Request 실패시)";
                case -50021: return "secERR_NET_CMD_SCAN_TIMEOUT (Scan Response Timeout)";
                case -50022: return "secERR_SLV_CONFIG_CHANGED (Scan 한 Slave와 Configuration 파일의 정보가 일치하지 않는 경우)";
                default: return "UnKnown Error Occured";
            }
        }

        //====================== NET INTERFACE FUNCTIONS =========================================================//


        //EC_EXTERN t_bool	(CECAT_API *ecNet_IsBootCompt) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_IsBootCompt(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int errCode);

        //EC_EXTERN t_i32		(CECAT_API *ecNet_GetDevIdx) (t_i32 NetID);
        [DllImport(dll)]
        public static extern unsafe int ecNet_GetDevIdx(
            [MarshalAs(UnmanagedType.I4)] int NetID);

        //EC_EXTERN t_i32		(CECAT_API *ecNet_GetLocNetIdx) (t_i32 NetID);
        [DllImport(dll)]
        public static extern unsafe int ecNet_GetLocNetIdx(
            [MarshalAs(UnmanagedType.I4)] int NetID);

        //EC_EXTERN t_success (CECAT_API *ecNet_GetVerInfo) (t_i32 NetID, TEcFileVerInfo_SDK *pVerInfo_SDK, TEcFileVerInfo_WDM *pVerInfo_WDM, TEcFileVerInfo_FW *pVerInfo_FW, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_GetVerInfo(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            ref TEcFileVerInfo_SDK pVerInfo_SDK, 
            ref TEcFileVerInfo_WDM pVerInfo_WDM, 
            ref TEcFileVerInfo_FW pVerInfo_FW, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui32	(CECAT_API *ecNet_ScanSlaves) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecNet_ScanSlaves(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui32	(CECAT_API *ecNet_GetCfgSlaveCount) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecNet_GetCfgSlaveCount(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_SetCfgSlaveCount) (t_i32 NetID, t_ui32 SlaveCount, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_SetCfgSlaveCount(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint SlaveCount, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecNet_SetAlState) (t_i32 NetID, EEcAlState AlState, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecNet_SetAlState(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            EEcAlState AlState, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecNet_SetAlState_FF) (t_i32 NetID, EEcAlState AlState, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecNet_SetAlState_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            EEcAlState AlState, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN EEcAlState	(CECAT_API *ecNet_GetAlState) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe EEcAlState ecNet_GetAlState(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_bool	(CECAT_API *ecNet_SlvComErrSum_GetEnable) (t_i32 NetID, int *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_SlvComErrSum_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecNet_SlvComErrSum_SetEnable) (t_i32 NetID, t_bool IsEnable, int *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_SlvComErrSum_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I1)] bool isEnable, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecNet_SlvComErrSum_ClearAll) (t_i32 NetID, int *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_SlvComErrSum_ClearAll(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        //====================== SLAVE I/F FUNCTIONS ============================================================//

        //EC_EXTERN t_i32			(CECAT_API *ecSlv_SlvIdx2PhysAddr) (t_i32 NetID, t_ui16 SlaveIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_SlvIdx2PhysAddr(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlaveIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecSlv_PhysAddr2SlvIdx) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_PhysAddr2SlvIdx(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecSlv_GetProdInfo_A) (t_i32 NetID, t_i32 SlaveIndex, TEcSlvProdInfo *pProdInfoBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_GetProdInfo_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIndex, 
            ref TEcSlvProdInfo pProdInfoBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecSlv_GetProdInfo) (t_i32 NetID, t_i32 SlvPhysAddr, TEcSlvProdInfo *pProdInfoBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_GetProdInfo(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr, 
            ref TEcSlvProdInfo pProdInfoBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecSlv_GetTypeInfo) (t_i32 NetID, t_ui16 SlvPhysAddr, TEcSlvTypeInfo *pTypeInfoBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_GetTypeInfo(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr, 
            ref TEcSlvTypeInfo pTypeInfoBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecSlv_GetTypeInfo_A) (t_i32 NetID, t_i32 SlaveIndex, TEcSlvTypeInfo *pTypeInfoBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_GetTypeInfo_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIndex, 
            ref TEcSlvTypeInfo pTypeInfoBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui8		(CECAT_API *ecSlv_GetAlState) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe EEcAlState ecSlv_GetAlState(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui8		(CECAT_API *ecSlv_GetAlState_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe EEcAlState ecSlv_GetAlState_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecSlv_ReadReg) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 RegAddr, t_i32 DataSize, _out void *pBuf, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_ReadReg(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int RegAddr, 
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecSlv_ReadReg_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 RegAddr, t_i32 DataSize, _out void *pBuf, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_ReadReg_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx, 
            [MarshalAs(UnmanagedType.I4)] int RegAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteReg) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 RegAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteReg(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr, 
            [MarshalAs(UnmanagedType.I4)] int RegAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteReg_FF) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 RegAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteReg_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int RegAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteReg_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 RegAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteReg_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx, 
            [MarshalAs(UnmanagedType.I4)] int RegAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        
        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteReg_A_FF) (t_i32 NetID, t_i32 SlaveIdx, t_i32 RegAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteReg_A_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int RegAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            ref IntPtr pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecSlv_ReadCoeSdo) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pBuf, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_ReadCoeSdo(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Index, 
            [MarshalAs(UnmanagedType.I4)] int SubIdx, 
            [MarshalAs(UnmanagedType.I4)] int IsComptAccess,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecSlv_ReadCoeSdo_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pBuf, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_ReadCoeSdo_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx, 
            [MarshalAs(UnmanagedType.I4)] int Index, 
            [MarshalAs(UnmanagedType.I4)] int SubIdx,
            [MarshalAs(UnmanagedType.I4)] int IsComptAccess,
            [MarshalAs(UnmanagedType.I4)] int DataSize, 
            [MarshalAs(UnmanagedType.I4)] ref int pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecSlv_ReadCoeSdo_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pBuf, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecSlv_ReadCoeSdo_A")]
        public static extern unsafe int ecSlv_ReadCoeSdo_A_IntPtr(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int Index,
            [MarshalAs(UnmanagedType.I4)] int SubIdx,
            [MarshalAs(UnmanagedType.I4)] int IsComptAccess,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            ref IntPtr pBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteCoeSdo) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteCoeSdo(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr, 
            [MarshalAs(UnmanagedType.I4)] int Index,
            [MarshalAs(UnmanagedType.I4)] int SubIdx,
            [MarshalAs(UnmanagedType.I4)] int IsComptAccess,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pData,  
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteCoeSdo_FF) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteCoeSdo_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Index, 
            [MarshalAs(UnmanagedType.I4)] int SubIdx,
            [MarshalAs(UnmanagedType.I4)] int IsComptAccess,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            ref IntPtr pData,  
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteCoeSdo_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteCoeSdo_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx, 
            [MarshalAs(UnmanagedType.I4)] int Index, 
            [MarshalAs(UnmanagedType.I4)] int SubIdx, 
            [MarshalAs(UnmanagedType.I4)] int IsComptAccess, 
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pData,  
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteCoeSdo_A_FF) (t_i32 NetID, t_i32 SlaveIdx, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteCoeSdo_A_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int Index, 
            [MarshalAs(UnmanagedType.I4)] int SubIdx, 
            [MarshalAs(UnmanagedType.I4)] int IsComptAccess,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            ref IntPtr pData,  
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecSlv_GetComErrSum_A) (t_i32 NetID, t_ui16 SlaveIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_GetComErrSum_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort slaveIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui16		(CECAT_API *ecSlv_GetComErrSum) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe ushort ecSlv_GetComErrSum(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecSlv_ClearComErrSum_A) (t_i32 NetID, t_i32 SlaveIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_ClearComErrSum_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui16		(CECAT_API *ecSlv_ClearComErrSum) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe ushort ecSlv_ClearComErrSum(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        ////====================== Digital Input FUNCTIONS =======================================================//
        
        
        //--------------- Global Channel을 이용하는 함수군 ----------------------------------------------//

        //EC_EXTERN t_i32		(CECAT_API *ecdiGetSlaveIndex) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecdiGetSlaveIndex(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint DiChannel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecdiGetSlaveID) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecdiGetSlaveID(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecdiGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecdiGetNumChannels(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecdiGetOne) (t_i32 NetID, t_ui32 DiChannel, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiGetOne(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword	(CECAT_API *ecdiGetMulti) (t_i32 NetID, t_ui32 IniChannel, t_ui8 NumChannels, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecdiGetMulti(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint IniChannel,
            [MarshalAs(UnmanagedType.U1)] byte NumChannels, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword		(CECAT_API *ecdiGetLogicAddr) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecdiGetLogicAddr(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_success		(CECAT_API *ecdiLtc_AddChannel) (t_i32 NetID, t_ui16 DiChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_AddChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecdiLtc_DelChannel) (t_i32 NetID, t_ui16 DiChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_DelChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecdiLtc_SetFilter) (t_i32 NetID, t_ui16 DiChannel, t_i32 FilterCycles, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_SetFilter(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort DiChannel,
            [MarshalAs(UnmanagedType.I4)] int FilterCycles,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecdiLtc_GetFilter) (t_i32 NetID, t_ui16 DiChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecdiLtc_GetFilter(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecdiLtc_SetLogicInvert) (t_i32 NetID, t_ui16 DiChannel, t_bool IsInvertLogic, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_SetLogicInvert(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort DiChannel,
            [MarshalAs(UnmanagedType.I1)] bool IsInvertLogic,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_bool		(CECAT_API *ecdiLtc_GetLogicInvert) (t_i32 NetID, t_ui16 DiChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_GetLogicInvert(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecdiLtc_GetOnCount) (t_i32 NetID, t_ui16 DiChannel, t_bool IsResetOnCount, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecdiLtc_GetOnCount(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort DiChannel,
            [MarshalAs(UnmanagedType.I1)] bool IsResetOnCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecdiLtc_ResetOnCount) (t_i32 NetID, t_ui16 DiChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_ResetOnCount(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //--------------- Slave Address와 Local Channel을 이용하는 함수군 ------------------------------//

        //EC_EXTERN t_bool		(CECAT_API *ecdiGetOne_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiGetOne_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword		(CECAT_API *ecdiGetMulti_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui32 IniLocalChannel, t_ui8 NumChannels, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecdiGetMulti_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U4)] uint IniLocalChannel,
            [MarshalAs(UnmanagedType.U1)] byte NumChannels,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success		(CECAT_API *ecdiLtc_AddChannel_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_AddChannel_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecdiLtc_DelChannel_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_DelChannel_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecdiLtc_SetFilter_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 FilterCycles, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_SetFilter_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I4)] int FilterCycles,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecdiLtc_GetFilter_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecdiLtc_GetFilter_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecdiLtc_SetLogicInvert_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_bool IsInvertLogic, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_SetLogicInvert_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I1)] bool IsInvertLogic,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool		(CECAT_API *ecdiLtc_GetLogicInvert_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_GetLogicInvert_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecdiLtc_GetOnCount_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_bool IsResetOnCount, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecdiLtc_GetOnCount_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I1)] bool IsResetOnCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecdiLtc_ResetOnCount_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiLtc_ResetOnCount_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        //--------------- 논리비트주소(Logic Bit Address) 변환 함수군 ------------------------------//

        //EC_EXTERN t_dword		(CECAT_API *ecdiLogBitAddr_FromGlobalChannel) (t_i32 NetID, t_i32 GlobalChannel, t_i32 *ErrCode); 
        // Global Input Channel을 논리비트주소로 변환 
        [DllImport(dll)]
        public static extern unsafe uint ecdiLogBitAddr_FromGlobalChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int GlobalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword		(CECAT_API *ecdiLogBitAddr_FromLocalChannel) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode); 
        // Local Input Channel을 논리비트주소로 변환 
        [DllImport(dll)]
        public static extern unsafe uint ecdiLogBitAddr_FromLocalChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword		(CECAT_API *ecdiLogBitAddr_FromOnboardChannel) (t_i32 NetID, t_i32 OnboardChannel, t_i32 *ErrCode); 
        // Onboard Input Channel을 논리비트주소로 변환
        [DllImport(dll)]
        public static extern unsafe uint ecdiLogBitAddr_FromOnboardChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int OnboardChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecdiLogBitAddr_ToGlobalChannel) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode); 
        // 논리비트주소를 Global Input Channel로 변환
        [DllImport(dll)]
        public static extern unsafe int ecdiLogBitAddr_ToGlobalChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecdiLogBitAddr_ToLocalChannel) (t_i32 NetID, t_dword LogBitAddr, t_ui16 *SlvPhysAddr, t_i32 *ErrCode); 
        // 논리비트주소를 Local Input Channel로 변환
        [DllImport(dll)]
        public static extern unsafe int ecdiLogBitAddr_ToLocalChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.U2)] ref ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecdiLogBitAddr_ToOnboardChannel) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode);
        // 논리비트주소를 Onboard Input Channel로 변환
        [DllImport(dll)]
        public static extern unsafe int ecdiLogBitAddr_ToOnboardChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN EEcIoChanType (CECAT_API *ecdiLogBitAddr_GetChanType) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe EEcIoChanType ecdiLogBitAddr_GetChanType(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        ////====================== Digital Output FUNCTIONS =======================================================//


        //--------------- Global Channel을 이용하는 함수군 ----------------------------------------------//

        //EC_EXTERN t_i32		(CECAT_API *ecdoGetSlaveIndex) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecdoGetSlaveIndex(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecdoGetSlaveID) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecdoGetSlaveID(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecdoGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecdoGetNumChannels(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecdoPutOne) (t_i32 NetID, t_ui32 DoChannel, t_bool OutState, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdoPutOne(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint DoChannel,
            [MarshalAs(UnmanagedType.I1)] bool OutState,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecdoPutMulti) (t_i32 NetID, t_ui32 IniChannel, t_ui8 NumChannels, t_dword dwOutStates, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdoPutMulti(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint IniChannel,
            [MarshalAs(UnmanagedType.U1)] byte NumChannels,
            [MarshalAs(UnmanagedType.U4)] uint dwOutStates,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecdoGetOne) (t_i32 NetID, t_ui32 DoChannel, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdoGetOne(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint DoChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword	(CECAT_API *ecdoGetMulti) (t_i32 NetID, t_ui32 IniChannel, t_ui8 NumChannels, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecdoGetMulti(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint IniChannel,
            [MarshalAs(UnmanagedType.U1)] byte NumChannels,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        
        //--------------- Slave Address와 Local Channel을 이용하는 함수군 ------------------------------//
        
        //EC_EXTERN t_success		(CECAT_API *ecdoPutOne_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_bool OutState, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdoPutOne_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I1)] bool OutState,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecdoPutMulti_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui32 IniLocalChannel, t_ui8 NumChannels, t_dword dwOutStates, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdoPutMulti_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U4)] uint IniLocalChannel,
            [MarshalAs(UnmanagedType.U1)] byte NumChannels,
            [MarshalAs(UnmanagedType.U4)] uint dwOutStates,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool		(CECAT_API *ecdoGetOne_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdoGetOne_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U4)] uint LocalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //_EXTERN t_dword		(CECAT_API *ecdoGetMulti_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui32 IniLocalChannel, t_ui8 NumChannels, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecdoGetMulti_L(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U4)] uint IniLocalChannel,
            [MarshalAs(UnmanagedType.U1)] byte NumChannels,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //--------------- 논리비트주소(Logic Bit Address) 변환 함수군 ------------------------------//

        //EC_EXTERN t_dword		(CECAT_API *ecdoLogBitAddr_FromGlobalChannel) (t_i32 NetID, t_i32 GlobalChannel, t_i32 *ErrCode); 
        // Global Ouput Channel을 논리비트주소로 변환 
        [DllImport(dll)]
        public static extern unsafe uint ecdoLogBitAddr_FromGlobalChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int GlobalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword		(CECAT_API *ecdoLogBitAddr_FromLocalChannel) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode); 
        // Local Output Channel을 논리비트주소로 변환 
        [DllImport(dll)]
        public static extern unsafe uint ecdoLogBitAddr_FromLocalChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int LocalChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword		(CECAT_API *ecdoLogBitAddr_FromOnboardChannel) (t_i32 NetID, int OnboardChannel, t_i32 *ErrCode);
        // Onboard Output Channel을 논리비트주소로 변환
        [DllImport(dll)]
        public static extern unsafe uint ecdoLogBitAddr_FromOnboardChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int OnboardChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecdoLogBitAddr_ToGlobalChannel) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode); 
        // 논리비트주소를 Global Output Channel로 변환
        [DllImport(dll)]
        public static extern unsafe int ecdoLogBitAddr_ToGlobalChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecdoLogBitAddr_ToLocalChannel) (t_i32 NetID, t_dword LogBitAddr, t_ui16 *SlvPhysAddr, t_i32 *ErrCode); 
        // 논리비트주소를 Global Output Channel로 변환
        [DllImport(dll)]
        public static extern unsafe int ecdoLogBitAddr_ToLocalChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.U2)] ref ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecdoLogBitAddr_ToOnboardChannel) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode); 
        // 논리비트주소를 Onboard Output Channel로 변환
        [DllImport(dll)]
        public static extern unsafe int ecdoLogBitAddr_ToOnboardChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN EEcIoChanType (CECAT_API *ecdoLogBitAddr_GetChanType) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe EEcIoChanType ecdoLogBitAddr_GetChanType(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        ////====================== Analog Input FUNCTIONS =======================================================//

        //EC_EXTERN t_i32		(CECAT_API *ecaiGetSlaveIndex) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecaiGetSlaveIndex(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaiGetSlaveID) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecaiGetSlaveID(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaiGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecaiGetNumChannels(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaiGetChanVal_I) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecaiGetChanVal_I(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecaiGetChanVal_F) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecaiGetChanVal_F(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecaiGetChanVal_FS) (t_i32 NetID, t_ui32 Channel, t_f32 ScaleMin, t_f32 ScaleMax, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecaiGetChanVal_FS(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.R4)] float ScaleMin,
            [MarshalAs(UnmanagedType.R4)] float ScaleMax, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        ////EC_EXTERN t_i32		(CECAT_API *ecaiL_GetChanVal_I) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        //[DllImport(dll)]
        //public static extern unsafe int ecaiL_GetChanVal_I(
        //    [MarshalAs(UnmanagedType.I4)] int NetID, 
        //    [MarshalAs(UnmanagedType.U4)] uint Channel,
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        ////EC_EXTERN t_f64		(CECAT_API *ecaiL_GetChanVal_F) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        //[DllImport(dll)]
        //public static extern unsafe double ecaiL_GetChanVal_F(
        //    [MarshalAs(UnmanagedType.I4)] int NetID,
        //    [MarshalAs(UnmanagedType.U4)] uint Channel,
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        ////EC_EXTERN t_f64		(CECAT_API *ecaiL_GetChanVal_FS) (t_i32 NetID, t_ui32 Channel, t_f32 ScaleMin, t_f32 ScaleMax, _out t_i32 *ErrCode);
        //[DllImport(dll)]
        //public static extern unsafe double ecaiL_GetChanVal_FS(
        //    [MarshalAs(UnmanagedType.I4)] int NetID, 
        //    [MarshalAs(UnmanagedType.U4)] uint Channel, 
        //    [MarshalAs(UnmanagedType.R4)] float ScaleMin, 
        //    [MarshalAs(UnmanagedType.R4)] float ScaleMax,
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        ////====================== Analog Output FUNCTIONS =======================================================//

        //EC_EXTERN t_i32		(CECAT_API *ecaoGetSlaveIndex) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecaoGetSlaveIndex(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaoGetSlaveID) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecaoGetSlaveID(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaoGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecaoGetNumChannels(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecaoSetChanVal_I) (t_i32 NetID, t_ui32 Channel, t_i32 OutData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecaoSetChanVal_I(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] int OutData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecaoSetChanVal_F) (t_ecmSxCfg_SetMioPropi32 NetID, t_ui32 Channel, t_f64 OutData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecaoSetChanVal_F(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.R8)] double OutData, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecaoSetChanVal_FS) (t_i32 NetID, t_ui32 Channel, t_f64 OutData, t_f64 ScaleMin, t_f64 ScaleMax, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecaoSetChanVal_FS(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel,
            [MarshalAs(UnmanagedType.R8)] double outData,
            [MarshalAs(UnmanagedType.R8)] double ScaleMin,
            [MarshalAs(UnmanagedType.R8)] double ScaleMax,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaoGetOutValue_I) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecaoGetOutValue_I(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecaoGetOutValue_F) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecaoGetOutValue_F(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecaoGetOutValue_FS) (t_i32 NetID, t_ui32 Channel, t_f64 ScaleMin, t_f64 ScaleMax, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecaoGetOutValue_FS(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel,
            [MarshalAs(UnmanagedType.R8)] double ScaleMin,
            [MarshalAs(UnmanagedType.R8)] double ScaleMax, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        



        ////====================== MOTION - GENEAL FUNCTIONS =======================================================//

        //EC_EXTERN t_i32		(CECAT_API *ecmGn_GetAxisList) (t_i32 NetID, t_ui8 AxisListBuf[], t_ui8 AxisListBufSize, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmGn_GetAxisList(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.U1)] byte[] AxisListBuf, 
            [MarshalAs(UnmanagedType.U1)] byte AxisListBufSize, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN TEcmInPDO_Header* (CECAT_API *ecmGn_GetInPDOHeader) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe TEcmInPDO_Header ecmGn_GetInPDOHeader(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmGn_AxisToSlaveIndex) (t_i32 NetID, int Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmGn_AxisToSlaveIndex(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmGn_AxisToSlaveID) (t_i32 NetID, int Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmGn_AxisToSlaveID(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmGn_SlaveIndexToAxis) (t_i32 NetID, int SlaveIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmGn_SlaveIndexToAxis(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmGn_SlaveIDToAxis) (t_i32 NetID, int SlaveID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmGn_SlaveIDToAxis(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmGn_InitFromFile) (t_i32 NetID, t_i32 AxisCnt, char *szMotCfgFile, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecmGn_InitFromFile")]
        public static extern unsafe int ecmGn_InitFromFile(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int AxisCount,
            //[MarshalAs(UnmanagedType.LPWStr)] string szMotCfgFile,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szMotCfgFile,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //------ Hardware Emergency Stop --------------------------------------------------------//

        //EC_EXTERN t_success	(CECAT_API *ecmHEMG_SetInputEnv) (t_i32 NetID, t_dword LogBitAddr, t_bool InvertLogic, t_i32 FilterCount, t_i32 *ErrCode); 
        // Hardware EMG Stop 입력 신호에 대한 환경을 설정한다(단일 입력인 경우)
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHEMG_SetInputEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.I1)] bool InvertLogic,
            [MarshalAs(UnmanagedType.I4)] int FilterCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmHEMG_GetInputEnv) (t_i32 NetID, t_dword *LogBitAddr, t_bool *InvertLogic, t_i32 *FilterCount, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHEMG_GetInputEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] ref uint LogBitAddr,
            [MarshalAs(UnmanagedType.I1)] ref bool InvertLogic,
            [MarshalAs(UnmanagedType.I4)] ref int FilterCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmHEMG_SetInputEnv_Multi) (t_i32 NetID, t_i32 NumInputs, TEcmEmgInputEnv *pInputList, t_i32 FilterCount, t_i32 *ErrCode); 
        // Hardware EMG Stop 입력 신호에 대한 환경을 설정한다(복수 입력인 경우)
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHEMG_SetInputEnv_Multi(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int NumInputs,
            TEcmEmgInputEnv[] TEcmEmgInputEnv,
            [MarshalAs(UnmanagedType.I4)] int FilterCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmHEMG_GetInputEnv_Multi) (t_i32 NetID, t_i32 MaxNumInputsToCopy, TEcmEmgInputEnv *pInputListBuf, t_i32 *FilterCount, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmHEMG_GetInputEnv_Multi(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MaxNumInputsToCopy,
            //ref TEcmEmgInputEnv[] pInputListBuf,
            IntPtr startPosition,
            [MarshalAs(UnmanagedType.I4)] ref int FilterCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmHEMG_GetNumInputs) (t_i32 NetID, t_i32 *ErrCode); 
        // 'Hardware EMG Stop' 신호로 사용자가 등록한 입력 신호의 갯수를 반환한다.
        [DllImport(dll)]
        public static extern unsafe int ecmHEMG_GetNumInputs(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmHEMG_SetStopMode) (t_i32 NetID, t_bool IsDecelStop, t_i32 *ErrCode); 
        // 'Hardware EMG Stop' 신호가 ON되었을 때 모터를 정지하는 방식을 설정한다(즉시정지 또는 감속정지)
        [DllImport(dll)]
        [return:MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHEMG_SetStopMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I1)] bool IsDecelStop,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmHEMG_GetStopMode) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHEMG_GetStopMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmHEMG_SetEnable) (t_i32 NetID, t_bool IsEnable, t_i32 *ErrCode); 
        //  'Hardware EMG Stop' 입력을 활성화/비활성화 시킨다
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHEMG_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I1)] bool IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmHEMG_GetEnable) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHEMG_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmHEMG_GetState) (t_i32 NetID, t_i32 *ErrCode); 
        // 'Hardware EMG Stop' 입력의 동작 상태를 반환한다. 0-OFF, 1-ON
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHEMG_GetState(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        //------ Software Emergnecy Stop --------------------------------------------------------//

        //EC_EXTERN t_success	(CECAT_API *ecmSEMG_SetStopMode) (t_i32 NetID, t_bool IsDecelStop, t_i32 *ErrCode); 
        // 'Software EMG Stop' 신호가 ON되었을 때 모터를 정지하는 방식을 설정한다(즉시정지 또는 감속정지)
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSEMG_SetStopMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I1)] bool IsDecelStop,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSEMG_GetStopMode) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSEMG_GetStopMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSEMG_SetState) (t_i32 NetID, t_bool State, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSEMG_SetState(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I1)] bool State,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSEMG_GetState) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSEMG_GetState(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        //------ Collision Avoidance (CollA) ----------------------------------------------------//

        //EC_EXTERN t_success	(CECAT_API *ecmCollA_SetEnv) (t_i32 NetID, t_i32 CollAIdx, t_i32 MasterAxis, t_i32 SlvAxis, t_i32 SubOrAdd, t_i32 LessOrGreater, t_f64 Limit, t_i32 *ErrCode); // CollA의 환경을 설정한다.
        [DllImport(dll, EntryPoint = "ecmCollA_SetEnv")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmCollA_SetEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int CollAIdx,
            [MarshalAs(UnmanagedType.I4)] int MasterAxis,
            [MarshalAs(UnmanagedType.I4)] int SlvAxis,
            [MarshalAs(UnmanagedType.I4)] int SubOrAdd,
            [MarshalAs(UnmanagedType.I4)] int LessOrGreater,
            [MarshalAs(UnmanagedType.R8)] double Limit,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmCollA_GetEnv) (t_i32 NetID, t_i32 CollAIdx, t_i32* MasterAxis, t_i32* SlvAxis, t_i32* SubOrAdd, t_i32* LessOrGreater, t_f64* Limit, t_i32 *ErrCode); // CollA의 환경 설정값을 읽는다.
        [DllImport(dll, EntryPoint = "ecmCollA_GetEnv")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmCollA_GetEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int CollAIdx,
            [MarshalAs(UnmanagedType.I4)] ref int MasterAxis,
            [MarshalAs(UnmanagedType.I4)] ref int SlvAxis,
            [MarshalAs(UnmanagedType.I4)] ref int SubOrAdd,
            [MarshalAs(UnmanagedType.I4)] ref int LessOrGreater,
            [MarshalAs(UnmanagedType.R8)] ref double Limit,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmCollA_SetEnable) (t_i32 NetID, t_i32 CollAIdx, t_bool IsEnable, t_i32 *ErrCode); // CollA 기능을 활성화 또는 비활성화한다.
        [DllImport(dll, EntryPoint = "ecmCollA_SetEnable")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmCollA_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int CollAIdx,
            [MarshalAs(UnmanagedType.I1)] bool isEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmCollA_GetEnable) (t_i32 NetID, t_i32 CollAIdx, t_i32 *ErrCode); // CollA 기능의 활성화 여부를 반환한다. 
        [DllImport(dll, EntryPoint = "ecmCollA_GetEnable")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmCollA_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int CollAIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //t_success ecmCollA_SetStopMode (t_i32 NetID, t_i32 CollAIdx, t_bool IsDecelStop_M, t_bool IsDecelStop_S, t_i32 *ErrCode); // CollA의 Stop Mode를 설정한다.
        [DllImport(dll, EntryPoint = "ecmCollA_SetStopMode")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmCollA_SetStopMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int CollAIdx,
            [MarshalAs(UnmanagedType.I1)] bool IsDecelStop_M,
            [MarshalAs(UnmanagedType.I1)] bool IsDecelStop_S,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //t_success ecmCollA_GetStopMode (t_i32 NetID, t_i32 CollAIdx, t_bool* IsDecelStop_M, t_bool* IsDecelStop_S, t_i32 *ErrCode); // CollA의 Stop Mode 설정값을 읽는다.
        [DllImport(dll, EntryPoint = "ecmCollA_GetStopMode")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmCollA_GetStopMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int CollAIdx,
            [MarshalAs(UnmanagedType.I1)] ref bool IsDecelStop_M,
            [MarshalAs(UnmanagedType.I1)] ref bool IsDecelStop_S,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        //*****************************************************************************************************************************
        //*
        //*							Functions for Advanced Users
        //*
        //*****************************************************************************************************************************


        ////====================== DEBUG LOGGING FUNCTIONS =========================================================//
        //EC_EXTERN t_success (CECAT_API *ecDlog_SetFilePath) (char* szLogFilePath, t_i32 *ErrCode);
        [DllImport(dll, CharSet = CharSet.Unicode, BestFitMapping = false)]
        [return: MarshalAs(UnmanagedType.I1)]
        //public static extern unsafe bool ecDlog_SetFilePath( [MarshalAs(UnmanagedType.LPStr)] ref string szLogFilePath, [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        public static extern unsafe bool ecDlog_SetFilePath(
            [MarshalAs(UnmanagedType.LPStr)] string szLogFilePath,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecDlog_GetFilePath) (char *pszLogFilePath, t_i32 BufLen, t_i32 *ErrCode);
        [DllImport(dll, CharSet = CharSet.Unicode, BestFitMapping = false)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecDlog_GetFilePath(
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] filePath, 
            [MarshalAs(UnmanagedType.I4)] int BufLen, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecDlog_SetLogType) (int DebugLogType, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecDlog_SetLogType(
            [MarshalAs(UnmanagedType.I4)] int LogType, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN int		(CECAT_API *ecDlog_GetLogType) (void);
        [DllImport(dll)]
        public static extern unsafe int ecDlog_GetLogType();

        //EC_EXTERN int		(CECAT_API *ecDlog_GetLogType) (t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecDlog_GetLogType(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecDlog_SetLogLevel) (int DebugLogLevel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecDlog_SetLogLevel(
            [MarshalAs(UnmanagedType.I4)] int logLevel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN int		(CECAT_API *ecDlog_GetLogLevel) (void);
        [DllImport(dll)]
        public static extern unsafe int ecDlog_GetLogLevel();

        //EC_EXTERN int		(CECAT_API *ecDlog_GetLogLevel) (t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecDlog_GetLogLevel(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecDlog_SetLogMemSize) (int SizeKB, int *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecDlog_SetLogMemSize(
            [MarshalAs(UnmanagedType.I4)] int SizeKB,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui32	(CECAT_API *ecDlog_GetLogMemSize) (t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecDlog_GetLogMemSize(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecDlog_DumpMemoryLog) (int *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecDlog_DumpMemoryLog(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecDlog_DumpMemoryLog2) (char* szFilePath, int *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecDlog_DumpMemoryLog2(
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szFilePath,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN char*		(CECAT_API *ecDlog_GetLastDumpFilePath) (t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.LPStr)]
        public static extern unsafe string ecDlog_GetLastDumpFilePath(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecDlog_GetMemoryLogSts) (ULONGLONG *pBufSize, ULONGLONG *pWriteCount,  t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecDlog_GetMemoryLogSts(
            [MarshalAs(UnmanagedType.U8)] ref ulong pBufSize,
            [MarshalAs(UnmanagedType.U8)] ref ulong pWriteCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        

        //====================== MOTION - Motor Performance Monitor(MPMon) FUNCTIONS ============================================//

        //EC_EXTERN t_success (CECAT_API *ecmMPMon_AddAxis) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMPMon_AddAxis(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmMPMon_DelAxis) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMPMon_DelAxis(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmMPMon_SetAxisEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMPMon_SetAxisEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] bool IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32	    (CECAT_API *ecmMPMon_GetAxisStatus) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmMPMon_GetAxisStatus(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN ComiEcatSdk	(CECAT_API *ecmMPMon_ResetAxisData) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMPMon_ResetAxisData(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmMPMon_ResetSectData) (t_i32 NetID, t_i32 Axis, t_ui16 SectIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMPMon_ResetSectData(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.U2)] ushort SectIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmMPMon_SetTorqThreshVal) (t_i32 NetID, t_i32 Axis, t_ui16 SectIdx, t_ui16 TorqThresholdVal, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMPMon_SetTorqThreshVal(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.U2)] ushort SectIdx, 
            [MarshalAs(UnmanagedType.U2)] ushort TorqThresholdVal,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui16	(CECAT_API *ecmMPMon_GetTorqThreshVal) (t_i32 NetID, t_i32 Axis, t_ui16 SectIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe ushort ecmMPMon_GetTorqThreshVal(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.U2)] ushort SectIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmMPMon_SetDevThreshVal) (t_i32 NetID, t_i32 Axis, t_ui16 SectIdx, t_ui32 DevThresholdVal, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMPMon_SetDevThreshVal(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.U2)] ushort SectIdx, 
            [MarshalAs(UnmanagedType.U4)] uint DevThresholdVal, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui32	(CECAT_API *ecmMPMon_GetDevThreshVal) (t_i32 NetID, t_i32 Axis, t_ui16 SectIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecmMPMon_GetDevThreshVal(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.U2)] ushort SectIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmMPMon_ReadAxisData) (t_i32 NetID, t_i32 Axis, TMPMonData *pBuffer, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMPMon_ReadAxisData(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            ref TMPMonData monData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmMPMon_WriteAxisData) (t_i32 NetID, t_i32 Axis, TMPMonData *pMPMonData, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMPMon_WriteAxisData(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            ref TMPMonData monData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        




        //*****************************************************************************************************************************
        //*
        //*							Functions for public System Users
        //*
        //*****************************************************************************************************************************




        ////====================== SLAVE I/F FUNCTIONS ============================================================//

        //EC_EXTERN t_i32		(CECAT_API *ecSlv_ReadEEPR) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 EeeprAddr, t_i32 DataSize, _out void  *pBuf, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_ReadEEPR(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr, 
            [MarshalAs(UnmanagedType.I4)] int EeeprAddr, 
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecSlv_ReadEEPR_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 EeeprAddr, t_i32 DataSize, _out void  *pBuf, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_ReadEEPR_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int EeeprAddr, 
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteEEPR) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 EeeprAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteEEPR(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int EeeprAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pData, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteEEPR_FF) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 EeeprAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteEEPR_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int EeeprAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize, 
            [MarshalAs(UnmanagedType.I4)] ref int pData, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteEEPR_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 EeeprAddr, t_i32 DataSize, void  *pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteEEPR_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx, 
            [MarshalAs(UnmanagedType.I4)] int EeeprAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pData, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecSlv_WriteEEPR_A_FF) (t_i32 NetID, t_i32 SlaveIdx, t_i32 EeeprAddr, t_i32 DataSize, void  *pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteEEPR_A_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int EeeprAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize, 
            [MarshalAs(UnmanagedType.I4)] ref int pData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecSlv_RenewCrcOfEEPR_A) (t_i32 NetID, t_ui16 SlaveIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_RenewCrcOfEEPR_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecSlv_RenewCrcOfEEPR) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_RenewCrcOfEEPR(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui16		(CECAT_API *ecSlv_ReadReg134ID_A) (t_i32 NetID, t_i32 SlaveIdx, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe ushort ecSlv_ReadReg134ID_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui16		(CECAT_API *ecSlv_ReadReg134ID) (t_i32 NetID, t_ui16 SlvPhysAddr, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe ushort ecSlv_ReadReg134ID(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecSlv_SetAlState_A) (t_i32 NetID, t_ui16 SlaveIdx, EEcAlState AlState, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecSlv_SetAlState_A")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_SetAlState_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            EEcAlState AlState,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        ////====================== MOTION - SINGLE AXIS FUNCTIONS ==================================================//

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetUnitDist) (t_i32 NetID, t_i32 Axis, t_f64 UnitDist, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_SetUnitDist(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] double UnitDist, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_GetUnitDist) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmSxCfg_GetUnitDist(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetUnitSpeed) (t_i32 NetID, t_i32 Axis, t_f64 UnitSpeed, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_SetUnitSpeed(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double UnitSpeed, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_GetUnitSpeed) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmSxCfg_GetUnitSpeed(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetMioProp) (t_i32 NetID, t_i32 Axis, EEcmMioPropId PropId, t_i32 PropVal, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetMioProp(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            EEcmMioPropId PropId, 
            [MarshalAs(UnmanagedType.I4)] int PropVal, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_GetMioProp) (t_i32 NetID, t_i32 Axis, EEcmMioPropId PropId, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_GetMioProp(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            EEcmMioPropId PropId,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMastInp) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_f64
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_SetMastInp( 
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I1)] bool IsEnable,
            [MarshalAs(UnmanagedType.R8)] double inpositionRange,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_GetMastInp) (t_i32 NetID, t_i32 Axis, t_bool* IsEnable, t_f64*
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_GetMastInp(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I1)] ref bool IsEnable, 
            [MarshalAs(UnmanagedType.R8)] ref double inpositionRange,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMastInp_Cnt) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 InpRangeCnt, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecmSxCfg_SetMastInp_Cnt")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_SetMastInp_Cnt(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] bool IsEnable,
            [MarshalAs(UnmanagedType.I4)] int InpRangeCnt,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_GetMastInp_Cnt) (t_i32 NetID, t_i32 Axis, t_bool* IsEnable, t_i32* InpRangeCnt, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_GetMastInp_Cnt(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] ref bool IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int InpRangeCnt,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_GetSoftLimit) (t_i32 NetID, t_i32 Axis, BOOL* IsEnable, double* NegLimit, double* PosLimit, BOOL* IsDecelStop, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_GetSoftLimit(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int isEnable,
            [MarshalAs(UnmanagedType.R8)] ref double NegLimit, 
            [MarshalAs(UnmanagedType.R8)] ref double PosLimit, 
            [MarshalAs(UnmanagedType.I4)] ref int IsDecelStop, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetSoftLimit) (t_i32 NetID, t_i32 Axis, BOOL IsEnable, double NegLimit, double PosLimit, BOOL IsDecelStop, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetSoftLimit(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int isEnable, 
            [MarshalAs(UnmanagedType.R8)] double NegLimit,
            [MarshalAs(UnmanagedType.R8)] double PosLimit,
            [MarshalAs(UnmanagedType.I4)] int IsDecelStop,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetOperMode) (t_i32 NetID, t_i32 Axis, EEcmOperMode OperMode, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetOperMode(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            EEcmOperMode OperMode, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_GetOperMode) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_GetOperMode(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedPatt) (t_i32 NetID, t_i32 Axis, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 Acc, t_f64 Dec, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetSpeedPatt(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double VIni,
            [MarshalAs(UnmanagedType.R8)] double VEnd, 
            [MarshalAs(UnmanagedType.R8)] double VWork, 
            [MarshalAs(UnmanagedType.R8)] double Acc, 
            [MarshalAs(UnmanagedType.R8)] double Dec, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedPatt_FF) (t_i32 NetID, t_i32 Axis, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 Acc, t_f64 Dec, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetSpeedPatt_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double VIni,
            [MarshalAs(UnmanagedType.R8)] double VEnd, 
            [MarshalAs(UnmanagedType.R8)] double VWork, 
            [MarshalAs(UnmanagedType.R8)] double Acc,
            [MarshalAs(UnmanagedType.R8)] double Dec, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_GetSpeedPatt) (t_i32 NetID, t_i32 Axis, t_i32 *SpeedMode, t_f64 *VIni, t_f64 *VEnd, t_f64 *VWork, t_f64 *Acc, t_f64 *Dec, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_GetSpeedPatt(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] ref double VIni, 
            [MarshalAs(UnmanagedType.R8)] ref double VEnd, 
            [MarshalAs(UnmanagedType.R8)] ref double VWork, 
            [MarshalAs(UnmanagedType.R8)] ref double Acc, 
            [MarshalAs(UnmanagedType.R8)] ref double Dec, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedPatt_Time) (t_i32 NetID, t_i32 Axis, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 AccTime, t_f64 DecTime, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetSpeedPatt_Time(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double VIni,
            [MarshalAs(UnmanagedType.R8)] double VEnd, 
            [MarshalAs(UnmanagedType.R8)] double VWork,
            [MarshalAs(UnmanagedType.R8)] double AccTime, 
            [MarshalAs(UnmanagedType.R8)] double DecTime,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedPatt_Time_FF) (t_i32 NetID, t_i32 Axis, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 AccTime, t_f64 DecTime, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_SetSpeedPatt_Time_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double VIni,
            [MarshalAs(UnmanagedType.R8)] double VEnd,
            [MarshalAs(UnmanagedType.R8)] double VWork,
            [MarshalAs(UnmanagedType.R8)] double AccTime,
            [MarshalAs(UnmanagedType.R8)] double DecTime, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_GetSpeedPatt_Time) (t_i32 NetID, t_i32 Axis, t_i32 *SpeedMode, t_f64 *VIni, t_f64 *VEnd, t_f64 *VWork, t_f64 *AccTime, t_f64 *DecTime, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_GetSpeedPatt_Time(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] ref double VIni,
            [MarshalAs(UnmanagedType.R8)] ref double VEnd, 
            [MarshalAs(UnmanagedType.R8)] ref double VWork,
            [MarshalAs(UnmanagedType.R8)] ref double AccTime,
            [MarshalAs(UnmanagedType.R8)] ref double DecTime, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedRatio) (t_i32 NetID, t_i32 Axis, t_f64 SpeedRatio, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetSpeedRatio(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] double SpeedRatio, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *CECAT_API *ecmSxCfg_SetSpeedRatio_FF) (t_i32 NetID, t_i32 Axis, t_f64 SpeedRatio, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetSpeedRatio_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double SpeedRatio,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_GetSpeedRatio) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmSxCfg_GetSpeedRatio(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetJerkRatio) (t_i32 NetID, t_i32 Axis, t_f64 JerkTimeRatio, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetJerkRatio(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double JerkTimeRatio,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetJerkRatio_FF) (t_i32 NetID, t_i32 Axis, t_f64 JerkTimeRatio, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetJerkRatio_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] double JerkTimeRatio,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_GetJerkRatio) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmSxCfg_GetJerkRatio(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMinAccDecTime) (t_i32 NetID, t_i32 Axis, t_f64 MinAccTime, t_f64 MinDecTime, t_f64 LowLimitVel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_SetMinAccDecTime(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] double MinAccTime,
            [MarshalAs(UnmanagedType.R8)] double MinDecTime, 
            [MarshalAs(UnmanagedType.R8)] double LowLimitVel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_GetMinAccDecTime) (t_i32 NetID, t_i32 Axis, t_f64 *MinAccTime, t_f64 *MinDecTime, t_f64 *LowLimitVel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_GetMinAccDecTime(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] ref double MinAccTime, 
            [MarshalAs(UnmanagedType.R8)] ref double MinDecTime,
            [MarshalAs(UnmanagedType.R8)] ref double LowLimitVel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetTouchProbeFunc) (t_i32 NetID, t_i32 Axis, t_ui8 TouchProbeIndex, t_byte TouchProbeFuncVal, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetTouchProbeFunc(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.U1)] byte TouchProbeIndex, 
            [MarshalAs(UnmanagedType.U1)] byte TouchProbeFuncVal,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_byte	(CECAT_API *ecmSxCfg_GetTouchProbeFunc) (t_i32 NetID, t_i32 Axis, t_ui8 TouchProbeIndex, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe byte ecmSxCfg_GetTouchProbeFunc(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.U1)] byte TouchProbeIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSyncOtherEnv) (t_i32 NetID, t_i32 Axis, t_i32 SyncAxis, t_i32 SyncType, t_i32 PosSyncMethod, t_f64 SyncPosition, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetSyncOtherEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int SyncAxis,
            [MarshalAs(UnmanagedType.I4)] int SyncType,
            [MarshalAs(UnmanagedType.I4)] int PosSyncMethod, 
            [MarshalAs(UnmanagedType.R8)] double SyncPosition,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_GetSyncOtherEnv) (t_i32 NetID, t_i32 Axis, t_i32 *SyncAxis, t_i32 *SyncType, t_i32 *PosSyncMethod, t_f64 *SyncPosition, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_GetSyncOtherEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int SyncAxis, 
            [MarshalAs(UnmanagedType.I4)] ref int SyncType,
            [MarshalAs(UnmanagedType.I4)] ref int PosSyncMethod, 
            [MarshalAs(UnmanagedType.R8)] ref double SyncPosition,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSyncOtherEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_bool IsOneShot, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_SetSyncOtherEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] bool IsEnable, 
            [MarshalAs(UnmanagedType.I1)] bool IsOneShot, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_GetSyncOtherEnable) (t_i32 NetID, t_i32 Axis, t_bool* IsEnable, t_bool* IsOneShot, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_GetSyncOtherEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I1)] ref bool IsEnable, 
            [MarshalAs(UnmanagedType.I1)] ref bool IsOneShot,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr_SetTableSize) (t_i32 NetID, t_i32 Axis, t_i32 TableSize, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr_SetTableSize(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int TableSize, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_PosCorr_GetTableSize) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_PosCorr_GetTableSize(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr_SetTableData) (t_i32 NetID, t_i32 Axis, t_i32 TableIndex, t_f64 RefCmdPos, t_f64 ActMotorPos, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr_SetTableData(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int TableIndex,
            [MarshalAs(UnmanagedType.R8)] double RefCmdPos,
            [MarshalAs(UnmanagedType.R8)] double ActMotorPos,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr_GetTableData) (t_i32 NetID, t_i32 Axis, t_i32 TableIndex, t_f64* RefCmdPos, t_f64* ActMotorPos, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr_GetTableData(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int TableIndex, 
            [MarshalAs(UnmanagedType.R8)] ref double RefCmdPos,
            [MarshalAs(UnmanagedType.R8)] ref double ActMotorPos, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_PosCorr_SetTableFromFile) (t_i32 NetID, t_i32 Axis, char *szFilePath, t_i32 *ErrCode);
        [DllImport(dll, CharSet = CharSet.Unicode, BestFitMapping = false)]
        public static extern unsafe int ecmSxCfg_PosCorr_SetTableFromFile(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.LPStr)] ref string szFilePath, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I1)] bool IsEnable, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_PosCorr_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr_ClearTable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr_ClearTable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_PosCorr2D_Reset) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr2D_Reset(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_PosCorr2D_SetTableHeader) (t_i32 NetID, t_i32 Axis, TEcmPC2DHeader PC2DHeader, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr2D_SetTableHeader(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            TEcmPC2DHeader pc2Header,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_PosCorr2D_GetTableHeader) (t_i32 NetID, t_i32 Axis, TEcmPC2DHeader* pPC2DHeader, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr2D_GetTableHeader(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            ref TEcmPC2DHeader pc2Header,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_PosCorr2D_SetTableData) (t_i32 NetID, t_i32 Axis, t_i32 Row, t_i32 Col, t_f32 CorrOfsData, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr2D_SetTableData(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Row,
            [MarshalAs(UnmanagedType.I4)] int Col,
            [MarshalAs(UnmanagedType.R4)] float CorrOfsData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f32		(CECAT_API *ecmSxCfg_PosCorr2D_GetTableData) (t_i32 NetID, t_i32 Axis, t_i32 Row, t_i32 Col, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.R4)]
        public static extern unsafe float ecmSxCfg_PosCorr2D_GetTableData(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Row,
            [MarshalAs(UnmanagedType.I4)] int Col,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr2D_SetTableFromFile) (t_i32 NetID, t_i32 Axis, char *szFilePath, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr2D_SetTableFromFile(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int AxisCount,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szFilePath,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr2D_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr2D_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] bool IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_PosCorr2D_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_PosCorr2D_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_SetValMode) (t_i32 NetID, t_i32 Axis, t_i32 ValMode, t_i32 NumMultiVals, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_AutoTorq_SetValMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int ValMode, 
            [MarshalAs(UnmanagedType.I4)] int NumMultiVals, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_AutoTorq_GetValMode) (t_i32 NetID, t_i32 Axis, t_i32 *NumMultiVals, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_AutoTorq_GetValMode(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int NumMultiVals, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_SetMultiVal) (t_i32 NetID, t_i32 Axis, t_i32 ValIndex, t_i32 TorqVal, t_i32 Duration, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_AutoTorq_SetMultiVal(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int ValIndex, 
            [MarshalAs(UnmanagedType.I4)] int TorqVal, 
            [MarshalAs(UnmanagedType.I4)] int Duration, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_GetMultiVal) (t_i32 NetID, t_i32 Axis, t_i32 ValIndex, t_i32* TorqVal, t_i32* Duration, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_AutoTorq_GetMultiVal(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int ValIndex,
            [MarshalAs(UnmanagedType.I4)] ref int TorqVal,
            [MarshalAs(UnmanagedType.I4)] ref int Duration,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_SetValue) (t_i32 NetID, t_i32 Axis, t_i32 OutTorqVal, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_AutoTorq_SetValue(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int OutTorqVal, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_AutoTorq_GetValue) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_AutoTorq_GetValue(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_SetLimit) (t_i32 NetID, t_i32 Axis, t_ui32 LimitMask, t_f64 HighSpeedLimit, t_f64 LowSpeedLimit, t_i32 TimeLimit, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_AutoTorq_SetLimit(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.U4)] uint LimitMask,
            [MarshalAs(UnmanagedType.R8)] double HighSpeedLimit,
            [MarshalAs(UnmanagedType.R8)] double LowSpeedLimit,
            [MarshalAs(UnmanagedType.I4)] int TimeLimit, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_GetLimit) (t_i32 NetID, t_i32 Axis, t_ui32 *LimitMask, t_f64 *HighSpeedLimit, t_f64 *LowSpeedLimit, t_i32 *TimeLimit, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_AutoTorq_GetLimit(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.U4)] ref uint LimitMask, 
            [MarshalAs(UnmanagedType.R8)] ref double HighSpeedLimit,
            [MarshalAs(UnmanagedType.R8)] ref double LowSpeedLimit,
            [MarshalAs(UnmanagedType.I4)] ref int TimeLimit,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_bool IsOneShotEnable, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_AutoTorq_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I1)] bool IsEnable, 
            [MarshalAs(UnmanagedType.I1)] bool IsOneShotEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_AutoTorq_GetEnable) (t_i32 NetID, t_i32 Axis, t_bool *IsOneShotEnable, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_AutoTorq_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I1)] ref bool IsOneShotEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        
        //EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_Ring_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_Ring_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_Ring_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_Ring_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I1)] bool IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_Ring_GetPosRange) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmSxCfg_Ring_GetPosRange(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_Ring_SetPosRange) (t_i32 NetID, t_i32 Axis, t_f64 RingPosRange, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_Ring_SetPosRange(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double RingPosRange, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_Ring_GetDirMode) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_Ring_GetDirMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCfg_Ring_SetDirMode) (t_i32 NetID, t_i32 Axis, t_i32 RingDirMode, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_Ring_SetDirMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int RingDirMode, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_ExtStop_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_ExtStop_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] bool isEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_ExtStop_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_ExtStop_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_ExtStop_SetEnv) (t_i32 NetID, t_i32 Axis, TEcLogicAddr SigAddr, t_i32 ActiveState, t_i32 DelayTime, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_ExtStop_SetEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            TEcLogicAddr SigAddr,
            [MarshalAs(UnmanagedType.I4)] int ActiveState,
            [MarshalAs(UnmanagedType.I4)] int DelayTime,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_ExtStop_GetEnv) (t_i32 NetID, t_i32 Axis, TEcLogicAddr *pSigAddr, t_i32 *pActiveState, t_i32 *pDelayTime, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_ExtStop_GetEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            ref TEcLogicAddr SigAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ActiveState,
            [MarshalAs(UnmanagedType.I4)] ref int DelayTime,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_ExtStop_SetEnv2) (t_i32 NetID, t_i32 Axis, TEcLogicAddr SigAddr, t_i32 ActiveLogic, t_f64 OfsDist, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_ExtStop_SetEnv2(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            TEcLogicAddr SigAddr,
            [MarshalAs(UnmanagedType.I4)] int ActiveLogic,
            [MarshalAs(UnmanagedType.R8)] double OfsDist,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_ExtStop_GetEnv2) (t_i32 NetID, t_i32 Axis, TEcLogicAddr *pSigAddr, t_i32 *ActiveLogic, t_f64 *pOfsDist, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_ExtStop_GetEnv2(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            ref TEcLogicAddr SigAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ActiveLogic,
            [MarshalAs(UnmanagedType.R8)] ref double OfsDist,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_ExtStop_SetEnv3) (t_i32 NetID, t_i32 Axis, t_ui8 TouchProbeIndex, t_i32 ActiveLogic, t_f64 OfsDist, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_ExtStop_SetEnv3(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] byte TouchProbeIndex,
            [MarshalAs(UnmanagedType.I4)] int ActiveLogic,
            [MarshalAs(UnmanagedType.R8)] double OfsDist,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_ExtStop_GetEnv3) (t_i32 NetID, t_i32 Axis, t_ui8 *TouchProbeIndex, t_i32 *ActiveLogic, t_f64 *pOfsDist, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCfg_ExtStop_GetEnv3(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] ref byte TouchProbeIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ActiveLogic,
            [MarshalAs(UnmanagedType.R8)] ref double OfsDist,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //t_success ecmSxCfg_ExtStop_SetOfsDistMode (t_i32 NetID, t_i32 Axis, t_bool IsHardOfsDistMode, t_i32 *ErrCode)
        [DllImport(dll, EntryPoint = "ecmSxCfg_ExtStop_SetOfsDistMode")]
        public static extern unsafe bool ecmSxCfg_ExtStop_SetOfsDistMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] bool IsHardOfsDistMode,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //t_bool ecmSxCfg_ExtStop_GetOfsDistMode (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode)
        [DllImport(dll, EntryPoint = "ecmSxCfg_ExtStop_GetOfsDistMode")]
        public static extern unsafe bool ecmSxCfg_ExtStop_GetOfsDistMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_SetSvon) (t_i32 NetID, t_i32 Axis, t_i32 SvonVal, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCtl_SetSvon(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int SvonVal,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_SetSvon_FF) (t_i32 NetID, t_i32 Axis, t_i32 SvonVal, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCtl_SetSvon_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int SvonVal, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSxCtl_GetSvon) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCtl_GetSvon(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_SetAlmRst) (t_i32 NetID, t_i32 Axis, t_i32 IsSetAlmRst, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCtl_SetAlmRst(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int IsSetAlmRst,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_SetAlmRst_FF) (t_i32 NetID, t_i32 Axis, t_i32 IsSetAlmRst, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCtl_SetAlmRst_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int IsSetAlmRst, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_ResetAlm) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCtl_ResetAlm(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_ResetAlm_FF) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCtl_ResetAlm_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxMot_SetTargTorq) (t_i32 NetID, t_i32 Axis, t_i32 TargTorq, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxMot_SetTargTorq(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int TargTorq,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxMot_GetTargTorq) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_GetTargTorq(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxMot_SetTargVel) (t_i32 NetID, t_i32 Axis, t_f64 TargVel, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxMot_SetTargVel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double TargVel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxMot_GetTargVel) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);        
        [DllImport(dll)]
        public static extern unsafe double ecmSxMot_GetTargVel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_VMoveStart) (t_i32 NetID, t_i32 Axis, t_i32 Dir, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_VMoveStart(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Dir, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_VMoveStart_FF) (t_i32 NetID, t_i32 Axis, t_i32 Dir, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_VMoveStart_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int Dir,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_MoveStart) (t_i32 NetID, t_i32 Axis, t_f64 Distance, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_MoveStart(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] double Distance, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_MoveStart_FF) (t_i32 NetID, t_i32 Axis, t_f64 Distance, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_MoveStart_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] double Distance,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxMot_Move) (t_i32 NetID, t_i32 Axis, t_f64 Distance, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxMot_Move(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] double Distance, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxMot_Move_NB) (t_i32 NetID, t_i32 Axis, t_f64 Distance, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxMot_Move_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double Distance, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_MoveToStart) (t_i32 NetID, t_i32 Axis, t_f64 Position, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_MoveToStart(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] double Position,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_MoveToStart_FF) (t_i32 NetID, t_i32 Axis, t_f64 Position, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_MoveToStart_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double Position, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxMot_MoveTo) (t_i32 NetID, t_i32 Axis, t_f64 Position, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxMot_MoveTo(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double Position, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxMot_MoveTo_NB) (t_i32 NetID, t_i32 Axis, t_f64 Position, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxMot_MoveTo_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double Position, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_OverrideSpeed) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_OverrideSpeed(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_OverrideMove) (t_i32 NetID, t_i32 Axis, t_f64 NewDist, _out t_bool *IsIgnored, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_OverrideMove(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double NewDist,
            [MarshalAs(UnmanagedType.I1)] ref bool IsIgnored,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_OverrideMoveTo) (t_i32 NetID, t_i32 Axis, t_f64 NewPos, _out t_bool *IsIgnored, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_OverrideMoveTo(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double NewPos, 
            [MarshalAs(UnmanagedType.I1)] ref bool IsIgnored,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_Stop) (t_i32 NetID, t_i32 Axis, t_i32 IsDecStop, t_i32 IsWaitCompt, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_Stop(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int IsDecStop, 
            [MarshalAs(UnmanagedType.I4)] int IsWaitCompt, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_Stop_FF) (t_i32 NetID, t_i32 Axis, t_i32 IsDecStop, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMot_Stop_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int IsDecStop, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        

        //EC_EXTERN t_bool	(CECAT_API *ecmSxSt_IsConnected)(t_i32 NetID, t_i32 Axis, t_i32 *ConnStsDetail, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSt_IsConnected(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ConnStsDetail, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN void*		(CECAT_API *ecmSxSt_GetInPDOPtr)(t_i32 NetID, t_i32 Axis, t_ui8 *PDODataType, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe TEcmInPDO_AxisType0 ecmSxSt_GetInPDOPtr(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.U1)] ref byte PDODataType,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSxSt_IsBusy) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe byte ecmSxSt_IsBusy(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxSt_WaitCompt) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSt_WaitCompt(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxSt_WaitCompt_NB) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSt_WaitCompt_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxSt_SetCount) (t_i32 NetID, t_i32 Axis, t_i32 NewPosCount, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxSt_SetCount(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int NewPosCount, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32 	(CECAT_API *ecmSxSt_GetCount) (t_i32 NetID, t_i32 Axis, t_i32 TargCntr, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxSt_GetCount(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int TargCntr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxSt_SetPosition) (t_i32 NetID, t_i32 Axis, t_f64 NewPosition, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxSt_SetPosition(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double NewPosition,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxSt_GetPosition) (t_i32 NetID, t_i32 Axis, t_i32 TargCntr, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmSxSt_GetPosition(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int TargCntr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxSt_GetCurSpeed) (t_i32 NetID, t_i32 Axis, t_i32 TargCntr, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmSxSt_GetCurSpeed(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int TargCntr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxSt_GetCurTorque) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmSxSt_GetCurTorque(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxSt_GetMotState) (t_i32 NetID, t_i32 Axis, _out t_i32 *SubErrData);
        [DllImport(dll)]
        public static extern unsafe int ecmSxSt_GetMotState(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_word	(CECAT_API *ecmSxSt_GetFlags) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe ushort ecmSxSt_GetFlags(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_word	(CECAT_API *ecmSxSt_GetDI) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe ushort ecmSxSt_GetDI(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_byte	(CECAT_API *ecmSxSt_GetTouchProbeSts) (t_i32 NetID, t_i32 Axis, t_i32 TouchProbeIndex, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe byte ecmSxSt_GetTouchProbeSts(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int TouchProbeIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxSt_GetTouchProbePos) (t_i32 NetID, t_i32 Axis, t_i32 TouchProbeIndex, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmSxSt_GetTouchProbePos(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int TouchProbeIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui8		(CECAT_API *ecmSxSt_GetOpModeDisp) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe byte ecmSxSt_GetOpModeDisp(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_i32	(CECAT_API *ecmSxSt_GetLmMapIdx) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxSt_GetLmMapIdx(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32	(CECAT_API *ecmSxSt_GetPtmMapIdx) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxSt_GetPtmMapIdx(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMaxSpdOfCT) (t_i32 NetID, t_i32 Axis, t_ui32 MaxSpd, _out t_i32 *ErrCode); // Cyclic Torq Mode의 Max Speed setting. MaxSpd의 단위는 rpm값으로 설정한다. 
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_SetMaxSpdOfCT(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.U4)] uint MaxSpd, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui32	(CECAT_API *ecmSxCfg_GetMaxSpdOfCT) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode); // Cyclic Torq Mode의 Max Speed 값을 반환. 반환값의 단위는 rpm이다.
        [DllImport(dll)]
        public static extern unsafe uint ecmSxCfg_GetMaxSpdOfCT(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMaxProfSpdOfCT) (t_i32 NetID, t_i32 Axis, t_f64 MaxProfSpd, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_SetMaxProfSpdOfCT(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double MaxProfSpd,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_GetMaxProfSpdOfCT) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmSxCfg_GetMaxProfSpdOfCT(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMaxTorqOfCV) (t_i32 NetID, t_i32 Axis, t_ui16 MaxTorq, _out t_i32 *ErrCode); // Cyclic Vel. Mode의 Max Torque setting. MaxTorq의 단위는 0.1% 값으로 설정한다. 
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCfg_SetMaxTorqOfCV(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.U2)] ushort MaxTorq,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui16	(CECAT_API *ecmSxCfg_GetMaxTorqOfCV) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode); // Cyclic Vel. Mode의 Max Torque 값을 반환. 반환값의 단위는 0.1%이다.
        [DllImport(dll)]
        public static extern unsafe ushort ecmSxCfg_GetMaxTorqOfCV(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        

        //====================== MOTION - POSITION COMPARE OUTPUT FUNCTIONS =================================================//


        public delegate void CallbackFunc(IntPtr lParam);

        //EC_EXTERN t_success (CECAT_API *ecmSxCmpOne_SetHandler) (t_i32 NetID, t_i32 Axis, t_i32 HandlerType, HANDLE Handler, UINT nMessage, LPARAM lParam, t_i32 *ErrCode); // HandlerType: EEcmHandlerType 선언 참고
        [DllImport(dll, EntryPoint = "ecmSxCmpOne_SetHandler")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpOne_SetHandler_MSG(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int handlerType,
            IntPtr handler,
            [MarshalAs(UnmanagedType.U4)] uint message,
            IntPtr LPARAM,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        [DllImport(dll, EntryPoint = "ecmSxCmpOne_SetHandler")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpOne_SetHandler_CLB(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int handlerType,
            CallbackFunc handler,
            [MarshalAs(UnmanagedType.U4)] uint message,
            IntPtr LPARAM,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpOne_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 GdoChanIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpOne_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I1)] bool isEnable, 
            [MarshalAs(UnmanagedType.I4)] int GdoChanIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSxCmpOne_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32* GdoChanIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpOne_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int GdoChanIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpOne_SetEnv) (t_i32 NetID, t_i32 Axis, t_i32 CmpCntrType, t_i32 CmpMethod, t_f64 CmpRefPos, t_i32 OutSigLogic, t_i32 OutSigOnTime, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpOne_SetEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int CmpCntrType,
            [MarshalAs(UnmanagedType.I4)] int CmpMethod,
            [MarshalAs(UnmanagedType.R8)] double CmpRefPos, 
            [MarshalAs(UnmanagedType.I4)] int OutSigLogic,
            [MarshalAs(UnmanagedType.I4)] int OutSigOnTime, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpOne_GetEnv) (t_i32 NetID, t_i32 Axis, t_i32* CmpCntrType, t_i32* CmpMethod, t_f64* CmpRefPos, t_i32* OutSigLogic, t_i32* OutSigOnTime, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpOne_GetEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int CmpCntrType,
            [MarshalAs(UnmanagedType.I4)] ref int CmpMethod,
            [MarshalAs(UnmanagedType.R8)] ref double CmpRefPos,
            [MarshalAs(UnmanagedType.I4)] ref int OutSigLogic, 
            [MarshalAs(UnmanagedType.I4)] ref int OutSigOnTime,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpOne_GetOutSts) (t_i32 NetID, t_i32 Axis, t_i32 *OutCount, t_f64 *LastOutPos, t_i32 *ErrCode);
        //[DllImport("ComiEcatSdk.dll", EntryPoint = "ecmSxCmpOne_GetOutSts")]
        //[return: MarshalAs(UnmanagedType.I1)]
        //public static extern unsafe bool ecmSxCmpOne_GetOutSts(
        //    [MarshalAs(UnmanagedType.I4)] int NetID,
        //    [MarshalAs(UnmanagedType.I4)] int Axis,
        //    [MarshalAs(UnmanagedType.I4)] ref int OutCount, 
        //    [MarshalAs(UnmanagedType.R8)] ref double LastOutPos, 
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        // DLL에 없음

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpOne_ResetOutSts) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        //[DllImport("ComiEcatSdk.dll", EntryPoint = "ecmSxCmpOne_ResetOutSts")]
        //[return: MarshalAs(UnmanagedType.I1)]
        //public static extern unsafe bool ecmSxCmpOne_ResetOutSts(
        //    [MarshalAs(UnmanagedType.I4)] int NetID,
        //    [MarshalAs(UnmanagedType.I4)] int Axis,
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        // DLL에 없음

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 GdoChanIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpCont_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] bool isEnable, 
            [MarshalAs(UnmanagedType.I4)] int GdoChanIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSxCmpCont_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32* GdoChanIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpCont_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int GdoChanIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_SetTableSize) (t_i32 NetID, t_i32 Axis, t_i32 TableSize, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpCont_SetTableSize(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int TableSize, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCmpCont_GetTableSize) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCmpCont_GetTableSize(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_SetTableData) (t_i32 NetID, t_i32 Axis, t_i32 TableIndex, t_i32 CmpCntrType, t_i32 CmpMethod, t_f64 CmpRefPos, t_i32 OutSigLogic, t_i32 OutSigOnTime, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpCont_SetTableData(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int TableIndex, 
            [MarshalAs(UnmanagedType.I4)] int CmpCntrType,
            [MarshalAs(UnmanagedType.I4)] int CmpMethod,
            [MarshalAs(UnmanagedType.R8)] double CmpRefPos,
            [MarshalAs(UnmanagedType.I4)] int OutSigLogic, 
            [MarshalAs(UnmanagedType.I4)] int OutSigOnTime,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_GetTableData) (t_i32 NetID, t_i32 Axis, t_i32 TableIndex, t_i32* CmpCntrType, t_i32* CmpMethod, t_f64* CmpRefPos, t_i32* OutSigLogic, t_i32* OutSigOnTime, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpCont_GetTableData(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int TableIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int CmpCntrType, 
            [MarshalAs(UnmanagedType.I4)] ref int CmpMethod,
            [MarshalAs(UnmanagedType.R8)] ref double CmpRefPos,
            [MarshalAs(UnmanagedType.I4)] ref int OutSigLogic, 
            [MarshalAs(UnmanagedType.I4)] ref int OutSigOnTime,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmSxCmpCont_GetActTblIdx) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxCmpCont_GetActTblIdx(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_SetActTblIdx) (t_i32 NetID, t_i32 Axis, t_i32 TableIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpCont_SetActTblIdx(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int TableIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_GetOutSts) (t_i32 NetID, t_i32 Axis, t_i32 *OutCount, t_f64 *LastOutPos, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpCont_GetOutSts(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int OutCount, 
            [MarshalAs(UnmanagedType.R8)] ref double LastOutPos, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_ResetOutSts) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxCmpCont_ResetOutSts(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //====================== SLAVE ABCMP FUNCTIONS ==========================================================//

        //EC_EXTERN t_success (CECAT_API *ecTrg_InitCmp) 		(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_InitCmp(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success (CECAT_API *ecTrg_SetEnc) 		(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 Channel, t_i32 Mode, t_i32 EncInitCnt, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_SetEnc(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Mode,
            [MarshalAs(UnmanagedType.I4)] int EncInitCnt,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success (CECAT_API *ecTrg_SetCmp) 		(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 Channel, t_i32 Mode, t_i32 Width, t_i32 Margin, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_SetCmp(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Mode,
            [MarshalAs(UnmanagedType.I4)] int Width,
            [MarshalAs(UnmanagedType.I4)] int Margin,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecTrg_SetEncEnable) 	(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 Channel, t_i32 IsEnable, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_SetEncEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecTrg_SetCmpEnable) 	(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 Channel, t_i32 IsEnable, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_SetCmpEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecTrg_GetCmpStatus) 	(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 Channel, t_i32 *CmpPos, t_i32 *CmpCnt, t_i32 *FaultCnt, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_GetCmpStatus(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int CmpPos,
            [MarshalAs(UnmanagedType.I4)] ref int CmpCnt,
            [MarshalAs(UnmanagedType.I4)] ref int FaultCnt,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecTrg_GetEncStatus) 	(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 Channel, t_i32 *EncCntX, t_i32 *EncCntY, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_GetEncStatus(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int EncCntX,
            [MarshalAs(UnmanagedType.I4)] ref int EncCntY,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecTrg_SetCmpData) 	(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 Channel, t_i32 Addr, t_i32 CntX, t_i32 CntY, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_SetCmpData(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Addr,
            [MarshalAs(UnmanagedType.I4)] int CntX,
            [MarshalAs(UnmanagedType.I4)] int CntY,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecTrg_SetCmpNum) 	(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 Channel, t_i32 cmpNum, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_SetCmpNum(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int cmpNum,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecTrg_GetCmpFaultData) 	(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 Channel, t_i32 Addr, t_i32 *CntX, t_i32 *CntY, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_GetCmpFaultData(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int CntX,
            [MarshalAs(UnmanagedType.I4)] ref int CntY,
            [MarshalAs(UnmanagedType.I4)] int Addr,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecTrg_SetCmpTable) 	(t_i32 NetID, t_i32 SlvPhysAddr, t_i32 Channel, t_i32 *pTable, t_i32 dataNum, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecTrg_SetCmpTable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlvPhysAddr,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] pTable,
            [MarshalAs(UnmanagedType.I4)] int dataNum,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //====================== MOTION - MultiTorq FUNCTIONS =================================================//
        
        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMulTorq1_Start) (t_i32 NetID, t_i32 Axis, t_i16 InitialTorq, TEcmMTQ1Item NextTorqList[], t_ui16 NumNextTorqItems, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMulTorq1_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I2)] short InitialTorq,
            TEcmMTQ1Item[] NextTorqList,
            [MarshalAs(UnmanagedType.U2)] ushort NumNextTorqItems,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMulTorq1_Stop) (t_i32 NetID, t_i32 Axis, t_i16 StopTorq, t_bool IsApplyStopTorq, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmSxMulTorq1_Stop(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I2)] short StopTorq, 
            [MarshalAs(UnmanagedType.I1)] bool IsApplyStopTorq, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        ////====================== MOTION - Slow Down(SD) for Single Axis FUNCTIONS =================================================//

        //EC_EXTERN t_success	(CECAT_API *ecmSxSD_SetInputEnv) (t_i32 NetID, t_i32 Axis, t_dword LogBitAddr, t_bool IsInvertLogic, t_i32 FilterCount, t_i32 *ErrCode); 
        // SD 입력 신호에 대한 환경을 설정한다
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_SetInputEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.I1)] bool IsInvertLogic,
            [MarshalAs(UnmanagedType.I4)] int FilterCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmSxSD_GetInputEnv) (t_i32 NetID, t_i32 Axis, t_dword *LogBitAddr, t_bool *IsInvertLogic, t_i32 *FilterCount, t_i32 *ErrCode); 
        // SD 입력 신호에 대한 환경 설정값을 읽는다
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_GetInputEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.U4)] ref uint LogBitAddr,
            [MarshalAs(UnmanagedType.I1)] ref bool IsInvertLogic,
            [MarshalAs(UnmanagedType.I4)] ref int FilterCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmSxSD_SetSpeed) (t_i32 NetID, t_i32 Axis, t_f64 SdSpeed, t_i32 *ErrCode); 
        // SD 속도를 설정한다
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_SetSpeed(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double SdSpeed,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_f64		(CECAT_API *ecmSxSD_GetSpeed) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
        // SD 속도 설정값을 반환한다.
        [DllImport(dll)]
        public static extern unsafe double ecmSxSD_GetSpeed(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmSxSD_SetOffset) (t_i32 NetID, t_i32 Axis, t_i32 OffsetMode, t_f64 Offset, t_i32 *ErrCode); 
        // SD OFFSET을 설정한다. OffsetMode에 설정가능한 값은 EEcmSdOfsMode 형선언 참조.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_SetOffset(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int OffsetMode,
            [MarshalAs(UnmanagedType.R8)] double Offset,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmSxSD_GetOffset) (t_i32 NetID, t_i32 Axis, t_i32 *OffsetMode, t_f64 *Offset, t_i32 *ErrCode); 
        // SD OFFSET 설정을 읽는다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_GetOffset(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int OffsetMode,
            [MarshalAs(UnmanagedType.R8)] ref double Offset,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmSxSD_SetLatchMode) (t_i32 NetID, t_i32 Axis, t_bool IsLatchMode, t_i32 *ErrCode); 
        // SD 신호의 Latch 모드를 설정한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_SetLatchMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] bool IsLatchMode,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_bool	(CECAT_API *ecmSxSD_GetLatchMode) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode); 
        // SD 신호의 Latch 모드를 설정값을 반환한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_GetLatchMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmSxSD_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode); 
        // SD 기능을 활성화 또는 비활성화한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I1)] bool IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_bool	(CECAT_API *ecmSxSD_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode); 
        // SD 기능의 활성화 여부를 반환한다. 
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        

        //EC_EXTERN t_success	(CECAT_API *ecmSxSD_RestoreSpeed) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode); 
        // Slow Down 속도로 진행 중인 경우에 원래의 속도로 복귀하도록 한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_RestoreSpeed(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_bool	(CECAT_API *ecmSxSD_GetInputStatus) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode); 
        // SD 신호의 상태를 반환다
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_GetInputStatus(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmSxSD_GetActStatus) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode); 
        // SD 속도로 진행중인지에 대한 상태를 반환한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmSxSD_GetActStatus(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        ////====================== MOTION - MULTIPLE AXES FUNCTIONS =================================================//

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_VMoveStart) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 DirList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmMxMot_VMoveStart(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int NumAxes,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] DirList, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_VMoveStart_FF) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 DirList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmMxMot_VMoveStart_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int NumAxes, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] DirList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_MoveStart) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_f64 DistList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmMxMot_MoveStart(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int NumAxes, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] DistList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_MoveStart_FF) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_f64 DistList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmMxMot_MoveStart_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int NumAxes, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] DistList, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_MoveToStart) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_f64 PosList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmMxMot_MoveToStart(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int NumAxes, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] PosList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_MoveToStart_FF) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_f64 PosList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmMxMot_MoveToStart_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int NumAxes, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] PosList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_Stop) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 IsDecStop, t_i32 IsWaitCompt, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmMxMot_Stop(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int NumAxes,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.I4)] int IsDecStop,
            [MarshalAs(UnmanagedType.I4)] int IsWaitCompt,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_Stop_FF) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 IsDecStop, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmMxMot_Stop_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int NumAxes, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList, 
            [MarshalAs(UnmanagedType.I4)] int IsDecStop, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_bool	(CECAT_API *ecmMxSt_IsBusy) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMxSt_IsBusy(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int NumAxes,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmMxSt_WaitCompt) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMxSt_WaitCompt(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int NumAxes, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmMxSt_WaitCompt_NB) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMxSt_WaitCompt_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int NumAxes,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        ////====================== MOTION - INTERPOLATION FUNCTIONS ================================================//
        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_MapAxes) (t_i32 NetID, t_i32 MapIndex, t_i32 NumAxes, t_i32 AxisList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_MapAxes(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.I4)] int NumAxes, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_MapAxes_FF) (t_i32 NetID, t_i32 MapIndex, t_i32 NumAxes, t_i32 AxisList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_MapAxes_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.I4)] int NumAxes,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_UnmapAxes) (t_i32 NetID, t_i32 MapIndex, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_UnmapAxes(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_UnmapAxes_FF) (t_i32 NetID, t_i32 MapIndex, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_UnmapAxes_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetSpeedPatt) (t_i32 NetID, t_i32 MapIndex, t_i32 IsVectSpeed, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 Acc, t_f64 Dec, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_SetSpeedPatt(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] int IsVectSpeed, 
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double VIni,
            [MarshalAs(UnmanagedType.R8)] double VEnd, 
            [MarshalAs(UnmanagedType.R8)] double VWork,
            [MarshalAs(UnmanagedType.R8)] double Acc,
            [MarshalAs(UnmanagedType.R8)] double Dec,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetSpeedPatt_FF) (t_i32 NetID, t_i32 MapIndex, t_i32 IsVectSpeed, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 Acc, t_f64 Dec, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_SetSpeedPatt_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] int IsVectSpeed,
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double VIni,
            [MarshalAs(UnmanagedType.R8)] double VEnd, 
            [MarshalAs(UnmanagedType.R8)] double VWork, 
            [MarshalAs(UnmanagedType.R8)] double Acc,
            [MarshalAs(UnmanagedType.R8)] double Dec, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxCfg_GetSpeedPatt) (t_i32 NetID, t_i32 MapIndex, t_i32 *IsVectSpeed, t_i32 *SpeedMode, t_f64 *VIni, t_f64 *VEnd, t_f64 *VWork, t_f64 *Acc, t_f64 *Dec, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_GetSpeedPatt(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int IsVectSpeed,
            [MarshalAs(UnmanagedType.I4)] ref int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] ref double VIni,
            [MarshalAs(UnmanagedType.R8)] ref double VEnd,
            [MarshalAs(UnmanagedType.R8)] ref double VWork,
            [MarshalAs(UnmanagedType.R8)] ref double Acc, 
            [MarshalAs(UnmanagedType.R8)] ref double Dec, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetJerkRatio) (t_i32 NetID, t_i32 MapIndex, t_f64 JerkTimeRatio, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_SetJerkRatio(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double JerkTimeRatio, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetJerkRatio_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 JerkTimeRatio, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_SetJerkRatio_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double JerkTimeRatio,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmIxCfg_GetJerkRatio) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmIxCfg_GetJerkRatio(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetSpeedPatt_MR) (t_i32 NetID, t_i32 MapIndex, t_i32 SpeedMode, t_f64 MasterRatio, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_SetSpeedPatt_MR(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double MasterRatio, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetSpeedPatt_MR_FF) (t_i32 NetID, t_i32 MapIndex, t_i32 SpeedMode, t_f64 MasterRatio, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_SetSpeedPatt_MR_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double MasterRatio,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxCfg_GetSpeedPatt_MR) (t_i32 NetID, t_i32 MapIndex, t_i32 *SpeedMode, t_f64 *MasterRatio, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_GetSpeedPatt_MR(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int SpeedMode, 
            [MarshalAs(UnmanagedType.R8)] ref double MasterRatio, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetMastWeight) (t_i32 NetID, t_i32 MapIndex, t_f64 *MastWeightList, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_SetMastWeight(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] ref double MastWeightList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxCfg_GetMastWeight) (t_i32 NetID, t_i32 MapIndex, t_f64 *MastWeightList, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_GetMastWeight(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] ref double MastWeightList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        
        //EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_ClearPool) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_Spline_ClearPool(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_handle32 (CECAT_API *ecmIxCfg_Spline_AddNewObj) (t_i32 NetID, t_i32 MapIndex,  t_ui32 NumRefPoints, t_bool IsAbsPosMode, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe IntPtr ecmIxCfg_Spline_AddNewObj(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.U4)] uint NumRefPoints, 
            [MarshalAs(UnmanagedType.I1)] bool IsAbsPosMode, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxCfg_Spline_SetRefPoint) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 PointIndex, t_f64 Point[], t_i32 NumPointData, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_Spline_SetRefPoint(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj, 
            [MarshalAs(UnmanagedType.I4)] int PointIndex,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.R8)] double[] Point,
            [MarshalAs(UnmanagedType.I4)] int NumPointData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxCfg_Spline_BuildObj) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_Spline_BuildObj(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_SetTrgOutEnv) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_bool IsEnableTrgOut, t_i16 TrgOfsTime_ms, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_Spline_SetTrgOutEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj, 
            [MarshalAs(UnmanagedType.I1)] bool IsEnableTrgOut, 
            [MarshalAs(UnmanagedType.I2)] short TrgOfsTime_ms,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_GetTrgOutEnv) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_bool* IsEnableTrgOut, t_i16* TrgOfsTime_ms, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_Spline_GetTrgOutEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj, 
            [MarshalAs(UnmanagedType.I1)] ref bool IsEnableTrgOut,
            [MarshalAs(UnmanagedType.I2)] ref short TrgOfsTime_ms,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmIxCfg_Spline_GetTrgOutPos) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 Axis, t_i32 PointIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmIxCfg_Spline_GetTrgOutPos(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int PointIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_SetJsType) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 JerkSmoothType, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_Spline_SetJsType(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj,
            [MarshalAs(UnmanagedType.I4)] int JerkSmoothType, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmIxCfg_Spline_GetJsType) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxCfg_Spline_GetJsType(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_SetJsProp_F) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 PropId, t_f64 PropVal, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_Spline_SetJsProp_F(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj, 
            [MarshalAs(UnmanagedType.I4)] int PropId, 
            [MarshalAs(UnmanagedType.R8)] double PropVal, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmIxCfg_Spline_GetJsProp_F) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 PropId, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmIxCfg_Spline_GetJsProp_F(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj,
            [MarshalAs(UnmanagedType.I4)] int PropId, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_SetJerkThresh) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 Axis, t_f64 JerkThreshold, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_Spline_SetJerkThresh(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] double JerkThreshold,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmIxCfg_Spline_GetJerkThresh) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 Axis, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmIxCfg_Spline_GetJerkThresh(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmIxCfg_MPRLin2X_ClearPool) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_MPRLin2X_ClearPool(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_handle32 (CECAT_API *ecmIxCfg_MPRLin2X_AddNewObj) (t_i32 NetID, t_i32 MapIndex,  t_ui32 NumRefPoints, t_bool IsAbsPosMode, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe IntPtr ecmIxCfg_MPRLin2X_AddNewObj(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.U4)] uint NumRefPoints,
            [MarshalAs(UnmanagedType.I1)] bool IsAbsPosMode,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxCfg_MPRLin2X_SetRefPoint) (t_i32 NetID, t_i32 MapIndex, t_handle32 hMPRLin2XObj, t_i32 PointIndex, t_f64 Point[], t_f64 RoundData, t_i32 RoundDataType, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_MPRLin2X_SetRefPoint(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hMPRLin2XObj, 
            [MarshalAs(UnmanagedType.I4)] int PointIndex,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] Point, 
            [MarshalAs(UnmanagedType.R8)] double RoundData, 
            [MarshalAs(UnmanagedType.I4)] int RoundDataType,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxCfg_MPRLin2X_BuildObj) (t_i32 NetID, t_i32 MapIndex, t_handle32 hMPRLin2XObj, _out t_f64 LastPointBuf[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxCfg_MPRLin2X_BuildObj(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hMPRLin2XObj, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] LastPointBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_LineStart) (t_i32 NetID, t_i32 MapIndex, t_f64 DistList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_LineStart(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] DistList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_LineStart_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 DistList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_LineStart_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] DistList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxMot_Line) (t_i32 NetID, t_i32 MapIndex, t_f64 DistList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_Line(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] DistList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxMot_Line_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 DistList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_Line_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] DistList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_LineToStart) (t_i32 NetID, t_i32 MapIndex, t_f64 PosList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_LineToStart(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] PosList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_LineToStart_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 PosList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_LineToStart_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] PosList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxMot_LineTo) (t_i32 NetID, t_i32 MapIndex, t_f64 PosList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_LineTo(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] PosList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxMot_LineTo_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 PosList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_LineTo_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] PosList, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_ArcAng_R_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_ArcAng_R_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double YCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_ArcAng_R_Start_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_ArcAng_R_Start_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double XCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double YCentOffset,
            [MarshalAs(UnmanagedType.R8)] double EndAngle, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxMot_ArcAng_R) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_ArcAng_R(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double XCentOffset,
            [MarshalAs(UnmanagedType.R8)] double YCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxMot_ArcAng_R_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_ArcAng_R_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double YCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_ArcAng_A_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_ArcAng_A_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentPos, 
            [MarshalAs(UnmanagedType.R8)] double YCentPos, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_ArcAng_A_Start_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_ArcAng_A_Start_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double XCentPos, 
            [MarshalAs(UnmanagedType.R8)] double YCentPos, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcAng_A) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_ArcAng_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double XCentPos, 
            [MarshalAs(UnmanagedType.R8)] double YCentPos,
            [MarshalAs(UnmanagedType.R8)] double EndAngle, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcAng_A_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_ArcAng_A_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double XCentPos,
            [MarshalAs(UnmanagedType.R8)] double YCentPos,
            [MarshalAs(UnmanagedType.R8)] double EndAngle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_ArcPos_R_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 XEndOffset, t_f64 YEndOffset, t_i32 Direction, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_ArcPos_R_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double yCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double xEndOffset, 
            [MarshalAs(UnmanagedType.R8)] double yEndOffset, 
            [MarshalAs(UnmanagedType.I4)] int Direction,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_ArcPos_R_Start_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 XEndOffset, t_f64 YEndOffset, t_i32 Direction, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_ArcPos_R_Start_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentOffset,
            [MarshalAs(UnmanagedType.R8)] double YCentOffset,
            [MarshalAs(UnmanagedType.R8)] double XEndOffset,
            [MarshalAs(UnmanagedType.R8)] double YEndOffset, 
            [MarshalAs(UnmanagedType.I4)] int Direction, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
                
        //EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcPos_R) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 XEndOffset, t_f64 YEndOffset, t_i32 Direction, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_ArcPos_R(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double YCentOffset,
            [MarshalAs(UnmanagedType.R8)] double XEndOffset, 
            [MarshalAs(UnmanagedType.R8)] double YEndOffset, 
            [MarshalAs(UnmanagedType.I4)] int Direction, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcPos_R_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 XEndOffset, t_f64 YEndOffset, t_i32 Direction, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_ArcPos_R_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentOffset,
            [MarshalAs(UnmanagedType.R8)] double YCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double XEndOffset, 
            [MarshalAs(UnmanagedType.R8)] double YEndOffset,
            [MarshalAs(UnmanagedType.I4)] int Direction, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_ArcPos_A_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 XEndPos, t_f64 YEndPos, t_i32 Direction, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_ArcPos_A_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentPos,
            [MarshalAs(UnmanagedType.R8)] double YCentPos, 
            [MarshalAs(UnmanagedType.R8)] double XEndPos, 
            [MarshalAs(UnmanagedType.R8)] double YEndPos, 
            [MarshalAs(UnmanagedType.I4)] int Direction,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_ArcPos_A_Start_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 XEndPos, t_f64 YEndPos, t_i32 Direction, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_ArcPos_A_Start_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentPos,
            [MarshalAs(UnmanagedType.R8)] double YCentPos,
            [MarshalAs(UnmanagedType.R8)] double XEndPos,
            [MarshalAs(UnmanagedType.R8)] double YEndPos,
            [MarshalAs(UnmanagedType.I4)] int Direction, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcPos_A) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 XEndPos, t_f64 YEndPos, t_i32 Direction, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_ArcPos_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentPos,
            [MarshalAs(UnmanagedType.R8)] double YCentPos,
            [MarshalAs(UnmanagedType.R8)] double XEndPos, 
            [MarshalAs(UnmanagedType.R8)] double YEndPos, 
            [MarshalAs(UnmanagedType.I4)] int Direction,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcPos_A_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 XEndPos, t_f64 YEndPos, t_i32 Direction, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_ArcPos_A_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentPos,
            [MarshalAs(UnmanagedType.R8)] double YCentPos,
            [MarshalAs(UnmanagedType.R8)] double XEndPos,
            [MarshalAs(UnmanagedType.R8)] double YEndPos,
            [MarshalAs(UnmanagedType.I4)] int Direction, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_Arc3P_R_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XOffset, t_f64 P2_YOffset, t_f64 P3_XOffset, t_f64 P3_YOffset, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_Arc3P_R_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double P2_XOffset, 
            [MarshalAs(UnmanagedType.R8)] double P2_YOffset,
            [MarshalAs(UnmanagedType.R8)] double P3_XOffset, 
            [MarshalAs(UnmanagedType.R8)] double P3_YOffset,            
            [MarshalAs(UnmanagedType.R8)] double EndAngle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_Arc3P_R_Start_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XOffset, t_f64 P2_YOffset, t_f64 P3_XOffset, t_f64 P3_YOffset, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_Arc3P_R_Start_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double P2_XOffset, 
            [MarshalAs(UnmanagedType.R8)] double P2_YOffset,
            [MarshalAs(UnmanagedType.R8)] double P3_XOffset, 
            [MarshalAs(UnmanagedType.R8)] double P3_YOffset,
            [MarshalAs(UnmanagedType.R8)] double EndAngle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxMot_Arc3P_R) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XOffset, t_f64 P2_YOffset, t_f64 P3_XOffset, t_f64 P3_YOffset, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_Arc3P_R(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double P2_XOffset,
            [MarshalAs(UnmanagedType.R8)] double P2_YOffset,
            [MarshalAs(UnmanagedType.R8)] double P3_XOffset, 
            [MarshalAs(UnmanagedType.R8)] double P3_YOffset, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxMot_Arc3P_R_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XOffset, t_f64 P2_YOffset, t_f64 P3_XOffset, t_f64 P3_YOffset, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_Arc3P_R_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double P2_XOffset, 
            [MarshalAs(UnmanagedType.R8)] double P2_YOffset,
            [MarshalAs(UnmanagedType.R8)] double P3_XOffset,
            [MarshalAs(UnmanagedType.R8)] double P3_YOffset,
            [MarshalAs(UnmanagedType.R8)] double EndAngle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_Arc3P_A_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XPos, t_f64 P2_YPos, t_f64 P3_XPos, t_f64 P3_YPos, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_Arc3P_A_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double P2_XPos,
            [MarshalAs(UnmanagedType.R8)] double P2_YPos,
            [MarshalAs(UnmanagedType.R8)] double P3_XPos, 
            [MarshalAs(UnmanagedType.R8)] double P3_YPos,
            [MarshalAs(UnmanagedType.R8)] double EndAngle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_Arc3P_A_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XPos, t_f64 P2_YPos, t_f64 P3_XPos, t_f64 P3_YPos, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_Arc3P_A_Start_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double P2_XPos,
            [MarshalAs(UnmanagedType.R8)] double P2_YPos,
            [MarshalAs(UnmanagedType.R8)] double P3_XPos,
            [MarshalAs(UnmanagedType.R8)] double P3_YPos, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxMot_Arc3P_A) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XPos, t_f64 P2_YPos, t_f64 P3_XPos, t_f64 P3_YPos, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_Arc3P_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double P2_XPos,
            [MarshalAs(UnmanagedType.R8)] double P2_YPos, 
            [MarshalAs(UnmanagedType.R8)] double P3_XPos, 
            [MarshalAs(UnmanagedType.R8)] double P3_YPos,
            [MarshalAs(UnmanagedType.R8)] double EndAngle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmIxMot_Arc3P_A_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XPos, t_f64 P2_YPos, t_f64 P3_XPos, t_f64 P3_YPos, t_f64 EndAngle, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxMot_Arc3P_A_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double P2_XPos,
            [MarshalAs(UnmanagedType.R8)] double P2_YPos,
            [MarshalAs(UnmanagedType.R8)] double P3_XPos, 
            [MarshalAs(UnmanagedType.R8)] double P3_YPos,
            [MarshalAs(UnmanagedType.R8)] double EndAngle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_Spline_Start) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_bool IsReverseDir, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_Spline_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hSplineObj,
            [MarshalAs(UnmanagedType.I1)] bool IsReverseDir, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_MPRLin2X_Start) (t_i32 NetID, t_i32 MapIndex, t_handle32 hMPRLin2XObj, t_bool IsReverseDir, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_MPRLin2X_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            IntPtr hMPRLin2XObj,
            [MarshalAs(UnmanagedType.I1)] bool IsReverseDir, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_MoveVia2X_Start) (t_i32 NetID, t_ui16 MapIndex, t_f64 P2[], t_f64 P3[], t_bool IsAbsPosMode, t_i32 RoundPosType, t_f64 NormRadius, t_f64 MinRadius, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_MoveVia2X_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort MapIndex,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] P2,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] P3, 
            [MarshalAs(UnmanagedType.I1)] bool IsAbsPosMode,
            [MarshalAs(UnmanagedType.I4)] int RoundPosType,
            [MarshalAs(UnmanagedType.R8)] double NormRadius,
            [MarshalAs(UnmanagedType.R8)] double MinRadius,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_MoveVia2X_OverrideTP) (t_i32 NetID, t_ui16 MapIndex, t_f64 TP_new[], t_f64 RoundRadius, _out t_bool *IsIgnored, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_MoveVia2X_OverrideTP(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort MapIndex,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] TP_new,
            [MarshalAs(UnmanagedType.R8)] double RoundRadius,
            [MarshalAs(UnmanagedType.I1)] ref bool IsIgnored,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_Stop) (t_i32 NetID, t_i32 MapIndex, t_i32 IsDecStop, t_i32 IsWaitCompt, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_Stop(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] int IsDecStop,
            [MarshalAs(UnmanagedType.I4)] int IsWaitCompt,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_Stop_FF) (t_i32 NetID, t_i32 MapIndex, t_i32 IsDecStop, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmIxMot_Stop_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] int IsDecStop, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmIxSt_IsBusy) (t_i32 NetID, t_i32 MapIndex, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSt_IsBusy(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxSt_WaitCompt) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSt_WaitCompt(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmIxSt_WaitCompt_NB) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSt_WaitCompt_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //====================== MOTION - Slow Down(SD) for IX(Interpolation) FUNCTIONS =================================================//
        //EC_EXTERN t_success	(CECAT_API *ecmIxSD_SetInputEnv) (t_i32 NetID, t_i32 MapIndex, t_dword LogBitAddr, t_bool IsInvertLogic, t_i32 FilterCount, t_i32 *ErrCode); 
        // SD 입력 신호에 대한 환경을 설정한다
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_SetInputEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.U4)] uint LogBitAddr,
            [MarshalAs(UnmanagedType.I1)] bool IsInvertLogic,
            [MarshalAs(UnmanagedType.I4)] int FilterCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmIxSD_GetInputEnv) (t_i32 NetID, t_i32 MapIndex, t_dword *LogBitAddr, t_bool *IsInvertLogic, t_i32 *FilterCount, t_i32 *ErrCode); 
        // SD 입력 신호에 대한 환경 설정값을 읽는다
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_GetInputEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.U4)] ref uint LogBitAddr,
            [MarshalAs(UnmanagedType.I1)] ref bool IsInvertLogic,
            [MarshalAs(UnmanagedType.I4)] ref int FilterCount,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmIxSD_SetSpeed) (t_i32 NetID, t_i32 MapIndex, t_f64 SdSpeed, t_i32 *ErrCode); 
        // SD 속도를 설정한다 (이때 속도의 단위는 ecmIxCfg_SetSpeedPatt() 함수의 IxSpdPattType 인자에 따른다)
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_SetSpeed(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double SdSpeed,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_f64		(CECAT_API *ecmIxSD_GetSpeed) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode); // SD 속도 설정값을 반환한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.R8)]
        public static extern unsafe double ecmIxSD_GetSpeed(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmIxSD_SetOffset) (t_i32 NetID, t_i32 MapIndex, t_i32 OffsetMode, t_f64 Offset, t_i32 OfsAxis, t_i32 *ErrCode); 
        // SD OFFSET을 설정한다. OffsetMode에 설정가능한 값은 EEcmSdOfsMode 형선언 참조. OfsAixs는 OffsetMode가 ecmSD_OFS_CMDPOS나 ecmSD_OFS_FEEDPOS인 경우에 거리의 주체가 되는 축을 지정한다. 이 값을 -1로 지정하면 보간 거리를 적용한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_SetOffset(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] int OffsetMode,
            [MarshalAs(UnmanagedType.R8)] double Offset,
            [MarshalAs(UnmanagedType.I4)] int OfsAxis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmIxSD_GetOffset) (t_i32 NetID, t_i32 MapIndex, t_i32 *OffsetMode, t_f64 *Offset, t_i32 *OfsAxis, t_i32 *ErrCode); 
        // SD OFFSET 설정을 읽는다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_GetOffset(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int OffsetMode,
            [MarshalAs(UnmanagedType.R8)] ref double Offset,
            [MarshalAs(UnmanagedType.I4)] ref int OfsAxis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmIxSD_SetLatchMode) (t_i32 NetID, t_i32 MapIndex, t_bool IsLatchMode, t_i32 *ErrCode); 
        // SD 신호의 Latch 모드를 설정한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_SetLatchMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I1)] bool IsLatchMode,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_bool	(CECAT_API *ecmIxSD_GetLatchMode) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode); 
        // SD 신호의 Latch 모드를 설정값을 반환한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_GetLatchMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmIxSD_SetEnable) (t_i32 NetID, t_i32 MapIndex, t_bool IsEnable, t_i32 *ErrCode); 
        // SD 기능을 활성화 또는 비활성화한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_SetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I1)] bool IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_bool	(CECAT_API *ecmIxSD_GetEnable) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode); 
        // SD 기능의 활성화 여부를 반환한다. 
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_GetEnable(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmIxSD_RestoreSpeed) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode); 
        // Slow Down 속도로 진행 중인 경우에 원래의 속도로 복귀하도록 한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_RestoreSpeed(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_bool	(CECAT_API *ecmIxSD_GetInputStatus) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode); 
        // SD 신호의 상태를 반환다
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_GetInputStatus(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_bool	(CECAT_API *ecmIxSD_GetActStatus) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode); 
        // SD 속도로 진행중인지에 대한 상태를 반환한다.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmIxSD_GetActStatus(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);




        ////====================== MOTION - HOMING OPERATION FUNCTIONS ============================================//
        
        //EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeCfg_SetMode) (t_i32 NetID, t_i32 Axis, t_i32 HomeOpMode, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmHomeCfg_SetMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int HomeOpMode, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmHomeCfg_GetMode) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmHomeCfg_GetMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeCfg_SetOffset) (t_i32 NetID, t_i32 Axis, t_f64 Offset, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmHomeCfg_SetOffset(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.R8)] double Offset,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecmHomeCfg_GetOffset) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe double ecmHomeCfg_GetOffset(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeCfg_SetSpeedPatt) (t_i32 NetID, t_i32 Axis, t_i32 SpeedMode, t_f64 Vel, t_f64 Acc, t_f64 Dec, t_f64 HomeSpecVel, _out t_i32 *ErrCode);
        [DllImport(dll)]        
        public static extern unsafe int ecmHomeCfg_SetSpeedPatt(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double Vel,
            [MarshalAs(UnmanagedType.R8)] double Acc,
            [MarshalAs(UnmanagedType.R8)] double Dec,
            [MarshalAs(UnmanagedType.R8)] double HomeSpecVel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmHomeCfg_GetSpeedPatt) (t_i32 NetID, t_i32 Axis, t_i32* SpeedMode, t_f64* Vel, t_f64* Acc, t_f64* Dec, t_f64* HomeSpecVel, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHomeCfg_GetSpeedPatt(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] ref double Vel,
            [MarshalAs(UnmanagedType.R8)] ref double Acc,
            [MarshalAs(UnmanagedType.R8)] ref double Dec,
            [MarshalAs(UnmanagedType.R8)] ref double HomeSpecVel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeCfg_SetOption) (t_i32 NetID, t_i32 Axis, EEcmHomeOptID OptionID, t_i32 OptionVal, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmHomeCfg_SetOption(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            EEcmHomeOptID OptionID,
            [MarshalAs(UnmanagedType.I4)] int OptionVal,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmHomeCfg_GetOption) (t_i32 NetID, t_i32 Axis, EEcmHomeOptID OptionID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmHomeCfg_GetOption(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            EEcmHomeOptID OptionID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeMot_MoveStart) (t_i32 NetID, t_i32 Axis, t_i32 Direction, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmHomeMot_MoveStart(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Direction,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeMot_MoveStart_FF) (t_i32 NetID, t_i32 Axis, t_i32 Direction, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmHomeMot_MoveStart_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Direction, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmHomeMot_Move) (t_i32 NetID, t_i32 Axis, t_i32 Direction, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHomeMot_Move(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int Direction, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeMot_MoveStartAll)(t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 DirList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmHomeMot_MoveStartAll(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int NumAxes, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] DirList, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeMot_MoveStartAll_FF)(t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 DirList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmHomeMot_MoveStartAll_FF(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int NumAxes,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] DirList, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmHomeMot_MoveAll)(t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 DirList[], _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHomeMot_MoveAll(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int NumAxes,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] AxisList,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I4)] int[] DirList,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmHomeSt_IsBusy) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHomeSt_IsBusy(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmHomeSt_WaitCompt) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmHomeSt_WaitCompt(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_word	(CECAT_API *ecmHomeSt_GetFlags) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe ushort ecmHomeSt_GetFlags(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        


        ////====================== MOTION - Master/Slave FUNCTIONS ============================================//
        
        //EC_EXTERN t_success (CECAT_API *ecmMsCfg_SetSlvEnv) (t_i32 NetID, t_i32 Axis, t_i32 MasterAxis, t_f64 PosRatio, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMsCfg_SetSlvEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int MasterAxis,
            [MarshalAs(UnmanagedType.R8)] double PosRatio,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmMsCfg_GetSlvEnv) (t_i32 NetID, t_i32 Axis, t_i32* MasterAxis, t_f64* PosRatio, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]  
        public static extern unsafe bool ecmMsCfg_GetSlvEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int MasterAxis,
            [MarshalAs(UnmanagedType.R8)] ref double PosRatio,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmMsCtl_StartSlv) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMsCtl_StartSlv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmMsCtl_StopSlv) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMsCtl_StopSlv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmMsCtl_SynchSlv) (t_i32 NetID, t_i32 Axis, t_f64 MastPosOfs, t_bool IsWaitMoveCompt, _out t_i32 *ErrCode); 
        //< 지정된 슬레이브 축의 위치가 마스터축의 위치와 일치하는 위치가 되도록 슬레이브축을 이송.
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMsCtl_SynchSlv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.R8)] double MastPosOfs,
            [MarshalAs(UnmanagedType.I1)] bool IsWaitMoveCompt,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecmMsSt_IsSlvStarted) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmMsSt_IsSlvStarted(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        //====================== MOTION - ListMotion FUNCTIONS ============================================//

        //EC_EXTERN t_success	(CECAT_API *ecmLmCtl_Begin) (t_i32 NetID, t_i32 LmMapIndex, t_ui32 AxisMask1, t_ui32 AxisMask2, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCtl_Begin(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex, 
            [MarshalAs(UnmanagedType.U4)] uint AxisMask1, 
            [MarshalAs(UnmanagedType.U4)] uint AxisMask2,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmCtl_End) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCtl_End(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmCtl_Run) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCtl_Run(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmCtl_Stop) (t_i32 NetID, t_i32 LmMapIndex, t_bool IsComptCurStep, t_i32 DecelTime_ms, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCtl_Stop(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex, 
            [MarshalAs(UnmanagedType.I1)] bool IsComptCurStep,
            [MarshalAs(UnmanagedType.I4)] int DecelTime_ms,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmCtl_ClearQue) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCtl_ClearQue(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmCfg_SetQueFullMode) (t_i32 NetID, t_i32 LmMapIndex, t_i32 QueFullMode, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCfg_SetQueFullMode(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex, 
            [MarshalAs(UnmanagedType.I4)] int QueFullMode,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmLmCfg_GetQueFullMode) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmLmCfg_GetQueFullMode(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex,
            [MarshalAs(UnmanagedType.I4)] int QueFullMode,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmCfg_SetQueDepth) (t_i32 NetID, t_i32 LmMapIndex, t_i32 QueDepth, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCfg_SetQueDepth(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex, 
            [MarshalAs(UnmanagedType.I4)] int QueDepth,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmLmCfg_GetQueDepth) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmLmCfg_SetQueDepth(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmCfg_SetStepId) (t_i32 NetID, t_i32 LmMapIndex, t_i32 StepId, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCfg_SetStepId(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex,
            [MarshalAs(UnmanagedType.I4)] int StepId, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmLmCfg_GetStepId) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmLmCfg_GetStepId(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmCfg_SetStepParam) (t_i32 NetID, t_i32 LmMapIndex, t_i32 StepParam1, t_i32 StepParam2, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCfg_SetStepParam(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex,
            [MarshalAs(UnmanagedType.I4)] int StepParam1, 
            [MarshalAs(UnmanagedType.I4)] int StepParam2, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmCfg_GetStepParam) (t_i32 NetID, t_i32 LmMapIndex, t_dword *StepParam1, t_dword *StepParam2, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCfg_GetStepParam(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int StepParam1,
            [MarshalAs(UnmanagedType.I4)] ref int StepParam2,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmLmSt_GetRunSts) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmLmSt_GetRunSts(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecmLmSt_GetRemStepCount) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecmLmSt_GetRemStepCount(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmSt_GetRunStepInfo) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *RunStepCount, t_i32 *RunStepId, t_i32 *RunStepSts, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmSt_GetRunStepInfo(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int RunStepCount,
            [MarshalAs(UnmanagedType.I4)] ref int RunStepId, 
            [MarshalAs(UnmanagedType.I4)] ref int RunStepSts,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmSt_GetRunStepParam) (t_i32 NetID, t_i32 LmMapIndex, t_dword *StepParam1, t_dword *StepParam2, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmSt_GetRunStepParam(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex,
            [MarshalAs(UnmanagedType.U4)] ref uint StepParam1, 
            [MarshalAs(UnmanagedType.U4)] ref uint StepParam2, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmCmd_Delay) (t_i32 NetID, t_i32 LmMapIndex, t_i32 DelayTime_ms, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmLmCmd_Delay(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int LmMapIndex,
            [MarshalAs(UnmanagedType.I4)] int DelayTime_ms,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmLmResetAll);
        [DllImport(dll)]
        public static extern unsafe void ecmLmResetAll(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        
        //====================== MOTION - PT-Motion FUNCTIONS ============================================//

        //EC_EXTERN t_success	(CECAT_API *ecmPtmResetAll) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmPtmResetAll(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_success	(CECAT_API *ecmPtmCtl_Begin) (t_i32 NetID, t_i32 PtmMapIndex, t_ui32 AxisMask1, t_ui32 AxisMask2, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmPtmCtl_Begin(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int PtmMapIndex,
            [MarshalAs(UnmanagedType.U4)] uint AxisMask1,
            [MarshalAs(UnmanagedType.U4)] uint AxisMask2, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmPtmCtl_End) (t_i32 NetID, t_i32 PtmMapIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmPtmCtl_End(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int PtmMapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmPtmCtl_SetHold) (t_i32 NetID, t_i32 PtmMapIndex, t_bool IsHold, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmPtmCtl_SetHold(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int PtmMapIndex,
            [MarshalAs(UnmanagedType.I1)] bool IsHold,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecmPtmCmd_AddItem_PT) (t_i32 NetID, t_i32 PtmMapIndex, t_f64 DurTime, t_f64 PosDataList[], t_i32 NumPosData, t_bool IsAbsPos, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmPtmCmd_AddItem_PT(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int PtmMapIndex, 
            [MarshalAs(UnmanagedType.R8)] double DurTime, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] PosDataList, 
            [MarshalAs(UnmanagedType.I4)] int NumPosData, 
            [MarshalAs(UnmanagedType.I1)] bool IsAbsPos, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN EEcmPtmSts (CECAT_API *ecmPtmSt_GetRunSts) (t_i32 NetID, t_i32 PtmMapIndex, t_i32 *RunStepCount, t_i32 *RemStepCount, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe EEcmPtmSts ecmPtmSt_GetRunSts(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int PtmMapIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int runStepCount,
            [MarshalAs(UnmanagedType.I4)] ref int RemStepCount,            
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecmPtmSt_GetRunStepInfo) (t_i32 NetID, t_i32 PtmMapIndex, t_i32 *RunStepCount, t_i32 *RunStepSts, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecmPtmSt_GetRunStepInfo(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int PtmMapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int RunStepCount,
            [MarshalAs(UnmanagedType.I4)] ref int RunStepSts, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        ////====================== GENERAL FUNCTIONS ==============================================================//

        //EC_EXTERN t_success (CECAT_API *ecGn_SetBootWaitMode) (t_bool IsWaitBootCompt, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_SetBootWaitMode(
            [MarshalAs(UnmanagedType.I1)] bool IsWaitBootCompt, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecGn_GetBootWaitMode) (t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_GetBootWaitMode(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //====================== NET INTERFACE FUNCTIONS =========================================================//


        //EC_EXTERN void*		(CECAT_API *ecNet_InPDO_GetBufPtr) (t_i32 NetID, t_i32 OfsPos, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe IntPtr ecNet_InPDO_GetBufPtr(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int OfsPos, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecNet_InPDO_GetData) (t_i32 NetID, t_i32 OfsPos, t_ui16 Size, void *pBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecNet_InPDO_GetData(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int OfsPos, 
            [MarshalAs(UnmanagedType.U2)] ushort Size, 
            ref IntPtr pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_byte	(CECAT_API *ecNet_InPDO_GetData_B) (t_i32 NetID, t_i32 OfsPos, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe byte ecNet_InPDO_GetData_B(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int OfsPos, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_word	(CECAT_API *ecNet_InPDO_GetData_W) (t_i32 NetID, t_i32 OfsPos, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe ushort ecNet_InPDO_GetData_W(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int OfsPos, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword	(CECAT_API *ecNet_InPDO_GetData_D) (t_i32 NetID, t_i32 OfsPos, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecNet_InPDO_GetData_D(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int OfsPos, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN void*		(CECAT_API *ecNet_OutPDO_GetBufPtr) (t_i32 NetID, t_i32 OfsPos, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe IntPtr ecNet_OutPDO_GetBufPtr(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int OfsPos, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecNet_OutPDO_SetData) (t_i32 NetID, t_i32 OfsPos, t_ui16 Size, void *pBuf, t_i32 *ErrCode);
        //[DllImport(dll, EntryPoint = "ecNet_OutPDO_SetData")]
        //public static extern unsafe int ecNet_OutPDO_SetData(
        //    [MarshalAs(UnmanagedType.I4)] int NetID, 
        //    [MarshalAs(UnmanagedType.I4)] int OfsPos, 
        //    [MarshalAs(UnmanagedType.U2)] ushort Size, 
        //    ref IntPtr pBuf, 
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        //DLL에 없음

        //EC_EXTERN t_success	(CECAT_API *ecNet_OutPDO_SetData_B) (t_i32 NetID, t_i32 OfsPos, t_byte Data, t_i32 *ErrCode);
        //[DllImport(dll, EntryPoint = "ecNet_OutPDO_SetData_B")]
        //[return: MarshalAs(UnmanagedType.I1)]
        //public static extern unsafe bool ecNet_OutPDO_SetData_B(
        //    [MarshalAs(UnmanagedType.I4)] int NetID, 
        //    [MarshalAs(UnmanagedType.I4)] int OfsPos,
        //    [MarshalAs(UnmanagedType.U1)] byte Data, 
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        //DLL에 없음

        //EC_EXTERN t_success	(CECAT_API *ecNet_OutPDO_SetData_W) (t_i32 NetID, t_i32 OfsPos, t_word Data, t_i32 *ErrCode);
        //[DllImport(dll)]
        //[return: MarshalAs(UnmanagedType.I1)]
        //public static extern unsafe bool ecNet_OutPDO_SetData_W(
        //    [MarshalAs(UnmanagedType.I4)] int NetID, 
        //    [MarshalAs(UnmanagedType.I4)] int OfsPos,
        //    [MarshalAs(UnmanagedType.U2)] ushort Data, 
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        //DLL에 없음

        //EC_EXTERN t_success	(CECAT_API *ecNet_OutPDO_SetData_D) (t_i32 NetID, t_i32 OfsPos, t_dword Data, t_i32 *ErrCode);
        //[DllImport(dll)]
        //[return: MarshalAs(UnmanagedType.I1)]
        //public static extern unsafe bool ecNet_OutPDO_SetData_D(
        //    [MarshalAs(UnmanagedType.I4)] int NetID,
        //    [MarshalAs(UnmanagedType.I4)] int OfsPos, 
        //    [MarshalAs(UnmanagedType.U4)] uint Data, 
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        //DLL에 없음


        //====================== SLAVE I/F FUNCTIONS ============================================================//

        //EC_EXTERN void*		(CECAT_API *ecSlv_InPDO_GetBufPtr) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 PdoIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe IntPtr  ecSlv_InPDO_GetBufPtr(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr, 
            [MarshalAs(UnmanagedType.U1)] byte PdoIndex,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_i32			(CECAT_API *ecSlv_InPDO_GetOffset) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 InPdoUnitIdx, int *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_InPDO_GetOffset(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U1)] byte InPdoUnitIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecSlv_InPDO_GetBufLen) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 InPdoUnitIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_InPDO_GetBufLen(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr, 
            [MarshalAs(UnmanagedType.U1)] byte PdoIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN void*		(CECAT_API *ecSlv_OutPDO_GetBufPtr) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 PdoIndex, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe IntPtr ecSlv_OutPDO_GetBufPtr(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U1)] byte PdoIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_i32			(CECAT_API *ecSlv_OutPDO_GetOffset) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, int *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_OutPDO_GetOffset(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U1)] byte OutPdoUnitIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecSlv_OutPDO_GetBufLen) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_OutPDO_GetBufLen(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U1)] byte PdoIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecSlv_OutPDO_SetInitValMode) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 OutPDOInitMode, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_OutPDO_SetInitValMode(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U1)] byte OutPdoUnitIdx,
            [MarshalAs(UnmanagedType.I4)] int OutPDOInitMode, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecSlv_OutPDO_GetInitValMode) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_OutPDO_GetInitValMode(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U1)] byte OutPdoUnitIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecSlv_OutPDO_SetInitVal) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 OfsPos, t_i32 DataSize, void *pData, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_OutPDO_SetInitVal(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U1)] byte OutPdoUnitIdx,
            [MarshalAs(UnmanagedType.I4)] int OfsPos,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        ////EC_EXTERN t_i32			(CECAT_API *ecSlv_OutPDO_GetInitVal) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 OfsPos, t_i32 BufSize, void *pBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_OutPDO_GetInitVal(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U1)] byte OutPdoUnitIdx,
            [MarshalAs(UnmanagedType.I4)] int OfsPos,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        
        //*****************************************************************************************************************************
        //*
        //*							Functions for Advanced Users
        //*
        //*****************************************************************************************************************************

        //====================== NET INTERFACE FUNCTIONS =========================================================//

        //EC_EXTERN t_success (CECAT_API *ecNet_SetFastFuncType) (t_i32 NetID, t_ui8 FastCmdType, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_SetFastFuncType(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int FastCmdType, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui8		(CECAT_API *ecNet_GetFastFuncType) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecNet_GetFastFuncType(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecNet_InPDO_GetSectPos) (t_i32 NetID, t_ui16 SectionID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecNet_InPDO_GetSectPos(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SectionID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecNet_OutPDO_GetSectPos) (t_i32 NetID, t_ui16 SectionID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecNet_OutPDO_GetSectPos(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SectionID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecNet_InQue_ClearChanList) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_ClearChanList(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN HANDLE 	(CECAT_API *ecNet_InQue_AddChannel) (t_i32 NetID, TEcInQueDataDesc *pDataDescList, int NumDataDescLisItems, t_i32 QueBufDepth, t_bool IsCircular, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecNet_InQue_AddChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            ref TEcInQueDataDesc pDataDescList, 
            [MarshalAs(UnmanagedType.I4)] int NumDataDescLisItems, 
            [MarshalAs(UnmanagedType.I4)] int QueBufDepth, 
            [MarshalAs(UnmanagedType.I1)] bool IsCircular,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_InQue_DelChannel) (t_i32 NetID, HANDLE QueChanHandle, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_DelChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecNet_InQue_GetNumDataDescItems) (t_i32 NetID, HANDLE QueChanHandle, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecNet_InQue_GetNumDataDescItems(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecNet_InQue_GetDataDesc) (t_i32 NetID, HANDLE QueChanHandle, t_i32 ItemIndex, TEcInQueDataDesc *pDataDesc, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_GetDataDesc(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle, 
            [MarshalAs(UnmanagedType.I4)] int ItemIndex, 
            ref TEcInQueDataDesc pDataDesc,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecNet_InQue_GetQueSizeInfo)	(t_i32 NetID, HANDLE QueChanHandle, t_i32 *QueItemSize, t_i32 *QueBufDepth, t_bool *IsCircular, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_GetQueSizeInfo(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle,
            [MarshalAs(UnmanagedType.I4)] ref int QueItemSize, 
            [MarshalAs(UnmanagedType.I4)] ref int QueBufDepth,
            [MarshalAs(UnmanagedType.I1)] ref bool IsCircular,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_InQue_SetStaTrgEnv) (t_i32 NetID, HANDLE QueChanHandle, TEcInQueTrgCfg *pTrgCfgData, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_SetStaTrgEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle,
            ref TEcInQueTrgCfg pTrgCfgData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_InQue_GetStaTrgEnv) (t_i32 NetID, HANDLE QueChanHandle, TEcInQueTrgCfg *pTrgCfgBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_GetStaTrgEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle, 
            ref TEcInQueTrgCfg pTrgCfgBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_InQue_SetStopTrgEnv) (t_i32 NetID, HANDLE QueChanHandle, TEcInQueTrgCfg *pTrgCfgData, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_SetStopTrgEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle, 
            ref TEcInQueTrgCfg pTrgCfgData, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_InQue_GetStopTrgEnv) (t_i32 NetID, HANDLE QueChanHandle, TEcInQueTrgCfg *pTrgCfgBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_GetStopTrgEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle, 
            ref TEcInQueTrgCfg pTrgCfgBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_InQue_StartChannel) (t_i32 NetID, HANDLE QueChanHandle, t_i32 SamplingInterval, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_GetStopTrgEnv(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle,
            [MarshalAs(UnmanagedType.I4)] int SamplingInterval, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_InQue_StopChannel) (t_i32 NetID, HANDLE QueChanHandle, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_StopChannel(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32 	(CECAT_API *ecNet_InQue_GetQueuedCount) (t_i32 NetID, HANDLE QueChanHandle, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecNet_InQue_GetQueuedCount(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32 	(CECAT_API *ecNet_InQue_Deque) (t_i32 NetID, HANDLE QueChanHandle, void *pBuf, int nBufSize, t_i32 ReqDequeCnt, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecNet_InQue_Deque(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle, 
            ref IntPtr pBuf, 
            [MarshalAs(UnmanagedType.I4)] int nBufSize,
            [MarshalAs(UnmanagedType.I4)] int ReqDequeCnt,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32 	(CECAT_API *ecNet_InQue_PeekData) (t_i32 NetID, HANDLE QueChanHandle, void *pBuf, int nBufSize, int nStartIndex, t_i32 ReqPeekCnt, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecNet_InQue_PeekData(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int QueChanHandle, 
            ref IntPtr pBuf, 
            [MarshalAs(UnmanagedType.I4)] int nBufSize, 
            [MarshalAs(UnmanagedType.I4)] int nStartIndex,
            [MarshalAs(UnmanagedType.I4)] int ReqPeekCnt, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN HANDLE	(CECAT_API *ecNet_InQue_AddCommonTrg) (t_i32 NetID, TEcInQueCommonTrg *pCommonTrgObj, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecNet_InQue_AddCommonTrg(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            ref TEcInQueCommonTrg pCommonTrgObj, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_InQue_DelCommonTrg) (t_i32 NetID, HANDLE CommTrgHandle, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_DelCommonTrg(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int CommTrgHandle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_InQue_EnableCommonTrg) (t_i32 NetID, HANDLE CommTrgHandle, t_bool IsEanble, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_EnableCommonTrg(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int CommTrgHandle, 
            [MarshalAs(UnmanagedType.I1)] bool IsEanble,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_InQue_SetCommonTrgState) (t_i32 NetID, HANDLE CommTrgHandle, t_bool State, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_InQue_SetCommonTrgState(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int CommTrgHandle, 
            [MarshalAs(UnmanagedType.I1)] bool State, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_pdoidx	(CECAT_API *ecNet_GetLastPDOIdx) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecNet_GetLastPDOIdx(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecNet_IsPDOIdxCompt) (t_i32 NetID, t_pdoidx PDOIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_IsPDOIdxCompt(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int PDOIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecNet_WaitPDOIdxCompt) (t_i32 NetID, t_pdoidx PDOIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_WaitPDOIdxCompt(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int PDOIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecNet_WaitPDOIdxCompt_NB) (t_i32 NetID, t_pdoidx PDOIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_WaitPDOIdxCompt_NB
            ([MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int PDOIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecNet_IsCmdIdxCompt) (t_i32 NetID, t_cmdidx CmdIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_IsCmdIdxCompt(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int CmdIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecNet_WaitCmdIdxCompt) (t_i32 NetID, t_cmdidx CmdIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_WaitCmdIdxCompt(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int CmdIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecNet_WaitCmdIdxCompt_NB) (t_i32 NetID, t_cmdidx CmdIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_WaitCmdIdxCompt_NB(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int CmdIdx,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_ui32	(CECAT_API *ecNet_GetCycleProcessTime) (t_i32 NetID, t_ui8 ProcTimeType, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecNet_GetCycleProcessTime(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U1)] byte ProcTimeType, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        //====================== ECAT CONFIG FUNCTIONS ==========================================================//

        //EC_EXTERN t_success (CECAT_API *ecCfgFile_Download) (t_i32 DevIdx, char *szFilePath, EEcLocNetSel LocNetSel, t_i32 *ErrCode);
        [DllImport(dll, ThrowOnUnmappableChar = true, BestFitMapping = false)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfgFile_Download(
            //[MarshalAs(UnmanagedType.I1)] ref char[] szFilePath,
            [MarshalAs(UnmanagedType.LPStr)] string szFilePath,
            [MarshalAs(UnmanagedType.I4)] int DevIdx,
            [MarshalAs(UnmanagedType.I4)] int LocNetSel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecCfgFile_Verify) (t_i32 DevIdx, char *szFilePath, EEcLocNetSel LocNetSel, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfgFile_Verify(
            [MarshalAs(UnmanagedType.I4)] int DevIdx,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szFilePath,
            EEcLocNetSel LocNetSel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);





        //*****************************************************************************************************************************
        //*
        //*							Functions for public System Users
        //*
        //*****************************************************************************************************************************


        //====================== GENERAL FUNCTIONS ==============================================================//


        //EC_EXTERN ULONG		(CECAT_API *ecGn_GetDebugData) (t_i32 DevIdx, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecGn_GetDebugData(
            [MarshalAs(UnmanagedType.I4)] int DevIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_OutpB) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_byte Data, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_OutpB(
            [MarshalAs(UnmanagedType.I4)] int DevIdx,
            [MarshalAs(UnmanagedType.I4)] int CS, 
            [MarshalAs(UnmanagedType.I4)] int intOffset, 
            [MarshalAs(UnmanagedType.U1)] byte Data, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_OutpsB) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_i32 Count, t_byte* pData, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_OutpsB(
            [MarshalAs(UnmanagedType.I4)] int DevIdx, 
            [MarshalAs(UnmanagedType.I4)] int CS,
            [MarshalAs(UnmanagedType.I4)] int intOffset, 
            [MarshalAs(UnmanagedType.I4)] int Count, 
            [MarshalAs(UnmanagedType.U1)] ref byte pData, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_OutpW) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_word Data, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_OutpW(
            [MarshalAs(UnmanagedType.I4)] int DevIdx,
            [MarshalAs(UnmanagedType.I4)] int CS, 
            [MarshalAs(UnmanagedType.I4)] int intOffset,
            [MarshalAs(UnmanagedType.U2)] ushort Data, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_OutpsW) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_i32 Count, t_word* pData, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_OutpsW(
            [MarshalAs(UnmanagedType.I4)] int DevIdx, 
            [MarshalAs(UnmanagedType.I4)] int CS, 
            [MarshalAs(UnmanagedType.I4)] int intOffset, 
            [MarshalAs(UnmanagedType.I4)] int Count, 
            [MarshalAs(UnmanagedType.U2)] ref ushort pData, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_OutpD) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_dword Data, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_OutpD(
            [MarshalAs(UnmanagedType.I4)] int DevIdx, 
            [MarshalAs(UnmanagedType.I4)] int CS, 
            [MarshalAs(UnmanagedType.I4)] int intOffset,
            [MarshalAs(UnmanagedType.U4)] uint Data, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_OutpsD) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_i32 Count, t_dword* pData, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_OutpsD(
            [MarshalAs(UnmanagedType.I4)] int DevIdx,
            [MarshalAs(UnmanagedType.I4)] int CS,
            [MarshalAs(UnmanagedType.I4)] int intOffset,
            [MarshalAs(UnmanagedType.I4)] int Count, 
            [MarshalAs(UnmanagedType.U4)] ref uint pData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_byte	(CECAT_API *ecGn_InpB) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe byte ecGn_InpB(
            [MarshalAs(UnmanagedType.I4)] int DevIdx, 
            [MarshalAs(UnmanagedType.I4)] int CS, 
            [MarshalAs(UnmanagedType.I4)] int intOffset,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_InpsB) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_i32 Count, t_byte* pBuffer, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_InpsB(
            [MarshalAs(UnmanagedType.I4)] int DevIdx,
            [MarshalAs(UnmanagedType.I4)] int CS, 
            [MarshalAs(UnmanagedType.I4)] int intOffset, 
            [MarshalAs(UnmanagedType.I4)] int Count, 
            [MarshalAs(UnmanagedType.U1)] ref byte pBuffer, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_word	(CECAT_API *ecGn_InpW) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe ushort ecGn_InpW(
            [MarshalAs(UnmanagedType.I4)] int DevIdx, 
            [MarshalAs(UnmanagedType.I4)] int CS, 
            [MarshalAs(UnmanagedType.I4)] int intOffset, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_InpsW) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_i32 Count, t_word* pBuffer, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_InpsW(
            [MarshalAs(UnmanagedType.I4)] int DevIdx,
            [MarshalAs(UnmanagedType.I4)] int CS,
            [MarshalAs(UnmanagedType.I4)] int intOffset, 
            [MarshalAs(UnmanagedType.I4)] int Count, 
            [MarshalAs(UnmanagedType.U2)] ref ushort pBuffer, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword	(CECAT_API *ecGn_InpD) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecGn_InpD(
            [MarshalAs(UnmanagedType.I4)] int DevIdx,
            [MarshalAs(UnmanagedType.I4)] int CS, 
            [MarshalAs(UnmanagedType.I4)] int intOffset,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_InpsD) (t_i32 DevIdx, t_i32 CS, t_i32 intOffset, t_i32 Count, t_dword* pBuffer, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_InpsD(
            [MarshalAs(UnmanagedType.I4)] int DevIdx, 
            [MarshalAs(UnmanagedType.I4)] int CS,
            [MarshalAs(UnmanagedType.I4)] int intOffset, 
            [MarshalAs(UnmanagedType.I4)] int Count, 
            [MarshalAs(UnmanagedType.U4)] ref uint pBuffer, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_DbgTempCmd) (t_i32 DevIdx, t_i32 Data1, t_i32 Data2, t_i32 Data3, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_DbgTempCmd(
            [MarshalAs(UnmanagedType.I4)] int DevIdx,
            [MarshalAs(UnmanagedType.I4)] int Data1,
            [MarshalAs(UnmanagedType.I4)] int Data2,
            [MarshalAs(UnmanagedType.I4)] int Data3,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecGn_ReadInPDO) (t_i32 NetID, t_ui32 StartAddr, t_ui32 Size, void* pBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_ReadInPDO(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint StartAddr,
            [MarshalAs(UnmanagedType.U4)] uint Size, 
            ref IntPtr pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecGn_ReadDspDbgData_I) (t_i32 NetID, t_ui8 DspCoreIdx, t_ui16 IniArrayIdx, t_ui16 NumData, t_i32* pBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I4)]
        public static extern unsafe int ecGn_ReadDspDbgData_I(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U1)] byte DspCoreIdx,
            [MarshalAs(UnmanagedType.U2)] ushort IniArrayIdx,
            [MarshalAs(UnmanagedType.U2)] ushort NumData,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecGn_WriteDspDbgData_I) (t_i32 NetID, t_ui8 DspCoreIdx, t_ui16 IniArrayIdx, t_ui16 NumData, t_i32* pBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I4)]
        public static extern unsafe int ecGn_WriteDspDbgData_I(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U1)] byte DspCoreIdx,
            [MarshalAs(UnmanagedType.U2)] ushort IniArrayIdx,
            [MarshalAs(UnmanagedType.U2)] ushort NumData,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecGn_ReadDspDbgData_F) (t_i32 NetID, t_ui8 DspCoreIdx, t_ui16 IniArrayIdx, t_ui16 NumData, t_f64* pBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I4)]
        public static extern unsafe int ecGn_ReadDspDbgData_F(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U1)] byte DspCoreIdx,
            [MarshalAs(UnmanagedType.U2)] ushort IniArrayIdx,
            [MarshalAs(UnmanagedType.U2)] ushort NumData,
            [MarshalAs(UnmanagedType.R8)] ref double pBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecGn_WriteDspDbgData_F) (t_i32 NetID, t_ui8 DspCoreIdx, t_ui16 IniArrayIdx, t_ui16 NumData, t_f64* pBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I4)]
        public static extern unsafe int ecGn_WriteDspDbgData_F(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U1)] byte DspCoreIdx,
            [MarshalAs(UnmanagedType.U2)] ushort IniArrayIdx,
            [MarshalAs(UnmanagedType.U2)] ushort NumData,
            [MarshalAs(UnmanagedType.R8)] ref double pBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //public static bool ecGn_InitFromFile(int netID, int axisCount, string filePath, ref int errorCode)
        //{
        //    try
        //    {
        //        XmlDocument xdoc = new XmlDocument();
        //        xdoc.Load(filePath);

        //        byte[] axisList = new byte[axisCount];
        //        ecmGn_GetAxisList(netID, axisList, (byte)axisCount, ref errorCode);

        //        int tempInt = 0;
        //        int tempInt2 = 0;
        //        double tempDouble = 0;
        //        double tempDouble2 = 0;
        //        bool tempBool = false;
        //        //bool tempBool2 = false;

        //        int speedMode = 0;
        //        double workSpeed = 0;
        //        double accel = 0;
        //        double decel = 0;
        //        double init = 0;
        //        double end = 0;
        //        double reverseSpeed = 0;
        //        double jerk = 0;

        //        XmlNode deviceNode = xdoc.SelectSingleNode(string.Format("descendant::Devices/Device[@Type='{0}' and @ID='{1}']", "EtherCAT", netID));
        //        if (deviceNode == null)
        //        {
        //            errorCode = -30000;
        //            return false;
        //        }

        //        XmlNode devNode = deviceNode.ChildNodes[0].SelectSingleNode(string.Format("descendant::Motion[@ID='{0}']", 0));

        //        for (int axis = 0; axis < axisCount; axis++)
        //        {
        //            XmlNode axisNode = devNode.ChildNodes[1].SelectSingleNode(string.Format("descendant::Axis[@ID='{0}']", axisList[axis]));
        //            if (axisNode == null)
        //                continue;

        //            if (axisNode.SelectSingleNode("UnitDistance") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("UnitDistance").InnerText, out tempDouble))
        //                {
        //                    errorCode = -31001;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmSxCfg_SetUnitDist(netID, axisList[axis], tempDouble, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = - 31101;

        //            if (axisNode.SelectSingleNode("UnitSpeed") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("UnitSpeed").InnerText, out tempDouble))
        //                {
        //                    errorCode = -31002;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmSxCfg_SetUnitSpeed(netID, axisList[axis], tempDouble, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31102;

        //            if (axisNode.SelectSingleNode("SpeedMode") != null)
        //            {
        //                if (!int.TryParse(axisNode.SelectSingleNode("SpeedMode").InnerText, out speedMode))
        //                {
        //                    errorCode = -31000;
        //                    return false;
        //                }
        //            }

        //            if (axisNode.SelectSingleNode("WorkSpeed") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("WorkSpeed").InnerText, out workSpeed))
        //                {
        //                    errorCode = -31003;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31103;

        //            if (axisNode.SelectSingleNode("Accel") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("Accel").InnerText, out accel))
        //                {
        //                    errorCode = -31004;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31104;

        //            if (axisNode.SelectSingleNode("Decel") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("Decel").InnerText, out decel))
        //                {
        //                    errorCode = -31005;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31105;

        //            if (axisNode.SelectSingleNode("Init") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("Init").InnerText, out init))
        //                {
        //                    errorCode = -31006;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31106;

        //            if (axisNode.SelectSingleNode("EndSpeed") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("EndSpeed").InnerText, out end))
        //                {
        //                    errorCode = -31007;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31107;
                                        
        //            ecmSxCfg_SetSpeedPatt(netID, axisList[axis], speedMode, init, end, workSpeed, accel, decel, ref errorCode);
        //            if(errorCode != 0) 
        //                return false;

        //            if (axisNode.SelectSingleNode("Jerk") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("Jerk").InnerText, out jerk))
        //                {
        //                    errorCode = -31008;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmSxCfg_SetJerkRatio(netID, axisList[axis], jerk, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31108;

        //            if (axisNode.SelectSingleNode("HomeMode") != null)
        //            {
        //                if (!int.TryParse(axisNode.SelectSingleNode("HomeMode").InnerText, out tempInt))
        //                {
        //                    errorCode = -31009;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmHomeCfg_SetMode(netID, axisList[axis], tempInt, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31109;

        //            if (axisNode.SelectSingleNode("HomeSpeedMode") != null)
        //            {
        //                if (!int.TryParse(axisNode.SelectSingleNode("HomeSpeedMode").InnerText, out speedMode))
        //                {
        //                    errorCode = -31010;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31111;

        //            if (axisNode.SelectSingleNode("HomeWorkSpeed") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("HomeWorkSpeed").InnerText, out workSpeed))
        //                {
        //                    errorCode = -31012;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31112;

        //            if (axisNode.SelectSingleNode("HomeAccSpeed") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("HomeAccSpeed").InnerText, out accel))
        //                {
        //                    errorCode = -31000;
        //                    return false;
        //                }
        //            }

        //            if (axisNode.SelectSingleNode("HomeDecSpeed") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("HomeDecSpeed").InnerText, out decel))
        //                {
        //                    errorCode = -31013;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31113;

        //            if (axisNode.SelectSingleNode("HomeReverseSpeed") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("HomeReverseSpeed").InnerText, out reverseSpeed))
        //                {
        //                    errorCode = -31014;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31114;

        //            ecmHomeCfg_SetSpeedPatt(netID, axisList[axis], speedMode, workSpeed, accel, decel, reverseSpeed, ref errorCode);
        //            if(errorCode != 0)
        //                return false;

        //            if (axisNode.SelectSingleNode("HomeOffset") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("HomeOffset").InnerText, out tempDouble))
        //                {
        //                    errorCode = -31015;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmHomeCfg_SetOffset(netID, axisList[axis], tempDouble, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31115;

        //            if (axisNode.SelectSingleNode("TouchProbeEdge") != null)
        //            {
        //                if (!int.TryParse(axisNode.SelectSingleNode("TouchProbeEdge").InnerText, out tempInt))
        //                {
        //                    errorCode = -31016;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmHomeCfg_SetOption(netID, axisList[axis], EEcmHomeOptID.ecmHOID_TPROB_EDGE_SEL, tempInt, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31116;

        //            if (axisNode.SelectSingleNode("RingCounterDirection") != null)
        //            {
        //                if (!int.TryParse(axisNode.SelectSingleNode("RingCounterDirection").InnerText, out tempInt))
        //                {
        //                    errorCode = -31017;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmSxCfg_Ring_SetDirMode(netID, axisList[axis], tempInt, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31117;

        //            if (axisNode.SelectSingleNode("RingCounterMaxValue") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("RingCounterMaxValue").InnerText, out tempDouble))
        //                {
        //                    errorCode = -31018;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmSxCfg_Ring_SetPosRange(netID, axisList[axis], tempDouble, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31118;

        //            if (axisNode.SelectSingleNode("RingCounterEnable") != null)
        //                tempBool = axisNode.SelectSingleNode("RingCounterEnable").InnerText.Equals("True");
        //            else
        //                errorCode = -31119;

        //            ecmSxCfg_Ring_SetEnable(netID, axisList[axis], tempBool, ref errorCode);
        //            if (errorCode != 0)
        //                return false;

        //            if (axisNode.SelectSingleNode("ControlMode") != null)
        //            {
        //                if (!int.TryParse(axisNode.SelectSingleNode("ControlMode").InnerText, out tempInt))
        //                {
        //                    errorCode = -31020;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmSxCfg_SetOperMode(netID, axisList[axis], (EEcmOperMode)(tempInt + 8), ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31120;

        //            if (axisNode.SelectSingleNode("SoftLimitEnable") != null)
        //                tempInt = axisNode.SelectSingleNode("SoftLimitEnable").InnerText.Equals("True") ? 1: 0;
        //            else
        //                errorCode = -31121;

        //            if (axisNode.SelectSingleNode("SoftLimitStopMode") != null)
        //                tempInt2 = axisNode.SelectSingleNode("SoftLimitStopMode").InnerText.Equals("True") ? 1 : 0;
        //            else
        //                errorCode = -31122;

        //            if (axisNode.SelectSingleNode("SoftLimitNValue") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("SoftLimitNValue").InnerText, out tempDouble))
        //                {
        //                    errorCode = -31023;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31123;

        //            if (axisNode.SelectSingleNode("SoftLimitPValue") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("SoftLimitPValue").InnerText, out tempDouble2))
        //                {
        //                    errorCode = -31024;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31124;
                                        
        //            ecmSxCfg_SetSoftLimit(netID, axisList[axis], tempInt, tempDouble, tempDouble2, tempInt2, ref errorCode);
        //            if (errorCode != 0)
        //                return false;

        //            if (axisNode.SelectSingleNode("NotIgnore") != null)
        //            {
        //                tempBool = axisNode.SelectSingleNode("NotIgnore").InnerText.Equals("True");
        //                ecmSxCfg_SetMioProp(netID, axisList[axis], EEcmMioPropId.ecmMPID_IGNORE_ELN, tempBool ? 1 : 0, ref errorCode);
        //            }
        //            else
        //                errorCode = -31125;

        //            if (axisNode.SelectSingleNode("PotIgnore") != null)
        //            {
        //                tempBool = axisNode.SelectSingleNode("PotIgnore").InnerText.Equals("True");
        //                ecmSxCfg_SetMioProp(netID, axisList[axis], EEcmMioPropId.ecmMPID_IGNORE_ELP, tempBool ? 1 : 0, ref errorCode);
        //            }
        //            else
        //                errorCode = -31126;

        //            if (axisNode.SelectSingleNode("NotSignalType") != null)
        //            {
        //                if (!int.TryParse(axisNode.SelectSingleNode("NotSignalType").InnerText, out tempInt))
        //                {
        //                    errorCode = -31027;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmSxCfg_SetMioProp(netID, axisList[axis], EEcmMioPropId.ecmMPID_ELN_INPUT_SEL, tempInt, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31127;

        //            if (axisNode.SelectSingleNode("PotSignalType") != null)
        //            {
        //                if (!int.TryParse(axisNode.SelectSingleNode("PotSignalType").InnerText, out tempInt))
        //                {
        //                    errorCode = -31028;
        //                    return false;
        //                }
        //                else
        //                {
        //                    ecmSxCfg_SetMioProp(netID, axisList[axis], EEcmMioPropId.ecmMPID_ELP_INPUT_SEL, tempInt, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31128;

        //            if (axisNode.SelectSingleNode("AlarmStopMode") != null)
        //            {
        //                tempBool = axisNode.SelectSingleNode("AlarmStopMode").InnerText.Equals("True");
        //                ecmSxCfg_SetMioProp(netID, axisList[axis], EEcmMioPropId.ecmMPID_ALM_STOP_MODE, tempBool ? 1 : 0, ref errorCode);
        //                if (errorCode != 0)
        //                    return false;
        //            }
        //            else
        //                errorCode = -31129;

        //            if (axisNode.SelectSingleNode("ELStopMode") != null)
        //            {
        //                tempBool = axisNode.SelectSingleNode("ELStopMode").InnerText.Equals("True");
        //                ecmSxCfg_SetMioProp(netID, axisList[axis], EEcmMioPropId.ecmMPID_EL_STOP_MODE, tempBool ? 1 : 0, ref errorCode);
        //                if (errorCode != 0)
        //                    return false;
        //            }
        //            else
        //                errorCode = -31130;

        //            if (axisNode.SelectSingleNode("InpositionEnalbe") != null)
        //            {
        //                tempBool = axisNode.SelectSingleNode("InpositionEnalbe").InnerText.Equals("True");
        //                ecmSxCfg_SetMioProp(netID, axisList[axis], EEcmMioPropId.ecmMPID_INP_ENABLE, tempBool ? 1 : 0, ref errorCode);
        //                if (errorCode != 0)
        //                    return false;
        //            }
        //            else
        //                errorCode = -31131;

        //            if (axisNode.SelectSingleNode("MasterInpositionRange") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("MasterInpositionRange").InnerText, out tempDouble))
        //                {
        //                    errorCode = -31032;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31132;

        //            if (axisNode.SelectSingleNode("MasterInpositionEnable") != null)
        //            {
        //                tempBool = axisNode.SelectSingleNode("MasterInpositionEnable").InnerText.Equals("True");
        //                ecmSxCfg_SetMastInp(netID, axisList[axis], tempBool, tempDouble, ref errorCode);
        //                if (errorCode != 0)
        //                    return false;
        //            }
        //            else
        //                errorCode = -31133;

        //            if (axisNode.SelectSingleNode("MasterAxis") != null)
        //            {
        //                if (!int.TryParse(axisNode.SelectSingleNode("MasterAxis").InnerText, out tempInt))
        //                {
        //                    errorCode = -31033;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31133;

        //            if (axisNode.SelectSingleNode("MasterSlaveRatio") != null)
        //            {
        //                if (!double.TryParse(axisNode.SelectSingleNode("MasterSlaveRatio").InnerText, out tempDouble))
        //                {
        //                    errorCode = -31034;
        //                    return false;
        //                }
        //            }
        //            else
        //                errorCode = -31134;

        //            if (axisNode.SelectSingleNode("MasterSlaveEnable") != null)
        //            {
        //                if (!int.TryParse(axisNode.SelectSingleNode("MasterSlaveEnable").InnerText, out tempInt2))
        //                {
        //                    errorCode = -31035;
        //                    return false;
        //                }

        //                if(tempInt2 == 1)
        //                {
        //                    ecmMsCfg_SetSlvEnv(netID, axisList[axis], tempInt, tempDouble, ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;

        //                    ecmMsCtl_StartSlv(netID, axisList[axis], ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //                else
        //                {
        //                    ecmMsCtl_StopSlv(netID, axisList[axis], ref errorCode);
        //                    if (errorCode != 0)
        //                        return false;
        //                }
        //            }
        //            else
        //                errorCode = -31135;
        //        }
        //    }
        //    catch
        //    {
        //        throw;
        //    }
        //    return true;
        //}


        //====================== NET INTERFACE FUNCTIONS =========================================================//


        //EC_EXTERN t_success (CECAT_API *ecNet_SetEnableSTM) (t_i32 NetID, t_bool IsEnable, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecNet_SetEnableSTM")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_SetEnableSTM(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I1)] bool IsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        //EC_EXTERN t_cmdidx	(CECAT_API *ecNet_SendRcvEcatCmd) (t_i32 NetID, EEcEcatCmd EcatCmd, t_ui16 ADP, t_ui16 ADO, t_ui16 DataSize, t_byte *pDataBuf, t_ui32 Timeout, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe uint ecNet_SendRcvEcatCmd(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            EEcEcatCmd EcatCmd,
            [MarshalAs(UnmanagedType.U2)] ushort ADP, 
            [MarshalAs(UnmanagedType.U2)] ushort ADO, 
            [MarshalAs(UnmanagedType.U2)] ushort DataSize, 
            [MarshalAs(UnmanagedType.U1)] ref byte pDataBuf,
            [MarshalAs(UnmanagedType.U4)] uint Timeout,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_FWDnld_Process) (t_i32 NetID, t_char szFilePath[], t_bool IsVerify, t_i32 *ErrCode);
        [DllImport(dll, CharSet = CharSet.Unicode, BestFitMapping = false)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_FWDnld_Process(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.LPStr)] string szfilePath,
            [MarshalAs(UnmanagedType.I1)] bool IsVerify,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_FWDnld_Cancel) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_FWDnld_Cancel(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_FWDnld_GetSts) (t_i32 NetID, TEcFwuStatus *pStsBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_FWDnld_GetSts(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            ref TEcFwuStatus pStsBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_FWDnld_ResetSts) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_FWDnld_ResetSts(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_FWUpld_GetFileInfo) (t_i32 NetID, TEcFwuFileInfo *pFileInfo, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_FWUpld_GetFileInfo(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            ref TEcFwuFileInfo pFileInfo, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_FWUpld_Process) (t_i32 NetID, t_char szFilePath[], t_i32 *ErrCode);
        [DllImport(dll, CharSet = CharSet.Unicode, BestFitMapping = false)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_FWUpld_Process(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.LPStr)] string szfilePath,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_FWUpld_Cancel) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_FWUpld_Cancel(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_FWUpld_GetSts) (t_i32 NetID, TEcFwuStatus *pStsBuf, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_FWUpld_GetSts(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            ref TEcFwuStatus pStsBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecNet_FWUpld_ResetSts) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecNet_FWUpld_ResetSts(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        ////====================== ECAT CONFIG FUNCTIONS ==========================================================//

        //EC_EXTERN t_success (CECAT_API *ecCfg_Start) (t_i32 NetID, BOOL IsApplyTimeout, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_Start(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.Bool)] bool IsApplyTimeout,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecCfg_End) (t_i32 NetID, BOOL IsSave, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_End(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.Bool)] bool IsSave, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecCfg_SetNetConfig) (t_i32 NetID, _in TEcNetConfig *pNetCfgHeader, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_SetNetConfig(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            ref TEcNetConfig pNetCfgHeader, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_success	(CECAT_API *ecCfg_GetNetConfig) (t_i32 NetID, _out TEcNetConfig *pNetCfgHeader, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_GetNetConfig(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            ref TEcNetConfig pNetCfgHeader,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecCfg_SetOutPDOLogicSect) (t_i32 NetID, t_i32 SectIdx, _in TEcLogMemSectCfg *pCfgData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_SetOutPDOLogicSect(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SectIdx,
            ref TEcNetConfig pCfgData, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecCfg_GetOutPDOLogicSect) (t_i32 NetID, t_i32 SectIdx, _out TEcLogMemSectCfg *pCfgData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_GetOutPDOLogicSect(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SectIdx, 
            ref TEcNetConfig pCfgData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecCfg_SetInPDOLogicSect) (t_i32 NetID, t_i32 SectIdx, _in TEcLogMemSectCfg *pCfgData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_SetInPDOLogicSect(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SectIdx, 
            ref TEcNetConfig pCfgData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecCfg_GetInPDOLogicSect) (t_i32 NetID, t_i32 SectIdx, _out TEcLogMemSectCfg *pCfgData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_GetInPDOLogicSect
            ([MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SectIdx, 
            ref TEcNetConfig pCfgData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecCfg_SetSlaveConfig) (t_i32 NetID, t_i32 SlaveIdx, _in TEcSlaveCfg *pCfgData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_SetSlaveConfig(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SectIdx,
            ref TEcSlaveCfg pCfgData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecCfg_GetSlaveConfig) (t_i32 NetID, t_i32 SlaveIdx, _out TEcSlaveCfg *pCfgData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_GetSlaveConfig(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SectIdx,
            ref TEcSlaveCfg pCfgData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecCfg_SetChanMap) (t_i32 NetID, t_ui8 MapType, t_i32 ChanMapIdx, _in void* pChanMapData, t_i32 ChanMapDataSize, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_SetChanMap(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U1)] int MapType, 
            [MarshalAs(UnmanagedType.I4)] int ChanMapIdx,
            ref IntPtr pChanMapData, 
            [MarshalAs(UnmanagedType.I4)] int ChanMapDataSize, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecCfg_GetChanMap) (t_i32 NetID, t_ui8 MapType, t_i32 ChanMapIdx, _in void* pChanMapBuf, t_i32 ChanMapBufSize, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecCfg_GetChanMap(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U1)] int MapType,
            [MarshalAs(UnmanagedType.I4)] int ChanMapIdx,
            ref IntPtr pChanMapData, 
            [MarshalAs(UnmanagedType.I4)] int ChanMapBufSize, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        
        ////====================== XML FILE READING FUNCTIONS ==========================================================//

        //EC_EXTERN HANDLE	(CECAT_API *ecXml_LoadByProdInfo) (char *szXmlDirectory, TEcSlvProdInfo *pProdInfo, _out char *szFileNameBuf, t_i32 FileNameBufLen, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecXml_LoadByProdInfo(
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szXmlDirectory, 
            ref TEcSlvProdInfo pProdInfo,
            [Out][MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szFileNameBuf, 
            [MarshalAs(UnmanagedType.I4)] int FileNameBufLen,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN HANDLE	(CECAT_API *ecXml_LoadByFileName) (char *szXmlDirectory, char *szFileName, t_i32 *ErrCode);
        [DllImport(dll, CharSet = CharSet.Unicode)]
        public static extern unsafe int ecXml_LoadByFileName(
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szXmlDirectory,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szFileName, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN void		(CECAT_API *ecXml_Unload) (HANDLE XmlHandle, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe void ecXml_Unload(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_GetTagName) (HANDLE XmlHandle, char *szTagNameBuf, t_i32 TagNameBufLen, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_GetTagName(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szTagNameBuf, 
            [MarshalAs(UnmanagedType.I4)] int TagNameBufLen, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_i32		(CECAT_API *ecXml_GetNumElem) (HANDLE XmlHandle, t_bool IsResetPos, const char *szElemPath, t_i32 *ErrCode); -ysy const 처리안함
        [DllImport(dll)]
        public static extern unsafe int ecXml_GetNumElem(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle, 
            [MarshalAs(UnmanagedType.I1)] bool IsResetPos,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szElemPath, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecXml_FindElem) (HANDLE XmlHandle, t_bool IsResetPos, const char *szElemPath, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_FindElem(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle, 
            [MarshalAs(UnmanagedType.I1)] bool IsResetPos,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szElemPath,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_IntoElem) (HANDLE XmlHandle, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_IntoElem(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_OutOfElem) (HANDLE XmlHandle, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_OutOfElem(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_ResetPos) (HANDLE XmlHandle, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_ResetPos(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_SavePos) (HANDLE XmlHandle, char *szPosName, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_SavePos(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szPosName,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_RestorePos) (HANDLE XmlHandle, char *szPosName, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_RestorePos(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szPosName,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_ReadElemData) (HANDLE XmlHandle, char *szDataBuf, t_i32 DataBufLen, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_ReadElemData(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szDataBuf,
            [MarshalAs(UnmanagedType.I4)] int DataBufLen,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_ReadElemAttr) (HANDLE XmlHandle, const char *szAttrName, char *szDataBuf, t_i32 DataBufLen, t_i32 *ErrCode); //ysy const 처리안함
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_ReadElemAttr(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szAttrName,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szDataBuf,
            [MarshalAs(UnmanagedType.I4)] int DataBufLen,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_FindReadElemData) (HANDLE XmlHandle, t_bool IsResetPos, const char *szElemPath, char *szDataBuf, t_i32 DataBufLen, t_i32 *ErrCode); //ysy const 처리안함
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_FindReadElemData(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.I1)] bool IsResetPos,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szElemPath,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szDataBuf,
            [MarshalAs(UnmanagedType.I4)] int DataBufLen, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_FindReadElemAttr) (HANDLE XmlHandle, t_bool IsResetPos, const char *szElemPath, const char *szElemAttrName, char *szDataBuf, t_i32 DataBufLen, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_FindReadElemAttr(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.I1)] bool IsResetPos,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szElemPath,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szElemAttrName,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szDataBuf, 
            [MarshalAs(UnmanagedType.I4)] int DataBufLen, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_FindDeviceByProdInfo) (HANDLE XmlHandle, TEcSlvProdInfo *pProdInfo, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_FindDeviceByProdInfo(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            ref TEcSlvProdInfo pProdInfo, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecXml_Str2Bool) (char *szString, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_Str2Bool(
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szString,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecXml_Str2HexDec) (char *szString, t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecXml_Str2HexDec(
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szString, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecXml_GetProdDesc) (HANDLE XmlHandle, char *szLcId, TEcSlvProdInfo *pProdInfo, TEcSlvProdDesc *pProdDesc, t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecXml_GetProdDesc(
            [MarshalAs(UnmanagedType.I4)] int XmlHandle,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.I1)] char[] szLcId,
            ref TEcSlvProdInfo pProdInfo, ref TEcSlvProdDesc pProdDesc, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        ////====================== SLAVE I/F FUNCTIONS ============================================================//

        //EC_EXTERN TEcSdoiODList*	(CECAT_API *ecSlv_SdoInfo_GetODList) (t_i32 NetID, t_ui16 SlvPhysAddr, EEcSdoiODListType ODListType, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe TEcSdoiODList ecSlv_SdoInfo_GetODList(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            EEcSdoiODListType ODListType,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN TEcSdoiODList*	(CECAT_API *ecSlv_SdoInfo_GetODList_A) (t_i32 NetID, t_ui16 SlaveIdx, EEcSdoiODListType ODListType, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe TEcSdoiODList ecSlv_SdoInfo_GetODList_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlaveIdx,
            EEcSdoiODListType ODListType,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN TEcSdoiObjDesc*	(CECAT_API *ecSlv_SdoInfo_GetObjDesc) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui16 ObjIndex, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe TEcSdoiObjDesc ecSlv_SdoInfo_GetObjDesc(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr, 
            [MarshalAs(UnmanagedType.U2)] ushort ObjIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN TEcSdoiObjDesc*	(CECAT_API *ecSlv_SdoInfo_GetObjDesc_A) (t_i32 NetID, t_ui16 SlaveIdx, t_ui16 ObjIndex, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe TEcSdoiObjDesc ecSlv_SdoInfo_GetObjDesc_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlaveIdx, 
            [MarshalAs(UnmanagedType.U2)] ushort ObjIndex, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN TEcSdoiEntryDesc* (CECAT_API *ecSlv_SdoInfo_GetEntryDesc) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui16 ObjIndex, t_ui8 SubIndex, t_ui8 ValueInfo, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe TEcSdoiEntryDesc ecSlv_SdoInfo_GetEntryDesc(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlvPhysAddr,
            [MarshalAs(UnmanagedType.U2)] ushort ObjIndex, 
            [MarshalAs(UnmanagedType.U1)] int SubIndex,
            [MarshalAs(UnmanagedType.U1)] int ValueInfo, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN TEcSdoiEntryDesc* (CECAT_API *ecSlv_SdoInfo_GetEntryDesc_A) (t_i32 NetID, t_ui16 SlaveIdx, t_ui16 ObjIndex, t_ui8 SubIndex, t_ui8 ValueInfo, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe TEcSdoiEntryDesc ecSlv_SdoInfo_GetEntryDesc_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U2)] ushort SlaveIdx, 
            [MarshalAs(UnmanagedType.U2)] ushort ObjIndex, 
            [MarshalAs(UnmanagedType.U1)] int SubIndex,
            [MarshalAs(UnmanagedType.U1)] int ValueInfo, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success			(CECAT_API *ecSlv_SdoInfo_ReleaseData) (t_i32 NetID, t_ui16 SlaveIdx, void *pSdoiStruct, _out t_i32 *ErrCode);
        [DllImport(dll)]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_SdoInfo_ReleaseData(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U2)] ushort SlaveIdx, 
            ref IntPtr pSdoiStruct,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        public enum EEcVerCompatResult
        {
            ecVER_MISMATCH_HIGHER = -2,	// 해당 파일의 버전이 기준이 되는 파일과 호환되지 않는 상위 버전임을 나타냄
            ecVER_MISMATCH_LOWER = -1,	// 해당 파일의 버전이 기준이 되는 파일과 호환되지 않는 하위 버전임을 나타냄
            ecVER_NOT_FOUND = 0,	// 해당 파일의 버전을 찾을 수 없음(파일이 없거나, 버전 정보를 얻을 수 없는 경우)
            ecVER_MATCH = 1,	// 해당 파일의 버전이 기준이 되는 파일과 호환이 되는 버전임을 나타냄 
            ecVER_INVALID
        }

        public enum EEcFastFuncType
        {
            ecFF_TYPE1 = 1,
            ecFF_TYPE2 = 2
        }


        public enum EEcEcatCmd
        {
            ecCMD_APRD = 0x01,
            ecCMD_APWR = 0x02,
            ecCMD_FPRD = 0x04,
            ecCMD_FPWR = 0x05,
            ecCMD_BRD = 0x07,
            ecCMD_BWR = 0X08,
            ecCMD_LRD = 0x0a,
            ecCMD_LWR = 0x0b,
            ecCMD_LRW = 0x0c,
            ecCMD_ARMW = 0x0d,
            ecCMD_FRMW = 0x0e
        }

        public enum EEcSlvInfoType
        {
            ecSLV_INFO_VENDOR_ID = 0,
            ecSLV_INFO_PROD_CODE = 1,
            ecSLV_INFO_REV_NO = 2,
            ecSLV_INFO_SER_NO = 3
        }

        public enum EEcAlState
        {
            DISCONNECTED = 0,
            INITIAL = 1,
            PREOP = 2,
            BOOTSTRAP = 3,
            SAFEOP = 4,
            OP = 8
        }

        // OutPDO 데이터의 초기값 셋팅 모드 (OP모드로 전환될 때 셋팅되는 초기값) //
        public enum EEcOPDOInitMode
        {
            ecOPDO_INIT_KEEPLAST, // 마지막의 출력값을 그대로 유지한다.
            ecOPDO_INIT_ZERO, // 모든 값을 0으로 셋팅한다.
            ecOPDO_INIT_USERDEF, // 사용자가 미리 정의한 초기값을 적용한다.
            ecOPDO_INIT_INVALID, // 
        }

        // 디지털 I/O 채널 표현 형식 //
        public enum EEcIoChanType
        {
            ecIOCH_TYPE_GLOBAL, ///< Global Channel 방식 (슬레이브 구분없이 연속된 채널 번호를 부여하여 표현하는 방식)
            ecIOCH_TYPE_LOCAL,	///< Local Channel 방식 (슬레이브를 지정하고, 해당 슬레이브 내에서의 로컬 채널 번호로 표현하는 방식
            ecIOCH_TYPE_ONBOARD, ///< Onboard Cahnnel (마스터보드내에서 제공하는 I/O 채널을 표현) 
            ecIOCH_TYPE_UNDEF	///< 채널형식이 특별히 지정되지 않았음을 의미함.
        };


        // Debug Logging Type //
        public enum EEcDlogType
        {
            ecDLOG_TYPE_FILE = 0, // Text file에 로그 결과를 기록하는 모드 
            ecDLOG_TYPE_TRACE = 1,  //Debug 스트링 뷰어를 통해서 로그 결과를 보여 주는 모드 
            ecDLOG_TYPE_COMITOOL = 2,  // COMIZOA에서 제작한 디버깅 툴을 사용하여 로그 결과를 보여주는 모드 (현재 지원되지 않으며 항후 지원 예정)
            ecDLOG_TYPE_MEMORY = 3, // 메모리에 로그하고 필요시에 덤프하는 모드
            ecDLOG_TYPE_INVALID
        }

        // Debug Logging Level //
        public enum EEcDlogLevel
        {
            ecDLOG_LEVEL_DISALBE = 0, // No debug logging
            ecDLOG_LEVEL_ERR = 1,   // 에러 발생했을 때만 로깅 
            ecDLOG_LEVEL_CMD = 2,   // ecDLOG_LEVEL_ERR레벨을 포함하며 더해서 Set 함수 및 각종 커맨드 함수 로깅 
            ecDLOG_LEVEL_GET = 3,    // ecDLOG_LEVEL_CMD레벨을 포함하며 더해서 Get 함수도 로깅 (단 일부 상태 체크 함수들은 제외)
            ecDLOG_LEVEL_ALL = 4,   // 모든 함수에 대해서 로깅 수행 
            ecDLOG_LEVEL_INVALID
        }

        // Debug Logging Level //
        public enum EEcDlogErrLogType
        {
            ecDLOG_ERR_LOG_NONE = 0, // 에러가 발생하더라도 로깅을 남기지 않는다. 
            ecDLOG_ERR_LOG_CMD = 1,  // Command 함수에서만 에러가 발생했을 때 로깅을 남긴다.
            ecDLOG_ERR_LOG_GET = 2,  // 모든 함수에 대해서 에러가 발생했을 때 로깅을 남긴다.
        }

        // InPDOQue 기능에서 Queueing start/stop trigger 모드 종류에 대한 아이디값 //
        public enum EEcQueTrgMode
        {
            ecTRG_MODE_NONE, // 트리거모드 사용 안함.
            ecTRG_MODE_COMMON, // 모든 채널이 공통 트리거 소스를 사용함. 이 때에는 TInPDOQueChannel::Cfg.StaTrg.pCommonTrgSig 포인터가 가리키는 Signal 변수의 값이 1이 되면 
            ecTRG_MODE_COUNT, // InputPDO 데이터 전송 이벤트 카운트를 이용해서 트리거함. 이 때에 Count 조건 값은 TInPDOQueChannel::Cfg.StaTrg.TrgRefVal 멤버 변수를 통해서 설정한다. 
            ecTRG_MODE_PDODATA, // 특정 PDO 데이터의 값을 체크하여 트리거 조건을 결정하는 모드. 
            ecTRG_MODE_INVALID
        }

        public enum EEcQueCommTrgMode
        {
            ecCOMTRG_MODE_NONE, // 트리거모드 사용 안함.
            ecCOMTRG_MODE_MANUAL, // Manual trigger 모드 
            ecCOMTRG_MODE_COUNT, // InputPDO 데이터 전송 이벤트 카운트를 이용해서 트리거함. 이 때에 Count 조건 값은 TInPDOQueChannel::Cfg.StaTrg.TrgRefVal 멤버 변수를 통해서 설정한다. 
            ecCOMTRG_MODE_PDODATA, // 특정 PDO 데이터의 값을 체크하여 트리거 조건을 결정하는 모드. 
            ecCOMTRG_MODE_INVALID
        }

        // InPDOQue 기능에서 Start/Trigger 사용할 때 데이터를 비교하는 방법의 종류에 대한 아이디값 //
        public enum EEcTrgLevelType
        {
            ecTRG_LEV_TYPE_EQ, // 비교데이터가 Ref 데이터와 같으면(Equal) 트리거 셋
            ecTRG_LEV_TYPE_GT, // 비교데이터가 Ref 데이터보다 크면(Greater than) 트리거 셋
            ecTRG_LEV_TYPE_GE, // 비교데이터가 Ref 데이터보다 크거나 같으면 트리거 셋
            ecTRG_LEV_TYPE_LT, // 비교데이터가 Ref 데이터보다 작으면(Less than) 트리거 셋
            ecTRG_LEV_TYPE_LE, // 비교데이터가 Ref 데이터보다 작거나 같으면 트리거 셋
            ecTRG_LEV_TYPE_RE, // 비교데이터가 Ref 데이터를 기준으로 상승에지(Rising edge, 비교데이터의 한 샘플 전/후 값이 Ref값 보다 작은 상태에서 큰 상태로 변화한 경우)가 발생하면 트리거 셋
            ecTRG_LEV_TYPE_FE, // 비교데이터가 Ref 데이터를 기준으로 하강에지(Rising edge, 비교데이터의 한 샘플 전/후 값이 Ref값 보다 큰 상태에서 작은 상태로 변화한 경우)가 발생하면 트리거 셋
            ecTRG_LEV_TYPE_INVALID
        }

        // Axis Connection Status Detailed ID //
        public enum EEcmConnStsDetail
        {
            ecmCONN_STS_NOCONFIG = -1, // 해당축 번호로 맵핑된 Slave가 Network Configuration에서 정의되지 않음.
            ecmCONN_STS_DISCONN = 0, // 해당축의 통신이 끊어진 상태
            ecmCONN_STS_INITIAL = 1, // 해당축의 통신이 연결되어 있으며, AL State가 INITIAL 단계임.
            ecmCONN_STS_PREOP = 2, // 해당축의 통신이 연결되어 있으며, AL State가 PreOP 단계임.
            ecmCONN_STS_BOOTSTRAP = 3, // 해당축의 통신이 연결되어 있으며, AL State가 BOOTSTRAP 단계임.
            ecmCONN_STS_SAFEOP = 4, // 해당축의 통신이 연결되어 있으며, AL State가 SafeOP 단계임.
            ecmCONN_STS_OP = 8  // 해당축의 통신이 연결되어 있으며, AL State가 OP 단계임.
        }

        public enum EEcmOperMode
        {
            ecmOPMODE_CP = 8, // cyclic synchronous position mode
            ecmOPMODE_CV = 9, // cyclic synchronous velocity mode
            ecmOPMODE_CT = 10 // cyclic synchronous torque mode
        }

        // Motion Property ID //
        public enum EEcmMioPropId
        {
            ecmMPID_EL_STOP_MODE = 0, ///< External Limit 센서 감지 시의 정지 모드 [ 0:즉시정지(Default), 1:감속정지]
            ecmMPID_SWL_STOP_MODE = 10, ///< Software Limit 감지 시의 정지 모드: [ 0:즉시정지(Default), 1:감속정지]
            ecmMPID_ALM_STOP_MODE = 20, ///< Servo Alarm 감지 시의 정지 모드: [ 0:즉시정지(Default), 1:감속정지]
            ecmMPID_INP_ENABLE = 30, ///< 서보드라이버의 INP 신호의 모션의 완료 상태 체크에 반영할 것인지 설정. [ 0:Disable(Default), 1:Enable]
            ecmMPID_SVOFF_MOVE_MODE = 40, ///< 서보 OFF 상태에서의 이송 허용 모드(0:허용 안함(또한 이송 중에 Servo-off 불가), 1:허용함)
            ecmMPID_CLEAR_INITIAL_ALARM = 50, ///< ECAT AL State가 OP모드로 전환될 때 1회에 한해서 서보앰프의 알람을 클리어할 것인지에 대한 설정. [0:Disable, 1:Enable(Default)]
            ecmMPID_INPUTPDO_TYPE = 60, ///< 각 축의 InputPDO데이터를 마스터장치에서 PC측으로 전달할 때의 데이터 구조를 결정.
            ecmMPID_IGNORE_ELN = 70, ///< (-)Limit 신호를 무시하라는 옵션에 대한 설정. [ 0:Disable(Default), 1:Enable]
            ecmMPID_IGNORE_ELP = 71, ///< (+)Limit 신호를 무시하라는 옵션에 대한 설정. [ 0:Disable(Default), 1:Enable]
            ecmMPID_ELN_INPUT_SEL = 72, ///< (-)Limit 신호로 사용할 신호 입력 핀을 설정하는 옵션 [ 0:NOT신호(Default), 1:SIMON1/EXT1신호, 2:SIMON2/EXT2신호, 3:SIMON3, 4:SIMON4, 5:SIMON5] <= 파나소닉서보드라이버 기준
            ecmMPID_ELP_INPUT_SEL = 73, ///< (+)Limit 신호로 사용할 신호 입력 핀을 설정하는 옵션 [ 0:POT신호(Default), 1:SIMON1/EXT1신호, 2:SIMON2/EXT2신호, 3:SIMON3, 4:SIMON4, 5:SIMON5] <= 파나소닉서보드라이버 기준
            ecmMPID_NULL
        }

        public enum EEcmHomeOptID
        {
            ecmHOID_TPROB_EDGE_SEL = 0, ///< Homming시에 사용되는 Touch Probe의 Trigger Edge 설정.
            ecmHOID_NULL
        }

        // Signal logic //
        public enum EEcmSigLogic
        {
            ecmLOGIC_A = 0,
            ecmLOGIC_B = 1
        }

        // Trigger Signal Edge //
        public enum EEcmSigEdge
        {
            ecmEDGE_NEG = 0, // Positive Edge
            ecmEDGE_POS = 1	 // Negative Edge	
        }

        public enum EEcmDir
        {
            ecmDIR_N = 0,
            ecmDIR_P = 1
        }

        // Speed Mode //
        public enum EEcmSpeedMode
        {
            ecmSMODE_CONST = 0,
            ecmSMODE_TRAPE = 1,
            ecmSMODE_SCURVE = 2,
            ecmSMODE_INVALID
        }

        // 'SyncOther' 모드에서 Sync. Type 에 대한 ID //
        public enum EEcmSyncOtherType
        {
            ecmSYNC_OTHER_START,
            ecmSYNC_OTHER_ACC_INI,
            ecmSYNC_OTHER_ACC_END,
            ecmSYNC_OTHER_DEC_INI,
            ecmSYNC_OTHER_DEC_END,
            ecmSYNC_OTHER_POSITION,
            ecmSYNC_OTHER_INVALID
        }

        // 'SyncOther' 모드에서 Sync. Type 이 ecmSYNC_OTHER_POSITION인 경우에 Position을 비교하는 방법 종류에 대한 ID //
        public enum EEcmPosSyncMethod
        {
            ecmPOS_SYNC_GT, // sync축의 position이 ref. position보다 큰(Greater Than) 경우.
            ecmPOS_SYNC_GE, // sync축의 position이 ref. position보다 크거나 같은(Greater or Equal) 경우.
            ecmPOS_SYNC_LT, // sync축의 position이 ref. position보다 작은(Less Than) 경우.
            ecmPOS_SYNC_LE, // sync축의 position이 ref. position보다 크거나 같은(Less or Equal) 경우.
            ecmPOS_SYNC_POS_CROSS, // sync축의 position이 ref. position보다 작은 값에서 큰 값으로 변하는 경우.
            ecmPOS_SYNC_NEG_CROSS, // sync축의 position이 ref. position보다 큰 값에서 작은 값으로 변하는 경우.
            ecmPOS_SYNC_INVALID
        }

        public enum EEcmAutoTorqValMode
        {
            ecmATRQ_VAL_SINGLE, // single torque value output mode
            ecmATRQ_VAL_MULTI,  // Multiple level torque value output mode
            ecmATRQ_VAL_INVALID
        }

        public enum _EEcmAtrqLimMask
        {
            ecmATRQ_LMBIT_HIGHSPD, // single torque value output mode
            ecmATRQ_LMBIT_LOWSPD,  // Multiple level torque value output mode
            ecmATRQ_LMBIT_TIME
        }

        // Counter name //
        public enum EEcmCntr
        {
            ecmCNT_COMM, // 최종좌표계 Command 위치 (기계적 원점, 사용자 좌표계 원점, PosCorrTable이 모두 적용된 이후의 위치)
            ecmCNT_FEED, // 최종좌표계 Feedback 위치 (기계적 원점, 사용자 좌표계 원점, PosCorrTable 적용이 된 이후의 위치)
            ecmCNT_COMM_CORR, // PosCorrTable 적용전 사용자좌표계 Command 위치 (기계적 원점과 사용자좌표계 원점이 적용되고, PosCorrTable은 적용되지 않은 위치)
            ecmCNT_FEED_CORR, // PosCorrTable 적용전 사용자좌표계 Feedback 위치 (기계적 원점과 사용자좌표계 원점이 적용되고, PosCorrTable은 적용되지 않은 위치)
            ecmCNT_COMM_MOTOR, // 모터좌표계 Command 위치 (모터에서 전달받은 그대로의 위치값. 기계적 원점 적용하기 전의 위치)
            ecmCNT_FEED_MOTOR // 모터좌표계 Command 위치 (모터에서 전달받은 그대로의 위치값. 기계적 원점 적용하기 전의 위치)
        }

        // Motion State //
        public enum EEcmMotStateId
        {
            STOP = 0,
            ACCEL = 1,
            WORKSPEED = 2,
            DECEL = 3,
            INITSPEED = 4,
            WAIT_INP = 5,
            IN_SDSPD = 6,
            HOMMING = 10,
            SLAVE_MODE = 13,  ///<해당 축이 Master/Slave 기능의 Slave축으로 동작하는 상태
            WAIT = 14,
            AUTO_TORQ_MDOE = 15,
            PTMOTION = 16,
            NORMAL_TORQ_MODE = 17, ///< Normal Torque Control Mode가 진행중인 상태
            MULTORQ1_MODE = 18, ///< Multi-Torque1 기능이 활성화된 상태
            NORMAL_CV_MODE = 21  ///< Normal cyclic velocity control mode 가 진행중인 상태
        }

        // Interpolation Map Index //
        public enum EEcmIxMap
        {
            ecmIX_MAP0 = 0,
            ecmIX_MAP1 = 1,
            ecmIX_MAP2 = 2,
            ecmIX_MAP3 = 3,
            ecmIX_MAP4 = 4,
            ecmIX_MAP5 = 5,
            ecmIX_MAP6 = 6,
            ecmIX_MAP7 = 7,
            ecmIX_MAP8 = 8,
            ecmIX_MAP9 = 9,
            ecmIX_MAP10 = 10,
            ecmIX_MAP11 = 11,
            ecmIX_MAP12 = 12,
            ecmIX_MAP13 = 13,
            ecmIX_MAP14 = 14,
            ecmIX_MAP15 = 15,
        }

        // interpolation mode(using to IxMapAxes) //
        public enum EEcmIxMODE
        {
            ecmIX_MODE_NONE = 0,
            ecmIX_MODE_LINEAR = 1,
            ecmIX_MODE_CIRCULAR = 2,
            ecmIX_MODE_HELICARL = 3,
            ecmIX_MODE_SPLINE = 4,
        }

        public enum EEcmArcDir
        {
            ecmARC_CW = 0,
            ecmARC_CCW = 1
        }

        public enum EEcmSplJsType
        {
            ecmJSTYPE_DISABLED = 0,
            ecmJSTYPE_USE_JERKTHRESH = 1,
            ecmJSTYPE_INVALID,
        }

        public enum EEcmSplJsPropId
        {
            ecmJSPROP_DEC_TIME_ms, // 저속으로 감속할때의 감속 시간을 msec 단위로 설정한다.
            ecmJSPROP_LOWVEL_RATIO, // 저속구간의 속도를 고속구간 속도에 대한 비율값으로 설정한다.
            ecmJSPROP_LOWVEL_DUR_ms,// 저속구간의 유지시간을 msec단위로 설정한다. 
            ecmJSPROP_INVALID
        }

        // Round Data Type ID //
        public enum EEcmRoundDataType
        {
            NONE = 0,
            RADIUS = 1,
            OFFSET = 2,
            INVALID
        }


        // Round Position Type ID (MoveVia2X에서 사용) //
        public enum EEcmRoundPosType
        {
            ecmROUND_PT_START	= 0, // 경유점에서 원호가 시작됨
	        ecmROUND_PT_END		= 1, // 경유점에서 원호가 종료됨
	        ecmROUND_PT_INVALID
        }


        public enum EEcmLmQueFullMode
        {
            ecmLM_QUEFULL_SKIP,
            ecmLM_QUEFULL_WAIT,
            ecmLM_QUEFULL_INVALID,
        }

        // 하나의 리스트모션맵의 현재 동작 상태 아이디 //
        public enum EEcmLmSts
        {
            ecmLM_STS_DISABLED,	// List Motion 기능이 비활성화된 상태 (LmCtl_Begin() 실행하기 전)
            ecmLM_STS_PAUSED,	// List Motion 기능이 활성화(LmCtl_Begin()) 되었지만 아직 Run (LmCtl_Run()) 되지 않은 상태
            ecmLM_STS_RUN,		// List Motion 기능이 활성화(LmCtl_Begin()) 되고, 또한  Run (LmCtl_Run()) 된 상태.
            ecmLM_STS_STOPPING, // List Motion 정지 명령(ecmLmCtl_Stop)이 하달되어서 정지 작업을 진행하고 있는 상태(감속중)
            ecmLM_STS_STEPCOMPTING, // IsComptCurStep인자를 true로 하여  List Motion 정지 명령(ecmLmCtl_Stop)이 하달되어서 그 시점에 진행되고 있던 스텝은 그대로 진행하고 있는 상태임을 나타냄
            ecmLM_STS_INVALID
        }

        // 리스트모션 각 커맨드 아이템의 실행 상태 //
        public enum EEcmLmCmdItemSts
        {
            ecmLM_CMDITEM_STS_READY, 		// 아직 실행되지 않음
            ecmLM_CMDITEM_STS_BUSY,			// 현재 실행되고 있음.
            ecmLM_CMDITEM_STS_PAUSED,		// 실행 중에(완료되기 전에) 중지됨.
            ecmLM_CMDITEM_STS_COMPLETED,	// 해당 커맨드의  실행이 완료되었음.
            ecmLM_CMDITEM_STS_INVALID
        }

        // 하나의 리스트모션맵의 현재 동작 상태 아이디 //
        public enum EEcmPtmSts
        {
            ecmPTM_STS_DISABLED,	// PT-Motion 기능이 비활성화된 상태 (ecmPtmCtl_Begin() 실행하기 전)
            ecmPTM_STS_PAUSED,		// PT-Motion 기능이 활성화(ecmPtmCtl_Begin()) 되었지만 Hold된 상태
            ecmPTM_STS_RUN_IDLE,	// PT-Motion 기능이 활성화(ecmPtmCtl_Begin()) 되고 Hold상태도 아니지만 아직 등록된 커맨드가 하나도 없는 경우.
            ecmPTM_STS_RUN_BUSY,	// PT-Motion 기능이 활성화(ecmPtmCtl_Begin()) 되고 Hold상태도 아닌 상태에서 등록된 커맨드가 실행중에 있는 경우.
            ecmPTM_STS_RUN_COMPT,	// PT-Motion 기능이 활성화(ecmPtmCtl_Begin()) 되고 Hold상태도 아닌 상태에서 등록된 커맨드가 모두 실행된 경우(참고로 ecmPTM_STS_RUN_COMPT은 1개 이상의 등록된 커맨드가 있었던 경우에 해당하며, 등록된 커맨드가 아예 없는 경우는 ecmPTM_STS_RUN_IDLE 상태로 반환된다)
            ecmPTM_STS_INVALID
        }

        public enum EEcmPtmCmdItemSts
        {
            ecmPTM_CMDITEM_STS_READY, 		// 아직 실행되지 않음
            ecmPTM_CMDITEM_STS_BUSY,			// 현재 실행되고 있음.
            ecmPTM_CMDITEM_STS_PAUSED,		// 실행 중에(완료되기 전에) 중지됨.
            ecmPTM_CMDITEM_STS_COMPLETED,	// 해당 커맨드의  실행이 완료되었음.
            ecmPTM_CMDITEM_STS_INVALID
        }

        // EEcmRingCntrDir: RingCounter 모드가 활성화된 축에 대해서 절대 좌표 이송 명령이 내려졌을 때 이송방향을 결정하는 Direction Mode의 아이디값 //
        // 참고: 링카운터 모드에서는 지정한 위치를 (-)방향으로 이송해서 갈수도 있고, (+)방향으로 이송해서 갈 수도 있다.
        public enum EEcmRingCntrDir
        {
            ecmRING_DIR_NEG,	// (-)방향으로 이송하여 지정한 절대 위치로 이송
            ecmRING_DIR_POS,	// (-)방향으로 이송하여 지정한 절대 위치로 이송
            ecmRING_DIR_NEAR,	// (-)방향과 (+)방향 중에서 현재 위치로부터 지정한 절대 위치까지 거리가 더 가까운 방향으로 이송.
            ecmRING_DIR_FAR,	// (-)방향과 (+)방향 중에서 현재 위치로부터 지정한 절대 위치까지 거리가 더 먼 방향으로 이송.
            ecmRING_DIR_INVALID
        }

        // Position Compare 기능의 Counter Type //
        public enum EEcmCmpCntrType
        {
            ecmCMP_CNTR_COMM,
            ecmCMP_CNTR_FEED,
            ecmCMP_CNTR_INVALID
        }

        // EEcmCmpMethod: Compare Method for 'Position Compare Output' function //
        public enum EEcmCmpMethod
        {
            ecmCMP_METH_EQ_NDIR,	// (-)방향 이송 중에 CP == RP 일때 Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
            ecmCMP_METH_EQ_PDIR,	// (+)방향 이송 중에 CP == RP 일때 Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
            ecmCMP_METH_EQ_BIDIR,	// 방향에 상관없이 CP == RP 일때 Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
            ecmCMP_METH_LT,			// CP < RP 일때  Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
            ecmCMP_METH_GT,			// CP > RP 일때  Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
            ecmCMP_METH_LE,			// CP <= RP 일때  Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
            ecmCMP_METH_GE,			// CP >= RP 일때  Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
        }

        public enum EEcmMTQ1CmpMode
        {
            ecmCMP_METH_LT,			// CP < RP 일때  Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
            ecmCMP_METH_GT,			// CP > RP 일때  Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
            ecmCMP_METH_LE,			// CP <= RP 일때  Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
            ecmCMP_METH_GE,			// CP >= RP 일때  Compare Output Active 되는 모드. 여기서 CP:Current Position,  RP:Reference Position.
        }

        public enum EEcmHandlerType
        {
            ecmHT_DISABLE,	        // Handler를 사용하지 않는다(현재 등록된 핸들러는 삭제된다)
            ecmHT_MESSAGE,	        // Window Message 방식
            ecmHT_EVENT,			// Event 방식
            ecmHT_CALLBACK,			// Callback 방식
        }

        public enum EEcmSdOfsMode
        {
            ecmSD_OFS_NONE, // offset 적용 안함
            ecmSD_OFS_TIME, // time offset 적용(msec 단위)
            ecmSD_OFS_CMDPOS, // command position offset 적용
            ecmSD_OFS_FEEDPOS, // feedback position offset 적용
            ecmSD_OFS_INVALID
        }

        


        /// <summary>
        /// ComiEcatSdk_SysDef.h
        /// </summary>
        /// 

        public enum EMPMonSectID
        {
            MPMSECT_ACC, ///< 가속구간만을 누적하여 계산하는 구간
            MPMSECT_DEC, ///< 감속구간만을 누적하여 계산하는 구간
            MPMSECT_CONST, ///< 정속구간만을 누적하여 계산하는 구간
            MPMSECT_MOVING, ///< 이송중인구간을 종합하여 계산하는 구간
            MPMSECT_IDLE, ///< 정지해 있는 구간만 누적하여 계산하는 구간
            MPMSECT_TOTAL, ///< 모든 구간을 모두 누적하여 계산
            MPMSECT_INVALID
        };

        

        // EEcFwuDnldCmd: FW Download 함수를 수행할 때 매개변수로 전달되는 명령들의 ID //
        public enum EEcFwuDnldCmd
        {
            ecFWU_DNLD_START, // download 시작하라는 커맨드
            ecFWU_DNLD_CONTINUE, // 일반적인 download 데이터 전송 커맨드
            ecFWU_DNLD_LAST, // 마지막 데이터의 download 전송 커맨드
            ecFWU_DNLD_END // download 종료 커맨드
        }


        public enum EEcFwuUpldCmd
        {
            ecFWU_UPLD_FILEINFO, // FileInfo 정보만 업로드하는 커맨드
            ecFWU_UPLD_FILEDATA // File data를 업로드하는 커맨드
        }


        // EEcEcatCmd: COE SDOInfo Service 중에서 'OD List Get' 서비를 이용할 때 Get하는 Obect Dictionary List의 종류를 나타내는 ID값들을 정의한 것 //
        public enum EEcSdoiODListType
        {
            ecODLT_LEN_LIST = 0x0, // 각 OD List Type(1~5)에 대한 List의 크기에 대한 리스트(이때에는 리스트 아이템이 2바이트 정수 5개로 구성된다)
            ecODLT_ALL_OBJ = 0x1, // Object Dictionary에 있는 모든 Object의 Index 리스트 
            ecODLT_RXPDO_OBJ = 0x2, // RxPDO에 맵핑 가능한 Object들의 리스트 
            ecODLT_TXPDO_OBJ = 0x3, // TxPDO에 맵핑 가능한 Object들의 리스트 
            ecODLT_STORE_OBJ = 0x4, // 디바이스를 교체할 때 저장되어야만 하는 Object들의 리스트 
            ecODLT_STARTUP_OBJ = 0x5, // startup parameter로 사용되는 Object들의 리스트 
            ecODLT_INVALID
        }


        //============================================================================================
        //  Structures
        //============================================================================================

        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct RPMData
        {
            public byte isAlarm;
            public ushort rpmValue;
        }


        // COMIZOA EtherCAT 마스터 디바이스 정보 //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcDevInfo
        {
            public ushort ProdId; // Product ID: 0xA550, 0xA551, 0xA552
            public ushort PhysId; // Board에 장착되어 있는 스위치에 의해서 결정되는 ID
            public ushort NumNets; // 해당 디바이스 하나에서 제공하는 네트워크 갯수 (1 또는 2)
            public ushort NetIdx; // 해당 디바이스의 첫번째 네트워크가 전체 네트워크 리스트상에서 차지하는 순서. 
            public ushort FwVerMinor; // Firmware version(minor)
            public ushort FwVerMajor; // Firmware version(major)
        }


        // File Version Info //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcFileVersion
        {
            public ushort MajorVer;
            public ushort MinorVer;
            public ushort BuildNo;
            public ushort RevNo;
        }


        // SDK(DLL) File Version & Compatibility Info //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcFileVerInfo_SDK
        {
            public TEcFileVersion CurVer;			// Current SDK File Version
            public TEcFileVersion CompWdmVer;	// WDM driver File(.sys) Version which is Compatible with SDK DLL
            public TEcFileVersion CompFwVer;	// Firmwar[Struct dsasdsadsade File Version which is Compatible with SDK DLL
            public int nWdmCompResult;		// WDM driver compatibity result, 'EEcVerCompatResult' enum 선언 참조
            public int nFwCompResult;		// Firmware compatibity result, 'EEcVerCompatResult' enum 선언 참조
        }


        // WDM(.sys) File Version & Compatibility Info //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcFileVerInfo_WDM
        {
            public TEcFileVersion CurVer;			// Current WDM driver File(.sys) Version
            public TEcFileVersion CompSdkVer;	// SDK(DLL) File Version which is Compatible with WDM driver
            public TEcFileVersion CompFwVer;	// Firmware File Version which is Compatible with WDM driver
            public int nSdkCompResult;		// SDK compatibity result, 'EEcVerCompatResult' enum 선언 참조
            public int nFwCompResult;		// Firmware compatibity result, 'EEcVerCompatResult' enum 선언 참조
        }


        // Firmware File Version & Compatibility Info //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcFileVerInfo_FW
        {
            public TEcFileVersion CurVer;			// Current WDM driver File(.sys) Version
            public TEcFileVersion CompSdkVer;	// SDK(DLL) File Version which is Compatible with Firmware
            public TEcFileVersion CompWdmVer;	// WDM driver File(.sys) Version which is Compatible with Firmware
            public int nSdkCompResult;		// SDK(DLL) compatibity result, 'EEcVerCompatResult' enum 선언 참조
            public int nWdmCompResult;		// WDM driver compatibity result, 'EEcVerCompatResult' enum 선언 참조
        }


        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcInQueCommonTrg
        {
            public sbyte TrgMode; // 트리거 모드, EEcQueCommTrgMode enum 데이터 참고
            public int TrgLevelType; // 트리거 레벨 타입, ETrgLevelType enum 데이터 참고 
            public ushort wReseved; // reserved field (사용 안함)
            public short TrgDataPdoPos; // (TrgMode==TRG_MODE_PDODATA)인 경우에 트리거 소스로 사용되는 데이터의 PDO 메모리 상의 offset 위치  
            public short TrgDataSize;
            public ushort TrgDataMask; // (TrgMode==TRG_MODE_PDODATA)인 경우에 사용하는 마스킹 값으로서, 트리거 데이터에 이 값을 마스킹하여 트리거 데이터로 사용한다. 트리거 데이터가 특정비트 값을 사용하는 경우에 사용한다. 단, 이 값이 0이면 무시됨.
            public int TrgRefVal; // Trigger의 비교대상 기준값. (TrgMode==TRG_MODE_COUNT)인 경우에는 Count 리미트값으로 사용된다. 
            public int Delay; // 트리거조건이 만족한 이후에 실제 Trg 행위를 하기 전까지 지연이 필요한 경우에 이 값을 사용한다. 이때 Delay의 단위는 PDO전송 횟수이다.
        }


        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcInQueTrgCfg
        {
            public int TrgMode; // 트리거 모드, EEcQueTrgMode enum 데이터 참고
            public int TrgLevelType; // 트리거 레벨 타입, EEcTrgLevelType enum 데이터 참고. (TrgMode==TRG_MODE_PDODATA)인 경우에만 사용함 
            public ushort wReseved; // reserved field (사용 안함)
            public short TrgDataPdoPos; // 트리거 소스로 사용되는 데이터의 PDO 메모리 상의 offset 위치. (TrgMode==TRG_MODE_PDODATA)인 경우에만 사용함
            public short TrgDataSize; // 트리거 소스로 사용되는 데이터의 데이터형 크기를 바이트 단위로 나타낸다. (TrgMode==TRG_MODE_PDODATA)인 경우에만 사용함
            public uint TrgDataMask; // 트리거 데이터에 이 값을 마스킹하여 트리거 데이터로 사용한다. 트리거 데이터가 특정비트 값을 사용하는 경우에 사용한다. 단, 이 값이 0이면 무시됨. (TrgMode==TRG_MODE_PDODATA)인 경우에만 사용함.
            public int TrgRefVal; // (TrgMode==TRG_MODE_PDODATA)인 경우 => Trigger의 비교대상 기준값. (TrgMode==TRG_MODE_COUNT)인 경우 => 이 값을 Count 리미트값으로 사용한다. 
            public int Delay; // 트리거조건이 만족한 이후에 실제 Trg 행위를 하기 전까지 지연이 필요한 경우에 이 값을 사용한다. 이때 Delay의 단위는 PDO전송 횟수이다.
            public int CommonTrgHandle; // (TrgMode == TRG_MODE_COMMON(공통트리거)) 인 경우에만 사용하는 멤버로서, 공통 트리거 신호 관리하는 오브젝트의 핸들을 나타낸다.
        }


        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcInQueDataDesc
        {
            public ushort PdoOfsPos; // 해당 데이터가 위치하는 Input PDO 논리 메모리상의 OFFSET 주소값 
            public ushort DataSize; // 해당 데이터의 크기(바이트 단위);
        }


        // TEcSlvProdInfo: 하나의 슬레이브에 대한 Product ID 정보 // 
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcSlvProdInfo
        {
            public uint VendId;
            public uint ProdCode;
            public uint RevNo;
            public uint SerNo;
        }


        // TEcSlvProdDesc: 하나의 슬레이브에 대한 Product 정보를 스트링으로 나타내는 구조체 // 
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcSlvProdDesc
        {
            // buffer declaration //
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 128)]
            public char[] szVendName;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 128)]
            public char[] szDevName;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
            public char[] szDevPhysics;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 128)]
            public char[] szGroupType;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
            public char[] szURL;
        }


        // TEcSlvTypeInfo: Slave 모듈의 장치 형식에 대한 정보를 제공하는 구조체.
        // 여기서 제공하는 장치 형식은 DI, DO, AI, AO, Servo-Axis 의 채널에 대한 정보를 말한다.
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcSlvTypeInfo
        {
            // Digital Input Function Info. //

            public DI DiInfo;
            [StructLayout(LayoutKind.Sequential, Pack = 1)]
            public struct DI
            {
                public short StaGlobChannel; // start global channel no.
                public ushort NumChannels; // number of channels
            }
            // Digital Output Function Info. //

            public DO DoInfo;
            [StructLayout(LayoutKind.Sequential, Pack = 1)]
            public struct DO
            {
                public short StaGlobChannel; // start global channel no.
                public ushort NumChannels; // number of channels
            }

            // Analog Input Function Info. //
            public AI aiInfo;
            [StructLayout(LayoutKind.Sequential, Pack = 1)]
            public struct AI
            {
                public short StaGlobChannel; // start global channel no.
                public ushort NumChannels; // number of channels
            }

            // Analog Input Function Info. //
            public AO aoInfo;
            [StructLayout(LayoutKind.Sequential, Pack = 1)]
            public struct AO
            {
                public short StaGlobChannel; // start global channel no.
                public ushort NumChannels; // number of channels
            }

            public Servo servoInfo;
            // Servo Motor Function Info. //
            [StructLayout(LayoutKind.Sequential, Pack = 1)]
            public struct Servo
            {
                public short StaAxisNo; // start global channel no.
                public ushort NumAxes; // number of channels
            }
            // Reserved for future //
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
            public int[] Resv;
        }



        // Homing 관련 상태 플래그들 //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcmHomeSt_Flags
        {
#if BitFieldUsing
            [BitFieldInfo(0, 1)]    public bool Moving { get; set; } // 1 - 모터가 구동중임을 나타냄. 단, 이 플래그는 Homing이 아닌 다른 일반 이송중일때도 1로 된다.
            [BitFieldInfo(1, 1)]    public bool HomeBusy { get; set; }// 1 - Homing 동작이 진행중임을 나타냄. 
            [BitFieldInfo(2, 1)]    public bool HomeAttained { get; set; }// 1 - Homing 동작이 성공적으로 완료되었음을 나타냄.
            [BitFieldInfo(3, 1)]    public bool HomingError { get; set; }// 1 - Homing 동작 중에 에러가 발생함.
#else
            public ushort word;
            public ushort Moving { get { return SafeNativeMethods.GetBit(word, 0); } }    // 1 - 모터가 구동중임을 나타냄. 단, 이 플래그는 Homing이 아닌 다른 일반 이송중일때도 1로 된다.
            public ushort HomeBusy { get { return SafeNativeMethods.GetBit(word, 1); } }    // 1 - Homing 동작이 진행중임을 나타냄. 
            public ushort HomeAttained { get { return SafeNativeMethods.GetBit(word, 2); } }    // 1 - Homing 동작이 성공적으로 완료되었음을 나타냄.
            public ushort HomingError { get { return SafeNativeMethods.GetBit(word, 3); } }    // 1 - Homing 동작 중에 에러가 발생함.
#endif
        }


        // Motion InputPDO Group의 헤더 정보: 이 정보가 Motion InputPDO 영역의 맨처음에 자리하게 된다. //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcmInPDO_Header
        {
            private uint data;
            public uint HEmgState
            {
                get { return data & 0x1; }
                set { data = data & (value & 0x1); }
            }

            public uint SEmgState
            {
                get { return (data >> 1) & 0x1; }
                set { data = (data & 0xFFFFFFFD) | ((value & 0x1) << 1); }
            }

            public uint Resv
            {
                get { return (data >> 2); }
                set { data = (data & 0x3) | (value << 2 ); }
            }

                //t_ui32	HEmgState:	1; ///< Motion Hard-EMG 상태
                //t_ui32	SEmgState:	1; ///< Motion Soft-EMG 상태
                //t_ui32	Resv:	30;
        }


        /////////////////////////////////////////////////////////////////////////////////////
        // Flag: Bit 별로 Axis의 상태를 알리는 플래그들의 집합
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcmSxSt_Flags
        {
#if BitFieldUsing

            public ushort word;

            [BitFieldInfo(0, 1)]    public bool RdyToSwOn { get; set; }            
            [BitFieldInfo(1, 1)]    public bool SwOn { get; set; }
            [BitFieldInfo(2, 1)]    public bool OperEnabled { get; set; }
            [BitFieldInfo(3, 1)]    public bool ServoFault { get; set; }
            [BitFieldInfo(4, 1)]    public bool VoltEnabled { get; set; }
            [BitFieldInfo(5, 1)]    public bool QuickStop { get; set; }
            [BitFieldInfo(6, 1)]    public bool SwOnDisabled { get; set; }
            [BitFieldInfo(7, 1)]    public bool ServoWarn { get; set; }
            [BitFieldInfo(8, 1)]    public bool CtlrFault { get; set; }
            [BitFieldInfo(9, 1)]    public bool HomeError { get; set; }
            [BitFieldInfo(10, 1)]   public bool OMS1 { get; set; }
            [BitFieldInfo(11, 1)]   public bool IntLimit { get; set; }
            [BitFieldInfo(12, 1)]   public byte OMS2 { get; set; }
            [BitFieldInfo(13, 1)]   public bool HomeBusy { get; set; }
            [BitFieldInfo(15, 1)]   public bool HomeAttained { get; set; }
#else
            public ushort word;
            public ushort RdyToSwOn { get { return SafeNativeMethods.GetBit(word, 0); } }
            public ushort SwOn { get { return SafeNativeMethods.GetBit(word, 1); } }
            public ushort OperEnabled { get { return SafeNativeMethods.GetBit(word, 2); } }
            public ushort ServoFault { get { return SafeNativeMethods.GetBit(word, 3); } }
            public ushort VoltEnabled { get { return SafeNativeMethods.GetBit(word, 4); } }
            public ushort QuickStop { get { return SafeNativeMethods.GetBit(word, 5); } }
            public ushort SwOnDisabled { get { return SafeNativeMethods.GetBit(word, 6); } }
            public ushort ServoWarn { get { return SafeNativeMethods.GetBit(word, 7); } }
            public ushort CtlrFault { get { return SafeNativeMethods.GetBit(word, 8); } }
            public ushort HomeError { get { return SafeNativeMethods.GetBit(word, 9); } }
            public ushort OMS1 { get { return SafeNativeMethods.GetBit(word, 10); } }
            public ushort IntLimit { get { return SafeNativeMethods.GetBit(word, 11); } }
            public ushort OMS2 { get { return SafeNativeMethods.GetBit(word, 12); } }
            public ushort HomeBusy { get { return SafeNativeMethods.GetBit(word, 14); } }
            public ushort HomeAttained { get { return SafeNativeMethods.GetBit(word, 15); } }
#endif
        }


        // Digital Input of an Axis //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcmSxSt_DI
        {
#if BitFieldUsing
        [StructLayout(LayoutKind.Explicit)]
        public struct bit
        {
            [FieldOffsetAttribute(0)]
            public ushort NOT;
            [FieldOffsetAttribute(1)]
            public ushort POT;
            [FieldOffsetAttribute(2)]
            public ushort HOME;
            [FieldOffsetAttribute(3)]
            public ushort INP;
            [FieldOffsetAttribute(4)]
            ushort b4;
            [FieldOffsetAttribute(5)]
            ushort b5;
            [FieldOffsetAttribute(6)]
            ushort b6;
            [FieldOffsetAttribute(7)]
            ushort b7;
            [FieldOffsetAttribute(8)]
            ushort b8;
            [FieldOffsetAttribute(9)]
            ushort b9;
            [FieldOffsetAttribute(10)]
            ushort b10;
            [FieldOffsetAttribute(11)]
            ushort b11;
            [FieldOffsetAttribute(12)]
            ushort b12;
            [FieldOffsetAttribute(13)]
            ushort b13;
            [FieldOffsetAttribute(14)]
            ushort b14;
            [FieldOffsetAttribute(15)]
            ushort b15;
        }
#endif
            public ushort word;
            public ushort NOT { get { return SafeNativeMethods.GetBit(word, 0); } }
            public ushort POT { get { return SafeNativeMethods.GetBit(word, 1); } }
            public ushort HOME { get { return SafeNativeMethods.GetBit(word, 2); } }
            public ushort INP { get { return SafeNativeMethods.GetBit(word, 3); } }
            public ushort b4 { get { return SafeNativeMethods.GetBit(word, 4); } }
            public ushort b5 { get { return SafeNativeMethods.GetBit(word, 5); } }
        }


        // Motion InputPDO에서 하나의 Axis의 Status 정보 구조체 형식 0 //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcmInPDO_AxisType0
        {
            private ushort data;
            public ushort PDOTypeID
            {
                get { return (ushort)(data & 0xFF); }
                set { data = (ushort)((data & 0xFF00) | (value & 0xFF)); }
            }

            public ushort TouchProbSts1
            {
                get { return (ushort)((data >> 8) & 0x7); }
                set { data = (ushort)((data & 0xF8FF) | ((value & 7) << 8)); }
            }

            public ushort TouchProbSts2
            {
                get { return (ushort)((data >> 11) & 0x7); }
                set { data = (ushort)((data & 0xC7FF) | ((value & 7) << 11)); }
            }

            public ushort SdInputSts //< SD 센서 입력 상태
            {
                get { return (ushort)((data >> 14) & 0x1); }
                set { data = (ushort)((data & 0xBFFF) | ((value & 1) << 14)); }
            }

            public ushort Resv1
            {
                get { return (ushort)((data >> 15) & 0x1); }
                set { data = (ushort)((data & 0x7FFF) | ((value & 1) << 15)); }
            }
            ////////////////////////////////////////////////////////////////////////////////////
            // Mst: Motion의 상태를 알리는 코드값. 이 값은 Mio의 일부 비트 상태에 따라서 그 의미가 달라진다.
            // 1) Mio.ServoFault=1인 경우: Servo driver의 알람코드를 나타낸다.
            // 2) Mio.CtlrFault=1인경우: Controller의 알람코드를 나타낸다.
            // 3) Mio.ServoFault=0, Mio.CtlrFault=0 인 경우: Motion Control 동작 상태 코드
            // 참고) Mio.ServoFault 와 Mio.CtlrFault 가 둘다 1인 경우에는 Servo driver의 알람코드를 나타낸다.	
            public short Mst;
            // Motion Status Flags //
            public TEcmSxSt_Flags Flags;
            //// Digital Input //
            public TEcmSxSt_DI DI;

            // Position 정보 //
            public int CmdCnt, FeedCnt;
            // 속도 정보 //
            public int CmdVel, FeedVel;
        }


        // Motion InputPDO에서 하나의 Axis의 Status 정보 구조체 형식 1 //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcmInPDO_AxisType1
        {
            private ushort data;
            public ushort PDOTypeID
            {
                get { return (ushort)(data & 0xFF); }
                set { data = (ushort)((data & 0xFF00) | (value & 0xFF)); }
            }

            public ushort TouchProbSts1
            {
                get { return (ushort)((data >> 8) & 0x7); }
                set { data = (ushort)((data & 0xF8FF) | ((value & 7) << 8)); }
            }

            public ushort TouchProbSts2
            {
                get { return (ushort)((data >> 11) & 0x7); }
                set { data = (ushort)((data & 0xC7FF) | ((value & 7) << 11)); }
            }

            public ushort SdInputSts //< SD 센서 입력 상태
            {
                get { return (ushort)((data >> 14) & 0x1); }
                set { data = (ushort)((data & 0xBFFF) | ((value & 1) << 14)); }
            }

            public ushort Resv1
            {
                get { return (ushort)((data >> 15) & 0x1); }
                set { data = (ushort)((data & 0x7FFF) | ((value & 1) << 15)); }
            }
            ////////////////////////////////////////////////////////////////////////////////////
            // Mst: Motion의 상태를 알리는 코드값. 이 값은 Mio의 일부 비트 상태에 따라서 그 의미가 달라진다.
            // 1) Mio.ServoFault=1인 경우: Servo driver의 알람코드를 나타낸다.
            // 2) Mio.CtlrFault=1인경우: Controller의 알람코드를 나타낸다.
            // 3) Mio.ServoFault=0, Mio.CtlrFault=0 인 경우: Motion Control 동작 상태 코드
            // 참고) Mio.ServoFault 와 Mio.CtlrFault 가 둘다 1인 경우에는 Servo driver의 알람코드를 나타낸다.	
            public short Mst;
            // Motion Status Flags //
            public TEcmSxSt_Flags Flags;
            // Digital Input //
            public TEcmSxSt_DI DI;
            // Position 정보 //
            public int CmdCnt, FeedCnt;
            // 속도 정보 //
            public int CmdVel, FeedVel;
            public short Torque;
        }


        // Motion InputPDO에서 하나의 Axis의 Status 정보 구조체 형식 2 //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcmInPDO_AxisType2
        {
            private ushort data;
            public ushort PDOTypeID
            {
                get { return (ushort)(data & 0xFF); }
                set { data = (ushort)((data & 0xFF00) | (value & 0xFF)); }
            }

            public ushort TouchProbSts1
            {
                get { return (ushort)((data >> 8) & 0x7); }
                set { data = (ushort)((data & 0xF8FF) | ((value & 7) << 8)); }
            }

            public ushort TouchProbSts2
            {
                get { return (ushort)((data >> 11) & 0x7); }
                set { data = (ushort)((data & 0xC7FF) | ((value & 7) << 11)); }
            }

            public ushort SdInputSts //< SD 센서 입력 상태
            {
                get { return (ushort)((data >> 14) & 0x1); }
                set { data = (ushort)((data & 0xBFFF) | ((value & 1) << 14)); }
            }

            public ushort Resv1
            {
                get { return (ushort)((data >> 15) & 0x1); }
                set { data = (ushort)((data & 0x7FFF) | ((value & 1) << 15)); }
            }
            ////////////////////////////////////////////////////////////////////////////////////
            // Mst: Motion의 상태를 알리는 코드값. 이 값은 Mio의 일부 비트 상태에 따라서 그 의미가 달라진다.
            // 1) Mio.ServoFault=1인 경우: Servo driver의 알람코드를 나타낸다.
            // 2) Mio.CtlrFault=1인경우: Controller의 알람코드를 나타낸다.
            // 3) Mio.ServoFault=0, Mio.CtlrFault=0 인 경우: Motion Control 동작 상태 코드
            // 참고) Mio.ServoFault 와 Mio.CtlrFault 가 둘다 1인 경우에는 Servo driver의 알람코드를 나타낸다.	
            public short Mst;
            // Motion Status Flags //
            public TEcmSxSt_Flags Flags;
            // Digital Input //
            public TEcmSxSt_DI DI;
            // Position 정보 //
            public int CmdCnt, FeedCnt;
            // 속도 정보 //
            public int CmdVel, FeedVel;
            public short Torque;
            public int TouchProbPos1;
        }


        // Motion InputPDO에서 하나의 Axis의 Status 정보 구조체 형식 3 //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcmInPDO_AxisType3
        {
            private ushort data;
            public ushort PDOTypeID
            {
                get { return (ushort)(data & 0xFF); }
                set { data = (ushort)((data & 0xFF00) | (value & 0xFF)); }
            }

            public ushort TouchProbSts1
            {
                get { return (ushort)((data >> 8) & 0x7); }
                set { data = (ushort)((data & 0xF8FF) | ((value & 7) << 8)); }
            }

            public ushort TouchProbSts2
            {
                get { return (ushort)((data >> 11) & 0x7); }
                set { data = (ushort)((data & 0xC7FF) | ((value & 7) << 11)); }
            }

            public ushort SdInputSts //< SD 센서 입력 상태
            {
                get { return (ushort)((data >> 14) & 0x1); }
                set { data = (ushort)((data & 0xBFFF) | ((value & 1) << 14)); }
            }

            public ushort Resv1
            {
                get { return (ushort)((data >> 15) & 0x1); }
                set { data = (ushort)((data & 0x7FFF) | ((value & 1) << 15)); }
            }

            ////////////////////////////////////////////////////////////////////////////////////
            // Mst: Motion의 상태를 알리는 코드값. 이 값은 Mio의 일부 비트 상태에 따라서 그 의미가 달라진다.
            // 1) Mio.ServoFault=1인 경우: Servo driver의 알람코드를 나타낸다.
            // 2) Mio.CtlrFault=1인경우: Controller의 알람코드를 나타낸다.
            // 3) Mio.ServoFault=0, Mio.CtlrFault=0 인 경우: Motion Control 동작 상태 코드
            // 참고) Mio.ServoFault 와 Mio.CtlrFault 가 둘다 1인 경우에는 Servo driver의 알람코드를 나타낸다.	
            public short Mst;
            // Motion Status Flags //
            public TEcmSxSt_Flags Flags;
            // Digital Input //
            public TEcmSxSt_DI DI;
            // Position 정보 //
            public int CmdCnt, FeedCnt;
            // 속도 정보 //
            public int CmdVel, FeedVel;
            public short Torque;
            public int TouchProbPos1;
        }


        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TMPMonSectData
        {
            public Torq torq;
            public PosDev posDev;
            public struct Torq
            {
                public ushort Max; ///< 최대 토크 (0.1% 단위. 즉 1은 0.1%를 의미한다)
                public ushort Avg; ///< 평균 토크 (0.1% 단위. 즉 1은 0.1%를 의미한다) 
                public uint Dummy; ///< 64비트 정렬을 위한 dummy data
                public ulong ThreshCount; ///< 문턱값(threshold)을 넘어서는 토크값이 발생한 카운트
            }

            public struct PosDev
            {
                public uint Max; ///< 최대 위치편차
                public uint Avg; ///< 평균 위치편차
                public ulong ThreshCount; ///< 문턱값(threshold)을 넘어서는 위치편차값이 발생한 카운트
            }
            public ulong DataCount; ///< 해당 구간의 누적시간
        }


        public struct TMPMonData
        {
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 6)]
            public TMPMonSectData[] Section;
        }


        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcDateTime
        {
            public ushort wYear;
            public ushort wMonth;
            public ushort wDayOfWeek; // 이 필드는 사용 안할 수 있음
            public ushort wDay;
            public ushort wHour;
            public ushort wMinute;
            public ushort wSecond;
            public ushort wMilliseconds; // 이 필드는 사용 안할 수 있음
        }


        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcFwuFileInfo
        {
            // ecFWU_SIGNATURE	= 0x56981532; 
            public uint Signature; // 파일의 유효성을 나타내기 위해 사용하는 signature 0x56981532
            public uint FileSize;
            public TEcDateTime FileTime;
            public TEcDateTime DnldTime;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 128)]
            public byte[] Resv;
        }


        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcFwuStatus
        {
            // State 
            // bit 1: IsAbort, 
            // bit 3 : resv
            // bit 4 : phase (0 : idle. 1 : Downloading. 2 : Uploading. 3 : Verifying ) 
            // bit 4 : state (0 : before job, 1 : busy. 2 : normally complete(OK). 3 : Abnormally complete (Error)
            public ushort state;
            public ushort iProgress; // 진행율: 0.01% 단위의 값을 정수값으로 표현        
            public uint targSize;
            public uint doneSize;
        }


        // TEcSdoiODList: COE SDO Object Dictionary List 데이터 //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcSdoiODList
        {
            public ushort SturctType; // 구조체 타입: TEcSdoiODList, TEcSdoiObjDesc, TEcSdoiEntryDesc 의 세가지 구조체에 대한 메모리 해제를 할 때 ecGn_ReleaseSdoInfoData() 함수 하나를 통해서 수행하므로 전달된 구조체의 타입을 파악하기 위해서 필요하다.
            public ushort ListType;
            public ushort NumItems;
            private UIntPtr Items;
        }


        // TEcSdoiODList: COE SDO Object Description 데이터 //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcSdoiObjDesc
        {
            public ushort SturctType; // 구조체 타입: TEcSdoiODList, TEcSdoiObjDesc, TEcSdoiEntryDesc 의 세가지 구조체에 대한 메모리 해제를 할 때 ecGn_ReleaseSdoInfoData() 함수 하나를 통해서 수행하므로 전달된 구조체의 타입을 파악하기 위해서 필요하다.
            public ushort ObjIndex; // Object Index
            public ushort DataType; // Data Type of the object
            public byte MaxSubIdx; // Maximum number of sub indices
            public byte ObjCode;	 // Object Code: 7-Variable, 8-Array, 9-Record
            private UIntPtr pObjName; // Name of the object //ysy 확인필요 / t_char *pObjName; // Name of the object
        }


        // TEcSdoiODList: COE SDO Object Entry Description 데이터 //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcSdoiEntryDesc
        {
            public ushort SturctType; // 구조체 타입: TEcSdoiODList, TEcSdoiObjDesc, TEcSdoiEntryDesc 의 세가지 구조체에 대한 메모리 해제를 할 때 ecGn_ReleaseSdoInfoData() 함수 하나를 통해서 수행하므로 전달된 구조체의 타입을 파악하기 위해서 필요하다.
            public ushort ObjIndex; // Object Index
            public byte SubIndex;
            public byte ValueInfo; // 비트별로 pEntryData 값에 담기는 데이터의 종류를 나타내는데, 이 값이 0이면 pEntryData에는 SubIndex의 Object 이름이 담겨진다.
            public ushort DataType; // 해당 Object의 data type index
            public ushort BitLen; // bit length of the object
            public ushort ObjAccess; // 어떤 AL State에서 해당 object를 access할 수 있는지를 나타내는 값.
            private UIntPtr pEntryData; // Entry Description Data    //ysy 확인필요 / t_byte *pEntryData; // Entry Description Data    
        }


        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcmMTQ1Item
        {
            public short TorqVal; // 조건이 만족되었을 때 출력될 target torque value. 이 값의 단위는 0.1% 이다.
            public ushort RefAxis; // 조건 만족을 판단할 때 감시 대상이 되는 축 번호.
            public int RefCmpMode; // 조건 만족을 판단하는 방법. 이 값에 적용 가능한 값의 종류는 0-LT, 1-GT, 2-LE, 3-GE 이다(EEcmMT1CmpMode 선언 참조)
            public double RefPos; // 조건 만족 검사를 위한 기준 위치
        }


        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcmPC2DHeader
        {
            // Target Axis Information //
            [StructLayout(LayoutKind.Sequential, Pack = 1)]
            public struct TA
            {
                public double StartPos; // 첫 번째 열(Column)의 기준 위치 값
                public float StepSize; // 각 열(Column)의 기준 위치값의 거리 간격. 예를 들어서 두 번째 열의 기준 위치값은 (StartPos+StepSize)가 되고, 세 번째 열의 기준 위치값은 (StartPos+2*StepSize)가 되는 것이다.
                public uint StepCount; // 대상축의 티칭 포인트 갯수. 이 값은 결국 열(Column)의 갯수를 의미한다.
	        };

	        // Reference Axis information //
            [StructLayout(LayoutKind.Sequential, Pack = 1)]
            public struct RA
            {
                public uint Axis; // 참조축(Ref. Axis)의 번호
                public double StartPos; // 첫 번째 행(Row)에 해당하는 참조축의 기준 위치 값
                public float StepSize; // 각 행(Row)의 기준 위치값의 거리 간격. 예를 들어서 두 번째 행의 참조축 기준 위치값은 (StartPos+StepSize)가 되고, 세 번째 행의 참조축 기준 위치값은 (StartPos+2*StepSize)가 되는 것이다.
                public uint StepCount; // 참조축의 티칭 포인트 갯수. 이 값은 결국 행(Row)의 갯수
	        }

            public TA TargetAxis;
            public RA ReferenceAxis;
        }

        public struct TEcLogicAddr
        {
            public ushort AddrOfs; ///< Offset address
            public ushort BitIdx; ///< AddrOfs이 가리키는 영역의 바이트내에서 원하는 데이터가 위치한 bit index를 나타낸다. 
        }

        public struct TEcLogBitAddr
        {
            private uint data;

            public uint AddrOfs
            {
                get { return data & 0x3FFF; }
                set { data = (data & 0xFFFFC000) | (value & 0x3FFF); }
            }

            public uint ChanType
            {
                get { return ((data >> 14) & 0x3); }
                set { data = (data & 0xFFFFCFFF) | ((value & 3) << 14); }
            }

            public uint BitIdx
            {
                get { return (data >> 16); }
                set { data = (data & 0x0000FFFF) | ((value & 0xFFFF) << 16); }
            }
            //public uint AddrOfs;  //:	14; ///< 논리메모리(PDO영역) 상에서의 Offset address
            //public uint ChanType; //:	2;	///< LogBitAddr로 변환할 때 사용한 채널 형식,  0-Global, 1-Local, 2-Onboard, 3-Undefined 이와 관련하여 EEcIoChanType 선언 참고
            //public uint BitIdx;   //: 16; ///< AddrOfs이 가리키는 영역의 바이트내에서 원하는 데이터가 위치한 bit index를 나타낸다. 
        };

        public struct TEcLogBitAddrU
        {
            public uint d;
        }

        [StructLayout(LayoutKind.Explicit, Pack = 1)]
        public struct TEcmEmgInputEnv
        {
            [FieldOffsetAttribute(0)]
            public uint LogBitAddr; // 논리비트주소(Logic Bit Address). 이 데이터의 구조는 TEcLogBitAddr 구조체와 같다.
            [FieldOffsetAttribute(4)]
            public bool InvertLogic; // 입력 신호의 로직을 반전하여 사용할지를 설정한다.  0:입력된 신호값을 그대로 사용.  1:입력된 신호의값을 반전하여 사용	
            [FieldOffsetAttribute(5)]
            //[MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)]
            public byte Resv0; // 현재는 사용하지 않는 예비 변수
            [FieldOffsetAttribute(6)]
            public byte Resv1;
            [FieldOffsetAttribute(7)]
            public byte Resv2;
        };

        public struct HEmgInputEnv
        {
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
            public TEcmEmgInputEnv[] emgInputEnv;
        }

        //public static Func<dynamic, int, int, dynamic> SetBit = (v, n, s) => s == 1 ? v |= (1 << n) : v &= ~(1 << n);
        public static Func<ushort, int, ushort> GetBit = (v, n) => (ushort)((v >> n) & 0x1);

        
        public const int ecMAX_NUM_NET_PER_DEVICE = 2;
        public const int ecMAX_NUM_ONBOARD_INPUT = 8; // Onboard Digital Input 채널 갯수
        public const int ecMAX_NUM_ONBOARD_OUTPUT = 4; // Onboard Digital Output 채널 갯수
        public const int ecMAX_NUM_SLAVES = 1000;
        public const int ecMAX_NUM_AXES_PER_NET = 64;  // 하나의 Network에서 지원하는 최대 모션제어 축 수 
        public const int ecMAX_NUM_IX_AXES = 32;  // 하나의 보간맵에 맵핑할 수 있는 최대 축 수 
        public const int ecmMAX_NUM_MOT_IX_MAP = 32; ///< 최대 정의 가능한 보간 맵 갯수
        public const int ecMAX_NUM_InQUE_DATA_DESC = 32; ///< 하나의 InQUE채널에 할당할 수 있는 데이터 종류의 최대 갯수
        public const int ecmMAX_NUM_LIST_MOT_MAP = 8;
        public const int ecmMAX_NUM_PT_MOT_MAP = 8;
        public const int ecmMAX_NUM_AXES_PER_NET = ecMAX_NUM_AXES_PER_NET; ///< 최대 정의 가능한 보간 맵 갯수
        public const int ecmMAX_NUM_IX_AXES = ecMAX_NUM_IX_AXES;
        public const int ecmMAX_NUM_SPLINE_AXES = 8;
        public const int ecmMAX_NUM_SPLINE_OBJ = 100;
        public const int ecmMAX_NUM_SPLINE_INPUT_POINTS = 10000;
        public const int ecmMAX_NUM_EMG_INPUTS = 8;   // 최대 설정 가능한 EmgStop Input 채널 수
        public const int ecmMAX_NUM_COLLAS = 16;
        public const int ecmMAX_NUM_ATRQ_MULTIVALS = 1000;  // 최대 설정 가능한 AutoTorq 모드의 Multi-Value Items 갯수 
        public const int ecmMAX_POSCORR_TABLE_SIZE = 10000; //< 각 축별로 할당할 수 있는 Position Correction Table의 최대 크기                                                                      ///
        public const int ecmMAX_CMPCONT_TABLE_SIZE = 32768; //
        public const int ecmDEFAULT_LM_QUE_DEPTH = 50000; // default list motion queue depth
        
public enum EEcLocNetSel
        {
            ecNETSEL_NET0 = 0,
            ecNETSEL_NET1 = 1,
            ecNETSEL_ALL = 2
        }


        public enum EEcLogSectType
        {
            ecLOGSECT_DI,
            ecLOGSECT_DO,
            ecLOGSECT_AI,
            ecLOGSECT_AO,
            ecLOGSECT_SERVO,
            ecLOGSECT_ETC = 15,
            ecLOGSECT_INVALID = 16
        }


        public enum EEcAxisType
        {
            ecAXIS_TYPE_NONE, // Slave가 모션제어 기능이 없는 경우
            ecAXIS_TYPE_SERVO, // Slave가 servo driver인 경우
            ecAXIS_TYPE_STEP, // Slave가 step driver인 경우
            ecAXIS_TYPE_PULSEMOTION // Slave가 Pulse Motion Controller인 경우.
        }


        public enum EEcPdoSyncMode
        {
            FreeRUN, 
            SM2_Event,
            DC, 
            NONE = 0xf, // PDO Sync Mode 셋팅을 지원하지 않는 경우.
        }


        public enum EEcChanMapType
        {
            ecCH_MAP_TYPE_DI, // Digital Input Channel Mapping
            ecCH_MAP_TYPE_DO, // Digital Output Channel Mapping
            ecCH_MAP_TYPE_AI, // Analog Input Channel Mapping
            ecCH_MAP_TYPE_AO, // Analog Output Channel Mapping
            ecCH_MAP_TYPE_INVALID
        }


        public enum EEcAiDataType
        {
            ecAI_DT_INT, // signed integer
            ecAI_DT_UINT, // unsigned integer
            ecAI_DT_FLT, // floating point data
            ecAI_DT_INVALID
        }


        public enum EEcAiScaleType
        {
            ecAI_ST_MINMAX, // Scale데이터가 Min/Max 값을 나타내는 경우.
            ecAI_ST_MULTIPLY, // Scale 데이터가 곱하기값으로 사용되는 경우. 이 때는 ScaleMin 값이 계수값으로 사용된다.  
            ecAI_ST_INVALID
        }


        public enum EEcAoDataType
        {
            ecAO_DT_INT, // signed integer
            ecAO_DT_UINT, // unsigned integer
            ecAO_DT_FLT, // floating point data
            ecAO_DT_INVALID
        }


        public enum EEcAoScaleType
        {
            ecAO_ST_MINMAX, // Scale데이터가 Min/Max 값을 나타내는 경우.
            ecAO_ST_MULTIPLY, // Scale 데이터가 곱하기값으로 사용되는 경우. 이 때는 ScaleMin 값이 계수값으로 사용된다.  
            ecAO_ST_INVALID
        }


        public enum LogMemSectType
        {
            DI,
            DO,
            AI,
            AO,
            SERVO,
            ETC = 15
        }
        

        public enum EEcAliasILMode
        {
            NONE,
            ADO,
            REG134,
            INVALID
        };

        // FPRD/FPWR 시에 사용되는 Address 모드 //
        public enum EEcFPRWAddrMode
        {
	        ecFPRWADDR_ALIAS, 	// Alias 레지스터(0x12) 사용
	        ecFPRWADDR_CSA, 	// Configured Station Address(CSA) 레지스터(0x10) 사용
            ecFPRWADDR_INVALID
        };


        //============================================================================================
        //  Structures
        //============================================================================================

        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TCfgFileHeader
        {
            [Serializable]
            [StructLayout(LayoutKind.Sequential, Pack = 1)]
            public struct Version
            {
                public ushort Major;
                public ushort Minor;
            };

            [Serializable]
            [StructLayout(LayoutKind.Sequential, Pack = 1)]
            public struct Info
            {
                public ushort DevIdx;
                public ushort LcaNetIdx;
                public uint Resv1;
                public uint Resv2;
            };

            public Version version;
            public Info info;

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 10)]
            public uint[] dwReserved;
        }


        // 각 슬레이브의 Device Type 정보 : ecSlv_GetDevTypeInfo() 함수의 Argument로 사용됨. //
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcDevTypeInfo
        {
            public ushort DeviceType; // CoE SDO 1000h 값 참조.
            public ushort NumDI;
            public ushort NumDO;
            public ushort NumAI;
            public ushort NumAO;
            public ushort NumServo;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
            public ushort[] Resv;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcSmCfg
        {
            public ushort StaAddr;
            public ushort Len;
            public byte CtlByte;
            public byte ActByte;
            public ushort Resv; // Dummy 변수 4바이트 정렬을 맞추기 위해서 있는 것임.
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcFmmuCfg
        {
            public uint StaLAddr;
            public ushort Len;
            public byte LStaBit;
            public byte LStopBit;
            public ushort StaPAddr;
            public byte PStaBit;
            public byte Type;
            public byte Activate;
            public byte Resv1;
            public byte Resv2;
            public byte Resv3;
        }
        

        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TFmmu
        {
            public ushort num;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)] // MAX_NUM_FMMU = 3;
            public TFmmuAttr[] Attr;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
            public uint[] Resv;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TFmmuAttr
        {
            public short Sm;
            public ushort Type;
            public bool OpOnly;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
            public uint[] Resv;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TSm
        {
            public ushort num;
            public byte numOut;
            public byte numIn;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)] //#define MAX_NUM_SM		4
            public TSmAttr[] Attr;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
            public uint[] Resv;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TSmAttr
        {
            public ushort Type;
            public ushort MinSize;
            public ushort MaxSize;
            public ushort DefaultSize;
            public uint StartAddress;
            public uint ControlByte;
            public bool Enable;
            public bool OpOnly;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
            public uint[] Resv;
        }


        // ESI의 "DeviceType:Mailbox:CoE" 항목 //
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcMbxCoE
        {
#if BitFieldUsing
            [BitFieldInfo(0, 1)]    public uint IsSupport { get; set; }
            [BitFieldInfo(1, 1)]    public uint IsPdoAssign { get; set; }
            [BitFieldInfo(2, 1)]    public uint IsPdoConfig { get; set; }
            [BitFieldInfo(3, 1)]    public uint IsPdoUpload { get; set; }
            [BitFieldInfo(4, 1)]    public uint IsComptAccess { get; set; }
            [BitFieldInfo(5, 1)]    public uint IsSegmSdoSupp { get; set; }
            [BitFieldInfo(6, 26)]   public uint Resv { get; set; } 

#else
            uint data;
            public uint IsSupport
            {
                get { return data & 1; }
                set
                {
                    if ((value & 1) == 1)
                        data |= ((value & 1) << 0);
                    else
                        data &= ~((value & 1) << 0);
                }
            }

            public uint IsPdoAssign
            {
                get { return (data >> 1) & 1; }
                set
                {
                    if ((value & 1) == 1)
                        data |= ((value & 1) << 1);
                    else
                        data &= ~((value & 1) << 1);
                }
            }

            public uint IsPdoConfig
            {
                get { return (data >> 2) & 1; }
                set
                {
                    if ((value & 1) == 1)
                        data |= ((value & 1) << 2);
                    else
                        data &= ~((value & 1) << 2);
                }
            }

            public uint IsPdoUpload
            {
                get { return (data >> 3) & 1; }
                set
                {
                    if ((value & 1) == 1)
                        data |= ((value & 1) << 3);
                    else
                        data &= ~((value & 1) << 3);
                }
            }

            public uint IsComptAccess
            {
                get { return (data >> 4) & 1; }
                set
                {
                    if ((value & 1) == 1)
                        data |= ((value & 1) << 4);
                    else
                        data &= ~((value & 1) << 4);
                }
            }

            public uint IsSegmSdoSupp
            {
                get { return (data >> 5) & 1; }
                set
                {
                    if ((value & 1) == 1)
                        data |= ((value & 1) << 5);
                    else
                        data &= ~((value & 1) << 5);
                }
            }
#endif
        }



        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcPdoAssObj
        {
            public byte SmIdx;
            public byte NumAssVals;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 255)]
            public ushort[] AssVal;	    // 이멤버의 배열 크기는 255로 설정되어 있으나 이것은 구조체의 틀을 잡기 위한 것이고 실제 사용되는 AssVal 배열의 크기는 NumAssVals 가 결정한다.
        }


        // Slave configuration //
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcSlaveCfg
        {
            public uint VendId;
            public uint ProdCode;
            public short AutoAddr; // 자동주소. 연결순서대로 매겨지는 주소로서 첫번째 슬레이브는 0 두번째는 -1, 세번째는 -2,....의 순으로 값이 설정된다.
            public ushort PhysAddr; // 물리주소

#if BitFieldUsing
            [BitFieldInfo(0, 4)]   public uint SmIdx_OutMbx { get; set; }
            [BitFieldInfo(4, 4)]   public uint SmIdx_InMbx { get; set; }
            [BitFieldInfo(8, 4)]   public uint AxisType { get; set; }
            [BitFieldInfo(12, 4)]  public uint NumSM { get; set; }
            [BitFieldInfo(16, 4)]  public uint SmSyncMode { get; set; }
            [BitFieldInfo(20, 2)]  public uint AliasILMode { get; set; }
            [BitFieldInfo(22, 2)]  public uint AliasILSize { get; set; }
            [BitFieldInfo(24, 1)]  public uint FPRWAddrMode { get; set; }
            [BitFieldInfo(25, 7)]  public uint Resv1 { get; set; }

#else
            private uint data;

            public uint SmIdx_OutMbx
            {
                get { return (data & 0xF); }
                set { data = ((data & 0xFFFFFFF0) | (value & 0xF)); }
            }

            public uint SmIdx_InMbx
            {
                get { return ((data >> 4) & 0xF); }
                set { data = ((data & 0xFFFFFF0F) | ((value & 0xF) << 4)); }
            }

            public uint AxisType    // 0-Axis가 아님, 1-servo driver, 2-step driver, 3-pusle motion, 4-other
            {
                get { return ((data >> 8) & 0xF); }
                set { data = ((data & 0xFFFFF0FF) | ((value & 0xF) << 8)); }
            }

            public uint NumSM
            {
                get { return ((data >> 12) & 0xF); }
                set { data = ((data & 0xFFFF0FFF) | ((value & 0xF) << 12)); }
            }

            public uint SmSyncMode
            {
                get { return ((data >> 16) & 0xF); }
                set { data = ((data & 0xFFF0FFFF) | (value & 0xF) << 16); }
            }

            public uint AliasILMode
            {
                get { return ((data >> 20) & 0x3); }
                set { data = ((data & 0xFFCFFFFF) | (value & 0x3) << 20); }                
            }

            public uint AliasILSize
            {
                get { return ((data >> 22) & 0x3); }
                set { data = ((data & 0xFF3FFFFF) | (value & 0x3) << 22); }
            }

            public uint FPRWAddrMode
            {
                get { return ((data >> 24) & 0x1); }
                set { data = ((data & 0xFEFFFFFF) | (value & 0x1) << 24); }
            }

            //public uint Resv1
            //{
            //    get { return ((data >> 25) & 0x7F); }
            //    set { data = ((data & 0x1FFFFFFF) | (value & 0x7F) << 25); }
            //}
#endif
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = ecMAX_NUM_SMMU)]  // SizeConst = ecMAX_NUM_FMMU
            public TEcSmCfg[] SM;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = ecMAX_NUM_FMMU)]  // SizeConst = ecMAX_NUM_FMMU
            public TEcFmmuCfg[] FMMU;
            public TEcMbxCoE MbxCoE;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = ecPDO_ASSGN_SECT_SIZE)] // SizeConst = ecPDO_ASSGN_SECT_SIZE
            public byte[] PdoAssData;

            public ushort AliasILReg;
            public ushort AliasILValue;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TPdo
        {
            public ushort RxNum;	// RxPDO 수
            public ushort TxNum;	// RxPDO 수
            public ushort TxLength;
            public ushort RxLength;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]//#define MAX_NUM_PDO_ASSIGN	32
            public TPdoAttr[] Rx;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)] //#define MAX_NUM_PDO_ASSIGN	32
            public TPdoAttr[] Tx;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
            public uint[] uiResv;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TPdoAttr
        {
            public bool Exclude;
            public bool Fixed;
            public bool Mandatory;
            public bool IsSm;
            public ushort SmIdx;
            public ushort Index;
            public ushort NumEntry;
            public ushort Size;
            public ushort LstIdx;

            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 40)] //#define CSR_DEV_ELEM		40        
            public string Name;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
            public uint[] uiResv;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]//#define MAX_NUM_PDO_ENTRY	16
            public TPdoEntryAttr[] Entry;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TPdoEntryAttr
        {
            public ushort Index;		// M
            public ushort SubIndex;
            public ushort BitLen;		// M
            public byte DScaleNo;
            public byte DataTypeNo;

            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 40)]
            public string Name;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 40)]
            public string DataType;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TAlias
        {
            public byte ILMode;
            public ushort ILReg;
            public byte ILSize;
            public ushort Value;
        }
        

        // a 'Logical Memory Section' configuration //
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcLogMemSectCfg
        {
            //char szName[ecMAX_LMEM_SECT_NAME_LEN];
            public byte Type; // 0-DI, 1-DO, 2-AI, 3-AO, 4-SERVO, 5-ETC

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)]
            public byte[] Resv;
            public ushort StartAddr; // Section의 시작주소 (Logical Memory 내에서의 주소), 2048보다 작아야 한다.
            public ushort Length; // Section 바이트 크기. 2048보다 작아야 한다. 
        }



        // Network configuration header //
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcNetConfig
        {
            public uint Version;  // <= t_ui32	NetID;
            public uint CycleTime;
            public byte NumOutpdoLogSects; // Number of logical memory sections which has been defined
            public byte NumInpdoLogSects; // Number of logical memory sections which has been defined
            public ushort NumSlaves; // Number of cofgured slaves
            public ushort NumDiChanMaps;
            public ushort NumDoChanMaps;
            public ushort NumAiChanMaps;
            public ushort NumAoChanMaps;

            uint data;
            public uint IsAllFPRWAlias
            {
                get { return (data & 0x1); }
                set { data = value & 0x1; }
            }

            //public uint Resv1
            //{
            //    get { return ((data >> 25) & 0x7F); }
            //    set { data = ((data & 0x1FFFFFFF) | (value & 0x7F) << 25); }
            //}

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 52)]
            public byte[] Resv;
        }


        

        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TNetworkInfo
        {
            public TEcNetConfig EcNetCfg;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
            TEcLogMemSectCfg[]	EcLogMemOut;	// DO, AO, SERVO, ETC
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
	        TEcLogMemSectCfg[]	EcLogMemIn;	// DI, AI, SERVO, ETC

	        ushort				LenRxPdo;
	        ushort				LenTxPdo;

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = NUM_DEV_TYPE)]
	        short[]				DevNum;

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
	        uint[]				uiResv;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CSR_MAX_PATH)]
	        char[]				szResv;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TChanInfo
        {
            public ushort DiChanMapCnt;
            public ushort DoChanMapCnt;
            public ushort AiChanMapCnt;
            public ushort AoChanMapCnt;

            //[Serializable]
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 1000)]
            public TEcDiChanMap[] DiChanMap;

            //[Serializable]
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 1000)]
            public TEcDoChanMap[] DoChanMap;

            //[Serializable]
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 1000)]
            public TEcAioChanMap[] AiChanMap;

            //[Serializable]
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 1000)]
            public TEcAioChanMap[] AoChanMap;
        };

        
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TDScaleInfo
        {
            public byte	Type;
	        public float	ScaleMin;
	        public float	ScaleMax;
	        public string  Name;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TDScale
        {
            public byte         No;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = MAX_NUM_DSCALE)]
	        public TDScaleInfo[]	Info;
        }



        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TDc
        {
            public ushort NumOpMode;

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)] //MAX_NUM_DC_OPMODE = 8
            public TDcInfo[] Info;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TDcInfo
        {
            public string Name;
            public string Desc;
            public ushort AssignActivate;
            public ushort CylTmSync0;
            public ushort CylTmSync0Factor;
            public ushort ShftTmSync0;
            public ushort CylTmSync1;
            public ushort CylTmSync1Factor;
            public ushort ShftTmSync1;

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
            public uint[] uiResv;
        }


        


        // Digital Input Global Channel 맵핑 정보 //
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcDiChanMap
        {
            public ushort SlvIdx;
            public ushort StaGlobChan;
            public ushort StaLogAddr; // start logical address
            public byte StaLogBit;	// start bit of logical data
            public byte NumChans;	// number of channels in this channel group
        }


        // Digital Output Global Channel 맵핑 정보 //
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcDoChanMap
        {
            public ushort SlvIdx;
            public ushort StaGlobChan;
            public ushort StaLogAddr; // start logical address
            public byte StaLogBit;	// start bit of logical data
            public byte NumChans;	// number of channels in this channel group
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcAioChanMap
        {
            public ushort SlvIdx;
            public ushort StaLogAddr;
            public uint Data;
            public uint StaLogBit // :4
            {
                get { return (uint)(Data & 0xf); }
                set { Data = (Data & 0xfffffff0) | (uint)(value & 0xf); }
            }

            public uint BitLength // :6
            {
                get { return (uint)((Data >> 4) & 0x3f); }
                set { Data = (uint)((Data & 0xFFFFFC0F) | ((value & 0x3F) << 4)); }
            }

            public uint DataType // :3 // 0-signed int, 1-unsigned int, 2-float; EEcAiDataType 타입 참조 
            {
                get { return (uint)((Data >> 10) & 0x7); }
                set { Data = (uint)((Data & 0xFFFFE3FF) | ((value & 0x7) << 10)); }
            }

            public uint ScaleType  // :3 //0-MinMax, 1-Multiply; EEcAiScaleType 타입 참조 
            {
                get { return (uint)((Data >> 13) & 0x7); }
                set { Data = (uint)((Data & 0xFFFF1FFF) | ((value & 0x7) << 13)); }
            }

            public float ScaleMin;	// Scale Min. Value, 단 ScaleType=ecAI_ST_MULTIPLY인 경우에는 이 값은 Multiplication 값을 셋팅한다.  
            public float ScaleMax;	// Scale Max. Value, 단 ScaleType=ecAI_ST_MULTIPLY인 경우에는 이 값은 무시된다.
        };


        //// Analog Output Global Channel 맵핑 정보 //
        //[Serializable]
        //[StructLayout(LayoutKind.Sequential, Pack = 1)]
        //public struct TEcAoChanMap
        //{
        //    public ushort SlvIdx;
        //    public ushort StaLogAddr;
        //    public uint Data;
        //    public uint StaLogBit // :4
        //    {
        //        get { return (uint)(Data & 0xf); }
        //        set { Data = (Data & 0xfffffff0) | (uint)(value & 0xf); }
        //    }

        //    public uint BitLength // :6
        //    {
        //        get { return (uint)((Data >> 4) & 0x3f); }
        //        set { Data = (uint)((Data & 0xFFFFFC0F) | ((value & 0x3F) << 4)); }
        //    }

        //    public uint DataType // :3 // 0-signed int, 1-unsigned int, 2-float; EEcAiDataType 타입 참조 
        //    {
        //        get { return (uint)((Data >> 10) & 0x7); }
        //        set { Data = (uint)((Data & 0xFFFFE3FF) | ((value & 0x7) << 10)); }
        //    }

        //    public uint ScaleType  // :3 //0-MinMax, 1-Multiply; EEcAiScaleType 타입 참조 
        //    {
        //        get { return (uint)((Data >> 13) & 0x7); }
        //        set { Data = (uint)((Data & 0xFFFF1FFF) | ((value & 0x7) << 13)); }
        //    }

        //    public float ScaleMin;	// Scale Min. Value, 단 ScaleType=ecAI_ST_MULTIPLY인 경우에는 이 값은 Multiplication 값을 셋팅한다.  
        //    public float ScaleMax;	// Scale Max. Value, 단 ScaleType=ecAI_ST_MULTIPLY인 경우에는 이 값은 무시된다.
        //}

        
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcEscdHeader
        {
	        public int	ESCDSectSignature;	    // 0x50321234
            public int	ESCDSectTotSize;        // 단 ESCDSectSignature 항목은 크기 계산에서 제외
            public int	NumSlaves;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 128)]
            public byte[] Reserved;
        };

        
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcEscdSlvHeader
        {
            public short SlaveSectSize;
            public short NumSlvCfgItems;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcEscdSlvData
        {
            public short MapIndex;
            public sbyte NumMapItems;
            public sbyte IsFixedMap;
            public int[] MapData;
        }


        // ESCD 데이터 아이템 중에서 PDO 맵핑 데이터용 구조체 (ESCD Type 0 & 1)  //
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcEscdSlvItem
        {
            public short DataType;
            public short DataSize;
            public TEcEscdSlvData Data;		// Entry 수
        }


        // ESCD 데이터 아이템 중에서 SlaveAxisInfo 데이터용 구조체 (ESCD Type 0 & 1)  //
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcEscdSlvAxisInfo
        {
            public short DataType;
            public short DataSize;
            public TSlvAxisInfo SlvAxisInfo;
        }

        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcEscdSlv
        {
            public TEcEscdSlvHeader Header;
            public uint numMappingItems;
            //public IntPtr Item;
            //[MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
            public TEcEscdSlvItem[] Item;		// PDO 수
            //[MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
            public TEcEscdSlvAxisInfo SlvAxisInfo;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TEcEscd
        {
            public TEcEscdHeader Header;
            //public IntPtr Slave;
            //[MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
            public TEcEscdSlv[] Slave;		// ESCD 슬레이브 수
        }


        // 슬레이브가 Axis 슬레이브인 경우에 ComiEcatDevInfo.xml 파일에서 설정해주는 정보 //
        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TSlvAxisInfo
        {
            public byte IsMultiAxes;    // 다축을 지원하는 슬레이브인지...
            public byte Resv;

            //< 각 축의 SDO 인덱스의 Offset 값 
            public ushort SdoIdxOfs;            

            // PDO맵인덱스 값을 로컬축번호로 변환하는데 필요한 정보 (IsMultiAxes=1인 경우에만 사용됨) //
            [Serializable]
            [StructLayout(LayoutKind.Sequential, Pack = 1)]
            public struct PDOM2Axis
            {
                ///////////////////////////////////////////////////////////////////////////////
                // (BaseMapIdx <= PDOMap <= MaxMapIdx)조건을 만족하는 맵번호에 대해서
                // LocalAxis = ((PDOMap & Mask) >> Shift) 의 식으로 축번호를 계산한다.
                // 예를들어서 Mask=0xF0, Shift=4, PDOMap=0x1610이면, LocalAxis=((0x1610 & 0xF0)>>4)=1이 된다.
                // 그리고 OutputPDO에 대해서는 BaseMapIdx = 0x1600 + BaseMapIdxOfs 가 되고, InputPDO에 대해서는 BaseMapIdx = 0x1A00 + BaseMapIdxOfs 가 된다.
                // 마찬가지로 OutputPDO에 대해서는 MaxMapIdx = 0x1600 + MaxMapIdxOfs 가 되고, InputPDO에 대해서는 BaseMapIdx = 0x1A00 + MaxMapIdxOfs 가 된다.

                public ushort BaseMapIdxOfs; // 로컬축번호를 구분하기 위해서 사용되는 PDO맵번호의 최소값 (0x1600 또는 0x1A00 으로부터의 Offset값으로 정의함)
                public ushort MaxMapIdxOfs; // 로컬축번호를 구분하기 위해서 사용되는 PDO맵번호의 최대값 (0x1600 또는 0x1A00 으로부터의 Offset값으로 정의함)
                public ushort Mask; // 맵번호를 마스킹하는 값
                public ushort Shift; // 맵번호를 쉬프트하는 값
            }

            public PDOM2Axis pdoM2Axis;
            public ushort SlotScanObject;
        }

        

        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TPrevDev
        {
            public ushort DevType;
            public uint VendorId;
            public uint ProductCode;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TBackupNetInfo
        {
            public bool IsChange;
            public bool IsFile;
            public string Path;
        }

        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TXmlVen
        {
            uint 	Id;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CSR_DEV_NAME)]
	        char[] 	Name;
	        IntPtr 	Icon;
	        uint	IconNo;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
	        uint[]	uiResv;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TXmlGrp
        {
            uint	VenIdx;
	        byte	PhysisType;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 40)]
	        char[] 	Type;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CSR_DEV_NAME)]
	        char[] 	Name;
	        IntPtr 	Icon;
	        uint	IconNo;
	        short	GrpDevType;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
	        uint[]	uiResv;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TXmlDev
        {
            byte	PhysisType;	// 0 : Slave("YY"), 1 : Counpler Slave("KK"), 2 : Coulper("YKY")
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
	        char[] 	Physis;
	        uint	ProductCode;
	        uint	RevisionNo;
	        ushort	ProfileNo;
	        ushort	Alias;
	        ushort  ModProfNo;

            bool	bIsInfoFile;
	        short	NumRxCh, NumTxCh;
            short	NumRxPdo, NumTxPdo;
            short	NumRxSm, NumTxSm;
            TPdoEntryInfo[]	RxPEI;
            TPdoEntryInfo[]	TxPEI;

	        TInfo		Info;
	        TProfile	Profile;
	        bool	PhysAddrChk;	// Physical address duplication check
   	        bool	PhysAddrChange;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CSR_DEV_NAME)]
            char[]  Type;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CSR_DEV_NAME)]
	        char[] 	Name;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CSR_FILE_NAME)]
	        char[]	URL;
	        IntPtr 	Icon;
	        uint	IconNo;
            TSlvAxisInfo SlvAxisInfo;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 29)]
	        uint[]	uiResv;
        }

        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TInfo
        {
            byte	NumCh;
	        TVendorSpecific DfltPdoAssin;
        }


        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TVendorSpecific
        {
            byte	NumSm;
	        byte	NumPdo;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = MAX_NUM_SM)]
	        byte[]	DfltSmNo;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = MAX_NUM_PDO_ENTRY)]
	        ushort[]	DfltPdoIdx;
        }

        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TProfile
        {
            ushort	ProfileNo;
	        ushort	AddInfo;
	        ushort	ChannelCount;	// <ChannelInfo> 속성이 있으면 수가 채널 수 이다.
        }

        [Serializable]
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        public struct TPdoEntryInfo
        {
            ushort	Index;		// M
	        ushort	SmNo;
            ushort	NumEtry;
	        ushort	NumCh;
	        ushort	BitLen;
	        ushort	ChStartBit;
	        ushort	ChBitLen;
            short	DataType;
	        short	DScale;
        }


        [Serializable]
        public class SlotInfos
        {
            public bool isReadInfo = false;
            public int SlotPdoIncrement;
            public bool isSlotPdoIncrementExist = false;
            public int SlotIndexIncrement;
            public bool IsSlotIndexIncrementExist;
            //public int XmlSlotCount;
            public List<SlotInfo> slotList = new List<SlotInfo>();
        }


        //[Serializable]
        //[StructLayout(LayoutKind.Sequential, Pack = 1)]
        public class SlotInfo
        {
            public int minInstances;
            public int maxInstances;
            public string name;
            public int moduleIdent;
            public int defaultVal;
            public int moduleCount;
            //public ModuleInfo[] moduleInfo;
        }

        [Serializable]
        public class ModuleInfos
        {
            public int moduleCount = 0;
            public List<ModuleInfo> moduleList;

            public ModuleInfos()
            {
                moduleList = new System.Collections.Generic.List<ModuleInfo>();
            }
        }

        [Serializable]
        //[StructLayout(LayoutKind.Sequential, Pack = 1)]
        public class ModuleInfo
        {
            public string type;
            public int moduleIdent;
            public string name;
            public TPdo pdoList;
        }

        public const int ecMAX_NUM_LMEM_SECTIONS = 16;	// Maximum number of logical memory sections
        public const int ecMAX_LMEM_SECT_NAME_LEN = 63;	// Maximum string length of a logical memory section

        // 여기서 정의하는 논리메모리의 Base주소는 내부적으로만 사용되는 것이며 사용자가 사용할 때는 
        // InputPDO 영역과 OutputPDO 영역 모두 주소가 0부터 시작한다.
        public const int ecINPDO_BASE_LOGIC_ADDR = 10000;
        public const int ecOUTPDO_BASE_LOGIC_ADDR = 0;

        public const int ecSLAVE_ID_MASTER = 0xffff;   // Master 스스로가 처리해야 하는 Command일 때 SlaveIdx 값 대신에 셋팅해야 하는 ID값 

        public const int ecMAX_NUM_SMMU = 8;
        public const int ecMAX_NUM_FMMU = 8;
        public const int ecMAX_NUM_PDO_UNIT = 4; // OutPDO / InPDO 각각으로 할당되는 SyncManager의 최대갯수 (In / Out 각각에 할당될 수 있는 최대 갯 수임)
        public const int ecMAX_NUM_PDO_ASSIGN = 8;
        public const int NUM_DEV_TYPE = 13;
        public const int CSR_MAX_PATH = 260;
        public const int CSR_FILE_NAME	= 60;
        public const int CSR_USR_NAME	= 100;
        public const int CSR_DEV_NAME	= 100;
        public const int CSR_DEV_ELEM	= 40;
        public const int MAX_NUM_DSCALE = 19;

        public const int MAX_NUM_SM		= 4;
        public const int MAX_NUM_PDO_ENTRY = 16;
        public const int ecPDO_ASSGN_SECT_SIZE = 136;

        public enum EEcEscdTypeId
        {
	        ESCD_TYPE_OutPdoMap,  	// OutPDO Mapping Data
	        ESCD_TYPE_InPdoMap,		// InPDO Mapping Data
	        ESCD_TYPE_AxisInfo		// Axis Information
        };
    }
}

