        
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

using cmm = Cmmsdk.SafeNativeMethods;
using ec = ComiECAT.SafeNativeMethods;

namespace Runner
{
    public partial class MainForm : Form
    {

        public bool isPause = false;
        public bool isStop = false;


        private void btnInit_Click(object sender, EventArgs e)
        {
            int numAxes = 0;
            cmm.cmmGnDeviceLoad(0, ref numAxes);
            
            for(int i=0; i< numAxes; i++)
            {
                cmm.cmmGnSetServoOn(i,1);
                cmm.cmmStSetPosition(i,0,0);
            }
            //ToDo
        }


        private void btnStart_Click(object sender, EventArgs e)
        {
            isPause = false;
            isStop = false;

            ThreadPool.QueueUserWorkItem(new WaitCallback(MainLoop));
        }


        

        private void MainLoop(object obj)
        {
            while(!isStop)
            {
                if(isPause)
                {
                    Thread.Sleep(200);
                    continue;
                }
                
                for(int i=0;i<8;i++)
                {
                    cmm.cmmSxMoveStart(i,12345);
                    Thread.Sleep(100);
                }
                Thread.Sleep(500);
                    
            }
            //ToDo
        }

        private void btnPause_Click(object sender, EventArgs e) 
        { 
            isPause = !isPause; 
        }

        private void btnStop_Click(object sender, EventArgs e) 
        { 
            isStop = true; 
        }
    }
}
        