/*******************************************************************************
* [ ComiEcatSdk_Loader.cpp ]
* Source(C/C++) file for loading COMIZOA ECAT SDK library
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
********************************************************************************/

#include "stdafx.h" // VC++  ƴ ٸ     Ͻʽÿ.

#if defined(__BCPLUSPLUS__)  // Borland C++ Builder specific
 #include <vcl.h>
 #pragma hdrstop
#endif

#include <windows.h>
#define _COMIECAT_SDK_LOADER_C_
#include "ComiEcatSdk_API.h"
#include <stdio.h>

#define __DLL_FILE_FULL_PATH__ "ComiEcatSdk.DLL"

typedef struct{
    char *name;
    FARPROC* ptr;
}LIB_FUNCT;

static HINSTANCE g_hCmmLibrary=NULL;

static LIB_FUNCT g_ecSdkFunc[] = {
	{"ecGn_LoadDevice",			(FARPROC*)&ecGn_LoadDevices},
	{"ecGn_UnloadDevices",		(FARPROC*)&ecGn_UnloadDevices},
	{"ecGn_SetBootWaitMode",	(FARPROC*)&ecGn_SetBootWaitMode},
	{"ecGn_GetBootWaitMode",	(FARPROC*)&ecGn_GetBootWaitMode},	
	{"ecGn_SetEnableTimerResolSet",	(FARPROC*)&ecGn_SetEnableTimerResolSet},	
	{"ecGn_GetEnableTimerResolSet",	(FARPROC*)&ecGn_GetEnableTimerResolSet},	
	{"ecGn_IsDevLoaded",		(FARPROC*)&ecGn_IsDevLoaded},
	{"ecGn_GetNumDevices",		(FARPROC*)&ecGn_GetNumDevices},
	{"ecGn_GetNumNetworks",		(FARPROC*)&ecGn_GetNumNetworks},
	{"ecGn_GetDevInfo",			(FARPROC*)&ecGn_GetDevInfo},
	{"ecGn_GetDebugData",		(FARPROC*)&ecGn_GetDebugData},
	{"ecGn_OutpB",				(FARPROC*)&ecGn_OutpB},
	{"ecGn_OutpsB",				(FARPROC*)&ecGn_OutpsB},
	{"ecGn_OutpW",				(FARPROC*)&ecGn_OutpW},
	{"ecGn_OutpsW",				(FARPROC*)&ecGn_OutpsW},
	{"ecGn_OutpD",				(FARPROC*)&ecGn_OutpD},
	{"ecGn_OutpsD",				(FARPROC*)&ecGn_OutpsD},
	{"ecGn_InpB",				(FARPROC*)&ecGn_InpB},
	{"ecGn_InpsB",				(FARPROC*)&ecGn_InpsB},
	{"ecGn_InpW",				(FARPROC*)&ecGn_InpW},
	{"ecGn_InpsW",				(FARPROC*)&ecGn_InpsW},
	{"ecGn_InpD",				(FARPROC*)&ecGn_InpD},
	{"ecGn_InpsD",				(FARPROC*)&ecGn_InpsD},
	{"ecGn_DbgTempCmd",			(FARPROC*)&ecGn_DbgTempCmd},
	{"ecGn_ReadInPDO",			(FARPROC*)&ecGn_ReadInPDO},
	{"ecGn_ReadDspDbgData_I",	(FARPROC*)&ecGn_ReadDspDbgData_I},
	{"ecGn_WriteDspDbgData_I",	(FARPROC*)&ecGn_WriteDspDbgData_I},
	{"ecGn_ReadDspDbgData_F",	(FARPROC*)&ecGn_ReadDspDbgData_F},
	{"ecGn_WriteDspDbgData_F",	(FARPROC*)&ecGn_WriteDspDbgData_F},
	{"ecDlog_SetFilePath",		(FARPROC*)&ecDlog_SetFilePath},
	{"ecDlog_GetFilePath",		(FARPROC*)&ecDlog_GetFilePath},
	{"ecDlog_SetLogType",		(FARPROC*)&ecDlog_SetLogType},
	{"ecDlog_GetLogType",		(FARPROC*)&ecDlog_GetLogType},
	{"ecDlog_SetLogLevel",		(FARPROC*)&ecDlog_SetLogLevel},
	{"ecDlog_GetLogLevel",		(FARPROC*)&ecDlog_GetLogLevel},	
	{"ecDlog_SetLogMemSize",	(FARPROC*)&ecDlog_SetLogMemSize},
	{"ecDlog_GetLogMemSize",	(FARPROC*)&ecDlog_GetLogMemSize},
	{"ecDlog_GetMemoryLogSts",	(FARPROC*)&ecDlog_GetMemoryLogSts},	
	{"ecDlog_DumpMemoryLog",	(FARPROC*)&ecDlog_DumpMemoryLog},
	{"ecDlog_DumpMemoryLog2",	(FARPROC*)&ecDlog_DumpMemoryLog2},
	{"ecDlog_GetLastDumpFilePath",	(FARPROC*)&ecDlog_GetLastDumpFilePath},
	{"ecNet_IsBootCompt",		(FARPROC*)&ecNet_IsBootCompt},
	{"ecNet_GetDevIdx",			(FARPROC*)&ecNet_GetDevIdx},
	{"ecNet_GetLocNetIdx",		(FARPROC*)&ecNet_GetLocNetIdx},
	{"ecNet_GetVerInfo",	(FARPROC*)&ecNet_GetVerInfo},
	{"ecNet_SetFastFuncType",	(FARPROC*)&ecNet_SetFastFuncType},
	{"ecNet_GetFastFuncType",	(FARPROC*)&ecNet_GetFastFuncType},
	{"ecNet_SendRcvEcatCmd",	(FARPROC*)&ecNet_SendRcvEcatCmd},
	{"ecNet_ScanSlaves",		(FARPROC*)&ecNet_ScanSlaves},
	{"ecNet_GetCfgSlaveCount",	(FARPROC*)&ecNet_GetCfgSlaveCount},
	{"ecNet_SetCfgSlaveCount",	(FARPROC*)&ecNet_SetCfgSlaveCount},
	{"ecNet_SetAlState",		(FARPROC*)&ecNet_SetAlState},
	{"ecNet_SetAlState_FF",		(FARPROC*)&ecNet_SetAlState_FF},
	{"ecNet_GetAlState",		(FARPROC*)&ecNet_GetAlState},
	{"ecNet_SlvComErrSum_GetEnable",	(FARPROC*)&ecNet_SlvComErrSum_GetEnable},
	{"ecNet_SlvComErrSum_SetEnable",	(FARPROC*)&ecNet_SlvComErrSum_SetEnable},	
	{"ecNet_SlvComErrSum_ClearAll",	(FARPROC*)&ecNet_SlvComErrSum_ClearAll},
	{"ecNet_GetLastPDOIdx",		(FARPROC*)&ecNet_GetLastPDOIdx},
	{"ecNet_IsPDOIdxCompt",		(FARPROC*)&ecNet_IsPDOIdxCompt},
	{"ecNet_WaitPDOIdxCompt",	(FARPROC*)&ecNet_WaitPDOIdxCompt},
	{"ecNet_WaitPDOIdxCompt_NB",(FARPROC*)&ecNet_WaitPDOIdxCompt_NB},
	{"ecNet_IsCmdIdxCompt",		(FARPROC*)&ecNet_IsCmdIdxCompt},
	{"ecNet_WaitCmdIdxCompt",	(FARPROC*)&ecNet_WaitCmdIdxCompt},
	{"ecNet_WaitCmdIdxCompt_NB",(FARPROC*)&ecNet_WaitCmdIdxCompt_NB},
	{"ecNet_GetCycleProcessTime",(FARPROC*)&ecNet_GetCycleProcessTime},
	{"ecNet_FWDnld_Process",	(FARPROC*)&ecNet_FWDnld_Process},
	{"ecNet_FWDnld_Cancel",		(FARPROC*)&ecNet_FWDnld_Cancel},
	{"ecNet_FWDnld_GetSts",		(FARPROC*)&ecNet_FWDnld_GetSts},
	{"ecNet_FWDnld_GetSts",		(FARPROC*)&ecNet_FWDnld_GetSts},
	{"ecNet_FWUpld_GetFileInfo",	(FARPROC*)&ecNet_FWUpld_GetFileInfo},
	{"ecNet_FWUpld_Process",	(FARPROC*)&ecNet_FWUpld_Process},
	{"ecNet_FWUpld_Cancel",		(FARPROC*)&ecNet_FWUpld_Cancel},
	{"ecNet_FWUpld_GetSts",		(FARPROC*)&ecNet_FWUpld_GetSts},
	{"ecNet_FWUpld_ResetSts",	(FARPROC*)&ecNet_FWUpld_ResetSts},
	{"ecNet_InPDO_GetBufPtr",	(FARPROC*)&ecNet_InPDO_GetBufPtr},
	{"ecNet_InPDO_GetData",		(FARPROC*)&ecNet_InPDO_GetData},
	{"ecNet_InPDO_GetData_I8",	(FARPROC*)&ecNet_InPDO_GetData_I8},
	{"ecNet_InPDO_GetData_I16",	(FARPROC*)&ecNet_InPDO_GetData_I16},
	{"ecNet_InPDO_GetData_I32",	(FARPROC*)&ecNet_InPDO_GetData_I32},
	{"ecNet_InPDO_GetData_U8",	(FARPROC*)&ecNet_InPDO_GetData_U8},
	{"ecNet_InPDO_GetData_U16",	(FARPROC*)&ecNet_InPDO_GetData_U16},
	{"ecNet_InPDO_GetData_U32",	(FARPROC*)&ecNet_InPDO_GetData_U32},
	{"ecNet_InPDO_GetData_R32",	(FARPROC*)&ecNet_InPDO_GetData_R32},
	{"ecNet_InPDO_GetSectPos",	(FARPROC*)&ecNet_InPDO_GetSectPos},	
	{"ecNet_InQue_ClearChanList",	(FARPROC*)&ecNet_InQue_ClearChanList},
	{"ecNet_InQue_AddChannel",	(FARPROC*)&ecNet_InQue_AddChannel},
	{"ecNet_InQue_DelChannel",	(FARPROC*)&ecNet_InQue_DelChannel},	
	{"ecNet_InQue_GetNumDataDescItems",	(FARPROC*)&ecNet_InQue_GetNumDataDescItems},	
	{"ecNet_InQue_GetDataDesc",	(FARPROC*)&ecNet_InQue_GetDataDesc},	
	{"ecNet_InQue_GetQueSizeInfo",	(FARPROC*)&ecNet_InQue_GetQueSizeInfo},
	{"ecNet_InQue_SetStaTrgEnv",	(FARPROC*)&ecNet_InQue_SetStaTrgEnv},
	{"ecNet_InQue_GetStaTrgEnv",	(FARPROC*)&ecNet_InQue_GetStaTrgEnv},
	{"ecNet_InQue_SetStopTrgEnv",	(FARPROC*)&ecNet_InQue_SetStopTrgEnv},
	{"ecNet_InQue_GetStopTrgEnv",	(FARPROC*)&ecNet_InQue_GetStopTrgEnv},
	{"ecNet_InQue_StartChannel",	(FARPROC*)&ecNet_InQue_StartChannel},
	{"ecNet_InQue_StopChannel",		(FARPROC*)&ecNet_InQue_StopChannel},
	{"ecNet_InQue_GetQueuedCount",	(FARPROC*)&ecNet_InQue_GetQueuedCount},
	{"ecNet_InQue_Deque",		(FARPROC*)&ecNet_InQue_Deque},
	{"ecNet_InQue_PeekData",		(FARPROC*)&ecNet_InQue_PeekData},
	{"ecNet_InQue_AddCommonTrg",	(FARPROC*)&ecNet_InQue_AddCommonTrg},
	{"ecNet_InQue_DelCommonTrg",	(FARPROC*)&ecNet_InQue_DelCommonTrg},
	{"ecNet_InQue_EnableCommonTrg",	(FARPROC*)&ecNet_InQue_EnableCommonTrg},
	{"ecNet_InQue_SetCommonTrgState",	(FARPROC*)&ecNet_InQue_SetCommonTrgState},
	{"ecNet_OutPDO_GetBufPtr",	(FARPROC*)&ecNet_OutPDO_GetBufPtr},
	{"ecNet_OutPDO_GetData",	(FARPROC*)&ecNet_OutPDO_GetData},
	{"ecNet_OutPDO_GetData_I8",	(FARPROC*)&ecNet_OutPDO_GetData_I8},
	{"ecNet_OutPDO_GetData_I16",	(FARPROC*)&ecNet_OutPDO_GetData_I16},
	{"ecNet_OutPDO_GetData_I32",	(FARPROC*)&ecNet_OutPDO_GetData_I32},
	{"ecNet_OutPDO_GetData_U8",	(FARPROC*)&ecNet_OutPDO_GetData_U8},
	{"ecNet_OutPDO_GetData_U16",	(FARPROC*)&ecNet_OutPDO_GetData_U16},
	{"ecNet_OutPDO_GetData_U32",	(FARPROC*)&ecNet_OutPDO_GetData_U32},
	{"ecNet_OutPDO_GetData_R32",	(FARPROC*)&ecNet_OutPDO_GetData_R32},
	{"ecNet_OutPDO_SetData",	(FARPROC*)&ecNet_OutPDO_SetData},
	{"ecNet_OutPDO_SetData_I8",	(FARPROC*)&ecNet_OutPDO_SetData_I8},
	{"ecNet_OutPDO_SetData_I16",	(FARPROC*)&ecNet_OutPDO_SetData_I16},
	{"ecNet_OutPDO_SetData_I32",	(FARPROC*)&ecNet_OutPDO_SetData_I32},
	{"ecNet_OutPDO_SetData_U8",	(FARPROC*)&ecNet_OutPDO_SetData_U8},
	{"ecNet_OutPDO_SetData_U16",	(FARPROC*)&ecNet_OutPDO_SetData_U16},
	{"ecNet_OutPDO_SetData_U32",	(FARPROC*)&ecNet_OutPDO_SetData_U32},
	{"ecNet_OutPDO_SetData_R32",	(FARPROC*)&ecNet_OutPDO_SetData_R32},
	{"ecNet_OutPDO_GetSectPos",	(FARPROC*)&ecNet_OutPDO_GetSectPos},
	{"ecNet_DCMeas_Start",	(FARPROC*)&ecNet_DCMeas_Start},
	{"ecNet_DCMeas_Abort",	(FARPROC*)&ecNet_DCMeas_Abort},
	{"ecNet_DCMeas_GetProgress",	(FARPROC*)&ecNet_DCMeas_GetProgress},
	{"ecNet_DCMeas_IsBusy",	(FARPROC*)&ecNet_DCMeas_IsBusy},
	{"ecNet_DCMeas_GetStatus",	(FARPROC*)&ecNet_DCMeas_GetStatus},
	{"ecNet_DCMeas_GetSlaveInfo_A",	(FARPROC*)&ecNet_DCMeas_GetSlaveInfo_A},
	{"ecNet_DCMeas_GetSlaveInfo",	(FARPROC*)&ecNet_DCMeas_GetSlaveInfo},
	{"ecCfg_Start",				(FARPROC*)&ecCfg_Start},
	{"ecCfg_End",				(FARPROC*)&ecCfg_End},
	{"ecCfg_SetNetConfig",		(FARPROC*)&ecCfg_SetNetConfig},
	{"ecCfg_GetNetConfig",		(FARPROC*)&ecCfg_GetNetConfig},
	{"ecCfg_SetOutPDOLogicSect",(FARPROC*)&ecCfg_SetOutPDOLogicSect},
	{"ecCfg_GetOutPDOLogicSect",(FARPROC*)&ecCfg_GetOutPDOLogicSect},
	{"ecCfg_SetInPDOLogicSect",	(FARPROC*)&ecCfg_SetInPDOLogicSect},
	{"ecCfg_GetInPDOLogicSect",	(FARPROC*)&ecCfg_GetInPDOLogicSect},
	{"ecCfg_SetSlaveConfig",	(FARPROC*)&ecCfg_SetSlaveConfig},
	{"ecCfg_GetSlaveConfig",	(FARPROC*)&ecCfg_GetSlaveConfig},
	{"ecCfg_SetChanMap",		(FARPROC*)&ecCfg_SetChanMap},
	{"ecCfg_GetChanMap",		(FARPROC*)&ecCfg_GetChanMap},
	{"ecCfgFile_Download",		(FARPROC*)&ecCfgFile_Download},
	{"ecCfgFile_Verify",		(FARPROC*)&ecCfgFile_Verify},
	{"ecXml_FindDeviceByProdInfo",	(FARPROC*)&ecXml_FindDeviceByProdInfo},
	{"ecXml_FindElem",			(FARPROC*)&ecXml_FindElem},
	{"ecXml_FindReadElemAttr",	(FARPROC*)&ecXml_FindReadElemAttr},
	{"ecXml_FindReadElemData",	(FARPROC*)&ecXml_FindReadElemData},
	{"ecXml_GetTagName",		(FARPROC*)&ecXml_GetTagName},
	{"ecXml_GetNumElem",		(FARPROC*)&ecXml_GetNumElem},
	{"ecXml_GetProdDesc",		(FARPROC*)&ecXml_GetProdDesc},
	{"ecXml_IntoElem",			(FARPROC*)&ecXml_IntoElem},
	{"ecXml_LoadByFileName",	(FARPROC*)&ecXml_LoadByFileName},
	{"ecXml_LoadByProdInfo",	(FARPROC*)&ecXml_LoadByProdInfo},
	{"ecXml_OutOfElem",			(FARPROC*)&ecXml_OutOfElem},
	{"ecXml_ReadElemAttr",		(FARPROC*)&ecXml_ReadElemAttr},
	{"ecXml_ReadElemData",		(FARPROC*)&ecXml_ReadElemData},
	{"ecXml_ResetPos",			(FARPROC*)&ecXml_ResetPos},
	{"ecXml_RestorePos",		(FARPROC*)&ecXml_RestorePos},
	{"ecXml_SavePos",			(FARPROC*)&ecXml_SavePos},
	{"ecXml_Str2Bool",			(FARPROC*)&ecXml_Str2Bool},
	{"ecXml_Str2HexDec",		(FARPROC*)&ecXml_Str2HexDec},
	{"ecXml_Unload",			(FARPROC*)&ecXml_Unload},
	{"ecSlv_GetProdInfo_A",		(FARPROC*)&ecSlv_GetProdInfo_A},
	{"ecSlv_GetProdInfo",		(FARPROC*)&ecSlv_GetProdInfo},
	{"ecSlv_GetTypeInfo",		(FARPROC*)&ecSlv_GetTypeInfo},
	{"ecSlv_GetTypeInfo_A",		(FARPROC*)&ecSlv_GetTypeInfo_A},
	{"ecSlv_GetAlState_A",		(FARPROC*)&ecSlv_GetAlState_A},
	{"ecSlv_GetAlState",		(FARPROC*)&ecSlv_GetAlState},
	{"ecSlv_ReadReg",			(FARPROC*)&ecSlv_ReadReg},
	{"ecSlv_ReadReg_A",			(FARPROC*)&ecSlv_ReadReg_A},
	{"ecSlv_WriteReg",			(FARPROC*)&ecSlv_WriteReg},
	{"ecSlv_WriteReg_FF",		(FARPROC*)&ecSlv_WriteReg_FF},
	{"ecSlv_WriteReg_A",		(FARPROC*)&ecSlv_WriteReg_A},
	{"ecSlv_WriteReg_A_FF",		(FARPROC*)&ecSlv_WriteReg_A_FF},
	{"ecSlv_ReadEEPR",			(FARPROC*)&ecSlv_ReadEEPR},
	{"ecSlv_ReadEEPR_A",		(FARPROC*)&ecSlv_ReadEEPR_A},
	{"ecSlv_WriteEEPR",			(FARPROC*)&ecSlv_WriteEEPR},
	{"ecSlv_WriteEEPR_FF",		(FARPROC*)&ecSlv_WriteEEPR_FF},
	{"ecSlv_WriteEEPR_A",		(FARPROC*)&ecSlv_WriteEEPR_A},
	{"ecSlv_WriteEEPR_A_FF",	(FARPROC*)&ecSlv_WriteEEPR_A_FF},
	{"ecSlv_RenewCrcOfEEPR_A",	(FARPROC*)&ecSlv_RenewCrcOfEEPR_A},
	{"ecSlv_RenewCrcOfEEPR",	(FARPROC*)&ecSlv_RenewCrcOfEEPR},
	{"ecSlv_ReadCoeSdo",		(FARPROC*)&ecSlv_ReadCoeSdo},
	{"ecSlv_ReadCoeSdo_A",		(FARPROC*)&ecSlv_ReadCoeSdo_A},
	{"ecSlv_WriteCoeSdo",		(FARPROC*)&ecSlv_WriteCoeSdo},
	{"ecSlv_WriteCoeSdo_FF",	(FARPROC*)&ecSlv_WriteCoeSdo_FF},
	{"ecSlv_WriteCoeSdo_A",		(FARPROC*)&ecSlv_WriteCoeSdo_A},
	{"ecSlv_WriteCoeSdo_A_FF",	(FARPROC*)&ecSlv_WriteCoeSdo_A_FF},	
	{"ecSlv_ReadReg134ID",		(FARPROC*)&ecSlv_ReadReg134ID},
	{"ecSlv_ReadReg134ID_A",	(FARPROC*)&ecSlv_ReadReg134ID_A},	
	{"ecSlv_SdoInfo_GetODList",		(FARPROC*)&ecSlv_SdoInfo_GetODList},
	{"ecSlv_SdoInfo_GetODList_A",	(FARPROC*)&ecSlv_SdoInfo_GetODList_A},
	{"ecSlv_SdoInfo_GetObjDesc",	(FARPROC*)&ecSlv_SdoInfo_GetObjDesc},
	{"ecSlv_SdoInfo_GetObjDesc_A",	(FARPROC*)&ecSlv_SdoInfo_GetObjDesc_A},
	{"ecSlv_SdoInfo_GetEntryDesc",	(FARPROC*)&ecSlv_SdoInfo_GetEntryDesc},
	{"ecSlv_SdoInfo_GetEntryDesc_A", (FARPROC*)&ecSlv_SdoInfo_GetEntryDesc_A},
	{"ecSlv_SdoInfo_ReleaseData", (FARPROC*)&ecSlv_SdoInfo_ReleaseData},
	{"ecSlv_SlvIdx2PhysAddr",	(FARPROC*)&ecSlv_SlvIdx2PhysAddr},
	{"ecSlv_PhysAddr2SlvIdx",	(FARPROC*)&ecSlv_PhysAddr2SlvIdx},
	{"ecSlv_InPDO_GetBufPtr",	(FARPROC*)&ecSlv_InPDO_GetBufPtr},
	{"ecSlv_InPDO_GetOffset",	(FARPROC*)&ecSlv_InPDO_GetOffset},
	{"ecSlv_InPDO_GetBufLen",	(FARPROC*)&ecSlv_InPDO_GetBufLen},
	{"ecSlv_OutPDO_GetBufPtr",	(FARPROC*)&ecSlv_OutPDO_GetBufPtr},
	{"ecSlv_OutPDO_GetOffset",	(FARPROC*)&ecSlv_OutPDO_GetOffset},
	{"ecSlv_OutPDO_GetBufLen",	(FARPROC*)&ecSlv_OutPDO_GetBufLen},
	{"ecSlv_OutPDO_SetInitValMode",	(FARPROC*)&ecSlv_OutPDO_SetInitValMode},
	{"ecSlv_OutPDO_GetInitValMode",	(FARPROC*)&ecSlv_OutPDO_GetInitValMode},
	{"ecSlv_OutPDO_SetInitVal",	(FARPROC*)&ecSlv_OutPDO_SetInitVal},
	{"ecSlv_OutPDO_GetInitVal",	(FARPROC*)&ecSlv_OutPDO_GetInitVal},
	{"ecSlv_GetComErrSum_A",	(FARPROC*)&ecSlv_GetComErrSum_A},
	{"ecSlv_GetComErrSum",		(FARPROC*)&ecSlv_GetComErrSum},
	{"ecSlv_ClearComErrSum_A",	(FARPROC*)&ecSlv_ClearComErrSum_A},
	{"ecSlv_ClearComErrSum",	(FARPROC*)&ecSlv_ClearComErrSum},
	{"ecSlv_SetEscWDT_A",	(FARPROC*)&ecSlv_SetEscWDT_A},
	{"ecSlv_GetEscWDT_A",	(FARPROC*)&ecSlv_GetEscWDT_A},
	{"ecSlv_SetEscWDT",		(FARPROC*)&ecSlv_SetEscWDT},
	{"ecSlv_GetEscWDT",		(FARPROC*)&ecSlv_GetEscWDT},
	{"ecdiGetSlaveIndex",		(FARPROC*)&ecdiGetSlaveIndex},
	{"ecdiGetSlaveID",			(FARPROC*)&ecdiGetSlaveID},
	{"ecdiGetNumChannels",		(FARPROC*)&ecdiGetNumChannels},
	{"ecdiGetOne",				(FARPROC*)&ecdiGetOne},
	{"ecdiGetMulti",			(FARPROC*)&ecdiGetMulti},
	{"ecdiGetLogicAddr",		(FARPROC*)&ecdiGetLogicAddr},
	{"ecdiLtc_AddChannel",		(FARPROC*)&ecdiLtc_AddChannel},
	{"ecdiLtc_DelChannel",		(FARPROC*)&ecdiLtc_DelChannel},
	{"ecdiLtc_SetFilter",		(FARPROC*)&ecdiLtc_SetFilter},
	{"ecdiLtc_GetFilter",		(FARPROC*)&ecdiLtc_GetFilter},
	{"ecdiLtc_SetLogicInvert",		(FARPROC*)&ecdiLtc_SetLogicInvert},
	{"ecdiLtc_GetLogicInvert",		(FARPROC*)&ecdiLtc_GetLogicInvert},
	{"ecdiLtc_GetOnCount",		(FARPROC*)&ecdiLtc_GetOnCount},
	{"ecdiLtc_ResetOnCount",		(FARPROC*)&ecdiLtc_ResetOnCount},
	{"ecdiGetOne_L",			(FARPROC*)&ecdiGetOne_L},
	{"ecdiGetMulti_L",			(FARPROC*)&ecdiGetMulti_L},
	{"ecdiLtc_AddChannel_L",		(FARPROC*)&ecdiLtc_AddChannel_L},
	{"ecdiLtc_DelChannel_L",		(FARPROC*)&ecdiLtc_DelChannel_L},
	{"ecdiLtc_SetFilter_L",		(FARPROC*)&ecdiLtc_SetFilter_L},
	{"ecdiLtc_GetFilter_L",		(FARPROC*)&ecdiLtc_GetFilter_L},
	{"ecdiLtc_SetLogicInvert_L",		(FARPROC*)&ecdiLtc_SetLogicInvert_L},
	{"ecdiLtc_GetLogicInvert_L",		(FARPROC*)&ecdiLtc_GetLogicInvert_L},
	{"ecdiLtc_GetOnCount_L",		(FARPROC*)&ecdiLtc_GetOnCount_L},
	{"ecdiLtc_ResetOnCount_L",		(FARPROC*)&ecdiLtc_ResetOnCount_L},
	{"ecdiLogBitAddr_FromGlobalChannel",		(FARPROC*)&ecdiLogBitAddr_FromGlobalChannel},
	{"ecdiLogBitAddr_FromLocalChannel",		(FARPROC*)&ecdiLogBitAddr_FromLocalChannel},
	{"ecdiLogBitAddr_FromOnboardChannel",		(FARPROC*)&ecdiLogBitAddr_FromOnboardChannel},
	{"ecdiLogBitAddr_ToGlobalChannel",		(FARPROC*)&ecdiLogBitAddr_ToGlobalChannel},
	{"ecdiLogBitAddr_ToLocalChannel",		(FARPROC*)&ecdiLogBitAddr_ToLocalChannel},
	{"ecdiLogBitAddr_ToOnboardChannel",		(FARPROC*)&ecdiLogBitAddr_ToOnboardChannel},
	{"ecdiLogBitAddr_GetChanType",		(FARPROC*)&ecdiLogBitAddr_GetChanType},
	{"ecdoGetSlaveIndex",		(FARPROC*)&ecdoGetSlaveIndex},
	{"ecdoGetSlaveID",			(FARPROC*)&ecdoGetSlaveID},
	{"ecdoGetNumChannels",		(FARPROC*)&ecdoGetNumChannels},
	{"ecdoPutOne",				(FARPROC*)&ecdoPutOne},
	{"ecdoLmPutOne",			(FARPROC*)&ecdoLmPutOne},
	{"ecdoPutMulti",			(FARPROC*)&ecdoPutMulti},
	{"ecdoGetOne",				(FARPROC*)&ecdoGetOne},
	{"ecdoGetMulti",			(FARPROC*)&ecdoGetMulti},
	{"ecdoPutOne_L",			(FARPROC*)&ecdoPutOne_L},
	{"ecdoLmPutOne_L",			(FARPROC*)&ecdoLmPutOne_L},
	{"ecdoPutMulti_L",			(FARPROC*)&ecdoPutMulti_L},
	{"ecdoGetOne_L",			(FARPROC*)&ecdoGetOne_L},
	{"ecdoGetMulti_L",			(FARPROC*)&ecdoGetMulti_L},
	{"ecdoLogBitAddr_FromGlobalChannel",		(FARPROC*)&ecdoLogBitAddr_FromGlobalChannel},
	{"ecdoLogBitAddr_FromLocalChannel",		(FARPROC*)&ecdoLogBitAddr_FromLocalChannel},
	{"ecdoLogBitAddr_FromOnboardChannel",		(FARPROC*)&ecdoLogBitAddr_FromOnboardChannel},
	{"ecdoLogBitAddr_ToGlobalChannel",		(FARPROC*)&ecdoLogBitAddr_ToGlobalChannel},
	{"ecdoLogBitAddr_ToLocalChannel",		(FARPROC*)&ecdoLogBitAddr_ToLocalChannel},
	{"ecdoLogBitAddr_ToOnboardChannel",		(FARPROC*)&ecdoLogBitAddr_ToOnboardChannel},
	{"ecdoLogBitAddr_GetChanType",		(FARPROC*)&ecdoLogBitAddr_GetChanType},
	{"ecaiGetSlaveIndex",		(FARPROC*)&ecaiGetSlaveIndex},
	{"ecaiGetSlaveID",			(FARPROC*)&ecaiGetSlaveID},
	{"ecaiGetNumChannels",		(FARPROC*)&ecaiGetNumChannels},
	{"ecaiGetChanVal_I",		(FARPROC*)&ecaiGetChanVal_I},
	{"ecaiGetChanVal_I_L",		(FARPROC*)&ecaiGetChanVal_I_L},
	{"ecaiGetChanVal_F",		(FARPROC*)&ecaiGetChanVal_F},
	{"ecaiGetChanVal_FS",		(FARPROC*)&ecaiGetChanVal_FS},
	{"ecaoGetSlaveIndex",		(FARPROC*)&ecaoGetSlaveIndex},
	{"ecaoGetSlaveID",			(FARPROC*)&ecaoGetSlaveID},
	{"ecaoGetNumChannels",		(FARPROC*)&ecaoGetNumChannels},
	{"ecaoSetChanVal_I",		(FARPROC*)&ecaoSetChanVal_I},
	{"ecaoSetChanVal_F",		(FARPROC*)&ecaoSetChanVal_F},
	{"ecaoSetChanVal_FS",		(FARPROC*)&ecaoSetChanVal_FS},
	{"ecaoGetOutValue_I",		(FARPROC*)&ecaoGetOutValue_I},
	{"ecaoGetOutValue_F",		(FARPROC*)&ecaoGetOutValue_F},
	{"ecaoGetOutValue_FS",		(FARPROC*)&ecaoGetOutValue_FS},
	{"ecmGn_GetAxisList",		(FARPROC*)&ecmGn_GetAxisList},
	{"ecmGn_GetInPDOHeader",	(FARPROC*)&ecmGn_GetInPDOHeader},
	{"ecmGn_AxisToSlaveIndex",	(FARPROC*)&ecmGn_AxisToSlaveIndex},
	{"ecmGn_AxisToSlaveID",		(FARPROC*)&ecmGn_AxisToSlaveID},
	{"ecmGn_SlaveIndexToAxis",	(FARPROC*)&ecmGn_SlaveIndexToAxis},
	{"ecmGn_SlaveIDToAxis",		(FARPROC*)&ecmGn_SlaveIDToAxis},
	{"ecmGn_InitFromFile",		(FARPROC*)&ecmGn_InitFromFile},
	{"ecmHEMG_SetInputEnv",	(FARPROC*)&ecmHEMG_SetInputEnv},
	{"ecmHEMG_GetInputEnv",	(FARPROC*)&ecmHEMG_GetInputEnv},
	{"ecmHEMG_SetInputEnv_Multi",	(FARPROC*)&ecmHEMG_SetInputEnv_Multi},
	{"ecmHEMG_GetInputEnv_Multi",	(FARPROC*)&ecmHEMG_GetInputEnv_Multi},
	{"ecmHEMG_GetNumInputs",	(FARPROC*)&ecmHEMG_GetNumInputs},
	{"ecmHEMG_SetStopMode",	(FARPROC*)&ecmHEMG_SetStopMode},
	{"ecmHEMG_GetStopMode",	(FARPROC*)&ecmHEMG_GetStopMode},
	{"ecmHEMG_SetEnable",	(FARPROC*)&ecmHEMG_SetEnable},
	{"ecmHEMG_GetEnable",	(FARPROC*)&ecmHEMG_GetEnable},
	{"ecmHEMG_GetState",		(FARPROC*)&ecmHEMG_GetState},
	{"ecmSEMG_SetStopMode",	(FARPROC*)&ecmSEMG_SetStopMode},
	{"ecmSEMG_GetStopMode",	(FARPROC*)&ecmSEMG_GetStopMode},
	{"ecmSEMG_SetState",		(FARPROC*)&ecmSEMG_SetState},
	{"ecmSEMG_GetState",		(FARPROC*)&ecmSEMG_GetState},
	{"ecmCollA_SetEnv",		(FARPROC*)&ecmCollA_SetEnv},
	{"ecmCollA_GetEnv",		(FARPROC*)&ecmCollA_GetEnv},
	{"ecmCollA_SetStopMode",		(FARPROC*)&ecmCollA_SetStopMode},
	{"ecmCollA_GetStopMode",		(FARPROC*)&ecmCollA_GetStopMode},
	{"ecmCollA_SetEnable",		(FARPROC*)&ecmCollA_SetEnable},
	{"ecmCollA_GetEnable",		(FARPROC*)&ecmCollA_GetEnable},
	{"ecmSxCfg_SetUnitDist",	(FARPROC*)&ecmSxCfg_SetUnitDist},
	{"ecmSxCfg_GetUnitDist",	(FARPROC*)&ecmSxCfg_GetUnitDist},
	{"ecmSxCfg_GetSoftLimit",	(FARPROC*)&ecmSxCfg_GetSoftLimit},
	{"ecmSxCfg_SetSoftLimit",	(FARPROC*)&ecmSxCfg_SetSoftLimit},
	{"ecmSxCfg_SetOperMode",	(FARPROC*)&ecmSxCfg_SetOperMode},
	{"ecmSxCfg_GetOperMode",	(FARPROC*)&ecmSxCfg_GetOperMode},
	{"ecmSxCfg_SetUnitSpeed",	(FARPROC*)&ecmSxCfg_SetUnitSpeed},
	{"ecmSxCfg_GetUnitSpeed",	(FARPROC*)&ecmSxCfg_GetUnitSpeed},
	{"ecmSxCfg_SetMioProp",		(FARPROC*)&ecmSxCfg_SetMioProp},
	{"ecmSxCfg_GetMioProp",		(FARPROC*)&ecmSxCfg_GetMioProp},
	{"ecmSxCfg_SetMastInp",		(FARPROC*)&ecmSxCfg_SetMastInp},
	{"ecmSxCfg_GetMastInp",		(FARPROC*)&ecmSxCfg_GetMastInp},
	{"ecmSxCfg_SetMastInp_Cnt",		(FARPROC*)&ecmSxCfg_SetMastInp_Cnt},
	{"ecmSxCfg_GetMastInp_Cnt",		(FARPROC*)&ecmSxCfg_GetMastInp_Cnt},
	{"ecmSxCfg_SetSpeedPatt",	(FARPROC*)&ecmSxCfg_SetSpeedPatt},
	{"ecmSxCfg_SetSpeedPatt_FF",(FARPROC*)&ecmSxCfg_SetSpeedPatt_FF},
	{"ecmSxCfg_GetSpeedPatt",	(FARPROC*)&ecmSxCfg_GetSpeedPatt},
	{"ecmSxCfg_SetSpeedPatt_Time",		(FARPROC*)&ecmSxCfg_SetSpeedPatt_Time},
	{"ecmSxCfg_SetSpeedPatt_Time_FF",	(FARPROC*)&ecmSxCfg_SetSpeedPatt_Time_FF},
	{"ecmSxCfg_GetSpeedPatt_Time",		(FARPROC*)&ecmSxCfg_GetSpeedPatt_Time},
	{"ecmSxCfg_SetSpeedRatio",			(FARPROC*)&ecmSxCfg_SetSpeedRatio},
	{"ecmSxCfg_SetSpeedRatio_FF",		(FARPROC*)&ecmSxCfg_SetSpeedRatio_FF},
	{"ecmSxCfg_GetSpeedRatio",			(FARPROC*)&ecmSxCfg_GetSpeedRatio},
	{"ecmSxCfg_SetVelCorrRatio",		(FARPROC*)&ecmSxCfg_SetVelCorrRatio},
	{"ecmSxCfg_GetVelCorrRatio",		(FARPROC*)&ecmSxCfg_GetVelCorrRatio},
	{"ecmSxCfg_SetRdpOffset",			(FARPROC*)&ecmSxCfg_SetRdpOffset},
	{"ecmSxCfg_GetRdpOffset",			(FARPROC*)&ecmSxCfg_GetRdpOffset},
	{"ecmSxCfg_SetJerkRatio",			(FARPROC*)&ecmSxCfg_SetJerkRatio},
	{"ecmSxCfg_SetJerkRatio_FF",		(FARPROC*)&ecmSxCfg_SetJerkRatio_FF},
	{"ecmSxCfg_GetJerkRatio",			(FARPROC*)&ecmSxCfg_GetJerkRatio},
	{"ecmSxCfg_SetJerkMode",			(FARPROC*)&ecmSxCfg_SetJerkMode},
	{"ecmSxCfg_GetJerkMode",			(FARPROC*)&ecmSxCfg_GetJerkMode},
	{"ecmSxCfg_SetJerk",				(FARPROC*)&ecmSxCfg_SetJerk},
	{"ecmSxCfg_GetJerk",				(FARPROC*)&ecmSxCfg_GetJerk},
	{"ecmSxCfg_SetSecondaryAcc",		(FARPROC*)&ecmSxCfg_SetSecondaryAcc},
	{"ecmSxCfg_GetSecondaryAcc",		(FARPROC*)&ecmSxCfg_GetSecondaryAcc},
	{"ecmSxCfg_SetSecondaryDec",		(FARPROC*)&ecmSxCfg_SetSecondaryDec},
	{"ecmSxCfg_GetSecondaryDec",		(FARPROC*)&ecmSxCfg_GetSecondaryDec},
	{"ecmSxCfg_SetMinAccDecTime",		(FARPROC*)&ecmSxCfg_SetMinAccDecTime},
	{"ecmSxCfg_GetMinAccDecTime",		(FARPROC*)&ecmSxCfg_GetMinAccDecTime},
	{"ecmSxCfg_SetTouchProbeFunc",		(FARPROC*)&ecmSxCfg_SetTouchProbeFunc},
	{"ecmSxCfg_GetTouchProbeFunc",		(FARPROC*)&ecmSxCfg_GetTouchProbeFunc},
	{"ecmSxCfg_SetSyncOtherEnv",		(FARPROC*)&ecmSxCfg_SetSyncOtherEnv},
	{"ecmSxCfg_GetSyncOtherEnv",		(FARPROC*)&ecmSxCfg_GetSyncOtherEnv},
	{"ecmSxCfg_SetSyncOtherEnable",		(FARPROC*)&ecmSxCfg_SetSyncOtherEnable},
	{"ecmSxCfg_GetSyncOtherEnable",		(FARPROC*)&ecmSxCfg_GetSyncOtherEnable},
	{"ecmSxCfg_PosCorr_SetTableSize",	(FARPROC*)&ecmSxCfg_PosCorr_SetTableSize},
	{"ecmSxCfg_PosCorr_GetTableSize",	(FARPROC*)&ecmSxCfg_PosCorr_GetTableSize},
	{"ecmSxCfg_PosCorr_SetTableData",	(FARPROC*)&ecmSxCfg_PosCorr_SetTableData},
	{"ecmSxCfg_PosCorr_GetTableData",	(FARPROC*)&ecmSxCfg_PosCorr_GetTableData},
	{"ecmSxCfg_PosCorr_SetTableFromFile",(FARPROC*)&ecmSxCfg_PosCorr_SetTableFromFile},	
	{"ecmSxCfg_PosCorr_SetEnable",		(FARPROC*)&ecmSxCfg_PosCorr_SetEnable},
	{"ecmSxCfg_PosCorr_GetEnable",		(FARPROC*)&ecmSxCfg_PosCorr_GetEnable},
	{"ecmSxCfg_PosCorr_ClearTable",		(FARPROC*)&ecmSxCfg_PosCorr_ClearTable},
	{"ecmSxCfg_PosCorr2D_Reset",		(FARPROC*)&ecmSxCfg_PosCorr2D_Reset},
	{"ecmSxCfg_PosCorr2D_SetTableHeader",		(FARPROC*)&ecmSxCfg_PosCorr2D_SetTableHeader},
	{"ecmSxCfg_PosCorr2D_GetTableHeader",		(FARPROC*)&ecmSxCfg_PosCorr2D_GetTableHeader},
	{"ecmSxCfg_PosCorr2D_SetTableData",		(FARPROC*)&ecmSxCfg_PosCorr2D_SetTableData},
	{"ecmSxCfg_PosCorr2D_GetTableData",		(FARPROC*)&ecmSxCfg_PosCorr2D_GetTableData},
	{"ecmSxCfg_PosCorr2D_SetTableFromFile",		(FARPROC*)&ecmSxCfg_PosCorr2D_SetTableFromFile},
	{"ecmSxCfg_PosCorr2D_SetEnable",		(FARPROC*)&ecmSxCfg_PosCorr2D_SetEnable},
	{"ecmSxCfg_PosCorr2D_GetEnable",		(FARPROC*)&ecmSxCfg_PosCorr2D_GetEnable},
	{"ecmSxCfg_AutoTorq_SetValMode",	(FARPROC*)&ecmSxCfg_AutoTorq_SetValMode},
	{"ecmSxCfg_AutoTorq_GetValMode",	(FARPROC*)&ecmSxCfg_AutoTorq_GetValMode},
	{"ecmSxCfg_AutoTorq_SetMultiVal",	(FARPROC*)&ecmSxCfg_AutoTorq_SetMultiVal},
	{"ecmSxCfg_AutoTorq_GetMultiVal",	(FARPROC*)&ecmSxCfg_AutoTorq_GetMultiVal},
	{"ecmSxCfg_AutoTorq_SetValue",	(FARPROC*)&ecmSxCfg_AutoTorq_SetValue},
	{"ecmSxCfg_AutoTorq_GetValue",	(FARPROC*)&ecmSxCfg_AutoTorq_GetValue},
	{"ecmSxCfg_AutoTorq_SetLimit",	(FARPROC*)&ecmSxCfg_AutoTorq_SetLimit},
	{"ecmSxCfg_AutoTorq_GetLimit",	(FARPROC*)&ecmSxCfg_AutoTorq_GetLimit},
	{"ecmSxCfg_AutoTorq_SetEnable",	(FARPROC*)&ecmSxCfg_AutoTorq_SetEnable},
	{"ecmSxCfg_AutoTorq_GetEnable",	(FARPROC*)&ecmSxCfg_AutoTorq_GetEnable},
	{"ecmSxCfg_Ring_GetEnable",		(FARPROC*)&ecmSxCfg_Ring_GetEnable},
	{"ecmSxCfg_Ring_SetEnable",		(FARPROC*)&ecmSxCfg_Ring_SetEnable},
	{"ecmSxCfg_Ring_GetPosRange",	(FARPROC*)&ecmSxCfg_Ring_GetPosRange},
	{"ecmSxCfg_Ring_SetPosRange",	(FARPROC*)&ecmSxCfg_Ring_SetPosRange},
	{"ecmSxCfg_Ring_GetPosRangeEx",	(FARPROC*)&ecmSxCfg_Ring_GetPosRangeEx},
	{"ecmSxCfg_Ring_SetPosRangeEx",	(FARPROC*)&ecmSxCfg_Ring_SetPosRangeEx},
	{"ecmSxCfg_Ring_GetDirMode",	(FARPROC*)&ecmSxCfg_Ring_GetDirMode},
	{"ecmSxCfg_Ring_SetDirMode",	(FARPROC*)&ecmSxCfg_Ring_SetDirMode},
	{"ecmSxCfg_ExtStop_SetEnable",	(FARPROC*)&ecmSxCfg_ExtStop_SetEnable},
	{"ecmSxCfg_ExtStop_GetEnable",	(FARPROC*)&ecmSxCfg_ExtStop_GetEnable},
	{"ecmSxCfg_ExtStop_SetEnv",		(FARPROC*)&ecmSxCfg_ExtStop_SetEnv},
	{"ecmSxCfg_ExtStop_SetEnv2",	(FARPROC*)&ecmSxCfg_ExtStop_SetEnv2},
	{"ecmSxCfg_ExtStop_SetEnv3",	(FARPROC*)&ecmSxCfg_ExtStop_SetEnv3},
	{"ecmSxCfg_ExtStop_GetEnv",		(FARPROC*)&ecmSxCfg_ExtStop_GetEnv},
	{"ecmSxCfg_ExtStop_GetEnv2",	(FARPROC*)&ecmSxCfg_ExtStop_GetEnv2},
	{"ecmSxCfg_ExtStop_GetEnv3",	(FARPROC*)&ecmSxCfg_ExtStop_GetEnv3},
	{"ecmSxCfg_ExtStop_SetOfsDistMode",	(FARPROC*)&ecmSxCfg_ExtStop_SetOfsDistMode},
	{"ecmSxCfg_ExtStop_GetOfsDistMode",	(FARPROC*)&ecmSxCfg_ExtStop_GetOfsDistMode},
	{"ecmSxCfg_SetMaxTorqOfCV",		(FARPROC*)&ecmSxCfg_SetMaxTorqOfCV},
	{"ecmSxCfg_GetMaxTorqOfCV",		(FARPROC*)&ecmSxCfg_GetMaxTorqOfCV},
	{"ecmSxCfg_SetMaxSpdOfCT",		(FARPROC*)&ecmSxCfg_SetMaxSpdOfCT},
	{"ecmSxCfg_GetMaxSpdOfCT",		(FARPROC*)&ecmSxCfg_GetMaxSpdOfCT},
	{"ecmSxCfg_SetMaxProfSpdOfCT",	(FARPROC*)&ecmSxCfg_SetMaxProfSpdOfCT},
	{"ecmSxCfg_GetMaxProfSpdOfCT",	(FARPROC*)&ecmSxCfg_GetMaxProfSpdOfCT},
	{"ecmSxCfg_SetZVISEnable",	(FARPROC*)&ecmSxCfg_SetZVISEnable},
	{"ecmSxCfg_GetZVISEnable",	(FARPROC*)&ecmSxCfg_GetZVISEnable},
	{"ecmSxCfg_SetZVISParam",	(FARPROC*)&ecmSxCfg_SetZVISParam},
	{"ecmSxCfg_GetZVISParam",	(FARPROC*)&ecmSxCfg_GetZVISParam},
	{"ecmSxCtl_SetSvon",		(FARPROC*)&ecmSxCtl_SetSvon},
	{"ecmSxCtl_GetSvon",		(FARPROC*)&ecmSxCtl_GetSvon},
	{"ecmSxCtl_SetSvon_FF",		(FARPROC*)&ecmSxCtl_SetSvon_FF},
	{"ecmSxCtl_SetAlmRst",		(FARPROC*)&ecmSxCtl_SetAlmRst},
	{"ecmSxCtl_SetAlmRst_FF",	(FARPROC*)&ecmSxCtl_SetAlmRst_FF},
	{"ecmSxCtl_ResetAlm",		(FARPROC*)&ecmSxCtl_ResetAlm},
	{"ecmSxCtl_ResetAlm_FF",	(FARPROC*)&ecmSxCtl_ResetAlm_FF},
	{"ecmSxMot_SetTargTorq",	(FARPROC*)&ecmSxMot_SetTargTorq},
	{"ecmSxMot_GetTargTorq",	(FARPROC*)&ecmSxMot_GetTargTorq},
	{"ecmSxMot_SetTargVel",		(FARPROC*)&ecmSxMot_SetTargVel},
	{"ecmSxMot_GetTargVel",		(FARPROC*)&ecmSxMot_GetTargVel},
	{"ecmSxMot_VMoveStart",		(FARPROC*)&ecmSxMot_VMoveStart},
	{"ecmSxMot_VMoveStart_FF",	(FARPROC*)&ecmSxMot_VMoveStart_FF},
	{"ecmSxMot_MoveStart",		(FARPROC*)&ecmSxMot_MoveStart},
	{"ecmSxMot_MoveStart_FF",	(FARPROC*)&ecmSxMot_MoveStart_FF},
	{"ecmSxMot_Move",			(FARPROC*)&ecmSxMot_Move},
	{"ecmSxMot_Move_NB",		(FARPROC*)&ecmSxMot_Move_NB},
	{"ecmSxMot_MoveToStart",	(FARPROC*)&ecmSxMot_MoveToStart},
	{"ecmSxMot_MoveToStart_FF",	(FARPROC*)&ecmSxMot_MoveToStart_FF},
	{"ecmSxMot_MoveTo",			(FARPROC*)&ecmSxMot_MoveTo},
	{"ecmSxMot_MoveTo_NB",		(FARPROC*)&ecmSxMot_MoveTo_NB},
	{"ecmSxMot_OverrideSpeed",	(FARPROC*)&ecmSxMot_OverrideSpeed},
	{"ecmSxMot_OverrideMove",	(FARPROC*)&ecmSxMot_OverrideMove},
	{"ecmSxMot_OverrideMoveTo",	(FARPROC*)&ecmSxMot_OverrideMoveTo},
	{"ecmSxMot_Stop",			(FARPROC*)&ecmSxMot_Stop},
	{"ecmSxMot_Stop_FF",		(FARPROC*)&ecmSxMot_Stop_FF},
	{"ecmMxMot_VMoveStart",		(FARPROC*)&ecmMxMot_VMoveStart},
	{"ecmMxMot_VMoveStart_FF",	(FARPROC*)&ecmMxMot_VMoveStart_FF},
	{"ecmMxMot_MoveStart",		(FARPROC*)&ecmMxMot_MoveStart},
	{"ecmMxMot_MoveStart_FF",	(FARPROC*)&ecmMxMot_MoveStart_FF},
	{"ecmMxMot_MoveToStart",	(FARPROC*)&ecmMxMot_MoveToStart},
	{"ecmMxMot_MoveToStart_FF",	(FARPROC*)&ecmMxMot_MoveToStart_FF},
	{"ecmMxMot_Stop",			(FARPROC*)&ecmMxMot_Stop},	
	{"ecmMxMot_Stop_FF",		(FARPROC*)&ecmMxMot_Stop_FF},
	{"ecmMxSt_IsBusy",			(FARPROC*)&ecmMxSt_IsBusy},
	{"ecmMxSt_WaitCompt",		(FARPROC*)&ecmMxSt_WaitCompt},
	{"ecmMxSt_WaitCompt_NB",	(FARPROC*)&ecmMxSt_WaitCompt_NB},
	{"ecmSxSt_IsConnected",		(FARPROC*)&ecmSxSt_IsConnected},
	{"ecmSxSt_GetInPDOPtr",		(FARPROC*)&ecmSxSt_GetInPDOPtr},
	{"ecmSxSt_IsBusy",			(FARPROC*)&ecmSxSt_IsBusy},
	{"ecmSxSt_WaitCompt",		(FARPROC*)&ecmSxSt_WaitCompt},
	{"ecmSxSt_WaitCompt_NB",	(FARPROC*)&ecmSxSt_WaitCompt_NB},
	{"ecmSxSt_SetCount",		(FARPROC*)&ecmSxSt_SetCount},
	{"ecmSxSt_GetCount",		(FARPROC*)&ecmSxSt_GetCount},
	{"ecmSxSt_SetPosition",		(FARPROC*)&ecmSxSt_SetPosition},
	{"ecmSxSt_GetPosition",		(FARPROC*)&ecmSxSt_GetPosition},
	{"ecmSxSt_GetCurSpeed",		(FARPROC*)&ecmSxSt_GetCurSpeed},
	{"ecmSxSt_GetCurTorque",	(FARPROC*)&ecmSxSt_GetCurTorque},
	{"ecmSxSt_GetMotState",		(FARPROC*)&ecmSxSt_GetMotState},
	{"ecmSxSt_GetFlags",		(FARPROC*)&ecmSxSt_GetFlags},
	{"ecmSxSt_GetDI",			(FARPROC*)&ecmSxSt_GetDI},
	{"ecmSxSt_GetTouchProbeSts",(FARPROC*)&ecmSxSt_GetTouchProbeSts},
	{"ecmSxSt_GetTouchProbePos",(FARPROC*)&ecmSxSt_GetTouchProbePos},
	{"ecmSxSt_GetTouchProbePosN",(FARPROC*)&ecmSxSt_GetTouchProbePosN},
	{"ecmSxSt_GetOpModeDisp",	(FARPROC*)&ecmSxSt_GetOpModeDisp},
	{"ecmSxSt_GetLmMapIdx",		(FARPROC*)&ecmSxSt_GetLmMapIdx},
	{"ecmSxSt_GetPtmMapIdx",	(FARPROC*)&ecmSxSt_GetPtmMapIdx},
	{"ecmSxCmpOne_SetChannel",	(FARPROC*)&ecmSxCmpOne_SetChannel},
	{"ecmSxCmpOne_GetChannel",	(FARPROC*)&ecmSxCmpOne_GetChannel},
	{"ecmSxCmpOne_SetCondition",	(FARPROC*)&ecmSxCmpOne_SetCondition},
	{"ecmSxCmpOne_GetCondition",	(FARPROC*)&ecmSxCmpOne_GetCondition},	
	{"ecmSxCmpOne_SetEnable",	(FARPROC*)&ecmSxCmpOne_SetEnable},
	{"ecmSxCmpOne_GetEnable",	(FARPROC*)&ecmSxCmpOne_GetEnable},
	{"ecmSxCmpOne_GetOutResult",	(FARPROC*)&ecmSxCmpOne_GetOutResult},
	{"ecmSxCmpOne_ClearOutResult",	(FARPROC*)&ecmSxCmpOne_ClearOutResult},
	{"ecmSxCmpOne_SetOutputState",	(FARPROC*)&ecmSxCmpOne_SetOutputState},
	{"ecmSxCmpOne_GetOutputState",	(FARPROC*)&ecmSxCmpOne_GetOutputState},
	{"ecmSxCmpOne_ManualTrgOut",	(FARPROC*)&ecmSxCmpOne_ManualTrgOut},
	{"ecmSxCmpOne_SetHandler",	(FARPROC*)&ecmSxCmpOne_SetHandler},
	{"ecmSxCmpCont_SetChannel",	(FARPROC*)&ecmSxCmpCont_SetChannel},
	{"ecmSxCmpCont_GetChannel",	(FARPROC*)&ecmSxCmpCont_GetChannel},	
	{"ecmSxCmpCont_SetTableSize",	(FARPROC*)&ecmSxCmpCont_SetTableSize},
	{"ecmSxCmpCont_GetTableSize",	(FARPROC*)&ecmSxCmpCont_GetTableSize},
	{"ecmSxCmpCont_SetTableData",	(FARPROC*)&ecmSxCmpCont_SetTableData},
	{"ecmSxCmpCont_GetTableData",	(FARPROC*)&ecmSxCmpCont_GetTableData},
	{"ecmSxCmpCont_GetActTblIdx",	(FARPROC*)&ecmSxCmpCont_GetActTblIdx},
	{"ecmSxCmpCont_SetActTblIdx",	(FARPROC*)&ecmSxCmpCont_SetActTblIdx},
	{"ecmSxCmpCont_SetEnable",	(FARPROC*)&ecmSxCmpCont_SetEnable},
	{"ecmSxCmpCont_GetEnable",	(FARPROC*)&ecmSxCmpCont_GetEnable},
	{"ecmSxCmpCont_GetOutResult",	(FARPROC*)&ecmSxCmpCont_GetOutResult},
	{"ecmSxCmpCont_ClearOutResult",	(FARPROC*)&ecmSxCmpCont_ClearOutResult},
	{"ecmSxCmpCont_SetOutputState",	(FARPROC*)&ecmSxCmpCont_SetOutputState},
	{"ecmSxCmpCont_GetOutputState",	(FARPROC*)&ecmSxCmpCont_GetOutputState},
	{"ecmSxCmpCont_ManualTrgOut",	(FARPROC*)&ecmSxCmpCont_ManualTrgOut},
	{"ecmSxSD_SetInputEnv",	(FARPROC*)&ecmSxSD_SetInputEnv},
	{"ecmSxSD_GetInputEnv",	(FARPROC*)&ecmSxSD_GetInputEnv},
	{"ecmSxSD_SetSpeed",	(FARPROC*)&ecmSxSD_SetSpeed},
	{"ecmSxSD_GetSpeed",	(FARPROC*)&ecmSxSD_GetSpeed},
	{"ecmSxSD_SetOffset",	(FARPROC*)&ecmSxSD_SetOffset},
	{"ecmSxSD_GetOffset",	(FARPROC*)&ecmSxSD_GetOffset},
	{"ecmSxSD_SetLatchMode",	(FARPROC*)&ecmSxSD_SetLatchMode},
	{"ecmSxSD_GetLatchMode",	(FARPROC*)&ecmSxSD_GetLatchMode},
	{"ecmSxSD_SetEnable",	(FARPROC*)&ecmSxSD_SetEnable},
	{"ecmSxSD_GetEnable",	(FARPROC*)&ecmSxSD_GetEnable},
	{"ecmSxSD_RestoreSpeed",	(FARPROC*)&ecmSxSD_RestoreSpeed},
	{"ecmSxSD_GetInputStatus",	(FARPROC*)&ecmSxSD_GetInputStatus},
	{"ecmSxSD_GetActStatus",	(FARPROC*)&ecmSxSD_GetActStatus},
	{"ecmSxDO_SetBitMask",	(FARPROC*)&ecmSxDO_SetBitMask},
	{"ecmSxDO_GetBitMask",	(FARPROC*)&ecmSxDO_GetBitMask},
	{"ecmSxDO_GetOne",	(FARPROC*)&ecmSxDO_GetOne},
	{"ecmSxDO_PutOne",	(FARPROC*)&ecmSxDO_PutOne},
	{"ecmSxDO_GetMulti",	(FARPROC*)&ecmSxDO_GetMulti},
	{"ecmSxDO_PutMulti",	(FARPROC*)&ecmSxDO_PutMulti},
	{"ecmSxMulTorq1_Start",	(FARPROC*)&ecmSxMulTorq1_Start},
	{"ecmSxMulTorq1_Stop",	(FARPROC*)&ecmSxMulTorq1_Stop},
	{"ecmIxCfg_MapAxes",		(FARPROC*)&ecmIxCfg_MapAxes},
	{"ecmIxCfg_MapAxes_FF",		(FARPROC*)&ecmIxCfg_MapAxes_FF},
	{"ecmIxCfg_UnmapAxes",		(FARPROC*)&ecmIxCfg_UnmapAxes},
	{"ecmIxCfg_UnmapAxes_FF",	(FARPROC*)&ecmIxCfg_UnmapAxes_FF},
	{"ecmIxCfg_SetSpeedPatt",	(FARPROC*)&ecmIxCfg_SetSpeedPatt},
	{"ecmIxCfg_SetSpeedPatt_FF",(FARPROC*)&ecmIxCfg_SetSpeedPatt_FF},
	{"ecmIxCfg_GetSpeedPatt",	(FARPROC*)&ecmIxCfg_GetSpeedPatt},
	{"ecmIxCfg_SetSpeedPatt_Time",	(FARPROC*)&ecmIxCfg_SetSpeedPatt_Time},
	{"ecmIxCfg_GetSpeedPatt_Time",	(FARPROC*)&ecmIxCfg_GetSpeedPatt_Time},
	{"ecmIxCfg_SetSpeedPatt_MR",	(FARPROC*)&ecmIxCfg_SetSpeedPatt_MR},
	{"ecmIxCfg_SetSpeedPatt_MR_FF",	(FARPROC*)&ecmIxCfg_SetSpeedPatt_MR_FF},
	{"ecmIxCfg_GetSpeedPatt_MR",	(FARPROC*)&ecmIxCfg_GetSpeedPatt_MR},
	{"ecmIxCfg_SetMastWeight",	(FARPROC*)&ecmIxCfg_SetMastWeight},
	{"ecmIxCfg_GetMastWeight",	(FARPROC*)&ecmIxCfg_GetMastWeight},
	{"ecmIxCfg_SetJerkRatio",	(FARPROC*)&ecmIxCfg_SetJerkRatio},
	{"ecmIxCfg_SetJerkRatio_FF", (FARPROC*)&ecmIxCfg_SetJerkRatio_FF},
	{"ecmIxCfg_GetJerkRatio",	(FARPROC*)&ecmIxCfg_GetJerkRatio},
	{"ecmIxCfg_Spline_ClearPool",		(FARPROC*)&ecmIxCfg_Spline_ClearPool},
	{"ecmIxCfg_Spline_AddNewObj",		(FARPROC*)&ecmIxCfg_Spline_AddNewObj},
	{"ecmIxCfg_Spline_SetRefPoint",		(FARPROC*)&ecmIxCfg_Spline_SetRefPoint},
	{"ecmIxCfg_Spline_BuildObj",		(FARPROC*)&ecmIxCfg_Spline_BuildObj},
	{"ecmIxCfg_Spline_SetTrgOutEnv",	(FARPROC*)&ecmIxCfg_Spline_SetTrgOutEnv},
	{"ecmIxCfg_Spline_GetTrgOutEnv",	(FARPROC*)&ecmIxCfg_Spline_GetTrgOutEnv},
	{"ecmIxCfg_Spline_GetTrgOutPos",	(FARPROC*)&ecmIxCfg_Spline_GetTrgOutPos},
	{"ecmIxCfg_Spline_SetJsType",		(FARPROC*)&ecmIxCfg_Spline_SetJsType},
	{"ecmIxCfg_Spline_GetJsType",		(FARPROC*)&ecmIxCfg_Spline_GetJsType},
	{"ecmIxCfg_Spline_SetJsProp_F",		(FARPROC*)&ecmIxCfg_Spline_SetJsProp_F},
	{"ecmIxCfg_Spline_GetJsProp_F",		(FARPROC*)&ecmIxCfg_Spline_GetJsProp_F},
	{"ecmIxCfg_Spline_SetJerkThresh",	(FARPROC*)&ecmIxCfg_Spline_SetJerkThresh},
	{"ecmIxCfg_Spline_GetJerkThresh",	(FARPROC*)&ecmIxCfg_Spline_GetJerkThresh},
	{"ecmIxCfg_MPRLin2X_ClearPool",		(FARPROC*)&ecmIxCfg_MPRLin2X_ClearPool},
	{"ecmIxCfg_MPRLin2X_AddNewObj",		(FARPROC*)&ecmIxCfg_MPRLin2X_AddNewObj},
	{"ecmIxCfg_MPRLin2X_SetRefPoint",	(FARPROC*)&ecmIxCfg_MPRLin2X_SetRefPoint},
	{"ecmIxCfg_MPRLin2X_BuildObj",		(FARPROC*)&ecmIxCfg_MPRLin2X_BuildObj},
	{"ecmIxMot_LineStart",		(FARPROC*)&ecmIxMot_LineStart},
	{"ecmIxMot_LineStart_FF",	(FARPROC*)&ecmIxMot_LineStart_FF},
	{"ecmIxMot_Line",			(FARPROC*)&ecmIxMot_Line},
	{"ecmIxMot_Line_NB",		(FARPROC*)&ecmIxMot_Line_NB},
	{"ecmIxMot_LineToStart",	(FARPROC*)&ecmIxMot_LineToStart},
	{"ecmIxMot_LineToStart_FF",	(FARPROC*)&ecmIxMot_LineToStart_FF},
	{"ecmIxMot_LineTo",			(FARPROC*)&ecmIxMot_LineTo},
	{"ecmIxMot_LineTo_NB",		(FARPROC*)&ecmIxMot_LineTo_NB},
	{"ecmIxMot_Line_OverrideSpeed",		(FARPROC*)&ecmIxMot_Line_OverrideSpeed},
	{"ecmIxMot_LineTo_OverrideSpeed",		(FARPROC*)&ecmIxMot_LineTo_OverrideSpeed},
	{"ecmIxMot_Line_OverrideSpeed",		(FARPROC*)&ecmIxMot_OverrideSpeed},
	{"ecmIxMot_ArcAng_R_Start",	(FARPROC*)&ecmIxMot_ArcAng_R_Start},
	{"ecmIxMot_ArcAng_R_Start_FF", (FARPROC*)&ecmIxMot_ArcAng_R_Start_FF},
	{"ecmIxMot_ArcAng_R",		(FARPROC*)&ecmIxMot_ArcAng_R},
	{"ecmIxMot_ArcAng_R_NB",	(FARPROC*)&ecmIxMot_ArcAng_R_NB},
	{"ecmIxMot_ArcAng_A_Start",	(FARPROC*)&ecmIxMot_ArcAng_A_Start},
	{"ecmIxMot_ArcAng_A_Start_FF",	(FARPROC*)&ecmIxMot_ArcAng_A_Start_FF},
	{"ecmIxMot_ArcAng_A",		(FARPROC*)&ecmIxMot_ArcAng_A},
	{"ecmIxMot_ArcAng_A_NB",	(FARPROC*)&ecmIxMot_ArcAng_A_NB},
	{"ecmIxMot_ArcPos_R_Start",	(FARPROC*)&ecmIxMot_ArcPos_R_Start},
	{"ecmIxMot_ArcPos_R_Start_FF",	(FARPROC*)&ecmIxMot_ArcPos_R_Start_FF},
	{"ecmIxMot_ArcPos_R",		(FARPROC*)&ecmIxMot_ArcPos_R},
	{"ecmIxMot_ArcPos_R_NB",	(FARPROC*)&ecmIxMot_ArcPos_R_NB},
	{"ecmIxMot_ArcPos_A_Start",	(FARPROC*)&ecmIxMot_ArcPos_A_Start},
	{"ecmIxMot_ArcPos_A_Start_FF",	(FARPROC*)&ecmIxMot_ArcPos_A_Start_FF},
	{"ecmIxMot_ArcPos_A",		(FARPROC*)&ecmIxMot_ArcPos_A},
	{"ecmIxMot_ArcPos_A_NB",	(FARPROC*)&ecmIxMot_ArcPos_A_NB},
	{"ecmIxMot_Arc3P_R_Start",	(FARPROC*)&ecmIxMot_Arc3P_R_Start},
	{"ecmIxMot_Arc3P_R_Start_FF",	(FARPROC*)&ecmIxMot_Arc3P_R_Start_FF},
	{"ecmIxMot_Arc3P_R",		(FARPROC*)&ecmIxMot_Arc3P_R},
	{"ecmIxMot_Arc3P_R_NB",		(FARPROC*)&ecmIxMot_Arc3P_R_NB},
	{"ecmIxMot_Arc3P_A_Start",	(FARPROC*)&ecmIxMot_Arc3P_A_Start},
	{"ecmIxMot_Arc3P_A_FF",		(FARPROC*)&ecmIxMot_Arc3P_A_FF},
	{"ecmIxMot_Arc3P_A",		(FARPROC*)&ecmIxMot_Arc3P_A},
	{"ecmIxMot_Arc3P_A_NB",		(FARPROC*)&ecmIxMot_Arc3P_A_NB},
	{"ecmIxMot_Helical_Start",		(FARPROC*)&ecmIxMot_Helical_Start},
	{"ecmIxMot_Spline_Start",		(FARPROC*)&ecmIxMot_Spline_Start},
	{"ecmIxMot_MPRLin2X_Start",		(FARPROC*)&ecmIxMot_MPRLin2X_Start},
	{"ecmIxMot_MoveVia2X_Start",	(FARPROC*)&ecmIxMot_MoveVia2X_Start},
	{"ecmIxMot_MoveVia2X_OverrideTP",	(FARPROC*)&ecmIxMot_MoveVia2X_OverrideTP},
	{"ecmIxMot_Stop",			(FARPROC*)&ecmIxMot_Stop},
	{"ecmIxMot_Stop_FF",		(FARPROC*)&ecmIxMot_Stop_FF},	
	{"ecmIxSt_IsBusy",			(FARPROC*)&ecmIxSt_IsBusy},
	{"ecmIxSt_WaitCompt",		(FARPROC*)&ecmIxSt_WaitCompt},
	{"ecmIxSt_WaitCompt_NB",	(FARPROC*)&ecmIxSt_WaitCompt_NB},
	{"ecmIxSD_SetInputEnv",	(FARPROC*)&ecmIxSD_SetInputEnv},
	{"ecmIxSD_GetInputEnv",	(FARPROC*)&ecmIxSD_GetInputEnv},
	{"ecmIxSD_SetSpeed",	(FARPROC*)&ecmIxSD_SetSpeed},
	{"ecmIxSD_GetSpeed",	(FARPROC*)&ecmIxSD_GetSpeed},
	{"ecmIxSD_SetOffset",	(FARPROC*)&ecmIxSD_SetOffset},
	{"ecmIxSD_GetOffset",	(FARPROC*)&ecmIxSD_GetOffset},
	{"ecmIxSD_SetLatchMode",	(FARPROC*)&ecmIxSD_SetLatchMode},
	{"ecmIxSD_GetLatchMode",	(FARPROC*)&ecmIxSD_GetLatchMode},
	{"ecmIxSD_SetEnable",	(FARPROC*)&ecmIxSD_SetEnable},
	{"ecmIxSD_GetEnable",	(FARPROC*)&ecmIxSD_GetEnable},
	{"ecmIxSD_RestoreSpeed",	(FARPROC*)&ecmIxSD_RestoreSpeed},
	{"ecmIxSD_GetInputStatus",	(FARPROC*)&ecmIxSD_GetInputStatus},
	{"ecmIxSD_GetActStatus",	(FARPROC*)&ecmIxSD_GetActStatus},
	{"ecmHomeCfg_SetOption",	(FARPROC*)&ecmHomeCfg_SetOption},
	{"ecmHomeCfg_GetOption",	(FARPROC*)&ecmHomeCfg_GetOption},
	{"ecmHomeCfg_SetMode",		(FARPROC*)&ecmHomeCfg_SetMode},
	{"ecmHomeCfg_GetMode",		(FARPROC*)&ecmHomeCfg_GetMode},
	{"ecmHomeCfg_SetOffset",	(FARPROC*)&ecmHomeCfg_SetOffset},
	{"ecmHomeCfg_GetOffset",	(FARPROC*)&ecmHomeCfg_GetOffset},
	{"ecmHomeCfg_SetOffsetEx",	(FARPROC*)&ecmHomeCfg_SetOffsetEx},
	{"ecmHomeCfg_GetOffsetEx",	(FARPROC*)&ecmHomeCfg_GetOffsetEx},
	{"ecmHomeCfg_SetSpeedPatt",	(FARPROC*)&ecmHomeCfg_SetSpeedPatt},
	{"ecmHomeCfg_GetSpeedPatt",	(FARPROC*)&ecmHomeCfg_GetSpeedPatt},
	{"ecmHomeMot_MoveStart",	(FARPROC*)&ecmHomeMot_MoveStart},
	{"ecmHomeMot_MoveStart_FF",	(FARPROC*)&ecmHomeMot_MoveStart_FF},
	{"ecmHomeMot_Move",			(FARPROC*)&ecmHomeMot_Move},
	{"ecmHomeSt_IsBusy",		(FARPROC*)&ecmHomeSt_IsBusy},
	{"ecmHomeSt_WaitCompt",		(FARPROC*)&ecmHomeSt_WaitCompt},
	{"ecmHomeSt_GetFlags",		(FARPROC*)&ecmHomeSt_GetFlags},
	{"ecmMsCfg_SetSlvEnv",		(FARPROC*)&ecmMsCfg_SetSlvEnv},
	{"ecmMsCfg_GetSlvEnv",		(FARPROC*)&ecmMsCfg_GetSlvEnv},
	{"ecmMsCfg_SetTorqFollowMode",		(FARPROC*)&ecmMsCfg_SetTorqFollowMode},
	{"ecmMsCfg_GetTorqFollowMode",		(FARPROC*)&ecmMsCfg_GetTorqFollowMode},
	{"ecmMsCtl_StartSlv",		(FARPROC*)&ecmMsCtl_StartSlv},
	{"ecmMsCtl_StopSlv",		(FARPROC*)&ecmMsCtl_StopSlv},
	{"ecmMsCtl_SynchSlv",		(FARPROC*)&ecmMsCtl_SynchSlv},
	{"ecmMsSt_IsSlvStarted",	(FARPROC*)&ecmMsSt_IsSlvStarted},
	{"ecmLmResetAll",			(FARPROC*)&ecmLmResetAll},
	{"ecmLmCtl_Begin",			(FARPROC*)&ecmLmCtl_Begin},
	{"ecmLmCtl_End",			(FARPROC*)&ecmLmCtl_End},
	{"ecmLmCtl_Run",			(FARPROC*)&ecmLmCtl_Run},
	{"ecmLmCtl_Stop",			(FARPROC*)&ecmLmCtl_Stop},
	{"ecmLmCtl_ClearQue",		(FARPROC*)&ecmLmCtl_ClearQue},
	{"ecmLmCtl_SetSpeedRatio",	(FARPROC*)&ecmLmCtl_SetSpeedRatio},
	{"ecmLmCfg_SetQueFullMode",	(FARPROC*)&ecmLmCfg_SetQueFullMode},
	{"ecmLmCfg_GetQueFullMode",	(FARPROC*)&ecmLmCfg_GetQueFullMode},
	{"ecmLmCfg_SetQueDepth",	(FARPROC*)&ecmLmCfg_SetQueDepth},
	{"ecmLmCfg_GetQueDepth",	(FARPROC*)&ecmLmCfg_GetQueDepth},
	{"ecmLmCfg_SetStepId",		(FARPROC*)&ecmLmCfg_SetStepId},
	{"ecmLmCfg_GetStepId",		(FARPROC*)&ecmLmCfg_GetStepId},
	{"ecmLmCfg_SetStepParam",	(FARPROC*)&ecmLmCfg_SetStepParam},
	{"ecmLmCfg_GetStepParam",	(FARPROC*)&ecmLmCfg_GetStepParam},
	{"ecmLmSt_GetRunSts",		(FARPROC*)&ecmLmSt_GetRunSts},
	{"ecmLmSt_GetRemStepCount",	(FARPROC*)&ecmLmSt_GetRemStepCount},
	{"ecmLmSt_GetRunStepInfo",	(FARPROC*)&ecmLmSt_GetRunStepInfo},
	{"ecmLmSt_GetRunStepParam",	(FARPROC*)&ecmLmSt_GetRunStepParam},
	{"ecmLmCmd_Delay",			(FARPROC*)&ecmLmCmd_Delay},
	{"ecmPtmResetAll",			(FARPROC*)&ecmPtmResetAll},
	{"ecmPtmCtl_Begin",			(FARPROC*)&ecmPtmCtl_Begin},
	{"ecmPtmCtl_End",			(FARPROC*)&ecmPtmCtl_End},
	{"ecmPtmCtl_SetHold",		(FARPROC*)&ecmPtmCtl_SetHold},
	{"ecmPtmCmd_AddItem_PT",	(FARPROC*)&ecmPtmCmd_AddItem_PT},
	{"ecmPtmSt_GetRunSts",		(FARPROC*)&ecmPtmSt_GetRunSts},
	{"ecmPtmSt_GetRunStepInfo",	(FARPROC*)&ecmPtmSt_GetRunStepInfo},
	{"ecmMPMon_AddAxis",		(FARPROC*)&ecmMPMon_AddAxis},
	{"ecmMPMon_DelAxis",		(FARPROC*)&ecmMPMon_DelAxis},
	{"ecmMPMon_SetAxisEnable",	(FARPROC*)&ecmMPMon_SetAxisEnable},
	{"ecmMPMon_GetAxisStatus",	(FARPROC*)&ecmMPMon_GetAxisStatus},
	{"ecmMPMon_ResetAxisData",	(FARPROC*)&ecmMPMon_ResetAxisData},
	{"ecmMPMon_ResetSectData",	(FARPROC*)&ecmMPMon_ResetSectData},
	{"ecmMPMon_SetTorqThreshVal",	(FARPROC*)&ecmMPMon_SetTorqThreshVal},
	{"ecmMPMon_GetTorqThreshVal",	(FARPROC*)&ecmMPMon_GetTorqThreshVal},
	{"ecmMPMon_SetDevThreshVal",	(FARPROC*)&ecmMPMon_SetDevThreshVal},
	{"ecmMPMon_GetDevThreshVal",	(FARPROC*)&ecmMPMon_GetDevThreshVal},
	{"ecmMPMon_ReadAxisData",	(FARPROC*)&ecmMPMon_ReadAxisData},
	{"ecmMPMon_WriteAxisData",	(FARPROC*)&ecmMPMon_WriteAxisData},
	{"ecUtl_ShowError_A",		(FARPROC*)&ecUtl_ShowError_A},
	{"ecUtl_ShowError_W",		(FARPROC*)&ecUtl_ShowError_W},
	{"ecUtl_ShowMessage_A",		(FARPROC*)&ecUtl_ShowMessage_A},
	{"ecUtl_ShowMessage_W",		(FARPROC*)&ecUtl_ShowMessage_W},
	{"ecUtl_GetCntDiff_UI32",	(FARPROC*)&ecUtl_GetCntDiff_UI32},
	{"ecUtl_GetCntDiff_UI16",	(FARPROC*)&ecUtl_GetCntDiff_UI16},
	{"ecUtl_IsTimeOut",			(FARPROC*)&ecUtl_IsTimeOut},
	{"ecNet_SetEnableSTM",		(FARPROC*)&ecNet_SetEnableSTM},
	{"ecSlv_SetAlState_A",		(FARPROC*)&ecSlv_SetAlState_A},
	{"ecmHomeCfg_SetSpeedPatt_Time",	(FARPROC*)&ecmHomeCfg_SetSpeedPatt_Time},
	{"ecmHomeCfg_GetSpeedPatt_Time",	(FARPROC*)&ecmHomeCfg_GetSpeedPatt_Time},
	{"ecNet_CloseTwoPorts",	(FARPROC*)&ecNet_CloseTwoPorts},
	{"ecNet_GetEnableRedundSupport",	(FARPROC*)&ecNet_GetEnableRedundSupport},
	{"ecNet_SetEnableRedundSupport",	(FARPROC*)&ecNet_SetEnableRedundSupport},
	{"ecSlv_IsReverseConnected_A",		(FARPROC*)&ecSlv_IsReverseConnected_A},
	{"ecNet_CheckReverseConnections",	(FARPROC*)&ecNet_CheckReverseConnections},
	{"ecSlv_SetInfo",	(FARPROC*)&ecSlv_SetInfo},
	{"ecSlv_SetInfo_A",	(FARPROC*)&ecSlv_SetInfo_A},
	{"ecSlv_GetInfo",	(FARPROC*)&ecSlv_GetInfo},
	{"ecSlv_GetInfo_A",	(FARPROC*)&ecSlv_GetInfo_A},
	{"ecSlv_ResetEsc",	(FARPROC*)&ecSlv_ResetEsc},
	{"ecSlv_ResetEsc_A",	(FARPROC*)&ecSlv_ResetEsc_A},
	{"ecNet_FwReset",	(FARPROC*)&ecNet_FwReset},
	{"ecaoSetChanVal_I_L",	(FARPROC*)&ecaoSetChanVal_I_L},
	{"ecaoGetOutValue_I_L",	(FARPROC*)&ecaoGetOutValue_I_L},
	{"ecmSxCfg_SetSpeedPatt_TimeStrict",	(FARPROC*)&ecmSxCfg_SetSpeedPatt_TimeStrict},
	{"ecmSxCfg_SetSpeedPatt_TimeStrict_FF",	(FARPROC*)&ecmSxCfg_SetSpeedPatt_TimeStrict_FF},
	{"ecmSxCfg_GetSpeedPatt_TimeStrict",	(FARPROC*)&ecmSxCfg_GetSpeedPatt_TimeStrict},
	{"ecmSxMot_MoveStart_InTime",		(FARPROC*)&ecmSxMot_MoveStart_InTime},
	{"ecmSxMot_MoveStart_InTime_FF",	(FARPROC*)&ecmSxMot_MoveStart_InTime_FF},
	{"ecmSxMot_Move_InTime",			(FARPROC*)&ecmSxMot_Move_InTime},
	{"ecmSxMot_Move_InTime_NB",		(FARPROC*)&ecmSxMot_Move_InTime_NB},
	{"ecmSxMot_MoveToStart_InTime",	(FARPROC*)&ecmSxMot_MoveToStart_InTime},
	{"ecmSxMot_MoveToStart_InTime_FF",	(FARPROC*)&ecmSxMot_MoveToStart_InTime_FF},
	{"ecmSxMot_MoveTo_InTime",			(FARPROC*)&ecmSxMot_MoveTo_InTime},
	{"ecmSxMot_MoveTo_InTime_NB",		(FARPROC*)&ecmSxMot_MoveTo_InTime_NB},
	{"ecm_ODM_SxMot_SmartMoveToStart",	(FARPROC*)&ecm_ODM_SxMot_SmartMoveToStart},
	{"ecSlv_PDO_GetBitOfs_L",	(FARPROC*)&ecSlv_PDO_GetBitOfs_L},
	{"ecm_ODM_SOCfgMapAxes",	(FARPROC*)&ecm_ODM_SOCfgMapAxes},
	{"ecm_ODM_SOCfgEnv",		(FARPROC*)&ecm_ODM_SOCfgEnv},
	{"ecm_ODM_SOSetStartPos",	(FARPROC*)&ecm_ODM_SOSetStartPos},
	{"ecm_ODM_SOSetDataCnt",	(FARPROC*)&ecm_ODM_SOSetDataCnt},
	{"ecm_ODM_SOSetData",		(FARPROC*)&ecm_ODM_SOSetData},
	{"ecm_ODM_SOProfileBuild",	(FARPROC*)&ecm_ODM_SOProfileBuild},
	{"ecm_ODM_SOMoveStart",		(FARPROC*)&ecm_ODM_SOMoveStart},
	{"ecm_ODM_SOStop",			(FARPROC*)&ecm_ODM_SOStop},
	{"ecm_ODM_SOPause",			(FARPROC*)&ecm_ODM_SOPause},
	{"ecm_ODM_SOResume",		(FARPROC*)&ecm_ODM_SOResume},
	{NULL, NULL}
};

t_success ecDll_Load(void)
{
	LIB_FUNCT *f;
	
	if((g_hCmmLibrary = LoadLibraryA (__DLL_FILE_FULL_PATH__)) == NULL)
    	return FALSE;
	
	f = &g_ecSdkFunc[0];
	while(f->ptr != NULL)
	{
		*(f->ptr) = GetProcAddress ((HMODULE)g_hCmmLibrary, f->name);
		if(*(f->ptr) == NULL){
			//printf("Failed to load \"%s\" Function\n", f->name);
		}
		f++;
	}
	
	return TRUE;
}

t_success ecDll_Unload(void)
{
	if(g_hCmmLibrary){
		FreeLibrary(g_hCmmLibrary);
		g_hCmmLibrary = NULL;
	}
	return true;
}

BOOL ecDll_IsLoaded(void)
{
	return !(g_hCmmLibrary == NULL);
}

