//*******************************************************************************
//* [ ceSDK.pas ]
//* Header file for API fuctions in ceSDK library
//* - Update Data: 2008/03/07
//* - Provider: COMIZOA Co., Ltd.
//* - Phone: +82-42-936-6500~6
//* - Fax  : +82-42-936-6507
//* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
//********************************************************************************

unit ceSDK;

interface

uses
	Windows,
	Messages,
	SysUtils,
	Classes,
	Graphics,
	Controls,
	Forms,
	Dialogs;

const
	// , 
	CE_TRUE = 1;
	CE_FALSE = 0;
	
//  Reset Ķ
	CE_RESET_DIO	=		$1;
	CE_RESET_MOTION	=		$2; // Ĩ  (Axis) ʱȭ
	CE_RESET_AIO	=		$4;
	CE_RESET_ALL	=		CE_RESET_DIO or CE_RESET_MOTION or CE_RESET_AIO;
	CE_RESET_CFG_RESTORE	= $10000;
	CE_RESET_DSP = $20000000;	// ߿ DSP 

	// Motion I/O Property ID //
// MIO Property ID //
	cemALM_LOGIC = 0;
	cemALM_MODE = 1;
	cemCMP_LOGIC = 2;
	cemDR_LOGIC = 3;
	cemEL_LOGIC = 4;
	cemEL_MODE = 5; 
	cemERC_LOGIC = 6;
	cemERC_OUT = 7;
	cemEZ_LOGIC = 8;
	cemINP_EN = 9;
	cemINP_LOGIC = 10;
	cemLTC_LOGIC = 11; 
	cemLTC_LTC2SRC = 12;
	cemORG_LOGIC = 13;
	cemSD_EN = 14;
	cemSD_LOGIC = 15;
	cemSD_LATCH = 16;
	cemSD_MODE = 17;
	cemSTA_MODE = 18;
	cemSTA_TRG = 19;
	cemSTP_MODE = 20;
	cemCLR_CNTR = 21;
	cemCLR_SIGTYPE = 22;
	cemCMP_PWIDTH = 23;
	cemERC_ONTIME = 24;
	cemSVON_LOGIC = 25;

// MIO Property ID Ex //
	cemMPID_ALM_LOGIC = 0;
	cemMPID_ALM_MODE = 1;
	cemMPID_CMP_LOGIC = 2;
	cemMPID_DR_LOGIC = 3;
	cemMPID_EL_LOGIC = 4;
	cemMPID_EL_MODE = 5;
	cemMPID_ERC_LOGIC = 6;
	cemMPID_ERC_OUT = 7;
	cemMPID_EZ_LOGIC = 8;
	cemMPID_INP_EN = 9;
	cemMPID_INP_LOGIC = 10;
	cemMPID_LTC_LOGIC = 11; 
	cemMPID_LTC_LTC2SRC = 12;
	cemMPID_ORG_LOGIC = 13;
	cemMPID_SD_EN = 14;
	cemMPID_SD_LOGIC = 15;
	cemMPID_SD_LATCH = 16;
	cemMPID_SD_MODE = 17;
	cemMPID_STA_MODE = 18;
	cemMPID_STA_TRG = 19;
	cemMPID_STP_MODE = 20;
	cemMPID_CLR_CNTR = 21;
	cemMPID_CLR_SIGTYPE = 22;
	cemMPID_CMP_PWIDTH = 23; 
	cemMPID_ERC_ONTIME = 24;
	cemMPID_SVON_LOGIC = 25;
	cemMPID_ERC_OUT_EL = 26;
	cemMPID_CNT_D_SRC = 27;
	cemMPID_CNT_G_SRC = 28;
	cemMPID_SLIM_EN = 100;
	cemMPID_OUT_MODE = 101;
	cemMPID_IN_MODE = 102;
	cemMPID_IN_INV = 103;
	cemMPID_CEMG_EN = 104;

// Bit order of StReadMioStatuses() return value  //
	cemIOST_RDY = 0;
	cemIOST_ALM = 1;
	cemIOST_ELN = 2;
	cemIOST_ELP = 3;
	cemIOST_ORG = 4; 
	cemIOST_DIR = 5;
	cemIOST_EZ = 6;
	cemIOST_LTC = 7;
	cemIOST_SD = 8;
	cemIOST_INP = 9; 
	cemIOST_DRN = 10;
	cemIOST_DRP = 11;
	cemIOST_STA = 12;
	cemIOST_STP = 13;
	cemIOST_ALMR = 14;
	cemIOST_EMG = 15;
	cemIOST_SVON = 16;
	cemIOST_HOMS = 17;
	cemIOST_PLSA = 18;
	
	// ------ MST(Motion State)  
	cemMST_STOP = 0;
	cemMST_WAIT_DR = 1;
	cemMST_WAIT_STA = 2;
	cemMST_WAIT_INSYNC = 3;
	cemMST_WAIT_OTHER = 4; 
	cemMST_WAIT_ERC = 5;
	cemMST_WAIT_DIR = 6;
	cemMST_RESERVED1 = 7;
	cemMST_WAIT_PLSR = 8;
	cemMST_IN_RVSSPD = 9; 
	cemMST_IN_INISPD = 10;
	cemMST_IN_ACC = 11;
	cemMST_IN_WORKSPD = 12;
	cemMST_IN_DEC = 13;
	cemMST_WAIT_INP = 14; 
	cemMST_SPARE0 = 15;
	cemMST_HOMMING = 16;

	// ------- (A Ǵ B)
	cemLOGIC_A = 0;
	cemLOGIC_B = 1;
	
	// ------  (Axis) ̸ (zero based)
	cemX1 = 0;
	cemY1 = 1;
	cemZ1 = 2;
	cemU1 = 3;

	cemX2 = 4;
	cemY2 = 5;
	cemZ2 = 6;
	cemU2 = 7;
	
	// ------- Feedback ޽ Է 
	cemIMODE_AB1X = 0;
	cemIMODE_AB2X = 1;
	cemIMODE_AB4X = 2;
	cemIMODE_CWCCW = 3;
	cemIMODE_STEP = 4;

// Command output mode definition //
	cemOMODE_PDIR0 = 0;
	cemOMODE_PDIR1 = 1;
	cemOMODE_PDIR2 = 2;
	cemOMODE_PDIR3 = 3;
	cemOMODE_CWCCW0 = 4;
	cemOMODE_CWCCW1 = 5;
	cemOMODE_CCWCW0 = 6;
	cemOMODE_CCWCW1 = 7;

// Control Mode //
	cemCTRL_OPEN = 0; // Open loop control mode
	cemCTRL_SEMI_C = 1; // Semi-closed loop control mode (applied only to absolute in-position commands)
	cemCTRL_FULL_C = 2; // Full-closed loop control mode (this is not supported at current version)
	
	// ----  (- Ǵ +)
	cemDIR_N = 0;
	cemDIR_P = 1;
	
	// ----- ī 
	cemCNT_COMM = 0; // Command
	cemCNT_FEED = 1; // Feedback
	cemCNT_DEV  = 2; // DEVCounter
	cemCNT_GEN = 3; // General
	cemCNT_REM = 4; // Remained	
	
	// -------  ӵ 
	cemSMODE_KEEP = -1; //   ӵ  
	cemSMODE_C = 0;	// Constant:  
	cemSMODE_T = 1; // Trapezoidal
	cemSMODE_S = 2; // S-Curve
	
	// ------- Arc   (CW-ClockWise, CCW-Counter ClockWise)
	cemARC_CW = 0;
	cemARC_CCW = 1;	
		
		
// Compare Method //
	cemDISABLE = 0;
	cemEQ_BIDIR = 1;
	cemEQ_PDIR = 2;
	cemEQ_NDIR = 3;
	cemLESS = 4;	//Cnt<Data
	cemGREATER = 5; //Cnt>Data

// Action when general comparator met the condition //
	cemEVNT_ONLY = 0;
	cemEVNT_IS = 1;
	cemEVNT_DS = 2;
	cemEVNT_SPDCHG = 3;

// Backlash/Slip correction mode //
	cemCORR_DIS = 0; // Disable correction 
	cemCORR_BACK = 1; // Backlash correction mode 
	cemCORR_SLIP = 2; // Slip correction mode

// _TCemExtOptionId
	cemEXOPT_SET_USE_PREREG = 0;

// Interrupt Handler Type //
	cemIHT_MESSAGE = 0;
	cemIHT_EVENT = 1;
	cemIHT_CALLBACK = 2;

// Interrupt Handler Type //
	cemSTR_AXIS_NAME = 0;
	cemSTR_DIST_UNIT = 1;
	cemSTR_SPEED_UNIT = 2;

// Sequence Mode //
	cemSEQM_SKIP_RUN = 0;
	cemSEQM_WAIT_RUN = 1;

// Map Type //
	cemDMAP_MOTION = 0;
	cemDMAP_DIO = 1;
	cemDMAP_ALL = 2;

// SetFilterAB  //
	cemAB_ENC = 0;
	cemAB_PULSAR = 1;

// Axis Capability ID //
	cemCAPX_CMD_DIR = 0; // Command direction change function
	cemCAPX_EL_MAN_SET = 1; // -/+EL Manual control function
	cemCAPX_CMP_HIGH = 2; // High-speed Compare Output function

// HomePosClrMode
	cemHPCM_M0 = 0; // ORG(/EL/EZ) ȣ ߻  COMMAND & FEEDBACK ġ 0 ŬѴ.
	cemHPCM_M1 = 1; // ͸  Ϸϰ  COMMAND & FEEDBACK ġ  0 ŬѴ.
	cemHPCM_M2 = 2;  // ͸  Ϸϰ  FEEDBACK ġ ״ ΰ COMMAND ġ FEEDBACK ġ ġŲ.

// Sync mode //
	cemSYNC_DISABLE = 0;
	cemSYNC_INT_SYNC = 1;
	cemSYNC_OTHER_STOP = 2;

// Internal sync. conditions //
	cemISYNC_ACC_STA = 0; // 0: at start of acceleration
	cemISYNC_ACC_END = 1; // 1: at end of acceleration
	cemISYNC_DEC_STA = 2; // 2: at start of deceleration
	cemISYNC_DEC_END = 3; // 3: at end of deceleration
	cemISYNC_SLN = 4; // 4: when (-)software limit met
	cemISYNC_SLP = 5; // 5: when (+)software limit met
	cemISYNC_GCMP = 6; // 6: when General Comparator condition is satisfied
	cemISYNC_TCMP = 7; // 7: when Trigger Comparator condition is satisfied

// DIO Mode //
	cemDIOMODE_IN = 0;//Input Mode
	cemDIOMODE_OUT = 1; //Output Mode

//////////////////////////////////////////////////////////////////////////
// Basic Node Information 
//////////////////////////////////////////////////////////////////////////
	MAX_NODE	=	255;
	MAX_MOT_MODULE	=	10;
	MAX_DIO_MODULE	=	10;
	MAX_AI_MODULE	=	10;
	MAX_AO_MODULE	=	10;

	MODULE_MOT_TYPE =	$2;
	MODULE_AI_TYPE = 	$3;
	MODULE_AO_TYPE = 	$4;
	MODULE_DIO_TYPE =	$5;
			
	// -----  ڵ 
//////////////////////////////////////////////////////////////////////////
// General Error Codes
//////////////////////////////////////////////////////////////////////////

	ceERR_NONE	=						   0;

	ceGnERR_NONE =                          0;
	ceGnERR_INVALID_PARAMETER =       -100000;
	ceGnERR_MEM_ALLOC_FAIL =          -100010;
	ceGnERR_GLOBAL_MEM_FAIL =         -100020;
	ceGnERR_UNREADY_FUNCTION =        -110000;

	ceGnERR_TIMEOUT =                      -1; // communication timeout error
	ceGnERR_INVALID_PACKET =               -2; // Packet data error
	ceGnERR_CHECKSUM =                     -3; // checksum mismatch
	ceGnERR_FLASH_ERASE_FAIL =             -4; // fali to erase flash-memory
	ceGnERR_UNDEFINE_COMMAND =             -5; // Undefined control command has been received

//////////////////////////////////////////////////////////////////////////
// Motion API Error Codes
//////////////////////////////////////////////////////////////////////////
	cemERR_MEM_ALLOC_FAIL = -290; // Memory allocation fail
	cemERR_GLOBAL_MEM_FAIL = -292; // Global memory allocation fail
	cemERR_ISR_CONNEC_FAIL =  -310; // ISR registration fail
	cemERR_DIVIDE_BY_ZERO = -400; // Cause divide by zero error 
	cemERR_WORNG_NUM_DATA = -500; // Number of data is too small or too big
	cemERR_VER_MISMATCH =  -600;  // Version(of file or device) mismatch

	cemERR_INVALID_DEVICE_ID = -1010; // Invalid device id => Load Device Ǵ SetDeviceId()...
	cemERR_INVALID_HANDLE = -1020;
	cemERR_UNSUPORTED_FUNC = -1030;
	cemERR_INVALID_PARAMETER = -1101;
	cemERR_INVALID_CHANNEL = -1105;
	cemERR_INVALID_INPUT_RANGE = -1111; // Invalid range value (AI, AO)
	cemERR_INVALID_FREQ_RANGE = -1121; // Invalid input or output frequency
	cemERR_FILE_CREATE_FAIL = -1501; // File create fail 
	cemERR_FILE_OPEN_FAIL = -1511; // File open fail
	cemERR_FILE_READ_FAIL = -1522; // File reading fail
	cemERR_EVENT_CREATE_FAIL = -1550; // Event handle creation fail   
	cemERR_INT_INSTANCE_FAIL = -1560; // Interrupt event instance creation fail
	cemERR_DITHREAD_CRE =  -1570; // D/I state change monitor thread creation fail
	cemERR_BUFFER_SMALL =  -1580; // Buffer size is too small
	cemERR_HIGH_TIMER_UNSUPP = -1590; // The installed hardware does not support a high-resolution performance counter (cemmUtlDelayMicroSec() function fails)
	cemERR_OUT_OF_RANGE =  -1600; // The range of some parameter is out of range

	cemERR_ON_MOTION =   -5001;
	cemERR_STOP_BY_SLP =  -5002; // Abnormally stopped by positive soft limit
	cemERR_STOP_BY_SLN =  -5003; // Abnormally stopped by negative soft limit
	cemERR_STOP_BY_CMP3 =  -5004; // Abnormally stopped by comparator3
	cemERR_STOP_BY_CMP4 =  -5005; // Abnormally stopped by comparator4
	cemERR_STOP_BY_CMP5 =  -5006; // Abnormally stopped by comparator5
	cemERR_STOP_BY_ELP =  -5007; // Abnormally stopped by (+) external limit
	cemERR_STOP_BY_ELN =  -5008; // Abnormally stopped by (-) external limit
	cemERR_STOP_BY_ALM =  -5009; // Abnormally stopped by alarm input signal
	cemERR_STOP_BY_CSTP =  -5010; // Abnormally stopped by CSTP input signal
	cemERR_STOP_BY_CEMG =  -5011; // Abnormally stopped by CEMG input signal
	cemERR_STOP_BY_SD =  -5012; // Abnormally stopped by SD input signal
	cemERR_STOP_BY_DERROR = -5013; // Abnormally stopped by operation data error
	cemERR_STOP_BY_IP =  -5014; // Abnormally stopped by other axis error during interpolation
	cemERR_STOP_BY_PO =  -5015; // An overflow occurred in the PA/PB input buffer
	cemERR_STOP_BY_AO =  -5016; // Out of range position counter during interpolation
	cemERR_STOP_BY_EE =  -5017; // An EA/EB input error occurred (does not stop)
	cemERR_STOP_BY_PE =  -5018; // An PA/PB input error occurred (does not stop)
	cemERR_STOP_BY_SLVERR = -5019; // Abnormally stopped because slave axis has been stopped
	cemERR_STOP_BY_SEMG =  -5020; // Abnormally stopped by software emergency setting

	cemERR_MOT_MAOMODE =  -5110; // Master output mode is not CW/CCW mode // Master/Slave ۽ÿ Master output尡 CW/CCW尡 ƴϴ.
	cemERR_MOT_SLAVE_SET =  -5120; // Slave start fail (Motion state "Wait for Pulsar Input"  ʴ´.
	cemERR_SPEED_RANGE_OVER = -5130;
	cemERR_INVALID_SPEED_SET = -5140; // Speed setting value is not valid
	cemERR_INVALID_IXMAP =  -5150; // Invalid interpolation map
	cemERR_INVALID_LMMAP =  -5160; // Invalid List-Motion Map 
	cemERR_MOT_SEQ_SKIPPED = -5170; // Motion command is skipped because the axis is already running.  


//////////////////////////////////////////////////////////////////////////
// Process Boost Mode & Level
//////////////////////////////////////////////////////////////////////////

// MODE
	CE_PROCESS_ONLY_BOOST	= 0;
	CE_SERVICE_ONLY_BOOST	= 1;
	CE_ALL_BOOST	=		2;

// LEVEL
	CE_ABOVE_NORMAL_PRIORITY_CLASS	=	$8000;
	CE_BELOW_NORMAL_PRIORITY_CLASS	=	$4000;
	CE_HIGH_PRIORITY_CLASS	=		$80;
	CE_IDLE_PRIORITY_CLASS	=		$40;
	CE_NORMAL_PRIORITY_CLASS	=	$20;
	CE_PROCESS_MODE_BACKGROUND_BEGIN	= $100000;
	CE_PROCESS_MODE_BACKGROUND_END	=	$200000;
	CE_REALTIME_PRIORITY_CLASS	=	$100;

type
	//****************************************************************************
	//*************** START OF GENERAL FUNCTION DECLARATIONS *********************
	//****************************************************************************
		
	// ̺귯 ε ¿ ġ ε.	
	TCMM_ceGnLoad	  	= function () : LongInt; stdcall;
		
	// ̺귯 ε ¿ ġ ε.		
	TCMM_ceGnUnload    = function () : LongInt; stdcall; 
		
	//  带 .
	// [DebugMode:  , szDebugFileName:     ̸]		
	TCMM_ceGnDebugMode				= function (DebugMode : LongInt; szBebugFileName : PChar) : LongInt; stdcall; 		
		
	// ̺귯 ε ¿ 带 ٽ Žմϴ.
	// [RealNode:   , nTimeout: Ÿ ƿ, IsBlocking: Ϸɶ ޼  , pResultNode: ε   ȯ]
	TCMM_ceGnReSearchDevice	= function (RealNode : LongInt; nTimeout : LongInt; IsBlocking : LongInt; pResultNode : PLongInt) : LongInt; stdcall;
		
	//  Ž ϷǾ ִ Ȯմϴ.  μ ٸ μ ̹ 尡 ŽǾٸ,  Լ 
	// ̹ Ž 带   Ž ϰų  ʵ   ֽϴ.
	TCMM_ceGnIsSearchedDevice	= function (IsSearchedDevice : PLongInt) : LongInt; stdcall;
		
	// ġ ε ¿ ġ ȯ  ȯ.
	// [RealNode:   , nTimeout: Ÿ ƿ, IsBlocking: Ϸɶ ޼  , pResultNode: ü   ȯ]
	TCMM_ceGnSearchDevice	= function (RealNode : LongInt; nTimeout : LongInt; IsBlocking : LongInt; pResultNode : PLongInt) : LongInt; stdcall;
		
	//  Ž ʱȭ ϸ,  Լ   ceGnSearchDevice    Ž   ֽϴ.		
	TCMM_ceGnUnSearchDevice	= function () : LongInt; stdcall;
				
	// ε ü   ȯ.
	// [Node : ε   ȯ]
	TCMM_ceGnTotalNode	= function (Node : PLongInt) : LongInt; stdcall;

	// ε     ȯ.
	// [Channel : ε     ȯ]
	TCMM_ceGnTotalMotionChannel	= function (Channel : PLongInt) : LongInt; stdcall;

	// ε   ä  ȯ.
	// [Channel : ε   ä  ȯ]
	TCMM_ceGnTotalDIOChannel	= function (Channel : PLongInt) : LongInt; stdcall;

	// ε Ƴα Է ä  ȯ.
	// [Channel : ε Ƴα Է ä  ȯ]
	TCMM_ceGnTotalAIChannel	= function (Channel : PLongInt) : LongInt; stdcall;

	// ε Ƴα  ä  ȯ.
	// [Channel : ε Ƴα  ä  ȯ]
	TCMM_ceGnTotalAOChannel	= function (Channel : PLongInt) : LongInt; stdcall;

	// ش      ȯ.
	// [NodeID :  ȣ, ModuleCount : ش      ȯ]
	TCMM_ceGnModuleCount_Motion	= function (NodeID : LongInt; ModuleCount : PLongInt) : LongInt; stdcall;

	// ش      ȯ.
	// [NodeID :  ȣ, ModuleCount : ش      ȯ]
	TCMM_ceGnModuleCount_Dio	= function (NodeID : LongInt; ModuleCount : PLongInt) : LongInt; stdcall;

	// ش  Ƴα Է   ȯ.
	// [NodeID :  ȣ, ModuleCount : ش  Ƴα Է   ȯ]
	TCMM_ceGnModuleCount_Ai	= function (NodeID : LongInt; ModuleCount : PLongInt) : LongInt; stdcall;

	// ش  Ƴα    ȯ.
	// [NodeID,  ȣ, ModuleCount : ش  Ƴα    ȯ]
	TCMM_ceGnModuleCount_Ao	= function (NodeID : LongInt; ModuleCount : PLongInt) : LongInt; stdcall;

	// ش   ⿡      ȯ.
	// [NodeID :  ȣ, ModuleIdx :   ȣ, ChannelCount :     ȯ]
	TCMM_ceGnChannelCount_Motion	= function (NodeID : LongInt; ModuleIdx : LongInt; ChannelCount : PLongInt) : LongInt; stdcall;

	// ش    ⿡  ä  ȯ .
	// [NodeID :  ȣ, ModuleIdx :    ȣ, ChannelCount :   ä  ȯ]
	TCMM_ceGnChannelCount_Dio	= function (NodeID : LongInt; ModuleIdx : LongInt; ChannelCount : PLongInt) : LongInt; stdcall;

	// ش  Ƴα Է ⿡  ä  ȯ.
	// [NodeID :  ȣ, ModuleIdx : Ƴα Է  ȣ, ChannelCount : Ƴα Է ä  ȯ]
	TCMM_ceGnChannelCount_Ai	= function (NodeID : LongInt; ModuleIdx : LongInt; ChannelCount : PLongInt) : LongInt; stdcall;

	// ش  Ƴα  ⿡  ä  ȯ.
	// [NodeID :  ȣ, ModuleIdx : Ƴα   ȣ, ChannelCount : Ƴα  ä  ȯ]
	TCMM_ceGnChannelCount_Ao	= function (NodeID : LongInt; ModuleIdx : LongInt; ChannelCount : PLongInt) : LongInt; stdcall;

	// ش 忡 Ʈ  Emergency Ȳ ϰų  մϴ.
	TCMM_ceGnEmergency_Set	= function (NodeID : LongInt; State : LongInt) : LongInt; stdcall;

	// ش  Emergency Ȳ  ȯմϴ.
	TCMM_ceGnEmergency_Get	= function (NodeID : LongInt; State : PLongInt) : LongInt; stdcall;

	// ش   ʱȭ.
	// [NodeID :  ȣ, ResetMode : ʱȭ ]
	TCMM_ceGnResetNode	= function (NodeID : LongInt; ResetMode : LongInt) : LongInt; stdcall;

	// ش μ  μ μ 켱 
	// [BoostLevel : 켱 , BoostMode : ]
	TCMM_ceGnCtrlBoost_Set	= function (BoostLevel : LongInt; BoostMode : LongInt) : LongInt; stdcall;

	// ش μ  μ μ 켱 ȯ
	// [BoostLevel : 켱 , BoostMode : ]
	TCMM_ceGnCtrlBoost_Get	= function (BoostLevel : PLongInt; BoostMode : PLongInt) : LongInt; stdcall;

	// ش 尡 Ǿ ִ Ǿ ִ Ȯϴ Լ
	// [NodeID :  , IsActive :  Ȥ  ]
	TCMM_ceGnNodeIsActive	= function (NodeID : LongInt; IsActive : PLongInt) : LongInt; stdcall;

	// ش  Flash Memory ȯ    .
	// [NodeID :  ȣ]
	TCMM_ceGnBeginSerialize	= function (NodeID : LongInt) : LongInt; stdcall;

	// ش 忡 Flash Memory ȯ    .
	// [NodeID :  ȣ]
	TCMM_ceGnEndSerialize	= function (NodeID : LongInt) : LongInt; stdcall;

	// ش   ࿡      ȯ.
	// [Axis :     ȣ, NodeIP :  IP ּ ȯ, NodeID :  ȣ ȯ, NodeInGlobal : ش      ȣ ȯ,
	// ModuleIdx : ش   ȣ ȯ, ModuleInCh :      ȣ ȯ]
	TCMM_ceGnLocalAxis_Get	= function (Axis : LongInt; NodeIP : PLongInt; NodeID : PLongInt; NodeInGlobal : PLongInt; ModuleIdx : PLongInt; ModuleInCh : PLongInt ) : LongInt; stdcall;

	// ش  I/O äο      ȯ.
	// [Channel :    ä ȣ, NodeIP :  IP ּ ȯ, NodeID :  ȣ ȯ, NodeInGlobal : ش     ä ȣ ȯ, ModuleIdx : ش   ȣ ȯ, ModuleInCh :     ä ȣ ȯ]
	TCMM_ceGnLocalDIO_Get	= function (Channel : LongInt; NodeIP : PLongInt; NodeID : PLongInt; NodeInGlobal : PLongInt; ModuleIdx : PLongInt; ModuleInCh : PLongInt) : LongInt; stdcall;

	// ش Ƴα Է äο      ȯ.
	// [Channel:  Ƴα Է ä ȣ, NodeIP :  IP ּ ȯ, NodeID :  ȣ ȯ, NodeInGlobal : ش   Ƴα Է ä ȣ ȯ, ModuleIdx : ش   ȣ ȯ, ModuleInCh :   Ƴα Է ä ȣ ȯ]
	TCMM_ceGnLocalAI_Get	= function (Channel : LongInt; NodeIP : PLongInt; NodeID : PLongInt; NodeInGlobal : PLongInt; ModuleIdx : PLongInt; ModuleInCh : PLongInt) : LongInt; stdcall;

	// ش Ƴα  äο      ȯ.
	// [Channel:  Ƴα  ä ȣ, NodeIP :  IP ּ ȯ, NodeID :  ȣ ȯ, NodeInGlobal : ش   Ƴα  ä ȣ ȯ, ModuleIdx : ش   ȣ ȯ, ModuleInCh :   Ƴα  ä ȣ ȯ]
	TCMM_ceGnLocalAO_Get	= function (Channel : LongInt; NodeIP : PLongInt; NodeID : PLongInt; NodeInGlobal : PLongInt; ModuleIdx : PLongInt; ModuleInCh : PLongInt) : LongInt; stdcall;

	// ش      ȣ Ͽ   ȣ ȯ.
	// [NodeID :  ȣ, ModuleIdx : ش   ȣ, ModuleInCh :      ȣ, GlobalAxis :     ȣ ȯ]
	TCMM_ceGnGlobalAxis_Get	= function (NodeID : LongInt; ModuleIdx : LongInt; ModuleInCh : LongInt; GlobalAxis : PLongInt) : LongInt; stdcall;

	// ش      ä ȣ Ͽ  ä ȣ ȯ.
	// [NodeID :  ȣ, ModuleIdx : ش   ȣ, ModuleInCh :     ä ȣ, GlobalDIO :    ä ȣ ȯ]
	TCMM_ceGnGlobalDIO_Get	= function (NodeID : LongInt; ModuleIdx : LongInt; ModuleInCh : LongInt; GlobalDIO : PLongInt) : LongInt; stdcall;

	// ش  Ƴα Է   ä ȣ Ͽ  ä ȣ ȯ.
	// [NodeID :  ȣ, ModuleIdx : ش   ȣ, ModuleInCh :   Ƴα Է ä ȣ, GlobalAI :  Ƴα Է ä ȣ ȯ]
	TCMM_ceGnGlobalAI_Get	= function (NodeID : LongInt; ModuleIdx : LongInt; ModuleInCh : LongInt; GlobalAI : PLongInt) : LongInt; stdcall;

	// ش  Ƴα    ä ȣ Ͽ  ä ȣ ȯ.
	// [NodeID :  ȣ, ModuleIdx : ش   ȣ, ModuleInCh :   Ƴα  ä ȣ, GlobalAO :  Ƴα  ä ȣ ȯ]
	TCMM_ceGnGlobalAO_Get	= function (NodeID : LongInt; ModuleIdx : LongInt; ModuleInCh : LongInt; GlobalAO : PLongInt) : LongInt; stdcall;
				
	//****************************************************************************
	//*************** START OF GENERAL MOTION FUNCTION DECLARATIONS **************
	//****************************************************************************

	TCMM_cemGnServoOn_Set	  	= function (nChannel : LongInt; IsEnable : LongInt) : LongInt; stdcall;
	TCMM_cemGnServoOn_Get	  	= function (nChannel : LongInt; IsEnable : PLongInt) : LongInt; stdcall;
	TCMM_cemGnAlarmReset	  	= function (Axis : LongInt; IsReset : LongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF CONFIGURATION FUNCTION DECLARATIONS ***************
	//****************************************************************************

	//   ȣ ȯ  . PropId ceSDKDef.h Ͽ ǵ enum _TCmMioPropId  Ʈ .
	// [Axis :   ȣ, PropId : ȯ  Ű , PropVal : PropId  ȯ濡  ]
	TCMM_cemCfgMioProperty_Set = function (Axis : LongInt; PropId : LongInt; PropVal : LongInt) : LongInt; stdcall;

	//   ȣ ȯ   ȯ. PropId ceSDKDef.h Ͽ ǵ enum _TCmMioPropId  Ʈ .
	// [Axis :   ȣ, PropId : ȯ  Ű , PropVal : PropId  ȯ濡  ȯ]
	TCMM_cemCfgMioProperty_Get = function (Axis : LongInt; PropId : LongInt; PropVal : PLongInt) : LongInt; stdcall;

	//  I/O(Input/Output) ȣ      .
	// [Axis :   ȣ, IsEnable :    ]
	TCMM_cemCfgFilter_Set = function (Axis : LongInt; IsEnable : LongInt) : LongInt; stdcall;

	//  I/O(Input/Output) ȣ       ¸ ȯ.
	// [Axis :   ȣ, IsEnabled :     ȯ]
	TCMM_cemCfgFilter_Get = function (Axis : LongInt; IsEnabled : PLongInt) : LongInt; stdcall;

	// EA/EB Ǵ PA/PB ȣ Է ȸο  ͸   .
	// [Channel :   ȣ, Target : Լ  (EA/EB or PA/PB), IsEnable :    ]
	TCMM_cemCfgFilterAB_Set = function (Channel : LongInt; Target : LongInt; IsEnable : LongInt) : LongInt; stdcall;

	// EA/EB Ǵ PA/PB ȣ Է ȸο  ͸     ¸ ȯ
	// [Channel :   ȣ, Target : Լ  (EA/EB or PA/PB), IsEnabled :     ȯ]
	TCMM_cemCfgFilterAB_Get = function (Channel : LongInt; Target : LongInt; IsEnabled : PLongInt) : LongInt; stdcall;

	// ڴ ޽(Feedback Pulse) ȣ Է  .
	// [Axis :   ȣ, InputMode : Feedback Pulse Է , IsReverse : Feedback Count  UP/DOWN  ݴ   ]
	TCMM_cemCfgInMode_Set = function (Axis : LongInt; InputMode : LongInt; IsReverse : LongInt) : LongInt; stdcall;

	// ڴ ޽(Feedback Pulse) ȣ Է   ¸ ȯ.
	// [Axis :   ȣ, InputMode: Feedback Pulse Է , IsReverse : Feedback Count  UP/DOWN  ݴ    ȯ]
	TCMM_cemCfgInMode_Get = function (Axis : LongInt; InputMode : PLongInt; IsReverse : PLongInt) : LongInt; stdcall;

	//  ޽(Command Pulse) ȣ   .
	// [Axis :   ȣ, OutputMode : Command Pulse  ]
	TCMM_cemCfgOutMode_Set = function (Axis : LongInt; OutputMode : LongInt) : LongInt; stdcall;

	//  ޽(Command Pulse) ȣ    ¸ ȯ.
	// [Axis :   ȣ, OutputMode: Command ޽   ȯ]
	TCMM_cemCfgOutMode_Get = function (Axis : LongInt; OutputMode : PLongInt) : LongInt; stdcall;

	// ̼ ǥ ǥ  Ŀǵ ġ  ǵ ġ  .
	// [Axis :   ȣ, CtrlMode :  ]
	TCMM_cemCfgCtrlMode_Set = function (Axis : LongInt; CtrlMode : LongInt) : LongInt; stdcall;

	// ̼ ǥ ǥ  Ŀǵ ġ  ǵ ġ    ¸ ȯ.
	// [Axis :   ȣ, CtrlMode :  ]
	TCMM_cemCfgCtrlMode_Get = function (Axis : LongInt; CtrlMode : PLongInt) : LongInt; stdcall;

	// Է ޽(Feedback Pulse)  ޽(Command Pulse) ش .
	// [Axis :   ȣ, Ratio : Feedback Pulse Command Pulse ش ]
	TCMM_cemCfgInOutRatio_Set = function (Axis : LongInt; Ratio : Double) : LongInt; stdcall;

	// Է ޽(Feedback Pulse)  ޽(Command Pulse) ش  ¸ ȯ.
	// [Axis :   ȣ, Ratio : Feedback Pulse Command Pulse ش  ȯ]
	TCMM_cemCfgInOutRatio_Get = function (Axis : LongInt; Ratio : PDouble) : LongInt; stdcall;

	//  Ÿ  .
	// [Axis :   ȣ, UnitDist :  Ÿ 1 ̵ϱ   ޽ ]
	TCMM_cemCfgUnitDist_Set = function (Axis : LongInt; UnitDist : Double) : LongInt; stdcall;

	//  Ÿ  ȯ.
	// [Axis :   ȣ, UnitDist :  Ÿ 1 ̵ϱ   ޽  ȯ]
	TCMM_cemCfgUnitDist_Get = function (Axis : LongInt; UnitDist : PDouble) : LongInt; stdcall;

	//  ӵ  .
	// [Axis :   ȣ, UnitDist :  ӵ  ޽  ӵ(PPS)]
	TCMM_cemCfgUnitSpeed_Set = function (Axis : LongInt; UnitSpeed : Double) : LongInt; stdcall;

	//  ӵ  ȯ.
	// [Axis :   ȣ, UnitDist :  ӵ  ޽  ӵ(PPS) ȯ]
	TCMM_cemCfgUnitSpeed_Get = function (Axis : LongInt; UnitSpeed : PDouble) : LongInt; stdcall;

	//  ӵ ѹ .
	// [Axis :   ȣ, MaxPPS :  ְ ӵ(PPS)]
	TCMM_cemCfgSpeedRange_Set = function (Axis : LongInt; MaxPPS : Double) : LongInt; stdcall;

	//  ӵ ѹ  ¸ ȯ.
	// [Axis :   ȣ, MinPPS :   ӵ(PPS) ȯ, MaxPPS :  ְ ӵ(PPS) ȯ]
	TCMM_cemCfgSpeedRange_Get = function (Axis : LongInt; MinPPS : PDouble; MaxPPS : PDouble) : LongInt; stdcall;

	//  ̼  ӵ .
	// [Axis :   ȣ, SpeedMode : ӵ , WorkSpeed : ۾ ӵ, Accel : ӵ, Decel : ӵ]
	TCMM_cemCfgSpeedPattern_Set = function (Axis : LongInt; SpeedMode : LongInt; WorkSpeed : Double; Accel : Double;  Decel : Double) : LongInt; stdcall;

	//  ̼  ӵ  ¸ ȯ.
	// [Axis :   ȣ, SpeedMode : ӵ  ȯ, WorkSpeed : ۾ ӵ ȯ, Accel : ӵ ȯ, Decel : ӵ ȯ]
	TCMM_cemCfgSpeedPattern_Get = function (Axis : LongInt; SpeedMode : PLongInt; WorkSpeed : PDouble; Accel : PDouble; Decel : PDouble) : LongInt; stdcall;

	// Է ޽(Feedback Pulse)   ӵ  .
	// [Axis :   ȣ, IsEnable : Feedback ӵ Ȯ  Ȱ , Interval : Feedback ޽  Ȯ ֱ(ms)]
	TCMM_cemCfgActSpdCheck_Set = function (Axis : LongInt; IsEnable : LongInt; Interval : LongInt) : LongInt; stdcall;

	// Է ޽(Feedback Pulse)   ӵ   ¸ ȯ.
	// [Axis :   ȣ, IsEnable : Feedback ӵ Ȯ  Ȱθ ȯ, Interval : Feedback ޽  Ȯ ֱ(ms) ȯ]
	TCMM_cemCfgActSpdCheck_Get = function (Axis : LongInt; IsEnable : PLongInt; Interval : PLongInt) : LongInt; stdcall;

	//  ̼  Ʈ ̼ѹ Ͽ .
	// [Axis :   ȣ, IsEnable : Ʈ   Ȱ , LimitN : (-) Limit, LimitP : (+) Limit]
	TCMM_cemCfgSoftLimit_Set = function (Axis : LongInt; IsEnable : LongInt; LimitN : Double; LimitP : Double) : LongInt; stdcall;

	//  Ʈ ̼ѹ   ȯ.
	// [Axis :   ȣ, IsEnable : Ʈ   Ȱ  ȯ, LimitN : (-) Limit ȯ, LimitP : (+) Limit ȯ]
	TCMM_cemCfgSoftLimit_Get = function (Axis : LongInt; IsEnable : PLongInt; LimitN : PDouble; LimitP : PDouble) : LongInt; stdcall;

	// ī(Ring-Counter)  .
	// [Channel :   ȣ, TargCntr : Լ  (Command or Feedback Counter), IsEnable : Ring-Counter  Ȱ , CntMax: ī ]
	TCMM_cemCfgRingCntr_Set = function (Channel : LongInt; TargCntr : LongInt; IsEnable : LongInt; CntMax : Double) : LongInt; stdcall;

	// ī(Ring-Counter)   ¸ ȯ.
	// [Channel:   ȣ, TargCntr: Լ  (Command or Feedback Counter) , IsEnable: Ring-Counter  Ȱ  ȯ, CntMax: ī  ȯ]
	TCMM_cemCfgRingCntr_Get = function (Channel : LongInt; TargCntr : LongInt; IsEnable : PLongInt; CntMax : PDouble) : LongInt; stdcall;

	// ۾ӵ    ۾ӵ ϴ   .
	// [Axis:   ȣ, fCorrRatio: ӵ  (%)]
	TCMM_cemCfgVelCorrRatio_Set = function (Axis : LongInt; fCorrRatio : Double) : LongInt; stdcall;

	// ۾ӵ    ۾ӵ ϴ   ȯ.
	// [Axis:   ȣ, fCorrRatio: ӵ  (%)]
	TCMM_cemCfgVelCorrRatio_Get = function (Axis : LongInt; fCorrRatio : PDouble) : LongInt; stdcall;

	//  ̼ ۾ Ϸ  ࿡ ο ̼  ϴ޵Ǿ  ó å .
	// [seqMode: (Sequence) ]
	TCMM_cemCfgSeqMode_Set = function (SeqMode : LongInt) : LongInt; stdcall;

	//  ̼ ۾ Ϸ  ࿡ ο ̼  ϴ޵Ǿ  ó å   ȯ.
	// [seqMode: (Sequence) ]
	TCMM_cemCfgSeqMode_Get = function (SeqMode : PLongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF HOME RETURN FUNCTION DECLARATIONS *****************
	//****************************************************************************

	//  ȯ .
	// [Axis:   ȣ, HomeMode:  (0~12), Dir:     EzCount: EzCount (0~15), EscDist: Ż Ÿ, Offset:   ġ  ߰  ̵(ǥ ̼)]
	TCMM_cemHomeConfig_Set = function (Axis : LongInt; HomeMode : LongInt;  Dir : LongInt;  EzCount : LongInt;  EscDist : Double;  Offset : Double) : LongInt; stdcall;

	//  ȯ  ¸ ȯ.
	// [Axis:   ȣ, HomeMode:  (0~12) ȯ, Dir:     ȯ, EzCount: EzCount (0~15) ȯ, EscDist: Ż Ÿ ȯ, Offset:   ġ  ߰  ̵ ȯ]
	TCMM_cemHomeConfig_Get = function (Axis : LongInt; HomeMode : PLongInt; Dir : PLongInt; EzCount : PLongInt; EscDist : PDouble; Offset : PDouble) : LongInt; stdcall;

	//  Ϸ  ߻ϴ  Ʈѷ  ̺갣    ߻ Է ޽(Feedback Pulse) ó  .
	// [Axis:   ȣ, PosClrMode: Command  Feedback ġ ŬǴ ]
	TCMM_cemHomePosClrMode_Set = function (Axis : LongInt; PosClrMode : LongInt) : LongInt; stdcall;

	//  Ϸ  ߻ϴ  Ʈѷ  ̺갣    ߻ Է ޽(Feedback Pulse) ó   ¸ ȯ.
	//[Axis:   ȣ, PosClrMode: Command  Feedback ġ Ŭ Ǵ  ȯ]
	TCMM_cemHomePosClrMode_Get = function (Axis : LongInt; PosClrMode : PLongInt) : LongInt; stdcall;

	//   ӵ .
	// [Axis:   ȣ, SpeedMode:  ӵ , Vel:  ۾ ӵ, Accel:  ӵ, Decel:  ӵ, RevVel: Revers Speed]
	TCMM_cemHomeSpeedPattern_Set = function (Axis : LongInt; SpeedMode : LongInt; Vel : Double; Accel : Double; Decel : Double; RevVel : Double) : LongInt; stdcall;

	//   ӵ  ¸ ȯ.
	// [Axis:   ȣ, SpeedMode:  ӵ  ȯ, Vel:  ۾ ӵ ȯ, Accel: ӵ ȯ, Decel: ӵ ȯ, RevVel: Revers Speed ȯ]
	TCMM_cemHomeSpeedPattern_Get = function (Axis : LongInt; SpeedMode : PLongInt; Vel : PDouble; Accel : PDouble; Decel : PDouble; RevVel : PDouble) : LongInt; stdcall;

	//    ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [Axis:   ȣ, IsBlocking: Ϸɶ ޼  ]
	TCMM_cemHomeMove = function (Axis : LongInt; IsBlocking : LongInt) : LongInt; stdcall;

	//    ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [Axis:   ȣ]
	TCMM_cemHomeMoveStart = function (Axis : LongInt) : LongInt; stdcall;

	//   ¸ ȯ.
	// [Axis:   ȣ, IsBusy:    ]
	TCMM_cemHomeIsBusy = function (Axis : LongInt; IsBusy : PLongInt) : LongInt; stdcall;

	//  Ϸ ñ .
	// [Channel:   ȣ, IsBlocking: Ϸɶ ޼  ]
	TCMM_cemHomeWaitDone = function (Axis : LongInt; IsBlocking : LongInt) : LongInt; stdcall;


	//****************************************************************************
	//*************** START OF SINGLE AXIS CONTROL FUNCTION DECLARATIONS *********
	//****************************************************************************

	//    ش ࿡  ӵ  ӵ .
	// [Axis:   ȣ, SpeedMode: ӵ , VelRatio: ۾ӵ (%), AccRatio: ӵ (%), DecRatio: ӵ (%)]
	TCMM_cemSxSpeedRatio_Set = function (Axis : LongInt; SpeedMode : LongInt; VelRatio : Double; AccRatio : Double; DecRatio : Double) : LongInt; stdcall;

	//    ش ࿡  ӵ  ӵ  ¸ ȯ.
	// [Axis:   ȣ, SpeedMode: ӵ  ȯ, VelRatio: ۾ӵ (%) ȯ, AccRatio: ӵ (%) ȯ, DecRatio: ӵ (%) ȯ]
	TCMM_cemSxSpeedRatio_Get = function (Axis : LongInt; SpeedMode : PLongInt; VelRatio : PDouble; AccRatio : PDouble; DecRatio : PDouble) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [Axis:   ȣ, Distance: ̵ Ÿ, IsBlocking: Ϸɶ ޼  ]
	TCMM_cemSxMove = function (Axis : LongInt; Distance : Double; IsBlocking : LongInt) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [Axis:   ȣ, Distance: ̵ Ÿ]
	TCMM_cemSxMoveStart = function (Axis : LongInt; Distance : Double) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [Axis:   ȣ, Distance: ̵  ǥ, IsBlocking: Ϸɶ ޼  ]
	TCMM_cemSxMoveTo = function (Axis : LongInt; Position : Double; IsBlocking : LongInt) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [Axis:   ȣ, Distance: ̵  ǥ ]
	TCMM_cemSxMoveToStart = function (Axis : LongInt; Position : Double) : LongInt; stdcall;	

	//   ӵ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [Axis:   ȣ, Direction:  ̼ ]
	TCMM_cemSxVMoveStart = function (Axis : LongInt; Direction : LongInt) : LongInt; stdcall;

	//  ̼   .
	// [Axis:   ȣ, IsWaitComplete:  Ϸɶ Լ ȯ , IsBlocking: Ϸɶ ޼  ]
	TCMM_cemSxStop = function (Axis : LongInt; IsWaitComplete : LongInt; IsBlocking : LongInt) : LongInt; stdcall;

	//  ̼  .
	// [Axis:   ȣ]
	TCMM_cemSxStopEmg = function (Axis : LongInt) : LongInt; stdcall;

	//  ̼ Ϸ Ȯ.
	// [Axis:   ȣ, IsDone:  ۾ Ϸ ]
	TCMM_cemSxIsDone = function (Axis : LongInt; IsDone : PLongInt) : LongInt; stdcall;

	//  ̼ Ϸ  .
	// [Axis:   ȣ, IsBlocking: Ϸɶ ޼  ]
	TCMM_cemSxWaitDone = function (Axis : LongInt; IsBlocking : LongInt) : LongInt; stdcall;

	// ش  ࿡   ̼( or  ǥ) ġ ȯ.
	// [Channel:   ȣ, Position:  ̼ ġ  ȯ]
	TCMM_cemSxTargetPos_Get = function (Channel : LongInt; Position : PDouble) : LongInt; stdcall;

	//   ʱ ӵ .
	// [Axis:   ȣ, IniSpeed: ʱ ӵ]
	TCMM_cemSxOptIniSpeed_Set = function (Axis : LongInt; IniSpeed : Double) : LongInt; stdcall;

	//   ʱ ӵ  ȯ.
	// [Axis:   ȣ, IniSpeed: ʱ ӵ ȯ]
	TCMM_cemSxOptIniSpeed_Get = function (Axis : LongInt; IniSpeed : PDouble) : LongInt; stdcall;

	//    ǥ 2ܰ ӵ ̼ .  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [Axis:   ȣ, Distance: ̵ Ÿ( ǥ ), Vel2: 2ܰ ۾ ӵ]
	TCMM_cemSxMoveStart2V = function (Axis : LongInt; Distance : Double; Vel2 : Double) : LongInt; stdcall;

	//    ǥ 2ܰ ӵ ̼ .  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [Axis:  ³ ȣ, Position: ̵ ġ ( ǥ ), Vel2: 2ܰ ۾ ӵ]
	TCMM_cemSxMoveToStart2V = function (Axis : LongInt; Position : Double; Vel2 : Double) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF MULTIPLE AXES CONTROL FUNCTION DECLARATIONS *******
	//****************************************************************************

	//   ǥ ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [NumAxes:   , AxisList:   迭 ּ, DistList: ̵ Ÿ 迭 ּ, IsBlocking: Ϸɶ ޼  ]
	TCMM_cemMxMove = function (NumAxes : LongInt; AxisList : PLongInt; DistList : PDouble; IsBlocking : LongInt) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	//[NumAxes:   , AxisList:   迭 ּ, DistList: ̵ Ÿ(ǥ) 迭 ּ]
	TCMM_cemMxMoveStart = function 	(NumAxes : LongInt; AxisList : PLongInt; DistList : PDouble) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [NumAxes:   , AxisList:   迭 ּ, PosList: ̵ ġ(ǥ) 迭 ּ, IsBlocking: Ϸɶ ޼  ]
	TCMM_cemMxMoveTo = function (NumAxes : LongInt; AxisList : PLongInt; PosList : PDouble; IsBlocking : LongInt) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [NumAxes:   , AxisList:   迭 ּ, PosList: ̵ ġ(ǥ) 迭 ּ]
	TCMM_cemMxMoveToStart = function (NumAxes : LongInt; AxisList : PLongInt; PosList : PDouble) : LongInt; stdcall;

	//  Ӽӵ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [NumAxes:   , AxisList:   迭 ּ, DirList:  ϴ  迭 ּ]
	TCMM_cemMxVMoveStart = function (NumAxes : LongInt; AxisList : PLongInt; DirList : PLongInt) : LongInt; stdcall;

	//  ̼ Ȥ  .
	// [NumAxes:   , AxisList:   迭 ּ, IsWaitComplete:  Ϸɶ Լ ȯ , IsBlocking: Ϸɶ ޼  ]
	TCMM_cemMxStop = function (NumAxes : LongInt; AxisList : PLongInt; IsWaitComplete : LongInt; IsBlocking : LongInt) : LongInt; stdcall;

	//  ̼  .
	// [NumAxes:   , AxisList:   迭 ּ]
	TCMM_cemMxStopEmg = function (NumAxes : LongInt; AxisList : PLongInt) : LongInt; stdcall;

	//  ̼ Ϸ Ȯ.
	// [NumAxes:   , AxisList:   迭 ּ, IsDone: ۾ Ϸ ]
	TCMM_cemMxIsDone = function (NumAxes : LongInt; AxisList : PLongInt; IsDone : PLongInt) : LongInt; stdcall;

	//  ̼ Ϸ  .
	// [NumAxes:   , AxisList:   迭 ּ, IsBlocking: Ϸɶ ޼  ]
	TCMM_cemMxWaitDone = function (NumAxes : LongInt; AxisList : PLongInt; IsBlocking : LongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF INTERPOLATION CONTROL FUNCTION DECLARATIONS *******
	//****************************************************************************

	//    ׷ .
	// [MapIndex:  ȣ(0~7), NodeID:  ȣ, MapMask1:  ʿ    ũ( 32Ʈ, BIT0~BIT31),
	// MapMask2:  ʿ    ũ( 32Ʈ, BIT32~BIT63)]
	TCMM_cemIxMapAxes = function (MapIndex : LongInt; NodeID : LongInt; MapMask1 : LongInt; MapMask2 : LongInt) : LongInt; stdcall;

	//    ׷  .
	// [MapIndex:  ȣ]
	TCMM_cemIxUnMap = function (MapIndex : LongInt) : LongInt; stdcall;

	//  ̼ ӵ .
	// [MapIndex:  ȣ, IsVectorSpeed:  Ȥ  ǵ  , SpeedMode: ӵ , Vel: ۾ ӵ, Acc: ӵ, Dec: ӵ]
	TCMM_cemIxSpeedPattern_Set = function (MapIndex : LongInt; IsVectorSpeed : LongInt; SpeedMode : LongInt; Vel : Double; Acc : Double; Dec : Double) : LongInt; stdcall;

	//  ̼ ӵ  ȯ.
	// [MapIndex:  ȣ, IsVectorSpeed:  Ȥ  ǵ   ȯ, SpeedMode: ӵ  ȯ, Vel: ۾ ӵ ȯ, Acc: ӵ ȯ, Dec: ӵ ȯ]
	TCMM_cemIxSpeedPattern_Get = function (MapIndex : LongInt; IsVectorSpeed : PLongInt; SpeedMode : PLongInt; Vel : PDouble; Acc : PDouble; Dec : PDouble) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [MapIndex:  ȣ, DistList: ̵ Ÿ(ǥ) 迭 ּ, IsBlocking: Ϸɶ ޼  ]
	TCMM_cemIxLine = function (MapIndex : LongInt; DistList : PDouble; IsBlocking : LongInt) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [MapIndex:  ȣ, DistList: ̵ Ÿ(ǥ) 迭 ּ]
	TCMM_cemIxLineStart = function (MapIndex : LongInt; DistList : PDouble) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [MapIndex:  ȣ, PosList: ̵ ġ(ǥ) 迭 ּ, IsBlocking: Ϸɶ ޼  ]
	TCMM_cemIxLineTo = function (MapIndex : LongInt; PosList : PDouble; IsBlocking : LongInt) : LongInt; stdcall;

	//   ǥ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [MapIndex:  ȣ, PosList: ̵ ġ(ǥ) 迭 ּ]
	TCMM_cemIxLineToStart = function (MapIndex : LongInt; PosList : PDouble) : LongInt; stdcall;

	// ȣ  ǥ( ߽ǥ ) ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [MapIndex:  ȣ, XCentOffset:  ġκ  ߽ɱ X ǥ, YCentOffset:  ġ  ߽ɱ Y ǥ,
	// EndAngle: ȣ  Ϸ ǥ  ġ  (Degree), IsBlocking: Ϸɶ ޼  ]
	TCMM_cemIxArcA = function (MapIndex : LongInt; XCentOffset : Double; YCentOffset : Double; EndAngle : Double; IsBlocking : LongInt) : LongInt; stdcall;

	// ȣ  ǥ( ߽ǥ ) ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [MapIndex:  ȣ, XCentOffset:  ġκ  ߽ɱ X ǥ, YCentOffset:  ġκ  ߽ɱ Y ǥ,
	// EndAngle: ȣ  Ϸ ǥ   ġ  (Degree)]
	TCMM_cemIxArcAStart = function (MapIndex : LongInt; XCentOffset : Double; YCentOffset : Double; EndAngle : Double) : LongInt; stdcall;

	// ȣ  ǥ( ߽ǥ ) ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [MapIndex:  ȣ, XCent: ߽ X ǥ, YCent: ߽ Y ǥ,
	// EndAngle: ȣ  Ϸ ǥ   ġ  (Degree), IsBlocking: Ϸɶ ޼  ]
	TCMM_cemIxArcATo = function (MapIndex : LongInt; XCent : Double; YCent : Double; EndAngle : Double; IsBlocking : LongInt) : LongInt; stdcall;

	// ȣ  ǥ( ߽ǥ ) ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [MapIndex:  ȣ, XCent: ߽ X ǥ, YCent: ߽ Y ǥ, EndAngle: ȣ  Ϸ ǥ   ġ  (Degree)]
	TCMM_cemIxArcAToStart = function (MapIndex : LongInt; XCent : Double; YCent : Double; EndAngle : Double) : LongInt; stdcall;

	// ȣ ǥ( ߽ǥ ǥ) ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [MapIndex:  ȣ, XCentOffset:  ġ  ߽ɱ X Ÿ, YCentOffset:  ġ  ߽ɱ Y Ÿ,
	// XEndPointDist: ȣ ̵ Ϸ ǥ  ġκ X Ÿ, YEndPointDist: ȣ  ̵ Ϸ ǥ ġ  Y Ÿ, Direction: ȸ , IsBlocking: Ϸɶ ޼   ]
	TCMM_cemIxArcP = function (MapIndex : LongInt; XCentOffset : Double; YCentOffset : Double; XEndPointDist : Double; YEndPointDist : Double; Direction : LongInt; IsBlocking : LongInt) : LongInt; stdcall;

	// ȣ ǥ( ߽ǥ ǥ) ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [MapIndex:  ȣ, XCentOffset:  ġ  ߽ɱ X Ÿ, YCentOffset:  ġ  ߽ɱ Y Ÿ,
	// XEndPointDist: ȣ  ̵ Ϸ ǥ ġ  X Ÿ, YEndPointDist: ȣ  ̵ Ϸ ǥ ġ  Y Ÿ, Direction: ȸ ]
	TCMM_cemIxArcPStart = function (MapIndex : LongInt; XCentOffset : Double; YCentOffset : Double; XEndPointDist : Double; YEndPointDist : Double; Direction : LongInt) : LongInt; stdcall;

	// ȣ ǥ( ߽ǥ ǥ) ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [MapIndex:  ȣ, XCent: ߽ X ǥ, YCent: ߽ Y ǥ, XEndPointDist: ȣ ̵ Ϸ ǥ X ǥ,
	// YEndPointDist: ȣ ̵ Ϸ ǥ Y ǥ, Direction: ȸ , IsBlocking: Ϸɶ ޼  ]
	TCMM_cemIxArcPTo = function (MapIndex : LongInt; XCent : Double; YCent : Double; XEndPointDist : Double; YEndPointDist : Double; Direction : LongInt; IsBlocking : LongInt) : LongInt; stdcall;

	// ȣ ǥ( ߽ǥ ǥ) ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [MapIndex:  ȣ, XCent: ߽ X ǥ, YCent: ߽ Y ǥ, XEndPointDist: ȣ ̵ Ϸ ǥ X ǥ,
	// YEndPointDist: ȣ ̵ Ϸ ǥ Y ǥ, Direction: ȸ ]
	TCMM_cemIxArcPToStart = function (MapIndex : LongInt; XCent : Double; YCent : Double; XEndPointDist : Double; YEndPointDist : Double; Direction : LongInt) : LongInt; stdcall;

	// 3(Point)  ȣ ǥ ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [MapIndex:  ȣ, P2X:  ġ 2°  X ǥ, P2Y:  ġ 2°  Y ǥ,
	// P3X: 2°  3°  X ǥ, P3Y: 2°  3°  Y ǥ, EndAngle: , IsBlocking: Ϸɶ ޼  ]
	TCMM_cemIxArc3P = function (MapIndex : LongInt; P2X : Double; P2Y : Double; P3X : Double; P3Y : Double; EndAngle : Double; IsBlocking : LongInt) : LongInt; stdcall;

	// 3(Point)  ȣ ǥ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [MapIndex:  ȣ, P2X:  ġ 2°  X ǥ, P2Y:  ġ 2°  Y ǥ,
	// P3X: 2°  3°  X ǥ, P3Y: 2°  3°  Y ǥ, EndAngle: ]
	TCMM_cemIxArc3PStart = function (MapIndex : LongInt; P2X : Double; P2Y : Double; P3X : Double; P3Y : Double; EndAngle : Double) : LongInt; stdcall;

	// 3(Point)  ȣ ǥ ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [MapIndex:  ȣ, P2X: 2°  X ǥ, P2Y: 2°  Y ǥ,
	// P3X: 3°  X ǥ, P3Y: 3°  Y ǥ, EndAngle: , IsBlocking: Ϸɶ ޼  ]
	TCMM_cemIxArc3PTo = function (MapIndex : LongInt; P2X : Double; P2Y : Double; P3X : Double; P3Y : Double; EndAngle : Double; IsBlocking : LongInt) : LongInt; stdcall;

	// 3(Point)  ȣ ǥ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [MapIndex:  ȣ, P2X: 2°  X ǥ, P2Y: 2°  Y ǥ, P3X: 3°  X ǥ, P3Y: 3°  Y ǥ, EndAngle: ]
	TCMM_cemIxArc3PToStart = function (MapIndex : LongInt; P2X : Double; P2Y : Double; P3X : Double; P3Y : Double; EndAngle : Double) : LongInt; stdcall;

	//    ̼   .
	// [MapIndex:  ȣ]
	TCMM_cemIxStop = function (MapIndex : LongInt) : LongInt; stdcall;

	//    ̼ .
	// [MapIndex:  ȣ]
	TCMM_cemIxStopEmg = function (MapIndex : LongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF MASTER/SLAVE CONTROL FUNCTION DECLARATIONS ********
	//****************************************************************************

	//   ࿡ ؼ, Master/Slave   Slave  .
	// [Axis: Slave     ȣ, MaxSpeed: Slave  ִ ӵ, IsInverse: Slave  Master  ݴ Ұ ]
	TCMM_cemMsRegisterSlave = function (Axis : LongInt; MaxSpeed : Double; IsInverse : LongInt) : LongInt; stdcall;

	//   ࿡ ؼ, Master/Slave   Slave  .
	// [Axis: Slave ࿡    ȣ]
	TCMM_cemMsUnregisterSlave = function (Axis : LongInt) : LongInt; stdcall;

	//   ࿡ ؼ, Master/Slave   Slave    ȯ.
	// [SlaveAxis: Slave ¸ Ȯ    ȣ, SlaveState: Slave   ȯ]
	TCMM_cemMsCheckSlaveState = function (SlaveAxis : LongInt; SlaveState : PLongInt) : LongInt; stdcall;

	//   ࿡ ؼ, Master/Slave   Master    ȣ Ȯ.
	// [SlaveAxis: Slave   ȣ, MasterAxis: Master   ȣ]
	TCMM_cemMsMasterAxis_Get = function (SlaveAxis : LongInt; MasterAxis : PLongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF Manual Pulsar FUNCTION SECTION ********************
	//****************************************************************************

	// Manual Pulsar Է ȣ  ȯ漳.
	// [Channel:   ȣ, InputMode: Pulsar Է ȣ Է , IsInverse: Pulsar Է ȣ Ÿ    ġ ]
	TCMM_cemPlsrInMode_Set = function (Channel : LongInt; InputMode : LongInt; IsInverse : LongInt) : LongInt; stdcall;

	// Manual Pulsar Է ȣ  ȯ漳 ȯ.
	// [Channel:   ȣ, InputMode: Pulsar Է ȣ Է  ȯ, Pulsar Է ȣ Ÿ    ġ  ȯ]
	TCMM_cemPlsrInMode_Get = function (Channel : LongInt; InputMode : PLongInt; IsInverse : PLongInt) : LongInt; stdcall;

	// Manual Pulsar PA/PB Է޽ , ޽    .
	// [Channel:   ȣ, GainFactor: PMG ȸο Ǵ  (1~32), DivFactor: PDIV ȸο Ǵ  (1~2048)]
	TCMM_cemPlsrGain_Set = function (Channel : LongInt; GainFactor : LongInt; DivFactor : LongInt) : LongInt; stdcall;

	// Manual Pulsar PA/PB Է޽ , ޽     ȯ.
	// [Channel:   ȣ, GainFactor: PMG ȸο Ǵ   ȯ, DivFactor: PDIV ȸο Ǵ   ȯ]
	TCMM_cemPlsrGain_Get = function (Channel : LongInt; GainFactor : PLongInt; DivFactor : PLongInt) : LongInt; stdcall;
	//
	// Manual Pulsar Է ȣ   ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [Channel:   ȣ, HomeType: Pulsar Input     ]
	TCMM_cemPlsrHomeMoveStart = function (Channel : LongInt; HomeType : LongInt) : LongInt; stdcall;

	// Manual Pulsar Է ȣ  ǥ ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [Channel:   ȣ, Distance: ̵ Ÿ(ǥ), IsBlocking: Ϸɶ ޼  ]
	TCMM_cemPlsrMove = function (Channel : LongInt; Distance : Double; IsBlocking : LongInt) : LongInt; stdcall;

	// Manual Pulsar Է ȣ  ǥ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [Channel:   ȣ, Distance: ̵ Ÿ(ǥ)]
	TCMM_cemPlsrMoveStart = function (Channel : LongInt; Distance : Double) : LongInt; stdcall;

	// Manual Pulsar Է ȣ  ǥ ̼.  Լ  ϷǱ  ȯ ʽϴ.
	// [Channel:   ȣ, Position: ̵ ġ(ǥ), IsBlocking: Ϸɶ ޼  ]
	TCMM_cemPlsrMoveTo = function (Channel : LongInt; Position : Double; IsBlocking : LongInt) : LongInt; stdcall;

	// Manual Pulsar Է ȣ  ǥ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [Channel:   ȣ, Position: ̵ ġ(ǥ)]
	TCMM_cemPlsrMoveToStart = function (Channel : LongInt; Position : Double) : LongInt; stdcall;

	// Manual Pulsar Է ȣ  Ӽӵ ̼.  Լ  ۽Ų Ŀ ٷ ȯ˴ϴ.
	// [Channel:   ȣ]
	TCMM_cemPlsrVMoveStart = function (Channel : LongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF OVERRIDE FUNCTION DECLARATIONS ********************
	//****************************************************************************

	//  ̼ ۾ ߿ ӵ .
	// [Axis:   ȣ]
	TCMM_cemOverrideSpeedSet = function (Axis : LongInt) : LongInt; stdcall;

	//  ̼ ۾ ߿  鿡 Ͽ ÿ ӵ .
	// [NumAxes : ÿ ۾    , AxisList : ÿ ۾    迭 ּ]
	TCMM_cemOverrideSpeedSetAll = function (NumAxes : LongInt; AxisList : LongInt) : LongInt; stdcall;

	// ǥ ̼ ߿, ǥ ǥ  Ÿ .
	// [Axis:   ȣ, NewDistance: ο ǥ Ÿ(ǥ), IsHardApply: Override Ұ , Override    , AppliedState: Override   ]
	TCMM_cemOverrideMove = function (Axis : LongInt; NewDistance : Double; IsHardApply : LongInt; AppliedState : PLongInt) : LongInt; stdcall;

	// ǥ ̼ ߿, ǥ ǥ  Ÿ .
	// [Axis:   ȣ, NewPosition: ο ǥ Ÿ(ǥ), IsHardApply: Override Ұ , Override    , AppliedState: Override   ]
	TCMM_cemOverrideMoveTo = function (Axis : LongInt; NewPosition : Double; IsHardApply : LongInt; AppliedState : PLongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF MONITORING FUNCTION DECLARATIONS ******************
	//****************************************************************************

	//    ϵ ī (޽) . Target  ceSDKDef.h Ͽ ǵ enum _TCnmCntr  Ʈ .
	// [Axis:   ȣ, Target:  ī ȣ, Count:  ī (PPS)]
	TCMM_cemStCount_Set = function (Axis : LongInt; Target : LongInt; Count : LongInt) : LongInt; stdcall;

	//    ϵ ī (޽) ȯ. Target  ceSDKDef.h Ͽ ǵ enum _TCnmCntr  Ʈ .
	// [Axis:   ȣ, Source:   ī ȣ, Count:  ī (PPS) ȯ]
	TCMM_cemStCount_Get = function (Axis : LongInt; Source : LongInt; Count : PLongInt) : LongInt; stdcall;

	//     ī ( Ÿ) . Target  ceSDKDef.h Ͽ ǵ enum _TCnmCntr  Ʈ .
	// [Axis:   ȣ, Target:  ī ȣ, Position:  ī ( Ÿ)]
	TCMM_cemStPosition_Set = function (Axis : LongInt; Target : LongInt; Position : Double) : LongInt; stdcall;

	//     ī ( Ÿ) ȯ. Target  ceSDKDef.h Ͽ ǵ enum _TCnmCntr  Ʈ .
	// [Axis:   ȣ, Source:   ī ȣ, Position:  ī ( Ÿ) ȯ]
	TCMM_cemStPosition_Get = function (Axis : LongInt; Source : LongInt; Position : PDouble) : LongInt; stdcall;

	//    ӵ ȯ. Target  ceSDKDef.h Ͽ ǵ enum _TCnmCntr  Ʈ .
	// [Axis:   ȣ, Source: ӵ ȯ Ǵ ī ȣ, Speed:  Source ӵ( ӵ) ȯ]
	TCMM_cemStSpeed_Get = function (Axis : LongInt; Source : LongInt; Speed : PDouble) : LongInt; stdcall;

	//      ȯ.
	// [Axis:   ȣ, MotStates:   ȯ]
	TCMM_cemStReadMotionState = function (Axis : LongInt; MotStates : PLongInt) : LongInt; stdcall;

	//     I/O  ȯ.
	// [Axis:   ȣ, MiotStates: Machine I/O  ȯ]
	TCMM_cemStReadMioStatuses = function (Axis : LongInt; MioStates : PLongInt) : LongInt; stdcall;

	//  ۻ¿ õ ڿ ȯ. cemStReadMotionState() Լ    .
	// [MstCode:    , Buffer:  ۻ¸  ڿ  ּ ȯ, Bufferlen: ڿ  ]
	TCMM_cemStGetMstString = function (MstCode : LongInt; Buffer : PChar; BufferLen : LongInt) : LongInt; stdcall;

	// ŵ I/O ޽  ȯ.
	// [IOMessageCount: I/O ޽ ]
	TCMM_cemStReadIOMessageCount = function (IOMessageCount : PLongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF DIO CONFIGURATION FUNCTION DECLARATIONS ***********
	//****************************************************************************

	//    ä  (Input/Output) .
	// [Channel:  ä ȣ, InOutMode:  ]
	TCMM_cedioMode_Set = function (Channel : LongInt; InOutMode : LongInt) : LongInt; stdcall;

	//    ä  (Input/Output)   ȯ.
	// [Channel:  ä ȣ, InOutMode:   ȯ]
	TCMM_cedioMode_Get = function (Channel : LongInt; InOutMode : PLongInt) : LongInt; stdcall;

	//    ä    äο  ÿ  (Input/Output) .
	// [IniChan:   ä ȣ, NumChan:  ä , InOutModeMask:   ũ]
	TCMM_cedioModeMulti_Set = function (IniChan : LongInt; NumChan : LongInt; InOutModeMask : LongInt) : LongInt; stdcall;

	//    ä    äο  ÿ  (Input/Output)   ȯ.
	// [IniCahn:   ä ȣ, NumChan:  ä , InOutModeMask:   ũ ȯ]
	TCMM_cedioModeMulti_Get = function (IniChan : LongInt; NumChan : LongInt; InOutModeMask : PLongInt) : LongInt; stdcall;

	//    ä  (Logic) .
	// [Channel:  ä ȣ, InputLogic:  ]
	TCMM_cedioLogicOne_Set = function (Channel : LongInt; Logic : LongInt) : LongInt; stdcall;

	//    ä  (Logic)   ȯ.
	// [Channel:  ä ȣ, InputLogic:   ȯ]
	TCMM_cedioLogicOne_Get = function (Channel : LongInt; Logic : PLongInt) : LongInt; stdcall;

	//    ä    äο  ÿ  (Logic) .
	// [IniChan:   ä ȣ, NumChan:  ä , LogicMask:  (Logic) ũ]
	TCMM_cedioLogicMulti_Set = function (IniChan : LongInt; NumChan : LongInt; LogicMask : LongInt) : LongInt; stdcall;

	//    ä    äο  ÿ  (Logic)   ȯ
	//   ä ³  ȯ [IniChan:   ä ȣ, NumChan: ä , LogicMask:  ũ]
	TCMM_cedioLogicMulti_Get = function (IniChan : LongInt; NumChan : LongInt; LogicMask : PLongInt) : LongInt; stdcall;

	//    ä Է Ǵ   ȯ.
	// [Channel:  ä ȣ, OutState: ä  ȯ]
	TCMM_cedioOne_Get = function (Channel : LongInt; State : PLongInt) : LongInt; stdcall;

	//    ä Է Ǵ   .
	// [Channel:  ä ȣ, OutState: ä ]
	TCMM_cedioOne_Put = function (Channel : LongInt; State : LongInt) : LongInt; stdcall;

	//    ä    äο  ÿ Է Ǵ  ¸ ȯ.
	// [IniChan:   ä ȣ, NumChan:  ä , States: ä  ȯ]
	TCMM_cedioMulti_Get = function (IniChan : LongInt; NumChan : LongInt; States : PLongInt) : LongInt; stdcall;

	//    ä    äο  ÿ Է Ǵ  ¸ .
	// [ IniChan:   ä ȣ, NumChan:  ä , States: ä ]
	TCMM_cedioMulti_Put = function (IniChan : LongInt; NumChan : LongInt; States : LongInt) : LongInt; stdcall;

	//    ä    Ȱȭ Ͽ  Է Ǵ  ¸ ȯ.
	// [Channel:  ä ȣ, CutoffTime_us:  Է ȣ  ð(us), State: ä  ȯ]
	TCMM_cedioOneF_Get = function (Channel : LongInt; CutoffTime_us : LongInt; State : PLongInt) : LongInt; stdcall;

	//    ä 
	//    ä   
	// [IniChan:   ä ȣ, NumChan: ä , CutoffTime_us:  Է ȣ  ð(us), InputStates: ش ä  Է ]
	TCMM_cedioMultiF_Get = function (IniChan : LongInt; NumChan : LongInt; CutoffTime_us : LongInt; States : PLongInt) : LongInt; stdcall;

	//    ä   ä   ޽  ߻
	// [Channel:  ä ȣ, IsOnPulse:      ʱ ޽  ¸ ,
	// IsWaitPulseEnd: ޽  ۽ÿ Լ ٷ ȯ , ƴϸ ޽  ð Լ ȯ   ]
	TCMM_cedioPulseOne = function (Channel : LongInt; IsOnPulse : LongInt; Duration : LongInt;  IsWaitPulseEnd : LongInt) : LongInt; stdcall;

	//   ä     ä   ޽  ߻
	// [IniChan:  ä, NumChan: ä , OutStates:   , Duration: ޽  ð ,
	// IsWaitPulseEnd: ޽  ۽ÿ Լ ٷ ȯ , ƴϸ ޽  ð Լ ȯ   ]
	TCMM_cedioPulseMulti = function (IniChan : LongInt; NumChan : LongInt; OutStates : LongInt; Duration : LongInt; IsWaitPulseEnd : LongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF DI CONTROL FUNCTION DECLARATIONS ******************
	//****************************************************************************

	//   Է ä Է³ 
	// [Channel:  ä ȣ, InputLogic: Է ]
	TCMM_cediLogicOne_Set = function (Channel : LongInt; InputLogic : LongInt) : LongInt; stdcall;

	//   Է ä Է³  ȯ
	// [Channel:  ä ȣ, InputLogic: Է ]
	TCMM_cediLogicOne_Get = function (Channel : LongInt; InputLogic : PLongInt) : LongInt; stdcall;

	//  Է ä Է³ 
	// [IniChan:   ä ȣ, NumChan: ä , LogicMask:  ũ]
	TCMM_cediLogicMulti_Set = function (IniChan : LongInt; NumChan : LongInt; LogicMask : LongInt) : LongInt; stdcall;

	//  Է ä Է³  ȯ
	// [IniChan:   ä ȣ, NumChan: ä , LogicMask:  ũ]
	TCMM_cediLogicMulti_Get = function (IniChan : LongInt; NumChan : LongInt; LogicMask : PLongInt) : LongInt; stdcall;

	//   Էä   Է ä ¸ ȯ
	// [Channel:  ä ȣ, InputState:  Է ]
	TCMM_cediOne_Get = function (Channel : LongInt; InputState : PLongInt) : LongInt; stdcall;

	//   Է ä    Է ä ¸ ȯ
	// [IniChan:   ä ȣ, NumChan: ä , InputStates:  Է ]
	TCMM_cediMulti_Get = function (IniChan : LongInt; NumChan : LongInt; InputStates : PLongInt) : LongInt; stdcall;

	//   Է ä  ä     Ȱȭ Ͽ  Է ¸ ȯ
	// [Channel:  ä ȣ, CutoffTime_us:  Է ȣ  ð(us), InputState: ش ä  Է ]
	TCMM_cediOneF_Get = function (Channel : LongInt; CutoffTime_us : LongInt; InputState : PLongInt) : LongInt; stdcall;

	//   Է ä   
	// [IniChan:   ä ȣ, NumChan: ä , CutoffTime_us:  Է ȣ  ð(us), InputStates: ش ä  Է ]
	TCMM_cediMultiF_Get = function (IniChan : LongInt; NumChan : LongInt; CutoffTime_us : LongInt; InputStates : PLongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF DO CONTROL FUNCTION DECLARATIONS ******************
	//****************************************************************************

	//    ä ³ 
	// [Channel:  ä ȣ, OutputLogic:  ]
	TCMM_cedoLogicOne_Set = function (Channel : LongInt; OutputLogic : LongInt) : LongInt; stdcall;

	//    ä ³   ȯ
	// [Channel:  ä ȣ, OutputLogic: ]
	TCMM_cedoLogicOne_Get = function (Channel : LongInt; OutputLogic : PLongInt) : LongInt; stdcall;

	//   ä     ä  ÿ   ߻
	// [IniChan:   ä ȣ, NumChan: ä , LogicMask:  ũ]
	TCMM_cedoLogicMulti_Set = function (IniChan : LongInt; NumChan : LongInt; LogicMask : LongInt) : LongInt; stdcall;

	//   ä     ä ¸ Ȯ
	// [IniChan:   ä ȣ, NumChan: ä , LogicMask:  ũ]
	TCMM_cedoLogicMulti_Get = function (IniChan : LongInt; NumChan : LongInt; LogicMask : PLongInt) : LongInt; stdcall;

	//    ä   ä    ߻
	// [Channel:  ä ȣ, OutState:  ]
	TCMM_cedoOne_Put = function (Channel : LongInt; OutState : LongInt) : LongInt; stdcall;

	//    ä   ä    ¸ ȯ
	// [Channel:  ä ȣ, OutState:   ]
	TCMM_cedoOne_Get = function (Channel : LongInt; OutState : PLongInt) : LongInt; stdcall;

	//   ä     ä  ÿ   ߻
	// [ IniChan:   ä ȣ, NumChan: ä , OutStates:   ]
	TCMM_cedoMulti_Put = function (IniChan : LongInt; NumChan : LongInt; OutStates : LongInt) : LongInt; stdcall;

	//   ä     ä  ÿ   ¸ Ȯ
	// [IniChannel:   ä ȣ, NumChan: ä , OutStates:   ]
	TCMM_cedoMulti_Get = function (IniChan : LongInt; NumChan : LongInt; OutStates : PLongInt) : LongInt; stdcall;

	//    ä   ä   ޽  ߻
	// [Channel:  ä ȣ, IsOnPulse:      ʱ ޽  ¸ ,
	// IsWaitPulseEnd: ޽  ۽ÿ Լ ٷ ȯ , ƴϸ ޽  ð Լ ȯ   ]
	TCMM_cedoPulseOne = function (Channel : LongInt; IsOnPulse : LongInt; Duration : LongInt;  IsWaitPulseEnd : LongInt) : LongInt; stdcall;

	//   ä     ä   ޽  ߻
	// [IniChan:   ä ȣ, NumChan: ä , OutStates:   , Duration: ޽  ð ,
	// IsWaitPulseEnd: ޽  ۽ÿ Լ ٷ ȯ , ƴϸ ޽  ð Լ ȯ   ]
	TCMM_cedoPulseMulti = function (IniChan : LongInt; NumChan : LongInt;   OutStates : LongInt; Duration : LongInt; IsWaitPulseEnd : LongInt) : LongInt; stdcall;

	//****************************************************************************
	//*************** START OF UTILITY FUNCTION DECLARATIONS *********************
	//****************************************************************************

	// ִ 32Ʈ  ڿ    ġ մϴ.
	// [NodeID :   ȣ]
	// [NumByte:   (Ʈ )]
	// [szText :  ڿ]
	TCMM_ceutlUserData_Set = function (NodeID : LongInt; NumByte : LongInt;  szText : PChar) : LongInt; stdcall;

	// ִ 32Ʈ  ڿ    ġ оɴϴ.
	// [NodeID :   ȣ]
	// [NumByte: о  (Ʈ )]
	// [szText : о ڿ]
	TCMM_ceutlUserData_Get = function (NodeID : LongInt; NumByte : PLongInt; szText : PChar) : LongInt; stdcall;

	//   忡    մϴ.
	// [NodeID :   ȣ]
	// [Version:  ]
	TCMM_ceutlUserVersion_Set = function (NodeID : LongInt; Version : LongInt) : LongInt; stdcall;

	//       оɴϴ.
	// [NodeID :   ȣ]
	// [Version: ϵ ]
	TCMM_ceutlUserVersion_Get = function (NodeID : LongInt; pVersion : PLongInt) : LongInt; stdcall;

	//    ߿  оɴϴ.
	// [NodeID :   ȣ]
	// [Version: ϵ ߿ ]
	TCMM_ceutlNodeVersion_Get = function (NodeID : LongInt; pVersion : PLongInt) : LongInt; stdcall;

	//  ̺귯  ɴϴ.    4Ʈ ּҿ  2Ʈ  Ҵմϴ.  ڸ  4ڸԴϴ.
	// ̺귯     ϴ.
	// [pVersionMS :  Ʈ  ]
	// [pVersionLS :  Ʈ  ]

	// printf("Dynamic Link Library Version = [%d].[%d].[%d].[%d]"
	//	_X(pVersionMS >> 16 and $FF)
	//	_X(pVersionMS >> 0 and $FF)
	//	_X(pVersionLS >> 16 and $FF)
	//	_X(pVersionLS >> 0 and $FF));
	TCMM_ceutlLibVersion_Get = function (pVersionMS : PLongInt; pVersionLS : PLongInt) : LongInt; stdcall;

	//   ȭ ϱ   īƮ ȯ
	// [NodeID :  , pSyncCount :    īƮ]
	TCMM_ceutlSyncCount_Get = function (NodeID : LongInt; pSyncCount : PLongInt) : LongInt; stdcall;

	//   ȭ ϱ  I/O ޼  īƮ ȯ
	// [NodeID :  , pSyncCount :    īƮ]
	TCMM_ceutlIOSyncCount_Get = function (NodeID : LongInt; pSyncCount : PLongInt) : LongInt; stdcall;




	// ****************************************************************************************************************************

	Var

	//****************************************************************************
	//*************** START OF GENERAL FUNCTION DECLARATIONS *********************
	//****************************************************************************	
	
	ceGnLoad : TCMM_ceGnLoad;
	ceGnUnload : TCMM_ceGnUnload;
	ceGnDebugMode : TCMM_ceGnDebugMode;
	ceGnReSearchDevice : TCMM_ceGnReSearchDevice;
	ceGnIsSearchedDevice : TCMM_ceGnIsSearchedDevice;
	ceGnSearchDevice : TCMM_ceGnSearchDevice;
	ceGnUnSearchDevice : TCMM_ceGnUnSearchDevice;
	ceGnTotalNode : TCMM_ceGnTotalNode;
	ceGnTotalMotionChannel : TCMM_ceGnTotalMotionChannel;
	ceGnTotalDIOChannel : TCMM_ceGnTotalDIOChannel;
	ceGnTotalAIChannel : TCMM_ceGnTotalAIChannel;
	ceGnTotalAOChannel : TCMM_ceGnTotalAOChannel;
	ceGnModuleCount_Motion : TCMM_ceGnModuleCount_Motion;
	ceGnModuleCount_Dio : TCMM_ceGnModuleCount_Dio;
	ceGnModuleCount_Ai : TCMM_ceGnModuleCount_Ai;
	ceGnModuleCount_Ao : TCMM_ceGnModuleCount_Ao;
	ceGnChannelCount_Motion : TCMM_ceGnChannelCount_Motion;
	ceGnChannelCount_Dio : TCMM_ceGnChannelCount_Dio;
	ceGnChannelCount_Ai : TCMM_ceGnChannelCount_Ai;
	ceGnChannelCount_Ao : TCMM_ceGnChannelCount_Ao;
	ceGnEmergency_Set : TCMM_ceGnEmergency_Set;
	ceGnEmergency_Get : TCMM_ceGnEmergency_Get;
	ceGnResetNode : TCMM_ceGnResetNode;
	ceGnCtrlBoost_Set : TCMM_ceGnCtrlBoost_Set;
	ceGnCtrlBoost_Get : TCMM_ceGnCtrlBoost_Get;
	ceGnNodeIsActive : TCMM_ceGnNodeIsActive;
	ceGnBeginSerialize : TCMM_ceGnBeginSerialize;
	ceGnEndSerialize : TCMM_ceGnEndSerialize;
	ceGnLocalAxis_Get : TCMM_ceGnLocalAxis_Get;
	ceGnLocalDIO_Get : TCMM_ceGnLocalDIO_Get;
	ceGnLocalAI_Get : TCMM_ceGnLocalAI_Get;
	ceGnLocalAO_Get : TCMM_ceGnLocalAO_Get;
	ceGnGlobalAxis_Get : TCMM_ceGnGlobalAxis_Get;
	ceGnGlobalDIO_Get : TCMM_ceGnGlobalDIO_Get;
	ceGnGlobalAI_Get : TCMM_ceGnGlobalAI_Get;
	ceGnGlobalAO_Get : TCMM_ceGnGlobalAO_Get;
				
	//****************************************************************************
	//*************** START OF GENERAL MOTION FUNCTION DECLARATIONS **************
	//****************************************************************************

	cemGnServoOn_Set : TCMM_cemGnServoOn_Set;
	cemGnServoOn_Get : TCMM_cemGnServoOn_Get;
	cemGnAlarmReset : TCMM_cemGnAlarmReset;

	//****************************************************************************
	//*************** START OF CONFIGURATION FUNCTION DECLARATIONS ***************
	//****************************************************************************

	cemCfgMioProperty_Set : TCMM_cemCfgMioProperty_Set;
	cemCfgMioProperty_Get : TCMM_cemCfgMioProperty_Get;
	cemCfgFilter_Set : TCMM_cemCfgFilter_Set;
	cemCfgFilter_Get : TCMM_cemCfgFilter_Get;
	cemCfgFilterAB_Set : TCMM_cemCfgFilterAB_Set;
	cemCfgFilterAB_Get : TCMM_cemCfgFilterAB_Get;
	cemCfgInMode_Set : TCMM_cemCfgInMode_Set;
	cemCfgInMode_Get : TCMM_cemCfgInMode_Get;
	cemCfgOutMode_Set : TCMM_cemCfgOutMode_Set;
	cemCfgOutMode_Get : TCMM_cemCfgOutMode_Get;
	cemCfgCtrlMode_Set : TCMM_cemCfgCtrlMode_Set;
	cemCfgCtrlMode_Get : TCMM_cemCfgCtrlMode_Get;
	cemCfgInOutRatio_Set : TCMM_cemCfgInOutRatio_Set;
	cemCfgInOutRatio_Get : TCMM_cemCfgInOutRatio_Get;
	cemCfgUnitDist_Set : TCMM_cemCfgUnitDist_Set;
	cemCfgUnitDist_Get : TCMM_cemCfgUnitDist_Get;
	cemCfgUnitSpeed_Set : TCMM_cemCfgUnitSpeed_Set;
	cemCfgUnitSpeed_Get : TCMM_cemCfgUnitSpeed_Get;
	cemCfgSpeedRange_Set : TCMM_cemCfgSpeedRange_Set;
	cemCfgSpeedRange_Get : TCMM_cemCfgSpeedRange_Get;
	cemCfgSpeedPattern_Set : TCMM_cemCfgSpeedPattern_Set;
	cemCfgSpeedPattern_Get : TCMM_cemCfgSpeedPattern_Get;
	cemCfgActSpdCheck_Set : TCMM_cemCfgActSpdCheck_Set;
	cemCfgActSpdCheck_Get : TCMM_cemCfgActSpdCheck_Get;
	cemCfgSoftLimit_Set : TCMM_cemCfgSoftLimit_Set;
	cemCfgSoftLimit_Get : TCMM_cemCfgSoftLimit_Get;
	cemCfgRingCntr_Set : TCMM_cemCfgRingCntr_Set;
	cemCfgRingCntr_Get : TCMM_cemCfgRingCntr_Get;
	cemCfgVelCorrRatio_Set : TCMM_cemCfgVelCorrRatio_Set;
	cemCfgVelCorrRatio_Get : TCMM_cemCfgVelCorrRatio_Get;
	cemCfgSeqMode_Set : TCMM_cemCfgSeqMode_Set;
	cemCfgSeqMode_Get : TCMM_cemCfgSeqMode_Get;

	//****************************************************************************
	//*************** START OF HOME RETURN FUNCTION DECLARATIONS *****************
	//****************************************************************************
	cemHomeConfig_Set : TCMM_cemHomeConfig_Set;
	cemHomeConfig_Get : TCMM_cemHomeConfig_Get;
	cemHomePosClrMode_Set : TCMM_cemHomePosClrMode_Set;
	cemHomePosClrMode_Get : TCMM_cemHomePosClrMode_Get;
	cemHomeSpeedPattern_Set : TCMM_cemHomeSpeedPattern_Set;
	cemHomeSpeedPattern_Get : TCMM_cemHomeSpeedPattern_Get;
	cemHomeMove : TCMM_cemHomeMove;
	cemHomeMoveStart : TCMM_cemHomeMoveStart;
	cemHomeIsBusy : TCMM_cemHomeIsBusy;
	cemHomeWaitDone : TCMM_cemHomeWaitDone;

	//****************************************************************************
	//*************** START OF SINGLE AXIS CONTROL FUNCTION DECLARATIONS *********
	//****************************************************************************
	cemSxSpeedRatio_Set : TCMM_cemSxSpeedRatio_Set;
	cemSxSpeedRatio_Get : TCMM_cemSxSpeedRatio_Get;
	cemSxMove : TCMM_cemSxMove;
	cemSxMoveStart : TCMM_cemSxMoveStart;
	cemSxMoveTo : TCMM_cemSxMoveTo;
	cemSxMoveToStart : TCMM_cemSxMoveToStart;
	cemSxVMoveStart : TCMM_cemSxVMoveStart;
	cemSxStop : TCMM_cemSxStop;
	cemSxStopEmg : TCMM_cemSxStopEmg;
	cemSxIsDone : TCMM_cemSxIsDone;
	cemSxWaitDone : TCMM_cemSxWaitDone;
	cemSxTargetPos_Get : TCMM_cemSxTargetPos_Get;
	cemSxOptIniSpeed_Set : TCMM_cemSxOptIniSpeed_Set;
	cemSxOptIniSpeed_Get : TCMM_cemSxOptIniSpeed_Get;
	cemSxMoveStart2V : TCMM_cemSxMoveStart2V;
	cemSxMoveToStart2V : TCMM_cemSxMoveToStart2V;

	//****************************************************************************
	//*************** START OF MULTIPLE AXES CONTROL FUNCTION DECLARATIONS *******
	//****************************************************************************
	cemMxMove : TCMM_cemMxMove;
	cemMxMoveStart : TCMM_cemMxMoveStart;
	cemMxMoveTo : TCMM_cemMxMoveTo;
	cemMxMoveToStart : TCMM_cemMxMoveToStart;
	cemMxVMoveStart : TCMM_cemMxVMoveStart;
	cemMxStop : TCMM_cemMxStop;
	cemMxStopEmg : TCMM_cemMxStopEmg;
	cemMxIsDone : TCMM_cemMxIsDone;
	cemMxWaitDone : TCMM_cemMxWaitDone;

	//****************************************************************************
	//*************** START OF INTERPOLATION CONTROL FUNCTION DECLARATIONS *******
	//****************************************************************************
	cemIxMapAxes : TCMM_cemIxMapAxes;
	cemIxUnMap : TCMM_cemIxUnMap;
	cemIxSpeedPattern_Set : TCMM_cemIxSpeedPattern_Set;
	cemIxSpeedPattern_Get : TCMM_cemIxSpeedPattern_Get;
	cemIxLine : TCMM_cemIxLine;
	cemIxLineStart : TCMM_cemIxLineStart;
	cemIxLineTo : TCMM_cemIxLineTo;
	cemIxLineToStart : TCMM_cemIxLineToStart;
	cemIxArcA : TCMM_cemIxArcA; 
	cemIxArcAStart : TCMM_cemIxArcAStart;
	cemIxArcATo : TCMM_cemIxArcATo;
	cemIxArcAToStart : TCMM_cemIxArcAToStart;
	cemIxArcP : TCMM_cemIxArcP;
	cemIxArcPStart : TCMM_cemIxArcPStart;
	cemIxArcPTo : TCMM_cemIxArcPTo;
	cemIxArcPToStart : TCMM_cemIxArcPToStart;
	cemIxArc3P : TCMM_cemIxArc3P;
	cemIxArc3PStart : TCMM_cemIxArc3PStart;
	cemIxArc3PTo : TCMM_cemIxArc3PTo;
	cemIxArc3PToStart : TCMM_cemIxArc3PToStart;
	cemIxStop : TCMM_cemIxStop;
	cemIxStopEmg : TCMM_cemIxStopEmg;

	//****************************************************************************
	//*************** START OF MASTER/SLAVE CONTROL FUNCTION DECLARATIONS ********
	//****************************************************************************
	cemMsRegisterSlave : TCMM_cemMsRegisterSlave;
	cemMsUnregisterSlave : TCMM_cemMsUnregisterSlave;
	cemMsCheckSlaveState : TCMM_cemMsCheckSlaveState;
	cemMsMasterAxis_Get : TCMM_cemMsMasterAxis_Get;

	//****************************************************************************
	//*************** START OF Manual Pulsar FUNCTION SECTION ********************
	//****************************************************************************
	cemPlsrInMode_Set : TCMM_cemPlsrInMode_Set;
	cemPlsrInMode_Get : TCMM_cemPlsrInMode_Get;
	cemPlsrGain_Set : TCMM_cemPlsrGain_Set;
	cemPlsrGain_Get : TCMM_cemPlsrGain_Get;
	cemPlsrHomeMoveStart : TCMM_cemPlsrHomeMoveStart;
	cemPlsrMove : TCMM_cemPlsrMove;
	cemPlsrMoveStart : TCMM_cemPlsrMoveStart;
	cemPlsrMoveTo : TCMM_cemPlsrMoveTo;
	cemPlsrMoveToStart : TCMM_cemPlsrMoveToStart;
	cemPlsrVMoveStart : TCMM_cemPlsrVMoveStart;

	//****************************************************************************
	//*************** START OF OVERRIDE FUNCTION DECLARATIONS ********************
	//****************************************************************************
	cemOverrideSpeedSet : TCMM_cemOverrideSpeedSet;
	cemOverrideSpeedSetAll : TCMM_cemOverrideSpeedSetAll;
	cemOverrideMove : TCMM_cemOverrideMove;
	cemOverrideMoveTo : TCMM_cemOverrideMoveTo;

	//****************************************************************************
	//*************** START OF MONITORING FUNCTION DECLARATIONS ******************
	//****************************************************************************
	cemStCount_Set : TCMM_cemStCount_Set;
	cemStCount_Get : TCMM_cemStCount_Get;
	cemStPosition_Set : TCMM_cemStPosition_Set;
	cemStPosition_Get : TCMM_cemStPosition_Get;
	cemStSpeed_Get : TCMM_cemStSpeed_Get;
	cemStReadMotionState : TCMM_cemStReadMotionState;
	cemStReadMioStatuses : TCMM_cemStReadMioStatuses;
	cemStGetMstString : TCMM_cemStGetMstString;
	cemStReadIOMessageCount : TCMM_cemStReadIOMessageCount;

	//****************************************************************************
	//*************** START OF DIO CONFIGURATION FUNCTION DECLARATIONS ***********
	//****************************************************************************
	cedioMode_Set : TCMM_cedioMode_Set;
	cedioMode_Get : TCMM_cedioMode_Get;
	cedioModeMulti_Set : TCMM_cedioModeMulti_Set;
	cedioModeMulti_Get : TCMM_cedioModeMulti_Get;
	cedioLogicOne_Set : TCMM_cedioLogicOne_Set;
	cedioLogicOne_Get : TCMM_cedioLogicOne_Get;
	cedioLogicMulti_Set : TCMM_cedioLogicMulti_Set;
	cedioLogicMulti_Get : TCMM_cedioLogicMulti_Get;
	cedioOne_Get : TCMM_cedioOne_Get;
	cedioOne_Put : TCMM_cedioOne_Put;
	cedioMulti_Get : TCMM_cedioMulti_Get;
	cedioMulti_Put : TCMM_cedioMulti_Put;
	cedioOneF_Get : TCMM_cedioOneF_Get;
	cedioMultiF_Get : TCMM_cedioMultiF_Get;
	cedioPulseOne : TCMM_cedioPulseOne;
	cedioPulseMulti : TCMM_cedioPulseMulti;

	//****************************************************************************
	//*************** START OF DI CONTROL FUNCTION DECLARATIONS ******************
	//****************************************************************************
	cediLogicOne_Set : TCMM_cediLogicOne_Set;
	cediLogicOne_Get : TCMM_cediLogicOne_Get;
	cediLogicMulti_Set : TCMM_cediLogicMulti_Set;
	cediLogicMulti_Get : TCMM_cediLogicMulti_Get;
	cediOne_Get : TCMM_cediOne_Get;
	cediMulti_Get : TCMM_cediMulti_Get;
	cediOneF_Get : TCMM_cediOneF_Get;
	cediMultiF_Get : TCMM_cediMultiF_Get;

	//****************************************************************************
	//*************** START OF DO CONTROL FUNCTION DECLARATIONS ******************
	//****************************************************************************
	cedoLogicOne_Set : TCMM_cedoLogicOne_Set;
	cedoLogicOne_Get : TCMM_cedoLogicOne_Get;
	cedoLogicMulti_Set : TCMM_cedoLogicMulti_Set;
	cedoLogicMulti_Get : TCMM_cedoLogicMulti_Get;
	cedoOne_Put : TCMM_cedoOne_Put;
	cedoOne_Get : TCMM_cedoOne_Get;
	cedoMulti_Put : TCMM_cedoMulti_Put;
	cedoMulti_Get : TCMM_cedoMulti_Get;
	cedoPulseOne : TCMM_cedoPulseOne;
	cedoPulseMulti : TCMM_cedoPulseMulti;

	//****************************************************************************
	//*************** START OF UTILITY FUNCTION DECLARATIONS *********************
	//****************************************************************************
	ceutlUserData_Set : TCMM_ceutlUserData_Set;
	ceutlUserData_Get : TCMM_ceutlUserData_Get;
	ceutlUserVersion_Set : TCMM_ceutlUserVersion_Set;
	ceutlUserVersion_Get : TCMM_ceutlUserVersion_Get;
	ceutlNodeVersion_Get : TCMM_ceutlNodeVersion_Get;
	ceutlLibVersion_Get : TCMM_ceutlLibVersion_Get;
	ceutlSyncCount_Get : TCMM_ceutlSyncCount_Get;
	ceutlIOSyncCount_Get : TCMM_ceutlIOSyncCount_Get;

	// ****************************************************************************************************************************

	FDLLInstance : THandle;

procedure LoadDll;
procedure UnloadDll;

implementation

Const
LIBRARY_FILENAME : AnsiString = 'ceSDKDLL.dll';

procedure LoadDll;
var
	LibraryFilename : AnsiString;
	// FDLLPath : string;

begin
	LibraryFilename := LIBRARY_FILENAME;
	FDLLInstance := LoadLibrary(PChar(LibraryFileName));

	if ( FDLLInstance <> 0 ) then
	begin


		// List of function for General I/O *******************************************************************************************
		@ceGnLoad := GetProcAddress(FDLLInstance,'ceGnLoad');
		@ceGnUnload := GetProcAddress(FDLLInstance,'ceGnUnload');
		@ceGnDebugMode := GetProcAddress(FDLLInstance,'ceGnDebugMode');
		@ceGnReSearchDevice := GetProcAddress(FDLLInstance,'ceGnReSearchDevice');
		@ceGnIsSearchedDevice := GetProcAddress(FDLLInstance,'ceGnIsSearchedDevice');
		@ceGnSearchDevice := GetProcAddress(FDLLInstance,'ceGnSearchDevice');
		@ceGnUnSearchDevice := GetProcAddress(FDLLInstance,'ceGnUnSearchDevice');
		@ceGnTotalNode := GetProcAddress(FDLLInstance,'ceGnTotalNode');
		@ceGnTotalMotionChannel := GetProcAddress(FDLLInstance,'ceGnTotalMotionChannel');
		@ceGnTotalDIOChannel := GetProcAddress(FDLLInstance,'ceGnTotalDIOChannel');
		@ceGnTotalAIChannel := GetProcAddress(FDLLInstance,'ceGnTotalAIChannel');
		@ceGnTotalAOChannel := GetProcAddress(FDLLInstance,'ceGnTotalAOChannel');
		@ceGnModuleCount_Motion := GetProcAddress(FDLLInstance,'ceGnModuleCount_Motion');
		@ceGnModuleCount_Dio := GetProcAddress(FDLLInstance,'ceGnModuleCount_Dio');
		@ceGnModuleCount_Ai := GetProcAddress(FDLLInstance,'ceGnModuleCount_Ai');
		@ceGnModuleCount_Ao := GetProcAddress(FDLLInstance,'ceGnModuleCount_Ao');
		@ceGnChannelCount_Motion := GetProcAddress(FDLLInstance,'ceGnChannelCount_Motion');
		@ceGnChannelCount_Dio := GetProcAddress(FDLLInstance,'ceGnChannelCount_Dio');
		@ceGnChannelCount_Ai := GetProcAddress(FDLLInstance,'ceGnChannelCount_Ai');
		@ceGnChannelCount_Ao := GetProcAddress(FDLLInstance,'ceGnChannelCount_Ao');
		@ceGnEmergency_Set := GetProcAddress(FDLLInstance,'ceGnEmergency_Set');
		@ceGnEmergency_Get := GetProcAddress(FDLLInstance,'ceGnEmergency_Get');
		@ceGnResetNode := GetProcAddress(FDLLInstance,'ceGnResetNode');
		@ceGnCtrlBoost_Set := GetProcAddress(FDLLInstance,'ceGnCtrlBoost_Set');
		@ceGnCtrlBoost_Get := GetProcAddress(FDLLInstance,'ceGnCtrlBoost_Get');
		@ceGnNodeIsActive := GetProcAddress(FDLLInstance,'ceGnNodeIsActive');
		@ceGnBeginSerialize := GetProcAddress(FDLLInstance,'ceGnBeginSerialize');
		@ceGnEndSerialize := GetProcAddress(FDLLInstance,'ceGnEndSerialize');
		@ceGnLocalAxis_Get := GetProcAddress(FDLLInstance,'ceGnLocalAxis_Get');
		@ceGnLocalDIO_Get := GetProcAddress(FDLLInstance,'ceGnLocalDIO_Get');
		@ceGnLocalAI_Get := GetProcAddress(FDLLInstance,'ceGnLocalAI_Get');
		@ceGnLocalAO_Get := GetProcAddress(FDLLInstance,'ceGnLocalAO_Get');
		@ceGnGlobalAxis_Get := GetProcAddress(FDLLInstance,'ceGnGlobalAxis_Get');
		@ceGnGlobalDIO_Get := GetProcAddress(FDLLInstance,'ceGnGlobalDIO_Get');
		@ceGnGlobalAI_Get := GetProcAddress(FDLLInstance,'ceGnGlobalAI_Get');
		@ceGnGlobalAO_Get := GetProcAddress(FDLLInstance,'ceGnGlobalAO_Get');
					
		//****************************************************************************
		//*************** START OF GENERAL MOTION FUNCTION DECLARATIONS **************
		//****************************************************************************
	
		@cemGnServoOn_Set := GetProcAddress(FDLLInstance,'cemGnServoOn_Set');
		@cemGnServoOn_Get := GetProcAddress(FDLLInstance,'cemGnServoOn_Get');
		@cemGnAlarmReset := GetProcAddress(FDLLInstance,'cemGnAlarmReset');
	
		//****************************************************************************
		//*************** START OF CONFIGURATION FUNCTION DECLARATIONS ***************
		//****************************************************************************
	
		@cemCfgMioProperty_Set := GetProcAddress(FDLLInstance,'cemCfgMioProperty_Set');
		@cemCfgMioProperty_Get := GetProcAddress(FDLLInstance,'cemCfgMioProperty_Get');
		@cemCfgFilter_Set := GetProcAddress(FDLLInstance,'cemCfgFilter_Set');
		@cemCfgFilter_Get := GetProcAddress(FDLLInstance,'cemCfgFilter_Get');
		@cemCfgFilterAB_Set := GetProcAddress(FDLLInstance,'cemCfgFilterAB_Set');
		@cemCfgFilterAB_Get := GetProcAddress(FDLLInstance,'cemCfgFilterAB_Get');
		@cemCfgInMode_Set := GetProcAddress(FDLLInstance,'cemCfgInMode_Set');
		@cemCfgInMode_Get := GetProcAddress(FDLLInstance,'cemCfgInMode_Get');
		@cemCfgOutMode_Set := GetProcAddress(FDLLInstance,'cemCfgOutMode_Set');
		@cemCfgOutMode_Get := GetProcAddress(FDLLInstance,'cemCfgOutMode_Get');
		@cemCfgCtrlMode_Set := GetProcAddress(FDLLInstance,'cemCfgCtrlMode_Set');
		@cemCfgCtrlMode_Get := GetProcAddress(FDLLInstance,'cemCfgCtrlMode_Get');
		@cemCfgInOutRatio_Set := GetProcAddress(FDLLInstance,'cemCfgInOutRatio_Set');
		@cemCfgInOutRatio_Get := GetProcAddress(FDLLInstance,'cemCfgInOutRatio_Get');
		@cemCfgUnitDist_Set := GetProcAddress(FDLLInstance,'cemCfgUnitDist_Set');
		@cemCfgUnitDist_Get := GetProcAddress(FDLLInstance,'cemCfgUnitDist_Get');
		@cemCfgUnitSpeed_Set := GetProcAddress(FDLLInstance,'cemCfgUnitSpeed_Set');
		@cemCfgUnitSpeed_Get := GetProcAddress(FDLLInstance,'cemCfgUnitSpeed_Get');
		@cemCfgSpeedRange_Set := GetProcAddress(FDLLInstance,'cemCfgSpeedRange_Set');
		@cemCfgSpeedRange_Get := GetProcAddress(FDLLInstance,'cemCfgSpeedRange_Get');
		@cemCfgSpeedPattern_Set := GetProcAddress(FDLLInstance,'cemCfgSpeedPattern_Set');
		@cemCfgSpeedPattern_Get := GetProcAddress(FDLLInstance,'cemCfgSpeedPattern_Get');
		@cemCfgActSpdCheck_Set := GetProcAddress(FDLLInstance,'cemCfgActSpdCheck_Set');
		@cemCfgActSpdCheck_Get := GetProcAddress(FDLLInstance,'cemCfgActSpdCheck_Get');
		@cemCfgSoftLimit_Set := GetProcAddress(FDLLInstance,'cemCfgSoftLimit_Set');
		@cemCfgSoftLimit_Get := GetProcAddress(FDLLInstance,'cemCfgSoftLimit_Get');
		@cemCfgRingCntr_Set := GetProcAddress(FDLLInstance,'cemCfgRingCntr_Set');
		@cemCfgRingCntr_Get := GetProcAddress(FDLLInstance,'cemCfgRingCntr_Get');
		@cemCfgVelCorrRatio_Set := GetProcAddress(FDLLInstance,'cemCfgVelCorrRatio_Set');
		@cemCfgVelCorrRatio_Get := GetProcAddress(FDLLInstance,'cemCfgVelCorrRatio_Get');
		@cemCfgSeqMode_Set := GetProcAddress(FDLLInstance,'cemCfgSeqMode_Set');
		@cemCfgSeqMode_Get := GetProcAddress(FDLLInstance,'cemCfgSeqMode_Get');
	
		//****************************************************************************
		//*************** START OF HOME RETURN FUNCTION DECLARATIONS *****************
		//****************************************************************************
		@cemHomeConfig_Set := GetProcAddress(FDLLInstance,'cemHomeConfig_Set');
		@cemHomeConfig_Get := GetProcAddress(FDLLInstance,'cemHomeConfig_Get');
		@cemHomePosClrMode_Set := GetProcAddress(FDLLInstance,'cemHomePosClrMode_Set');
		@cemHomePosClrMode_Get := GetProcAddress(FDLLInstance,'cemHomePosClrMode_Get');
		@cemHomeSpeedPattern_Set := GetProcAddress(FDLLInstance,'cemHomeSpeedPattern_Set');
		@cemHomeSpeedPattern_Get := GetProcAddress(FDLLInstance,'cemHomeSpeedPattern_Get');
		@cemHomeMove := GetProcAddress(FDLLInstance,'cemHomeMove');
		@cemHomeMoveStart := GetProcAddress(FDLLInstance,'cemHomeMoveStart');
		@cemHomeIsBusy := GetProcAddress(FDLLInstance,'cemHomeIsBusy');
		@cemHomeWaitDone := GetProcAddress(FDLLInstance,'cemHomeWaitDone');
	
		//****************************************************************************
		//*************** START OF SINGLE AXIS CONTROL FUNCTION DECLARATIONS *********
		//****************************************************************************
		@cemSxSpeedRatio_Set := GetProcAddress(FDLLInstance,'cemSxSpeedRatio_Set');
		@cemSxSpeedRatio_Get := GetProcAddress(FDLLInstance,'cemSxSpeedRatio_Get');
		@cemSxMove := GetProcAddress(FDLLInstance,'cemSxMove');
		@cemSxMoveStart := GetProcAddress(FDLLInstance,'cemSxMoveStart');
		@cemSxMoveTo := GetProcAddress(FDLLInstance,'cemSxMoveTo');
		@cemSxMoveToStart := GetProcAddress(FDLLInstance,'cemSxMoveToStart');
		@cemSxVMoveStart := GetProcAddress(FDLLInstance,'cemSxVMoveStart');
		@cemSxStop := GetProcAddress(FDLLInstance,'cemSxStop');
		@cemSxStopEmg := GetProcAddress(FDLLInstance,'cemSxStopEmg');
		@cemSxIsDone := GetProcAddress(FDLLInstance,'cemSxIsDone');
		@cemSxWaitDone := GetProcAddress(FDLLInstance,'cemSxWaitDone');
		@cemSxTargetPos_Get := GetProcAddress(FDLLInstance,'cemSxTargetPos_Get');
		@cemSxOptIniSpeed_Set := GetProcAddress(FDLLInstance,'cemSxOptIniSpeed_Set');
		@cemSxOptIniSpeed_Get := GetProcAddress(FDLLInstance,'cemSxOptIniSpeed_Get');
		@cemSxMoveStart2V := GetProcAddress(FDLLInstance,'cemSxMoveStart2V');
		@cemSxMoveToStart2V := GetProcAddress(FDLLInstance,'cemSxMoveToStart2V');
	
		//****************************************************************************
		//*************** START OF MULTIPLE AXES CONTROL FUNCTION DECLARATIONS *******
		//****************************************************************************
		@cemMxMove := GetProcAddress(FDLLInstance,'cemMxMove');
		@cemMxMoveStart := GetProcAddress(FDLLInstance,'cemMxMoveStart');
		@cemMxMoveTo := GetProcAddress(FDLLInstance,'cemMxMoveTo');
		@cemMxMoveToStart := GetProcAddress(FDLLInstance,'cemMxMoveToStart');
		@cemMxVMoveStart := GetProcAddress(FDLLInstance,'cemMxVMoveStart');
		@cemMxStop := GetProcAddress(FDLLInstance,'cemMxStop');
		@cemMxStopEmg := GetProcAddress(FDLLInstance,'cemMxStopEmg');
		@cemMxIsDone := GetProcAddress(FDLLInstance,'cemMxIsDone');
		@cemMxWaitDone := GetProcAddress(FDLLInstance,'cemMxWaitDone');
	
		//****************************************************************************
		//*************** START OF INTERPOLATION CONTROL FUNCTION DECLARATIONS *******
		//****************************************************************************
		@cemIxMapAxes := GetProcAddress(FDLLInstance,'cemIxMapAxes');
		@cemIxUnMap := GetProcAddress(FDLLInstance,'cemIxUnMap');
		@cemIxSpeedPattern_Set := GetProcAddress(FDLLInstance,'cemIxSpeedPattern_Set');
		@cemIxSpeedPattern_Get := GetProcAddress(FDLLInstance,'cemIxSpeedPattern_Get');
		@cemIxLine := GetProcAddress(FDLLInstance,'cemIxLine');
		@cemIxLineStart := GetProcAddress(FDLLInstance,'cemIxLineStart');
		@cemIxLineTo := GetProcAddress(FDLLInstance,'cemIxLineTo');
		@cemIxLineToStart := GetProcAddress(FDLLInstance,'cemIxLineToStart');
		@cemIxArcA := GetProcAddress(FDLLInstance,'cemIxArcA'); 
		@cemIxArcAStart := GetProcAddress(FDLLInstance,'cemIxArcAStart');
		@cemIxArcATo := GetProcAddress(FDLLInstance,'cemIxArcATo');
		@cemIxArcAToStart := GetProcAddress(FDLLInstance,'cemIxArcAToStart');
		@cemIxArcP := GetProcAddress(FDLLInstance,'cemIxArcP');
		@cemIxArcPStart := GetProcAddress(FDLLInstance,'cemIxArcPStart');
		@cemIxArcPTo := GetProcAddress(FDLLInstance,'cemIxArcPTo');
		@cemIxArcPToStart := GetProcAddress(FDLLInstance,'cemIxArcPToStart');
		@cemIxArc3P := GetProcAddress(FDLLInstance,'cemIxArc3P');
		@cemIxArc3PStart := GetProcAddress(FDLLInstance,'cemIxArc3PStart');
		@cemIxArc3PTo := GetProcAddress(FDLLInstance,'cemIxArc3PTo');
		@cemIxArc3PToStart := GetProcAddress(FDLLInstance,'cemIxArc3PToStart');
		@cemIxStop := GetProcAddress(FDLLInstance,'cemIxStop');
		@cemIxStopEmg := GetProcAddress(FDLLInstance,'cemIxStopEmg');
	
		//****************************************************************************
		//*************** START OF MASTER/SLAVE CONTROL FUNCTION DECLARATIONS ********
		//****************************************************************************
		@cemMsRegisterSlave := GetProcAddress(FDLLInstance,'cemMsRegisterSlave');
		@cemMsUnregisterSlave := GetProcAddress(FDLLInstance,'cemMsUnregisterSlave');
		@cemMsCheckSlaveState := GetProcAddress(FDLLInstance,'cemMsCheckSlaveState');
		@cemMsMasterAxis_Get := GetProcAddress(FDLLInstance,'cemMsMasterAxis_Get');
	
		//****************************************************************************
		//*************** START OF Manual Pulsar FUNCTION SECTION ********************
		//****************************************************************************
		@cemPlsrInMode_Set := GetProcAddress(FDLLInstance,'cemPlsrInMode_Set');
		@cemPlsrInMode_Get := GetProcAddress(FDLLInstance,'cemPlsrInMode_Get');
		@cemPlsrGain_Set := GetProcAddress(FDLLInstance,'cemPlsrGain_Set');
		@cemPlsrGain_Get := GetProcAddress(FDLLInstance,'cemPlsrGain_Get');
		@cemPlsrHomeMoveStart := GetProcAddress(FDLLInstance,'cemPlsrHomeMoveStart');
		@cemPlsrMove := GetProcAddress(FDLLInstance,'cemPlsrMove');
		@cemPlsrMoveStart := GetProcAddress(FDLLInstance,'cemPlsrMoveStart');
		@cemPlsrMoveTo := GetProcAddress(FDLLInstance,'cemPlsrMoveTo');
		@cemPlsrMoveToStart := GetProcAddress(FDLLInstance,'cemPlsrMoveToStart');
		@cemPlsrVMoveStart := GetProcAddress(FDLLInstance,'cemPlsrVMoveStart');
	
		//****************************************************************************
		//*************** START OF OVERRIDE FUNCTION DECLARATIONS ********************
		//****************************************************************************
		@cemOverrideSpeedSet := GetProcAddress(FDLLInstance,'cemOverrideSpeedSet');
		@cemOverrideSpeedSetAll := GetProcAddress(FDLLInstance,'cemOverrideSpeedSetAll');
		@cemOverrideMove := GetProcAddress(FDLLInstance,'cemOverrideMove');
		@cemOverrideMoveTo := GetProcAddress(FDLLInstance,'cemOverrideMoveTo');
	
		//****************************************************************************
		//*************** START OF MONITORING FUNCTION DECLARATIONS ******************
		//****************************************************************************
		@cemStCount_Set := GetProcAddress(FDLLInstance,'cemStCount_Set');
		@cemStCount_Get := GetProcAddress(FDLLInstance,'cemStCount_Get');
		@cemStPosition_Set := GetProcAddress(FDLLInstance,'cemStPosition_Set');
		@cemStPosition_Get := GetProcAddress(FDLLInstance,'cemStPosition_Get');
		@cemStSpeed_Get := GetProcAddress(FDLLInstance,'cemStSpeed_Get');
		@cemStReadMotionState := GetProcAddress(FDLLInstance,'cemStReadMotionState');
		@cemStReadMioStatuses := GetProcAddress(FDLLInstance,'cemStReadMioStatuses');
		@cemStGetMstString := GetProcAddress(FDLLInstance,'cemStGetMstString');
		@cemStReadIOMessageCount := GetProcAddress(FDLLInstance,'cemStReadIOMessageCount');
	
		//****************************************************************************
		//*************** START OF DIO CONFIGURATION FUNCTION DECLARATIONS ***********
		//****************************************************************************
		@cedioMode_Set := GetProcAddress(FDLLInstance,'cedioMode_Set');
		@cedioMode_Get := GetProcAddress(FDLLInstance,'cedioMode_Get');
		@cedioModeMulti_Set := GetProcAddress(FDLLInstance,'cedioModeMulti_Set');
		@cedioModeMulti_Get := GetProcAddress(FDLLInstance,'cedioModeMulti_Get');
		@cedioLogicOne_Set := GetProcAddress(FDLLInstance,'cedioLogicOne_Set');
		@cedioLogicOne_Get := GetProcAddress(FDLLInstance,'cedioLogicOne_Get');
		@cedioLogicMulti_Set := GetProcAddress(FDLLInstance,'cedioLogicMulti_Set');
		@cedioLogicMulti_Get := GetProcAddress(FDLLInstance,'cedioLogicMulti_Get');
		@cedioOne_Get := GetProcAddress(FDLLInstance,'cedioOne_Get');
		@cedioOne_Put := GetProcAddress(FDLLInstance,'cedioOne_Put');
		@cedioMulti_Get := GetProcAddress(FDLLInstance,'cedioMulti_Get');
		@cedioMulti_Put := GetProcAddress(FDLLInstance,'cedioMulti_Put');
		@cedioOneF_Get := GetProcAddress(FDLLInstance,'cedioOneF_Get');
		@cedioMultiF_Get := GetProcAddress(FDLLInstance,'cedioMultiF_Get');
		@cedioPulseOne := GetProcAddress(FDLLInstance,'cedioPulseOne');
		@cedioPulseMulti := GetProcAddress(FDLLInstance,'cedioPulseMulti');
	
		//****************************************************************************
		//*************** START OF DI CONTROL FUNCTION DECLARATIONS ******************
		//****************************************************************************
		@cediLogicOne_Set := GetProcAddress(FDLLInstance,'cediLogicOne_Set');
		@cediLogicOne_Get := GetProcAddress(FDLLInstance,'cediLogicOne_Get');
		@cediLogicMulti_Set := GetProcAddress(FDLLInstance,'cediLogicMulti_Set');
		@cediLogicMulti_Get := GetProcAddress(FDLLInstance,'cediLogicMulti_Get');
		@cediOne_Get := GetProcAddress(FDLLInstance,'cediOne_Get');
		@cediMulti_Get := GetProcAddress(FDLLInstance,'cediMulti_Get');
		@cediOneF_Get := GetProcAddress(FDLLInstance,'cediOneF_Get');
		@cediMultiF_Get := GetProcAddress(FDLLInstance,'cediMultiF_Get');
	
		//****************************************************************************
		//*************** START OF DO CONTROL FUNCTION DECLARATIONS ******************
		//****************************************************************************
		@cedoLogicOne_Set := GetProcAddress(FDLLInstance,'cedoLogicOne_Set');
		@cedoLogicOne_Get := GetProcAddress(FDLLInstance,'cedoLogicOne_Get');
		@cedoLogicMulti_Set := GetProcAddress(FDLLInstance,'cedoLogicMulti_Set');
		@cedoLogicMulti_Get := GetProcAddress(FDLLInstance,'cedoLogicMulti_Get');
		@cedoOne_Put := GetProcAddress(FDLLInstance,'cedoOne_Put');
		@cedoOne_Get := GetProcAddress(FDLLInstance,'cedoOne_Get');
		@cedoMulti_Put := GetProcAddress(FDLLInstance,'cedoMulti_Put');
		@cedoMulti_Get := GetProcAddress(FDLLInstance,'cedoMulti_Get');
		@cedoPulseOne := GetProcAddress(FDLLInstance,'cedoPulseOne');
		@cedoPulseMulti := GetProcAddress(FDLLInstance,'cedoPulseMulti');
	
		//****************************************************************************
		//*************** START OF UTILITY FUNCTION DECLARATIONS *********************
		//****************************************************************************
		@ceutlUserData_Set := GetProcAddress(FDLLInstance,'ceutlUserData_Set');
		@ceutlUserData_Get := GetProcAddress(FDLLInstance,'ceutlUserData_Get');
		@ceutlUserVersion_Set := GetProcAddress(FDLLInstance,'ceutlUserVersion_Set');
		@ceutlUserVersion_Get := GetProcAddress(FDLLInstance,'ceutlUserVersion_Get');
		@ceutlNodeVersion_Get := GetProcAddress(FDLLInstance,'ceutlNodeVersion_Get');
		@ceutlLibVersion_Get := GetProcAddress(FDLLInstance,'ceutlLibVersion_Get');
		@ceutlSyncCount_Get := GetProcAddress(FDLLInstance,'ceutlSyncCount_Get');
		@ceutlIOSyncCount_Get := GetProcAddress(FDLLInstance,'ceutlIOSyncCount_Get');

	end
end;

procedure UnloadDll;
begin
	if not FreeLibrary(FDLLInstance) then exit;
end;

Initialization

begin
	LoadDll;

end;

Finalization
	UnloadDll;
end.
