unit ceip_delpi;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ceSDK, ExtCtrls, Math, StrUtils;


type
  TForm1 = class(TForm)
    BT_Init: TButton;
    Label1: TLabel;
    Control_Axis: TComboBox;
    GroupBox2: TGroupBox;
    CMD_Spd: TLabel;
    Current_State: TLabel;
    FB_Pos: TLabel;
    FB_Spd: TLabel;
    LB_MotState: TLabel;
    LB_CMD_Spd: TLabel;
    LB_CMD_Pos: TLabel;
    LB_FB_Pos: TLabel;
    LB_FB_Spd: TLabel;
    GroupBox1: TGroupBox;
    BT_SERVO_ONOFF: TButton;
    BT_ResetPos: TButton;
    BT_ResetAlarm: TButton;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    Alarm: TLabel;
    CB_AlarmLogic: TComboBox;
    Alarm_stopmode: TLabel;
    CB_AlarmStop: TComboBox;
    Limit_Stopmode: TLabel;
    CB_EL_Stop: TComboBox;
    EL: TLabel;
    CB_EL_Logic: TComboBox;
    ORG_Logic: TLabel;
    CB_ORGLogic: TComboBox;
    Servo_input: TLabel;
    CB_ServoInputLogic: TComboBox;
    Encoder_Feedback: TLabel;
    CB_EncoderFeedback: TComboBox;
    Command_Pulse_Mode: TLabel;
    CB_CommandPulseMode: TComboBox;
    BT_Apply_Logic: TButton;
    GroupBox5: TGroupBox;
    BT_Apply_Speed: TButton;
    WorkSpeed: TLabel;
    TB_SxWorkSpeed: TEdit;
    Accel: TLabel;
    SpeedMode: TLabel;
    CB_SxSpeedMode: TComboBox;
    TB_SxAccel: TEdit;
    InitSpeed: TLabel;
    TB_InitSpeed: TEdit;
    Decel: TLabel;
    TB_Decel: TEdit;
    GroupBox6: TGroupBox;
    RB_VelocityMode: TRadioButton;
    RB_AbsoluteMode: TRadioButton;
    Position1: TLabel;
    TB_AbsolutePos1: TEdit;
    Position2: TLabel;
    TB_AbsolutePos2: TEdit;
    RB_RelativeMode: TRadioButton;
    RM_Position: TLabel;
    TB_RelativePos: TEdit;
    BT_SxMove_N: TButton;
    BT_SxMove_P: TButton;
    BT_SxStop: TButton;
    BT_SxEMGStop: TButton;
    GroupBox7: TGroupBox;
    LB_HomeMode: TLabel;
    CB_HomeMode: TComboBox;
    LB_SpeedMode: TLabel;
    CB_HomeSpeedMode: TComboBox;
    LB_WorkSpeed: TLabel;
    TB_HomeSpeed: TEdit;
    LB_Accel: TLabel;
    TB_HomeAccel: TEdit;
    LB_Decel: TLabel;
    TB_HomeDecel: TEdit;
    LB_EZCount: TLabel;
    TB_HomeEzCount: TEdit;
    LB_Offset: TLabel;
    TB_HomeOffset: TEdit;
    LB_ReverseVel: TLabel;
    TB_HomeReverseVel: TEdit;
    LB_EscapeDist: TLabel;
    TB_HomeEscapeDist: TEdit;
    LB_Direction: TLabel;
    CB_HomeDir: TComboBox;
    BT_Apply_Home: TButton;
    BT_HomeMove: TButton;
    BT_SxStop2: TButton;
    BT_SxEMGStop2: TButton;
    GroupBox8: TGroupBox;
    Button15: TButton;
    Button16: TButton;
    CB_DIO1: TCheckBox;
    CB_DIO2: TCheckBox;
    CB_DIO3: TCheckBox;
    CB_DIO4: TCheckBox;
    CB_DIO5: TCheckBox;
    CB_DIO6: TCheckBox;
    CB_DIO7: TCheckBox;
    CB_DIO8: TCheckBox;
    CB_DIO9: TCheckBox;
    CB_DIO10: TCheckBox;
    CB_DIO11: TCheckBox;
    CB_DIO12: TCheckBox;
    CB_DIO13: TCheckBox;
    CB_DIO14: TCheckBox;
    CB_DIO15: TCheckBox;
    CB_DIO0: TCheckBox;
    Timer1: TTimer;
    ALM: TLabel;
    EL_minus: TLabel;
    EL_plus: TLabel;
    ORG: TLabel;
    INP: TLabel;
    RDY: TLabel;
    LIC: TLabel;
    SD: TLabel;
    PC_ALM: TCheckBox;
    PC_NEL: TCheckBox;
    PC_PEL: TCheckBox;
    PC_ORG: TCheckBox;
    PC_INP: TCheckBox;
    PC_RDY: TCheckBox;
    PC_LTC: TCheckBox;
    PC_SD: TCheckBox;
    CMD_Pos: TLabel;
    Button1: TButton;
    Button2: TButton;
    procedure BT_InitClick(Sender: TObject);
    procedure BT_SERVO_ONOFFClick(Sender: TObject);
    procedure Control_AxisChange(Sender: TObject);
    procedure BT_Apply_LogicClick(Sender: TObject);
    procedure BT_Apply_SpeedClick(Sender: TObject);
    procedure BT_SxMove_NClick(Sender: TObject);
    procedure BT_SxMove_PClick(Sender: TObject);
    procedure BT_SxStopClick(Sender: TObject);
    procedure BT_SxEMGStopClick(Sender: TObject);
    procedure BT_Apply_HomeClick(Sender: TObject);
    procedure BT_HomeMoveClick(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure GUI_SetControlAxisInfo();
    procedure GUI_Refresh_ServoOnOff();
    procedure GUI_Refresh_Position();
    procedure GUI_Refresh_MotState();
    procedure GUI_Refresh_Logic();
    procedure GUI_Refresh_All();
    procedure GUI_Refresh_MIOState();
    procedure GUI_Refresh_Dio();
    procedure GUI_Refresh_SxSpeedSetup();
    procedure CTRL_Pos_Reset();
    procedure GUI_Refresh_HomeSetup();
    procedure CTRL_Toggle_ServoOn();
    procedure CTRL_Alarm_Reset();
    procedure CTRL_Apply_MIOLogic();
    procedure CTRL_Apply_SxSetup();
    procedure CTRL_VMove(dir : LongInt);
    procedure CTRL_Relative_Move(dir : LongInt);
    procedure CTRL_Absolute_Move(dir : LongInt);
    procedure CTRL_Stop();
    procedure CTRL_EMGStop();
    procedure CTRL_Apply_HomeSetup();
    procedure CTRL_Homming();
    procedure Button16Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure BT_ResetPosClick(Sender: TObject);
    procedure BT_ResetAlarmClick(Sender: TObject);
    procedure BT_SxStop2Click(Sender: TObject);
    procedure BT_SxEMGStop2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{Init}

procedure Init_cEIP();
begin
	ceGnLoad();
end;

function Init_cEIPConnectionCheck(): bool;
var
  EXPECTED_NODECOUNT : longint;
  TIMEOUT : longint;
  nIsSearchedDev : longint;
  nNumNodes : longint;
  is_OK : bool;
  errorcode : LongInt;

begin
  EXPECTED_NODECOUNT := 10;
	TIMEOUT := EXPECTED_NODECOUNT * 100;

	nIsSearchedDev := 0;
  ceGnIsSearchedDevice(@nIsSearchedDev);

	if (nIsSearchedDev = CE_FALSE) then
	begin
		errorcode := ceGnSearchDevice(EXPECTED_NODECOUNT, TIMEOUT, 0, @nNumNodes);
     //带 ˻մϴ.
	end
	else
	begin
	 	errorcode :=	ceGnReSearchDevice(EXPECTED_NODECOUNT, TIMEOUT, 0, @nNumNodes); //带 ˻մϴ.
	end;

	is_OK :=  (nNumNodes > 0) and True and not False;
	Result := is_OK;

end;


procedure TForm1.GUI_SetControlAxisInfo();
var
  NumAxes : LongInt;
  Axis_Name : string;
  i : LongInt;
begin
  NumAxes := 0;
  ceGnTotalMotionChannel(@NumAxes);

	for i := 0 to NumAxes - 1 do
  begin
    Axis_Name := 'Axis ' + IntToStr(i);
		Control_Axis.Items.add(Axis_Name);
	end;
	Control_Axis.Itemindex := 0;
end;


procedure TForm1.GUI_Refresh_ServoOnOff();
var
  Current_Axis : LongInt;
  IsServoOn : LongInt;                                                                              

begin
	Current_Axis := Control_Axis.ItemIndex;
	IsServoOn := 0;
	cemGnServoOn_Get(Current_Axis, @IsServoOn);

//	BT_SERVO_ONOFF.SetWindowTextA(IsServoOn == CE_TRUE ? "Servo On/Off (ON)" : "Servo On/Off (OFF)");

    BT_SERVO_ONOFF.caption := ifthen(IsServoOn = CE_TRUE , 'Servo On/Off (ON)', 'Servo On/Off (OFF)');
end;

procedure TForm1.GUI_Refresh_Position();
var
  cmdPos : Double;
  fdbPos : Double;
  cmdSpd : Double;
  fdbspd : Double;
  Current_Axis : LongInt;
  temp : string;

begin
	Current_Axis := Control_Axis.ItemIndex;
	cmdPos := 0;
	fdbPos := 0;
	cmdSpd := 0;
	fdbSpd := 0;

	cemStPosition_Get(Current_Axis, cemCNT_COMM, @cmdPos);
	cemStPosition_Get(Current_Axis, cemCNT_FEED, @fdbPos);
	cemStSpeed_Get(Current_Axis, cemCNT_COMM, @cmdSpd);
	cemStSpeed_Get(Current_Axis, cemCNT_FEED, @fdbSpd);


	temp := FloatTostr(cmdPos);
  LB_CMD_Pos.Caption := temp;
	temp := FloatToStr(fdbPos);
  LB_FB_Pos.Caption := temp;
	temp := FloatToStr(cmdSpd);
  LB_CMD_Spd.Caption := temp;
	temp := FloatToStr(fdbSpd);
	LB_FB_Spd.Caption := temp;
end;

procedure TForm1.GUI_Refresh_MotState();
var
  Current_Axis : LongInt;
  status : LongInt;
  temp : string;
begin
	Current_Axis := Control_Axis.ItemIndex;
	status := 0;

	cemStReadMotionState(Current_Axis, @status);

	case (status) of
  cemMST_STOP:
  begin
		LB_MotState.Caption := 'Stop';
		end;
	cemMST_WAIT_DR:
  begin
		LB_MotState.Caption := 'WaitDR';
		end;

	cemMST_WAIT_STA:
  begin
		LB_MotState.Caption := 'WaitSTA';
		end;
	cemMST_WAIT_INSYNC:
  begin
		LB_MotState.Caption := 'WaitINSYNC';
		end;
	cemMST_WAIT_OTHER:
  begin
		LB_MotState.Caption := 'WaitOTHER';
		end;
  cemMST_WAIT_ERC:
  begin
		LB_MotState.Caption := 'WaitERC';
		end;
	cemMST_WAIT_DIR:
  begin
		LB_MotState.Caption := 'WaitDIR';
		end;
	cemMST_WAIT_PLSR:
  begin
		LB_MotState.Caption := 'WaitPLSR';
		end;
	cemMST_IN_RVSSPD:
  begin
		LB_MotState.Caption := 'WaitRVSSPD';
		end;
	cemMST_IN_INISPD:
  begin
		LB_MotState.Caption := 'IniSpeed';
		end;
	cemMST_IN_ACC:
  begin
		LB_MotState.Caption := 'InAcceleration';
		end;
	cemMST_IN_WORKSPD:
  begin
		LB_MotState.Caption := 'InWorkspeed';
		end;
	cemMST_IN_DEC:
  begin
		LB_MotState.Caption := 'InDeceleration';
		end;
	cemMST_WAIT_INP:
    begin
		LB_MotState.Caption := 'WaitINP';
		end;
	else
  begin
		temp := Inttostr(status);
		LB_MotState.Caption := temp;
		end;
	end;
end;

procedure TForm1.GUI_Refresh_Logic();
var
  Current_Axis : LongInt;
	ALM_Logic : LongInt;
	ALM_Mode : LongInt;
	EL_Logic : LongInt;
	EL_Mode : LongInt;
	ORG_Logic : LongInt;
	ServoOn_Logic : LongInt;
	Encoder_Fdb : LongInt;
	Cmd_Pls_Mode : LongInt;
	is_reverse : LongInt;
begin
	Current_Axis := Control_Axis.ItemIndex;
	ALM_Logic := 0;
	ALM_Mode := 0;
	EL_Logic := 0;
	EL_Mode := 0;
	ORG_Logic := 0;
	ServoOn_Logic := 0;
	Encoder_Fdb := 0;
	Cmd_Pls_Mode := 0;
	is_reverse := 0;

	cemCfgMioProperty_Get(Current_Axis, cemMPID_ALM_LOGIC, @ALM_Logic);
	cemCfgMioProperty_Get(Current_Axis, cemMPID_ALM_MODE, @ALM_Mode);
	cemCfgMioProperty_Get(Current_Axis, cemMPID_EL_LOGIC, @EL_Logic);
	cemCfgMioProperty_Get(Current_Axis, cemMPID_EL_MODE, @EL_Mode);
	cemCfgMioProperty_Get(Current_Axis, cemMPID_ORG_LOGIC, @ORG_Logic);
	cemCfgMioProperty_Get(Current_Axis, cemMPID_SVON_LOGIC, @ServoOn_Logic);
	cemCfgInMode_Get(Current_Axis, @Encoder_Fdb, @is_reverse);
	cemCfgOutMode_Get(Current_Axis, @Cmd_Pls_Mode);


	CB_AlarmLogic.ItemIndex := ALM_Logic;
	CB_AlarmStop.ItemIndex := ALM_Mode;
	CB_EL_Logic.ItemIndex := EL_Logic;
	CB_EL_Stop.ItemIndex := EL_Mode;
	CB_ORGLogic.ItemIndex := ORG_Logic;
	CB_ServoInputLogic.ItemIndex := ServoOn_Logic;
	CB_EncoderFeedback.ItemIndex := Encoder_Fdb;
	CB_CommandPulseMode.ItemIndex := Cmd_Pls_Mode;

end;

{control reset alarm}

procedure TForm1.GUI_Refresh_MIOState();
var
  Current_Axis: LongInt;
  status : LongInt;
begin
	Current_Axis := Control_Axis.ItemIndex;
	status := 0;

	cemStReadMioStatuses(Current_Axis, @status);
  PC_ALM.Checked := ((status shr cemIOST_ALM) and $1) <> 0; // ALM
  PC_NEL.Checked := ((status shr cemIOST_ELN) and $1) <> 0; // +EL
  PC_PEL.Checked := ((status shr cemIOST_ELP) and $1) <> 0; // -EL
  PC_ORG.Checked := ((status shr cemIOST_ORG) and $1) <> 0; // ORG
  PC_RDY.Checked := ((status shr cemIOST_RDY) and $1) <> 0; // INF
  PC_RDY.Checked := ((status shr cemIOST_RDY) and $1) <> 0; // RDY
	PC_LTC.Checked := ((status shr cemIOST_LTC) and $1) <> 0; // LTC
	PC_SD.Checked := ((status shr cemIOST_SD) and $1) <> 0; //SD

end;


procedure TForm1.GUI_Refresh_SxSpeedSetup();
var
  Current_Axis : LongInt;
	SpeedMode : LongInt;
	WorkSpeed : double;
	Accel : double;
	Decel : double;
	InitSpeed : double;
  temp : string;

begin
	Current_Axis := Control_Axis.ItemIndex;
	SpeedMode := 0;
	WorkSpeed := 0;
	Accel := 0;
	Decel := 0;
	InitSpeed := 0;
	cemCfgSpeedPattern_Get(Current_Axis, @SpeedMode, @WorkSpeed, @Accel, @Decel);
	cemSxOptIniSpeed_Get(Current_Axis, @InitSpeed);

	CB_SxSpeedMode.ItemIndex := SpeedMode;

  temp := FloatToStr(WorkSpeed);
  TB_SxWorkSpeed.Text := temp;
  temp := FloatToStr(Accel);
  TB_SxAccel.Text := temp;
  temp := FloatToStr(Decel);
  TB_Decel.Text := temp;
  temp := FloatToStr(InitSpeed);
  TB_InitSpeed.Text := temp;

end;

procedure TForm1.GUI_Refresh_HomeSetup();
var
  Current_Axis : LongInt;
	SpeedMode : LongInt;
	HomeMode : LongInt;
	WorkSpeed : LongInt;
	Accel : double;
	Decel : double;
	EZCount : LongInt;
	Offset : double;
	ReverseVel : double;
	EscapeDist : double;
	Home_Dir : LongInt;
  temp : string ;
begin
	Current_Axis := Control_Axis.ItemIndex;
	SpeedMode := 0;
	HomeMode := 0;
	WorkSpeed := 0;
	Accel := 0;
	Decel := 0;
	EZCount := 0;
	Offset := 0;
	ReverseVel := 0;
	EscapeDist := 0;
	Home_Dir := 0;

	cemHomeConfig_Get(Current_Axis, @HomeMode, @Home_Dir, @EZCount, @EscapeDist, @Offset);
	cemHomeSpeedPattern_Get(Current_Axis, @SpeedMode, @WorkSpeed, @Accel, @Decel, @ReverseVel);


  temp := FloatToStr(EZCount);
  TB_HomeEzCount.Text := temp;
  temp := FloatToStr( EscapeDist);
  TB_HomeEscapeDist.Text := temp;
  temp := FloatToStr(Offset);
  TB_HomeOffset.Text := temp;
  temp := FloatToStr(WorkSpeed);
  TB_HomeSpeed.Text := temp;
  temp := FloatToStr(Accel);
  TB_HomeAccel.Text := temp;
  temp := FloatToStr(Decel);
  TB_HomeDecel.Text := temp;
  temp := FloatToStr(ReverseVel);
  TB_HomeReverseVel.Text := temp;


	CB_HomeDir.ItemIndex := Home_Dir;
	CB_HomeMode.ItemIndex := WorkSpeed;
	CB_HomeSpeedMode.ItemIndex := SpeedMode;
end;

{Control Axis}
procedure TForm1.GUI_Refresh_All();
begin
	GUI_Refresh_ServoOnOff();
	GUI_Refresh_Position();
	GUI_Refresh_MotState();
	GUI_Refresh_MIOState();
	GUI_Refresh_Logic();
	GUI_Refresh_SxSpeedSetup();
	GUI_Refresh_HomeSetup();
end;


{control reset position}
procedure TForm1.CTRL_Pos_Reset();
var
  Current_Axis : LongInt;
begin

	Current_Axis := Control_Axis.ItemIndex;

	cemStPosition_Set(Current_Axis, cemCNT_COMM, 0.0);
	cemStPosition_Set(Current_Axis, cemCNT_FEED, 0.0);
end;


procedure TForm1.CTRL_Toggle_ServoOn();
var
  Current_Axis: LongInt;
  IsServoOn: LongInt;
begin
	Current_Axis := Control_Axis.ItemIndex;
	IsServoOn := 0;

	cemGnServoOn_Get(Current_Axis, @IsServoOn);

	cemGnServoOn_Set(Current_Axis, ifthen(IsServoOn=1, CE_FALSE, CE_TRUE));



end;

procedure TForm1.CTRL_Alarm_Reset();
var
  Current_Axis : LongInt;
  Signal_Duration : LongInt;

begin
	Current_Axis := Control_Axis.ItemIndex;
	Signal_Duration := 10;

	cemGnAlarmReset(Current_Axis, 1);
	Sleep(Signal_Duration);
	cemGnAlarmReset(Current_Axis, 0);

end;



procedure TForm1.BT_InitClick(Sender: TObject);
begin

	ceGnLoad();

	if (Init_cEIPConnectionCheck()) then
  begin
		GUI_SetControlAxisInfo();
		GUI_Refresh_All();

  Timer1.Enabled := True;
	end;

end;


procedure TForm1.BT_SERVO_ONOFFClick(Sender: TObject);
begin
  CTRL_Toggle_ServoOn();
	GUI_Refresh_ServoOnOff();
end;

procedure TForm1.Control_AxisChange(Sender: TObject);
begin
    
end;

{logic input/output setup}
procedure TForm1.CTRL_Apply_MIOLogic();
var
  Current_Axis : LongInt;
	ALM_Logic : LongInt;
	ALM_Mode : LongInt;
	EL_Logic : LongInt;
	EL_Mode : LongInt;
	ORG_Logic : LongInt;
	ServoOn_Logic : LongInt;
	Encoder_Fdb : LongInt;
	Cmd_Pls_Mode : LongInt;
	is_reverse : LongInt; //Reverse Option   
begin
	Current_Axis := Control_Axis.ItemIndex;
	ALM_Logic := 0;
	ALM_Mode := 0;
	EL_Logic := 0;
	EL_Mode := 0;
	ORG_Logic := 0;
	ServoOn_Logic := 0;
	Encoder_Fdb := 0;
	Cmd_Pls_Mode := 0;
	is_reverse := 0;//Reverse Option   

	ALM_Logic := CB_AlarmLogic.ItemIndex;
	ALM_Mode := CB_AlarmLogic.ItemIndex;
	EL_Logic := CB_EL_Logic.ItemIndex;
	EL_Mode := CB_EL_Stop.ItemIndex;
	ORG_Logic := CB_ORGLogic.ItemIndex;
	ServoOn_Logic := CB_ServoInputLogic.ItemIndex;
	Encoder_Fdb := CB_EncoderFeedback.ItemIndex;
	Cmd_Pls_Mode := CB_CommandPulseMode.ItemIndex;

	cemCfgMioProperty_Set(Current_Axis, cemMPID_ALM_LOGIC, ALM_Logic);
	cemCfgMioProperty_Set(Current_Axis, cemMPID_ALM_MODE, ALM_Mode);
	cemCfgMioProperty_Set(Current_Axis, cemMPID_EL_LOGIC, EL_Logic);
	cemCfgMioProperty_Set(Current_Axis, cemMPID_EL_MODE, EL_Mode);
	cemCfgMioProperty_Set(Current_Axis, cemMPID_ORG_LOGIC, ORG_Logic);
	cemCfgMioProperty_Set(Current_Axis, cemMPID_SVON_LOGIC, ServoOn_Logic);
	cemCfgInMode_Set(Current_Axis, Encoder_Fdb, is_reverse);
	cemCfgOutMode_Set(Current_Axis, Cmd_Pls_Mode);
end;

procedure TForm1.BT_Apply_LogicClick(Sender: TObject);
begin
   CTRL_Apply_MIOLogic();
end;

procedure TForm1.CTRL_Apply_SxSetup();
var
  Current_Axis : LongInt;
	SpeedMode : LongInt;
	WorkSpeed : LongInt;
	Accel : double;
	Decel : double;
	InitSpeed : double;
  temp : string;

begin
	Current_Axis := Control_Axis.ItemIndex;
	SpeedMode := 0;
	WorkSpeed := 0;
	Accel := 0;
	Decel := 0;
	InitSpeed := 0;

	SpeedMode := CB_SxSpeedMode.ItemIndex;


  temp := TB_SxWorkSpeed.Text;
	WorkSpeed := strtoInt(temp);
  temp := TB_SxAccel.Text;
	Accel := strtoInt(temp);
  temp := TB_Decel.Text;
	Decel := strtoInt(temp);
  temp := TB_InitSpeed.Text;
	InitSpeed := strtoInt(temp);

	cemCfgSpeedPattern_Set(Current_Axis, SpeedMode, WorkSpeed, Accel, Decel);
	cemSxOptIniSpeed_Set(Current_Axis, InitSpeed);
end;

{speed setup apply}
procedure TForm1.BT_Apply_SpeedClick(Sender: TObject);
begin
	CTRL_Apply_SxSetup();
end;

{Single Axis Move (+) }

procedure TForm1.CTRL_Relative_Move(dir : LongInt);
var
  Current_Axis : LongInt;
  Target_Position_temp : double;
  Target_Position : double;
  temp : string;
begin
	Current_Axis := Control_Axis.ItemIndex;

	temp := TB_RelativePos.text ;
	Target_Position_temp := strtoInt(temp);

  Target_Position := ifthen(dir = cemDIR_P, Target_Position_temp, Target_Position_temp * -1);
	cemSxMoveStart(Current_Axis, Target_Position);
end;

procedure TForm1.CTRL_Absolute_Move(dir : LongInt);
var
  Current_Axis : LongInt;
  temp : string;
  Target_Position : double;

begin
	Current_Axis := Control_Axis.ItemIndex;

	if (dir = cemDIR_N) then
  begin
		temp := TB_AbsolutePos1.text;
	end
	else
  begin
		temp := TB_AbsolutePos2.text;
	end;

  Target_Position := StrtoInt(temp);
  cemSxMoveToStart(Current_Axis, Target_Position);
end;

{Single Axis Move Apply}
procedure TForm1.CTRL_VMove(dir : longInt);
var
  Current_Axis : LongInt;
begin
	Current_Axis := Control_Axis.ItemIndex;

	cemSxVMoveStart(Current_Axis, dir);
end;

procedure TForm1.BT_SxMove_NClick(Sender: TObject);
var
  dir : LongInt;
begin
	dir := cemDIR_N;

	if (RB_VelocityMode.checked) then
  begin
		CTRL_VMove(dir);
	end
	else if (RB_RelativeMode.checked) then
  begin
		CTRL_Relative_Move(dir);
	end
	else
  begin
		CTRL_Absolute_Move(dir);
	end;
end;


procedure TForm1.BT_SxMove_PClick(Sender: TObject);
var
  dir : LongInt;

begin
    dir := cemDIR_P;

	if (RB_VelocityMode.checked) then
  begin
		CTRL_VMove(dir);
	end
	else if (RB_RelativeMode.checked) then
  begin
		CTRL_Relative_Move(dir);
	end
	else
  begin
		CTRL_Absolute_Move(dir);
	end
end;


{Single Axis Move Stop}

procedure TForm1.CTRL_Stop();
var
  Current_Axis : LongInt;
begin
	Current_Axis := Control_Axis.ItemIndex;

	cemSxStop(Current_Axis, CE_FALSE, CE_FALSE);
end;

procedure TForm1.BT_SxStopClick(Sender: TObject);
begin
 CTRL_Stop();
end;

{Single Axis Move EMG Stop}

procedure TForm1.CTRL_EMGStop();
var
  Current_Axis : LongInt;
begin
	Current_Axis := Control_Axis.ItemIndex;

	cemSxStopEmg(Current_Axis);
end;

procedure TForm1.BT_SxEMGStopClick(Sender: TObject);
begin
  CTRL_EMGStop();
end;

{Homming Apply}

procedure TForm1.CTRL_Apply_HomeSetup();
var
  Current_Axis : LongInt;
	SpeedMode : LongInt;
	HomeMode : LongInt;
	WorkSpeed : double;
	Accel : double;
	Decel : double;
	EZCount : LongInt;
	Offset : double;
  ReverseVel : double;
	EscapeDist : double;
	Home_Dir : LongInt;
  temp : string;

begin
	Current_Axis := Control_Axis.ItemIndex;
	SpeedMode := 0;
	HomeMode := 0;
	WorkSpeed := 0;
	Accel := 0;
	Decel := 0;
	EZCount := 0;
	Offset := 0;
	ReverseVel := 0;
	EscapeDist := 0;
	Home_Dir := 0;

	temp := TB_HomeEzCount.text;
	EZCount := strtoInt(temp);
	temp := TB_HomeEscapeDist.text;
	EscapeDist := strtoInt(temp);
	temp := TB_HomeOffset.text;
	Offset := strtoInt(temp);
	temp := TB_HomeSpeed.text;
	WorkSpeed := strtoInt(temp);
	temp := TB_HomeAccel.text;
	Accel := strtoInt(temp);
	temp := TB_HomeDecel.text;
	Decel := strtoInt(temp);
	temp := TB_HomeReverseVel.text;
	ReverseVel := strtoInt(temp);

	Home_Dir := CB_HomeDir.Itemindex;
	HomeMode := CB_HomeMode.ItemIndex;
	SpeedMode := CB_HomeSpeedMode.ItemIndex;

	cemHomeConfig_Set(Current_Axis, HomeMode, Home_Dir, EZCount, EscapeDist, Offset);
	cemHomeSpeedPattern_Set(Current_Axis, SpeedMode, WorkSpeed, Accel, Decel, ReverseVel);
end;

procedure TForm1.BT_Apply_HomeClick(Sender: TObject);
begin
     CTRL_Apply_HomeSetup();
end;


{Homming Move}
procedure TForm1.CTRL_Homming();
var
  Current_Axis : LongInt;
begin
	Current_Axis := Control_Axis.ItemIndex;

	cemHomeMoveStart(Current_Axis);
end;

procedure TForm1.BT_HomeMoveClick(Sender: TObject);
begin
   CTRL_Homming();
end;

procedure TForm1.Button15Click(Sender: TObject);
var
   nDioIniChNo : LongInt;
   nDioChNum : LongInt;
   nDioModeMulti : LongInt;
begin
  nDioIniChNo := 0;
  nDioChNum :=15;

  cedioMulti_Put(8, 8, $ff);

end;

procedure TForm1.Button16Click(Sender: TObject);
begin
     cedioMulti_Put(8, 8, 0);
end;

procedure TForm1.Timer1Timer(Sender: TObject);

begin
		GUI_Refresh_MIOState();
		GUI_Refresh_MotState();
		GUI_Refresh_Position();
		GUI_Refresh_ServoOnOff();
    GUI_Refresh_Dio();
end;

procedure TForm1.BT_ResetPosClick(Sender: TObject);
begin
  CTRL_Pos_Reset();
end;

procedure TForm1.BT_ResetAlarmClick(Sender: TObject);
begin
  CTRL_Alarm_Reset();
end;

procedure TForm1.GUI_Refresh_Dio();
var
  state : LongInt;
begin
  state := 0;
  cedioMulti_Get(0, 16, @state);
  CB_DIO0.Checked := ((state shr 0) and $1) <> 0; // CH 0
  CB_DIO1.Checked := ((state shr 1) and $1) <> 0; // CH 1
  CB_DIO2.Checked := ((state shr 2) and $1) <> 0; // CH 2
  CB_DIO3.Checked := ((state shr 3) and $1) <> 0; // CH 3
  CB_DIO4.Checked := ((state shr 4) and $1) <> 0; // CH 4
  CB_DIO5.Checked := ((state shr 5) and $1) <> 0; // CH 5
	CB_DIO6.Checked := ((state shr 6) and $1) <> 0; // CH 6
	CB_DIO7.Checked := ((state shr 7) and $1) <> 0; // CH 7
  CB_DIO8.Checked := ((state shr 8) and $1) <> 0; // CH 8
  CB_DIO9.Checked := ((state shr 9) and $1) <> 0; // CH 9
  CB_DIO10.Checked := ((state shr 10) and $1) <> 0; // CH 10
  CB_DIO11.Checked := ((state shr 11) and $1) <> 0; // CH 11
  CB_DIO12.Checked := ((state shr 12) and $1) <> 0; // CH 12
  CB_DIO13.Checked := ((state shr 13) and $1) <> 0; // CH 13
	CB_DIO14.Checked := ((state shr 14) and $1) <> 0; // CH 14
	CB_DIO15.Checked := ((state shr 15) and $1) <> 0; //CH 15
end;

procedure TForm1.BT_SxStop2Click(Sender: TObject);
begin
 CTRL_Stop();
end;

procedure TForm1.BT_SxEMGStop2Click(Sender: TObject);
begin
  CTRL_EMGStop();
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Timer1.Enabled := false;
  Sleep(1000);
  ceGnUnload();
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
      cedioLogicMulti_Set(0, 16, 0);
end;


procedure TForm1.Button2Click(Sender: TObject);
begin
      cedioLogicMulti_Set(0, 16, $FFFF);
end;

end.
