// VSCEx.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include "ceSDK.h"

#define EXPECTED_NODECOUNT	10
#define TIMEOUT	1000 // Node Search Timeout

#define AI_NUM 16
#define DIO_NUM 48
#define NODE_NUM 3

int _tmain(int argc, _TCHAR* argv[])
{
	long i, j, g_nErrCode, nIsSearchedDev, m_nNodeCnt;

	if( !ceLoadDll() ) //DLL εմϴ.
		return TRUE;

	g_nErrCode = ceGnLoad();
	if(g_nErrCode)
		return FALSE;

	g_nErrCode = ceGnIsSearchedDevice( &nIsSearchedDev );

	if ( nIsSearchedDev == CE_FALSE )
	{
		//ڴ   , ŸӾƿ, , ãƳ   Դϴ.
		if( g_nErrCode = ceGnSearchDevice(EXPECTED_NODECOUNT, TIMEOUT, TRUE, &m_nNodeCnt) != ceERR_NONE ) {
			return FALSE;
		}
	}
	else{
		//带 ˻մϴ.
		if((g_nErrCode = ceGnReSearchDevice(EXPECTED_NODECOUNT, TIMEOUT, TRUE, &m_nNodeCnt)) < 0) {
			return FALSE;
		}
	}

	// VSC.ini  εմϴ
	// ش   丮   ⺻ ε˴ϴ
	// Enabled = 0
	// DigitMapMin = 0
	// DigitMapMax = 8192
	// RefDigit = 4096
	// Offset = 0.0
	// Gain = 1.0
	g_nErrCode = ceVSCSetting_Load();
	bool bVal;
	long nVal, nMin, nMax;
	double fVal, fMin, fMax;

	for(i=0; i<AI_NUM; i++)
	{
		g_nErrCode = ceVSCDigitRangeMap_Set(i, 0, 8192);
		g_nErrCode = ceVSCDigitRangeMap_Get(i, &nMin, &nMax);

		g_nErrCode = ceVSCAiSwGain_Set(i, 1.0);
		g_nErrCode = ceVSCAiSwGain_Get(i, &fVal);

		g_nErrCode = ceVSCAiSwOffset_Set(i, 0);
		g_nErrCode = ceVSCAiSwOffset_Get(i, &fVal);

		g_nErrCode = ceVSCReferenceDigit_Set(i, 4096);
		g_nErrCode = ceVSCReferenceDigit_Get(i, &nVal);

		g_nErrCode = ceVSCSettingEnable_Set(i, 0);
		g_nErrCode = ceVSCSettingEnable_Get(i, &nVal);
	}

	//  VSC Setting  VSC.ini Ϸ մϴ
	g_nErrCode = ceVSCSetting_Save();


	// Volt Range Mode 
	//for(i=0; i<AI_NUM; i++)
	//	g_nErrCode = ceaiVoltRangeMode_Set(i, 0); // -10~10 Volt 


	// (VSC ÷ξ  Լ ⺻ Ŀ  Լ ٸ VSC ð ˴ϴ)
	for(i=0; i<AI_NUM; i++)
	{
		// Ai Digit  ɴϴ
		g_nErrCode = ceVSCAiDigit_Get(i, &nVal);

		// Ai Voltage  ɴϴ (ceaiVoltRangeMode Voltage  Ͽ)
		g_nErrCode = ceVSCAiVolt_Get(i, &fVal);

		// Ai Current  ɴϴ (ceaiVoltRangeMode Current  Ͽ)
		g_nErrCode = ceVSCAiCurrent_Get(i, &fVal);

		// VSC Digit ذ    0, 1  ȯմϴ
		g_nErrCode = ceVSCReferenceResult_Get(i, &nVal);
	}

	LONG nNodeID;
	LONG nIniChan;
	LONG nChanNum;
	LONG nGalbalCh;
	// 1  10  DIO äο 1  մϴ
	g_nErrCode = ceVSCLocalDioOne_Put(nNodeID=1, 10, nVal=1);

	// 2  10  DIO äο 1  մϴ
	g_nErrCode = ceVSCLocalDioOne_Put(nNodeID=2, 10, nVal=1);

	// 2  0 äκ 32 äα ش DIO մϴ
	// ִ 32äα ÿ  մϴ
	g_nErrCode = ceVSCLocalDioMulti_Put(nNodeID=2, 0, 32, nVal=0xAAAAAAAA);

	// 1  Էµ ä  Ͽ Էµ  մϴ
	// 1 48ä    մϴ
	//  ڵ 0 äκ 15 äα  16ä ϸ 0 1 ݺؼ  Դϴ
	// nChanMap Է° {15, 12, 11, 3, 4, 9 .... }
	//   ϴ    ֽϴ
	// ̶  Put/Get Լ /  ä  ä ʿ Էµ  ϴ
	LONG nChanMap[32] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, };
	LONG nValMap[32]  = {0, 1, 0, 1, 0, 1, 0, 1, 0, 1,  0,  1,  0,  1,  0,  1, };
	g_nErrCode = ceVSCLocalDioMultiMap_Put(nNodeID=2, 16, nChanMap, nValMap);

	// 1  2  AI äο AIа ȯմϴ
	g_nErrCode = ceVSCLocalAiVoltOne_Get(nNodeID=1, 2, &fVal);

	DOUBLE fVals[32];
	LONG nVals[32];
	// 1  0-7  AI äο AI а ȯմϴ
	g_nErrCode = ceVSCLocalAiVoltMulti_Get(nNodeID=1, nIniChan=0, nChanNum=8, fVals);

	// 2  0-15  AI äο AI а ȯմϴ
	g_nErrCode = ceVSCLocalAiVoltMultiMap_Get(nNodeID=2, nChanNum=16, nChanMap, fVals);

	// 3  3  AI äο AI  ȯմϴ
	g_nErrCode = ceVSCLocalAiCurrentOne_Get(nNodeID=3, 3, &fVal);

	// 4  0-12  AI äο AI  ȯմϴ
	g_nErrCode = ceVSCLocalAiCurrentMulti_Get(nNodeID=4, nIniChan=0, nChanNum=13, fVals);

	// 5  0-15  AI äο AI  ȯմϴ
	g_nErrCode = ceVSCLocalAiCurrentMultiMap_Get(nNodeID=5, nChanNum=16, nChanMap, fVals);

	// 6  4  AI äο AI Digit ȯմϴ
	g_nErrCode = ceVSCLocalAiDigitOne_Get(nNodeID=6, 4, &nVal);

	// 7  0-15  AI äο AI Digit ȯմϴ
	g_nErrCode = ceVSCLocalAiDigitMulti_Get(nNodeID=7, nIniChan=0, nChanNum=16, nVals);

	// 8  0-15  AI äο AI Digit ȯմϴ
	g_nErrCode = ceVSCLocalAiDigitMultiMap_Get(nNodeID=8, nChanNum=16, nChanMap, nVals);


	/******************************************************************************************************/
	/***************************************  2015.11.12 ߰ Լ  ***************************************/
	/******************************************************************************************************/

	// ۷ι DIO 0 äο 1 մϴ.
	g_nErrCode = ceVSCDioOne_Put(nGalbalCh = 0, nVal = 1);

	// ۷ι DIO 10 ä  8 ä 10~17 ä 0xAA մϴ. 
	g_nErrCode = ceVSCDioMulti_Put(nIniChan = 10, nChanNum = 8, nVal = 0xAA);

	//  ۷ι äη õǴ DigitRangeMap, AiSwGain, SwOffset, ReferenceDigit, SettingEnable
	//  Լ  äη õǵ Լ ߰ Ǿϴ.
	for(i=1; i<NODE_NUM; i++)
	{
		for(j=0; j<AI_NUM; j++)
		{
			g_nErrCode = ceVSCLocalDigitRangeMap_Set(i, j, 0, 8192);
			g_nErrCode = ceVSCLocalDigitRangeMap_Get(i, j, &nMin, &nMax);

			g_nErrCode = ceVSCLocalAiSwGain_Set(i, j, 1.0);
			g_nErrCode = ceVSCLocalAiSwGain_Get(i, j, &fVal);

			g_nErrCode = ceVSCLocalAiSwOffset_Set(i, j, 0);
			g_nErrCode = ceVSCLocalAiSwOffset_Get(i, j, &fVal);

			g_nErrCode = ceVSCLocalReferenceDigit_Set(i, j, 4096);
			g_nErrCode = ceVSCLocalReferenceDigit_Get(i, j, &nVal);

			g_nErrCode = ceVSCLocalSettingEnable_Set(i, j, 0);
			g_nErrCode = ceVSCLocalSettingEnable_Get(i, j, &nVal);
		}
	}

	// 3  1 ä Digit  VSC Digit ذ    0, 1  ȯմϴ.
	g_nErrCode = ceVSCLocalReferenceResult_Get(nNodeID=3, 1, &nVal);
	g_nErrCode = ceVSCLocalReferenceResultMulti_Get(nNodeID=1, nIniChan=0, nChanNum=16, nVals);
	g_nErrCode = ceVSCLocalReferenceResultMultiMap_Get(nNodeID=1, nChanNum=16, nChanMap, nVals);

	LONG nMsDuration=0;

	ceVSCLocalDioOnePulse_Put(nNodeID=1, 0, nVal=1, nMsDuration=0);
	ceVSCLocalDioMultiPulse_Put(nNodeID=1, nIniChan=0, nChanNum=32, nVal=0xFFFFFFFF, nMsDuration=10);
	ceVSCLocalDioMultiMapPulse_Put(nNodeID=1, nChanNum=32, nChanMap, nVals, nMsDuration=10);

	ceVSCLocalAiKpaOne_Get(nNodeID=1, 0, &fVal);
	ceVSCLocalAiKpaMulti_Get(nNodeID=1, nIniChan=0, nChanNum=16, fVals);
	ceVSCLocalAiKpaMultiMap_Get(nNodeID=1, nChanNum=16, nChanMap, fVals);

	ceGnUnload();
	ceUnloadDll();
	return 0;
}

