/*******************************************************************************
* [ ComiMLink2_SDK.cpp ]
* CPP file for definitions of constants and data in Mechatrolink-2 SDK library
* - Update Data: 2021/03/11
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#include "stdafx.h"

#if defined(__BCPLUSPLUS__)  // Borland C++ Builder specific
 #include <vcl.h>
 #pragma hdrstop
#endif

#include <windows.h>
#include <stdio.h>

#define _DLL_MAIN_CPP_
#include "ComiMLink2_SDK.h"

#ifdef UNICODE
#define __DLL_FILE_FULL_PATH__ L"ComiMLink2.DLL"
#else
#define __DLL_FILE_FULL_PATH__ "ComiMLink2.DLL"
#endif

typedef struct{
	char *name;
	FARPROC* ptr;
}LIB_FUNCT;

static HINSTANCE hLibrary=NULL;

BOOL cmlLoadDll(void)
{
	LIB_FUNCT Func[] = {

		//////////////////////////////////////////////////////////////////////////
		// Low Level API for Debugging
		//////////////////////////////////////////////////////////////////////////
		{"GetResources",		(FARPROC*)&cmlGetResources},
		{"WriteMemPortDW",		(FARPROC*)&cmlWriteMemPortDW},
		{"ReadMemPortDW",		(FARPROC*)&cmlReadMemPortDW},
		{"DpramRead",			(FARPROC*)&cmlDpramRead},
		{"DpramWrite",			(FARPROC*)&cmlDpramWrite},
		{"DpramBusyEnable",		(FARPROC*)&cmlDpramBusyEnable},
		{"DpramBusyDisable",	(FARPROC*)&cmlDpramBusyDisable},
		
		//////////////////////////////////////////////////////////////////////////
		// Device Load / Unload
		//////////////////////////////////////////////////////////////////////////
		{"GnLoadDevice",		(FARPROC*)&cmlGnLoadDevice},
		{"GnUnloadDevice",		(FARPROC*)&cmlGnUnloadDevice},
		
		//////////////////////////////////////////////////////////////////////////
		// General function
		//////////////////////////////////////////////////////////////////////////
		{"GnResetDevice",		(FARPROC*)&cmlGnResetDevice},
		
		{"GnSetServoOn",		(FARPROC*)&cmlGnSetServoOn},
		{"GnGetServoOn",		(FARPROC*)&cmlGnGetServoOn},
		{"GnSetAlarmRes",		(FARPROC*)&cmlGnSetAlarmRes},
		{"GnGetAlarmRes",		(FARPROC*)&cmlGnGetAlarmRes},
		{"GnSetEmergency",		(FARPROC*)&cmlGnSetEmergency},
		{"GnGetEmergency",		(FARPROC*)&cmlGnGetEmergency},
		{"GnSetEmergencyAll",	(FARPROC*)&cmlGnSetEmergencyAll},
		{"GnGetEmergencyAll",	(FARPROC*)&cmlGnGetEmergencyAll},
		{"GnSetCommPeriod",		(FARPROC*)&cmlGnSetCommPeriod},
		{"GnGetCommPeriod",		(FARPROC*)&cmlGnGetCommPeriod},
		{"GnGetAxisMap",		(FARPROC*)&cmlGnGetAxisMap},
		{"GnResetComm",			(FARPROC*)&cmlGnResetComm},
		{"GnSetCommStates",		(FARPROC*)&cmlGnSetCommStates},
		{"GnGetCommStates",		(FARPROC*)&cmlGnGetCommStates},
		{"GnGetNodeInfo",		(FARPROC*)&cmlGnGetNodeInfo},
		{"GnTotalDIOChannel",	(FARPROC*)&cmlGnTotalDIOChannel},
		{"GnTotalAIChannel",	(FARPROC*)&cmlGnTotalAIChannel},
		{"GnTotalAOChannel",	(FARPROC*)&cmlGnTotalAOChannel},
		
		//////////////////////////////////////////////////////////////////////////
		// Log function
		//////////////////////////////////////////////////////////////////////////
		{"GnSetLogMode",	(FARPROC*)&cmlGnSetLogMode},
		{"GnGetLogMode",	(FARPROC*)&cmlGnGetLogMode},
		{"GnSetLogLevel",	(FARPROC*)&cmlGnSetLogLevel},
		{"GnGetLogLevel",	(FARPROC*)&cmlGnGetLogLevel},
		{"GnSetFuncLevel",	(FARPROC*)&cmlGnSetFuncLevel},
		{"GnRestoreFuncLevel",	(FARPROC*)&cmlGnRestoreFuncLevel},
		{"GnGetFuncLevel",	(FARPROC*)&cmlGnGetFuncLevel},
		
		//////////////////////////////////////////////////////////////////////////
		// Cfg function
		//////////////////////////////////////////////////////////////////////////
		{"CfgSetMioProperty",  (FARPROC*)&cmlCfgSetMioProperty},
		{"CfgGetMioProperty",  (FARPROC*)&cmlCfgGetMioProperty},

		{"CfgSetUnitDist",	   (FARPROC*)&cmlCfgSetUnitDist},
		{"CfgGetUnitDist",	   (FARPROC*)&cmlCfgGetUnitDist},

		{"CfgSetUnitSpeed",	   (FARPROC*)&cmlCfgSetUnitSpeed},
		{"CfgGetUnitSpeed",	   (FARPROC*)&cmlCfgGetUnitSpeed},

		{"CfgSetSpeedPattern", (FARPROC*)&cmlCfgSetSpeedPattern},
		{"CfgGetSpeedPattern", (FARPROC*)&cmlCfgGetSpeedPattern},

		{"CfgSetSpeedPattern_T", (FARPROC*)&cmlCfgSetSpeedPattern_T},
		{"CfgGetSpeedPattern_T", (FARPROC*)&cmlCfgGetSpeedPattern_T},

		{"CfgSetSoftLimit",	   (FARPROC*)&cmlCfgSetSoftLimit},
		{"CfgGetSoftLimit",	   (FARPROC*)&cmlCfgGetSoftLimit},

		{"CfgSetVelCorrRatio",	   (FARPROC*)&cmlCfgSetVelCorrRatio},
		{"CfgGetVelCorrRatio",	   (FARPROC*)&cmlCfgGetVelCorrRatio},

		//////////////////////////////////////////////////////////////////////////
		// Sx Control
		//////////////////////////////////////////////////////////////////////////
		{"SxMove",			(FARPROC*)&cmlSxMove},
		{"SxMoveStart",		(FARPROC*)&cmlSxMoveStart},
		{"SxMoveTo",		(FARPROC*)&cmlSxMoveTo},
		{"SxMoveToStart",	(FARPROC*)&cmlSxMoveToStart},
		{"SxVMoveStart",	(FARPROC*)&cmlSxVMoveStart},
		{"SxStop",          (FARPROC*)&cmlSxStop},
		{"SxStopEmg",       (FARPROC*)&cmlSxStopEmg},
		{"SxIsDone",		(FARPROC*)&cmlSxIsDone},
		{"SxWaitDone",		(FARPROC*)&cmlSxWaitDone},

		{"SxSetCorrection", (FARPROC*)&cmlSxSetCorrection},
		{"SxGetCorrection", (FARPROC*)&cmlSxGetCorrection},

		//////////////////////////////////////////////////////////////////////////
		// Mx Control
		//////////////////////////////////////////////////////////////////////////
		{"MxMove",			(FARPROC*)&cmlMxMove},
		{"MxMoveStart",		(FARPROC*)&cmlMxMoveStart},
		{"MxMoveTo",		(FARPROC*)&cmlMxMoveTo},
		{"MxMoveToStart",	(FARPROC*)&cmlMxMoveToStart},
		{"MxVMoveStart",	(FARPROC*)&cmlMxVMoveStart},
		{"MxStop",			(FARPROC*)&cmlMxStop},
		{"MxStopEmg",		(FARPROC*)&cmlMxStopEmg},
		{"MxIsDone",		(FARPROC*)&cmlMxIsDone},
		{"MxWaitDone",		(FARPROC*)&cmlMxWaitDone},

		//////////////////////////////////////////////////////////////////////////
		// Ix Control
		//////////////////////////////////////////////////////////////////////////
		{"IxMapAxes",		 (FARPROC*)&cmlIxMapAxes},
		{"IxUnMapAxes",		 (FARPROC*)&cmlIxUnMapAxes},
		
		{"IxSetSpeedPattern",(FARPROC*)&cmlIxSetSpeedPattern},
		{"IxGetSpeedPattern",(FARPROC*)&cmlIxGetSpeedPattern},
		
		{"IxSetSpeedPattern_T", (FARPROC*)&cmlIxSetSpeedPattern_T},
		{"IxGetSpeedPattern_T", (FARPROC*)&cmlIxGetSpeedPattern_T},

		{"IxLine",			 (FARPROC*)&cmlIxLine},
		{"IxLineStart",		 (FARPROC*)&cmlIxLineStart},

		{"IxLineTo",		 (FARPROC*)&cmlIxLineTo},
		{"IxLineToStart",	 (FARPROC*)&cmlIxLineToStart},

		{"IxArcA",			 (FARPROC*)&cmlIxArcA},
		{"IxArcAStart",		 (FARPROC*)&cmlIxArcAStart},

		{"IxArcATo",		 (FARPROC*)&cmlIxArcATo},
		{"IxArcAToStart",	 (FARPROC*)&cmlIxArcAToStart},

		{"IxArcP",			 (FARPROC*)&cmlIxArcP},
		{"IxArcPStart",		 (FARPROC*)&cmlIxArcPStart},

		{"IxArcPTo",		 (FARPROC*)&cmlIxArcPTo},
		{"IxArcPToStart",	 (FARPROC*)&cmlIxArcPToStart},

		{"IxArc3P",			 (FARPROC*)&cmlIxArc3P},
		{"IxArc3PStart",	 (FARPROC*)&cmlIxArc3PStart},

		{"IxArc3PTo",		 (FARPROC*)&cmlIxArc3PTo},
		{"IxArc3PToStart",	 (FARPROC*)&cmlIxArc3PToStart},

		{"IxIsDone",		 (FARPROC*)&cmlIxIsDone},
		{"IxWaitDone",		 (FARPROC*)&cmlIxWaitDone},

		{"IxStop",			 (FARPROC*)&cmlIxStop},
		{"IxStopEmg",		 (FARPROC*)&cmlIxStopEmg},

		{"IxHelOnceStart",	 (FARPROC*)&cmlIxHelOnceStart},
		{"IxSplineStart",    (FARPROC*)&cmlIxSplineStart},

		{"IxSpline2_RegRefPoints",    (FARPROC*)&cmlIxSpline2_RegRefPoints},
		{"IxSpline2_MoveStart",    (FARPROC*)&cmlIxSpline2_MoveStart},
		
		{"IxGetMapIndex",	 (FARPROC*)&cmlIxGetMapIndex},

		//////////////////////////////////////////////////////////////////////////
		// Return To Home
		//////////////////////////////////////////////////////////////////////////
		{"HomeSetConfig",		(FARPROC*)&cmlHomeSetConfig},
		{"HomeGetConfig",		(FARPROC*)&cmlHomeGetConfig},

		{"HomeSetOffset",		(FARPROC*)&cmlHomeSetOffset},
		{"HomeGetOffset",		(FARPROC*)&cmlHomeGetOffset},

		{"HomeSetSpeedPattern",	(FARPROC*)&cmlHomeSetSpeedPattern},
		{"HomeGetSpeedPattern",	(FARPROC*)&cmlHomeGetSpeedPattern},

		{"HomeSetSpeedPattern_T", (FARPROC*)&cmlHomeSetSpeedPattern_T},
		{"HomeGetSpeedPattern_T", (FARPROC*)&cmlHomeGetSpeedPattern_T},

		{"HomeMove",			(FARPROC*)&cmlHomeMove},
		{"HomeMoveStart",		(FARPROC*)&cmlHomeMoveStart},

		{"HomeMoveAll",			(FARPROC*)&cmlHomeMoveAll},
		{"HomeMoveAllStart",	(FARPROC*)&cmlHomeMoveAllStart},

		{"HomeIsBusy",			(FARPROC*)&cmlHomeIsBusy},
		{"HomeWaitDone",		(FARPROC*)&cmlHomeWaitDone},

		{"HomeSetSuccess",		(FARPROC*)&cmlHomeSetSuccess},
		{"HomeGetSuccess",	    (FARPROC*)&cmlHomeGetSuccess},

		//////////////////////////////////////////////////////////////////////////
		// Override
		//////////////////////////////////////////////////////////////////////////
		{"OverrideSpeedSet",	(FARPROC*)&cmlOverrideSpeedSet},
		{"OverrideMove",		(FARPROC*)&cmlOverrideMove},
		{"OverrideMoveTo",		(FARPROC*)&cmlOverrideMoveTo},

		//////////////////////////////////////////////////////////////////////////
		// Listed Motion
		//////////////////////////////////////////////////////////////////////////
		{"LmxStart",			(FARPROC*)&cmlLmxStart},
		{"LmxSuspend",			(FARPROC*)&cmlLmxSuspend},
		{"LmxResume",			(FARPROC*)&cmlLmxResume},
		{"LmxEnd",				(FARPROC*)&cmlLmxEnd},
		{"LmxGetStates",		(FARPROC*)&cmlLmxGetStates},

		{"LmxSetSeqMode",		(FARPROC*)&cmlLmxSetSeqMode},
		{"LmxGetSeqMode",		(FARPROC*)&cmlLmxGetSeqMode},

		{"LmxSetNextItemId",	(FARPROC*)&cmlLmxSetNextItemId},
		{"LmxGetNextItemId",	(FARPROC*)&cmlLmxGetNextItemId},
		
		{"LmxSetNextItemParam",	(FARPROC*)&cmlLmxSetNextItemParam},
		{"LmxGetNextItemParam", (FARPROC*)&cmlLmxGetNextItemParam},

		{"LmxGetRunItemParam",	(FARPROC*)&cmlLmxGetRunItemParam},
		{"LmxGetRunItemStaPos", (FARPROC*)&cmlLmxGetRunItemStaPos},
		{"LmxGetRunItemTargPos",(FARPROC*)&cmlLmxGetRunItemTargPos},
		
		{"LmxSetSeqId",			(FARPROC*)&cmlLmxSetSeqId},
		{"LmxGetSeqId",			(FARPROC*)&cmlLmxGetSeqId},
		
		//////////////////////////////////////////////////////////////////////////
		// Status Monitoring
		//////////////////////////////////////////////////////////////////////////
		{"StSetCount",          (FARPROC*)&cmlStSetCount},
		{"StGetCount",			(FARPROC*)&cmlStGetCount},

		{"StSetPosition",       (FARPROC*)&cmlStSetPosition},
		{"StGetPosition",		(FARPROC*)&cmlStGetPosition},

		{"StGetSpeed",			(FARPROC*)&cmlStGetSpeed},
		{"StGetTorque",			(FARPROC*)&cmlStGetTorque},

		{"StSxReadMotionState", (FARPROC*)&cmlStSxReadMotionState},
		{"StIxReadMotionState", (FARPROC*)&cmlStIxReadMotionState},

		{"StReadMioStatuses",	(FARPROC*)&cmlStReadMioStatuses},
		{"StGetMotionMode",		(FARPROC*)&cmlStGetMotionMode},

		{"StSxGetLastError",	(FARPROC*)&cmlStSxGetLastError},
		{"StIxGetLastError",	(FARPROC*)&cmlStIxGetLastError},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (DI)
		//////////////////////////////////////////////////////////////////////////
		{"DiGetLogic",			(FARPROC*)&cmlDiGetLogic},
		{"DiSetLogic",			(FARPROC*)&cmlDiSetLogic},
		{"DiGetLogicMulti",		(FARPROC*)&cmlDiGetLogicMulti},
		{"DiSetLogicMulti",		(FARPROC*)&cmlDiSetLogicMulti},
		{"DiGetOne",			(FARPROC*)&cmlDiGetOne},
		{"DiGetMulti",			(FARPROC*)&cmlDiGetMulti},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (DO)
		//////////////////////////////////////////////////////////////////////////
		{"DoGetLogic",			(FARPROC*)&cmlDoGetLogic},
		{"DoSetLogic",			(FARPROC*)&cmlDoSetLogic},
		{"DoGetLogicMulti",		(FARPROC*)&cmlDoGetLogicMulti},
		{"DoSetLogicMulti",		(FARPROC*)&cmlDoSetLogicMulti},
		{"DoPutOne",			(FARPROC*)&cmlDoPutOne},
		{"DoGetOne",			(FARPROC*)&cmlDoGetOne},
		{"DoPutMulti",			(FARPROC*)&cmlDoPutMulti},
		{"DoGetMulti",			(FARPROC*)&cmlDoGetMulti},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (DIO)
		//////////////////////////////////////////////////////////////////////////
		{"DioGetIomode",		(FARPROC*)&cmlDioGetIomode},
		{"DioSetIomode",		(FARPROC*)&cmlDioSetIomode},
		{"DioGetIomodeMulti",	(FARPROC*)&cmlDioGetIomodeMulti},
		{"DioSetIomodeMulti",	(FARPROC*)&cmlDioSetIomodeMulti},
		{"DioGetLogic",			(FARPROC*)&cmlDioGetLogic},
		{"DioSetLogic",			(FARPROC*)&cmlDioSetLogic},
		{"DioGetLogicMulti",	(FARPROC*)&cmlDioGetLogicMulti},
		{"DioSetLogicMulti",	(FARPROC*)&cmlDioSetLogicMulti},
		{"DioPutOne",			(FARPROC*)&cmlDioPutOne},
		{"DioGetOne",			(FARPROC*)&cmlDioGetOne},
		{"DioPutMulti",			(FARPROC*)&cmlDioPutMulti},
		{"DioGetMulti",			(FARPROC*)&cmlDioGetMulti},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (AI)
		//////////////////////////////////////////////////////////////////////////
		{"AiSetVoltRangeMode",	(FARPROC*)&cmlAiSetVoltRangeMode},
		{"AiGetVoltRangeMode",	(FARPROC*)&cmlAiGetVoltRangeMode},
		{"AiGetRangeDigit",		(FARPROC*)&cmlAiGetRangeDigit},
		{"AiGetDigit",			(FARPROC*)&cmlAiGetDigit},
		{"AiGetVolt",			(FARPROC*)&cmlAiGetVolt},
		{"AiGetCurrent",		(FARPROC*)&cmlAiGetCurrent},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (AO)
		//////////////////////////////////////////////////////////////////////////
		{"AoOutDigit",			(FARPROC*)&cmlAoOutDigit},
		{"AoOutVolt",			(FARPROC*)&cmlAoOutVolt},
		{"AoOutCurrent",		(FARPROC*)&cmlAoOutCurrent},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-GN)
		//////////////////////////////////////////////////////////////////////////
		{"PmGnSetServoOn",		(FARPROC*)&cmlPmGnSetServoOn},
		{"PmGnGetServoOn",		(FARPROC*)&cmlPmGnGetServoOn},
		{"PmGnAlarmReset",		(FARPROC*)&cmlPmGnAlarmReset},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-CFG)
		//////////////////////////////////////////////////////////////////////////
		{"PmCfgSetMioProperty",	(FARPROC*)&cmlPmCfgSetMioProperty},
		{"PmCfgGetMioProperty",	(FARPROC*)&cmlPmCfgGetMioProperty},
		{"PmCfgSetFilter",		(FARPROC*)&cmlPmCfgSetFilter},
		{"PmCfgGetFilter",		(FARPROC*)&cmlPmCfgGetFilter},
		{"PmCfgSetFilterAB",	(FARPROC*)&cmlPmCfgSetFilterAB},
		{"PmCfgGetFilterAB",	(FARPROC*)&cmlPmCfgGetFilterAB},
		{"PmCfgSetInMode",		(FARPROC*)&cmlPmCfgSetInMode},
		{"PmCfgGetInMode",		(FARPROC*)&cmlPmCfgGetInMode},
		{"PmCfgSetOutMode",		(FARPROC*)&cmlPmCfgSetOutMode},
		{"PmCfgGetOutMode",		(FARPROC*)&cmlPmCfgGetOutMode},
		{"PmCfgSetCtrlMode",	(FARPROC*)&cmlPmCfgSetCtrlMode},
		{"PmCfgGetCtrlMode",	(FARPROC*)&cmlPmCfgGetCtrlMode},
		{"PmCfgSetInOutRatio",	(FARPROC*)&cmlPmCfgSetInOutRatio},
		{"PmCfgGetInOutRatio",	(FARPROC*)&cmlPmCfgGetInOutRatio},
		{"PmCfgSetUnitDist",	(FARPROC*)&cmlPmCfgSetUnitDist},
		{"PmCfgGetUnitDist",	(FARPROC*)&cmlPmCfgGetUnitDist},
		{"PmCfgSetUnitSpeed",	(FARPROC*)&cmlPmCfgSetUnitSpeed},
		{"PmCfgGetUnitSpeed",	(FARPROC*)&cmlPmCfgGetUnitSpeed},
		{"PmCfgSetSpeedRange",	(FARPROC*)&cmlPmCfgSetSpeedRange},
		{"PmCfgGetSpeedRange",	(FARPROC*)&cmlPmCfgGetSpeedRange},
		{"PmCfgSetSpeedPattern",	(FARPROC*)&cmlPmCfgSetSpeedPattern},
		{"PmCfgGetSpeedPattern",	(FARPROC*)&cmlPmCfgGetSpeedPattern},
		{"PmCfgSetSpeedPattern_T",	(FARPROC*)&cmlPmCfgSetSpeedPattern_T},
		{"PmCfgGetSpeedPattern_T",	(FARPROC*)&cmlPmCfgGetSpeedPattern_T},
		{"PmCfgSetSoftLimit",	(FARPROC*)&cmlPmCfgSetSoftLimit},
		{"PmCfgGetSoftLimit",	(FARPROC*)&cmlPmCfgGetSoftLimit},
		{"PmCfgSetRingCntr",	(FARPROC*)&cmlPmCfgSetRingCntr},
		{"PmCfgGetRingCntr",	(FARPROC*)&cmlPmCfgGetRingCntr},
		{"PmCfgSetVelCorrRatio",	(FARPROC*)&cmlPmCfgSetVelCorrRatio},
		{"PmCfgGetVelCorrRatio",	(FARPROC*)&cmlPmCfgGetVelCorrRatio},
		{"PmCfgSetSeqMode",		(FARPROC*)&cmlPmCfgSetSeqMode},
		{"PmCfgGetSeqMode",		(FARPROC*)&cmlPmCfgGetSeqMode},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-HOME)
		//////////////////////////////////////////////////////////////////////////
		{"PmHomeSetConfig",		(FARPROC*)&cmlPmHomeSetConfig},
		{"PmHomeGetConfig",		(FARPROC*)&cmlPmHomeGetConfig},
		{"PmHomeSetPosClrMode",	(FARPROC*)&cmlPmHomeSetPosClrMode},
		{"PmHomeGetPosClrMode",	(FARPROC*)&cmlPmHomeGetPosClrMode},
		{"PmHomeSetSpeedPattern",	(FARPROC*)&cmlPmHomeSetSpeedPattern},
		{"PmHomeGetSpeedPattern",	(FARPROC*)&cmlPmHomeGetSpeedPattern},
		{"PmHomeSetSpeedPattern_T",	(FARPROC*)&cmlPmHomeSetSpeedPattern_T},
		{"PmHomeGetSpeedPattern_T",	(FARPROC*)&cmlPmHomeGetSpeedPattern_T},
		{"PmHomeMoveStart",		(FARPROC*)&cmlPmHomeMoveStart},
		{"PmHomeMoveAllStart",	(FARPROC*)&cmlPmHomeMoveAllStart},
		{"PmHomeSetSuccess",	(FARPROC*)&cmlPmHomeSetSuccess},
		{"PmHomeGetSuccess",	(FARPROC*)&cmlPmHomeGetSuccess},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-SX)
		//////////////////////////////////////////////////////////////////////////
		{"PmSxSetSpeedRatio",	(FARPROC*)&cmlPmSxSetSpeedRatio},
		{"PmSxGetSpeedRatio",	(FARPROC*)&cmlPmSxGetSpeedRatio},
		{"PmSxMoveStart",		(FARPROC*)&cmlPmSxMoveStart},
		{"PmSxMove",		(FARPROC*)&cmlPmSxMove},
		{"PmSxMoveToStart",		(FARPROC*)&cmlPmSxMoveToStart},
		{"PmSxMoveTo",		(FARPROC*)&cmlPmSxMoveTo},
		{"PmSxVMoveStart",		(FARPROC*)&cmlPmSxVMoveStart},
		{"PmSxStop",			(FARPROC*)&cmlPmSxStop},
		{"PmSxStopEmg",			(FARPROC*)&cmlPmSxStopEmg},
		{"PmSxIsDone",		(FARPROC*)&cmlPmSxIsDone},
		{"PmSxWaitDone",		(FARPROC*)&cmlPmSxWaitDone},
		{"PmSxGetTargetPos",	(FARPROC*)&cmlPmSxGetTargetPos},
		{"PmSxSetOptIniSpeed",	(FARPROC*)&cmlPmSxSetOptIniSpeed},
		{"PmSxGetOptIniSpeed",	(FARPROC*)&cmlPmSxGetOptIniSpeed},
		{"PmSxSetOptRdpOffset",	(FARPROC*)&cmlPmSxSetOptRdpOffset},
		{"PmSxGetOptRdpOffset",	(FARPROC*)&cmlPmSxGetOptRdpOffset},
		{"PmSxSetCorrection",	(FARPROC*)&cmlPmSxSetCorrection},
		{"PmSxGetCorrection",	(FARPROC*)&cmlPmSxGetCorrection},
		{"PmSxSetOptSyncMode",	(FARPROC*)&cmlPmSxSetOptSyncMode},
		{"PmSxGetOptSyncMode",	(FARPROC*)&cmlPmSxGetOptSyncMode},
		{"PmSxSetOptSyncOut",	(FARPROC*)&cmlPmSxSetOptSyncOut},
		{"PmSxGetOptSyncOut",	(FARPROC*)&cmlPmSxGetOptSyncOut},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-MX)
		//////////////////////////////////////////////////////////////////////////
		{"PmMxMoveStart",		(FARPROC*)&cmlPmMxMoveStart},
		{"PmMxMove",		(FARPROC*)&cmlPmMxMove},
		{"PmMxMoveToStart",		(FARPROC*)&cmlPmMxMoveToStart},
		{"PmMxMoveTo",		(FARPROC*)&cmlPmMxMoveTo},
		{"PmMxVMoveStart",		(FARPROC*)&cmlPmMxVMoveStart},
		{"PmMxStop",			(FARPROC*)&cmlPmMxStop},
		{"PmMxStopEmg",			(FARPROC*)&cmlPmMxStopEmg},
		{"PmMxIsDone",		(FARPROC*)&cmlPmMxIsDone},
		{"PmMxWaitDone",		(FARPROC*)&cmlPmMxWaitDone},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-IX)
		//////////////////////////////////////////////////////////////////////////
		{"PmIxMapAxes",			(FARPROC*)&cmlPmIxMapAxes},
		{"PmIxUnMapAxes",		(FARPROC*)&cmlPmIxUnMapAxes},
		{"PmIxSetVelCorrMode",	(FARPROC*)&cmlPmIxSetVelCorrMode},
		{"PmIxGetVelCorrMode",	(FARPROC*)&cmlPmIxGetVelCorrMode},
		{"PmIxSetSpeedPattern",	(FARPROC*)&cmlPmIxSetSpeedPattern},
		{"PmIxGetSpeedPattern",	(FARPROC*)&cmlPmIxGetSpeedPattern},
		{"PmIxSetSpeedPattern_T",	(FARPROC*)&cmlPmIxSetSpeedPattern_T},
		{"PmIxGetSpeedPattern_T",	(FARPROC*)&cmlPmIxGetSpeedPattern_T},
		{"PmIxLineStart",		(FARPROC*)&cmlPmIxLineStart},
		{"PmIxLineToStart",		(FARPROC*)&cmlPmIxLineToStart},
		{"PmIxArcAStart",		(FARPROC*)&cmlPmIxArcAStart},
		{"PmIxArcAToStart",		(FARPROC*)&cmlPmIxArcAToStart},
		{"PmIxArcPStart",		(FARPROC*)&cmlPmIxArcPStart},
		{"PmIxArcPToStart",		(FARPROC*)&cmlPmIxArcPToStart},
		{"PmIxArc3PStart",		(FARPROC*)&cmlPmIxArc3PStart},
		{"PmIxArc3PToStart",	(FARPROC*)&cmlPmIxArc3PToStart},
		{"PmIxStop",			(FARPROC*)&cmlPmIxStop},
		{"PmIxStopEmg",			(FARPROC*)&cmlPmIxStopEmg},
		{"PmIxIsDone",			(FARPROC*)&cmlPmIxIsDone},
		{"PmIxWaitDone",		(FARPROC*)&cmlPmIxWaitDone},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-OVERRIDE)
		//////////////////////////////////////////////////////////////////////////
		{"PmOverrideSpeedSet",	(FARPROC*)&cmlPmOverrideSpeedSet},
		{"PmOverrideSpeedSetAll",	(FARPROC*)&cmlPmOverrideSpeedSetAll},
		{"PmOverrideMove",		(FARPROC*)&cmlPmOverrideMove},
		{"PmOverrideMoveTo",	(FARPROC*)&cmlPmOverrideMoveTo},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-ST)
		//////////////////////////////////////////////////////////////////////////
		{"PmStSetCount",		(FARPROC*)&cmlPmStSetCount},
		{"PmStGetCount",		(FARPROC*)&cmlPmStGetCount},
		{"PmStSetPosition",		(FARPROC*)&cmlPmStSetPosition},
		{"PmStGetPosition",		(FARPROC*)&cmlPmStGetPosition},
		{"PmStGetSpeed",		(FARPROC*)&cmlPmStGetSpeed},
		{"PmStReadMotionState",	(FARPROC*)&cmlPmStReadMotionState},
		{"PmStReadMIOStatus",	(FARPROC*)&cmlPmStReadMIOStatus},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-LTC)
		//////////////////////////////////////////////////////////////////////////
		{"PmLtcIsLatched",		(FARPROC*)&cmlPmLtcIsLatched},
		{"PmLtcReadLatch",		(FARPROC*)&cmlPmLtcReadLatch},
		
		//////////////////////////////////////////////////////////////////////////
		// Servo Parameter R/W Functions
		//////////////////////////////////////////////////////////////////////////
		{"ServoParamRead",		(FARPROC*)&cmlServoParamRead},
		{"ServoParamWrite",		(FARPROC*)&cmlServoParamWrite},
		{"ServoParamSet",		(FARPROC*)&cmlServoParamSet},
		{"ServoParamValidate",		(FARPROC*)&cmlServoParamValidate},				
		
		//////////////////////////////////////////////////////////////////////////
		// Advanced Functions
		//////////////////////////////////////////////////////////////////////////
		{"AdvFwGetVersion",		(FARPROC*)&cmlAdvFwGetVersion},
		{"AdvDllGetVersion",	(FARPROC*)&cmlAdvDllGetVersion},
		{"AdvDrvGetVersion",	(FARPROC*)&cmlAdvDrvGetVersion},
		{"AdvFwGetSystemState",	(FARPROC*)&cmlAdvFwGetSystemState},
		{"AdvFwDnFrame",		(FARPROC*)&cmlAdvFwDnFrame},
		{"AdvFwDnFrameVerify",	(FARPROC*)&cmlAdvFwDnFrameVerify},		
		{"AdvFwSystemReset",	(FARPROC*)&cmlAdvFwSystemReset},
		{"AdvFwSetFwuBit",		(FARPROC*)&cmlAdvFwSetFwuBit},
		{"AdvFwGetFwuBit",		(FARPROC*)&cmlAdvFwGetFwuBit},
		{"AdvFwSetBootFlag",	(FARPROC*)&cmlAdvFwSetBootFlag},
		{"AdvFwGetBootFlag",	(FARPROC*)&cmlAdvFwGetBootFlag},
		{"AdvFwUpdateMode",		(FARPROC*)&cmlAdvFwUpdateMode},
		{"AdvM2NodeCfgRead",	(FARPROC*)&cmlAdvM2NodeCfgRead},
		{"AdvM2NodeCfgWrite",	(FARPROC*)&cmlAdvM2NodeCfgWrite},
		{"AdvSetRtsEnable",		(FARPROC*)&cmlAdvSetRtsEnable},
		{"AdvGetRtsEnable",		(FARPROC*)&cmlAdvGetRtsEnable},
		{"AdvSetRtsMode",		(FARPROC*)&cmlAdvSetRtsMode},
		{"AdvGetRtsMode",		(FARPROC*)&cmlAdvGetRtsMode},
		{"AdvGetRtsMemPtr",		(FARPROC*)&cmlAdvGetRtsMemPtr},
		{"AdvSetRtsUpdateInterval",		(FARPROC*)&cmlAdvSetRtsUpdateInterval},
		{"AdvGetRtsUpdateInterval",		(FARPROC*)&cmlAdvGetRtsUpdateInterval},
		{"AdvSetCmdAckMode",			(FARPROC*)&cmlAdvSetCmdAckMode},
		{"AdvGetCmdAckMode",			(FARPROC*)&cmlAdvGetCmdAckMode},
		{"AdvDeviceIDRead",		(FARPROC*)&cmlAdvDeviceIDRead},
		{"GnSetABSMode",		(FARPROC*)&cmlGnSetABSMode},
		{"GnGetABSMode",		(FARPROC*)&cmlGnGetABSMode},
		{"GnABSUpdate",			(FARPROC*)&cmlGnABSUpdate},
		{"GnSetABSHome",		(FARPROC*)&cmlGnSetABSHome},
		{"CfgSetRingCntr",		(FARPROC*)&cmlCfgSetRingCntr},
		{"CfgGetRingCntr",		(FARPROC*)&cmlCfgGetRingCntr},
		{"GnInitFromFile",		(FARPROC*)&cmlGnInitFromFile},
		{"MsRegisterSlave",		(FARPROC*)&cmlMsRegisterSlave},
		{"MsUnregisterSlave",	(FARPROC*)&cmlMsUnregisterSlave},
		{"MsGetMasterAxis",		(FARPROC*)&cmlMsGetMasterAxis},
		{"GnGetAlarmCode",		(FARPROC*)&cmlGnGetAlarmCode},
		{"CfgSetRotateAxis",	(FARPROC*)&cmlCfgSetRotateAxis},
		{"CfgGetRotateAxisInfo",(FARPROC*)&cmlCfgGetRotateAxisInfo},
		{"SxRMove",				(FARPROC*)&cmlSxRMove},
		{"SxRMoveStart",		(FARPROC*)&cmlSxRMoveStart},
		{"SxRMoveTo",			(FARPROC*)&cmlSxRMoveTo},
		{"SxRMoveToStart",		(FARPROC*)&cmlSxRMoveToStart},
		{"SxRSearch",			(FARPROC*)&cmlSxRSearch},
		{"SxRSearchStart",		(FARPROC*)&cmlSxRSearchStart},
		{"AdvFlsWrite",			(FARPROC*)&cmlAdvFlsWrite},
		{"AdvFlsRead",			(FARPROC*)&cmlAdvFlsRead},
		{"AdvFlsErase",			(FARPROC*)&cmlAdvFlsErase},
		{"AdvDataRW",			(FARPROC*)&cmlAdvDataRW},
		{"AdvNSet",			(FARPROC*)&cmlAdvNDbgSet},
		{"AdvNGet",			(FARPROC*)&cmlAdvNDbgGet},
		{"AdvFWSet",	(FARPROC*)&cmlAdvFWVSet},
		{"AdvFWGet",	(FARPROC*)&cmlAdvFWVGet},
		{NULL, NULL}
	};
	
	LIB_FUNCT *f;

	if((hLibrary = LoadLibrary (__DLL_FILE_FULL_PATH__)) == NULL)
	{
		OutputDebugString("\n The MLink2 SDK DLL not found");
		return FALSE;
	}

	f = &Func[0];
	while(f->ptr != NULL)
	{
		*(f->ptr) = GetProcAddress ((HMODULE)hLibrary, f->name);

#ifdef _DEBUG
		if(*(f->ptr) == NULL){
			char szMessage[1024] = "";
			sprintf(szMessage,"\n[%08s] function failed to load. LX530S Software Development Kit is incorrectly configured.",f->name);
			OutputDebugString(szMessage);
		}
#endif
		f++;
	}
	return TRUE;
}

void cmlUnloadDll(void)
{
	if(hLibrary){
		FreeLibrary(hLibrary);
		hLibrary = NULL;
	}
}

