/*******************************************************************************
* [ ComiMLink3_SDK.cpp ]
* CPP file for definitions of constants and data in Mechatrolink-3 SDK library
* - Update Data: 2016/07/08
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/
#include "stdafx.h"

#if defined(__BCPLUSPLUS__)  // Borland C++ Builder specific
 #include <vcl.h>
 #pragma hdrstop
#endif

#include <windows.h>
#include <stdio.h>

#define _DLL_MAIN_CPP_
#include "ComiMLink3_SDK.h"

#define __DLL_FILE_FULL_PATH__ "ComiMLink3.DLL"

typedef struct{
	char *name;
	FARPROC* ptr;
}LIB_FUNCT;

static HINSTANCE hLibrary=NULL;

BOOL cmcLoadDll(void)
{
	LIB_FUNCT Func[] = {

		//////////////////////////////////////////////////////////////////////////
		// Device Load / Unload
		//////////////////////////////////////////////////////////////////////////
		{"GnLoadDevice", 	(FARPROC*)&cmcGnLoadDevice},
		{"GnUnloadDevice", 	(FARPROC*)&cmcGnUnloadDevice},

		{"GnSetLogMode",	(FARPROC*)&cmcGnSetLogMode},
		{"GnGetLogMode",	(FARPROC*)&cmcGnGetLogMode},

		{"GnSetLogLevel",	(FARPROC*)&cmcGnSetLogLevel},
		{"GnGetLogLevel",	(FARPROC*)&cmcGnGetLogLevel},
		
		{"GnSetFuncLevel",	(FARPROC*)&cmcGnSetFuncLevel},
		{"GnRestoreFuncLevel",	(FARPROC*)&cmcGnRestoreFuncLevel},
		{"GnGetFuncLevel",	(FARPROC*)&cmcGnGetFuncLevel},
		
		//////////////////////////////////////////////////////////////////////////
		// COMI RTEX Raw Function
		//////////////////////////////////////////////////////////////////////////
		{"GetResources",	(FARPROC*)&cmcGetResources},
		{"WriteMemPortDW",  (FARPROC*)&cmcWriteMemPortDW},
		{"ReadMemPortDW",	(FARPROC*)&cmcReadMemPortDW},
		{"DpramRead",		(FARPROC*)&cmcDpramRead},
		{"DpramWrite",		(FARPROC*)&cmcDpramWrite},
		{"DpramBusyEnable",	(FARPROC*)&cmcDpramBusyEnable},
		{"DpramBusyDisable",	(FARPROC*)&cmcDpramBusyDisable},

		//////////////////////////////////////////////////////////////////////////
		// COMI RTEX High Level API Function
		//////////////////////////////////////////////////////////////////////////
		{"GnSetCommStates",	(FARPROC*)&cmcGnSetCommStates},
		{"GnGetCommStates", 	(FARPROC*)&cmcGnGetCommStates},

		{"GnResetComm", 	(FARPROC*)&cmcGnResetComm},
	
		{"GnSetServoOn",	(FARPROC*)&cmcGnSetServoOn},
		{"GnGetServoOn",	(FARPROC*)&cmcGnGetServoOn},

		{"GnSetAlarmRes",	(FARPROC*)&cmcGnSetAlarmRes},
		{"GnGetAlarmRes",	(FARPROC*)&cmcGnGetAlarmRes},

		{"GnSetSimulMode",	(FARPROC*)&cmcGnSetSimulMode},
		{"GnGetSimulMode",	(FARPROC*)&cmcGnGetSimulMode},

		{"GnSetEmergency",	(FARPROC*)&cmcGnSetEmergency},
		{"GnGetEmergency",	(FARPROC*)&cmcGnGetEmergency},

		{"GnSetEmergencyAll",	(FARPROC*)&cmcGnSetEmergencyAll},
		{"GnGetEmergencyAll",	(FARPROC*)&cmcGnGetEmergencyAll},

		{"GnSetCommPeriod",	(FARPROC*)&cmcGnSetCommPeriod},
		{"GnGetCommPeriod",	(FARPROC*)&cmcGnGetCommPeriod},

		{"GnResetDevice",	(FARPROC*)&cmcGnResetDevice},

		{"GnSetStatusUpdateInterval", (FARPROC*)&cmcGnSetStatusUpdateInterval},
		{"GnGetStatusUpdateInterval", (FARPROC*)&cmcGnGetStatusUpdateInterval},

		{"GnGetAxisMap", (FARPROC*)&cmcGnGetAxisMap},
		
		//////////////////////////////////////////////////////////////////////////
		// Cfg function
		//////////////////////////////////////////////////////////////////////////
		{"CfgSetMioProperty",  (FARPROC*)&cmcCfgSetMioProperty},
		{"CfgGetMioProperty",  (FARPROC*)&cmcCfgGetMioProperty},

		{"CfgSetUnitDist",	   (FARPROC*)&cmcCfgSetUnitDist},
		{"CfgGetUnitDist",	   (FARPROC*)&cmcCfgGetUnitDist},

		{"CfgSetUnitSpeed",	   (FARPROC*)&cmcCfgSetUnitSpeed},
		{"CfgGetUnitSpeed",	   (FARPROC*)&cmcCfgGetUnitSpeed},

		{"CfgSetSpeedPattern", (FARPROC*)&cmcCfgSetSpeedPattern},
		{"CfgGetSpeedPattern", (FARPROC*)&cmcCfgGetSpeedPattern},

		{"CfgSetSoftLimit",	   (FARPROC*)&cmcCfgSetSoftLimit},
		{"CfgGetSoftLimit",	   (FARPROC*)&cmcCfgGetSoftLimit},

		{"CfgSetSvonDevRange", (FARPROC*)&cmcCfgSetSvonDevRange},
		{"CfgGetSvonDevRange", (FARPROC*)&cmcCfgGetSvonDevRange},

		//////////////////////////////////////////////////////////////////////////
		// Sx Control
		//////////////////////////////////////////////////////////////////////////
		{"SxMove",			(FARPROC*)&cmcSxMove},
		{"SxMoveStart",		(FARPROC*)&cmcSxMoveStart},
		{"SxMoveTo",		(FARPROC*)&cmcSxMoveTo},
		{"SxMoveToStart",	(FARPROC*)&cmcSxMoveToStart},
		{"SxVMoveStart",	(FARPROC*)&cmcSxVMoveStart},
		{"SxStop",          (FARPROC*)&cmcSxStop},
		{"SxStopEmg",       (FARPROC*)&cmcSxStopEmg},
		{"SxIsDone",		(FARPROC*)&cmcSxIsDone},
		{"SxWaitDone",		(FARPROC*)&cmcSxWaitDone},

		{"SxSetCorrection", (FARPROC*)&cmcSxSetCorrection},
		{"SxGetCorrection", (FARPROC*)&cmcSxGetCorrection},

		//////////////////////////////////////////////////////////////////////////
		// Mx Control
		//////////////////////////////////////////////////////////////////////////
		{"MxMove",			(FARPROC*)&cmcMxMove},
		{"MxMoveStart",		(FARPROC*)&cmcMxMoveStart},
		{"MxMoveTo",		(FARPROC*)&cmcMxMoveTo},
		{"MxMoveToStart",	(FARPROC*)&cmcMxMoveToStart},
		{"MxVMoveStart",	(FARPROC*)&cmcMxVMoveStart},
		{"MxStop",			(FARPROC*)&cmcMxStop},
		{"MxStopEmg",		(FARPROC*)&cmcMxStopEmg},
		{"MxIsDone",		(FARPROC*)&cmcMxIsDone},
		{"MxWaitDone",		(FARPROC*)&cmcMxWaitDone},

		//////////////////////////////////////////////////////////////////////////
		// Ix Control
		//////////////////////////////////////////////////////////////////////////
		{"IxMapAxes",		 (FARPROC*)&cmcIxMapAxes},
		{"IxUnMapAxes",		 (FARPROC*)&cmcIxUnMapAxes},
		
		{"IxSetSpeedPattern",(FARPROC*)&cmcIxSetSpeedPattern},
		{"IxGetSpeedPattern",(FARPROC*)&cmcIxGetSpeedPattern},
		
		{"IxLine",			 (FARPROC*)&cmcIxLine},
		{"IxLineStart",		 (FARPROC*)&cmcIxLineStart},

		{"IxLineTo",		 (FARPROC*)&cmcIxLineTo},
		{"IxLineToStart",	 (FARPROC*)&cmcIxLineToStart},

		{"IxArcA",			 (FARPROC*)&cmcIxArcA},
		{"IxArcAStart",		 (FARPROC*)&cmcIxArcAStart},

		{"IxArcATo",		 (FARPROC*)&cmcIxArcATo},
		{"IxArcAToStart",	 (FARPROC*)&cmcIxArcAToStart},

		{"IxArcP",			 (FARPROC*)&cmcIxArcP},
		{"IxArcPStart",		 (FARPROC*)&cmcIxArcPStart},

		{"IxArcPTo",		 (FARPROC*)&cmcIxArcPTo},
		{"IxArcPToStart",	 (FARPROC*)&cmcIxArcPToStart},

		{"IxArc3P",			 (FARPROC*)&cmcIxArc3P},
		{"IxArc3PStart",	 (FARPROC*)&cmcIxArc3PStart},

		{"IxArc3PTo",		 (FARPROC*)&cmcIxArc3PTo},
		{"IxArc3PToStart",	 (FARPROC*)&cmcIxArc3PToStart},

		{"IxIsDone",		 (FARPROC*)&cmcIxIsDone},
		{"IxWaitDone",		 (FARPROC*)&cmcIxWaitDone},

		{"IxStop",			 (FARPROC*)&cmcIxStop},
		{"IxStopEmg",		 (FARPROC*)&cmcIxStopEmg},

		{"IxHelOnceStart",	 (FARPROC*)&cmcIxHelOnceStart},
		{"IxSplineStart",    (FARPROC*)&cmcIxSplineStart},
		
		{"IxGetMapIndex",	 (FARPROC*)&cmcIxGetMapIndex},

		{"IxGetMapIndex",	 (FARPROC*)&cmcIxGetMapIndex},

		//////////////////////////////////////////////////////////////////////////
		// Return To Home
		//////////////////////////////////////////////////////////////////////////
		{"HomeSetConfig",		(FARPROC*)&cmcHomeSetConfig},
		{"HomeGetConfig",		(FARPROC*)&cmcHomeGetConfig},

		{"HomeSetPosClrMode",	(FARPROC*)&cmcHomeSetPosClrMode},
		{"HomeGetPosClrMode",	(FARPROC*)&cmcHomeGetPosClrMode},

		{"HomeSetSpeedPattern",	(FARPROC*)&cmcHomeSetSpeedPattern},
		{"HomeGetSpeedPattern",	(FARPROC*)&cmcHomeGetSpeedPattern},

		{"HomeMove",			(FARPROC*)&cmcHomeMove},
		{"HomeMoveStart",		(FARPROC*)&cmcHomeMoveStart},

		{"HomeMoveAll",			(FARPROC*)&cmcHomeMoveAll},
		{"HomeMoveAllStart",	(FARPROC*)&cmcHomeMoveAllStart},

		{"HomeIsBusy",			(FARPROC*)&cmcHomeIsBusy},
		{"HomeWaitDone",		(FARPROC*)&cmcHomeWaitDone},

		{"HomeSetSuccess",		(FARPROC*)&cmcHomeSetSuccess},
		{"HomeGetSuccess",	    (FARPROC*)&cmcHomeGetSuccess},

		//////////////////////////////////////////////////////////////////////////
		// Override
		//////////////////////////////////////////////////////////////////////////
		{"OverrideSpeedSet",	(FARPROC*)&cmcOverrideSpeedSet},
		{"OverrideMove",		(FARPROC*)&cmcOverrideMove},
		{"OverrideMoveTo",		(FARPROC*)&cmcOverrideMoveTo},

		//////////////////////////////////////////////////////////////////////////
		// Listed Motion
		//////////////////////////////////////////////////////////////////////////
		{"LmxStart",			(FARPROC*)&cmcLmxStart},
		{"LmxSuspend",			(FARPROC*)&cmcLmxSuspend},
		{"LmxResume",			(FARPROC*)&cmcLmxResume},
		{"LmxEnd",				(FARPROC*)&cmcLmxEnd},
		{"LmxGetStates",		(FARPROC*)&cmcLmxGetStates},

		{"LmxSetSeqMode",		(FARPROC*)&cmcLmxSetSeqMode},
		{"LmxGetSeqMode",		(FARPROC*)&cmcLmxGetSeqMode},

		{"LmxSetNextItemId",	(FARPROC*)&cmcLmxSetNextItemId},
		{"LmxGetNextItemId",	(FARPROC*)&cmcLmxGetNextItemId},
		
		{"LmxSetNextItemParam",	(FARPROC*)&cmcLmxSetNextItemParam},
		{"LmxGetNextItemParam", (FARPROC*)&cmcLmxGetNextItemParam},

		{"LmxGetRunItemParam",	(FARPROC*)&cmcLmxGetRunItemParam},
		{"LmxGetRunItemStaPos", (FARPROC*)&cmcLmxGetRunItemStaPos},
		{"LmxGetRunItemTargPos",(FARPROC*)&cmcLmxGetRunItemTargPos},
		
		{"LmxSetSeqId",			(FARPROC*)&cmcLmxSetSeqId},
		{"LmxGetSeqId",			(FARPROC*)&cmcLmxGetSeqId},
		
		//////////////////////////////////////////////////////////////////////////
		// Master-Slave
		//////////////////////////////////////////////////////////////////////////
		{"MsRegisterSlave",		(FARPROC*)&cmcMsRegisterSlave},
		{"MsUnregisterSlave",	(FARPROC*)&cmcMsUnregisterSlave},
		{"MsGetMasterAxis",		(FARPROC*)&cmcMsGetMasterAxis},
		
		//////////////////////////////////////////////////////////////////////////
		// Status Monitoring
		//////////////////////////////////////////////////////////////////////////
		{"StSetCount",          (FARPROC*)&cmcStSetCount},
		{"StGetCount",			(FARPROC*)&cmcStGetCount},

		{"StSetPosition",       (FARPROC*)&cmcStSetPosition},
		{"StGetPosition",		(FARPROC*)&cmcStGetPosition},

		{"StGetSpeed",			(FARPROC*)&cmcStGetSpeed},
		{"StGetTorque",			(FARPROC*)&cmcStGetTorque},

		{"StSxReadMotionState", (FARPROC*)&cmcStSxReadMotionState},
		{"StIxReadMotionState", (FARPROC*)&cmcStIxReadMotionState},

		{"StReadMioStatuses",	(FARPROC*)&cmcStReadMioStatuses},
		{"StGetMotionMode",		(FARPROC*)&cmcStGetMotionMode},

		{"StSxGetLastError",	(FARPROC*)&cmcStSxGetLastError},
		{"StIxGetLastError",	(FARPROC*)&cmcStIxGetLastError},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (GN)
		//////////////////////////////////////////////////////////////////////////
		{"GnGetNodeInfo",		(FARPROC*)&cmcGnGetNodeInfo},
		{"GnTotalDIOChannel",	(FARPROC*)&cmcGnTotalDIOChannel},
		{"GnTotalAIChannel",	(FARPROC*)&cmcGnTotalAIChannel},
		{"GnTotalAOChannel",	(FARPROC*)&cmcGnTotalAOChannel},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (DI)
		//////////////////////////////////////////////////////////////////////////
		{"DiGetLogic",			(FARPROC*)&cmcDiGetLogic},
		{"DiSetLogic",			(FARPROC*)&cmcDiSetLogic},
		{"DiGetLogicMulti",		(FARPROC*)&cmcDiGetLogicMulti},
		{"DiSetLogicMulti",		(FARPROC*)&cmcDiSetLogicMulti},
		{"DiGetOne",			(FARPROC*)&cmcDiGetOne},
		{"DiGetMulti",			(FARPROC*)&cmcDiGetMulti},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (DO)
		//////////////////////////////////////////////////////////////////////////
		{"DoGetLogic",			(FARPROC*)&cmcDoGetLogic},
		{"DoSetLogic",			(FARPROC*)&cmcDoSetLogic},
		{"DoGetLogicMulti",		(FARPROC*)&cmcDoGetLogicMulti},
		{"DoSetLogicMulti",		(FARPROC*)&cmcDoSetLogicMulti},
		{"DoPutOne",			(FARPROC*)&cmcDoPutOne},
		{"DoGetOne",			(FARPROC*)&cmcDoGetOne},
		{"DoPutMulti",			(FARPROC*)&cmcDoPutMulti},
		{"DoGetMulti",			(FARPROC*)&cmcDoGetMulti},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (DIO)
		//////////////////////////////////////////////////////////////////////////
		{"DioGetIomode",		(FARPROC*)&cmcDioGetIomode},
		{"DioSetIomode",		(FARPROC*)&cmcDioSetIomode},
		{"DioGetIomodeMulti",	(FARPROC*)&cmcDioGetIomodeMulti},
		{"DioSetIomodeMulti",	(FARPROC*)&cmcDioSetIomodeMulti},
		{"DioGetLogic",			(FARPROC*)&cmcDioGetLogic},
		{"DioSetLogic",			(FARPROC*)&cmcDioSetLogic},
		{"DioGetLogicMulti",	(FARPROC*)&cmcDioGetLogicMulti},
		{"DioSetLogicMulti",	(FARPROC*)&cmcDioSetLogicMulti},
		{"DioPutOne",			(FARPROC*)&cmcDioPutOne},
		{"DioGetOne",			(FARPROC*)&cmcDioGetOne},
		{"DioPutMulti",			(FARPROC*)&cmcDioPutMulti},
		{"DioGetMulti",			(FARPROC*)&cmcDioGetMulti},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (AI)
		//////////////////////////////////////////////////////////////////////////
		{"AiSetVoltRangeMode",	(FARPROC*)&cmcAiSetVoltRangeMode},
		{"AiGetVoltRangeMode",	(FARPROC*)&cmcAiGetVoltRangeMode},
		{"AiGetRangeDigit",		(FARPROC*)&cmcAiGetRangeDigit},
		{"AiGetDigit",			(FARPROC*)&cmcAiGetDigit},
		{"AiGetVolt",			(FARPROC*)&cmcAiGetVolt},
		{"AiGetCurrent",		(FARPROC*)&cmcAiGetCurrent},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (AO)
		//////////////////////////////////////////////////////////////////////////
		{"AoOutDigit",			(FARPROC*)&cmcAoOutDigit},
		{"AoOutVolt",			(FARPROC*)&cmcAoOutVolt},
		{"AoOutCurrent",		(FARPROC*)&cmcAoOutCurrent},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-GN)
		//////////////////////////////////////////////////////////////////////////
		{"PmGnSetServoOn",		(FARPROC*)&cmcPmGnSetServoOn},
		{"PmGnGetServoOn",		(FARPROC*)&cmcPmGnGetServoOn},
		{"PmGnAlarmReset",		(FARPROC*)&cmcPmGnAlarmReset},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-CFG)
		//////////////////////////////////////////////////////////////////////////
		{"PmCfgSetMioProperty",	(FARPROC*)&cmcPmCfgSetMioProperty},
		{"PmCfgGetMioProperty",	(FARPROC*)&cmcPmCfgGetMioProperty},
		{"PmCfgSetFilter",		(FARPROC*)&cmcPmCfgSetFilter},
		{"PmCfgGetFilter",		(FARPROC*)&cmcPmCfgGetFilter},
		{"PmCfgSetFilterAB",	(FARPROC*)&cmcPmCfgSetFilterAB},
		{"PmCfgGetFilterAB",	(FARPROC*)&cmcPmCfgGetFilterAB},
		{"PmCfgSetInMode",		(FARPROC*)&cmcPmCfgSetInMode},
		{"PmCfgGetInMode",		(FARPROC*)&cmcPmCfgGetInMode},
		{"PmCfgSetOutMode",		(FARPROC*)&cmcPmCfgSetOutMode},
		{"PmCfgGetOutMode",		(FARPROC*)&cmcPmCfgGetOutMode},
		{"PmCfgSetCtrlMode",	(FARPROC*)&cmcPmCfgSetCtrlMode},
		{"PmCfgGetCtrlMode",	(FARPROC*)&cmcPmCfgGetCtrlMode},
		{"PmCfgSetInOutRatio",	(FARPROC*)&cmcPmCfgSetInOutRatio},
		{"PmCfgGetInOutRatio",	(FARPROC*)&cmcPmCfgGetInOutRatio},
		{"PmCfgSetUnitDist",	(FARPROC*)&cmcPmCfgSetUnitDist},
		{"PmCfgGetUnitDist",	(FARPROC*)&cmcPmCfgGetUnitDist},
		{"PmCfgSetUnitSpeed",	(FARPROC*)&cmcPmCfgSetUnitSpeed},
		{"PmCfgGetUnitSpeed",	(FARPROC*)&cmcPmCfgGetUnitSpeed},
		{"PmCfgSetSpeedRange",	(FARPROC*)&cmcPmCfgSetSpeedRange},
		{"PmCfgGetSpeedRange",	(FARPROC*)&cmcPmCfgGetSpeedRange},
		{"PmCfgSetSpeedPattern",	(FARPROC*)&cmcPmCfgSetSpeedPattern},
		{"PmCfgGetSpeedPattern",	(FARPROC*)&cmcPmCfgGetSpeedPattern},
		{"PmCfgSetSoftLimit",	(FARPROC*)&cmcPmCfgSetSoftLimit},
		{"PmCfgGetSoftLimit",	(FARPROC*)&cmcPmCfgGetSoftLimit},
		{"PmCfgSetRingCntr",	(FARPROC*)&cmcPmCfgSetRingCntr},
		{"PmCfgGetRingCntr",	(FARPROC*)&cmcPmCfgGetRingCntr},
		{"PmCfgSetVelCorrRatio",	(FARPROC*)&cmcPmCfgSetVelCorrRatio},
		{"PmCfgGetVelCorrRatio",	(FARPROC*)&cmcPmCfgGetVelCorrRatio},
		{"PmCfgSetSeqMode",		(FARPROC*)&cmcPmCfgSetSeqMode},
		{"PmCfgGetSeqMode",		(FARPROC*)&cmcPmCfgGetSeqMode},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-HOME)
		//////////////////////////////////////////////////////////////////////////
		{"PmHomeSetConfig",		(FARPROC*)&cmcPmHomeSetConfig},
		{"PmHomeGetConfig",		(FARPROC*)&cmcPmHomeGetConfig},
		{"PmHomeSetPosClrMode",	(FARPROC*)&cmcPmHomeSetPosClrMode},
		{"PmHomeGetPosClrMode",	(FARPROC*)&cmcPmHomeGetPosClrMode},
		{"PmHomeSetSpeedPattern",	(FARPROC*)&cmcPmHomeSetSpeedPattern},
		{"PmHomeGetSpeedPattern",	(FARPROC*)&cmcPmHomeGetSpeedPattern},
		{"PmHomeMoveStart",		(FARPROC*)&cmcPmHomeMoveStart},
		{"PmHomeMoveAllStart",	(FARPROC*)&cmcPmHomeMoveAllStart},
		{"PmHomeSetSuccess",	(FARPROC*)&cmcPmHomeSetSuccess},
		{"PmHomeGetSuccess",	(FARPROC*)&cmcPmHomeGetSuccess},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-SX)
		//////////////////////////////////////////////////////////////////////////
		{"PmSxSetSpeedRatio",	(FARPROC*)&cmcPmSxSetSpeedRatio},
		{"PmSxGetSpeedRatio",	(FARPROC*)&cmcPmSxGetSpeedRatio},
		{"PmSxMoveStart",		(FARPROC*)&cmcPmSxMoveStart},
		{"PmSxMove",		(FARPROC*)&cmcPmSxMove},
		{"PmSxMoveToStart",		(FARPROC*)&cmcPmSxMoveToStart},
		{"PmSxMoveTo",		(FARPROC*)&cmcPmSxMoveTo},
		{"PmSxVMoveStart",		(FARPROC*)&cmcPmSxVMoveStart},
		{"PmSxStop",			(FARPROC*)&cmcPmSxStop},
		{"PmSxStopEmg",			(FARPROC*)&cmcPmSxStopEmg},
		{"PmSxIsDone",		(FARPROC*)&cmcPmSxIsDone},
		{"PmSxWaitDone",		(FARPROC*)&cmcPmSxWaitDone},
		{"PmSxGetTargetPos",	(FARPROC*)&cmcPmSxGetTargetPos},
		{"PmSxSetOptIniSpeed",	(FARPROC*)&cmcPmSxSetOptIniSpeed},
		{"PmSxGetOptIniSpeed",	(FARPROC*)&cmcPmSxGetOptIniSpeed},
		{"PmSxSetOptRdpOffset",	(FARPROC*)&cmcPmSxSetOptRdpOffset},
		{"PmSxGetOptRdpOffset",	(FARPROC*)&cmcPmSxGetOptRdpOffset},
		{"PmSxSetCorrection",	(FARPROC*)&cmcPmSxSetCorrection},
		{"PmSxGetCorrection",	(FARPROC*)&cmcPmSxGetCorrection},
		{"PmSxSetOptSyncMode",	(FARPROC*)&cmcPmSxSetOptSyncMode},
		{"PmSxGetOptSyncMode",	(FARPROC*)&cmcPmSxGetOptSyncMode},
		{"PmSxSetOptSyncOut",	(FARPROC*)&cmcPmSxSetOptSyncOut},
		{"PmSxGetOptSyncOut",	(FARPROC*)&cmcPmSxGetOptSyncOut},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-MX)
		//////////////////////////////////////////////////////////////////////////
		{"PmMxMoveStart",		(FARPROC*)&cmcPmMxMoveStart},
		{"PmMxMove",		(FARPROC*)&cmcPmMxMove},
		{"PmMxMoveToStart",		(FARPROC*)&cmcPmMxMoveToStart},
		{"PmMxMoveTo",		(FARPROC*)&cmcPmMxMoveTo},
		{"PmMxVMoveStart",		(FARPROC*)&cmcPmMxVMoveStart},
		{"PmMxStop",			(FARPROC*)&cmcPmMxStop},
		{"PmMxStopEmg",			(FARPROC*)&cmcPmMxStopEmg},
		{"PmMxIsDone",		(FARPROC*)&cmcPmMxIsDone},
		{"PmMxWaitDone",		(FARPROC*)&cmcPmMxWaitDone},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-IX)
		//////////////////////////////////////////////////////////////////////////
		{"PmIxMapAxes",			(FARPROC*)&cmcPmIxMapAxes},
		{"PmIxUnMapAxes",		(FARPROC*)&cmcPmIxUnMapAxes},
		{"PmIxSetVelCorrMode",	(FARPROC*)&cmcPmIxSetVelCorrMode},
		{"PmIxGetVelCorrMode",	(FARPROC*)&cmcPmIxGetVelCorrMode},
		{"PmIxSetSpeedPattern",	(FARPROC*)&cmcPmIxSetSpeedPattern},
		{"PmIxGetSpeedPattern",	(FARPROC*)&cmcPmIxGetSpeedPattern},
		{"PmIxLineStart",		(FARPROC*)&cmcPmIxLineStart},
		{"PmIxLineToStart",		(FARPROC*)&cmcPmIxLineToStart},
		{"PmIxArcAStart",		(FARPROC*)&cmcPmIxArcAStart},
		{"PmIxArcAToStart",		(FARPROC*)&cmcPmIxArcAToStart},
		{"PmIxArcPStart",		(FARPROC*)&cmcPmIxArcPStart},
		{"PmIxArcPToStart",		(FARPROC*)&cmcPmIxArcPToStart},
		{"PmIxArc3PStart",		(FARPROC*)&cmcPmIxArc3PStart},
		{"PmIxArc3PToStart",	(FARPROC*)&cmcPmIxArc3PToStart},
		{"PmIxStop",			(FARPROC*)&cmcPmIxStop},
		{"PmIxStopEmg",			(FARPROC*)&cmcPmIxStopEmg},
		{"PmIxIsDone",			(FARPROC*)&cmcPmIxIsDone},
		{"PmIxWaitDone",		(FARPROC*)&cmcPmIxWaitDone},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-OVERRIDE)
		//////////////////////////////////////////////////////////////////////////
		{"PmOverrideSpeedSet",	(FARPROC*)&cmcPmOverrideSpeedSet},
		{"PmOverrideSpeedSetAll",	(FARPROC*)&cmcPmOverrideSpeedSetAll},
		{"PmOverrideMove",		(FARPROC*)&cmcPmOverrideMove},
		{"PmOverrideMoveTo",	(FARPROC*)&cmcPmOverrideMoveTo},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-ST)
		//////////////////////////////////////////////////////////////////////////
		{"PmStSetCount",		(FARPROC*)&cmcPmStSetCount},
		{"PmStGetCount",		(FARPROC*)&cmcPmStGetCount},
		{"PmStSetPosition",		(FARPROC*)&cmcPmStSetPosition},
		{"PmStGetPosition",		(FARPROC*)&cmcPmStGetPosition},
		{"PmStGetSpeed",		(FARPROC*)&cmcPmStGetSpeed},
		{"PmStReadMotionState",	(FARPROC*)&cmcPmStReadMotionState},
		{"PmStReadMIOStatus",	(FARPROC*)&cmcPmStReadMIOStatus},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-LTC)
		//////////////////////////////////////////////////////////////////////////
		{"PmLtcIsLatched",		(FARPROC*)&cmcPmLtcIsLatched},
		{"PmLtcReadLatch",		(FARPROC*)&cmcPmLtcReadLatch},

		//////////////////////////////////////////////////////////////////////////
		// Advanced Functions
		//////////////////////////////////////////////////////////////////////////
		{"AdvFwGetVersion",		(FARPROC*)&cmcAdvFwGetVersion},
		{"AdvFwGetSystemState",	(FARPROC*)&cmcAdvFwGetSystemState},
		{"AdvFwDnFrame",		(FARPROC*)&cmcAdvFwDnFrame},
		{"AdvFwDnFrameVerify",	(FARPROC*)&cmcAdvFwDnFrameVerify},		
		{"AdvFwSystemReset",	(FARPROC*)&cmcAdvFwSystemReset},
		{"AdvFwSetFwuBit",		(FARPROC*)&cmcAdvFwSetFwuBit},
		{"AdvFwGetFwuBit",		(FARPROC*)&cmcAdvFwGetFwuBit},
		{"AdvFwSetBootFlag",	(FARPROC*)&cmcAdvFwSetBootFlag},
		{"AdvFwGetBootFlag",	(FARPROC*)&cmcAdvFwGetBootFlag},
		{"AdvFwUpdateMode",		(FARPROC*)&cmcAdvFwUpdateMode},
		{"AdvM3NodeCfgRead",	(FARPROC*)&cmcAdvM3NodeCfgRead},
		{"AdvM3NodeCfgWrite",	(FARPROC*)&cmcAdvM3NodeCfgWrite},
		{"AdvSetRtsEnable",		(FARPROC*)&cmcAdvSetRtsEnable},
		{"AdvGetRtsEnable",		(FARPROC*)&cmcAdvGetRtsEnable},
		{"AdvSetRtsMode",		(FARPROC*)&cmcAdvSetRtsMode},
		{"AdvGetRtsMode",		(FARPROC*)&cmcAdvGetRtsMode},
		{"AdvGetRtsMemPtr",		(FARPROC*)&cmcAdvGetRtsMemPtr},
		{"AdvSetRtsUpdateInterval",		(FARPROC*)&cmcAdvSetRtsUpdateInterval},
		{"AdvGetRtsUpdateInterval",		(FARPROC*)&cmcAdvGetRtsUpdateInterval},
		{"GnSetABSMode",		(FARPROC*)&cmcGnSetABSMode},
		{"GnGetABSMode",		(FARPROC*)&cmcGnGetABSMode},
		{"GnABSUpdate",			(FARPROC*)&cmcGnABSUpdate},
		{"GnSetABSHome",		(FARPROC*)&cmcGnSetABSHome},
		
		{"SxCfg_PosCorr_SetTableSize",			(FARPROC*)&cmcSxCfg_PosCorr_SetTableSize},
		{"SxCfg_PosCorr_GetTableSize",			(FARPROC*)&cmcSxCfg_PosCorr_GetTableSize},
		{"SxCfg_PosCorr_SetTableData",			(FARPROC*)&cmcSxCfg_PosCorr_SetTableData},
		{"SxCfg_PosCorr_GetTableData",			(FARPROC*)&cmcSxCfg_PosCorr_GetTableData},
		{"SxCfg_PosCorr_SetEnable",				(FARPROC*)&cmcSxCfg_PosCorr_SetEnable},
		{"SxCfg_PosCorr_GetEnable",				(FARPROC*)&cmcSxCfg_PosCorr_GetEnable},		
		{"SxCfg_PosCorr_ClearTable",			(FARPROC*)&cmcSxCfg_PosCorr_ClearTable},		
		{"SxCfg_PosCorr_SetTableFromFile",		(FARPROC*)&cmcSxCfg_PosCorr_SetTableFromFile},
		
		{"SxCfg_PosCorr2D_Reset",				(FARPROC*)&cmcSxCfg_PosCorr2D_Reset},
		{"SxCfg_PosCorr2D_SetTableHeader",		(FARPROC*)&cmcSxCfg_PosCorr2D_SetTableHeader},
		{"SxCfg_PosCorr2D_GetTableHeader",		(FARPROC*)&cmcSxCfg_PosCorr2D_GetTableHeader},
		{"SxCfg_PosCorr2D_SetTableData",		(FARPROC*)&cmcSxCfg_PosCorr2D_SetTableData},
		{"SxCfg_PosCorr2D_GetTableData",		(FARPROC*)&cmcSxCfg_PosCorr2D_GetTableData},	
		{"SxCfg_PosCorr2D_SetTableFromFile",	(FARPROC*)&cmcSxCfg_PosCorr2D_SetTableFromFile},		
		{"SxCfg_PosCorr2D_SetEnable",			(FARPROC*)&cmcSxCfg_PosCorr2D_SetEnable},
		{"SxCfg_PosCorr2D_GetEnable",			(FARPROC*)&cmcSxCfg_PosCorr2D_GetEnable},	
		
		{"StGetCount_Corr",			(FARPROC*)&cmcStGetCount_Corr},	
		{"StGetPosition_Corr",			(FARPROC*)&cmcStGetPosition_Corr},	
		
		{NULL, NULL}
	};
	
	LIB_FUNCT *f;

	if((hLibrary = LoadLibrary (__DLL_FILE_FULL_PATH__)) == NULL)
	{
		OutputDebugString("\n The LX530SDK DLL not found");
		return FALSE;
	}

	f = &Func[0];
	while(f->ptr != NULL)
	{
		*(f->ptr) = GetProcAddress ((HMODULE)hLibrary, f->name);

#ifdef _DEBUG
		if(*(f->ptr) == NULL){
			char szMessage[1024] = "";
			sprintf(szMessage,"\n[%08s] function failed to load. LX530 Software Development Kit is incorrectly configured.",f->name);
			OutputDebugString(szMessage);
		}
#endif
		f++;
	}
	return TRUE;
}

void cmcUnloadDll(void)
{
	if(hLibrary){
		FreeLibrary(hLibrary);
		hLibrary = NULL;
	}
}

