/*******************************************************************************
* [ ComiLX530SDK.h ]
* Header file for definitions of constants and data in LX530 library
* - Update Data: 2016/07/08
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#ifndef __COMI_LX530_SDK_H__
#define __COMI_LX530_SDK_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ComiMLink3_SDK_Def.h"

#if !defined(__in)
#define __in
#endif

#if !defined(__in_opt)
#define __in_opt
#endif

#if !defined(__out)
#define __out
#endif

#if !defined(__out_opt)
#define __out_opt
#endif

#if !defined(__inout)
#define	__inout
#endif

#ifdef __cplusplus
extern "C"{
#endif

#ifdef _DLL_MAIN_CPP_
	#define EXTERN 
#else 
	#define EXTERN extern
#endif

//////////////////////////////////////////////////////////////////////////
// External Functions for DLL(Dynamic Link Library)
//////////////////////////////////////////////////////////////////////////
BOOL cmcLoadDll();
VOID cmcUnloadDll();


//////////////////////////////////////////////////////////////////////////
// Device Load / Unload
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 IsResetDevice : ̽ ʱȭմϴ, [OUT] VT_PI4 NumServos : ˻   ȯմϴ.  Ķʹ NULL  մϴ.
EXTERN LONG 	(WINAPI *cmcGnLoadDevice)		(__out PLONG NumDevices, __out PLONG BoardIdList, __out_opt PLONG NumServos);
EXTERN LONG 	(WINAPI *cmcGnUnloadDevice) 		();

EXTERN LONG	(WINAPI *cmcGnSetLogMode)		(__in  LONG LogMode);
EXTERN LONG	(WINAPI *cmcGnGetLogMode)		(__out PLONG LogMode);

EXTERN LONG	(WINAPI *cmcGnSetLogLevel)		(__in  LONG LogLevel);
EXTERN LONG	(WINAPI *cmcGnGetLogLevel)		(__out PLONG LogLevel);

EXTERN LONG	(WINAPI *cmcGnSetFuncLevel)		(__in LONG FuncIndex, __in  LONG LogLevel);
EXTERN LONG	(WINAPI *cmcGnRestoreFuncLevel)	(__in LONG FuncIndex);
EXTERN LONG	(WINAPI *cmcGnGetFuncLevel)		(__in LONG FuncIndex, __out PLONG LogLevel);

EXTERN LONG (WINAPI *cmcDpramRead)			(LONG BoardId, LONG StartAddr, LONG Size, PBYTE pBuffer);
EXTERN LONG (WINAPI *cmcDpramWrite)			(LONG BoardId, LONG StartAddr, LONG Size, PBYTE pBuffer);
EXTERN LONG (WINAPI *cmcDpramBusyEnable)	(LONG BoardId, LONG SectId, LONG IsWaitEnable, LONG TimeoutVal);
EXTERN LONG (WINAPI *cmcDpramBusyDisable)	(LONG BoardId, LONG SectId); 

//////////////////////////////////////////////////////////////////////////
// Low Level API for Debugging
//////////////////////////////////////////////////////////////////////////
EXTERN VOID		(WINAPI *cmcGetResources)		(__in LONG BoardId, __out PULONG pdwIntVect, __out PULONG pdwIoPorts, __in INT nNumPorts, __out PULONG pdwMemPorts, __in INT nNumMemPorts);
EXTERN VOID 	(WINAPI *cmcWriteMemPortDW)		(__in LONG BoardId, __in  ULONG dwPortBase, __in ULONG nOffset, __in LONG dwWriteVal);
EXTERN DWORD	(WINAPI *cmcReadMemPortDW)		(__in LONG BoardId, __in  ULONG dwPortBase, __in ULONG nOffset, __out PLONG pdwReadVal);

//////////////////////////////////////////////////////////////////////////
// General Functions
//////////////////////////////////////////////////////////////////////////

EXTERN  LONG    (WINAPI *cmcGnSetCommStates)		(__in LONG BoardId, __in LONG Axis, __in LONG cmStsId, __in  LONG CommStsVal);
EXTERN  LONG    (WINAPI *cmcGnGetCommStates)		(__in LONG BoardId, __in LONG Axis, __in LONG cmStsId, __out PLONG CommStsVal);

EXTERN  LONG    (WINAPI *cmcGnResetComm)		(__in LONG BoardId);


// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 dwIsOn :  ¸ մϴ.   (1: , 0: )
EXTERN	LONG	(WINAPI *cmcGnSetServoOn)		(__in LONG BoardId, __in	LONG Axis, __in LONG  dwIsOn);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 dwIsOn :  ¸ ȯմϴ. (1: , 0: )
EXTERN	LONG	(WINAPI *cmcGnGetServoOn)		(__in LONG BoardId, __in	LONG Axis, __out PLONG pdwIsOn);

EXTERN  LONG	(WINAPI *cmcGnSetAlarmRes)		(__in LONG BoardId, __in   LONG Axis);
EXTERN  LONG 	(WINAPI *cmcGnGetAlarmRes)		(__in LONG BoardId, __in	LONG Axis, __out LONG * IsReset);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsSimulMode : ùķ̼  Ȱȭ θ մϴ.   (1: ùķ̼  Ȱȭ, 0: ùķ̼  Ȱȭ)
EXTERN	LONG	(WINAPI *cmcGnSetSimulMode)		(__in LONG BoardId, __in	LONG Axis, __in  LONG  SimulMode);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 IsSimulMode : ùķ̼  Ȱȭ θ ȯմϴ.   (1: ùķ̼  Ȱȭ, 0: ùķ̼  Ȱȭ)
EXTERN	LONG	(WINAPI *cmcGnGetSimulMode)		(__in LONG BoardId, __in	LONG Axis, __out PLONG SimulMode);

EXTERN	LONG	(WINAPI *cmcGnSetEmergency)		(__in LONG BoardId, __in	LONG Axis, __in LONG IsDecStop, __in LONG IsEnable);
EXTERN	LONG	(WINAPI *cmcGnGetEmergency)		(__in LONG BoardId, __in	LONG Axis, __out PLONG IsDecStopped, __out PLONG IsEnabled);
EXTERN	LONG	(WINAPI *cmcGnSetEmergencyAll)		(__in   LONG IsDecStop, __in	LONG IsEnable);
EXTERN	LONG	(WINAPI *cmcGnGetEmergencyAll)		(__out  LONG * IsDecStopped, __out	PLONG IsEnabled);

// (NEMO) Sampling Period  Ǵ ȯմϴ.
// [IN] nPeriod
EXTERN LONG	(WINAPI *cmcGnSetCommPeriod)		(__in LONG BoardId, __in LONG nPeriod);

// (NEMO) Sampling Period Flashκ о´.
// [OUT] nPeriod
EXTERN LONG	(WINAPI *cmcGnGetCommPeriod)		(__in LONG BoardId, __out PLONG nPeriod);

EXTERN	LONG	(WINAPI *cmcGnResetDevice)		(__in LONG BoardId, __in	LONG ResetMask);

// [IN] VT_I4 dwInterval : Ʈ ֱ (500usec Unit)
EXTERN  LONG	(WINAPI *cmcGnSetStatusUpdateInterval)	(__in LONG BoardId, __in	LONG dwInterval);
EXTERN	LONG	(WINAPI *cmcGnGetStatusUpdateInterval)	(__in LONG BoardId, __out	PLONG dwInterval);

// [OUT] AxisMapMask
EXTERN	LONG	(WINAPI *cmcGnGetAxisMap)		(__in LONG BoardId, __out	LONG* AxisMapMask);

// Network Servo Ķ͸ ϰ ȯմϴ.
EXTERN LONG	(WINAPI *cmcGnSetParam520)				();
EXTERN LONG	(WINAPI *cmcGnGetParam520)				();

EXTERN LONG	(WINAPI *cmcGnSetParam530)				();
EXTERN LONG	(WINAPI *cmcGnGetParam530)				();

EXTERN LONG	(WINAPI *cmcGnSetParam540)				(__in LONG BoardId, __in LONG Axis, __in LONG PrmNo1, __in LONG PrmData1, __in LONG PrmNo2, __in LONG PrmData2);
EXTERN LONG	(WINAPI *cmcGnGetParam540)				(__in LONG BoardId, __in LONG Axis, __in LONG PrmNo1, __out PLONG pPrmData1, __in LONG PrmNo2, __out PLONG pPrmData2);

//////////////////////////////////////////////////////////////////////////
// Cfg Functions
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PropId :  id մϴ, [IN] VT_I4 PropVal :  id 
EXTERN	LONG	(WINAPI *cmcCfgSetMioProperty)		(__in LONG BoardId, __in	LONG Axis, __in LONG PropId, __in  LONG  PropVal);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PropId :  id մϴ, [OUT] VT_PI4 PropVal :  id 
EXTERN	LONG	(WINAPI *cmcCfgGetMioProperty)		(__in LONG BoardId, __in	LONG Axis, __in LONG PropId, __out PLONG PropVal);


EXTERN	LONG	(WINAPI *cmcCfgSetUnitDist)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE UnitDist);
EXTERN	LONG	(WINAPI *cmcCfgGetUnitDist)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE * UnitDist);
EXTERN	LONG	(WINAPI *cmcCfgSetUnitSpeed)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE UnitSpeed);
EXTERN	LONG	(WINAPI *cmcCfgGetUnitSpeed)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE * UnitSpeed);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 SpeedMode([0]Constant, [1]Trapezoidal, [2]S-Curve) [IN] VT_R8 Work/Workspeed, [IN] VT_R8 Acc/Acceleration , [IN] VT_R8 Dec/Deceleration, [IN] VT_R8 Ini/IniSpeed, [IN] VT_R8 End/EndSpeed 
EXTERN  LONG    (WINAPI *cmcCfgSetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __in LONG SpeedMode, __in DOUBLE Work, __in DOUBLE Acc, __in DOUBLE Dec, __in DOUBLE Ini, __in DOUBLE End);	

// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 SpeedMode([0]Constant, [1]Trapezoidal, [2]S-Curve) [OUT] VT_PR8 Work/Workspeed, [OUT] VT_PR8 Acc/Acceleration , [OUT] VT_PR8 Dec/Deceleration, [OUT] VT_PR8 Ini/IniSpeed, [OUT] VT_PR8 End/EndSpeed 
EXTERN  LONG    (WINAPI *cmcCfgGetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __out PLONG SpeedMode, __out DOUBLE * Work, __out DOUBLE * Acc, __out DOUBLE * Dec, __out DOUBLE * Ini, __out DOUBLE * End);

// 2013.08.12 yds add
EXTERN LONG		(WINAPI *cmcCfgSetSpeedPattern_T)	(__in LONG BoardId, __in LONG Axis, __in LONG SpeedMode, __in DOUBLE Work, __in DOUBLE AccTime, __in DOUBLE DecTime, __in DOUBLE Ini, __in DOUBLE End);
EXTERN LONG		(WINAPI *cmcCfgGetSpeedPattern_T) (__in LONG BoardId, __in LONG Axis, __out PLONG SpeedMode, __out DOUBLE * Work, __out DOUBLE * AccTime, __out DOUBLE * DecTime, __out DOUBLE * Ini, __out DOUBLE * End);

// [IN] VT_I4 Axis : ȣ, [OUT] VT_I4 IsEnable : Ʈ   Ȱȭ θ մϴ, [IN] VT_R8 LimitN : (-) Limit, [IN] VT_R8 LimitP : (+) Limit
EXTERN	LONG	(WINAPI *cmcCfgSetSoftLimit)		(__in LONG BoardId, __in LONG Axis, __in LONG IsEnable, __in DOUBLE LimitN, __in DOUBLE LimitP);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_I4 IsEnabled : Ʈ   Ȱȭ θ ȯմϴ, [OUT] VT_R8 LimitN : (-) Limit, [OUT] VT_R8 LimitP : (+) Limit
EXTERN	LONG	(WINAPI *cmcCfgGetSoftLimit)		(__in LONG BoardId, __in LONG Axis, __out PLONG IsEnabled, __out DOUBLE * LimitN, __out DOUBLE * LimitP);

// [IN] Axis, [IN] IsEnable, [IN] DevRange
EXTERN	LONG	(WINAPI *cmcCfgSetSvonDevRange)	(__in LONG BoardId, __in LONG Axis, __in LONG IsEnable, __in LONG DevRange);

// [IN] Axis, [OUT] IsEnable, [OUT] DevRange
EXTERN	LONG	(WINAPI *cmcCfgGetSvonDevRange)	(__in LONG BoardId, __in LONG Axis, __out PLONG IsEnable, __out PLONG DevRange);

//////////////////////////////////////////////////////////////////////////
// Sx Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Distance : Ÿ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN	LONG	(WINAPI *cmcSxMove)			(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Distance, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Distance : Ÿ
EXTERN	LONG	(WINAPI *cmcSxMoveStart)		(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Distance);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Position : ġ, [IN] VT_I4  IsBlocking :  ޽ ŷ 
EXTERN	LONG	(WINAPI *cmcSxMoveTo)			(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Position, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Position : ġ
EXTERN	LONG	(WINAPI *cmcSxMoveToStart)		(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Position);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 Dir : 
EXTERN	LONG	(WINAPI *cmcSxVMoveStart)		(__in LONG BoardId, __in	LONG Axis, __in LONG Dir);
// [IN] VT_I4 Axis : ȣ
EXTERN  LONG	(WINAPI *cmcSxStop)			(__in LONG BoardId, __in	LONG Axis);
// [IN] VT_I4 Axis : ȣ
EXTERN	LONG	(WINAPI *cmcSxStopEmg)			(__in LONG BoardId, __in	LONG Axis);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 pdwIsDone : ̼ ϷǾ ȯ(0:̼, 1:̼ۿϷ)
EXTERN	LONG	(WINAPI *cmcSxIsDone)			(__in LONG BoardId, __in	LONG Axis, __out PLONG pdwIsDone);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsBlocking :  ޼ ŷ 
EXTERN  LONG	(WINAPI *cmcSxWaitDone)		(__in LONG BoardId, __in	LONG Axis, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 CorrMode :     (0:  Ȱȭ, 1: 鷡  , 2:   ), [IN] VT_R8 CorrAmount :  ޽  ( Ÿ ), [IN] VT_I4 CntrMask :  ޽ ½ÿ  ī    (BIT0 1: Command Counter , BIT1 1: Feedback Counter , BIT2 1: Deviation Counter , BIT3 1: General Counter )
EXTERN	LONG	(WINAPI *cmcSxSetCorrection)		(__in LONG BoardId, __in	LONG Axis, __in  LONG CorrMode,	__in  DOUBLE   CorrAmount,__in   DOUBLE   CorrVel, __in  LONG  CntrMask);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 CorrMode :   ȯ  (0:  Ȱȭ, 1: 鷡  , 2:   ), [IN] VT_R8 CorrAmount :  ޽  ( Ÿ ), [IN] VT_I4 CntrMask :  ޽ ½ÿ  ī    (BIT0 1: Command Counter , BIT1 1: Feedback Counter , BIT2 1: Deviation Counter , BIT3 1: General Counter )
EXTERN	LONG	(WINAPI *cmcSxGetCorrection)		(__in LONG BoardId, __in	LONG Axis, __out PLONG CorrMode,__out DOUBLE * CorrAmount, __out DOUBLE * CorrVel, __out PLONG CntrMask);

//////////////////////////////////////////////////////////////////////////
// Mx Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 DistList : Ÿ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmcMxMove)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * DistList, __in LONG IsBlocking);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 DistList : Ÿ Ʈ
EXTERN LONG	(WINAPI *cmcMxMoveStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * DistList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 PosList : ġ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmcMxMoveTo)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * PosList, __in LONG IsBlocking);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 PosList : ġ Ʈ
EXTERN LONG	(WINAPI *cmcMxMoveToStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * PosList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PI4 DirList :  Ʈ
EXTERN LONG	(WINAPI *cmcMxVMoveStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in PLONG DirList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList :   ȣ Ʈ
EXTERN LONG	(WINAPI *cmcMxStop)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList :   ȣ Ʈ
EXTERN LONG	(WINAPI *cmcMxStopEmg)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_I4 IsDone: Ϸ 
EXTERN LONG	(WINAPI *cmcMxIsDone)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __out PLONG IsDone);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmcMxWaitDone)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in LONG IsBlocking);

//////////////////////////////////////////////////////////////////////////
// Ix Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 MapMask : ʸũ, [IN] VT_I4 IxMode : ̼  (0:, 1:ȣ, 2:︮ú, 3:öκ)
EXTERN LONG	(WINAPI *cmcIxMapAxes)			(__in LONG BoardId, __in LONG MapIndex, __in LONG MapMask, __in LONG IxMode);
// [IN] VT_I4 MapIndex : ʹȣ
EXTERN LONG	(WINAPI *cmcIxUnMapAxes)		(__in LONG BoardId, __in LONG MapIndex);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 IsVectorSpeed : ǵ (0:ͽǵ , 1:ͽǵ ), [IN] VT_I4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [IN] VT_R8 Ini : ʱӵ, [IN] VT_R8 End : ӵ, [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 Acc : ӵ, [IN] VT_R8 Dec : ӵ
EXTERN LONG	(WINAPI *cmcIxSetSpeedPattern)		(__in LONG BoardId, __in LONG MapIndex, __in  LONG  IsVectorSpeed, __in  LONG  SpeedMode, __in  DOUBLE   Ini, __in  DOUBLE   End, __in  DOUBLE   Vel, __in  DOUBLE Acc, __in  DOUBLE Dec);
// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 IsVectorSpeed : ǵ (0:ͽǵ , 1:ͽǵ ), [OUT] VT_PI4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [OUT] VT_PR8 Ini : ʱӵ, [OUT] VT_PR8 End : ӵ, [OUT] VT_PR8 Vel : ۾ӵ, [OUT] VT_PR8 Acc : ӵ, [OUT] VT_PR8 Dec : ӵ
EXTERN LONG	(WINAPI *cmcIxGetSpeedPattern)		(__in LONG BoardId, __in LONG MapIndex, __out PLONG IsVectorSpeed, __out PLONG SpeedMode, __out DOUBLE * Ini, __out DOUBLE * End, __out DOUBLE * Vel, __out DOUBLE * Acc, __out DOUBLE * Dec);

// 2013.08.12 yds add
EXTERN LONG	(WINAPI *cmcIxSetSpeedPattern_T)		(__in LONG BoardId, __in LONG MapIndex, __in LONG IsVectorSpeed, __in LONG SpeedMode, __in DOUBLE Ini, __in DOUBLE End, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime);
EXTERN LONG	(WINAPI *cmcIxGetSpeedPattern_T)		(__in LONG BoardId, __in LONG MapIndex, __out PLONG IsVectorSpeed, __out PLONG SpeedMode, __out DOUBLE * Ini, __out DOUBLE * End, __out DOUBLE * Vel, __out DOUBLE * AccTime, __out DOUBLE * DecTime); 

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 DistList : Ÿ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmcIxLine)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * DistList, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 DistList : Ÿ Ʈ
EXTERN LONG	(WINAPI *cmcIxLineStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * DistList);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 PosList : ġ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmcIxLineTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * PosList, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 PosList : ġ Ʈ
EXTERN LONG	(WINAPI *cmcIxLineToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * PosList);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmcIxArcA)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE EndAngle, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree)
EXTERN LONG	(WINAPI *cmcIxArcAStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmcIxArcATo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE EndAngle, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree)
EXTERN LONG	(WINAPI *cmcIxArcAToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 XEndPointDist : ǥ ġκ X Ÿ, [IN] VT_R8 YEndPointDist : ǥ ġκ Y Ÿ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmcIxArcP)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE XEndPointDist, __in DOUBLE YEndPointDist, __in LONG Direction, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 XEndPointDist : ǥ ġκ X Ÿ, [IN] VT_R8 YEndPointDist : ǥ ġκ Y Ÿ
EXTERN LONG	(WINAPI *cmcIxArcPStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE XEndPointDist, __in DOUBLE YEndPointDist, __in LONG Direction);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 XEndPos : ǥ X ǥ, [IN] VT_R8 YEndPos : ǥ Y ǥ, [IN] VT_I4 Direction : ȸ(0:ð(CW), 1:ݽð(CCW)), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmcIxArcPTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE XEndPos, __in DOUBLE YEndPos, __in LONG Direction, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 XEndPos : ǥ X ǥ, [IN] VT_R8 YEndPos : ǥ Y ǥ, [IN] VT_I4 Direction : ȸ(0:ð(CW), 1:ݽð(CCW))
EXTERN LONG	(WINAPI *cmcIxArcPToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE XEndPos, __in DOUBLE YEndPos, __in LONG Direction);

EXTERN LONG	(WINAPI *cmcIxArc3P)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle, __in LONG IsBlocking);
EXTERN LONG	(WINAPI *cmcIxArc3PStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle);
EXTERN LONG (WINAPI *cmcIxArc3PTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle, __in LONG IsBlocking);
EXTERN LONG (WINAPI *cmcIxArc3PToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 IsDone : ̼ ϷǾ ȯ(0:̼, 1:̼ۿϷ)
EXTERN LONG	(WINAPI *cmcIxIsDone)			(__in LONG BoardId, __in LONG MapIndex, __out LONG *IsDone);
// [IN] VT_I4 MapINdex : ʹȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmcIxWaitDone) 		(__in LONG BoardId, __in LONG MapIndex, __in  LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 IsWaitComplete : Ϸ  ٸ  , [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmcIxStop) 			(__in LONG BoardId, __in LONG MapIndex, __in  LONG IsWaitComplete, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ
EXTERN LONG	(WINAPI *cmcIxStopEmg) 		(__in LONG BoardId, __in LONG MapIndex);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PI4 Helcoord : 3 ǥ 迭, [IN] VT_I4 ArcAngle : ̼۰(degree)
EXTERN LONG	(WINAPI *cmcIxHelOnceStart) 		(__in LONG BoardId, __in LONG MapIndex, __in LONG * HelCoord, __in LONG ArcAngle);
EXTERN LONG	(WINAPI *cmcIxSplineStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE InArray[20][2], __in LONG  NumInArray, __in LONG NumOutArray);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 MapIndex : ش  ϰ ִ MapIndex ȣ
EXTERN LONG	(WINAPI *cmcIxGetMapIndex)		(__in LONG BoardId, __in LONG Axis, __out PLONG MapIndex);

//////////////////////////////////////////////////////////////////////////
// Return to Home
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmcHomeSetOffset)		(__in LONG BoardId, __in LONG Channel, __in DOUBLE Offset);
EXTERN LONG (WINAPI *cmcHomeGetOffset)		(__in LONG BoardId, __in LONG Channel, __out DOUBLE *Offset);

EXTERN LONG	(WINAPI *cmcHomeSetConfig)		(__in LONG BoardId, __in LONG Channel, __in LONG ParamId, __in LONG ParamVal);
EXTERN LONG	(WINAPI *cmcHomeGetConfig)		(__in LONG BoardId, __in LONG Channel, __in LONG ParamId, __out LONG * ParamVal);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 PhaseID, [IN] VT_I4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 Accel : ӵ, [IN] VT_R8 Decel : ӵ
EXTERN LONG	(WINAPI *cmcHomeSetSpeedPattern)	(__in LONG BoardId, __in LONG Channel, __in LONG PhaseID, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE Accel, __in DOUBLE Decel);
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 PhaseID, [IN] VT_I4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 Accel : ӵ, [IN] VT_R8 Decel : ӵ
EXTERN LONG	(WINAPI *cmcHomeGetSpeedPattern)	(__in LONG BoardId, __in LONG Channel, __in LONG PhaseID, __out PLONG SpeedMode, __out DOUBLE * Vel, __out DOUBLE * Accel, __out DOUBLE * Decel);

// 2013.08.12 yds add
EXTERN LONG	(WINAPI *cmcHomeSetSpeedPattern_T)		(__in LONG BoardId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime, __in DOUBLE RevVel);
EXTERN LONG	(WINAPI *cmcHomeGetSpeedPattern_T)		(__in LONG BoardId, __in LONG Channel, __in PLONG SpeedMode, __out DOUBLE * Vel, __out DOUBLE * AccTime, __out DOUBLE * DecTime, __out DOUBLE RevVel);
 
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmcHomeMove)			(__in LONG BoardId, __in LONG Channel, __in LONG IsBlocking);
// [IN] VT_I4 Channel : ȣ,
EXTERN LONG	(WINAPI *cmcHomeMoveStart)		(__in LONG BoardId, __in LONG Channel);

// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 ChannelList : ϴ  ȣ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmcHomeMoveAll)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG ChannelList, __in LONG IsBlocking);

// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 ChannelList : ϴ  ȣ Ʈ
EXTERN LONG	(WINAPI *cmcHomeMoveAllStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG ChannelList);
// [IN] VT_I4 Channel : ȣ, [IN] VT_PI4 : IsBusy :  Ͱ  ȯ(0: , 1:)
EXTERN LONG	(WINAPI *cmcHomeIsBusy)		(__in LONG BoardId, __in LONG Channel, __out PLONG IsBusy);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)   
EXTERN LONG	(WINAPI *cmcHomeWaitDone)		(__in LONG BoardId, __in LONG Channel, __in LONG IsBlocking);

EXTERN LONG	(WINAPI *cmcHomeSetSuccess)		(__in LONG BoardId, __in LONG Channel, __in LONG IsSuccess);
EXTERN LONG	(WINAPI *cmcHomeGetSuccess)		(__in LONG BoardId, __in LONG Channel, __out PLONG IsSuccess);

EXTERN LONG 	(WINAPI *cmcHomeSetPosClrMode)		(__in LONG BoardId, __in LONG Channel, __in LONG PosClrMode);
EXTERN LONG	(WINAPI *cmcHomeGetPosClrMode)		(__in LONG BoardId, __in LONG Channel, __out PLONG PosClrMode);

//////////////////////////////////////////////////////////////////////////
// Override Motion
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Channel : ȣ
EXTERN LONG	(WINAPI *cmcOverrideSpeedSet)		(__in LONG BoardId, __in LONG Channel);
// [IN] VT_I4 Channel : ȣ, [IN] VT_R8 NewDistance : ο ǥ Ÿ, [OUT] VT_PI4 IsIgnored : OverrideMove  /  ȯ  (0:  , 1: )
EXTERN LONG	(WINAPI *cmcOverrideMove)		(__in LONG BoardId, __in LONG Channel, __in DOUBLE NewDistance, __out PLONG IsIgnored);
// [IN] VT_I4 Channel : ȣ, [IN] VT_R8 NewPosition : ο ǥ Ÿ, [OUT] VT_PI4 IsIgnored : OverrideMove  /  ȯ  (0:  , 1: )
EXTERN LONG	(WINAPI *cmcOverrideMoveTo)		(__in LONG BoardId, __in LONG Channel, __in DOUBLE NewPosition, __out PLONG IsIgnored);

//////////////////////////////////////////////////////////////////////////
// Listed Motion
//////////////////////////////////////////////////////////////////////////
EXTERN LONG	(WINAPI *cmcLmxStart)			(__in LONG BoardId, __in LONG	LmIdx, __in LONG LmStartMode, __in LONG AxisMask);
EXTERN LONG	(WINAPI *cmcLmxSuspend)		(__in LONG BoardId, __in LONG	LmIdx, __in LONG SuspendMode);
EXTERN LONG	(WINAPI *cmcLmxResume)			(__in LONG BoardId, __in LONG	LmIdx, __in	LONG ResumeMode);
EXTERN LONG	(WINAPI *cmcLmxEnd)			(__in LONG BoardId, __in LONG	LmIdx);
EXTERN LONG	(WINAPI *cmcLmxGetStates)		(__in LONG BoardId, __in LONG	LmIdx, __in LONG LmStsId, __out PLONG LmxStsVal);

EXTERN LONG (WINAPI *cmcLmxSetSeqMode)		(__in LONG  LmIdx, __in  LONG SeqMode);
EXTERN LONG	(WINAPI *cmcLmxGetSeqMode)		(__in LONG  LmIdx, __out  LONG SeqMode);

EXTERN LONG	(WINAPI *cmcLmxSetNextItemId)		(__in LONG	LmIdx, __in  LONG SeqId);
EXTERN LONG	(WINAPI *cmcLmxGetNextItemId)		(__in LONG	LmIdx, __out LONG *SeqId);
EXTERN LONG	(WINAPI *cmcLmxSetNextItemParam)	(__in LONG	LmIdx, __in  LONG ParamIdx, __in  LONG ParamData);
EXTERN LONG	(WINAPI *cmcLmxGetNextItemParam)	(__in LONG	LmIdx, __in  LONG ParamIdx, __out  PLONG ParamData);
EXTERN LONG	(WINAPI *cmcLmxGetRunItemParam)	(__in LONG BoardId, __in LONG	LmIdx, __in  LONG ParamIdx, __out  PLONG ParamData);

EXTERN LONG	(WINAPI *cmcLmxGetRunItemStaPos)	(__in LONG 	LmIdx, __in  LONG Axis,     __out DOUBLE * Position);
EXTERN LONG	(WINAPI *cmcLmxGetRunItemTargPos)	(__in LONG	LmIdx, __in  LONG Axis,     __out DOUBLE * Position);

EXTERN LONG	(WINAPI *cmcLmxSetSeqId)		(__in LONG BoardId, __in LONG LmIdx, __in  LONG SeqId);
EXTERN LONG	(WINAPI *cmcLmxGetSeqId)		(__in LONG BoardId, __in LONG LmIdx, __out PLONG pSeqId);

//////////////////////////////////////////////////////////////////////////
// Master-Slave
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmcMsRegisterSlave)		(__in LONG BoardId, __in LONG Axis, __in LONG MasterAxis);
EXTERN LONG (WINAPI *cmcMsUnregisterSlave)		(__in LONG BoardId, __in LONG Axis);
EXTERN LONG (WINAPI *cmcMsGetMasterAxis)		(__in LONG BoardId, __in LONG Axis, __out PLONG MasterAxis);

//////////////////////////////////////////////////////////////////////////
// Status Monitoring
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_I4 pdwCount :  ī (޽ īƮ)
EXTERN LONG	(WINAPI *cmcStSetCount)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __in  LONG pdwCount);
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PI4 pdwcount : ī (޽ īƮ)
EXTERN LONG	(WINAPI *cmcStGetCount)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out PLONG pdwCount);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PI4 pdwcount : ī ( īƮ)
EXTERN LONG	(WINAPI *cmcStSetPosition)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __in  DOUBLE Count);
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PI4 pdwcount : ī ( īƮ)
EXTERN LONG	(WINAPI *cmcStGetPosition)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out DOUBLE * Count);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PR8 Speed : ī ( īƮ)
EXTERN LONG	(WINAPI *cmcStGetSpeed)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out DOUBLE * Speed);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PI4 pdwcount : ī ( īƮ)
EXTERN LONG	(WINAPI *cmcStGetTorque)		(__in LONG BoardId, __in LONG Channel, __out LONG * Torque);

// [IN] VT_I4 Channel : ȣ, [OUT] VT_PI4 MotStates
EXTERN LONG	(WINAPI *cmcStSxReadMotionState)	(__in LONG BoardId, __in LONG Channel, __out PLONG MotStates);
// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 MotStates
EXTERN LONG	(WINAPI *cmcStIxReadMotionState)	(__in LONG BoardId, __in LONG MapIndex, __out PLONG MotStates);

// [IN] VT_I4 Channel : ȣ, [OUT] VT_PI4 MioStates : Machine I/O 
EXTERN LONG 	(WINAPI *cmcStReadMioStatuses)		(__in LONG BoardId, __in LONG Channel, __out PLONG MioStates);

EXTERN LONG	(WINAPI *cmcStGetMotionMode)		(__in LONG BoardId, __in LONG Channel, __out PLONG Mode);

EXTERN LONG	(WINAPI *cmcStSxGetLastError)		(__in LONG BoardId, __in LONG Channel, __out PLONG LastError);

EXTERN LONG	(WINAPI *cmcStIxGetLastError)		(__in LONG BoardId, __in LONG MapIndex,__out PLONG LastError);

EXTERN LONG (WINAPI *cmcStSetMultiRevCnt)		(__in LONG BoardId, __in LONG Axis, __in LONG MultiRevCnt);
EXTERN LONG (WINAPI *cmcStGetMultiRevCnt)		(__in LONG BoardId, __in LONG Axis, __out PLONG pMultiRevCnt);

EXTERN LONG (WINAPI *cmcStSetOneRevPos)		(__in LONG BoardId, __in LONG Axis, __in LONG OneRevPos);
EXTERN LONG (WINAPI *cmcStGetOneRevPos)		(__in LONG BoardId, __in LONG Axis, __out PLONG pOneRevPos);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (GN)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [OUT] SlaveInfo
EXTERN LONG		(WINAPI *cmcGnGetNodeInfo)			(__in LONG BoardId, __in LONG Axis, __out cmcSlaveInfo* SlaveInfo);

// [IN] Axis,	[OUT] Channel 
EXTERN LONG		(WINAPI *cmcGnTotalDIOChannel)		(__in LONG BoardId, __in LONG Axis, __out PLONG Channel);

// [IN] Axis,	[OUT] Channel 
EXTERN LONG		(WINAPI *cmcGnTotalAIChannel)			(__in LONG BoardId, __in LONG Axis, __out PLONG Channel);

// [IN] Axis,	[OUT] Channel 
EXTERN LONG		(WINAPI *cmcGnTotalAOChannel)			(__in LONG BoardId, __in LONG Axis, __out PLONG Channel);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (DI)
/////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [OUT] Logic
EXTERN LONG		(WINAPI *cmcDiGetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Logic);

// [IN] Axis [IN] Channel [IN] Logic
EXTERN LONG		(WINAPI *cmcDiSetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
EXTERN LONG		(WINAPI *cmcDiGetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
EXTERN LONG		(WINAPI *cmcDiSetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG Logic);

// [IN] Axis [IN] Channel [OUT] State
EXTERN LONG		(WINAPI *cmcDiGetOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
EXTERN LONG		(WINAPI *cmcDiGetMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG State);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (DO)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [OUT] Logic
EXTERN LONG		(WINAPI *cmcDoGetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Logic);

// [IN] Axis [IN] Channel [IN] Logic
EXTERN LONG		(WINAPI *cmcDoSetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
EXTERN LONG		(WINAPI *cmcDoGetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
EXTERN LONG		(WINAPI *cmcDoSetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG Logic);

// [IN] Axis [IN] Channel [IN] State
EXTERN LONG		(WINAPI *cmcDoPutOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG State);

// [IN] Axis [IN] Channel [OUT] State
EXTERN LONG		(WINAPI *cmcDoGetOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] State
EXTERN LONG		(WINAPI *cmcDoPutMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
EXTERN LONG		(WINAPI *cmcDoGetMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG State);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (DIO)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [OUT] InOutMode
EXTERN LONG		(WINAPI *cmcDioGetIomode)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG InOutMode);

// [IN] Axis [IN] Channel [IN] InOutMode
EXTERN LONG		(WINAPI *cmcDioSetIomode)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG InOutMode);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] InOutMode
EXTERN LONG		(WINAPI *cmcDioGetIomodeMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG InOutMode);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] InOutMode
EXTERN LONG		(WINAPI *cmcDioSetIomodeMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG InOutMode);

// [IN] Axis [IN] Channel [OUT] Logic
EXTERN LONG		(WINAPI *cmcDioGetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Logic);

// [IN] Axis [IN] Channel [IN] Logic
EXTERN LONG		(WINAPI *cmcDioSetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
EXTERN LONG		(WINAPI *cmcDioGetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
EXTERN LONG		(WINAPI *cmcDioSetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG Logic);

// [IN] Axis [IN] Channel [IN] State
EXTERN LONG		(WINAPI *cmcDioPutOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG State);

// [IN] Axis [IN] Channel [OUT] State
EXTERN LONG		(WINAPI *cmcDioGetOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] State
EXTERN LONG		(WINAPI *cmcDioPutMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
EXTERN LONG		(WINAPI *cmcDioGetMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG State);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (AI)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [IN] Mode
EXTERN LONG		(WINAPI *cmcAiSetVoltRangeMode) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Mode);

// [IN] Axis [IN] Channel [OUT] Mode
EXTERN LONG		(WINAPI *cmcAiGetVoltRangeMode) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Mode);

// [IN] Axis [IN] Channel [OUT] Dmin [OUT] Dmax
EXTERN LONG		(WINAPI *cmcAiGetRangeDigit) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Dmin, __out PLONG Dmax);

// [IN] Axis [IN] Channel [OUT] Digit
EXTERN LONG		(WINAPI *cmcAiGetDigit)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Digit);

// [IN] Axis [IN] Channel [OUT] Volt
EXTERN LONG		(WINAPI *cmcAiGetVolt) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out DOUBLE * Volt);

// [IN] Axis [IN] Channel [OUT] Current
EXTERN LONG		(WINAPI *cmcAiGetCurrent) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out DOUBLE * Current);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (AO)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [IN] Digit
EXTERN LONG		(WINAPI *cmcAoOutDigit)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Digit);

// [IN] Axis [IN] Channel [IN] Volt
EXTERN LONG		(WINAPI *cmcAoOutVolt) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in DOUBLE Volt);

// [IN] Axis [IN] Channel [IN] Current
EXTERN LONG		(WINAPI *cmcAoOutCurrent) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in DOUBLE Current);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-GN)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] IsOn
EXTERN LONG (WINAPI *cmcPmGnSetServoOn) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsOn);

// [IN] NodeId [IN] Channel [OUT] pIsOn
EXTERN LONG (WINAPI *cmcPmGnGetServoOn) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsOn);

// [IN] NodeId [IN] Channel [IN] IsOn
EXTERN LONG (WINAPI *cmcPmGnAlarmReset) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsReset);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-CFG)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] PropId [IN] PropVal
EXTERN LONG (WINAPI *cmcPmCfgSetMioProperty) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG PropId, __in LONG PropVal);

// [IN] NodeId [IN] Channel [IN] PropId [OUT] pPropVal
EXTERN LONG (WINAPI *cmcPmCfgGetMioProperty) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG PropId, __out PLONG pPropVal);

// [IN] NodeId [IN] Channel [IN] IsEnable
EXTERN LONG (WINAPI *cmcPmCfgSetFilter) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsEnable);

// [IN] NodeId [IN] Channel [OUT] pIsEnable
EXTERN LONG (WINAPI *cmcPmCfgGetFilter) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsEnable);

// [IN] NodeId [IN] Channel [IN] Target [IN] IsEnable
EXTERN LONG (WINAPI *cmcPmCfgSetFilterAB) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __in LONG IsEnable);

// [IN] NodeId [IN] Channel [IN] Target [OUT] pIsEnable
EXTERN LONG (WINAPI *cmcPmCfgGetFilterAB) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __out PLONG pIsEnable);

// [IN] NodeId [IN] Channel [IN] InputMode [IN] IsReverse
EXTERN LONG (WINAPI *cmcPmCfgSetInMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG InputMode, __in LONG IsReverse);

// [IN] NodeId [IN] Channel [OUT] pInputMode [OUT] pIsReverse
EXTERN LONG (WINAPI *cmcPmCfgGetInMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pInputMode, __out PLONG pIsReverse);

// [IN] NodeId [IN] Channel [IN] OutputMode
EXTERN LONG (WINAPI *cmcPmCfgSetOutMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG OutputMode);

// [IN] NodeId [IN] Channel [OUT] pOutputMode
EXTERN LONG (WINAPI *cmcPmCfgGetOutMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pOutputMode);

// [IN] NodeId [IN] Channel [IN] CtrlMode
EXTERN LONG (WINAPI *cmcPmCfgSetCtrlMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG CtrlMode);

// [IN] NodeId [IN] Channel [OUT] pCtrlMode
EXTERN LONG (WINAPI *cmcPmCfgGetCtrlMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pCtrlMode);

// [IN] NodeId [IN] Channel [IN] Ratio
EXTERN LONG (WINAPI *cmcPmCfgSetInOutRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Ratio);

// [IN] NodeId [IN] Channel [OUT] pRatio
EXTERN LONG (WINAPI *cmcPmCfgGetInOutRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pRatio);

// [IN] NodeId [IN] Channel [IN] UnitDist
EXTERN LONG (WINAPI *cmcPmCfgSetUnitDist) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG UnitDist);

// [IN] NodeId [IN] Channel [OUT] pUnitDist
EXTERN LONG (WINAPI *cmcPmCfgGetUnitDist) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pUnitDist);

// [IN] NodeId [IN] Channel [IN] UnitSpeed
EXTERN LONG (WINAPI *cmcPmCfgSetUnitSpeed) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG UnitSpeed);

// [IN] NodeId [IN] Channel [OUT] pUnitSpeed
EXTERN LONG (WINAPI *cmcPmCfgGetUnitSpeed) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pUnitSpeed);

// [IN] NodeId [IN] Channel [IN] MaxPPS
EXTERN LONG (WINAPI *cmcPmCfgSetSpeedRange) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG MaxPPS);

// [IN] NodeId [IN] Channel [OUT] pMaxPPS
EXTERN LONG (WINAPI *cmcPmCfgGetSpeedRange) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMaxPPS);

// [IN] NodeId [IN] Channel [IN] SpeedMode [IN] WorkSpeed [IN] Accel [IN] Decel
EXTERN LONG (WINAPI *cmcPmCfgSetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE WorkSpeed, __in DOUBLE Accel, __in DOUBLE Decel);

// [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pWorkSpeed [OUT] pAccel [OUT] pDecel
EXTERN LONG (WINAPI *cmcPmCfgGetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE * pWorkSpeed, __out DOUBLE * pAccel, __out DOUBLE * pDecel);

//20130812 yds
EXTERN LONG (WINAPI *cmcPmCfgSetSpeedPattern_T) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE WorkSpeed, __in DOUBLE AccTime, __in DOUBLE DecTime);
EXTERN LONG (WINAPI *cmcPmCfgGetSpeedPattern_T) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE * pWorkSpeed, __out DOUBLE * pAccTime, __out DOUBLE * pDecTime);

// [IN] NodeId [IN] Channel [IN] IsEnable [IN] LimitN [IN] LimitP
EXTERN LONG (WINAPI *cmcPmCfgSetSoftLimit) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsEnable, __in DOUBLE LimitN, __in DOUBLE LimitP);

// [IN] NodeId [IN] Channel [OUT] pIsEnable [OUT] pLimitN [OUT] pLimitP
EXTERN LONG (WINAPI *cmcPmCfgGetSoftLimit) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsEnable, __out DOUBLE * pLimitN, __out DOUBLE * pLimitP);

// [IN] NodeId [IN] Channel [IN] TargCntr [IN] IsEnable [IN] CntMax
EXTERN LONG (WINAPI *cmcPmCfgSetRingCntr) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG TargCntr, __in LONG IsEnable, __in LONG CntMax);

// [IN] NodeId [IN] Channel [IN] TargCntr [OUT] pIsEnable [OUT] pCntMax
EXTERN LONG (WINAPI *cmcPmCfgGetRingCntr) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG TargCntr, __out PLONG pIsEnable, __out PLONG pCntMax);

// [IN] NodeId [IN] Channel [IN] CorrRatio
EXTERN LONG (WINAPI *cmcPmCfgSetVelCorrRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG CorrRatio);

// [IN] NodeId [IN] Channel [OUT] pCorrRatio
EXTERN LONG (WINAPI *cmcPmCfgGetVelCorrRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pCorrRatio);

// [IN] NodeId [IN] SeqMode
EXTERN LONG (WINAPI *cmcPmCfgSetSeqMode) (__in LONG BoardId, __in LONG NodeId, __in LONG SeqMode);

// [IN] NodeId [OUT] pSeqMode
EXTERN LONG (WINAPI *cmcPmCfgGetSeqMode) (__in LONG BoardId, __in LONG NodeId, __out PLONG pSeqMode);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-HOME)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] HomeMode [IN] Dir [IN] EzCount [IN] EscDist [IN] Offset
EXTERN LONG (WINAPI *cmcPmHomeSetConfig) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG HomeMode, __in LONG Dir, __in LONG EzCount, __in LONG EscDist, __in DOUBLE Offset);

// [IN] NodeId [IN] Channel [OUT] pHomeMode [OUT] pDir [OUT] pEzCount [OUT] pEscDist [OUT] pOffset
EXTERN LONG (WINAPI *cmcPmHomeGetConfig) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pHomeMode, __out PLONG pDir, __out PLONG pEzCount, __out PLONG pEscDist, __out DOUBLE * pOffset);

// [IN] NodeId [IN] Channel [IN] PosClrMode
EXTERN LONG (WINAPI *cmcPmHomeSetPosClrMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG PosClrMode);

// [IN] NodeId [IN] Channel [OUT] pPosClrMode
EXTERN LONG (WINAPI *cmcPmHomeGetPosClrMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pPosClrMode);

// [IN] NodeId [IN] Channel [IN] SpeedMode [IN] Vel [IN] Accel [IN] Decel [IN] RevVel
EXTERN LONG (WINAPI *cmcPmHomeSetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE Accel, __in DOUBLE Decel, __in DOUBLE RevVel);

// [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pVel [OUT] pAccel [OUT] pDecel [OUT] pRevVel
EXTERN LONG (WINAPI *cmcPmHomeGetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE * pVel, __out DOUBLE * pAccel, __out DOUBLE * pDecel, __out DOUBLE * pRevVel);

//20130812
EXTERN LONG (WINAPI *cmcPmHomeSetSpeedPattern_T) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime, __in DOUBLE RevVel);
EXTERN LONG (WINAPI *cmcPmHomeGetSpeedPattern_T) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE * pVel, __out DOUBLE * pAccTime, __out DOUBLE * pDecTime, __out DOUBLE * pRevVel);

// [IN] NodeId [IN] Channel
EXTERN LONG (WINAPI *cmcPmHomeMoveStart) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] Channel
EXTERN LONG (WINAPI *cmcPmHomeMoveAllStart) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG ChannelMask);

// [IN] NodeId [IN] Channel [IN] IsSuccess
EXTERN LONG (WINAPI *cmcPmHomeSetSuccess) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsSuccess);

// [IN] NodeId [IN] Channel [OUT] pIsSuccess
EXTERN LONG (WINAPI *cmcPmHomeGetSuccess) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsSuccess);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-SX)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] SpeedMode [IN] VelRatio [IN] AccRatio [IN] DecRatio
EXTERN LONG (WINAPI *cmcPmSxSetSpeedRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in LONG VelRatio, __in LONG AccRatio, __in LONG DecRatio);

// [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pVelRatio [OUT] pAccRatio [OUT] pDecRatio
EXTERN LONG (WINAPI *cmcPmSxGetSpeedRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out PLONG pVelRatio, __out PLONG pAccRatio, __out PLONG pDecRatio);

// [IN] NodeId [IN] Channel [IN] Distance
EXTERN LONG (WINAPI *cmcPmSxMoveStart) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Distance);

// [IN] NodeId [IN] Channel [IN] Distance [IN] IsBlocking
EXTERN LONG (WINAPI *cmcPmSxMove) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Distance, __in LONG IsBlocking);

// [IN] NodeId [IN] Channel [IN] Position
EXTERN LONG (WINAPI *cmcPmSxMoveToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Position);

// [IN] NodeId [IN] Channel [IN] Position [IN] IsBlocking
EXTERN LONG (WINAPI *cmcPmSxMoveTo) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Position, __in LONG IsBlocking);

// [IN] NodeId [IN] Channel [IN] Direction
EXTERN LONG (WINAPI *cmcPmSxVMoveStart) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Direction);

// [IN] NodeId [IN] Channel [IN] IsWaitComplete
EXTERN LONG (WINAPI *cmcPmSxStop) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsWaitComplete);

// [IN] NodeId [IN] Channel [IN] IsWaitComplete
EXTERN LONG (WINAPI *cmcPmSxStopEmg) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] Channel [OUT] pIsDnoe
EXTERN LONG (WINAPI *cmcPmSxIsDone) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsDone);

// [IN] NodeId [IN] Channel 
EXTERN LONG (WINAPI *cmcPmSxWaitDone) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] Channel [OUT] pPosition
EXTERN LONG (WINAPI *cmcPmSxGetTargetPos) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out DOUBLE * pPosition);

// [IN] NodeId [IN] Channel [IN] IniSpeed
EXTERN LONG (WINAPI *cmcPmSxSetOptIniSpeed) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE IniSpeed);

// [IN] NodeId [IN] Channel [OUT] pIniSpeed
EXTERN LONG (WINAPI *cmcPmSxGetOptIniSpeed) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out DOUBLE * pIniSpeed);

// [IN] NodeId [IN] Channel [IN] OffsetDist
EXTERN LONG (WINAPI *cmcPmSxSetOptRdpOffset) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE OffsetDist);

// [IN] NodeId [IN] Channel [OUT] pOffsetDist
EXTERN LONG (WINAPI *cmcPmSxGetOptRdpOffset) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out DOUBLE * pOffsetDist);

// [IN] NodeId [IN] Channel [IN] CorrMode [IN] CorrAmount [IN] CorrVel [IN] CntrMask
EXTERN LONG (WINAPI *cmcPmSxSetCorrection) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG CorrMode, __in DOUBLE CorrAmount, __in DOUBLE CorrVel, __in LONG CntrMask);

// [IN] NodeId [IN] Channel [OUT] pCorrMode [OUT] pCorrAmount [OUT] pCorrVel [OUT] pCntrMask
EXTERN LONG (WINAPI *cmcPmSxGetCorrection) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pCorrMode, __out DOUBLE * pCorrAmount, __out DOUBLE * pCorrVel, __out PLONG pCntrMask);

// [IN] NodeId [IN] Channel [IN] Mode [IN] RefAxis [IN] Condition
EXTERN LONG (WINAPI *cmcPmSxSetOptSyncMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Mode, __in LONG RefAxis, __in LONG Condition);

// [IN] NodeId [IN] Channel [OUT] pMode [OUT] pRefAxis [OUT] pCondition
EXTERN LONG (WINAPI *cmcPmSxGetOptSyncMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMode, __out PLONG pRefAxis, __out PLONG pCondition);

// [IN] NodeId [IN] Channel [IN] Mode [IN] DoChan_local [IN] DoLogic
EXTERN LONG (WINAPI *cmcPmSxSetOptSyncOut) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Mode, __in LONG DoChan_local, __in LONG DoLogic);

// [IN] NodeId [IN] Channel [OUT] pMode [OUT] pDoChan_local [OUT] pDoLogic
EXTERN LONG (WINAPI *cmcPmSxGetOptSyncOut) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMode, __out PLONG pDoChan_local, __out PLONG pDoLogic);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-MX)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2]
EXTERN LONG (WINAPI *cmcPmMxMoveStart) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE * DistList);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2] [IN] IsBlocking
EXTERN LONG (WINAPI *cmcPmMxMove) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE * DistList, __in LONG IsBlocking);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2]
EXTERN LONG (WINAPI *cmcPmMxMoveToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE * PosList);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2] [IN] IsBlocking
EXTERN LONG (WINAPI *cmcPmMxMoveTo) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE * PosList, __in LONG IsBlocking);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DirMask
EXTERN LONG (WINAPI *cmcPmMxVMoveStart) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in LONG DirMask);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] IsWaitComplete
EXTERN LONG (WINAPI *cmcPmMxStop) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in LONG IsWaitComplete);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask
EXTERN LONG (WINAPI *cmcPmMxStopEmg) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [OUT] pIsDone
EXTERN LONG (WINAPI *cmcPmMxIsDone) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __out PLONG pIsDone);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask
EXTERN LONG (WINAPI *cmcPmMxWaitDone) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-IX)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] MapIndex [IN] MapMask
EXTERN LONG (WINAPI *cmcPmIxMapAxes) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG MapMask);

// [IN] NodeId [IN] MapIndex
EXTERN LONG (WINAPI *cmcPmIxUnMapAxes) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);


// [IN] NodeId [IN] MapIndex [IN] VelCorrOpt1 [IN] VelCorrOpt2
EXTERN LONG (WINAPI *cmcPmIxSetVelCorrMode) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG VelCorrOpt1, __in LONG VelCorrOpt2);

// [IN] NodeId [IN] MapIndex [OUT] pVelCorrOpt1 [OUT] pVelCorrOpt2
EXTERN LONG (WINAPI *cmcPmIxGetVelCorrMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pVelCorrOpt1, __out PLONG pVelCorrOpt2);

// [IN] NodeId [IN] MapIndex [IN] IsVectorSpeed [IN] SpeedMode [IN] Vel [IN] Acc [IN] Dec
EXTERN LONG (WINAPI *cmcPmIxSetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG IsVectorSpeed, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE Acc, __in DOUBLE Dec);

// [IN] NodeId [IN] MapIndex [OUT] pIsVectorSpeed [OUT] pSpeedMode [OUT] pVel [OUT] pAcc [OUT] pDec
EXTERN LONG (WINAPI *cmcPmIxGetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __out PLONG pIsVectorSpeed, __out PLONG pSpeedMode, __out DOUBLE * pVel, __out DOUBLE * pAcc, __out DOUBLE * pDec);

//20130812
EXTERN LONG (WINAPI *cmcPmIxSetSpeedPattern_T) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG IsVectorSpeed, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime);
EXTERN LONG (WINAPI *cmcPmIxGetSpeedPattern_T) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __out PLONG pIsVectorSpeed, __out PLONG pSpeedMode, __out DOUBLE * pVel, __out DOUBLE * pAccTime, __out DOUBLE * pDecTime);

// [IN] NodeId [IN] MapIndex [IN] pPosList
EXTERN LONG (WINAPI *cmcPmIxLineStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE * pDistList);

// [IN] NodeId [IN] MapIndex [IN] pPosList
EXTERN LONG (WINAPI *cmcPmIxLineToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE * pPosList);

// [IN] NodeId [IN] MapIndex [IN] XCentOffset [IN] YCentOffset [IN] EndAngle
EXTERN LONG (WINAPI *cmcPmIxArcAStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE EndAngle);

// [IN] NodeId [IN] MapIndex [IN] XCent [IN] YCent [IN] EndAngle
EXTERN LONG (WINAPI *cmcPmIxArcAToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE EndAngle);

// [IN] NodeId [IN] MapIndex [IN] XCentOffset [IN] YCentOffset [IN] XEndPointDist [IN] YEndPointDist [IN] Direction
EXTERN LONG (WINAPI *cmcPmIxArcPStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE XEndPointDist, __in DOUBLE YEndPointDist, __in LONG Direction);

// [IN] NodeId [IN] MapIndex [IN] XCent [IN] YCent [IN] XEndPoint [IN] YEndPoint [IN] Direction
EXTERN LONG (WINAPI *cmcPmIxArcPToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE XEndPoint, __in DOUBLE YEndPoint, __in LONG Direction);

// [IN] NodeId [IN] MapIndex [IN] P2X [IN] P2Y [IN] P3X [IN] P3Y [IN] EndAngle
EXTERN LONG (WINAPI *cmcPmIxArc3PStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE P2X, __in DOUBLE P2Y, __in DOUBLE P3X, __in DOUBLE P3Y, __in DOUBLE EndAngle);

// [IN] NodeId [IN] MapIndex [IN] P2X [IN] P2Y [IN] P3X [IN] P3Y [IN] EndAngle
EXTERN LONG (WINAPI *cmcPmIxArc3PToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE P2X, __in DOUBLE P2Y, __in DOUBLE P3X, __in DOUBLE P3Y, __in DOUBLE EndAngle);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG (WINAPI *cmcPmIxStop) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG (WINAPI *cmcPmIxStopEmg) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG (WINAPI *cmcPmIxIsDone) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __out PLONG pIsDone);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG (WINAPI *cmcPmIxWaitDone) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] Channel 
EXTERN LONG (WINAPI *cmcPmOverrideSpeedSet) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] ChannelMask
EXTERN LONG (WINAPI *cmcPmOverrideSpeedSetAll) (__in LONG BoardId, __in LONG NodeId, __in LONG ChannelMask);

// [IN] NodeId [IN] Channel [IN] NewDistance [IN] IsHardApply [OUT] pAppliedState
EXTERN LONG (WINAPI *cmcPmOverrideMove) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE NewDistance, __in LONG IsHardApply, __out PLONG pAppliedState);

// [IN] NodeId [IN] Channel [IN] NewPosition [IN] IsHardApply
EXTERN LONG (WINAPI *cmcPmOverrideMoveTo) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE NewPosition, __in LONG IsHardApply);

// [IN] NodeId [IN] Channel [IN] Target [IN] Count
EXTERN LONG (WINAPI *cmcPmStSetCount) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __in LONG Count);

// [IN] NodeId [IN] Channel [IN] Source [OUT] pCount
EXTERN LONG (WINAPI *cmcPmStGetCount) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Source, __out PLONG pCount);

// [IN] NodeId [IN] Channel [IN] Target [IN] Position
EXTERN LONG (WINAPI *cmcPmStSetPosition) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __in DOUBLE Position);

// [IN] NodeId [IN] Channel [OUT] pIsLatched
EXTERN LONG (WINAPI *cmcPmStGetPosition) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Source, __out DOUBLE * pPosition);

// [IN] NodeId [IN] Channel [IN] Source [OUT] pIsLatched
EXTERN LONG (WINAPI *cmcPmStGetSpeed) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Source, __out DOUBLE * pSpeed);

// [IN] NodeId [IN] Channel [OUT] pMotStates
EXTERN LONG (WINAPI *cmcPmStReadMotionState) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMotStates);

// [IN] NodeId [IN] Channel [OUT] pMioStates
EXTERN LONG (WINAPI *cmcPmStReadMIOStatus) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMioStates);

// [IN] NodeId [IN] Channel [OUT] pIsLatched
EXTERN LONG (WINAPI *cmcPmLtcIsLatched) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsLatched);

// [IN] NodeId [IN] Channel [IN] Counter [OUT] pLatchedPos
EXTERN LONG (WINAPI *cmcPmLtcReadLatch) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Counter, __out DOUBLE * pLatchedPos);

//////////////////////////////////////////////////////////////////////////
// Advanced Function
//////////////////////////////////////////////////////////////////////////

// [RTS Update Functions]
// RTS Structure ּҸ RtsData Structure Pointer ȯմϴ.
EXTERN LONG	(WINAPI *cmcAdvGetRtsMemPtr)		(__in LONG BoardId, __out cmcRtsData** ppMemPtr);

// RTS Update  Ȱȭ Ұ Ͽ ϰ  RTS Update Ȱ ¸ ȯմϴ.
EXTERN LONG	(WINAPI *cmcAdvSetRtsEnable)		(__in LONG BoardId, __in LONG IsEnable);
EXTERN LONG	(WINAPI *cmcAdvGetRtsEnable)		(__in LONG BoardId, __out LONG *pIsEnable);

// ش Node RTS Update   Ͽ ϰ  Node RTS Update ¸ ȯմϴ.
EXTERN LONG	(WINAPI *cmcAdvSetRtsMode)		(__in LONG BoardId, __in LONG NodeId, __in LONG IsEnable);
EXTERN LONG	(WINAPI *cmcAdvGetRtsMode)		(__in LONG BoardId, __in LONG NodeId, __out LONG *pIsEnable);

// RTS Structure Update Interval  Ǵ ȯմϴ.
EXTERN LONG	(WINAPI *cmcAdvSetRtsUpdateInterval)	(__in LONG BoardId, __in LONG RtsUpdateInterval);
EXTERN LONG	(WINAPI *cmcAdvGetRtsUpdateInterval)	(__in LONG BoardId, __out PLONG pRtsUpdateInterval);

// [Command Acknowledge Setting Functions]
// API Լ  带 ϰ   带 ȯմϴ.
EXTERN LONG 	(WINAPI *cmcAdvSetCmdAckMode)		(__in LONG BoardId, __in LONG AckMode);
EXTERN LONG 	(WINAPI *cmcAdvGetCmdAckMode) 		(__in LONG BoardId, __out PLONG pAckMode);

// [NEMO Firmware Functions(Undocumented)]
EXTERN LONG	(WINAPI *cmcAdvFwGetVersion)		(__in LONG BoardId, __out PLONG VersionMS, __out PLONG VersionLS);
EXTERN LONG	(WINAPI *cmcAdvFwGetSystemState)	(__in LONG BoardId, __out PLONG State);
EXTERN LONG	(WINAPI *cmcAdvFwDnFrame)		(__in LONG BoardId, __in LONG FrameType, __in PLONG FrameData, __in LONG FrameSize);
EXTERN LONG	(WINAPI *cmcAdvFwDnFrameVerify)	(__in LONG BoardId, __in LONG FrameType, __in PLONG FrameData, __in LONG FrameSize);
EXTERN LONG	(WINAPI *cmcAdvFwSystemReset)		(__in LONG BoardId, __in LONG IsReset);
EXTERN LONG	(WINAPI *cmcAdvFwSetFwuBit)		(__in LONG BoardId, __in LONG IsAnswer, __in LONG Value);
EXTERN LONG	(WINAPI *cmcAdvFwGetFwuBit)		(__in LONG BoardId, __in LONG IsAnswer, __out PLONG pValue);
EXTERN LONG	(WINAPI *cmcAdvFwSetBootFlag)		(__in LONG BoardId, __in LONG Value);
EXTERN LONG	(WINAPI *cmcAdvFwGetBootFlag)		(__in LONG BoardId, __out PLONG pValue);
EXTERN LONG	(WINAPI *cmcAdvFwUpdateMode)		(__in LONG BoardId, __in LONG IsEnable);

EXTERN LONG (WINAPI *cmcServoParamRead)		(__in LONG BoardId, __in LONG Axis, __in LONG ParamNo, __in LONG DataSize, __out void *Buffer);
EXTERN LONG (WINAPI *cmcServoParamWrite)	(__in LONG BoardId, __in LONG Axis, __in LONG ParamNo, __in LONG DataSize, __in void *Buffer);
EXTERN LONG (WINAPI *cmcServoParamSet)		(__in LONG BoardId, __in LONG Axis, __in LONG ParamNo, __in LONG DataSize, __in void *Buffer);
EXTERN LONG (WINAPI *cmcServoParamValidate)	(__in LONG BoardId, __in LONG Axis, __in LONG IsWaitCompt);
EXTERN LONG (WINAPI *cmcAdvDeviceIDRead)	(__in LONG BoardId, __in LONG Axis, __in LONG DeviceCode, __in LONG Offset, __in LONG DataSize, __out void *Buffer);

// (NEMO-ME) Node Configuration info Flashκ о´.
// [OUT] pT_mcyc,	[OUT] pMa_max,	[OUT] pId_table,	[OUT] pCrdlen_table,	[OUT] pSlv_type 
EXTERN LONG	(WINAPI *cmcAdvM3NodeCfgRead)		(__in LONG BoardId, __out LONG *pT_mcyc, __out LONG *pMa_max, __out LONG *pId_table, __out LONG *pCrdlen_table, __out LONG *pSlv_type);

// (NEMO-ME) Node Configuration info Flash Ѵ.
// [IN] T_mcyc,		[IN] Ma_max,	[IN] pId_table,		[IN] pCrdlen_table,		[IN] pSlv_type 
EXTERN LONG	(WINAPI *cmcAdvM3NodeCfgWrite)	(__in LONG BoardId, __in LONG T_mcyc, __in LONG Ma_max, __in LONG *pId_table, __in LONG *pCrdlen_table, __in LONG *pSlv_type);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 EncoderMode : ڴ 带 մϴ.
EXTERN LONG (WINAPI *cmcGnSetABSMode)			(__in LONG BoardId, __in LONG Axis, __in LONG EncoderMode);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 EncoderMode : ڴ 带 ȯմϴ.
EXTERN LONG (WINAPI *cmcGnGetABSMode)			(__in LONG BoardId, __in LONG Axis, __out PLONG EncoderMode);
// [NONE]  ̽  ̹ ڴ 带 Ȯ, ¸ մϴ.
EXTERN LONG (WINAPI *cmcGnABSUpdate)			(__in LONG BoardId);
// [IN] VT_I4 Axis : ȣ, ġ ڴ   ش   ġ  մϴ.
EXTERN LONG (WINAPI *cmcGnSetABSHome)			(__in LONG BoardId, __in LONG Axis);

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr_SetTableSize) (__in int BoardId, __in int Axis, __in int TableSize );

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr_GetTableSize) (__in int BoardId, __in int Axis, __out int *TableSize);

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr_SetTableData) (__in int BoardId, __in int Axis, __in int TableIndex, __in double RefCmdPos, __in double ActMotorPos );

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr_GetTableData) (__in int BoardId, __in int Axis, __in int TableIndex, __out double* RefCmdPos, __out double* ActMotorPos );

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr_SetEnable) (__in int BoardId, __in int Axis, __in int IsEnable );

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr_GetEnable) (__in int BoardId, __in int Axis, __out int *IsEnable);

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr_ClearTable) (__in int BoardId, __in int Axis);

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr_SetTableFromFile) (__in int BoardId, __in int Axis, __in char *szFilePath);


EXTERN LONG (WINAPI *cmcSxCfg_PosCorr2D_Reset) (__in int BoardId, __in int Axis );

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr2D_SetTableHeader) (__in int BoardId, __in int Axis, __in TEcmPC2DHeader& PC2DHeader );

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr2D_GetTableHeader) (__in int BoardId, __in int Axis, __out TEcmPC2DHeader* pPC2DHeader );

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr2D_SetTableData) (__in int BoardId, __in int Axis, __in int Row, __in int Col, __in float CorrOfsData );

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr2D_GetTableData) (__in int BoardId, __in int Axis, __in int Row, __in int Col, __out float *CorrOfsData);

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr2D_SetTableFromFile) (__in int BoardId, __in int Axis, __in char *szFilePath, __in int *ErrCode);

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr2D_SetEnable) (__in int BoardId, __in int Axis, __in int IsEnable);

EXTERN LONG (WINAPI *cmcSxCfg_PosCorr2D_GetEnable) (__in int BoardId, __in int Axis, __out int *IsEnable);

EXTERN LONG	(WINAPI *cmcStGetCount_Corr)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out PLONG pdwCount);

EXTERN LONG	(WINAPI *cmcStGetPosition_Corr)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out DOUBLE * Count);

#ifdef __cplusplus
}
#endif


#endif
