﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


using MLink3 = ComiLib.MLink3.SafeNativeMethods;
using MLink3_def = ComiLib.NEMO_Def.SafeNativeMethods;

namespace HommingExample
{
    public partial class HomeSetupForm : Form
    {
        private static int nAxis = 0;
        private static int nHomeMode = 0; // Home Mode
        private static int nHomeClearMode = 0; // Home Clear Mode
        private static int nOrgLogic = 0; // ORG Input Logic
        private static int nEzLogic = 0; // EZ Input Logic
        private static int nEzCount = 0; // EZ Count
        private static int fOffDist = 0; // Offset Distance
        private static int nErrOut = 0; // Output ERC signal at completion
        private static int nSpeedMode = -1; // Speed Mode
        private static double fWorkSpeed = 0; // Work Speed
        private static double fAcceleration = 0; // Acceleration
        private static double fDeceleration = 0; // Deceleration

		// HomeSpeedPattern Phase
		// ORG 감지 후 ORG 탈출하였다가 다시 ORG 감지하는 동작을 예시로 설명
		// Phase 0 : ORG 감지를 위하여 최초 이송 할 때의 속도
		// Phase 1 : ORG 감지 후 탈출 할 때의 속도
		// Phase 2 : ORG 탈출 후 다시 ORG 감지를 위하여 이송할 때의 속도
        private static int nPhaseID = 0;

        public HomeSetupForm(int p_nAxis)
        {
            nAxis = p_nAxis;
            
            InitializeComponent();
        }

        private void HomeSetupForm_Load(object sender, EventArgs e)
        {
            nPhaseID = this.cmbPhaseID.SelectedIndex;

            // 화면에 초기값을 설정하기 위해서 현재 설정되어 있는 속도 패턴을 읽어들인다.
            MLink3.HomeGetConfig(0, nAxis + 3, (int)MLink3_def.HomeParamId.MODE, ref nHomeMode);
            MLink3.HomeGetConfig(0, nAxis + 3, (int)MLink3_def.HomeParamId.OFFSET, ref fOffDist);
            MLink3.HomeGetConfig(0, nAxis + 3, (int)MLink3_def.HomeParamId.EZCOUNT, ref nEzCount);
            MLink3.HomeGetPosClrMode(0, nAxis+3, ref nHomeClearMode);
            MLink3.CfgGetMioProperty(0, nAxis+3, 2, ref nOrgLogic);

            MLink3.HomeGetSpeedPattern(0, nAxis + 3, nPhaseID, ref nSpeedMode, ref fWorkSpeed, ref fAcceleration, ref fDeceleration);

            this.cmbHomeMode.SelectedIndex = (int)nHomeMode;
            this.cmbHomeClrMode.SelectedIndex = (int)nHomeClearMode;
            this.cmbOrgLogic.SelectedIndex = (int)nOrgLogic;
            this.cmbEzLogic.SelectedIndex = (int)nEzLogic;
            this.txtEzCount.Text = nEzCount.ToString();
            this.txtOffset.Text = fOffDist.ToString();

            if (nErrOut > 0)
            {
                this.chkErcOut.Checked = true;
            }
            else
            {
                this.chkErcOut.Checked = false;
            }

            this.cmbSpeedMode.SelectedIndex = (int)nSpeedMode;
            this.txtWorkSpeed.Text = fWorkSpeed.ToString();
            this.txtAcc.Text = fAcceleration.ToString();
            this.txtDec.Text = fDeceleration.ToString();
        }

        private void cmbHomeMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            nHomeMode = this.cmbHomeMode.SelectedIndex;
        }

        private void cmbHomeClrMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            nHomeClearMode = this.cmbHomeClrMode.SelectedIndex;
        }

        private void cmbOrgLogic_SelectedIndexChanged(object sender, EventArgs e)
        {
            nOrgLogic = this.cmbOrgLogic.SelectedIndex;
        }

        private void cmbEzLogic_SelectedIndexChanged(object sender, EventArgs e)
        {
            nEzLogic = this.cmbEzLogic.SelectedIndex;
        }

        private void cmbSpeedMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            nSpeedMode = this.cmbSpeedMode.SelectedIndex;
        }

        private void chkErcOut_Click(object sender, EventArgs e)
        {
            if(this.chkErcOut.Checked)
            {
                nErrOut = 1;
            }
        }

        private void btnApply_Click(object sender, EventArgs e)
        {
            nEzCount = int.Parse(this.txtEzCount.Text);
            fOffDist = Convert.ToInt32(this.txtOffset.Text);

            fWorkSpeed = Convert.ToDouble(this.txtWorkSpeed.Text);
            fAcceleration = Convert.ToDouble(this.txtAcc.Text);
            fDeceleration = Convert.ToDouble(this.txtDec.Text);

            nPhaseID = this.cmbPhaseID.SelectedIndex;


            MLink3.HomeSetConfig(0, nAxis + 3, (int)MLink3_def.HomeParamId.MODE, nHomeMode);
            MLink3.HomeSetConfig(0, nAxis + 3, (int)MLink3_def.HomeParamId.OFFSET, fOffDist);
            MLink3.HomeSetConfig(0, nAxis + 3, (int)MLink3_def.HomeParamId.EZCOUNT, nEzCount);

            MLink3.HomeSetPosClrMode(0, nAxis+3, nHomeClearMode);
            MLink3.CfgSetMioProperty(0, nAxis+3, 2, nOrgLogic);
            MLink3.HomeSetSpeedPattern(0, nAxis + 3, nPhaseID, nSpeedMode, fWorkSpeed, fAcceleration, fDeceleration);
        }

        private void btnQuit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void cmbPhaseID_SelectedIndexChanged(object sender, EventArgs e)
        {
            nPhaseID = this.cmbPhaseID.SelectedIndex;
            MLink3.HomeGetSpeedPattern(0, nAxis + 3, nPhaseID, ref nSpeedMode, ref fWorkSpeed, ref fAcceleration, ref fDeceleration);
            this.cmbSpeedMode.SelectedIndex = (int)nSpeedMode;
            this.txtWorkSpeed.Text = fWorkSpeed.ToString();
            this.txtAcc.Text = fAcceleration.ToString();
            this.txtDec.Text = fDeceleration.ToString();
        }
    }
}
