using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using MLink3 = ComiLib.MLink3.SafeNativeMethods;
using MLink3_def = ComiLib.NEMO_Def.SafeNativeMethods;

namespace SxMotion
{
	public class SxSpeedSettingForm : System.Windows.Forms.Form
	{
		private static int nSetCh = 0;
		private static int nSpeedMode = (int)MLink3_def.SpeedMode.SCURVE;
        private static double fMaxSpeed = 0;
		private static double fInitSpeed = 0;
		private static double fWorkSpeed = 0;
		private static double fAcceleration = 0;
		private static double fDeceleration = 0;

		private System.Windows.Forms.Label lblSpeedMode;
		private System.Windows.Forms.Label lblInitSpeed;
		private System.Windows.Forms.Label lblWorkSpeed;
		private System.Windows.Forms.Label lblAcc;
		private System.Windows.Forms.Label lblDec;
		private System.Windows.Forms.TextBox txtWorkSpeed;
		private System.Windows.Forms.TextBox txtAcc;
		private System.Windows.Forms.TextBox txtDec;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ComboBox cmbSpeedMode;
        private System.Windows.Forms.TextBox txtInitSpeed;
        private Label label6;
        private TextBox txtMaxSpeed;


		private System.ComponentModel.Container components = null;

		public static int SETCH
		{
			get { return nSetCh; }
			set { nSetCh = value; }
		}

        public static int SPEEDMODE
		{
			get { return nSpeedMode; }
			set { nSpeedMode = value; }
		}

        public static double MAXSPEED
        {
            get { return fMaxSpeed; }
            set { fMaxSpeed = value; }
        }

        public static double INITSPEED
		{
			get { return fInitSpeed; }
			set { fInitSpeed = value; }
		}

        public static double WORKSPEED
		{
			get { return fWorkSpeed; }
			set { fWorkSpeed = value; }
		}

        public static double ACCELERATION
		{
			get { return fAcceleration; }
			set { fAcceleration = value; }
		}

        public static double DECELERATION
		{
			get { return fDeceleration; }
			set { fDeceleration = value; }
		}
		
		public SxSpeedSettingForm(int nSelCh)
		{
			SETCH = nSelCh;

			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.lblSpeedMode = new System.Windows.Forms.Label();
            this.lblInitSpeed = new System.Windows.Forms.Label();
            this.lblWorkSpeed = new System.Windows.Forms.Label();
            this.lblAcc = new System.Windows.Forms.Label();
            this.lblDec = new System.Windows.Forms.Label();
            this.txtWorkSpeed = new System.Windows.Forms.TextBox();
            this.txtAcc = new System.Windows.Forms.TextBox();
            this.txtDec = new System.Windows.Forms.TextBox();
            this.btnOK = new System.Windows.Forms.Button();
            this.btnCancel = new System.Windows.Forms.Button();
            this.cmbSpeedMode = new System.Windows.Forms.ComboBox();
            this.txtInitSpeed = new System.Windows.Forms.TextBox();
            this.label6 = new System.Windows.Forms.Label();
            this.txtMaxSpeed = new System.Windows.Forms.TextBox();
            this.SuspendLayout();
            // 
            // lblSpeedMode
            // 
            this.lblSpeedMode.Location = new System.Drawing.Point(16, 32);
            this.lblSpeedMode.Name = "lblSpeedMode";
            this.lblSpeedMode.Size = new System.Drawing.Size(80, 23);
            this.lblSpeedMode.TabIndex = 0;
            this.lblSpeedMode.Text = "Speed Mode";
            // 
            // lblInitSpeed
            // 
            this.lblInitSpeed.Location = new System.Drawing.Point(16, 111);
            this.lblInitSpeed.Name = "lblInitSpeed";
            this.lblInitSpeed.Size = new System.Drawing.Size(80, 23);
            this.lblInitSpeed.TabIndex = 1;
            this.lblInitSpeed.Text = "Ini";
            // 
            // lblWorkSpeed
            // 
            this.lblWorkSpeed.Location = new System.Drawing.Point(16, 151);
            this.lblWorkSpeed.Name = "lblWorkSpeed";
            this.lblWorkSpeed.Size = new System.Drawing.Size(80, 23);
            this.lblWorkSpeed.TabIndex = 2;
            this.lblWorkSpeed.Text = "Work Speed";
            // 
            // lblAcc
            // 
            this.lblAcc.Location = new System.Drawing.Point(16, 191);
            this.lblAcc.Name = "lblAcc";
            this.lblAcc.Size = new System.Drawing.Size(80, 24);
            this.lblAcc.TabIndex = 3;
            this.lblAcc.Text = "Acceleration";
            // 
            // lblDec
            // 
            this.lblDec.Location = new System.Drawing.Point(16, 231);
            this.lblDec.Name = "lblDec";
            this.lblDec.Size = new System.Drawing.Size(80, 23);
            this.lblDec.TabIndex = 4;
            this.lblDec.Text = "Deceleration";
            // 
            // txtWorkSpeed
            // 
            this.txtWorkSpeed.Location = new System.Drawing.Point(112, 146);
            this.txtWorkSpeed.Name = "txtWorkSpeed";
            this.txtWorkSpeed.Size = new System.Drawing.Size(136, 21);
            this.txtWorkSpeed.TabIndex = 10;
            this.txtWorkSpeed.Text = "10000";
            this.txtWorkSpeed.TextChanged += new System.EventHandler(this.txtWorkSpeed_TextChanged);
            // 
            // txtAcc
            // 
            this.txtAcc.Location = new System.Drawing.Point(112, 186);
            this.txtAcc.Name = "txtAcc";
            this.txtAcc.Size = new System.Drawing.Size(136, 21);
            this.txtAcc.TabIndex = 11;
            this.txtAcc.Text = "100000";
            this.txtAcc.TextChanged += new System.EventHandler(this.txtAcc_TextChanged);
            // 
            // txtDec
            // 
            this.txtDec.Location = new System.Drawing.Point(112, 229);
            this.txtDec.Name = "txtDec";
            this.txtDec.Size = new System.Drawing.Size(136, 21);
            this.txtDec.TabIndex = 12;
            this.txtDec.Text = "100000";
            this.txtDec.TextChanged += new System.EventHandler(this.txtDec_TextChanged);
            // 
            // btnOK
            // 
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.Location = new System.Drawing.Point(70, 282);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(88, 40);
            this.btnOK.TabIndex = 13;
            this.btnOK.Text = "OK";
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // btnCancel
            // 
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(182, 282);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(88, 40);
            this.btnCancel.TabIndex = 14;
            this.btnCancel.Text = "Cancel";
            // 
            // cmbSpeedMode
            // 
            this.cmbSpeedMode.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cmbSpeedMode.Items.AddRange(new object[] {
            "CONSTANT",
            "TRAPEZOIDAL",
            "S-CURVE"});
            this.cmbSpeedMode.Location = new System.Drawing.Point(112, 27);
            this.cmbSpeedMode.Name = "cmbSpeedMode";
            this.cmbSpeedMode.Size = new System.Drawing.Size(136, 20);
            this.cmbSpeedMode.TabIndex = 15;
            this.cmbSpeedMode.SelectedIndexChanged += new System.EventHandler(this.cmbSpeedMode_SelectedIndexChanged);
            // 
            // txtInitSpeed
            // 
            this.txtInitSpeed.Location = new System.Drawing.Point(112, 106);
            this.txtInitSpeed.Name = "txtInitSpeed";
            this.txtInitSpeed.Size = new System.Drawing.Size(136, 21);
            this.txtInitSpeed.TabIndex = 16;
            this.txtInitSpeed.Text = "0";
            this.txtInitSpeed.TextChanged += new System.EventHandler(this.txtInitSpeed_TextChanged);
            // 
            // label6
            // 
            this.label6.Location = new System.Drawing.Point(16, 73);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(80, 23);
            this.label6.TabIndex = 1;
            this.label6.Text = "End";
            // 
            // txtMaxSpeed
            // 
            this.txtMaxSpeed.Location = new System.Drawing.Point(112, 68);
            this.txtMaxSpeed.Name = "txtMaxSpeed";
            this.txtMaxSpeed.Size = new System.Drawing.Size(136, 21);
            this.txtMaxSpeed.TabIndex = 16;
            this.txtMaxSpeed.Text = "655350";
            this.txtMaxSpeed.TextChanged += new System.EventHandler(this.txtMaxSpeed_TextChanged);
            // 
            // SpeedSettingForm
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(6, 14);
            this.ClientSize = new System.Drawing.Size(280, 334);
            this.Controls.Add(this.txtMaxSpeed);
            this.Controls.Add(this.txtInitSpeed);
            this.Controls.Add(this.txtDec);
            this.Controls.Add(this.txtAcc);
            this.Controls.Add(this.txtWorkSpeed);
            this.Controls.Add(this.cmbSpeedMode);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.lblDec);
            this.Controls.Add(this.lblAcc);
            this.Controls.Add(this.label6);
            this.Controls.Add(this.lblWorkSpeed);
            this.Controls.Add(this.lblInitSpeed);
            this.Controls.Add(this.lblSpeedMode);
            this.Name = "SpeedSettingForm";
            this.Text = "Speed Pattern Setting";
            this.Load += new System.EventHandler(this.SpeedSettingForm_Load);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SpeedSettingForm_Load(object sender, System.EventArgs e)
		{
			// ȭ鿡 ʱⰪ ϱ ؼ  Ǿ ִ ӵ  оδ. //
			int nSpeedMode=0;
			double fWorkSpeed=0;
			double fAcc=0;
			double fDec=0;
            double fIni = 0, fEnd = 0;

			MLink3.CfgGetSpeedPattern(0, SETCH+3, ref nSpeedMode, ref fWorkSpeed, ref fAcc, ref fDec, ref fIni, ref fEnd);
            MAXSPEED = fEnd;
            INITSPEED = fIni;
			SPEEDMODE = nSpeedMode;
			WORKSPEED = fWorkSpeed;
			ACCELERATION = fAcc;
			DECELERATION = fDec;

			this.cmbSpeedMode.SelectedIndex = SPEEDMODE;
            this.txtMaxSpeed.Text = MAXSPEED.ToString();
			this.txtInitSpeed.Text = INITSPEED.ToString();
			this.txtWorkSpeed.Text = WORKSPEED.ToString();
			this.txtAcc.Text = ACCELERATION.ToString();
			this.txtDec.Text = DECELERATION.ToString();


		}

		private void cmbSpeedMode_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			SPEEDMODE = cmbSpeedMode.SelectedIndex;
		}

        private void txtMaxSpeed_TextChanged(object sender, EventArgs e)
        {
            MAXSPEED = Convert.ToDouble(txtMaxSpeed.Text);
        }

		private void txtInitSpeed_TextChanged(object sender, System.EventArgs e)
		{
			INITSPEED = Convert.ToDouble(txtInitSpeed.Text);
		}

		private void txtWorkSpeed_TextChanged(object sender, System.EventArgs e)
		{
			WORKSPEED = Convert.ToDouble(txtWorkSpeed.Text);		
		}

		private void txtAcc_TextChanged(object sender, System.EventArgs e)
		{
			ACCELERATION = Convert.ToDouble(txtAcc.Text);				
		}

		private void txtDec_TextChanged(object sender, System.EventArgs e)
		{
			DECELERATION = Convert.ToDouble(txtDec.Text);						
		}

        private void btnOK_Click(object sender, EventArgs e)
        {
            MLink3.CfgSetSpeedPattern(0, SETCH+3, SPEEDMODE, WORKSPEED, ACCELERATION, DECELERATION, INITSPEED, MAXSPEED);
        }
	}
}
