﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MLink3 = ComiLib.MLink3.SafeNativeMethods;
using MLink3_def = ComiLib.NEMO_Def.SafeNativeMethods;

namespace OverrideSpeed
{
    public partial class OverrideSpeed : Form
    {
        private static double fWorkSpeed = 0;
        private static double fAcceleration = 0;
        private static double fDeceleration = 0;
        private static double fIni = 0;
        private static double fEnd = 0;
        
        public OverrideSpeed()
        {
            InitializeComponent();
        }

        // common function
        void InitMotionDevices()
        {
            // SERVO-ON //
            for (int i = 0; i < 16; i++)
            {
                MLink3.GnSetServoOn(0, i+3, 1);
            }
        }

        private void OverrideSpeed_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoardID = new int();
            int nNumAxes = new int();

            if (MLink3.GnLoadDevice(ref NumDevice, ref BoardID, ref nNumAxes) != 0)
            {
                MessageBox.Show("Can't load device");
                return;
            }
            else
            {
                // Motion 환경 초기화 //
                InitMotionDevices();

                ////////////////////////////////////////////////////////////////////////////////////
                int i;

                for (i = 0; i < 16; i++)
                {
                    this.cmbAxis.Items.Insert(i, "Axis" + i.ToString());
                }

                // 축선택의 기본값으로는 0번과 1번 두 축이 선택된 것으로 한다.
                this.cmbAxis.SelectedIndex = 0;

                cmbAxis_SelectedIndexChanged(null, null);

                // Set timer to read and display current command position //
                this.timer1.Start();
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            string sPos;
            double afCurPos = 0;

            // Command position display //
            MLink3.StGetPosition(0, nAxis+3, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosC.Text = sPos;

            // Feedback position display //
            MLink3.StGetPosition(0, nAxis+3, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosF.Text = sPos;

            // Command velocity display //
            MLink3.StGetSpeed(0, nAxis+3, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblVelC.Text = sPos;

            // Feedback velocity display //
            MLink3.StGetSpeed(0, nAxis+3, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblVelF.Text = sPos;

            //-------- 각 버튼의 Dimmed 처리를 상황에 맞추어서 수행 ---------//
            int nIsStopped = 0;
            MLink3.SxIsDone(0, nAxis+3,ref nIsStopped);
            if (nIsStopped == 1)
            {
                this.btnStart.Enabled = true;
                this.btnStop.Enabled = false;

            }
            else
            {
                this.btnStart.Enabled = false;
                this.btnStop.Enabled = true;
                this.btnOverPattern.Enabled = true;
            }
        }

        //**********************************************************************************
        // OnSelchangeAxisSel(): "Axis" Combobox의 선택이 변경되었을 때 호출되는 이벤트 핸들러
        // 축 선택이 바뀌면 해당 축의 현재 속도 설정을 읽어서 화면을 업데이트해준다.
        //**********************************************************************************
        private void cmbAxis_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            int nMode = 0;
            MLink3.CfgGetSpeedPattern(0, nAxis+3, ref nMode, ref fWorkSpeed, ref fAcceleration, ref fDeceleration, ref fIni, ref fEnd);
            this.cmbSpeedMode.SelectedIndex = nMode;

        }


        //**************************************************************************************
        // OnOverrideSpeedPattern(): "Speed Pattern" 그룹의 "Override" 버튼의 이벤트 핸들러.
        // 정격속도 설정을 오버라이딩한다. 
        //**************************************************************************************
        private void btnOverPattern_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            int nSpeedMode = this.cmbSpeedMode.SelectedIndex;
            MLink3.CfgSetSpeedPattern(0, nAxis+3, nSpeedMode, fWorkSpeed, fAcceleration, fDeceleration, fIni, fEnd); // 오버라이딩할 속도를 설정한다.
            MLink3.OverrideSpeedSet(0, nAxis+3); // 여기에서 실제 속도 오버라이딩이 수행된다. 

            this.lblStatus.Text = "속도 오버라이드 적용 됨";
        }


        //**************************************************************************************
        // OnStart(): "Start" 버튼 이벤트 핸들러. (+) 방향으로 속도모드 조그 이송을 시작한다.
        // 일반적으로 속도 설정을 할때 환경설정에서 정격속도를 설정해놓고 프로그램에서는 
        // 속도비를 조절하여 사용하는 것이 일반적이다. 따라서 일반적으로는 cmmSxSetSpeedRatio()만
        // 을 사용하면 된다. 본 예제에서는 cmmCfgSetSpeedPattern()에 의해서 결정되는 정격속도도
        // Overriding 될 수 있음을 예시하기 위해서 cmmCfgSetSpeedPattern() 함수도 함께 사용하였다.
        //**************************************************************************************
        private void btnStart_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;

            int nSpeedMode = this.cmbSpeedMode.SelectedIndex;
            // 정격속도 설정 //
            MLink3.CfgSetSpeedPattern(0, nAxis+3, nSpeedMode, fWorkSpeed, fAcceleration, fDeceleration, fIni, fEnd);
 
            if (MLink3.SxVMoveStart(0, nAxis+3, (int)MLink3_def.PmDir.PM_DIR_P) != (int)MLink3_def.ERROR_CODES.ERR_NONE)
            {
                MessageBox.Show("SxVMoveStart Error");
            }

            this.lblStatus.Text = "이송 시작됨, 이제 이송 속도 및 속도비율을 재설정 하시고 Override 버튼을 클릭하세요";
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            MLink3.SxStop(0, nAxis+3);

            this.lblStatus.Text = "정지됨";
        }

        private void OverrideSpeed_FormClosing(object sender, FormClosingEventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            MLink3.SxStop(0, nAxis+3);

            // 사용중인 타이머 종료.
            timer1.Stop();

            MLink3.GnUnloadDevice(); // Unload Device
        }

        private void txtVwork_TextChanged(object sender, EventArgs e)
        {
            fWorkSpeed = Convert.ToDouble(this.txtVwork.Text);
        }

        private void txtAcc_TextChanged(object sender, EventArgs e)
        {
            fAcceleration = Convert.ToDouble(this.txtAcc.Text);
        }

        private void txtDec_TextChanged(object sender, EventArgs e)
        {
            fDeceleration = Convert.ToDouble(this.txtDec.Text);
        }
    }
}
