﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MLink3 = ComiLib.MLink3.SafeNativeMethods;
using MLink3_def = ComiLib.NEMO_Def.SafeNativeMethods;

namespace OverridePosition
{
    public partial class OverridePosition : Form
    {
        SpeedSettingForm m_frmSpeedSetup = null;
        
        public OverridePosition()
        {
            InitializeComponent();
        }

        // common function
        void InitMotionDevices()
        {
            for (int i = 0; i < 16; i++)
            {
               MLink3.GnSetServoOn(0, i+3, 1);
            }
        }

        private void OverridePosition_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoardID = new int();
            int nNumAxes = new int();

            if (MLink3.GnLoadDevice(ref NumDevice, ref BoardID, ref nNumAxes) != 0)
            {
                MessageBox.Show("Can't load device");
                return;
            }
            else
            {
                // Motion 환경 초기화 //
                InitMotionDevices();

                ////////////////////////////////////////////////////////////////////////////////////
                int i;

                for (i = 0; i < 16; i++)
                {
                    this.cmbAxis.Items.Insert(i, "Axis" + i.ToString());
                }

                // 축선택의 기본값으로는 0번과 1번 두 축이 선택된 것으로 한다.
                this.cmbAxis.SelectedIndex = 0;

                // 초기 속도 패턴 설정
                for (i = 0; i < 16; i++)
                {
                    MLink3.CfgSetSpeedPattern(0, i+3, (int)MLink3_def.SpeedMode.SCURVE, 10000, 100000, 100000,0,0);
                }

                // Set timer to read and display current command position //
                this.timer1.Start();
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            //------- 모션제어기 위치 모니터링 -------------------------------//
            int nAxis = this.cmbAxis.SelectedIndex;
            string sPos;
            double afCurPos = 0;
            // Command position (X) //
            MLink3.StGetPosition(0, nAxis+3, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosC.Text = sPos;
            // Feedback position (X) //
            MLink3.StGetPosition(0, nAxis+3, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosF.Text = sPos;

            int nIsStopped = 0;
            MLink3.SxIsDone(0, nAxis+3, ref nIsStopped);
            if (nIsStopped == 0)
            {
                this.btnMove.Text = "Override";
            }
            else
            {
                this.btnMove.Text = "Move";
                this.lblStatus.Text = "정지상태";
            }
        }

        /***********************************************************************
        * OnResetPos() : Position "Reset" 버튼의 콜백함수. Command & Feedback 
        * position을 0으로 리셋한다.
        ***********************************************************************/
        private void btnResetPos_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            MLink3.StSetPosition(0, nAxis+3, 0, 0.0); // Reset command position of X-axis
            MLink3.StSetPosition(0, nAxis+3, 1, 0.0); // Reset feedback position of X-axis
        }

        private void btnSpeedSetup_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;

            if (IsFormExist(typeof(SpeedSettingForm)) == null)
            {
                m_frmSpeedSetup = new SpeedSettingForm(nAxis);
            }

            m_frmSpeedSetup.ShowDialog();
            m_frmSpeedSetup.Focus();
        }

        private void btnMove_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            int nIsStopped = 0;
            int nResult = 0;
            
            int nPosVal = int.Parse(this.txtPosVal.Text);
            bool boolIsAbsMode = this.rdoAbsPos.Checked;
            MLink3.SxIsDone(0, nAxis+3,ref nIsStopped);
            if (nIsStopped == 1)
            {
                if(boolIsAbsMode)
                {
                    MLink3.SxMoveToStart(0, nAxis+3, nPosVal);
                }
                else
                {
                    MLink3.SxMoveStart(0, nAxis+3, nPosVal);
                }
                this.lblStatus.Text = "이송 시작됨, 이제 이송 거리를 재설정 하시고 Override 버튼을 클릭하세요";
            }
            else
            {
                if (boolIsAbsMode)
                {
                    int nIsIgnord = 0;
                    nResult = MLink3.OverrideMoveTo(0, nAxis+3, nPosVal, ref nIsIgnord);
                    if(nResult != (int)MLink3_def.ERROR_CODES.ERR_NONE)
                    {
                        MessageBox.Show("OverrideMoveTo Error");
                    }
                    // nIsIgnord==1 이면 이송이 이미 완료되었거나 감속이 거의 끝난 상태로 오버라이드가 무시된 경우이다. 이때는 절대치 목표좌표 까지 단축 이송으로 보정 이송해줄 필요가 있다.//
                    if (nIsIgnord == 1) // 이송이 완료되었어도 반드시 해당위치로 가야한다면 아래와 같이 MoveTo 함수를 수행해준다.
                    {
                        DialogResult result = MessageBox.Show("오버라이드가 무시됨", "Confirm", MessageBoxButtons.YesNo);

                        if (result == DialogResult.Yes)
                        {
                            MLink3.SxMoveToStart(0, nAxis+3, nPosVal);
                            MLink3.SxWaitDone(0, nAxis+3, 0);
                        }
                    }
                    else
                    {
                        this.lblStatus.Text = "위치 오버라이드 적용 됨";
                    }
                }
                else
                {
                    int nIsIgnord = 0;
                    nResult = MLink3.OverrideMove(0, nAxis+3, nPosVal, ref nIsIgnord);
                    if (nResult != (int)MLink3_def.ERROR_CODES.ERR_NONE)
                    {
                        MessageBox.Show("OberrideMove Error");
                    }

                    if (nIsIgnord == 1) // 이송이 완료되었어도 반드시 해당위치로 가야한다면 아래와 같이 MoveTo 함수를 수행해준다.
                    {
                        MessageBox.Show("오버라이드가 무시됨", "Confirm", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                    else
                    {
                        this.lblStatus.Text = "위치 오버라이드 적용 됨";
                    }
                }
            }
        }

        /***********************************************************************
        * OnbtnStop() : Position "Reset" 버튼의 콜백함수. Command & Feedback 
        * position을 0으로 리셋한다.
        ***********************************************************************/
        private void btnStop_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            MLink3.SxStop(0, nAxis+3);
            this.lblStatus.Text = "정지됨";
        }

        // Form Check
        private Form IsFormExist(Type FormType)
        {
            foreach (Form OpenForm in Application.OpenForms)
            {
                if (OpenForm.GetType() == FormType)
                    return OpenForm;
            }
            return null;
        }

        private void OverridePosition_FormClosing(object sender, FormClosingEventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            MLink3.SxStop(0, nAxis+3);

            // 사용중인 타이머 종료.
            timer1.Stop();

            MLink3.GnUnloadDevice(); // Unload Device
        }
    }
}
