﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

using MLink3 = ComiLib.MLink3.SafeNativeMethods;
using MLink3_def = ComiLib.NEMO_Def.SafeNativeMethods;

namespace MxMotion
{
    public partial class MxMotion : Form
    {
        private bool m_bThreadStop = true;
        private int m_nNumWorkCh = 4;
        private int m_nOpMode = 0;

        double[] m_afCmdPos;
        double[] m_afFeedPos;
        int[]    m_nAxes;
        int[]    m_nAxesList;
        int      m_nAxesCount = 0;
        
        // properties
        public int SELOPMODE
        {
            get { return m_nOpMode; }
            set { m_nOpMode = value; }
        }
        public int NUMWORKCH
        {
            get { return m_nNumWorkCh; }
            set { m_nNumWorkCh = value; }
        }
        
        public MxMotion()
        {
            InitializeComponent();
        }

        // common function
        void InitMotionDevices()
        {
            for (int i = 0; i < 16; i++)
            {
               MLink3.GnSetServoOn(0, i+3, 1);
            }
        }

        /***********************************************************************
		* "Speed Setup" Button's event handler. 속도패턴 설정
		* 을 변경할 수 있는 대화상자를 디스플레이하고 변경된 속도패턴을 컨트롤러
		* 적용합니다. 이 것은 cmmCfgSetSpeedPattern() 함수의 사용을 예시하기
		* 위한 예제 코드입니다. 그러나 일반적으로 속도패턴은 CME 파일에서 설정
		* 하므로 cmmCfgSetSpeedPattern() 함수는 사용할 필요가 없는 경우가 많습니다. 
		* 대신에, cmmSxSetSpeedRatio() 함수를 이용하여 이송속도를 설정하는 것이
		* 일반적입니다.
		***********************************************************************/
        private void btnSetSpdPattern_Click(object sender, EventArgs e)
        {
            // 사용자가 선택한 축 리스트
            getAxesInfo();

            if (m_nAxesCount < 1)
            {
                MessageBox.Show("모션 축을 선택해주세요.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            SpeedSettingForm frmSpeedSetting = new SpeedSettingForm(m_nAxesList, NUMWORKCH);
            
            frmSpeedSetting.ShowDialog();
        }

        private void MxMotion_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoardID = new int();
            int nNumAxes = new int();

            if (MLink3.GnLoadDevice(ref NumDevice, ref BoardID, ref nNumAxes) != 0)
            {
                MessageBox.Show("Can't load device");
                return;
            }
            else
            {
                // Motion 환경 초기화 //
                InitMotionDevices();


                // COMI-LX502 2축모션컨트롤러만 장착되어 있는 경우에는 2축만 선택가능하도록...//
                if (nNumAxes == 2)
                {
                    NUMWORKCH = 2;

                    this.chkAxis2.Enabled = false;
                    this.chkAxis3.Enabled = false;
                }

                // 축선택의 기본값으로는 0번과 1번 두 축이 선택된 것으로 한다.
                this.chkAxis0.Checked = true;
                this.chkAxis1.Checked = true;

                // command 와 feedback postion list 를 저장할 배열 정의.
                m_afCmdPos = new double[NUMWORKCH];
                m_afFeedPos = new double[NUMWORKCH];

                // 초기 거리값 설정
                this.txtDist.Text = "10000";
                this.txtPos1.Text = "0";
                this.txtPos2.Text = "10000";

                OnJogModeSelectInit(1); // Jog 모드에 따른 각 에디트박스 Dimmed 처리를 위해서...
                

                // Set timer to display current command position //
                this.timer1.Start();

                // 쓰레드 동작을 시작한다.
                m_bThreadStop = false;
                new Thread(new ThreadStart(ThreadFunc)).Start();
            }
        }

        // 쓰레드 함수: 각 Axis 에 대한 현재 command 및 feedback position 값들을 얻는다.
        private void ThreadFunc()
        {
            double afPos = 0;

            while (!m_bThreadStop)
            {
                for (int i = 0; i < 4; i++)
                {
                    // Command position //
                    MLink3.StGetPosition(0, i+3, 0, ref afPos);
                    m_afCmdPos[i] = afPos;

                    // Feedback position //
                    MLink3.StGetPosition(0, i+3, 1, ref afPos);
                    m_afFeedPos[i] = afPos;
                }

                // 100밀리초만큼 sleep 을 준다.
                Thread.Sleep(100);
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            //------- 모션제어기 위치 모니터링 -------------------------------//

            // 본예제는 코드의 간결성을 위해서 4축 제어를 전제로 하여 작성되었다. //
            // 단, 2축 보드만 장착되어 있는 경우에는 2축 정보만 읽도록 한다.      //


            for (int i = 0; i < 4; i++)
            {
                // Command position & Feedback position 출력//
                if (i == 0)
                {
                    this.lblPosC0.Text = m_afCmdPos[i].ToString();
                    this.lblPosF0.Text = m_afFeedPos[i].ToString();
                }
                else if (i == 1)
                {
                    this.lblPosC1.Text = m_afCmdPos[i].ToString();
                    this.lblPosF1.Text = m_afFeedPos[i].ToString();
                }
                else if (i == 2)
                {
                    this.lblPosC2.Text = m_afCmdPos[i].ToString();
                    this.lblPosF2.Text = m_afFeedPos[i].ToString();
                }
                else if (i == 3)
                {
                    this.lblPosC3.Text = m_afCmdPos[i].ToString();
                    this.lblPosF3.Text = m_afFeedPos[i].ToString();
                }
            }
        }

        /***********************************************************************
        * "Stop" Button's event handler
        * : This button stops motion of specifed axis
        ***********************************************************************/
        private void btnStop_Click(object sender, EventArgs e)
        {
            this.btnPlus.Enabled = true;
            this.btnMinus.Enabled = true;

            int[] anAxes = new int[NUMWORKCH];
            for (int i = 0; i < NUMWORKCH; i++)
                anAxes[i] = i+3;

            MLink3.MxStop(0, NUMWORKCH, anAxes);
        }

        /***********************************************************************
        * "Emergency-Stop" Button's event handler
        * Emergency Stop Button
        ***********************************************************************/
        private void btnStopEmg_Click(object sender, EventArgs e)
        {
            this.btnPlus.Enabled = true;
            this.btnMinus.Enabled = true;

            int[] anAxes = new int[NUMWORKCH];
            for (int i = 0; i < NUMWORKCH; i++)
                anAxes[i] = i+3;

            MLink3.MxStopEmg(0, NUMWORKCH, anAxes);
        }

        /***********************************************************************
        * Position "Reset" 버튼의 콜백함수. Command & Feedback 
        * position을 0으로 리셋한다.
        ***********************************************************************/
        private void btnResetPos_Click(object sender, EventArgs e)
        {
            // 본예제는 코드의 간결성을 위해서 4축 제어를 전제로 하여 작성되었다. //
            for (int i = 0; i < 4; i++)
            {
                MLink3.StSetPosition(0, i+3, 0, 0.0); // Reset COMMAND Position
                MLink3.StSetPosition(0, i+3, 1, 0.0); // Reset FEEDBACK Position
            }
        }

        /***********************************************************************
        * Jog Mode Settings Radio Button Handler
        ***********************************************************************/
        public void OnJogModeSelectInit(int nJogMode)
        {
            if (nJogMode == 1)
            {
                SELOPMODE = 0;

                this.lblDist.Enabled = false;
                this.txtDist.Enabled = false;
                this.lblPos1.Enabled = false;
                this.txtPos1.Enabled = false;
                this.lblPos2.Enabled = false;
                this.txtPos2.Enabled = false;
                this.btnStop.Enabled = false;
                this.btnStopEmg.Enabled = false;
                this.btnMinus.Text = "Jog (-)";
                this.btnPlus.Text = "Jog (+)";
            }
            else if (nJogMode == 2)
            {
                SELOPMODE = 1;

                this.lblDist.Enabled = true;
                this.txtDist.Enabled = true;
                this.lblPos1.Enabled = false;
                this.txtPos1.Enabled = false;
                this.lblPos2.Enabled = false;
                this.txtPos2.Enabled = false;
                this.btnStop.Enabled = true;
                this.btnStopEmg.Enabled = true;
                this.btnMinus.Text = "Move (-)";
                this.btnPlus.Text = "Move (+)";
            }
            else if (nJogMode == 3)
            {
                SELOPMODE = 2;

                this.lblDist.Enabled = false;
                this.txtDist.Enabled = false;
                this.lblPos1.Enabled = true;
                this.txtPos1.Enabled = true;
                this.lblPos2.Enabled = true;
                this.txtPos2.Enabled = true;
                this.btnStop.Enabled = true;
                this.btnStopEmg.Enabled = true;
                this.btnMinus.Text = "Position1";
                this.btnPlus.Text = "Position2";
            }
        }

        /***********************************************************************
        * Jog Mode Settings Radio Button Handler
        ***********************************************************************/
        private void OnJogModeSelect(object sender, EventArgs e)
        {
            if (sender == rdoJogMove)
            {
                OnJogModeSelectInit(1);
            }
            else if (sender == rdoRelPosMove)
            {
                OnJogModeSelectInit(2);
            }
            else if (sender == rdoAbsPosMove)
            {
                OnJogModeSelectInit(3);
            }
        }

        // 사용자가 선택한 축 리스트를 얻는다
        public void getAxesInfo()
        {
            m_nAxesCount = 0;
            int nAxisCount = 0;

            m_nAxes = new int[NUMWORKCH];
            m_nAxesList = new int[NUMWORKCH];
            
            if (chkAxis0.Checked)
            {
                m_nAxesList[nAxisCount++] = 0;
                m_nAxes[m_nAxesCount++] = 3;
            }
            else
            {
                m_nAxesList[nAxisCount++] = -1;
            }

            if (chkAxis1.Checked)
            {
                m_nAxesList[nAxisCount++] = 1;
                m_nAxes[m_nAxesCount++] = 4;
            }
            else
            {
                m_nAxesList[nAxisCount++] = -1;
            }

            if (chkAxis2.Checked)
            {
                m_nAxesList[nAxisCount++] = 2;
                m_nAxes[m_nAxesCount++] = 5;
            }
            else
            {
                m_nAxesList[nAxisCount++] = -1;
            }

            if (chkAxis3.Checked)
            {
                m_nAxesList[nAxisCount++] = 3;
                m_nAxes[m_nAxesCount++] = 6;
            }
            else
            {
                m_nAxesList[nAxisCount++] = -1;
            }
        }

        private void FuncMxMove(int nDirection)
        {
            int i;
            
            double[] afDistList = new double[NUMWORKCH];
            double[] afPosList = new double[NUMWORKCH];
            int[] anDirectionList = new int[4];


            anDirectionList[0] = nDirection;
            anDirectionList[1] = nDirection;
            anDirectionList[2] = nDirection;
            anDirectionList[3] = nDirection;

            // 사용자가 선택한 축 리스트
            getAxesInfo();

            if (SELOPMODE == 0)
            {
                if (MLink3.MxVMoveStart(0, m_nAxesCount, m_nAxes, anDirectionList) != 0)
                {
                    MessageBox.Show("MxVMoveStart Error");
                }
            }
            else
            {
                this.btnPlus.Enabled = false;
                this.btnMinus.Enabled = false;

                if (SELOPMODE == 1)
                {
                    double fDistance = Convert.ToDouble(this.txtDist.Text);

                    // "Move (-)"버튼이면 Distance에 음수를 취하고, "Move (+)" 버튼이면 양수를 취한다 //
                    fDistance = (nDirection == 0) ? -fDistance : fDistance;

                    for (i = 0; i < m_nAxesCount; i++)
                    {
                        afDistList[i] = fDistance;
                    }

                    // [CAUTION] cmmMxMove() 함수의 IsBlocking 파라미터에 대하여:
                    // 본예제는 편의상 이송중에도 타이머 이벤트나 Stop 버튼 이벤트 처리를 할 수 있도록 
                    // IsBlocking 파라미터를 FALSE로 하였다. 하지만 쓰레드를 사용할 때는 IsBlocking 
                    // 파라미터를 반드시 TRUE로 해야한다. 
                    if (MLink3.MxMove(0, m_nAxesCount, m_nAxes, afDistList, 0) != 0)
                    {
                        MessageBox.Show("MxMove Error");
                    }
                }
                else if(SELOPMODE == 2)
				{
					double fPos1 = Convert.ToDouble(this.txtPos1.Text);
					double fPos2 = Convert.ToDouble(this.txtPos2.Text);

                    double fPosition = (nDirection == 0) ? fPos1 : fPos2;

                    for (i = 0; i < m_nAxesCount; i++)
					{
						afPosList[i] = fPosition;
					}

                    if (MLink3.MxMoveTo(0, m_nAxesCount, m_nAxes, afPosList, 0) != 0)
					{
                        MessageBox.Show("MxMoveTo Error");
					}
				}

				this.btnPlus.Enabled = true;
				this.btnMinus.Enabled = true;
            }
        }

        private void btnMinus_MouseDown(object sender, MouseEventArgs e)
        {
            // 사용자가 선택한 축 리스트
            getAxesInfo();
            
            if (m_nAxesCount < 1)
            {
                MessageBox.Show("모션 축을 선택해주세요.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            FuncMxMove(0);
        }

        private void btnMinus_MouseUp(object sender, MouseEventArgs e)
        {
            if (SELOPMODE != 0)    // Velocity Move
                return;

            // if Jog Control 모드이면, 모션 정지.
            int[] anAxes = new int[NUMWORKCH];
            for (int i = 0; i < NUMWORKCH; i++)
                anAxes[i] = i;

            MLink3.MxStop(0, 4, m_nAxes);
        }

        private void btnPlus_MouseDown(object sender, MouseEventArgs e)
        {
            // 사용자가 선택한 축 리스트
            getAxesInfo();
            
            if (m_nAxesCount < 1)
            {
                MessageBox.Show("모션 축을 선택해주세요.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            
            FuncMxMove(1);
        }

        private void btnPlus_MouseUp(object sender, MouseEventArgs e)
        {
            if (SELOPMODE != 0)    // Velocity Move
                return;

            // if Jog Control 모드이면, 모션 정지.
            int[] anAxes = new int[NUMWORKCH];
            for (int i = 0; i < NUMWORKCH; i++)
                anAxes[i] = i;

            MLink3.MxStop(0, 4, m_nAxes);
        }

        private void MxMotion_FormClosing(object sender, FormClosingEventArgs e)
        {
            // 사용중인 타이머, 쓰레드 종료.
            timer1.Stop();
            m_bThreadStop = true;

            int[] anAxes = new int[NUMWORKCH];
            for (int i = 0; i < NUMWORKCH; i++)
                anAxes[i] = i;

            MLink3.MxStop(0, 4, m_nAxes);

            MLink3.GnUnloadDevice(); // Unload Device
        }
    }
}
