﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MLink3 = ComiLib.MLink3.SafeNativeMethods;
using MLink3_def = ComiLib.NEMO_Def.SafeNativeMethods;

namespace MxMotion
{
    public partial class SpeedSettingForm : Form
    {
        private static int nSetCh = 0;
        private static int nSpeedMode = 2;
        private static double fMaxSpeed = 0;
        private static double fInitSpeed = 0;
        private static double fWorkSpeed = 0;
        private static double fAcceleration = 0;
        private static double fDeceleration = 0;

        int[] m_nAxes;
        int   m_nAxesCount = 0;
        
        public static int SETCH
        {
            get { return nSetCh; }
            set { nSetCh = value; }
        }

        public static int SPEEDMODE
        {
            get { return nSpeedMode; }
            set { nSpeedMode = value; }
        }

        public static double MAXSPEED
        {
            get { return fMaxSpeed; }
            set { fMaxSpeed = value; }
        }

        public static double INITSPEED
        {
            get { return fInitSpeed; }
            set { fInitSpeed = value; }
        }

        public static double WORKSPEED
        {
            get { return fWorkSpeed; }
            set { fWorkSpeed = value; }
        }

        public static double ACCELERATION
        {
            get { return fAcceleration; }
            set { fAcceleration = value; }
        }

        public static double DECELERATION
        {
            get { return fDeceleration; }
            set { fDeceleration = value; }
        }

        public SpeedSettingForm(int[] p_nAxes, int p_nAxesCount)
        {
            m_nAxes = p_nAxes; // MxMotion Form 에서 설정된 Checkbox 에 Check 된 Axis 축 List
            m_nAxesCount = p_nAxesCount; // MxMotion Form 에서 설정된 Checkbox Axis 축 갯수
            
            InitializeComponent();
        }

        private void SpeedSettingForm_Load(object sender, EventArgs e)
        {
            // 축설정 콤보박스에 축리스트를 채워넣습니다. 
           
            cmbAxisList.Items.Clear(); // Clear combobox
            string szTitle;

            for (int i = 0; i < 15; i++)
            {
                szTitle = "";
                for (int j = 3; j < 19; j++)
                {
                    szTitle += Convert.ToChar(j);
                }

                if (m_nAxes[i] > -1)
                {
                    cmbAxisList.Items.Add(szTitle);
                }
            }

            // 축설정 콤보박스 초기 선택값 지정
            if (cmbAxisList.Items.Count > 0)
                cmbAxisList.SelectedIndex = 0;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            
            MLink3.CfgSetSpeedPattern(0, SETCH+3, SPEEDMODE, WORKSPEED, ACCELERATION, DECELERATION, INITSPEED, MAXSPEED); // 속도패턴(SPEEDMODE : CONSTANT, TRAPEZOIDAL, S-CURVE), 작업속도(WORKSPEED), 가속도(ACCELERATION), 감속도(DECELERATION) 설정
        }

        private void cmbSpeedMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            SPEEDMODE = cmbSpeedMode.SelectedIndex;
        }

        private void txtMaxSpeed_TextChanged(object sender, EventArgs e)
        {
            MAXSPEED = Convert.ToDouble(txtMaxSpeed.Text);
        }

        private void txtInitSpeed_TextChanged(object sender, EventArgs e)
        {
            INITSPEED = Convert.ToDouble(txtInitSpeed.Text);
        }

        private void txtWorkSpeed_TextChanged(object sender, EventArgs e)
        {
            WORKSPEED = Convert.ToDouble(txtWorkSpeed.Text);
        }

        private void txtAcc_TextChanged(object sender, EventArgs e)
        {
            ACCELERATION = Convert.ToDouble(txtAcc.Text);
        }

        private void txtDec_TextChanged(object sender, EventArgs e)
        {
            DECELERATION = Convert.ToDouble(txtDec.Text);
        }

        private void cmbAxisList_SelectedIndexChanged(object sender, EventArgs e)
        {
            // Combobox 에 선택된 Axis(축) 을 기준으로 설정
            nSetCh = int.Parse(cmbAxisList.SelectedItem.ToString().Substring(4, 6));

            // 화면에 초기값을 설정하기 위해서 현재 설정되어 있는 속도 패턴을 읽어들인다.
            
            int nSpeedMode = 0;
            double fWorkSpeed = 0;
            double fAcc = 0;
            double fDec = 0;
            double fini = 0, fend = 0;

            MLink3.CfgGetSpeedPattern(0, SETCH+3, ref nSpeedMode, ref fWorkSpeed, ref fAcc, ref fDec, ref fini, ref fend);
            MAXSPEED = fend;
            INITSPEED = fini;
            SPEEDMODE = nSpeedMode;
            WORKSPEED = fWorkSpeed;
            ACCELERATION = fAcc;
            DECELERATION = fDec;

            this.cmbSpeedMode.SelectedIndex = SPEEDMODE;
            this.txtMaxSpeed.Text = MAXSPEED.ToString();
            this.txtInitSpeed.Text = INITSPEED.ToString();
            this.txtWorkSpeed.Text = WORKSPEED.ToString();
            this.txtAcc.Text = ACCELERATION.ToString();
            this.txtDec.Text = DECELERATION.ToString();

        }
    }
}
