﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MLink3 = ComiLib.MLink3.SafeNativeMethods;
using MLink3_def = ComiLib.NEMO_Def.SafeNativeMethods;

namespace IxLinear
{
    public partial class IxLinear : Form
    {
        private int m_nNumWorkCh = 2;
        private int m_nOpMode = 0;

        private bool m_bIsIxMapValid = false;
        private const int IX_MAP_IDX = 0;  // Interpolation Map Index

        double[] m_afCmdPos;
        double[] m_afFeedPos;

        // properties
        public int SELOPMODE
        {
            get { return m_nOpMode; }
            set { m_nOpMode = value; }
        }
        public int NUMWORKCH
        {
            get { return m_nNumWorkCh; }
            set { m_nNumWorkCh = value; }
        }

        // common function
        void InitMotionDevices()
        {
            for (int i = 0; i < 16; i++)
            {
                MLink3.GnSetServoOn(0, i+3, 1);
            }
        }
        
        public IxLinear()
        {
            InitializeComponent();
        }

        private void IxLinear_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoardID = new int();
            int nNumAxes = new int();

            if (MLink3.GnLoadDevice(ref NumDevice, ref BoardID, ref nNumAxes) != 0)
            {
                MessageBox.Show("Can't load device");
                return;
            }
            else
            {
                
                // Motion 환경 초기화 //
                InitMotionDevices();

                ////////////////////////////////////////////////////////////////////////////////////
                int i;

                // command 와 feedback postion list 를 저장할 배열 정의.
                m_afCmdPos = new double[NUMWORKCH];
                m_afFeedPos = new double[NUMWORKCH];

                // 사용 가능한 축의 갯수 얻어오기

                for (i = 0; i < 16; i++)
                {
                    this.cmbXAxis.Items.Insert(i, "Axis" + i.ToString());
                    this.cmbYAxis.Items.Insert(i, "Axis" + i.ToString());
                }

                // 축선택의 기본값으로는 0번과 1번 두 축이 선택된 것으로 한다.
                this.cmbXAxis.SelectedIndex = 0;
                this.cmbYAxis.SelectedIndex = 1;

                // 초기 속도 모드
                this.cmbMstSpdMode.SelectedIndex = 2;
                this.cmbVecSpdMode.SelectedIndex = 2;

                // 초기 거리값 설정
                this.txtXAxisPos.Text = "10000";
                this.txtYAxisPos.Text = "10000";

                this.txtMstVelSpd.Text = "100";
                this.txtMstAccSpd.Text = "100";
                this.txtMstDecSpd.Text = "100";
                this.txtVecVelSpd.Text = "10000";
                this.txtVecAccSpd.Text = "100000";
                this.txtVecDecSpd.Text = "100000";

                // 초기 속도 패턴 설정
                for (i = 0; i < 16; i++)
                {
                    MLink3.CfgSetSpeedPattern(0, i+3, 2, 10000, 100000, 100000,0,0);
                }

                OnSpeedModeChanged(this.rdoMstSpdMode, null);

                // Set timer to read and display current command position //
                this.timer1.Start();
            }
        }

        private void IxLinear_FormClosing(object sender, FormClosingEventArgs e)
        {
            // 사용중인 타이머 종료.
            timer1.Stop();

            MLink3.GnUnloadDevice(); // Unload Device
        }

        /***********************************************************************
		* TIMER event handler
		* : display command and feedback position list
		***********************************************************************/
        private void timer1_Tick(object sender, EventArgs e)
        {
            //------- 모션제어기 위치 모니터링 -------------------------------//
            int nAxisX = this.cmbXAxis.SelectedIndex;
            int nAxisY = this.cmbYAxis.SelectedIndex;
            string sPos;
            double afCurPos = 0;

            // Command position (X) //
            MLink3.StGetPosition(0, nAxisX+3, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.txtCmdXAxis.Text = sPos;
            // Feedback position (X) //
            MLink3.StGetPosition(0, nAxisX+3, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.txtFeedXAxis.Text = sPos;
            // Command position (Y) //
            MLink3.StGetPosition(0, nAxisY+3, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.txtCmdYAxis.Text = sPos;
            // Feedback position (Y) //
            MLink3.StGetPosition(0, nAxisY+3, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.txtFeedYAxis.Text = sPos;

            if (this.rdoVecSpdMode.Checked)
            {
                this.txtMstAxisCompare.Text = "Master 축 확인";
            }
            else
            {
                if (Convert.ToDouble(this.txtXAxisPos.Text) >= Convert.ToDouble(this.txtYAxisPos.Text))
                {
                    this.txtMstAxisCompare.Text = "Master 축은 X 축입니다.";
                }
                else
                {
                    this.txtMstAxisCompare.Text = "Master 축은 Y 축입니다.";
                }
            }
        }

        private void OnSpeedModeChanged(object sender, EventArgs e)
        {
            if (sender == rdoMstSpdMode)
            {
                this.cmbMstSpdMode.Enabled = true;
                this.txtMstVelSpd.Enabled = true;
                this.txtMstAccSpd.Enabled = true;
                this.txtMstDecSpd.Enabled = true;

                this.cmbVecSpdMode.Enabled = false;
                this.txtVecVelSpd.Enabled = false;
                this.txtVecAccSpd.Enabled = false;
                this.txtVecDecSpd.Enabled = false;
            }
            else if (sender == rdoVecSpdMode)
            {
                this.cmbMstSpdMode.Enabled = false;
                this.txtMstVelSpd.Enabled = false;
                this.txtMstAccSpd.Enabled = false;
                this.txtMstDecSpd.Enabled = false;

                this.cmbVecSpdMode.Enabled = true;
                this.txtVecVelSpd.Enabled = true;
                this.txtVecAccSpd.Enabled = true;
                this.txtVecDecSpd.Enabled = true;
            }
        }

        /***********************************************************************
		* Position "Reset" 버튼의 콜백함수. Command & Feedback 
		* position을 0으로 리셋한다.
		***********************************************************************/
        private void btnResetPos_Click(object sender, EventArgs e)
        {
            int nAxisX = this.cmbXAxis.SelectedIndex;
            int nAxisY = this.cmbYAxis.SelectedIndex;

            MLink3.StSetPosition(0, nAxisX+3, 0, 0.0); // Reset command position of X-axis
            MLink3.StSetPosition(0, nAxisX+3, 1, 0.0); // Reset feedback position of X-axis
            MLink3.StSetPosition(0, nAxisY+3, 0, 0.0); // Reset command position of X-axis
            MLink3.StSetPosition(0, nAxisY+3, 1, 0.0); // Reset feedback position of X-axis
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            // 보간맵의 축설정이 아직 이루어지지 않은 경우에는 에러를 유발하므로 바로 리턴한다. //
            if (!m_bIsIxMapValid)
                return;

            if (MLink3.IxStop(0, IX_MAP_IDX, 1, 0) != 0)
            {
                MessageBox.Show("IxStop Error");
            }

            btnGo.Enabled = true;
        }

        private void btnGo_Click(object sender, EventArgs e)
        {
            btnGo.Enabled = false;

            int nAxisX = this.cmbXAxis.SelectedIndex;
            int nAxisY = this.cmbYAxis.SelectedIndex;

            // X축과 Y축이 같은 축번호이면 에러 치리
            if (nAxisX == nAxisY)
            {
                MessageBox.Show("Error: X and Y axes must be different from each other!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                this.btnGo.Enabled = true;
                return;
            }

            int dwAxesMask = 0x0;

            dwAxesMask |= (1 << nAxisX+3); // X축 번호 비트를 셋팅.
            dwAxesMask |= (1 << nAxisY+3); // Y축 번호 비트를 셋팅.

            if (MLink3.IxMapAxes(0, IX_MAP_IDX, dwAxesMask, 0) == 0)
                m_bIsIxMapValid = true;

            // Speed Setting // (편의상 초기속도, 종료속도는 0으로 한다.)
            if (this.rdoVecSpdMode.Checked)
            {	// Vector Mode 이면..
                int nVectSpeedMode = this.cmbVecSpdMode.SelectedIndex;
                double fVectVel = Convert.ToDouble(this.txtVecVelSpd.Text);
                double fVectAcc = Convert.ToDouble(this.txtVecAccSpd.Text);
                double fVectDec = Convert.ToDouble(this.txtVecDecSpd.Text);

                MLink3.IxSetSpeedPattern(0, IX_MAP_IDX, 1,
                    nVectSpeedMode, 0, 0, fVectVel, fVectAcc, fVectDec);
            }
            else
            {
                int nMastSpeedMode = this.cmbMstSpdMode.SelectedIndex;

                double fMastVel = Convert.ToDouble(this.txtMstDecSpd.Text);
                double fMastAcc = Convert.ToDouble(this.txtMstAccSpd.Text);
                double fMastDec = Convert.ToDouble(this.txtMstDecSpd.Text);

                MLink3.IxSetSpeedPattern(0, IX_MAP_IDX, 0,
                    nMastSpeedMode, 0, 0, fMastVel, fMastAcc, fMastDec);
            }

            double fPosDataX = Convert.ToDouble(this.txtXAxisPos.Text);
            double fPosDataY = Convert.ToDouble(this.txtYAxisPos.Text);

            double[] afPosList = new double[2];
            afPosList[0] = fPosDataX;
            afPosList[1] = fPosDataY;

            if (this.rdoAbsPosMode.Checked)
            {
                if (MLink3.IxLineTo(0, IX_MAP_IDX, afPosList, 0/* This must be TRUE in Thread */) != 0)
                {
                    MessageBox.Show("IxLineTo Error");
                }
            }
            else
            {
                if (MLink3.IxLine(0, IX_MAP_IDX, afPosList, 0/* This must be TRUE in Thread */) != 0)
                {
                    MessageBox.Show("IxLine Error");
                }
            }

            btnGo.Enabled = true;
        }

        private void cmbXAxis_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nAxisX = this.cmbXAxis.SelectedIndex;

            // 사용 가능한 축의 갯수 얻어오기
            
            if (nAxisX == 15)
            {
                this.cmbYAxis.SelectedIndex = 0;
            }
            else
            {
                this.cmbYAxis.SelectedIndex = nAxisX + 1;
            }
        }
    }
}
