﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MLink3 = ComiLib.MLink3.SafeNativeMethods;
using MLink3_def = ComiLib.NEMO_Def.SafeNativeMethods;

namespace IxArc
{
    public partial class IxArcForm : Form
    {
        public enum ARC_MODE { ARC_ANGLE, ARC_POINT, ARC_3POINT };
        
        //const int IX_MAP_IDX = 0;
        private const int IX_MAP_IDX = 0;  // Interpolation Map Index
        int m_nArcMotionMode = (int)ARC_MODE.ARC_ANGLE;

        public IxArcForm()
        {
            InitializeComponent();
        }

        // common function
        void InitMotionDevices()
        {
            // SERVO-ON //
            for (int i = 0; i < 16; i++)
            {
               MLink3.GnSetServoOn(0, i+3, 1);
            }
        }


        private void IxArcForm_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoardID = new int();
            int nNumAxes = new int();

            if (MLink3.GnLoadDevice(ref NumDevice, ref BoardID, ref nNumAxes) != 0)
            {
                MessageBox.Show("Can't load device");
                return;
            }
            else
            {
            
                // Motion 환경 초기화 //
                InitMotionDevices();

                ////////////////////////////////////////////////////////////////////////////////////
                int i;

                // 사용 가능한 축의 갯수 얻어오기
                
                for (i = 0; i < 2; i++)
                {
                    this.cmbAxisX.Items.Insert(i, "Axis" + i.ToString());
                    this.cmbAxisY.Items.Insert(i, "Axis" + i.ToString());
                }

                // 축선택의 기본값으로는 0번과 1번 두 축이 선택된 것으로 한다.
                this.cmbAxisX.SelectedIndex = 0;
                this.cmbAxisY.SelectedIndex = 1;

                this.cmbMovMode.SelectedIndex = 0;
                this.cmbSpeedPattern.SelectedIndex = 2;
                this.cmbSpeedMode.SelectedIndex = 0;

                // 초기 속도 패턴 설정
                for (i = 0; i < 16; i++)
                {
                    MLink3.CfgSetSpeedPattern(0, i+3, 2, 10000, 1000000, 1000000, 0, 0);
                }

                // Set timer to read and display current command position //
                this.timer1.Start();
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            int nAxisX = this.cmbAxisX.SelectedIndex;
            int nAxisY = this.cmbAxisY.SelectedIndex;
            int nCount = 0;

            MLink3.StGetCount(0, nAxisX+3, 0, ref nCount);
            this.txt3PntP1AxisX.Text = nCount.ToString();
            MLink3.StGetCount(0, nAxisY+3, 0, ref nCount);
            this.txt3PntP1AxisY.Text = nCount.ToString();
        }

        private void cmbMovMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nMovMode = this.cmbMovMode.SelectedIndex;

            if(nMovMode == 0)
            {
                //Arc Method 창의 라벨 단위 이름 변경 - Offset
                //Arc-Angle의 라벨 단위 이름 변경
                this.lblAngCenAxisX.Text = "Axis-X Center Offset (Pulse)";
                this.lblAngCenAxisY.Text = "Axis-Y Center Offset (Pulse)";

                //Arc-Point의 라벨 단위 이름 변경
                this.lblPntCenAxisX.Text = "Axis-X Center Offset (Pulse)";
                this.lblPntCenAxisY.Text = "Axis-X Center Offset (Pulse)";

                //3-Point의 라벨 단위 이름 변경
                this.lbl3PntP2AxisX.Text = "Axis-X Offset (Pulse)";
                this.lbl3PntP2AxisY.Text = "Axis-Y Offset (Pulse)";
                this.lbl3PntP3AxisX.Text = "Axis-X Offset (Pulse)";
                this.lbl3PntP3AxisY.Text = "Axis-Y Offset (Pulse)";
            }
            else
            {
                //Arc Method 창의 라벨 단위 이름 변경 - Position
                //Arc-Angle의 라벨 단위 이름 변경
                this.lblAngCenAxisX.Text = "Axis-X Center Position (Pulse)";
                this.lblAngCenAxisY.Text = "Axis-Y Center Position (Pulse)";

                //Arc-Point의 라벨 단위 이름 변경
                this.lblPntCenAxisX.Text = "Axis-X Center Position (Pulse)";
                this.lblPntCenAxisY.Text = "Axis-X Center Position (Pulse)";

                //3-Point의 라벨 단위 이름 변경
                this.lbl3PntP2AxisX.Text = "Axis-X Position (Pulse)";
                this.lbl3PntP2AxisY.Text = "Axis-Y Position (Pulse)";
                this.lbl3PntP3AxisX.Text = "Axis-X Position (Pulse)";
                this.lbl3PntP3AxisY.Text = "Axis-Y Position (Pulse)";
            }
        }

        private void cmbAxisX_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nAxisX = this.cmbAxisX.SelectedIndex;
            
            if (nAxisX == 15)
            {
                this.cmbAxisX.SelectedIndex = 0;
            }
            else
            {
                this.cmbAxisY.SelectedIndex = nAxisX + 1;
            }
        }

        public void CommSetSpeedPattern()
        {
            double edtEnd  = 0.0;
	        double edtInit = 0.0;
	        int edtWork   = 100000;
	        int edtAcc    = 1000000;
	        int edtDec    = 1000000;
	        int nSpeedPattern = this.cmbSpeedPattern.SelectedIndex;

            MLink3.IxSetSpeedPattern(0, IX_MAP_IDX, 1, nSpeedPattern, edtInit, edtEnd, edtWork, edtAcc, edtDec);
        }

        // CCW(-) 방향으로 구동
        private void btnMoveN_Click(object sender, EventArgs e)
        {
            btnMoveN.Enabled = false;
            btnMoveP.Enabled = false;
            
            int nAxisX = this.cmbAxisX.SelectedIndex;
            int nAxisY = this.cmbAxisY.SelectedIndex;

            int nAxesMask = 0x0;
            
            if (nAxisX == nAxisY)
            {
                MessageBox.Show("Error : X and Y axes must be different from each other!");
                return;
            }

            nAxesMask |= (1 << (nAxisX+3)); // X축 번호 비트를 셋팅.
            nAxesMask |= (1 << (nAxisY+3)); // Y축 번호 비트를 셋팅.

            MLink3.IxMapAxes(0, IX_MAP_IDX, nAxesMask, 1);

            CommSetSpeedPattern();

            int nMovMode = this.cmbMovMode.SelectedIndex;
            int nSpeedPattern = this.cmbSpeedPattern.SelectedIndex;
            int nSpeedMode = this.cmbSpeedMode.SelectedIndex;

            // Arc Method - Arc Angle
            double fAngCenAxisX = Convert.ToDouble(this.txtAngCenAxisX.Text);
            double fAngCenAxisY = Convert.ToDouble(this.txtAngCenAxisY.Text);
            double fAngEndDeg = Convert.ToDouble(this.txtAngEndDeg.Text);

            // Arc Method - Arc Point
            double fPntCenAxisX = Convert.ToDouble(this.txtPntCenAxisX.Text);
            double fPntCenAxisY = Convert.ToDouble(this.txtPntCenAxisY.Text);
            double fPntEndAxisX = Convert.ToDouble(this.txtPntEndAxisX.Text);
            double fPntEndAxisY = Convert.ToDouble(this.txtPntEndAxisY.Text);

            // Arc Method - Arc 3Point
            double f3PntP2AxisX = Convert.ToDouble(this.txt3PntP2AxisX.Text);
            double f3PntP2AxisY = Convert.ToDouble(this.txt3PntP2AxisY.Text);
            double f3PntP3AxisX = Convert.ToDouble(this.txt3PntP3AxisX.Text);
            double f3PntP3AxisY = Convert.ToDouble(this.txt3PntP3AxisY.Text);

            if (nMovMode == 0) // Moving Mode 를 확인
            {
                if(nSpeedMode == 0) // Speed Mode 를 확인
                {
                    switch(m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE :

                            //Relative - Master - Arc_Angle
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArcAStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcAStart(0,IX_MAP_IDX, -fAngCenAxisX, -fAngCenAxisY, fAngEndDeg);
                            MLink3.IxWaitDone(0,IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArcPStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcPStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArc3PStart
                            //cmmIxWateDone
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            MLink3.IxArc3PStart(0, IX_MAP_IDX, P2, P3, 0);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
                else
                {
                    switch (m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArcAStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcAStart(0, IX_MAP_IDX, -fAngCenAxisX, -fAngCenAxisY, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArcPStart
                            //cmmIxWateDone

                            MLink3.IxArcPStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArc3PStart
                            //cmmIxWateDone

                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            MLink3.IxArc3PStart(0, IX_MAP_IDX, P2, P3, 0);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
            }
            else
            {
                if (nSpeedMode == 0) // Speed Mode 를 확인
                {
                    switch (m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArcAStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcAToStart(0, IX_MAP_IDX, -fAngCenAxisX, -fAngCenAxisY, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArcPStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcPToStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArc3PStart
                            //cmmIxWateDone
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            MLink3.IxArc3PToStart(0, IX_MAP_IDX, P2, P3, 0);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
                else
                {
                    switch (m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArcAStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcAToStart(0, IX_MAP_IDX, -fAngCenAxisX, -fAngCenAxisY, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArcPStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcPToStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArc3PStart
                            //cmmIxWateDone
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            MLink3.IxArc3PToStart(0, IX_MAP_IDX, P2, P3, 0);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
            }

            btnMoveN.Enabled = true;
            btnMoveP.Enabled = true;
        }

        private void tabArcMethod_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nTabArcMethodSelect = this.tabArcMethod.SelectedIndex;

            if (nTabArcMethodSelect == 0)
            {
                m_nArcMotionMode = (int)ARC_MODE.ARC_ANGLE;
            }
            else if (nTabArcMethodSelect == 1)
            {
                m_nArcMotionMode = (int)ARC_MODE.ARC_POINT;
            }
            else if (nTabArcMethodSelect == 2)
            {
                m_nArcMotionMode = (int)ARC_MODE.ARC_3POINT;
            }
        }

        // CW(+) 방향으로 구동
        private void btnMoveP_Click(object sender, EventArgs e)
        {
            btnMoveN.Enabled = false;
            btnMoveP.Enabled = false;
            
            int nAxisX = this.cmbAxisX.SelectedIndex;
            int nAxisY = this.cmbAxisY.SelectedIndex;

            int nAxesMask = 0x0;

            nAxesMask |= (1 << (nAxisX+3)); // X축 번호 비트를 셋팅.
            nAxesMask |= (1 << (nAxisY+3)); // Y축 번호 비트를 셋팅.

            MLink3.IxMapAxes(0, IX_MAP_IDX, nAxesMask, 1);

            CommSetSpeedPattern();

            int nMovMode = this.cmbMovMode.SelectedIndex;
            int nSpeedPattern = this.cmbSpeedPattern.SelectedIndex;
            int nSpeedMode = this.cmbSpeedMode.SelectedIndex;

            // Arc Method - Arc Angle
            double fAngCenAxisX = Convert.ToDouble(this.txtAngCenAxisX.Text);
            double fAngCenAxisY = Convert.ToDouble(this.txtAngCenAxisY.Text);

            // Arc Method - Arc Point
            double fPntCenAxisX = Convert.ToDouble(this.txtPntCenAxisX.Text);
            double fPntCenAxisY = Convert.ToDouble(this.txtPntCenAxisY.Text);
            double fPntEndAxisX = Convert.ToDouble(this.txtPntEndAxisX.Text);
            double fPntEndAxisY = Convert.ToDouble(this.txtPntEndAxisY.Text);

            // Arc Method - Arc 3Point
            double f3PntP2AxisX = Convert.ToDouble(this.txt3PntP2AxisX.Text);
            double f3PntP2AxisY = Convert.ToDouble(this.txt3PntP2AxisY.Text);
            double f3PntP3AxisX = Convert.ToDouble(this.txt3PntP3AxisX.Text);
            double f3PntP3AxisY = Convert.ToDouble(this.txt3PntP3AxisY.Text);

            double fAngEndDeg=0;

            if (nMovMode == 0) // Moving Mode 를 확인
            {
                if (nSpeedMode == 0) // Speed Mode 를 확인
                {
                    switch (m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArcAStart
                            //cmmIxWateDone
                            
                            fAngEndDeg = Convert.ToDouble(this.txtAngEndDeg.Text);
                            MLink3.IxArcAStart(0, IX_MAP_IDX, fAngCenAxisX, fAngCenAxisY, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArcPStart
                            //cmmIxWateDone

                            MLink3.IxArcPStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArc3PStart
                            //cmmIxWateDone

                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            fAngEndDeg = Convert.ToDouble(this.txtAngleFor3P.Text);
                            MLink3.IxArc3PStart(0, IX_MAP_IDX, P2, P3, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
                else
                {
                    switch (m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArcAStart
                            //cmmIxWateDone
                            
                            fAngEndDeg = Convert.ToDouble(this.txtAngEndDeg.Text);
                            MLink3.IxArcAStart(0, IX_MAP_IDX, fAngCenAxisX, fAngCenAxisY, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArcPStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcPStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            fAngEndDeg = Convert.ToDouble(this.txtAngleFor3P.Text);
                            MLink3.IxArc3PStart(0,IX_MAP_IDX, P2,P3, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
            }
            else
            {
                if (nSpeedMode == 0) // Speed Mode 를 확인
                {
                    switch (m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArcAStart
                            //cmmIxWateDone
                            
                            fAngEndDeg = Convert.ToDouble(this.txtAngEndDeg.Text);
                            MLink3.IxArcAToStart(0,IX_MAP_IDX, fAngCenAxisX, fAngCenAxisY, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArcPStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcPToStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //cmmIxSetSpeedPattern - Master
                            //cmmIxArc3PStart
                            //cmmIxWateDone
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            fAngEndDeg = Convert.ToDouble(this.txtAngleFor3P.Text);
                            MLink3.IxArc3PToStart(0, IX_MAP_IDX, P2, P3, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
                else
                {
                    switch (m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArcAStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcAToStart(0, IX_MAP_IDX, fAngCenAxisX, fAngCenAxisY, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArcPStart
                            //cmmIxWateDone
                            
                            MLink3.IxArcPToStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //cmmIxSetSpeedPattern - Vector
                            //cmmIxArc3PStart
                            //cmmIxWateDone
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            fAngEndDeg = Convert.ToDouble(this.txtAngleFor3P.Text);
                            MLink3.IxArc3PToStart(0, IX_MAP_IDX, P2, P3, fAngEndDeg);
                            MLink3.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
            }

            btnMoveN.Enabled = true;
            btnMoveP.Enabled = true;
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            if (MLink3.IxStop(0, IX_MAP_IDX, 1, 0) != 0)
            {
                MessageBox.Show("IxStop Error");
            }
        }

        private void btnStopEmg_Click(object sender, EventArgs e)
        {
            if (MLink3.IxStopEmg(0, IX_MAP_IDX) != 0)
            {
                MessageBox.Show("IxStopEmg Error");
            }
        }
    }
}
