﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MLink3 = ComiLib.MLink3.SafeNativeMethods;
using MLink3_def = ComiLib.NEMO_Def.SafeNativeMethods;

namespace IxxHelical
{
    public partial class IxxHelical : Form
    {
        private int[] nAxes = new int[3];
        
        // common function
        void InitMotionDevices()
        {
            //MLink3.GnResetComm(0);
            for (int i = 0; i < 16; i++)
            {
                MLink3.GnSetServoOn(0, i+3, 1);
            }
        }
        
        public IxxHelical()
        {
            InitializeComponent();
        }

        private void IxxHelical_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoardID = new int();
            int nNumAxes = new int();

            if (MLink3.GnLoadDevice(ref NumDevice, ref BoardID, ref nNumAxes) != 0)
            {
                MessageBox.Show("Can't load device");
                return;
            }
            else
            {
                
//                 if (nNumAxes < 3)
//                 {
//                     MessageBox.Show("이 예제는 3축 이상이 연결되어야만 유효한 예제입니다! \n프로그램을 종료합니다.");
//                     return;
//                 }

                // Motion 환경 초기화 //
                InitMotionDevices();

                nAxes[0] = 3;
                nAxes[1] = 4;
                nAxes[2] = 5;
                
                this.cmbSpeedMaster.SelectedIndex = 2;
                this.cmbSpeedMode.SelectedIndex = 0;
                                
                // Set timer to read and display current command position //
                this.timer1.Start();
            }
        }

        private void IxxHelical_FormClosing(object sender, FormClosingEventArgs e)
        {
            // 사용중인 타이머 종료.
            timer1.Stop();

            MLink3.GnUnloadDevice(); // Unload Device
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            string sPos;
            double afCurPos = 0;

            //--------- Position display -----------------------//

            // Command position (X) //
            MLink3.StGetPosition(0, 3, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosC0.Text = sPos;
            // Feedback position (X) //
            MLink3.StGetPosition(0, 3, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosF0.Text = sPos;

            // Command position (Y) //
            MLink3.StGetPosition(0, 4, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosC1.Text = sPos;
            // Feedback position (Y) //
            MLink3.StGetPosition(0, 4, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosF1.Text = sPos;

            // Command position (Z) //
            MLink3.StGetPosition(0, 5, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosC2.Text = sPos;
            // Feedback position (Z) //
            MLink3.StGetPosition(0, 5, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosF2.Text = sPos;


        }

        private void btnResetPos_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < 3; i++ )
            {
                MLink3.StSetPosition(0, i+3, 0, 0.0); // Reset command position
                MLink3.StSetPosition(0, i+3, 1, 0.0); // Reset command position
            }
        }

        bool bAxisZFlag = false;

        private void btnGo_Click(object sender, EventArgs e)
        {
            this.btnGo.Enabled = false;
            
            int[] fCoorList = new int[3];
            
            int fArcCentX = Convert.ToInt32(this.txtArcCentX.Text);
            int fArcCentY = Convert.ToInt32(this.txtArcCentY.Text);
            int fDistZ = Convert.ToInt32(this.txtDistZ.Text);
            int nNumberRepeat = int.Parse(this.txtNumRepeat.Text);

            int nSpeedMaster = this.cmbSpeedMaster.SelectedIndex;
            int nSpeedMode = this.cmbSpeedMode.SelectedIndex;
            double fVel = Convert.ToDouble(this.txtVel.Text);
            double fAcc = Convert.ToDouble(this.txtAcc.Text);
            double fDec = Convert.ToDouble(this.txtDec.Text);

            // 참고: 코드의 간결성을 아래에서는 에러 처리를 생략합니다. //
            fCoorList[0] = fArcCentX;   // X(Axis0) 축의 원호 중심 거리
            fCoorList[1] = fArcCentY;   // Y(Axis1) 축의 원호 중심 거리
                        
            int dwAxesMask = 0x0;

            dwAxesMask |= (1 << 3); // X축 번호 비트를 셋팅.
            dwAxesMask |= (1 << 4); // Y축 번호 비트를 셋팅.
            dwAxesMask |= (1 << 5); // Z축 번호 비트를 셋팅.

            MLink3.IxMapAxes(0, 1, dwAxesMask, 2);
            MLink3.IxSetSpeedPattern(0, 1, nSpeedMaster, nSpeedMode, 0, 0, fVel, fAcc, fDec);
            if (bAxisZFlag)
            {
                fCoorList[2] = -fDistZ;	//	Z(Axis2) 축의 원호 중심 거리 
                bAxisZFlag = false;
            }
            else
            {
                fCoorList[2] = fDistZ;	//	Z(Axis2) 축의 원호 중심 거리 
                bAxisZFlag = false;
            }

            MLink3.IxHelOnceStart(0, 1, fCoorList, 360);
            MLink3.IxWaitDone(0, 1, 0);

            this.btnGo.Enabled = true;
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            this.btnGo.Enabled = true;
            this.btnStop.Enabled = false;

            if (MLink3.IxStop(0, 1, 1, 0) != 0)
            {
                MessageBox.Show("IxStop Error");
            }

            this.btnStop.Enabled = true;
        }
    }
}
