﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ComiLib.SSCNET3;

/* 이 예제의 BoadId는 0번으로 지정합니다. */


namespace HommingExample
{
  

    public partial class Homming : Form
    {
        HomeSetupForm m_frmHomeSetup = null;

        public Homming()
        {
            InitializeComponent();
        }

        // common function
        void InitMotionDevices()
        {
            // SERVO-ON //

            for (int i = 0; i < 16; i++)
            {
                ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(0, i, 1);
            }
        }

        private void Homming_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = 0;
            int BoradID = 0;
            int nNumAxes = 0;

            ComiLib.SSCNET3.SafeNativeMethods.GnLoadDevice(ref NumDevice, ref BoradID, ref nNumAxes);
            
            
            // Motion 환경 초기화 //
            InitMotionDevices();
                     
            cmbAxisList.Items.Clear(); // Clear combobox
            string szTitle;

            for (int i = 0; i < 16; i++)
            {
                szTitle = i.ToString();
                cmbAxisList.Items.Add(szTitle);
            }

            // 축설정 콤보박스 초기 선택값 지정
            if (cmbAxisList.Items.Count > 0)
                cmbAxisList.SelectedIndex = 0;

            // Set timer to display current command position //
            this.timer1.Start();
        }


        /***********************************************************************
		* TIMER event handler
		* : Read current command & feedback position and display it
		***********************************************************************/
        private void timer1_Tick(object sender, EventArgs e)
        {
            //------- 모션제어기 위치 모니터링 -------------------------------//
            int nSelAxis = this.cmbAxisList.SelectedIndex;
            
            string sPos;
            double fCurPos = 0;
            // Command position //
            ComiLib.SSCNET3.SafeNativeMethods.StGetPosition(0, nSelAxis, 0, ref fCurPos);
            sPos = fCurPos.ToString();
            this.txtCmdPos.Text = sPos;

            // Feedback position //
            ComiLib.SSCNET3.SafeNativeMethods.StGetPosition(0, nSelAxis, 0, ref fCurPos);
            sPos = fCurPos.ToString();
            this.txtFeedPos.Text = sPos;

            //원점복귀 이송 중 홈복귀 중인지 아닌지 확인 한다.
            int nIsBusy = 0;
            ComiLib.SSCNET3.SafeNativeMethods.HomeIsBusy(0, nSelAxis, ref nIsBusy);

            if(nIsBusy > 0)
            {
                this.txtHomeIsBusy.Text = "Homming is busy";
            }
            else
            {
                this.txtHomeIsBusy.Text = "Homming is not busy";
            }
        }

        /***********************************************************************
		* Position "Reset" 버튼의 콜백함수. Command & Feedback 
		* position을 0으로 리셋한다.
		***********************************************************************/
        private void btnResetPos_Click(object sender, EventArgs e)
        {
            int nSelAxis = cmbAxisList.SelectedIndex;

            ComiLib.SSCNET3.SafeNativeMethods.StSetPosition(0, nSelAxis, 0, 0.0);        //Reset Command Position
            ComiLib.SSCNET3.SafeNativeMethods.StSetPosition(0, nSelAxis, 1, 0.0);        //Reset FeedBack Position
        }

        //******************************************************************************************
        // OnHomeConfig(): "Change Home Config" 버튼의 이벤트 핸들러. 이 것은 coding으로 원점복귀
        // 환경을 설정하는 방법을 예시하기 위한 것이다. 원점복귀 환경설정을 코딩으로 수행하는 
        // 방법은 CHomeSetup 클래스를 참조하면 된다. 일반적으로는 원점복귀의 환경설정은 CME 파일에서
        // 설정하므로 코딩으로 원점복귀 환경설정을 꼭 할 필요는 없다.
        //******************************************************************************************
        private void btnHomeConfig_Click(object sender, EventArgs e)
        {
            int nSelAxis = this.cmbAxisList.SelectedIndex;

            if (IsFormExist(typeof(HomeSetupForm)) == null)
            {
                m_frmHomeSetup = new HomeSetupForm(nSelAxis);
            }
            
            m_frmHomeSetup.Show();
            m_frmHomeSetup.Focus();
        }

        private void Homming_FormClosing(object sender, FormClosingEventArgs e)
        {
            // 사용중인 타이머 종료.
            timer1.Stop();

            if (m_frmHomeSetup != null)
            {
                m_frmHomeSetup.Dispose();
                m_frmHomeSetup = null;
            }

            int nSelAxis = this.cmbAxisList.SelectedIndex;
            ComiLib.SSCNET3.SafeNativeMethods.SxStop(0, nSelAxis);
            ComiLib.SSCNET3.SafeNativeMethods.GnUnloadDevice(); // Unload Device
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            int nSelAxis = this.cmbAxisList.SelectedIndex;

            ComiLib.SSCNET3.SafeNativeMethods.SxStop(0, nSelAxis);
        }

        // Form Check
        private Form IsFormExist(Type FormType)
        {
            foreach (Form OpenForm in Application.OpenForms)
            {
                if (OpenForm.GetType() == FormType)
                    return OpenForm;
            }
            return null;
        }

        private void btnHome_Click(object sender, EventArgs e)
        {
            int nSelAxis = this.cmbAxisList.SelectedIndex;

            //////////////////////////////////////////////////////////////////////////
            // 이전에 원점복귀를 성공적으로 수행했는지 체크하고자할 때에는 cmmHomeGetSuccess()
            // 함수를 사용한다. cmmHomeGetSuccess()에서 반환하는 플래그는 프로그램이 
            // 종료되었다가 다시 실행되어도 계속 유지된다(단, PC가 재부팅되면 리셋된다)

            // 원점복귀 수행 //
            int nDirection = 0;
            int nIsBlocking = 0;

            if (this.rdoPlusDir.Checked)
            {
                nDirection = 1;
                
            }


            // HomeSetConfig ParamId
            // 0 : 홈복귀 모드
            // 1 : 홈복귀 방향
            // 3 : 홈복귀 Ez 카운터

            ComiLib.SSCNET3.SafeNativeMethods.HomeSetConfig(0, nSelAxis, 1, nDirection);
            
            if (ComiLib.SSCNET3.SafeNativeMethods.HomeMove(0, nSelAxis, nIsBlocking) != 0)
            {
                MessageBox.Show("HomeMove Error");
            }

            //////////////////////////////////////////////////////////////////////////
            // [CAUTION] 위에서 cmmHomeMove() 함수 대신에 cmmHomeMoveStart() 함수를 
            // 사용할 수도 있다. 그런데 cmmHomeMoveStart() 함수를 사용한 경우에는 
            // 아래와 같이 cmmHomeWaitDone() 함수를 이용하여 원점복귀 완료여부를 
            // 체크해주어야 한다.
            // cmmHomeMoveStart(nAxis, m_nDirection);
            // cmmHomeWaitDone(nAxis, FALSE/*Thread에서는 TRUE로 사용할 것*/);


        }
    }
}
