﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ComiLib.SSCNET3;

namespace HommingExample
{
    public partial class HomeSetupForm : Form
    {
        private static int nAxis = 0;
        private static int nHomeMode = 0; // Home Mode
        private static int nHomeClearMode = 0; // Home Clear Mode
        private static int nOrgLogic = 0; // ORG Input Logic
        private static int nEzLogic = 0; // EZ Input Logic
        private static int nEzCount = 0; // EZ Count
        private static double fOffDist = 0; // Offset Distance
        private static int nErrOut = 0; // Output ERC signal at completion
        private static int nSpeedMode = -1; // Speed Mode
        private static double fWorkSpeed = 0; // Work Speed
        private static double fSpeedPhase1 = 0; // Phase1 Speed
        private static double fSpeedTemp = 0;
        private static double fSpeedPhase2 = 0; // Phase2 Speed
        private static double fAcceleration = 0; // Acceleration
        private static double fDeceleration = 0; // Deceleration

        public HomeSetupForm(int p_nAxis)
        {
            nAxis = p_nAxis;
            
            InitializeComponent();
        }

        private void HomeSetupForm_Load(object sender, EventArgs e)
        {
            // 화면에 초기값을 설정하기 위해서 현재 설정되어 있는 속도 패턴을 읽어들인다.

            // HomeGetConfig ParamId
            // 0 : 홈복귀 모드
            // 1 : 홈복귀 방향
            // 3 : 홈복귀 Ez 카운터
            ComiLib.SSCNET3.SafeNativeMethods.HomeGetConfig(0, nAxis, 0, ref nHomeMode);
            ComiLib.SSCNET3.SafeNativeMethods.HomeGetConfig(0, nAxis, 3, ref nEzCount);
            ComiLib.SSCNET3.SafeNativeMethods.HomeGetOffset(0, nAxis, ref fOffDist);
            ComiLib.SSCNET3.SafeNativeMethods.HomeGetPosClrMode(0, nAxis, ref nHomeClearMode);
            ComiLib.SSCNET3.SafeNativeMethods.CfgGetMioProperty(0, nAxis, 2, ref nOrgLogic);

            // HomeSpeedPattern Phase
            // ORG 감지 후 ORG 탈출하였다가 다시 ORG 감지하는 동작을 예시로 설명
            // Phase 0 : ORG 감지를 위하여 최초 이송 할 때의 속도
            // Phase 1 : ORG 감지 후 탈출 할 때의 속도
            // Phase 2 : ORG 탈출 후 다시 ORG 감지를 위하여 이송할 때의 속도
            ComiLib.SSCNET3.SafeNativeMethods.HomeGetSpeedPattern(0, nAxis, 0, ref nSpeedMode, ref fWorkSpeed, ref fAcceleration, ref fDeceleration);
            ComiLib.SSCNET3.SafeNativeMethods.HomeGetSpeedPattern(0, nAxis, 1, ref nSpeedMode, ref fSpeedPhase1, ref fSpeedTemp, ref fSpeedTemp);
            ComiLib.SSCNET3.SafeNativeMethods.HomeGetSpeedPattern(0, nAxis, 2, ref nSpeedMode, ref fSpeedPhase2, ref fSpeedTemp, ref fSpeedTemp);

            this.cmbHomeMode.SelectedIndex = (int)nHomeMode;
            this.cmbHomeClrMode.SelectedIndex = (int)nHomeClearMode;
            this.cmbOrgLogic.SelectedIndex = (int)nOrgLogic;
            this.cmbEzLogic.SelectedIndex = (int)nEzLogic;
            this.txtEzCount.Text = nEzCount.ToString();
            this.txtOffset.Text = fOffDist.ToString();

            if (nErrOut > 0)
            {
                this.chkErcOut.Checked = true;
            }
            else
            {
                this.chkErcOut.Checked = false;
            }

            this.cmbSpeedMode.SelectedIndex = (int)nSpeedMode;
            this.txtWorkSpeed.Text = fWorkSpeed.ToString();
            this.txtRvsSpeed.Text = fSpeedPhase1.ToString();
            this.textBox1.Text = fSpeedPhase2.ToString();
            this.txtAcc.Text = fAcceleration.ToString();
            this.txtDec.Text = fDeceleration.ToString();
        }

        private void cmbHomeMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            nHomeMode = this.cmbHomeMode.SelectedIndex;
        }

        private void cmbHomeClrMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            nHomeClearMode = this.cmbHomeClrMode.SelectedIndex;
        }

        private void cmbOrgLogic_SelectedIndexChanged(object sender, EventArgs e)
        {
            nOrgLogic = this.cmbOrgLogic.SelectedIndex;
        }

        private void cmbEzLogic_SelectedIndexChanged(object sender, EventArgs e)
        {
            nEzLogic = this.cmbEzLogic.SelectedIndex;
        }

        private void cmbSpeedMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            nSpeedMode = this.cmbSpeedMode.SelectedIndex;
        }

        private void chkErcOut_Click(object sender, EventArgs e)
        {
            if(this.chkErcOut.Checked)
            {
                nErrOut = 1;
            }
        }

        private void btnApply_Click(object sender, EventArgs e)
        {
            nEzCount = int.Parse(this.txtEzCount.Text);
            fOffDist = Convert.ToDouble(this.txtOffset.Text);

            fWorkSpeed = Convert.ToDouble(this.txtWorkSpeed.Text);
            fSpeedPhase1 = Convert.ToDouble(this.txtRvsSpeed.Text);
            fSpeedPhase2 = Convert.ToDouble(this.textBox1.Text);
            fAcceleration = Convert.ToDouble(this.txtAcc.Text);
            fDeceleration = Convert.ToDouble(this.txtDec.Text);

            // HomeSetConfig ParamId
            // 0 : 홈복귀 모드
            // 1 : 홈복귀 방향
            // 3 : 홈복귀 Ez 카운터
            ComiLib.SSCNET3.SafeNativeMethods.HomeSetConfig(0, nAxis, 0, nHomeMode);
            ComiLib.SSCNET3.SafeNativeMethods.HomeSetConfig(0, nAxis, 3, nEzCount);
            ComiLib.SSCNET3.SafeNativeMethods.HomeSetOffset(0, nAxis, fOffDist);
            ComiLib.SSCNET3.SafeNativeMethods.HomeSetPosClrMode(0, nAxis, nHomeClearMode);
            ComiLib.SSCNET3.SafeNativeMethods.CfgSetMioProperty(0, nAxis, 2, nOrgLogic);

            // HomeSpeedPattern Phase
            // ORG 감지 후 ORG 탈출하였다가 다시 ORG 감지하는 동작을 예시로 설명
            // Phase 0 : ORG 감지를 위하여 최초 이송 할 때의 속도
            // Phase 1 : ORG 감지 후 탈출 할 때의 속도
            // Phase 2 : ORG 탈출 후 다시 ORG 감지를 위하여 이송할 때의 속도
            ComiLib.SSCNET3.SafeNativeMethods.HomeSetSpeedPattern(0, nAxis, 0, nSpeedMode, fWorkSpeed, fAcceleration, fDeceleration);
            ComiLib.SSCNET3.SafeNativeMethods.HomeSetSpeedPattern(0, nAxis, 1, nSpeedMode, fSpeedPhase1, fSpeedPhase1*10, fSpeedPhase1*10);
            ComiLib.SSCNET3.SafeNativeMethods.HomeSetSpeedPattern(0, nAxis, 2, nSpeedMode, fSpeedPhase2, fSpeedPhase2*10, fSpeedPhase2*10);
        }

        private void btnQuit_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
