﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ComiLib.SSCNET3;

namespace OverrideSpeed
{
    public partial class OverrideSpeed : Form
    {
        private static double fWorkSpeed = 0;
        private static double fAcceleration = 0;
        private static double fDeceleration = 0;
        private static double fIni = 0;
        private static double fEnd = 0;
        
        public OverrideSpeed()
        {
            InitializeComponent();
        }

        // common function
        void InitMotionDevices()
        {
            // SERVO-ON //
            for (int i = 0; i < 16; i++)
            {
                ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(0, i, 1);
            }
        }

        private void OverrideSpeed_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoradID = new int();
            int nNumAxes = new int();

            //Device Load
            if (ComiLib.SSCNET3.SafeNativeMethods.GnLoadDevice(ref NumDevice, ref BoradID, ref nNumAxes) != 0)
            {
                MessageBox.Show("Can't load device");
                return;
            }
            else
            {
                // Motion 환경 초기화 //
                InitMotionDevices();

                ////////////////////////////////////////////////////////////////////////////////////
                int i;

                for (i = 0; i < 16; i++)
                {
                    this.cmbAxis.Items.Insert(i, "Axis" + i.ToString());
                }

                // 축선택의 기본값으로는 0번과 1번 두 축이 선택된 것으로 한다.
                this.cmbAxis.SelectedIndex = 0;

                cmbAxis_SelectedIndexChanged(null, null);

                // Set timer to read and display current command position //
                this.timer1.Start();
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            string sPos;
            double afCurPos = 0;

            // 지정한 축의 카운터 값을 읽어서 반환합니다.이때 반환되는 값은 Unit Distance로 정의된 논리적 거리입니다.
            // StGetCount() 함수 역시 카운터 값을 읽어서 반환하지만 이 함수의 반환값은 펄스수입니다.
            // Command position display //
            ComiLib.SSCNET3.SafeNativeMethods.StGetPosition(0, nAxis, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosC.Text = sPos;

            // Feedback position display //
            ComiLib.SSCNET3.SafeNativeMethods.StGetPosition(0, nAxis, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosF.Text = sPos;

            
            //Command 또는 Feedback 속도를 읽어서 논리적 속도 단위로 반환합니다.
            // Command velocity display //
            ComiLib.SSCNET3.SafeNativeMethods.StGetSpeed(0, nAxis, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblVelC.Text = sPos;

            // Feedback velocity display //
            ComiLib.SSCNET3.SafeNativeMethods.StGetSpeed(0, nAxis, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblVelF.Text = sPos;

            //-------- 각 버튼의 Dimmed 처리를 상황에 맞추어서 수행 ---------//
            int nIsStopped = 0;

            // 해당 축에 대해 모션 완료를 확인합니다.
            ComiLib.SSCNET3.SafeNativeMethods.SxIsDone(0, nAxis,ref nIsStopped);
            if (nIsStopped == 1)
            {
                this.btnStart.Enabled = true;
                this.btnStop.Enabled = false;

            }
            else
            {
                this.btnStart.Enabled = false;
                this.btnStop.Enabled = true;
                this.btnOverPattern.Enabled = true;
            }
        }

        //**********************************************************************************
        // OnSelchangeAxisSel(): "Axis" Combobox의 선택이 변경되었을 때 호출되는 이벤트 핸들러
        // 축 선택이 바뀌면 해당 축의 현재 속도 설정을 읽어서 화면을 업데이트해준다.
        //**********************************************************************************
        private void cmbAxis_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            int nMode = 0;

            // 속도패턴(SPEEDMODE : CONSTANT, TRAPEZOIDAL, S-CURVE), 작업속도(WORKSPEED), 가속도(ACCELERATION), 감속도(DECELERATION) 설정 값을 반환합니다.
            ComiLib.SSCNET3.SafeNativeMethods.CfgGetSpeedPattern(0, nAxis, ref nMode, ref fWorkSpeed, ref fAcceleration, ref fDeceleration, ref fIni, ref fEnd);
            this.cmbSpeedMode.SelectedIndex = nMode;

        }


        //**************************************************************************************
        // OnOverrideSpeedPattern(): "Speed Pattern" 그룹의 "Override" 버튼의 이벤트 핸들러.
        // 정격속도 설정을 오버라이딩한다. 
        //**************************************************************************************
        private void btnOverPattern_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            int nSpeedMode = this.cmbSpeedMode.SelectedIndex;
            fWorkSpeed = Convert.ToDouble(this.txtVwork.Text);
            fAcceleration = Convert.ToDouble(this.txtAcc.Text);
            fDeceleration = Convert.ToDouble(this.txtDec.Text);

            // 속도패턴(SPEEDMODE : CONSTANT, TRAPEZOIDAL, S-CURVE), 작업속도(WORKSPEED), 가속도(ACCELERATION), 감속도(DECELERATION)를 설정합니다.
            // CfgSetSpeedPattern_T() 함수는 가속, 감속을 시간(s) 단위로 설정합니다.
            // 오버라이딩할 속도를 설정합니다.
            ComiLib.SSCNET3.SafeNativeMethods.CfgSetSpeedPattern(0, nAxis, nSpeedMode, fWorkSpeed, fAcceleration, fDeceleration, fIni, fEnd);

            // 여기에서 실제 속도 오버라이딩이 수행됩니다.
            ComiLib.SSCNET3.SafeNativeMethods.OverrideSpeedSet(0, nAxis);  

            this.lblStatus.Text = "속도 오버라이드 적용 됨";
        }


        //**************************************************************************************
        // OnStart(): "Start" 버튼 이벤트 핸들러. (+) 방향으로 속도모드 조그 이송을 시작한다.
        // 일반적으로 속도 설정을 할때 환경설정에서 정격속도를 설정해놓고 프로그램에서는 
        // 속도비를 조절하여 사용하는 것이 일반적이다. 따라서 일반적으로는 cmmSxSetSpeedRatio()만
        // 을 사용하면 된다. 본 예제에서는 cmmCfgSetSpeedPattern()에 의해서 결정되는 정격속도도
        // Overriding 될 수 있음을 예시하기 위해서 cmmCfgSetSpeedPattern() 함수도 함께 사용하였다.
        //**************************************************************************************
        private void btnStart_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;

            int nSpeedMode = this.cmbSpeedMode.SelectedIndex;
            // 정격속도 설정 //
            // 속도패턴(SPEEDMODE : CONSTANT, TRAPEZOIDAL, S-CURVE), 작업속도(WORKSPEED), 가속도(ACCELERATION), 감속도(DECELERATION)를 설정합니다.
            // CfgSetSpeedPattern_T() 함수는 가속, 감속을 시간(s) 단위로 설정합니다.
            ComiLib.SSCNET3.SafeNativeMethods.CfgSetSpeedPattern(0, nAxis, nSpeedMode, fWorkSpeed, fAcceleration, fDeceleration, fIni, fEnd);
 
            if (ComiLib.SSCNET3.SafeNativeMethods.SxVMoveStart(0, nAxis, 1) != 0)
            {
                MessageBox.Show("cmsSxVMoveStart Error");
            }

            this.lblStatus.Text = "이송 시작됨, 이제 이송 속도 및 속도비율을 재설정 하시고 Override 버튼을 클릭하세요";
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;

            // 지정한 축에 대한 모션을 정지합니다.
            ComiLib.SSCNET3.SafeNativeMethods.SxStop(0, nAxis);

            this.lblStatus.Text = "정지됨";
        }

        private void OverrideSpeed_FormClosing(object sender, FormClosingEventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;

            // 지정한 축에 대한 모션을 정지합니다.
            ComiLib.SSCNET3.SafeNativeMethods.SxStop(0, nAxis);

            // 사용중인 타이머 종료.
            timer1.Stop();

            // SERVO-OFF //
            for (int i = 0; i < 16; i++)
            {
                ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(0, i, 0);
            }

            // Unload Device
            ComiLib.SSCNET3.SafeNativeMethods.GnUnloadDevice(); 
        }

        private void txtVwork_TextChanged(object sender, EventArgs e)
        {
            fWorkSpeed = Convert.ToDouble(this.txtVwork.Text);
        }
        
        private void txtAcc_TextChanged(object sender, EventArgs e)
        {
            fAcceleration = Convert.ToDouble(this.txtAcc.Text);
        }

        private void txtDec_TextChanged(object sender, EventArgs e)
        {
            fDeceleration = Convert.ToDouble(this.txtDec.Text);
        }
    }
}
