﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ComiLib.SSCNET3;

namespace OverridePosition
{
    public partial class OverridePosition : Form
    {
        SpeedSettingForm m_frmSpeedSetup = null;
        
        public OverridePosition()
        {
            InitializeComponent();
        }

        // common function
        void InitMotionDevices()
        {
            for (int i = 0; i < 16; i++)
            {
                //Servo On
                ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(0, i, 1);
            }
        }

        private void OverridePosition_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoradID = new int();
            int nNumAxes = new int();

            //Device Load
            if (ComiLib.SSCNET3.SafeNativeMethods.GnLoadDevice(ref NumDevice, ref BoradID, ref nNumAxes) != 0)
            {
                MessageBox.Show("Can't load device");
                return;
            }
            else
            {
                // Motion 환경 초기화 //
                InitMotionDevices();

                ////////////////////////////////////////////////////////////////////////////////////
                int i;

                for (i = 0; i < 16; i++)
                {
                    this.cmbAxis.Items.Insert(i, "Axis" + i.ToString());
                }

                // 축선택의 기본값으로는 0번과 1번 두 축이 선택된 것으로 한다.
                this.cmbAxis.SelectedIndex = 0;

                // 초기 속도 패턴 설정
                for (i = 0; i < 16; i++)
                {
                    // 속도패턴(SPEEDMODE : CONSTANT, TRAPEZOIDAL, S-CURVE), 작업속도(WORKSPEED), 가속도(ACCELERATION), 감속도(DECELERATION)를 설정합니다.
                    // CfgSetSpeedPattern_T() 함수는 가속, 감속을 시간(s) 단위로 설정합니다.
                    ComiLib.SSCNET3.SafeNativeMethods.CfgSetSpeedPattern(0, i, 2, 10000, 100000, 100000,0,0);
                }

                // Set timer to read and display current command position //
                this.timer1.Start();
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            //------- 모션제어기 위치 모니터링 -------------------------------//
            int nAxis = this.cmbAxis.SelectedIndex;
            string sPos;
            double afCurPos = 0;
           
            // 지정한 축의 카운터 값을 읽어서 반환합니다.이때 반환되는 값은 Unit Distance로 정의된 논리적 거리입니다.
            // StGetCount() 함수 역시 카운터 값을 읽어서 반환하지만 이 함수의 반환값은 펄스수입니다.
            // Command position (X) //
            ComiLib.SSCNET3.SafeNativeMethods.StGetPosition(0, nAxis, 0, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosC.Text = sPos;
            // Feedback position (X) //
            ComiLib.SSCNET3.SafeNativeMethods.StGetPosition(0, nAxis, 1, ref afCurPos);
            sPos = Convert.ToString(afCurPos);
            this.lblPosF.Text = sPos;

            int nIsStopped = 0;

            // 해당 축에 대해 모션 완료를 확인합니다.
            ComiLib.SSCNET3.SafeNativeMethods.SxIsDone(0, nAxis, ref nIsStopped);
            if (nIsStopped == 0)
            {
                this.btnMove.Text = "Override";
            }
            else
            {
                this.btnMove.Text = "Move";
                this.lblStatus.Text = "정지상태";
            }
        }

        /***********************************************************************
        * OnResetPos() : Position "Reset" 버튼의 콜백함수. Command & Feedback 
        * position을 0으로 리셋한다.
        ***********************************************************************/
        private void btnResetPos_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;

            // 지정한 축의 카운터 값을 읽어서 반환합니다.이때 반환되는 값은 Unit Distance로 정의된 논리적 거리입니다.
            // StGetCount() 함수 역시 카운터 값을 읽어서 반환하지만 이 함수의 반환값은 펄스수입니다.
            // Reset command position of X-axis
            ComiLib.SSCNET3.SafeNativeMethods.StSetPosition(0, nAxis, 0, 0.0);
            // Reset feedback position of X-axis
            ComiLib.SSCNET3.SafeNativeMethods.StSetPosition(0, nAxis, 1, 0.0); 
        }

        private void btnSpeedSetup_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;

            if (IsFormExist(typeof(SpeedSettingForm)) == null)
            {
                m_frmSpeedSetup = new SpeedSettingForm(nAxis);
            }

            m_frmSpeedSetup.ShowDialog();
            m_frmSpeedSetup.Focus();
        }

        private void btnMove_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            int nIsStopped = 0;
            int nResult = 0;
            
            int nPosVal = int.Parse(this.txtPosVal.Text);
            bool boolIsAbsMode = this.rdoAbsPos.Checked;

            // 해당 축에 대해 모션 완료를 확인합니다.
            ComiLib.SSCNET3.SafeNativeMethods.SxIsDone(0, nAxis,ref nIsStopped);
            if (nIsStopped == 1)
            {
                if(boolIsAbsMode)
                {
                    // 한 축에 대해 지정된 절대좌표까지 이동합니다.
                    // 이 함수는 모션 시작후에 바로 반환되기 때문에 이송 작업이 완료됐는지 확인하기 위해서는 
                    // SxIsDone() 또는 SxWaitDone() 함수를 사용해야합니다.
                    ComiLib.SSCNET3.SafeNativeMethods.SxMoveToStart(0, nAxis, nPosVal);
                }
                else
                {
                    // 한 축에 대해 지정된 상대 위치까지 이동합니다.
                    // 이 함수는 모션 시작후에 바로 반환되기 때문에 이송 작업이 완료됐는지 확인하기 위해서는 
                    // SxIsDone() 또는 SxWaitDone() 함수를 사용해야합니다.
                    ComiLib.SSCNET3.SafeNativeMethods.SxMoveStart(0, nAxis, nPosVal);
                }
                this.lblStatus.Text = "이송 시작됨, 이제 이송 거리를 재설정 하시고 Override 버튼을 클릭하세요";
            }
            else
            {
                if (boolIsAbsMode)
                {
                    int nIsIgnord = 0;

                    // SxMoveToStart() 함수를 통해 수행되는 절대좌표 모션에 대해서 새로운 목표 절대좌표값으로 오버라이딩하는 함수입니다.
                    // Isignored 파라미터 반환값을 통해서 오버라이드의 적용 여부를 확인할 수 있습니다.
                    nResult = ComiLib.SSCNET3.SafeNativeMethods.OverrideMoveTo(0, nAxis, nPosVal, ref nIsIgnord);
                    if(nResult != 0)
                    {
                        MessageBox.Show("cmsOverrideMoveTo Error");
                    }
                    // nIsIgnord==1 이면 이송이 이미 완료되었거나 감속이 거의 끝난 상태로 오버라이드가 무시된 경우입니다.
                    // 이때는 추가적인 이송 명령을 통해 절대치 목표좌표까지 보정 이송 해줄 필요가 있습니다.
                    // 따라서 이송이 완료되었어도 반드시 해당위치로 가야한다면 아래와 같이 MoveTo 함수를 수행해줍니다.
                    if (nIsIgnord == 1) 
                    {
                        DialogResult result = MessageBox.Show("오버라이드가 무시됨", "Confirm", MessageBoxButtons.YesNo);

                        if (result == DialogResult.Yes)
                        {

                            ComiLib.SSCNET3.SafeNativeMethods.SxMoveToStart(0, nAxis, nPosVal);
                            // 해당 축에 대해 모션이 완료될 때까지 기다린 후 반환됩니다.
                            ComiLib.SSCNET3.SafeNativeMethods.SxWaitDone(0, nAxis, 0);
                        }
                    }
                    else
                    {
                        this.lblStatus.Text = "위치 오버라이드 적용 됨";
                    }
                }
                else
                {
                    int nIsIgnord = 0;

                    // SxMoveStart() 함수를 통해 수행되는 상대좌표 모션에 대해서 새로운 목표 상대좌표값으로 오버라이딩하는 함수입니다.
                    // Isignored 파라미터 반환값을 통해서 오버라이드의 적용 여부를 확인할 수 있습니다.
                    nResult = ComiLib.SSCNET3.SafeNativeMethods.OverrideMove(0, nAxis, nPosVal, ref nIsIgnord);
                    if (nResult != 0)
                    {
                        MessageBox.Show("cmsOberrideMove Error");
                    }

                    // nIsIgnord==1 이면 이송이 이미 완료되었거나 감속이 거의 끝난 상태로 오버라이드가 무시된 경우입니다.
                    // 이때는 추가적인 이송 명령을 통해 절대치 목표좌표까지 보정 이송 해줄 필요가 있습니다.
                    // 따라서 이송이 완료되었어도 반드시 해당위치로 가야한다면 아래와 같이 Move 함수를 수행해줍니다.
                    if (nIsIgnord == 1) 
                    {
                        DialogResult result1 = MessageBox.Show("오버라이드가 무시됨", "Confirm", MessageBoxButtons.YesNo);
                        
                        if (result1 == DialogResult.Yes)
                        {
                            ComiLib.SSCNET3.SafeNativeMethods.SxMoveStart(0, nAxis, nPosVal);
                            // 해당 축에 대해 모션이 완료될 때까지 기다린 후 반환됩니다.
                            ComiLib.SSCNET3.SafeNativeMethods.SxWaitDone(0, nAxis, 0);
                        }
                    }
                    else
                    {
                        this.lblStatus.Text = "위치 오버라이드 적용 됨";
                    }
                }
            }
        }

        /***********************************************************************
        * OnbtnStop() : Position "Reset" 버튼의 콜백함수. Command & Feedback 
        * position을 0으로 리셋한다.
        ***********************************************************************/
        private void btnStop_Click(object sender, EventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;

            // 지정한 축에 대한 모션을 정지합니다.
            ComiLib.SSCNET3.SafeNativeMethods.SxStop(0, nAxis);
            this.lblStatus.Text = "정지됨";
        }

        // Form Check
        private Form IsFormExist(Type FormType)
        {
            foreach (Form OpenForm in Application.OpenForms)
            {
                if (OpenForm.GetType() == FormType)
                    return OpenForm;
            }
            return null;
        }

        private void OverridePosition_FormClosing(object sender, FormClosingEventArgs e)
        {
            int nAxis = this.cmbAxis.SelectedIndex;
            ComiLib.SSCNET3.SafeNativeMethods.SxStop(0, nAxis);

            // 사용중인 타이머 종료.
            timer1.Stop();

            // Servo Off
            for (int i = 0; i < 16; i++)
            {
                ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(0, i, 0);
            }

            //Unload Device
            ComiLib.SSCNET3.SafeNativeMethods.GnUnloadDevice(); // Unload Device
        }
    }
}
