﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ComiLib.SSCNET3;

namespace OverridePosition
{
    public partial class SpeedSettingForm : Form
    {
        private static int nSetCh = 0;
        private static int nSpeedMode = 2;
        private static double fMaxSpeed = 0;
        private static double fInitSpeed = 0;
        private static double fWorkSpeed = 0;
        private static double fAcceleration = 0;
        private static double fDeceleration = 0;

        public static int SETCH
        {
            get { return nSetCh; }
            set { nSetCh = value; }
        }

        public static int SPEEDMODE
        {
            get { return nSpeedMode; }
            set { nSpeedMode = value; }
        }

        public static double MAXSPEED
        {
            get { return fMaxSpeed; }
            set { fMaxSpeed = value; }
        }

        public static double INITSPEED
        {
            get { return fInitSpeed; }
            set { fInitSpeed = value; }
        }

        public static double WORKSPEED
        {
            get { return fWorkSpeed; }
            set { fWorkSpeed = value; }
        }

        public static double ACCELERATION
        {
            get { return fAcceleration; }
            set { fAcceleration = value; }
        }

        public static double DECELERATION
        {
            get { return fDeceleration; }
            set { fDeceleration = value; }
        }

        public SpeedSettingForm(int nSelCh)
        {
            SETCH = nSelCh;
            
            InitializeComponent();
        }

        private void SpeedSettingForm_Load(object sender, EventArgs e)
        {
            int nSpeedMode = 0;
            double fWorkSpeed = 0;
            double fAcc = 0;
            double fDec = 0;
            double fini = 0, fend = 0;


            // 속도패턴(SPEEDMODE : CONSTANT, TRAPEZOIDAL, S-CURVE), 작업속도(WORKSPEED), 가속도(ACCELERATION), 감속도(DECELERATION) 설정 값을 반환합니다.
            ComiLib.SSCNET3.SafeNativeMethods.CfgGetSpeedPattern(0, SETCH, ref nSpeedMode, ref fWorkSpeed, ref fAcc, ref fDec, ref fini, ref fend);
            
            MAXSPEED = fend;
            INITSPEED = fini;
            SPEEDMODE = nSpeedMode;
            WORKSPEED = fWorkSpeed;
            ACCELERATION = fAcc;
            DECELERATION = fDec;

            this.cmbSpeedMode.SelectedIndex = SPEEDMODE;
            this.txtMaxSpeed.Text = MAXSPEED.ToString();
            this.txtInitSpeed.Text = INITSPEED.ToString();
            this.txtWorkSpeed.Text = WORKSPEED.ToString();
            this.txtAcc.Text = ACCELERATION.ToString();
            this.txtDec.Text = DECELERATION.ToString();

        }

        private void cmbSpeedMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            SPEEDMODE = cmbSpeedMode.SelectedIndex;
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            MAXSPEED = Convert.ToDouble(txtMaxSpeed.Text);
        }

        private void txtInitSpeed_TextChanged(object sender, EventArgs e)
        {
            INITSPEED = Convert.ToDouble(txtInitSpeed.Text);
        }

        private void txtWorkSpeed_TextChanged(object sender, EventArgs e)
        {
            WORKSPEED = Convert.ToDouble(txtWorkSpeed.Text);
        }

        private void txtAcc_TextChanged(object sender, EventArgs e)
        {
            ACCELERATION = Convert.ToDouble(txtAcc.Text);
        }

        private void txtDec_TextChanged(object sender, EventArgs e)
        {
            DECELERATION = Convert.ToDouble(txtDec.Text);
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            // 속도패턴(SPEEDMODE : CONSTANT, TRAPEZOIDAL, S-CURVE), 작업속도(WORKSPEED), 가속도(ACCELERATION), 감속도(DECELERATION)를 설정합니다.
            // CfgSetSpeedPattern_T() 함수는 가속, 감속을 시간(s) 단위로 설정합니다.
            ComiLib.SSCNET3.SafeNativeMethods.CfgSetSpeedPattern(0, SETCH, SPEEDMODE, WORKSPEED, ACCELERATION, DECELERATION, INITSPEED, MAXSPEED);
        }
    }
}
