﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using ComiLib.SSCNET3;

namespace MxMotion
{
    public partial class MxMotion : Form
    {
        private bool m_bThreadStop = true;
        private int m_nNumWorkCh = 4;
        private int m_nOpMode = 0;

        double[] m_afCmdPos;
        double[] m_afFeedPos;
        int[]    m_nAxes;
        int[]    m_nAxesList;
        int      m_nAxesCount = 0;
        
        // properties
        public int SELOPMODE
        {
            get { return m_nOpMode; }
            set { m_nOpMode = value; }
        }
        public int NUMWORKCH
        {
            get { return m_nNumWorkCh; }
            set { m_nNumWorkCh = value; }
        }
        
        public MxMotion()
        {
            InitializeComponent();
        }

        // common function
        void InitMotionDevices()
        {
            for (int i = 0; i < 16; i++)
            {
                // Servo ON
                ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(0, i, 1);         
            }

            
        }

        private void btnSetSpdPattern_Click(object sender, EventArgs e)
        {
            // 사용자가 선택한 축 리스트
            getAxesInfo();

            if (m_nAxesCount < 1)
            {
                MessageBox.Show("모션 축을 선택해주세요.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            SpeedSettingForm frmSpeedSetting = new SpeedSettingForm(m_nAxesList, NUMWORKCH);
            
            frmSpeedSetting.ShowDialog();
        }

        private void MxMotion_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoradID = new int();
            int nNumAxes = new int();

            //Device Load
            if (ComiLib.SSCNET3.SafeNativeMethods.GnLoadDevice(ref NumDevice, ref BoradID, ref nNumAxes) != 0)
            {
                MessageBox.Show("Can't load device");
                return;
            }
            else
            {
                // Motion 환경 초기화 //
                InitMotionDevices();


                // COMI-LX502 2축모션컨트롤러만 장착되어 있는 경우에는 2축만 선택가능하도록...//
                if (nNumAxes == 2)
                {
                    NUMWORKCH = 2;

                    this.chkAxis2.Enabled = false;
                    this.chkAxis3.Enabled = false;
                }

                // 축선택의 기본값으로는 0번과 1번 두 축이 선택된 것으로 한다.
                this.chkAxis0.Checked = true;
                this.chkAxis1.Checked = true;

                // command 와 feedback postion list 를 저장할 배열 정의.
                m_afCmdPos = new double[NUMWORKCH];
                m_afFeedPos = new double[NUMWORKCH];

                // 초기 거리값 설정
                this.txtDist.Text = "10000";
                this.txtPos1.Text = "0";
                this.txtPos2.Text = "10000";

                OnJogModeSelectInit(1); // Jog 모드에 따른 각 에디트박스 Dimmed 처리를 위해서...
                

                // Set timer to display current command position //
                this.timer1.Start();

                // 쓰레드 동작을 시작한다.
                m_bThreadStop = false;
                new Thread(new ThreadStart(ThreadFunc)).Start();
            }
        }

        // 쓰레드 함수: 각 Axis 에 대한 현재 command 및 feedback position 값들을 얻는다.
        private void ThreadFunc()
        {
            double afPos = 0;

            while (!m_bThreadStop)
            {
                for (int i = 0; i < 4; i++)
                {
                    // Command position //
                    // 지정한 축의 카운터 값을 읽어서 반환합니다.이때 반환되는 값은 Unit Distance로 정의된 논리적 거리입니다.
                    // StGetCount() 함수 역시 카운터 값을 읽어서 반환하지만 이 함수의 반환값은 펄스수입니다.
                    ComiLib.SSCNET3.SafeNativeMethods.StGetPosition(0, i, 0, ref afPos);
                    m_afCmdPos[i] = afPos;

                    // Feedback position //
                    ComiLib.SSCNET3.SafeNativeMethods.StGetPosition(0, i, 1, ref afPos);
                    m_afFeedPos[i] = afPos;
                }

                // 100밀리초만큼 sleep 을 준다.
                Thread.Sleep(100);
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            //------- 모션제어기 위치 모니터링 -------------------------------//

            // 본예제는 코드의 간결성을 위해서 4축 제어를 전제로 하여 작성되었습니다. //
            // 단, 2축 보드만 장착되어 있는 경우에는 2축 정보만 읽도록 합니다.      //


            for (int i = 0; i < 4; i++)
            {
                // Command position & Feedback position 출력//
                if (i == 0)
                {
                    this.lblPosC0.Text = m_afCmdPos[i].ToString();
                    this.lblPosF0.Text = m_afFeedPos[i].ToString();
                }
                else if (i == 1)
                {
                    this.lblPosC1.Text = m_afCmdPos[i].ToString();
                    this.lblPosF1.Text = m_afFeedPos[i].ToString();
                }
                else if (i == 2)
                {
                    this.lblPosC2.Text = m_afCmdPos[i].ToString();
                    this.lblPosF2.Text = m_afFeedPos[i].ToString();
                }
                else if (i == 3)
                {
                    this.lblPosC3.Text = m_afCmdPos[i].ToString();
                    this.lblPosF3.Text = m_afFeedPos[i].ToString();
                }
            }
        }

        /***********************************************************************
        * "Stop" Button's event handler
        * : This button stops motion of specifed axis
        ***********************************************************************/
        private void btnStop_Click(object sender, EventArgs e)
        {
            this.btnPlus.Enabled = true;
            this.btnMinus.Enabled = true;

            int[] anAxes = new int[NUMWORKCH];
            for (int i = 0; i < NUMWORKCH; i++)
                anAxes[i] = i;

            // 지정한 모든 축에 대하여 모션을 정지합니다.
            // 감속 후에 정지합니다.
            // Board ID, NumAxes: 정지할 축수, AxisList: 정지할 축의 배열 주소값
            ComiLib.SSCNET3.SafeNativeMethods.MxStop(0, NUMWORKCH, anAxes);
        }

        /***********************************************************************
        * "Emergency-Stop" Button's event handler
        * Emergency Stop Button
        ***********************************************************************/
        private void btnStopEmg_Click(object sender, EventArgs e)
        {
            this.btnPlus.Enabled = true;
            this.btnMinus.Enabled = true;

            int[] anAxes = new int[NUMWORKCH];
            for (int i = 0; i < NUMWORKCH; i++)
                anAxes[i] = i;

            // 지정한 모든 축에 대하여 모션을 정지합니다.
            // 감속 없이 즉시 정지합니다.
            // Board ID, NumAxes: 정지할 축수, AxisList: 정지할 축의 배열 주소값
            ComiLib.SSCNET3.SafeNativeMethods.MxStopEmg(0, NUMWORKCH, anAxes);
        }

        /***********************************************************************
        * Position "Reset" 버튼의 콜백함수. Command & Feedback 
        * position을 0으로 리셋한다.
        ***********************************************************************/
        private void btnResetPos_Click(object sender, EventArgs e)
        {
            // 본예제는 코드의 간결성을 위해서 4축 제어를 전제로 하여 작성되었습니다. //
            for (int i = 0; i < 4; i++)
            {
                // Reset COMMAND Position
                // 지정된 카운터값을 새롭게 설정합니다. 이때 설정하는 카운터값의 단위는 Unit distance 로 정의되는 논리적 거리입니다.
                // StSetCount() 함수는 펄스수를 사용해서 카운터값을 설정합니다.
                ComiLib.SSCNET3.SafeNativeMethods.StSetPosition(0, i, 0, 0.0);
                // Reset FEEDBACK Position
                ComiLib.SSCNET3.SafeNativeMethods.StSetPosition(0, i, 1, 0.0); 
            }
        }

        /***********************************************************************
        * Jog Mode Settings Radio Button Handler
        ***********************************************************************/
        public void OnJogModeSelectInit(int nJogMode)
        {
            if (nJogMode == 1)
            {
                SELOPMODE = 0;

                this.lblDist.Enabled = false;
                this.txtDist.Enabled = false;
                this.lblPos1.Enabled = false;
                this.txtPos1.Enabled = false;
                this.lblPos2.Enabled = false;
                this.txtPos2.Enabled = false;
                this.btnStop.Enabled = false;
                this.btnStopEmg.Enabled = false;
                this.btnMinus.Text = "Jog (-)";
                this.btnPlus.Text = "Jog (+)";
            }
            else if (nJogMode == 2)
            {
                SELOPMODE = 1;

                this.lblDist.Enabled = true;
                this.txtDist.Enabled = true;
                this.lblPos1.Enabled = false;
                this.txtPos1.Enabled = false;
                this.lblPos2.Enabled = false;
                this.txtPos2.Enabled = false;
                this.btnStop.Enabled = true;
                this.btnStopEmg.Enabled = true;
                this.btnMinus.Text = "Move (-)";
                this.btnPlus.Text = "Move (+)";
            }
            else if (nJogMode == 3)
            {
                SELOPMODE = 2;

                this.lblDist.Enabled = false;
                this.txtDist.Enabled = false;
                this.lblPos1.Enabled = true;
                this.txtPos1.Enabled = true;
                this.lblPos2.Enabled = true;
                this.txtPos2.Enabled = true;
                this.btnStop.Enabled = true;
                this.btnStopEmg.Enabled = true;
                this.btnMinus.Text = "Position1";
                this.btnPlus.Text = "Position2";
            }
        }

        /***********************************************************************
        * Jog Mode Settings Radio Button Handler
        ***********************************************************************/
        private void OnJogModeSelect(object sender, EventArgs e)
        {
            if (sender == rdoJogMove)
            {
                OnJogModeSelectInit(1);
            }
            else if (sender == rdoRelPosMove)
            {
                OnJogModeSelectInit(2);
            }
            else if (sender == rdoAbsPosMove)
            {
                OnJogModeSelectInit(3);
            }
        }

        // 사용자가 선택한 축 리스트를 얻는다
        public void getAxesInfo()
        {
            m_nAxesCount = 0;
            int nAxisCount = 0;

            m_nAxes = new int[NUMWORKCH];
            m_nAxesList = new int[NUMWORKCH];
            
            if (chkAxis0.Checked)
            {
                m_nAxesList[nAxisCount++] = 0;
                m_nAxes[m_nAxesCount++] = 0;
            }
            else
            {
                m_nAxesList[nAxisCount++] = -1;
            }

            if (chkAxis1.Checked)
            {
                m_nAxesList[nAxisCount++] = 1;
                m_nAxes[m_nAxesCount++] = 1;
            }
            else
            {
                m_nAxesList[nAxisCount++] = -1;
            }

            if (chkAxis2.Checked)
            {
                m_nAxesList[nAxisCount++] = 2;
                m_nAxes[m_nAxesCount++] = 2;
            }
            else
            {
                m_nAxesList[nAxisCount++] = -1;
            }

            if (chkAxis3.Checked)
            {
                m_nAxesList[nAxisCount++] = 3;
                m_nAxes[m_nAxesCount++] = 3;
            }
            else
            {
                m_nAxesList[nAxisCount++] = -1;
            }
        }

        private void FuncMxMove(int nDirection)
        {
            int i;
            
            double[] afDistList = new double[NUMWORKCH];
            double[] afPosList = new double[NUMWORKCH];
            int[] anDirectionList = new int[4];


            anDirectionList[0] = nDirection;
            anDirectionList[1] = nDirection;
            anDirectionList[2] = nDirection;
            anDirectionList[3] = nDirection;

            // 사용자가 선택한 축 리스트
            getAxesInfo();

            if (SELOPMODE == 0)
            {
                // 여러 개의 축에 대해 이송 작업을 동시에 시작합니다.
                // 이 함수는 별도의 정지 함수가 호출되기 전까지 지정된 속도, 방향으로 계속 이송 작업을 수행합니다.
                if (ComiLib.SSCNET3.SafeNativeMethods.MxVMoveStart(0, m_nAxesCount, m_nAxes, anDirectionList) != 0)
                {
                    MessageBox.Show("cmsMxVMoveStart Error");
                }
            }
            else
            {
                this.btnPlus.Enabled = false;
                this.btnMinus.Enabled = false;

                if (SELOPMODE == 1)
                {
                    double fDistance = Convert.ToDouble(this.txtDist.Text);

                    // "Move (-)"버튼이면 Distance에 음수를 취하고, "Move (+)" 버튼이면 양수를 취한다 //
                    fDistance = (nDirection == 0) ? -fDistance : fDistance;

                    for (i = 0; i < m_nAxesCount; i++)
                    {
                        afDistList[i] = fDistance;
                    }

      
                    // 여러 개의 축에 대해 지정한 거리만큼 이송 작업을 동시에 수행합니다.
                    // 본 예제에서는 이송중에도 타이머 이벤트나 버튼 이벤트처리를 할 수 있도록 IsBlocking 파라미터를 FALSE로 하였지만
                    // 쓰레드를 사용할 때는 이 파라미터를 반드시 TRUE 로 설정해야합니다.
                    if (ComiLib.SSCNET3.SafeNativeMethods.MxMove(0, m_nAxesCount, m_nAxes, afDistList, 0) != 0)
                    {
                        MessageBox.Show("cmsMxMove Error");
                    }
                }
                else if(SELOPMODE == 2)
				{
					double fPos1 = Convert.ToDouble(this.txtPos1.Text);
					double fPos2 = Convert.ToDouble(this.txtPos2.Text);

                    double fPosition = (nDirection == 0) ? fPos1 : fPos2;

                    for (i = 0; i < m_nAxesCount; i++)
					{
						afPosList[i] = fPosition;
					}

                    // 여러 개의 축에 대해 지정한 절대좌표까지 이송 작업을 동시에 수행합니다.
                    // 이 함수는 작업을 수행하는 모든 축의 모션이 완료될때까지 반환되지 않습니다.
                    // 이와 다르게 MxMoveToStart() 함수는 모션을 시작시킨 후에 바로 반환되기 때문에 이송 작업이 완료됐는지 확인하기 위해서는 
                    // MxIsDone() 또는 MxWaitDone() 함수를 사용해야합니다.
                    if (ComiLib.SSCNET3.SafeNativeMethods.MxMoveTo(0, m_nAxesCount, m_nAxes, afPosList, 0) != 0)
					{
                        MessageBox.Show("cmsMxMoveTo Error");
					}
				}

				this.btnPlus.Enabled = true;
				this.btnMinus.Enabled = true;
            }
        }

        private void btnMinus_MouseDown(object sender, MouseEventArgs e)
        {
            // 사용자가 선택한 축 리스트
            getAxesInfo();
            
            if (m_nAxesCount < 1)
            {
                MessageBox.Show("모션 축을 선택해주세요.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            FuncMxMove(0);
        }

        private void btnMinus_MouseUp(object sender, MouseEventArgs e)
        {
            if (SELOPMODE != 0)    // Velocity Move
                return;

            // if Jog Control 모드이면, 모션 정지.
            int[] anAxes = new int[NUMWORKCH];
            for (int i = 0; i < NUMWORKCH; i++)
                anAxes[i] = i;

            // 지정한 모든 축에 대한 모션을 정지합니다.
            ComiLib.SSCNET3.SafeNativeMethods.MxStop(0, 4, m_nAxes);
        }

        private void btnPlus_MouseDown(object sender, MouseEventArgs e)
        {
            // 사용자가 선택한 축 리스트
            getAxesInfo();
            
            if (m_nAxesCount < 1)
            {
                MessageBox.Show("모션 축을 선택해주세요.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            
            FuncMxMove(1);
        }

        private void btnPlus_MouseUp(object sender, MouseEventArgs e)
        {
            if (SELOPMODE != 0)    // Velocity Move
                return;

            // if Jog Control 모드이면, 모션 정지.
            int[] anAxes = new int[NUMWORKCH];
            for (int i = 0; i < NUMWORKCH; i++)
                anAxes[i] = i;

            // 지정한 모든 축에 대한 모션을 정지합니다.
            ComiLib.SSCNET3.SafeNativeMethods.MxStop(0, 4, m_nAxes);
        }

        private void MxMotion_FormClosing(object sender, FormClosingEventArgs e)
        {
            // 사용중인 타이머, 쓰레드 종료.
            timer1.Stop();
            m_bThreadStop = true;

            int[] anAxes = new int[NUMWORKCH];
            for (int i = 0; i < NUMWORKCH; i++)
                anAxes[i] = i;

            // 지정한 모든 축에 대한 모션을 정지합니다.
            ComiLib.SSCNET3.SafeNativeMethods.MxStop(0, 4, m_nAxes);

            //모든 축의 서보모터를 Off 합니다.
            for (int i = 0; i < 16; i++)
            {
                // Servo ON
                ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(0, i, 0);
            }

            // Unload Device
            ComiLib.SSCNET3.SafeNativeMethods.GnUnloadDevice(); 
        }
    }
}
