﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ComiLib.SSCNET3;

namespace MxMotion
{
    public partial class SpeedSettingForm : Form
    {
        private static int nSetCh = 0;
        private static int nSpeedMode = 2;
        private static double fMaxSpeed = 0;
        private static double fInitSpeed = 0;
        private static double fWorkSpeed = 0;
        private static double fAcceleration = 0;
        private static double fDeceleration = 0;

        int[] m_nAxes;
        int   m_nAxesCount = 0;
        
        public static int SETCH
        {
            get { return nSetCh; }
            set { nSetCh = value; }
        }

        public static int SPEEDMODE
        {
            get { return nSpeedMode; }
            set { nSpeedMode = value; }
        }

        public static double MAXSPEED
        {
            get { return fMaxSpeed; }
            set { fMaxSpeed = value; }
        }

        public static double INITSPEED
        {
            get { return fInitSpeed; }
            set { fInitSpeed = value; }
        }

        public static double WORKSPEED
        {
            get { return fWorkSpeed; }
            set { fWorkSpeed = value; }
        }

        public static double ACCELERATION
        {
            get { return fAcceleration; }
            set { fAcceleration = value; }
        }

        public static double DECELERATION
        {
            get { return fDeceleration; }
            set { fDeceleration = value; }
        }

        public SpeedSettingForm(int[] p_nAxes, int p_nAxesCount)
        {

            m_nAxes = p_nAxes; // MxMotion Form 에서 설정된 Checkbox 에 Check 된 Axis 축 List
            m_nAxesCount = p_nAxesCount; // MxMotion Form 에서 설정된 Checkbox Axis 축 갯수
            
            InitializeComponent();
        }

        private void SpeedSettingForm_Load(object sender, EventArgs e)
        {
        }

        private void btnOK_Click(object sender, EventArgs e)
        {

            SPEEDMODE = cmbSpeedMode.SelectedIndex;
            WORKSPEED = Convert.ToDouble(txtWorkSpeed.Text);
            ACCELERATION = Convert.ToDouble(txtAcc.Text);
            DECELERATION = Convert.ToDouble(txtDec.Text);
            INITSPEED = Convert.ToDouble(txtInitSpeed.Text);
            MAXSPEED = Convert.ToDouble(txtMaxSpeed.Text);

            // 속도패턴(SPEEDMODE : CONSTANT, TRAPEZOIDAL, S-CURVE), 작업속도(WORKSPEED), 가속도(ACCELERATION), 감속도(DECELERATION)를 설정합니다.
            // 이 함수와 다르게 CfgSetSpeedPattern_T() 함수는 가속, 감속을 시간(s) 단위로 설정합니다.
            for (int i = 0; i < m_nAxesCount; i++)
            {          
                
                    ComiLib.SSCNET3.SafeNativeMethods.CfgSetSpeedPattern(0, i, SPEEDMODE, WORKSPEED, ACCELERATION, DECELERATION, INITSPEED, MAXSPEED);
            }
        }

        private void cmbSpeedMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            SPEEDMODE = cmbSpeedMode.SelectedIndex;
        }

        private void txtMaxSpeed_TextChanged(object sender, EventArgs e)
        {
            MAXSPEED = Convert.ToDouble(txtMaxSpeed.Text);
        }

        private void txtInitSpeed_TextChanged(object sender, EventArgs e)
        {
            INITSPEED = Convert.ToDouble(txtInitSpeed.Text);
        }

        private void txtWorkSpeed_TextChanged(object sender, EventArgs e)
        {
            WORKSPEED = Convert.ToDouble(txtWorkSpeed.Text);
        }

        private void txtAcc_TextChanged(object sender, EventArgs e)
        {
            ACCELERATION = Convert.ToDouble(txtAcc.Text);
        }

        private void txtDec_TextChanged(object sender, EventArgs e)
        {
            DECELERATION = Convert.ToDouble(txtDec.Text);
        }

        
    }
}
