﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ComiLib.SSCNET3;

namespace IxArc
{
    public partial class IxArcForm : Form
    {

       
        public enum ARC_MODE { ARC_ANGLE, ARC_POINT, ARC_3POINT };
        
        //const int IX_MAP_IDX = 0;
        private const int IX_MAP_IDX = 0;  // Interpolation Map Index
        int m_nArcMotionMode = (int)ARC_MODE.ARC_ANGLE;

        public IxArcForm()
        {
            InitializeComponent();
        }

        // common function
        void InitMotionDevices()
        {
            // SERVO-ON //
            for (int i = 0; i < 16; i++)
            {
               ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(0, i, 1);
            }
        }


        private void IxArcForm_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoradID = new int();
            int nNumAxes = new int();

            //Device를 로드합니다.
            if (ComiLib.SSCNET3.SafeNativeMethods.GnLoadDevice(ref NumDevice, ref BoradID, ref nNumAxes) != 0)
            {
                MessageBox.Show("Can't load device");
                return;
            }
            else
            {
            
                // Motion 환경 초기화 //
                InitMotionDevices();

                ////////////////////////////////////////////////////////////////////////////////////
                int i;

                // 사용 가능한 축의 갯수 얻어오기
                for (i = 0; i < 16; i++)
                {
                    this.cmbAxisX.Items.Insert(i, "Axis" + i.ToString());
                    this.cmbAxisY.Items.Insert(i, "Axis" + i.ToString());
                }

                // 축선택의 기본값으로는 0번과 1번 두 축이 선택된 것으로 한다.
                this.cmbAxisX.SelectedIndex = 0;
                this.cmbAxisY.SelectedIndex = 1;

                //기본값으로 Relative Move
                this.cmbMovMode.SelectedIndex = 0;
                //기본값으로 S-Curve
                this.cmbSpeedPattern.SelectedIndex = 2;
                //기본값으로 Master Speed Mode
                this.cmbSpeedMode.SelectedIndex = 0;

                // 초기 속도 패턴 설정
                // Device ID :0, Axis : i, S-Curve Mode, WorkSpeed : 10000, 가속도 : 1000000, 감속도 : 1000000, 초기속도 : 0, 최종속도 : 0
                for (i = 0; i < 16; i++)
                {
                    ComiLib.SSCNET3.SafeNativeMethods.CfgSetSpeedPattern(0, i, 2, 10000, 1000000, 1000000, 0, 0);
                }

                // Set timer to read and display current command position //
                this.timer1.Start();
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            int nAxisX = this.cmbAxisX.SelectedIndex;
            int nAxisY = this.cmbAxisY.SelectedIndex;
            int nCount = 0;

            //지정한 채널의 지정한 카운터의 값을 읽어서 반환합니다.
            //Device ID : 0, Axis, Command Counter
            ComiLib.SSCNET3.SafeNativeMethods.StGetCount(0, nAxisX, 0, ref nCount);
            this.txt3PntP1AxisX.Text = nCount.ToString();
            ComiLib.SSCNET3.SafeNativeMethods.StGetCount(0, nAxisY, 0, ref nCount);
            this.txt3PntP1AxisY.Text = nCount.ToString();
        }

        private void cmbMovMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nMovMode = this.cmbMovMode.SelectedIndex;

            //동작 모드에 따라서 Form에 표시되는 문자열을 변경합니다.
            //0: Relative Move, 1: Absolute Move
            if(nMovMode == 0)
            {
                //Arc Method 창의 라벨 단위 이름 변경 - Offset
                //Arc-Angle의 라벨 단위 이름 변경
                this.lblAngCenAxisX.Text = "Axis-X Center Offset (Pulse)";
                this.lblAngCenAxisY.Text = "Axis-Y Center Offset (Pulse)";

                //Arc-Point의 라벨 단위 이름 변경
                this.lblPntCenAxisX.Text = "Axis-X Center Offset (Pulse)";
                this.lblPntCenAxisY.Text = "Axis-Y Center Offset (Pulse)";

                //3-Point의 라벨 단위 이름 변경
                this.lbl3PntP2AxisX.Text = "Axis-X Offset (Pulse)";
                this.lbl3PntP2AxisY.Text = "Axis-Y Offset (Pulse)";
                this.lbl3PntP3AxisX.Text = "Axis-X Offset (Pulse)";
                this.lbl3PntP3AxisY.Text = "Axis-Y Offset (Pulse)";
            }
            else
            {
                //Arc Method 창의 라벨 단위 이름 변경 - Position
                //Arc-Angle의 라벨 단위 이름 변경
                this.lblAngCenAxisX.Text = "Axis-X Center Position (Pulse)";
                this.lblAngCenAxisY.Text = "Axis-Y Center Position (Pulse)";

                //Arc-Point의 라벨 단위 이름 변경
                this.lblPntCenAxisX.Text = "Axis-X Center Position (Pulse)";
                this.lblPntCenAxisY.Text = "Axis-X Center Position (Pulse)";

                //3-Point의 라벨 단위 이름 변경
                this.lbl3PntP2AxisX.Text = "Axis-X Position (Pulse)";
                this.lbl3PntP2AxisY.Text = "Axis-Y Position (Pulse)";
                this.lbl3PntP3AxisX.Text = "Axis-X Position (Pulse)";
                this.lbl3PntP3AxisY.Text = "Axis-Y Position (Pulse)";
            }
        }

        
        //Axis Select 창의 인덱스 변경
        //x축 인덱스를 선택하면 y축은 x+1의 값으로 변경됩니다.
        private void cmbAxisX_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nAxisX = this.cmbAxisX.SelectedIndex;
            

            if (nAxisX == 15)
            {
                this.cmbAxisY.SelectedIndex = 0;
            }
            else
            {
                this.cmbAxisY.SelectedIndex = nAxisX + 1;
            }
        }

        //보간 이동 속도 설정
        public void CommSetSpeedPattern()
        {
            double edtEnd  = 0.0;
	        double edtInit = 0.0;
	        double edtWork   = 100000;
	        double edtAcc    = 1000000;
	        double edtDec    = 1000000;
	        int nSpeedPattern = this.cmbSpeedPattern.SelectedIndex;

            //Board ID: 0
            //MapIndex : 맵번호, 이 맵번호를 사용하기 전에 먼저 IxMapAxes() 함수를 통해 해당 맵번호에 유효한 축들이 맵핑되어있어야합니다.
            //속도모드 : Vector Speed Mode
            //속도패턴 : S-Curve
            //초기속도 : 0, 최종속도 : 0, 작업속도 : 100000, 가속도 : 1000000, 감속도 : 1000000 
            //마스터스피드 모드일때 초기속도, 최종속도, 작업속도, 가/감속도는 PPS가 아닌 비율로 설정됩니다.
            ComiLib.SSCNET3.SafeNativeMethods.IxSetSpeedPattern(0, IX_MAP_IDX, 1, nSpeedPattern, edtInit, edtEnd, edtWork, edtAcc, edtDec);
        }

        // CCW(-) 방향으로 구동
        private void btnMoveN_Click(object sender, EventArgs e)
        {
            btnMoveN.Enabled = false;
            btnMoveP.Enabled = false;
            
            //x축, y축의 정보 읽어옴
            int nAxisX = this.cmbAxisX.SelectedIndex;
            int nAxisY = this.cmbAxisY.SelectedIndex;

            int nAxesMask = 0x0;
            
            if (nAxisX == nAxisY)
            {
                MessageBox.Show("Error : X and Y axes must be different from each other!");
                return;
            }

            //축맵에 포함할 축들을 지정할 마스크 값입니다. 포함시킬 축번호에 해당하는 비트값을 1로 설정해주시면 됩니다. 이 마스크 값을 IxMapAxes()함수의 인자로 사용합니다.
            nAxesMask |= (1 << nAxisX); // X축 번호 비트를 셋팅.
            nAxesMask |= (1 << nAxisY); // Y축 번호 비트를 셋팅.

            //보간작업을 수행할 축들을 맵번호로 맵핑합니다.
            //Board ID : 0, MapIndex : 0, MapMask, 보간 모드 : 원호보간
            ComiLib.SSCNET3.SafeNativeMethods.IxMapAxes(0, IX_MAP_IDX, nAxesMask, 1);

            CommSetSpeedPattern();

            int nMovMode = this.cmbMovMode.SelectedIndex;
            int nSpeedPattern = this.cmbSpeedPattern.SelectedIndex;
            int nSpeedMode = this.cmbSpeedMode.SelectedIndex;

            // Arc Method - Arc Angle
            double fAngCenAxisX = Convert.ToDouble(this.txtAngCenAxisX.Text);
            double fAngCenAxisY = Convert.ToDouble(this.txtAngCenAxisY.Text);
            double fAngEndDeg = Convert.ToDouble(this.txtAngEndDeg.Text);

            // Arc Method - Arc Point
            double fPntCenAxisX = Convert.ToDouble(this.txtPntCenAxisX.Text);
            double fPntCenAxisY = Convert.ToDouble(this.txtPntCenAxisY.Text);
            double fPntEndAxisX = Convert.ToDouble(this.txtPntEndAxisX.Text);
            double fPntEndAxisY = Convert.ToDouble(this.txtPntEndAxisY.Text);

            // Arc Method - Arc 3Point
            double f3PntP2AxisX = Convert.ToDouble(this.txt3PntP2AxisX.Text);
            double f3PntP2AxisY = Convert.ToDouble(this.txt3PntP2AxisY.Text);
            double f3PntP3AxisX = Convert.ToDouble(this.txt3PntP3AxisX.Text);
            double f3PntP3AxisY = Convert.ToDouble(this.txt3PntP3AxisY.Text);

            // Moving Mode 를 확인
            // 0 : Relative Move
            if (nMovMode == 0)
            {
                // Speed Mode 를 확인
                // FALSE(0) : Master Speed Mode, TRUE(1) : Vector Speed Mode
                if(nSpeedMode == 0) 
                {
                    switch(m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE :

                            //Relative - Master - Arc_Angle
                            //IxSetSpeedPattern - Master
                            //IxArcAStart
                            //IxWateDone

                            ComiLib.SSCNET3.SafeNativeMethods.IxArcAStart(0, IX_MAP_IDX, -fAngCenAxisX, -fAngCenAxisY, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //IxSetSpeedPattern - Master
                            //IxArcPStart
                            //IxWateDone

                            ComiLib.SSCNET3.SafeNativeMethods.IxArcPStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //IxSetSpeedPattern - Master
                            //IxArc3PStart
                            //IxWateDone
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            ComiLib.SSCNET3.SafeNativeMethods.IxArc3PStart(0, IX_MAP_IDX, P2, P3, 0);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
                else
                {
                    switch (m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //IxSetSpeedPattern - Vector
                            //IxArcAStart
                            //IxWateDone

                            ComiLib.SSCNET3.SafeNativeMethods.IxArcAStart(0, IX_MAP_IDX, -fAngCenAxisX, -fAngCenAxisY, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //IxSetSpeedPattern - Vector
                            //IxArcPStart
                            //IxWateDone

                            ComiLib.SSCNET3.SafeNativeMethods.IxArcPStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //IxSetSpeedPattern - Vector
                            //IxArc3PStart
                            //IxWateDone

                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            ComiLib.SSCNET3.SafeNativeMethods.IxArc3PStart(0, IX_MAP_IDX, P2, P3, 0);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
            }
            else
            {
                if (nSpeedMode == 0) // Speed Mode 를 확인
                {
                    switch (m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //IxSetSpeedPattern - Master
                            //IxArcAStart
                            //IxWateDone

                            ComiLib.SSCNET3.SafeNativeMethods.IxArcAToStart(0, IX_MAP_IDX, -fAngCenAxisX, -fAngCenAxisY, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //IxSetSpeedPattern - Master
                            //IxArcPStart
                            //IxWateDone

                            ComiLib.SSCNET3.SafeNativeMethods.IxArcPToStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //IxSetSpeedPattern - Master
                            //IxArc3PStart
                            //IxWateDone
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            ComiLib.SSCNET3.SafeNativeMethods.IxArc3PToStart(0, IX_MAP_IDX, P2, P3, 0);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
                else
                {
                    switch (m_nArcMotionMode)
                    {
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //IxSetSpeedPattern - Vector
                            //IxArcAStart
                            //IxWateDone

                            ComiLib.SSCNET3.SafeNativeMethods.IxArcAToStart(0, IX_MAP_IDX, -fAngCenAxisX, -fAngCenAxisY, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //IxSetSpeedPattern - Vector
                            //IxArcPStart
                            //IxWateDone

                            ComiLib.SSCNET3.SafeNativeMethods.IxArcPToStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //IxSetSpeedPattern - Vector
                            //IxArc3PStart
                            //IxWateDone
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            ComiLib.SSCNET3.SafeNativeMethods.IxArc3PToStart(0, IX_MAP_IDX, P2, P3, 0);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
            }

            btnMoveN.Enabled = true;
            btnMoveP.Enabled = true;
        }

        private void tabArcMethod_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nTabArcMethodSelect = this.tabArcMethod.SelectedIndex;

            if (nTabArcMethodSelect == 0)
            {
                m_nArcMotionMode = (int)ARC_MODE.ARC_ANGLE;
            }
            else if (nTabArcMethodSelect == 1)
            {
                m_nArcMotionMode = (int)ARC_MODE.ARC_POINT;
            }
            else if (nTabArcMethodSelect == 2)
            {
                m_nArcMotionMode = (int)ARC_MODE.ARC_3POINT;
            }
        }

        // CW(+) 방향으로 구동
        private void btnMoveP_Click(object sender, EventArgs e)
        {
            btnMoveN.Enabled = false;
            btnMoveP.Enabled = false;
            
            int nAxisX = this.cmbAxisX.SelectedIndex;
            int nAxisY = this.cmbAxisY.SelectedIndex;

            int nAxesMask = 0x0;

            nAxesMask |= (1 << nAxisX); // X축 번호 비트를 셋팅.
            nAxesMask |= (1 << nAxisY); // Y축 번호 비트를 셋팅.

            ComiLib.SSCNET3.SafeNativeMethods.IxMapAxes(0, IX_MAP_IDX, nAxesMask, 1);

            CommSetSpeedPattern();

            int nMovMode = this.cmbMovMode.SelectedIndex;
            int nSpeedPattern = this.cmbSpeedPattern.SelectedIndex;
            int nSpeedMode = this.cmbSpeedMode.SelectedIndex;

            // Arc Method - Arc Angle
            double fAngCenAxisX = Convert.ToDouble(this.txtAngCenAxisX.Text);
            double fAngCenAxisY = Convert.ToDouble(this.txtAngCenAxisY.Text);

            // Arc Method - Arc Point
            double fPntCenAxisX = Convert.ToDouble(this.txtPntCenAxisX.Text);
            double fPntCenAxisY = Convert.ToDouble(this.txtPntCenAxisY.Text);
            double fPntEndAxisX = Convert.ToDouble(this.txtPntEndAxisX.Text);
            double fPntEndAxisY = Convert.ToDouble(this.txtPntEndAxisY.Text);

            // Arc Method - Arc 3Point
            double f3PntP2AxisX = Convert.ToDouble(this.txt3PntP2AxisX.Text);
            double f3PntP2AxisY = Convert.ToDouble(this.txt3PntP2AxisY.Text);
            double f3PntP3AxisX = Convert.ToDouble(this.txt3PntP3AxisX.Text);
            double f3PntP3AxisY = Convert.ToDouble(this.txt3PntP3AxisY.Text);

            double fAngEndDeg=0;

            // Moving Mode 를 확인
            // 0: Relative Move
            if (nMovMode == 0) 
            {
                // Speed Mode 를 확인
                // 0: Master Speed Mode
                if (nSpeedMode == 0) 
                {
                    switch (m_nArcMotionMode)
                    {
                        // Arc-Angle Interpolation
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //IxSetSpeedPattern - Master
                            //IxArcAStart
                            //IxWateDone
                            

                            fAngEndDeg = Convert.ToDouble(this.txtAngEndDeg.Text);
                            
                            // 원호보간 상대좌표 이송(중심좌표와 원호의 각도 사용)
                            // Board ID : 0, MapIndex
                            // XCentOffset : 시작위치로부터 원의 중심까지 x축 상대좌표값
                            // YCentOffset : 시작위치로부터 원의 중심까지 Y축 상대좌표값
                            // EndAngle : 중심좌표를 기준으로 시작위치와 목표지점 사이의 각도값 지정
                            ComiLib.SSCNET3.SafeNativeMethods.IxArcAStart(0, IX_MAP_IDX, fAngCenAxisX, fAngCenAxisY, fAngEndDeg);

                            //해당 맵에서의 동작이 끝나는 것을 기다립니다.
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;

                        // Arc-Point Interpolation
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //IxSetSpeedPattern - Master
                            //IxArcPStart
                            //IxWateDone


                            // 원호보간 상대좌표 이송(중심좌표와 종점좌표 사용)
                            // Board ID : 0, MapIndex
                            // XCentOffset : 시작위치로부터 원의 중심까지 x축상의 거리
                            // YCentOffset : 시작위치로부터 원의 중심까지 Y축상의 거리
                            // XEndPointDist : 시작위치와 목표지점 사이의 x축상 거리
                            // YEndPointDist : 시작위치와 목표지점 사이의 y축상 거리
                            // Direction : 회전 방향
                            ComiLib.SSCNET3.SafeNativeMethods.IxArcPStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;

                        // 3-Point Interpolation
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //IxSetSpeedPattern - Master
                            //IxArc3PStart
                            //IxWateDone

                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;


                            // 원호보간 상대좌표 이송(시작위치와 두 지점의 좌표를 사용)
                            // Board ID : 0, MapIndex
                            // P2[] : 두번째 좌표
                            // P3[] : 세번째 좌표
                            // EndAngle : 시작 위치에서 원하는 위치까지의 각도
                            fAngEndDeg = Convert.ToDouble(this.txtAngleFor3P.Text);
                            ComiLib.SSCNET3.SafeNativeMethods.IxArc3PStart(0, IX_MAP_IDX, P2, P3, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
                else
                {   // 1: Vector Speed Mode
                    switch (m_nArcMotionMode)
                    {
                        // Arc-Angle Interpolation
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //IxSetSpeedPattern - Vector
                            //IxArcAStart
                            //IxWateDone

                            // 원호보간 상대좌표 이송(중심좌표와 원호의 각도 사용)
                            // Board ID : 0, MapIndex
                            // XCentOffset : 시작위치로부터 원의 중심까지 x축 상대좌표값
                            // YCentOffset : 시작위치로부터 원의 중심까지 Y축 상대좌표값
                            // EndAngle : 중심좌표를 기준으로 시작위치와 목표지점 사이의 각도값 지정  
                            fAngEndDeg = Convert.ToDouble(this.txtAngEndDeg.Text);
                            ComiLib.SSCNET3.SafeNativeMethods.IxArcAStart(0, IX_MAP_IDX, fAngCenAxisX, fAngCenAxisY, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;

                        // Arc-Point Interpolation
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //IxSetSpeedPattern - Vector
                            //IxArcPStart
                            //IxWateDone

                            
                            // 원호보간 상대좌표 이송(중심좌표와 종점좌표 사용)
                            // Board ID : 0, MapIndex
                            // XCentOffset : 시작위치로부터 원의 중심까지 x축상의 거리
                            // YCentOffset : 시작위치로부터 원의 중심까지 Y축상의 거리
                            // XEndPointDist : 시작위치와 목표지점 사이의 x축상 거리
                            // YEndPointDist : 시작위치와 목표지점 사이의 y축상 거리
                            // Direction : 회전 방향
                            ComiLib.SSCNET3.SafeNativeMethods.IxArcPStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;

                        // 3-Point Interpolation
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            // 원호보간 상대좌표 이송(시작위치와 두 지점의 좌표를 사용)
                            // Board ID : 0, MapIndex
                            // P2[] : 두번째 좌표
                            // P3[] : 세번째 좌표
                            // EndAngle : 시작 위치에서 원하는 위치까지의 각도
                            fAngEndDeg = Convert.ToDouble(this.txtAngleFor3P.Text);
                            ComiLib.SSCNET3.SafeNativeMethods.IxArc3PStart(0, IX_MAP_IDX, P2, P3, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
            }

            // 1: Relative Move
            else
            {   
                // Speed Mode 를 확인
                // 0: Master Speed Mode
                if (nSpeedMode == 0) 
                {
                    switch (m_nArcMotionMode)
                    {

                        // Arc-Angle Interpolation
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //IxSetSpeedPattern - Master
                            //IxArcAStart
                            //IxWateDone
                            
                            fAngEndDeg = Convert.ToDouble(this.txtAngEndDeg.Text);
                            ComiLib.SSCNET3.SafeNativeMethods.IxArcAToStart(0, IX_MAP_IDX, fAngCenAxisX, fAngCenAxisY, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;

                        // Arc-Point Interpolation
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //IxSetSpeedPattern - Master
                            //IxArcPStart
                            //IxWateDone

                            ComiLib.SSCNET3.SafeNativeMethods.IxArcPToStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;

                        // 3-Point Interpolation
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //IxSetSpeedPattern - Master
                            //IxArc3PStart
                            //IxWateDone
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            fAngEndDeg = Convert.ToDouble(this.txtAngleFor3P.Text);
                            ComiLib.SSCNET3.SafeNativeMethods.IxArc3PToStart(0, IX_MAP_IDX, P2, P3, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }  

                // 1: Vector Speed Mode
                else
                {  
                    switch (m_nArcMotionMode)
                    { 
                        // Arc-Angle Interpolation
                        case (int)ARC_MODE.ARC_ANGLE:

                            //Relative - Master - Arc_Angle
                            //IxSetSpeedPattern - Vector
                            //IxArcAStart
                            //IxWateDone


                            // 원호보간 상대좌표 이송(중심좌표와 원호의 각도 사용)
                            // Board ID : 0, MapIndex
                            // XCentOffset : 시작위치로부터 원의 중심까지 x축 상대좌표값
                            // YCentOffset : 시작위치로부터 원의 중심까지 Y축 상대좌표값
                            // EndAngle : 중심좌표를 기준으로 시작위치와 목표지점 사이의 각도값 지정  
                            ComiLib.SSCNET3.SafeNativeMethods.IxArcAToStart(0, IX_MAP_IDX, fAngCenAxisX, fAngCenAxisY, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;

                        // Arc-Point Interpolation
                        case (int)ARC_MODE.ARC_POINT:

                            //Relative - Master - Arc_Point
                            //IxSetSpeedPattern - Vector
                            //IxArcPStart
                            //IxWateDone


                            // 원호보간 상대좌표 이송(중심좌표와 종점좌표 사용)
                            // Board ID : 0, MapIndex
                            // XCentOffset : 시작위치로부터 원의 중심까지 x축상의 거리
                            // YCentOffset : 시작위치로부터 원의 중심까지 Y축상의 거리
                            // XEndPointDist : 시작위치와 목표지점 사이의 x축상 거리
                            // YEndPointDist : 시작위치와 목표지점 사이의 y축상 거리
                            // Direction : 회전 방향
                            ComiLib.SSCNET3.SafeNativeMethods.IxArcPToStart(0, IX_MAP_IDX, fPntCenAxisX, fPntCenAxisY, fPntEndAxisX, fPntEndAxisY, 1);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;

                        // 3-Point Interpolation    
                        case (int)ARC_MODE.ARC_3POINT:

                            //Relative - Master - 3_Point
                            //IxSetSpeedPattern - Vector
                            //IxArc3PStart
                            //IxWateDone
                            double[] P2 = new double[2];
                            double[] P3 = new double[2];

                            P2[0] = -f3PntP2AxisX;
                            P2[1] = -f3PntP2AxisY;

                            P3[0] = -f3PntP3AxisX;
                            P3[1] = -f3PntP3AxisY;

                            // 원호보간 상대좌표 이송(시작위치와 두 지점의 좌표를 사용)
                            // Board ID : 0, MapIndex
                            // P2[] : 두번째 좌표
                            // P3[] : 세번째 좌표
                            // EndAngle : 시작 위치에서 원하는 위치까지의 각도
                            fAngEndDeg = Convert.ToDouble(this.txtAngleFor3P.Text);
                            ComiLib.SSCNET3.SafeNativeMethods.IxArc3PToStart(0, IX_MAP_IDX, P2, P3, fAngEndDeg);
                            ComiLib.SSCNET3.SafeNativeMethods.IxWaitDone(0, IX_MAP_IDX, 0);
                            break;
                    }
                }
            }

            btnMoveN.Enabled = true;
            btnMoveP.Enabled = true;
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            if (ComiLib.SSCNET3.SafeNativeMethods.IxStop(0, IX_MAP_IDX, 1, 0) != 0)
            {
                MessageBox.Show("IxStop Error");
            }
        }

        private void btnStopEmg_Click(object sender, EventArgs e)
        {
            if (ComiLib.SSCNET3.SafeNativeMethods.IxStopEmg(0, IX_MAP_IDX) != 0)
            {
                MessageBox.Show("IxStopEmg Error");
            }
        }
    }
}
