﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using ComiLib.SSCNET3;

namespace TorqueMode
{
    public partial class TorqueMode : System.Windows.Forms.Form
    {
        private System.Windows.Forms.Label lblDevID;
        private System.Windows.Forms.Label lblAxis;
        private System.Windows.Forms.Label lblTorqLimit;
        private System.Windows.Forms.Label lblVelocity;
        private System.Windows.Forms.Label lblTorqMoveP;
        private System.Windows.Forms.Label lblTorqMoveN;

        private System.Windows.Forms.ComboBox cmbDeviceID;
        private System.Windows.Forms.ComboBox cmbAxisList;
        private System.Windows.Forms.GroupBox gbxTorqModeSet;
        private System.Windows.Forms.Button btnPlus;
        private System.Windows.Forms.Button btnMinus;
        private System.Windows.Forms.Button btnStop;
        private System.Windows.Forms.Button btnServoOn;
        private System.Windows.Forms.Button btnServoOff;
        private System.Windows.Forms.TextBox txtTorq;
        private System.Windows.Forms.TextBox txtVel;
        
        private System.Windows.Forms.Timer timer1;
        
        private System.ComponentModel.IContainer components;
        private Label lblTorque;
        private TextBox txtTorque;
        private GroupBox gbxPosMon;

        int err_chk = 0;
        
        public TorqueMode()
        {
            InitializeComponent();
        }

        protected override void Dispose( bool disposing )
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            this.lblAxis = new System.Windows.Forms.Label();
            this.cmbAxisList = new System.Windows.Forms.ComboBox();
            this.cmbDeviceID = new System.Windows.Forms.ComboBox();
            this.btnServoOn = new System.Windows.Forms.Button();
            this.lblDevID = new System.Windows.Forms.Label();
            this.gbxTorqModeSet = new System.Windows.Forms.GroupBox();
            this.btnPlus = new System.Windows.Forms.Button();
            this.txtVel = new System.Windows.Forms.TextBox();
            this.txtTorq = new System.Windows.Forms.TextBox();
            this.btnStop = new System.Windows.Forms.Button();
            this.lblVelocity = new System.Windows.Forms.Label();
            this.btnMinus = new System.Windows.Forms.Button();
            this.lblTorqMoveP = new System.Windows.Forms.Label();
            this.lblTorqMoveN = new System.Windows.Forms.Label();
            this.lblTorqLimit = new System.Windows.Forms.Label();
            this.timer1 = new System.Windows.Forms.Timer(this.components);
            this.btnServoOff = new System.Windows.Forms.Button();
            this.lblTorque = new System.Windows.Forms.Label();
            this.txtTorque = new System.Windows.Forms.TextBox();
            this.gbxPosMon = new System.Windows.Forms.GroupBox();
            this.gbxTorqModeSet.SuspendLayout();
            this.gbxPosMon.SuspendLayout();
            this.SuspendLayout();
            // 
            // lblAxis
            // 
            this.lblAxis.AutoSize = true;
            this.lblAxis.Location = new System.Drawing.Point(218, 27);
            this.lblAxis.Name = "lblAxis";
            this.lblAxis.Size = new System.Drawing.Size(30, 12);
            this.lblAxis.TabIndex = 0;
            this.lblAxis.Text = "Axis";
            // 
            // cmbAxisList
            // 
            this.cmbAxisList.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cmbAxisList.Location = new System.Drawing.Point(254, 23);
            this.cmbAxisList.Name = "cmbAxisList";
            this.cmbAxisList.Size = new System.Drawing.Size(121, 20);
            this.cmbAxisList.TabIndex = 1;
            // 
            // cmbDeviceID
            // 
            this.cmbDeviceID.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cmbDeviceID.Location = new System.Drawing.Point(83, 22);
            this.cmbDeviceID.Name = "cmbDeviceID";
            this.cmbDeviceID.Size = new System.Drawing.Size(121, 20);
            this.cmbDeviceID.TabIndex = 1;
            // 
            // btnServoOn
            // 
            this.btnServoOn.Location = new System.Drawing.Point(385, 12);
            this.btnServoOn.Name = "btnServoOn";
            this.btnServoOn.Size = new System.Drawing.Size(80, 26);
            this.btnServoOn.TabIndex = 6;
            this.btnServoOn.Text = "Servo On";
            this.btnServoOn.Click += new System.EventHandler(this.btnServoOn_Click);
            // 
            // lblDevID
            // 
            this.lblDevID.AutoSize = true;
            this.lblDevID.Location = new System.Drawing.Point(19, 26);
            this.lblDevID.Name = "lblDevID";
            this.lblDevID.Size = new System.Drawing.Size(58, 12);
            this.lblDevID.TabIndex = 0;
            this.lblDevID.Text = "Device ID";
            // 
            // gbxTorqModeSet
            // 
            this.gbxTorqModeSet.Controls.Add(this.btnPlus);
            this.gbxTorqModeSet.Controls.Add(this.txtVel);
            this.gbxTorqModeSet.Controls.Add(this.txtTorq);
            this.gbxTorqModeSet.Controls.Add(this.btnStop);
            this.gbxTorqModeSet.Controls.Add(this.lblVelocity);
            this.gbxTorqModeSet.Controls.Add(this.btnMinus);
            this.gbxTorqModeSet.Controls.Add(this.lblTorqMoveP);
            this.gbxTorqModeSet.Controls.Add(this.lblTorqMoveN);
            this.gbxTorqModeSet.Controls.Add(this.lblTorqLimit);
            this.gbxTorqModeSet.Location = new System.Drawing.Point(7, 134);
            this.gbxTorqModeSet.Name = "gbxTorqModeSet";
            this.gbxTorqModeSet.Size = new System.Drawing.Size(471, 202);
            this.gbxTorqModeSet.TabIndex = 3;
            this.gbxTorqModeSet.TabStop = false;
            this.gbxTorqModeSet.Text = "Torque Mode Settings";
            // 
            // btnPlus
            // 
            this.btnPlus.Location = new System.Drawing.Point(289, 92);
            this.btnPlus.Name = "btnPlus";
            this.btnPlus.Size = new System.Drawing.Size(176, 56);
            this.btnPlus.TabIndex = 7;
            this.btnPlus.Text = "Move (+)";
            this.btnPlus.Click += new System.EventHandler(this.btnPlus_Click);
            // 
            // txtVel
            // 
            this.txtVel.Location = new System.Drawing.Point(228, 48);
            this.txtVel.Name = "txtVel";
            this.txtVel.Size = new System.Drawing.Size(85, 21);
            this.txtVel.TabIndex = 7;
            this.txtVel.Text = "1000";
            // 
            // txtTorq
            // 
            this.txtTorq.Location = new System.Drawing.Point(137, 48);
            this.txtTorq.Name = "txtTorq";
            this.txtTorq.Size = new System.Drawing.Size(85, 21);
            this.txtTorq.TabIndex = 7;
            this.txtTorq.Text = "1000";
            // 
            // btnStop
            // 
            this.btnStop.Location = new System.Drawing.Point(192, 92);
            this.btnStop.Name = "btnStop";
            this.btnStop.Size = new System.Drawing.Size(85, 56);
            this.btnStop.TabIndex = 6;
            this.btnStop.Text = "Stop";
            this.btnStop.Click += new System.EventHandler(this.btnStop_Click);
            // 
            // lblVelocity
            // 
            this.lblVelocity.AutoSize = true;
            this.lblVelocity.Location = new System.Drawing.Point(226, 33);
            this.lblVelocity.Name = "lblVelocity";
            this.lblVelocity.Size = new System.Drawing.Size(50, 12);
            this.lblVelocity.TabIndex = 4;
            this.lblVelocity.Text = "Velocity";
            // 
            // btnMinus
            // 
            this.btnMinus.Location = new System.Drawing.Point(1, 92);
            this.btnMinus.Name = "btnMinus";
            this.btnMinus.Size = new System.Drawing.Size(176, 56);
            this.btnMinus.TabIndex = 5;
            this.btnMinus.Text = "Move (-)";
            this.btnMinus.Click += new System.EventHandler(this.btnMinus_Click);
            // 
            // lblTorqMoveP
            // 
            this.lblTorqMoveP.AutoSize = true;
            this.lblTorqMoveP.Location = new System.Drawing.Point(327, 77);
            this.lblTorqMoveP.Name = "lblTorqMoveP";
            this.lblTorqMoveP.Size = new System.Drawing.Size(88, 12);
            this.lblTorqMoveP.TabIndex = 6;
            this.lblTorqMoveP.Text = "TorqueLimit(+)";
            // 
            // lblTorqMoveN
            // 
            this.lblTorqMoveN.AutoSize = true;
            this.lblTorqMoveN.Location = new System.Drawing.Point(44, 77);
            this.lblTorqMoveN.Name = "lblTorqMoveN";
            this.lblTorqMoveN.Size = new System.Drawing.Size(88, 12);
            this.lblTorqMoveN.TabIndex = 4;
            this.lblTorqMoveN.Text = "TorqueLimit(-)";
            // 
            // lblTorqLimit
            // 
            this.lblTorqLimit.AutoSize = true;
            this.lblTorqLimit.Location = new System.Drawing.Point(135, 33);
            this.lblTorqLimit.Name = "lblTorqLimit";
            this.lblTorqLimit.Size = new System.Drawing.Size(72, 12);
            this.lblTorqLimit.TabIndex = 4;
            this.lblTorqLimit.Text = "TorqueLimit";
            // 
            // timer1
            // 
            this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
            // 
            // btnServoOff
            // 
            this.btnServoOff.Location = new System.Drawing.Point(385, 44);
            this.btnServoOff.Name = "btnServoOff";
            this.btnServoOff.Size = new System.Drawing.Size(80, 26);
            this.btnServoOff.TabIndex = 6;
            this.btnServoOff.Text = "Servo Off";
            this.btnServoOff.Click += new System.EventHandler(this.btnServoOff_Click);
            // 
            // lblTorque
            // 
            this.lblTorque.AutoSize = true;
            this.lblTorque.Location = new System.Drawing.Point(8, 28);
            this.lblTorque.Name = "lblTorque";
            this.lblTorque.Size = new System.Drawing.Size(53, 12);
            this.lblTorque.TabIndex = 0;
            this.lblTorque.Text = "Torque :";
            // 
            // txtTorque
            // 
            this.txtTorque.Location = new System.Drawing.Point(137, 25);
            this.txtTorque.Name = "txtTorque";
            this.txtTorque.ReadOnly = true;
            this.txtTorque.Size = new System.Drawing.Size(111, 21);
            this.txtTorque.TabIndex = 7;
            // 
            // gbxPosMon
            // 
            this.gbxPosMon.Controls.Add(this.txtTorque);
            this.gbxPosMon.Controls.Add(this.lblTorque);
            this.gbxPosMon.Location = new System.Drawing.Point(11, 69);
            this.gbxPosMon.Name = "gbxPosMon";
            this.gbxPosMon.Size = new System.Drawing.Size(467, 59);
            this.gbxPosMon.TabIndex = 7;
            this.gbxPosMon.TabStop = false;
            this.gbxPosMon.Text = "Torque Monitor";
            // 
            // TorqueMode
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(6, 14);
            this.ClientSize = new System.Drawing.Size(490, 299);
            this.Controls.Add(this.gbxTorqModeSet);
            this.Controls.Add(this.cmbDeviceID);
            this.Controls.Add(this.cmbAxisList);
            this.Controls.Add(this.gbxPosMon);
            this.Controls.Add(this.btnServoOff);
            this.Controls.Add(this.btnServoOn);
            this.Controls.Add(this.lblDevID);
            this.Controls.Add(this.lblAxis);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
            this.MaximizeBox = false;
            this.Name = "TorqueMode";
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            this.Text = "Torque Mode";
            this.Closing += new System.ComponentModel.CancelEventHandler(this.TorqueMode_Closing);
            this.Load += new System.EventHandler(this.TorqueMode_Load);
            this.gbxTorqModeSet.ResumeLayout(false);
            this.gbxTorqModeSet.PerformLayout();
            this.gbxPosMon.ResumeLayout(false);
            this.gbxPosMon.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        


        ////////////////////////////////////////////////////////////////////////////////////////
        //Form 처음 불러올 때 설정
        private void TorqueMode_Load(object sender, EventArgs e)
        {
            // Load Motion & DIO devices //
            int NumDevice = new int();
            int BoradID = new int();
            int nNumAxes = new int();

            err_chk = ComiLib.SSCNET3.SafeNativeMethods.GnLoadDevice(ref NumDevice, ref BoradID, ref nNumAxes);
            if (err_chk != 0)
            {
                MessageBox.Show("Can't load device : " + err_chk);
                return;
            }
            else
            {
                ////////////////////////////////////////////////////////////////////////////////
                // 로드된 축수가 올바른지 체크: 본 예제에서는 원하는 축 수를 모르기 때문에 
                // 주석처리 해놓았습니다.

                //const int NUM_AXES_TO_LOAD = 4; // 이 값을 시스템에서 필요한 축 수에 맞게 조정 
                //if(anNumAxes[0] < NUM_AXES_TO_LOAD){
                // MessageBox.Show("현재 장착되어 있는 모션 축 수가 정의된 축 수와 일치하지 않습니다", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                //}                            

                ////////////////////////////////////////////////////////////////////////////////////
                // DeviceID 설정 콤보박스에 ID를 채워넣습니다. 
                string szTitle;

                for (int i = 0; i < 5; i++)
                {
                    szTitle = "";
                    szTitle = Convert.ToString(i);


                    cmbDeviceID.Items.Add(szTitle);
                }

                if (cmbDeviceID.Items.Count > 0)
                    cmbDeviceID.SelectedIndex = 0;

                ////////////////////////////////////////////////////////////////////////////////////
                // 축설정 콤보박스에 축리스트를 채워넣습니다.
                //byte[] aszAxisTitle = new byte[30];
                for (int i = 0; i < 16; i++)
                {
                    szTitle = "";
                    szTitle = Convert.ToString(i);


                    cmbAxisList.Items.Add(szTitle);
                }

                if (cmbAxisList.Items.Count > 0)
                    cmbAxisList.SelectedIndex = 0;
               
                // Set timer to display current command position //
                this.timer1.Start();
            }
        }

        //Form 종료할 때
        private void TorqueMode_Closing(object sender, EventArgs e)
        {
            // 사용중인 타이머 종료.
            timer1.Stop();

            // 동작중인 모든 서보를  off 합니다.
            for(int i=0; i< 5; i++){
                for (int j = 0; j < 16; j++)
                {
                    //본 예제에서는 Servo Off 또는 프로그램 종료시 서보 제어모드를 기본값(위치 제어 모드)으로 변경합니다.
                    ComiLib.SSCNET3.SafeNativeMethods.GnSetControlMode(i,j,0);
                    //토크모드 토크제한값을 0으로 초기화합니다.
                    ComiLib.SSCNET3.SafeNativeMethods.StSetTorque(i, j, 0);
                    //서보를 Off 합니다.
                    ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(i, j, 0);
                }
            }
            // 디바이스 unload
            ComiLib.SSCNET3.SafeNativeMethods.GnUnloadDevice(); // Unload Device
        }

        /***********************************************************************
        * TIMER event handler
        * : Read current command & feedback position and display it
        ***********************************************************************/
        private void timer1_Tick(object sender, System.EventArgs e)
        {
            //------- 모션제어기 부하 모니터링 -------------------------------//
            int nSelID = this.cmbDeviceID.SelectedIndex;
            int nSelAxis = this.cmbAxisList.SelectedIndex;
            string sTorque;
            int nTorque = 0;

            //현재 모터의 토크값을 반환합니다.
            ComiLib.SSCNET3.SafeNativeMethods.StGetTorque(nSelID, nSelAxis, ref nTorque);
            sTorque = nTorque.ToString();
            this.txtTorque.Text = sTorque;
           
        }

      //Stop Button
        private void btnStop_Click(object sender, System.EventArgs e)
        {
            this.btnPlus.Enabled = true;
            this.btnMinus.Enabled = true;

            int nSelID = this.cmbDeviceID.SelectedIndex;
            int nSelAxis = this.cmbAxisList.SelectedIndex;

            //토크모드의 토크 제한값을 0으로 설정해 정지합니다.
            err_chk = ComiLib.SSCNET3.SafeNativeMethods.StSetTorque(nSelID,nSelAxis, 0);
            if (err_chk != 0)
            {
                MessageBox.Show("StSetTorque Error : " + err_chk);
            }

        }

        //Servo On
        private void btnServoOn_Click(object sender, EventArgs e){

            int nSelID = this.cmbDeviceID.SelectedIndex;
            int nSelAxis = this.cmbAxisList.SelectedIndex;

            ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(nSelID, nSelAxis, 1);
            //토크 제어모드로 변경합니다.
            //GnSetControlMode(int BoardId, int Axis, int ControlMode)
            //  ControlMode 파라미터
            // 0: Position control Mode
            // 1: Velocity control Mode
            // 2: Torque control Mode
            ComiLib.SSCNET3.SafeNativeMethods.GnSetControlMode(nSelID,nSelAxis,2);
        }

        //Servo Off
        private void btnServoOff_Click(object sender, EventArgs e){

            int nSelID = this.cmbDeviceID.SelectedIndex;
            int nSelAxis = this.cmbAxisList.SelectedIndex;

            //본 예제에서는 Servo Off 또는 프로그램 종료시 서보 제어모드를 기본값(위치 제어 모드)으로 변경합니다.
            ComiLib.SSCNET3.SafeNativeMethods.GnSetControlMode(nSelID,nSelAxis,0);
            ComiLib.SSCNET3.SafeNativeMethods.StSetTorque(nSelID,nSelAxis,0);
            ComiLib.SSCNET3.SafeNativeMethods.GnSetServoOn(nSelID, nSelAxis, 0);

        }

        private void btnPlus_Click(object sender, EventArgs e)
        {          
            int nSelID = this.cmbDeviceID.SelectedIndex;
            int nSelAxis = this.cmbAxisList.SelectedIndex;
            int TorqLimit = Convert.ToInt32(this.txtTorq.Text);
            int Vel = Convert.ToInt32(this.txtVel.Text);
            this.btnStop.Enabled = true;

            //토크모드의 속도를 설정합니다.
            ComiLib.SSCNET3.SafeNativeMethods.StSetTorqueVelLimit(nSelID,nSelAxis,Vel);
            //토크 제한값을 설정합니다. 이 함수가 실행되면 모터가 바로 동작합니다.
            //StSetTorque(int BoardId, int Axis, int Torque)
            // Torque 파라미터
            // 기본 단위 : 0.1%, 
            // 최대 설정값 : 1000 (100%)
            err_chk = ComiLib.SSCNET3.SafeNativeMethods.StSetTorque(nSelID, nSelAxis, TorqLimit);
            if(err_chk != 0){
                MessageBox.Show("StSetTorqueVelLimit Error : " + err_chk);
            }
            
            
        }

        private void btnMinus_Click(object sender, EventArgs e)
        {
            int nSelID = this.cmbDeviceID.SelectedIndex;
            int nSelAxis = this.cmbAxisList.SelectedIndex;
            int TorqLimit = Convert.ToInt32(this.txtTorq.Text);
            int Vel = Convert.ToInt32(this.txtVel.Text);
            //토크모드의 속도를 설정합니다.
            ComiLib.SSCNET3.SafeNativeMethods.StSetTorqueVelLimit(nSelID, nSelAxis, Vel);
            //토크 제한값을 설정합나다. 이 함수가 실행되면 모터가 바로 동작합니다.
            err_chk = ComiLib.SSCNET3.SafeNativeMethods.StSetTorque(nSelID,nSelAxis,-TorqLimit);
            if (err_chk != 0)
            {
                MessageBox.Show("StSetTorqueVelLimit Error : " + err_chk);
            }
        }     
    }
}
