﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Collections;

using SSCNET3 = ComiLib.SSCNET3.SafeNativeMethods;
using SSCNET3_DEFINE = ComiLib.NEMO_Def.SafeNativeMethods;

namespace ListMotion
{
    public partial class ListMotion : System.Windows.Forms.Form
    {
        public enum enum_LM_StartMode
        {
            START_IMMEDIATELY, //예약과 함께 바로 이송을 시작합니다
            WAIT_RESUME_CMD // Resume 명령이 들어올 때까지 이송을 대기합니다.
        };

        public enum enum_LM_SuspendMode
        {
            STOP_IMMEDIATELY, //즉시 리스트모션을 일시 정지합니다.
            FINISH_CUR_CMD // 현재 실행중인 리스트모션 동작을 끝내고 일시 정지합니다.
        };

        public enum enum_LM_ResumeMode
        {
            Normal_Mode, //리스트모션을 다시 재개합니다.
            Reserved
        };

        int ErrorCode = 0;
        int BoardID = 0;

        const int LM_MapIndex = 1;

        const double WorkSpeed = 1000; // 1000 Pulse / Sec
        const double Accel = WorkSpeed; // 1000 Pulse / Sec^2
        const double Decel = WorkSpeed;
        const double Init_Speed = 0;
        const double End_Speed = 0;

        const double Move_Distance = 1000; // 1000 Pulse

        private void InitSSCNET3H()
        {
            int temp_BoardID = 0;
            int temp_NumDevices = 0;
            int temp_NumServos = 0; //Loaddevice시 리턴되는 값을 받아오는 임시 변수

            ErrorCode = SSCNET3.GnLoadDevice(ref temp_NumDevices, ref temp_BoardID, ref temp_NumServos);

            if (ErrorCode != (int)SSCNET3_DEFINE.ERROR_CODES.ERR_NONE)
            {
                MessageBox.Show("Device Load Fail - " + ErrorCode.ToString());
            }
        }

        private void endSSCNET3H()
        {
            SSCNET3.GnUnloadDevice();
        }

        private List<int> Get_Available_AxisList()
        {
            List<int> AxisList = new List<int>();

            int AxisMapMask = 0;

            ErrorCode = SSCNET3.GnGetAxisMap(BoardID, ref AxisMapMask); //현재 인식된 Axis의 map을 받아와서

            for (var AxisIndex = 0; AxisIndex < 32; AxisIndex++)
            {
                if (((1 << AxisIndex) & AxisMapMask) != 0) //Axismap에 현재 AxisIndex가 있는 경우
                {
                    AxisList.Add(AxisIndex); //AxisList에 현재 Axis를 추가
                }
            }

            return AxisList;
        }

        public string Motstate_toString(int motstate) //Mot State 값을 받아 String으로 변환
        {
            string Return_Value;

            switch (motstate)
            {
                case ((int)SSCNET3_DEFINE.MotorState.STOP): Return_Value = "STOP"; break;
                case ((int)SSCNET3_DEFINE.MotorState.INVALID): Return_Value = "INVALID"; break;
                case ((int)SSCNET3_DEFINE.MotorState.ACCEL): Return_Value = "ACCEL"; break;
                case ((int)SSCNET3_DEFINE.MotorState.DECEL): Return_Value = "DECEL"; break;
                case ((int)SSCNET3_DEFINE.MotorState.INIT_SPEED): Return_Value = "INIT_SPEED"; break;
                case ((int)SSCNET3_DEFINE.MotorState.IN_WAIT): Return_Value = "IN_WAIT"; break;
                case ((int)SSCNET3_DEFINE.MotorState.SLAVE_MODE): Return_Value = "SLAVE_MODE"; break;
                case ((int)SSCNET3_DEFINE.MotorState.WORK_SPEED): Return_Value = "WORK_SPEED"; break;
                default: Return_Value = motstate.ToString(); break;
            }
            return Return_Value;
        }
        
        public void ServoOn_All()
        {
            List<int> AxisList = Get_Available_AxisList();

            foreach (var Axis in AxisList)
            {
                SSCNET3.GnSetServoOn(BoardID, Axis, (int)SSCNET3_DEFINE.SWITCH.ON);
            }
        }

        private void UI_Init_BoardID()
        {
            CB_BoardID.Items.Add("0");
            CB_BoardID.SelectedIndex = 0;
        }
        private void UI_Init_AxisList()
        {
            List<int> AxisList = Get_Available_AxisList();

            foreach (var Axis in AxisList)
            {
                CB_Axis.Items.Add(Axis.ToString());
            }
            CB_Axis.SelectedIndex = 0;
        }

        private void UI_Refresh_AxisStatus()
        {
            int CurrentAxis = Convert.ToInt32(CB_Axis.SelectedItem.ToString());

            double CMD_Pos = 0; 
            double FB_Pos = 0; 
            double CMD_SPD = 0;
            double FB_SPD = 0;
            int MotState = 0; //현재 Axis의 동작 상태
            int isLM_Busy = 0; //ListMotion이 동작중인지 표시
            int Current_LMIndex = 0; // 현재 Listmotion이 몇번째 동작인지 표시

            SSCNET3.StGetPosition(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.PmCntr.PM_CNT_COMM, ref CMD_Pos);
            SSCNET3.StGetPosition(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.PmCntr.PM_CNT_FEED, ref FB_Pos);

            SSCNET3.StGetSpeed(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.PmCntr.PM_CNT_COMM, ref CMD_SPD);
            SSCNET3.StGetSpeed(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.PmCntr.PM_CNT_FEED, ref FB_SPD);

            SSCNET3.StSxReadMotionState(BoardID, CurrentAxis, ref MotState);
            SSCNET3.LmxGetStates(BoardID, LM_MapIndex, (int)SSCNET3_DEFINE.LmStsId.BUSY, ref isLM_Busy);
            SSCNET3.LmxGetStates(BoardID, LM_MapIndex, (int)SSCNET3_DEFINE.LmStsId.RUN_TEM_SEQ_ID, ref Current_LMIndex);

            LB_CmdPos.Text = CMD_Pos.ToString();
            LB_FBPos.Text = FB_Pos.ToString();
            LB_CmdSpd.Text = CMD_SPD.ToString();
            LB_FBSpd.Text = FB_SPD.ToString();
            LB_MotorState.Text = Motstate_toString(MotState);
            LB_LMIndex.Text = Current_LMIndex.ToString();
            LB_LMStatus.Text = isLM_Busy == 1 ? "Busy" : "Not Busy";
        }

        private void UI_Init_All()
        {
            UI_Init_BoardID();
            UI_Init_AxisList();
            UI_Refresh_AxisStatus();
            Timer_AxisStatus_Refresh.Enabled = true;
        }

        private void Timer_AxisStatus_Tick(object sender, EventArgs e)
        {
            UI_Refresh_AxisStatus();
        }

        public ListMotion()
        {
            InitializeComponent();

            InitSSCNET3H();
            UI_Init_All();

            ServoOn_All();
        }

        private void ListMotion_FormClosed(object sender, FormClosedEventArgs e)
        {
            endSSCNET3H();
        }





        private void BT_CMD_StartLM_Click(object sender, EventArgs e)
        {
            int CurrentAxis = Convert.ToInt32(CB_Axis.SelectedItem.ToString());

            int LMAxisMap = 1 << CurrentAxis;

            MessageBox.Show(LMAxisMap.ToString());

            SSCNET3.LmxStart(BoardID, LM_MapIndex, (int)enum_LM_StartMode.START_IMMEDIATELY, LMAxisMap);
            SSCNET3.LmxSetSeqMode(BoardID, LM_MapIndex, (int)SSCNET3_DEFINE.PmSeqMode.PM_SEQM_WAIT_RUN);
        }

        private void BT_CMD_SuspendLM_Click(object sender, EventArgs e)
        {
            SSCNET3.LmxSuspend(BoardID, LM_MapIndex, (int)enum_LM_SuspendMode.STOP_IMMEDIATELY);
        }

        private void BT_CMD_ResumeLM_Click(object sender, EventArgs e)
        {
            SSCNET3.LmxResume(BoardID, LM_MapIndex, (int)enum_LM_ResumeMode.Normal_Mode);
        }

        private void BT_CMD_EndLM_Click(object sender, EventArgs e)
        {
            SSCNET3.LmxEnd(BoardID, LM_MapIndex);
        }

        private void BT_SxMoveCMD1_Neg_Click(object sender, EventArgs e)
        {
            int CurrentAxis = Convert.ToInt32(CB_Axis.SelectedItem.ToString());

            SSCNET3.CfgSetSpeedPattern(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.SpeedMode.SCURVE, WorkSpeed, Accel, Decel, Init_Speed, End_Speed);
            SSCNET3.SxMove(BoardID, CurrentAxis, -Move_Distance,0);
        }

        private void BT_SxMoveCMD1_Pos_Click(object sender, EventArgs e)
        {
            int CurrentAxis = Convert.ToInt32(CB_Axis.SelectedItem.ToString());

            SSCNET3.CfgSetSpeedPattern(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.SpeedMode.SCURVE, WorkSpeed, Accel, Decel, Init_Speed, End_Speed);  
            SSCNET3.SxMove(BoardID, CurrentAxis, Move_Distance, 0);
        }

        private void BT_SxMoveCMD2_Neg_Click(object sender, EventArgs e)
        {
            int CurrentAxis = Convert.ToInt32(CB_Axis.SelectedItem.ToString());

            SSCNET3.CfgSetSpeedPattern(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.SpeedMode.SCURVE, WorkSpeed * 2, Accel, Decel, Init_Speed, End_Speed);
            SSCNET3.SxMove(BoardID, CurrentAxis, -(Move_Distance * 2), 0);
        }

        private void BT_SxMoveCMD2_Pos_Click(object sender, EventArgs e)
        {
            int CurrentAxis = Convert.ToInt32(CB_Axis.SelectedItem.ToString());

            SSCNET3.CfgSetSpeedPattern(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.SpeedMode.SCURVE, WorkSpeed * 2, Accel, Decel, Init_Speed, End_Speed);
            SSCNET3.SxMove(BoardID, CurrentAxis, (Move_Distance * 2), 0);
        }

        private void BT_SxMoveCMD3_Neg_Click(object sender, EventArgs e)
        {
            int CurrentAxis = Convert.ToInt32(CB_Axis.SelectedItem.ToString());

            SSCNET3.CfgSetSpeedPattern(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.SpeedMode.SCURVE, WorkSpeed * 3, Accel, Decel, Init_Speed, End_Speed);
            SSCNET3.SxMove(BoardID, CurrentAxis, -(Move_Distance * 3), 0);
        }

        private void BT_SxMoveCMD3_Pos_Click(object sender, EventArgs e)
        {
            int CurrentAxis = Convert.ToInt32(CB_Axis.SelectedItem.ToString());

            SSCNET3.CfgSetSpeedPattern(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.SpeedMode.SCURVE, WorkSpeed * 3, Accel, Decel, Init_Speed, End_Speed);
            SSCNET3.SxMove(BoardID, CurrentAxis, (Move_Distance * 3), 0);
        }

        private void BT_SxMoveCMD4_Neg_Click(object sender, EventArgs e)
        {
            int CurrentAxis = Convert.ToInt32(CB_Axis.SelectedItem.ToString());

            SSCNET3.CfgSetSpeedPattern(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.SpeedMode.SCURVE, WorkSpeed * 4, Accel, Decel, Init_Speed, End_Speed);
            SSCNET3.SxMove(BoardID, CurrentAxis, -(Move_Distance * 4), 0);
        }

        private void BT_SxMoveCMD4_Pos_Click(object sender, EventArgs e)
        {
            int CurrentAxis = Convert.ToInt32(CB_Axis.SelectedItem.ToString());

            SSCNET3.CfgSetSpeedPattern(BoardID, CurrentAxis, (int)SSCNET3_DEFINE.SpeedMode.SCURVE, WorkSpeed * 4, Accel, Decel, Init_Speed, End_Speed);
            SSCNET3.SxMove(BoardID, CurrentAxis, (Move_Distance * 4), 0);
        }
    }
}
