using System;
using System.Runtime.InteropServices;

namespace ComiLib.DX
{
    [System.Security.SuppressUnmanagedCodeSecurity]
    public  unsafe class SafeNativeMethods
    {
        const int MAX_DEVICE_NUM = 10;
        const int MAX_INTERRUPT_COUNT = 10;
        public  enum DeviceID
        {
	        DX101 = 0xF101,
            DX201 = 0xF201,
            DX301 = 0xF301,
            DX501 = 0xF501,
        }
                
        //public  struct TDXComiDevInfo
        //{
        //    public  ushort wSubSysID;
        //    public  uint nInstance;

        //    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        //    public  char[] szDevName;
        //    public  byte bDevCaps;
        //    public  byte nNumAdChan, nNumDaChan, nNumDiChan, nNumDoChan, nNumCntrChan, nNumPlsgenChan;
        //}

        //public  struct TDxInterruptState
        //{
        //    public  uint nNumCount;
        //    [MarshalAs(UnmanagedType.ByValArray, SizeConst = MAX_INTERRUPT_COUNT)]
        //    public  ushort[] nIntrType;
        //    [MarshalAs(UnmanagedType.ByValArray, SizeConst = MAX_INTERRUPT_COUNT)]
        //    public  uint[] EventID;
        //}

        // ******************************************************************* //
        // Enum Define
        // ******************************************************************* //

        public  enum TDxLogType
        {
            dxDLOG_TRACE=0, /* Log Mode Trace */
	        dxDLOG_FILE=1   /* Log Mode File */
        }

        public  enum TDxLogLevel
        {
            dxDLOG_DISABLE=0,/* Log Mode Off */
	        dxDLOG_SET=1,     /* Set functions */
	        dxDLOG_GET=2,		/* Set functions + get functions */
	        dxDLOG_OUT=3,	/* Output Functions */
	        dxDLOG_ALL=4,    /* All Output + Input Functions */
        }

        public  enum TDxEdgeType
        {
            dxTE_POSITIVE=0,/* Positive edge */
	        dxTE_NEGATIVE=1, /* Negative edge */
	        dxTE_ALL
        }


        public  enum TDxBool
        {
            dxFALSE=0,
	        dxTRUE=1
        }


        public  enum TDxDir
        {
            dxDIR_P=0,/* (+) Direction */
	        dxDIR_N=1/* (-) Direction */
        }


        public  enum TDxInverse
        {
            dxINV_FALLING=0, /* Inverse Falling */
	        dxINV_RISING=1	 /* Inverse Rising */
        }


        public  enum TDxDioUsage
        {
            dxDI_ONLY=0,/* All channels are digital input                                                */
	        dxDI_DO=1,  /* The first half channels are input and the latter half channels are for output */
	        dxDO_DI=2,  /* The first half channels are output and the latter half channels are for input */
	        dxDO_ONLY=3 /* All channels are digital output                                               */
        }

        public  enum TDxAiInputMode
        {
            dxAI_SINGLE=0,/* AI Single mode*/
	        dxAI_DIFF=1,	  /* AI differential mode */
	        dxAI_REF=2,
	        dxAI_DA=3
        }

        public  enum TDxAiScanTrs
        {
            dxTRS_SINGLE=0, /* Single data transfer (low performance) */
	        dxTRS_BLOCK=1,  /* Block data transfer (high performance) */
        }

        public  enum TDxAiScanTriggerMode
        {
            dxTRG_S=0,     /* Trigger Source clock */
	        dxTRG_E=1,	   /* Trigger External clock */
	        dxTRG_E_SCAN=2 /* Trigger External scan */
        }

        public  enum TDxAiFilter
        {
            dxAIF_NONE=0,
	        dxAIF_AVG=1,/* M3 Moving Average */
	        dxAIF_LPF=2,/* M3 LowPass Filter */
	        dxAIF_TUSTIN_LPF=3/* M3 TUSTIN LowPass Filter */
        }

        public  enum TDxCntSourceMode
        {
            dxCMODE_DISABLE=0,/* Counter Mode Disable */
	        dxCMODE_SRC_SOFT0=1,/* Counter Mode Soft set Default Value */
	        dxCMODE_SRC_EXT0=2,/* Counter Mode External Trigger Signal set Default Value */
	        dxCMODE_SRC_SOFT1=3,/* Counter Mode Soft set Value 0 */
	        dxCMODE_SRC_EXT1=4/* Counter Mode External Trigger Signal set Value 0 */
        }

        public  enum TDxCntHold
        {
            dxCHOLD_LOW=0,/* Counter Hold Value 0 */
	        dxCHOLD_HIGH=1/* Counter Hold Value 1 */
        }

        public  enum TDxCntFilterClock
        {
            dxCFILTER_FREQ_NONE=0, // Frequency Disable
	        dxCFILTER_FREQ0=1, //  2.5 MHz
	        dxCFILTER_FREQ1=2, // 1.25 MHz
	        dxCFILTER_FREQ2=3, //  625 Khz
	        dxCFILTER_FREQ3=4 // 312.5 Khz
        }

        public  enum TDxCntEdge
        {
            dxCNT_FALLING=0,
	        dxCNT_RISING=1
        }

        public  enum TDxCntUpDown
        {
            dxCNT_UP=0,
	        dxCNT_DOWN=1
        }

        public  enum TDxCntSource
        {
            dxCNT_POARTA=0,
	        dxCNT_20MHZ=1
        }

        public  enum TDxCntSelectParameter
        {
            dxCSET_PARAM0=0,
	        dxCSET_PARAM1=1
        }

        public  enum TDxVoltRange
        {
            dxRANGE_V0=0, // 0~1v		// 0~5v
	        dxRANGE_V1=1, // 0~2v		// 0~10v
	        dxRANGE_V2=2, // 0~5v		// 0~10.8v
	        dxRANGE_V3=3, // 0~10v		// -5~5v
	        dxRANGE_V4=4, // -1~1v		// -10~10v
	        dxRANGE_V5=5,  // -2~2v		// -10.8v~10.8v
	        dxRANGE_V6=6, // -5~5v		//	none
	        dxRANGE_V7=7 // -10~10v	// none
        }

        public  enum TDxEcInMode
        {
            dxEC_x4AB=0,
	        dxEC_x2AB=1,
	        dxEC_x1AB=2,
	        dxEC_PLSDIR=3,
	        dxEC_CWCCW=4
        }

        public  enum TDxEcInverse
        {
            dxEC_INV_NONE=0, dxEC_INV_A=1, dxEC_INV_B=2, dxEC_INV_AB=3, dxEC_INV_Z=4, 
	        dxEC_INV_AZ=5, dxEC_INV_BZ=6, dxEC_INV_ABZ=7
        }

        public  enum TDxEcClock
        {
            dxEC_10M=0, /* 10M*3 Filter */
	        dxEC_5M=1   /* 5M*3 Filter */
        }
        public  enum TDxLTCmode
        {
            dxLTC_NONE=0,
	        dxLTC_R_EDGE=1, /* Rising Edge */
	        dxLTC_F_EDGE=2, /* Falling Edge */
	        dxLTC_BI_EDGE=3 /* both Risng & Falling Edge */
        }
        public  enum TDxCmpMode
        {
            dxCMP_REGULAR=0,
	        dxCMP_RANDOM=1
        }
        public  enum TDxIntHandlerType
        {
            dxIHT_MESSAGE=0, dxIHT_EVENT, dxIHT_CALLBACK
        }
        public  enum TDxIntDiMode
        {
            dxINT_DI_SINGLE=0,
	        dxINT_DI_MULTI=1,
	        dxINT_DI_MULTI_ONE=2
        }
        public  enum TDxIntUpDown
        {
            dxINT_UP=0,
	        dxINT_ON=0,
	        dxINT_DOWN=1,
	        dxINT_OFF=1,
	        dxINT_BI=2
        }


        //////////////////////////////////////////////////////////////////////////
        // Global Function

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_UnloadDll")]
        public static extern unsafe void DX_UnloadDll();
        
 
        [DllImport("ComiDXDll.dll", EntryPoint = "DX_GnLoadDevice", CallingConvention=CallingConvention.Cdecl)]
        public  static extern unsafe int DX_GnLoadDevice(
            [MarshalAs(UnmanagedType.I4)] ref int numDevs,
            ref IntPtr hDevList);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_GnIsDevLoaded")]
        public  static extern unsafe int DX_GnIsDevLoaded(
            [MarshalAs(UnmanagedType.I1)] ref bool IsLoaded);
        
        [DllImport("ComiDXDll.dll", EntryPoint = "DX_GnUnloadDevice")]
        public  static extern unsafe int DX_GnUnloadDevice();

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_GnGetDevInfo", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_GnGetDevInfo(
            IntPtr hDevice,
            ref Daq.DaqDevInfo pDevInfo);



        //////////////////////////////////////////////////////////////////////////
        // Advanced Functions

        //////////////////////////////////////////////////////////////////////////
        // DIO Functions

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DioSetUsage", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DioSetUsage(
            IntPtr hDevice /*HANDLE*/, 
            [MarshalAs(UnmanagedType.I4)] int Usage);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DioGetUsage", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DioGetUsage(
            IntPtr hDevice /*HANDLE*/, 
            [MarshalAs(UnmanagedType.I4)] ref int Usage);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DiGetOne", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DiGetOne
            (IntPtr hDevice /*HANDLE*/,
            [MarshalAs(UnmanagedType.I4)] int channel,
            [MarshalAs(UnmanagedType.I4)] ref int State);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DiGetAll", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DiGetAll(
            IntPtr hDevice /*HANDLE*/, 
            [MarshalAs(UnmanagedType.I4)] ref int States);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DoGetOne", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DoGetOne(
            IntPtr hDevice /*HANDLE*/, 
            [MarshalAs(UnmanagedType.I4)] int channel, 
            [MarshalAs(UnmanagedType.I4)] ref int State);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DoGetAll", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DoGetAll(
            IntPtr hDevice /*HANDLE*/, 
            [MarshalAs(UnmanagedType.I4)] ref int States);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DoPutOne", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DoPutOne(
            IntPtr hDevice /*HANDLE*/,
            [MarshalAs(UnmanagedType.I4)] int channel, 
            [MarshalAs(UnmanagedType.I4)] int State);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DoPutAll", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DoPutAll(
            IntPtr hDevice /*HANDLE*/, 
            [MarshalAs(UnmanagedType.I4)] int States);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DioGetOne", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DioGetOne(
            IntPtr hDevice /*HANDLE*/,
            [MarshalAs(UnmanagedType.I4)] int channel,
            [MarshalAs(UnmanagedType.I4)] ref int State);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DioGetAll", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DioGetAll(
            IntPtr hDevice /*HANDLE*/,
            [MarshalAs(UnmanagedType.I4)] ref int States);



        //////////////////////////////////////////////////////////////////////////
        // Analog Input Functions

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdSetInputType", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_AdSetInputType(
            IntPtr hDevice /*HANDLE*/, 
            [MarshalAs(UnmanagedType.I4)] int InputMode);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdGetInputType", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_AdGetInputType(
            IntPtr hDevice /*HANDLE*/, [MarshalAs(UnmanagedType.I4)] ref int InputMode);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdSetRange", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_AdSetRange(
            IntPtr hDevice /*HANDLE*/, 
            [MarshalAs(UnmanagedType.I4)] int Range);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdGetRange", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_AdGetRange(
            IntPtr hDevice /*HANDLE*/,
            [MarshalAs(UnmanagedType.I4)] ref int Range);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdGetDigit", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_AdGetDigit(
            IntPtr hDevice /*HANDLE*/, 
            [MarshalAs(UnmanagedType.I4)] int Channel, [MarshalAs(UnmanagedType.I4)] ref int Digit);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdGetVolt", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_AdGetVolt(
            IntPtr hDevice /*HANDLE*/, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] ref double Volt);



        //////////////////////////////////////////////////////////////////////////
        // AD Scan Functions

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanSetTriggerMode")]
        public  static extern unsafe int DX_AdScanSetTriggerMode(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int TrgMode,
            [MarshalAs(UnmanagedType.I4)] int Inverse);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanGetTriggerMode")]
        public  static extern unsafe int DX_AdScanGetTriggerMode(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] ref int TrgMode, 
            [MarshalAs(UnmanagedType.I4)] ref int Inverse);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanSetRange")]
        public  static extern unsafe int DX_AdScanSetRange(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Range);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanGetRange")]
        public  static extern unsafe int DX_AdScanGetRange(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] ref int Range);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanSetChannelList")]
        public  static extern unsafe int DX_AdScanSetChannelList(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int numChannel, 
            [MarshalAs(UnmanagedType.I4)] ref int[] pChanList);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanStart")]
        public  static extern unsafe int DX_AdScanStart(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int ScanFreq,
            [MarshalAs(UnmanagedType.I4)] int SampFreq,
            [MarshalAs(UnmanagedType.I4)] int nBufSize, 
            [MarshalAs(UnmanagedType.I4)] int nTrsMethod, 
            [MarshalAs(UnmanagedType.I4)] int IsPauseAtFull);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanFilterStart")]
        public  static extern unsafe int DX_AdScanFilterStart(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int ScanFreq,
            [MarshalAs(UnmanagedType.I4)] int SampFreq,
            [MarshalAs(UnmanagedType.I4)] int nBufSize);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanStop")]
        public  static extern unsafe int DX_AdScanStop(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int IsReleaseBuf);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanClear")]
        public  static extern unsafe int DX_AdScanClear(
            IntPtr hDevice);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanGetFreq")]
        public  static extern unsafe int DX_AdScanGetFreq(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] ref int ScanFreq,
            [MarshalAs(UnmanagedType.I4)] ref int SampFreq);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanChangeFreq")]
        public  static extern unsafe int DX_AdScanChangeFreq(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int ScanFreq,
            [MarshalAs(UnmanagedType.I4)] int SampFreq);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanGetCurCount")]
        public  static extern unsafe int DX_AdScanGetCurCount(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] ref int dwCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanIsBufFull")]
        public  static extern unsafe int DX_AdScanIsBufFull(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I1)] ref bool IsBufFull);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanResume")]
        public  static extern unsafe int DX_AdScanResume(
            IntPtr hDevice);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanRetrChannelI2")]
        public  static extern unsafe int DX_AdScanRetrChannelI2(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int ChannelOrder,
            [MarshalAs(UnmanagedType.I4)] int StartCount,
            [MarshalAs(UnmanagedType.I4)] int MaxNumData,
            [MarshalAs(UnmanagedType.I2)] ref short pDestBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int RetrivedDataCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanRetrChannelF4")]
        public  static extern unsafe int DX_AdScanRetrChannelI2(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int ChannelOrder,
            [MarshalAs(UnmanagedType.I4)] int StartCount, 
            [MarshalAs(UnmanagedType.I4)] int MaxNumData,
            [MarshalAs(UnmanagedType.R4)] ref float pDestBuf,
            [MarshalAs(UnmanagedType.I4)] ref int RetrivedDataCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanRetrChannelF8")]
        public  static extern unsafe int DX_AdScanRetrChannelI2(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int ChannelOrder,
            [MarshalAs(UnmanagedType.I4)] int StartCount,
            [MarshalAs(UnmanagedType.I4)] int MaxNumData,
            [MarshalAs(UnmanagedType.R8)] ref double pDestBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int RetrivedDataCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanRetrBlockI2")]
        public  static extern unsafe int DX_AdScanRetrBlockI2(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int StartCount,
            [MarshalAs(UnmanagedType.I4)] int MaxNumScan, 
            [MarshalAs(UnmanagedType.I2)] ref short pDestBuf,
            [MarshalAs(UnmanagedType.I4)] ref int RetrivedStartCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanRetrBlockF4")]
        public  static extern unsafe int DX_AdScanRetrBlockI2(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int StartCount,
            [MarshalAs(UnmanagedType.I4)] int MaxNumScan, 
            [MarshalAs(UnmanagedType.R4)] ref float pDestBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int RetrivedStartCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanRetrBlockF8")]
        public  static extern unsafe int DX_AdScanRetrBlockI2(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int StartCount,
            [MarshalAs(UnmanagedType.I4)] int MaxNumScan, 
            [MarshalAs(UnmanagedType.R8)] ref double pDestBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int RetrivedStartCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanFilterConfig")]
        public  static extern unsafe int DX_AdScanFilterConfig(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int FilterType,
            [MarshalAs(UnmanagedType.R8)] ref double CutOffFrequency, 
            [MarshalAs(UnmanagedType.I4)] int AvgCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanGetMinMax")]
        public  static extern unsafe int DX_AdScanGetMinMax(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int ChannelOrder,
            [MarshalAs(UnmanagedType.R8)] ref double MinVolt, 
            [MarshalAs(UnmanagedType.R8)] ref double MaxVolt);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_AdScanMinMaxClear")]
        public  static extern unsafe int DX_AdScanMinMaxClear(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int ChannelOrder);



        //////////////////////////////////////////////////////////////////////////
        // Analog Output Functions

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DaClear", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DaClear(
            IntPtr hDevice);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DaSetRange", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DaSetRange(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Range);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DaGetRange", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DaGetRange(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int Range);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_DaOut", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_DaOut(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] double OutVolt);


        
        //////////////////////////////////////////////////////////////////////////
        // Counter Functions

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntClear", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntClear(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntSetClearMode", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntSetClearMode(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int ClrMode);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntGetClearMode", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntGetClearMode(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int ClrMode);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntSetFilter", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntSetFilter(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Frequency);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntGetFilter", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntGetFilter(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int Frequency);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntSetConfig", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntSetConfig(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int Edge, 
            [MarshalAs(UnmanagedType.I4)] int UpDown, 
            [MarshalAs(UnmanagedType.I4)] int CntSrc);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntGetConfig", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntGetConfig(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int Edge,
            [MarshalAs(UnmanagedType.I4)] ref int UpDown, 
            [MarshalAs(UnmanagedType.I4)] ref int CntSrc);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntStart", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntStart(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntIsActive", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntIsActive(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int IsActive);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntStop", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntStop(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntSetDefault", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntSetDefault(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int Count);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntGetDefault", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntGetDefault(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int Count);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CntGetCount", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CntGetCount(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int Count);


        //////////////////////////////////////////////////////////////////////////
        // Pulse Generator Functions

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_PgSetConfig", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_PgSetConfig(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] double Frequency,
            [MarshalAs(UnmanagedType.I4)] int Duty,
            [MarshalAs(UnmanagedType.I4)] int Number);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_PgGetConfig", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_PgGetConfig(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] ref double Frequency,
            [MarshalAs(UnmanagedType.I4)] ref int Duty,
            [MarshalAs(UnmanagedType.I4)]ref  int Number);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_PgSetInverse", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_PgSetInverse(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int Inverse);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_PgGetInverse", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_PgGetInverse(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int Inverse);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_PgStart", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_PgStart(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_PgStop", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_PgStop(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_PgIsActive", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_PgIsActive(
            IntPtr hDevice,            
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int IsActive);



        //////////////////////////////////////////////////////////////////////////
        // LATCH

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_LtcSetMode", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_LtcSetMode(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int LtcMode);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_LtcGetMode", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_LtcGetMode(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int LtcMode);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_LtcStart", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_LtcStart(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_LtcStop", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_LtcStop(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_LtcIsActive", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_LtcIsActive(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int IsActive);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_LtcClear", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_LtcClear(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_LtcGetDataCount", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_LtcGetDataCount(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int DataCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_LtcReadOneLatch", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_LtcReadOneLatch(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int DataIdx, 
            [MarshalAs(UnmanagedType.I4)] ref int DataCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_LtcReadAllLatch", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_LtcReadAllLatch(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int StartCnt, 
            [MarshalAs(UnmanagedType.I4)] int DataCount, 
            [MarshalAs(UnmanagedType.I4)] ref int[] DataList);



        //////////////////////////////////////////////////////////////////////////
        // CMP

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CmpSetConfig", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CmpSetConfig(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int CmpMode,
            [MarshalAs(UnmanagedType.I4)] int CmpMethod, 
            [MarshalAs(UnmanagedType.I4)] int CmpInv, 
            [MarshalAs(UnmanagedType.I4)] int PlsWidth);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CmpGetConfig", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CmpGetConfig(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int CmpMode, 
            [MarshalAs(UnmanagedType.I4)] ref int CmpMethod,
            [MarshalAs(UnmanagedType.I4)] ref int CmpInv, 
            [MarshalAs(UnmanagedType.I4)] ref int PlsWidth);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CmpSetRegularData", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CmpSetRegularData(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int IniPos, 
            [MarshalAs(UnmanagedType.I4)] int Interval,
            [MarshalAs(UnmanagedType.I4)] int PlsCount, 
            [MarshalAs(UnmanagedType.I4)] int RepeatInterval,
            [MarshalAs(UnmanagedType.I4)] int RepeatCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CmpGetRegularData", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CmpGetRegularData(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int IniPos, 
            [MarshalAs(UnmanagedType.I4)] ref int Interval, 
            [MarshalAs(UnmanagedType.I4)] ref int PlsCount,
            [MarshalAs(UnmanagedType.I4)] ref int RepeatInterval,
            [MarshalAs(UnmanagedType.I4)] ref int RepeatCount);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CmpSetRandomData", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CmpSetRandomData(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int DataCount, 
            [MarshalAs(UnmanagedType.I4)] ref int[] DataList);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CmpGetRandomData", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CmpGetRandomData(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int DataCount, 
            [MarshalAs(UnmanagedType.I4)] ref int DataList);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CmpStart", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CmpStart(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CmpStop", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CmpStop(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CmpIsActive", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CmpIsActive(
            IntPtr hDevice,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int IsActive);

        [DllImport("ComiDXDll.dll", EntryPoint = "DX_CmpClear", CallingConvention = CallingConvention.Cdecl)]
        public  static extern unsafe int DX_CmpClear(
            IntPtr hDevice, 
            [MarshalAs(UnmanagedType.I4)] int Channel);


    }
}