﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace ComiLib.Daq
{
    public struct DaqDevInfo
    {
        public ushort wSubSysID;
        public uint nInstance;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public Char[] szDevName;
        public byte bDevCaps; // 0bit-A/D, 1bit-D/A, 2bit-DIO, 3bit-Counter,
        public byte nNumAdChan, nNumDaChan, nNumDiChan, nNumDoChan, nNumCntrChan;
    }

    public struct DaqDevList
    {
        public ushort nNumDev;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public DaqDevInfo[] DevInfo;
    }
}
