﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


using CDDLL = ComiDll.SafeNativeMethods;

namespace DAQ_Examples_CSharp
{
    public partial class DAQ_Analog_Output : Form
    {
        IntPtr g_hDevice = IntPtr.Zero;
        bool nRtn = false;
        int nCh = 0;
        float fVolt = 0;
        int nVMin = 0;
        int nVMax = 0;

        public DAQ_Analog_Output()
        {
            InitializeComponent();
        }

        private void DAOUT_Load(object sender, EventArgs e)
        {
            g_hDevice = CDDLL.COMI_LoadDevice((int)CDDLL.TCmDeviceID.SD101, 0);
            if (g_hDevice == IntPtr.Zero) MessageBox.Show("Can't Load any Device");

            nVMin = Convert.ToInt16(edtVMin.Text);
            nVMax = Convert.ToInt16(edtVMax.Text);

            CDDLL.COMI_DA_SetRange(g_hDevice, nCh, nVMin, nVMax);           
        }

        private void btnSetRange_Click(object sender, EventArgs e)
        {
            nVMin = Convert.ToInt16(edtVMin.Text);
            nVMax = Convert.ToInt16(edtVMax.Text);

            CDDLL.COMI_DA_SetRange(g_hDevice, nCh, nVMin, nVMax);           
        }

        private void btnDAOut_Click(object sender, EventArgs e)
        {
            fVolt = Convert.ToInt16(edtVolt.Text);
            nRtn = CDDLL.COMI_DA_Out(g_hDevice, nCh, fVolt);
        }

        private void DAOUT_FormClosing(object sender, FormClosingEventArgs e)
        {
            CDDLL.COMI_UnloadDevice(g_hDevice);
        }
    }
}
