﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using CDDLL = ComiDll.SafeNativeMethods;

namespace DAQ_Examples_CSharp
{
    public partial class DAQ_Digital_Input : Form
    {
        IntPtr g_hDevice = IntPtr.Zero;

        uint DI_Status = 1; // DI 값 저장하는 변수

        public DAQ_Digital_Input()
        {
            InitializeComponent();
        }

        private void DAQ_Digital_Input_Load(object sender, EventArgs e)
        {
            g_hDevice = CDDLL.COMI_LoadDevice((int)CDDLL.TCmDeviceID.SD424, 0); // 사용하는 Device 이름으로 수정후 Device Load

            if (g_hDevice == IntPtr.Zero) // Load 실패시
            {
                MessageBox.Show("Device 로드 실패");
                Close();
            }
            timer1.Start();

        }
        private void DAQ_Digital_Input_FormClosing(object sender, FormClosingEventArgs e)
        {
            CDDLL.COMI_UnloadDevice(g_hDevice); //종료시 Unload Device
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            DI_Status = CDDLL.COMI_DI_GetAll(g_hDevice); // 모든 Input 상태를 읽어온 후

            Refresh_UI(DI_Status); //DI Status값을 GUI에 표시
        }

        void Refresh_UI(uint DI_Status)
        {
            int LED_Temp = (int)DI_Status;
            int bit_index = 0;
            LED_Ch0.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch1.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch2.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch3.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch4.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch5.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch6.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch7.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch8.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch9.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch10.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch11.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch12.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch13.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch14.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
            LED_Ch15.BackColor = (((LED_Temp >> bit_index++) & 0x1) == 1) ? Color.Cyan : Color.LightGray;
        }
    }
}
