﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using CDDLL = ComiDll.SafeNativeMethods;
using System.Runtime.InteropServices;

namespace DAQ_Examples_CSharp
{
    public partial class DAQ_Digital_Output : Form
    {
        IntPtr g_hDevice = IntPtr.Zero;

        public DAQ_Digital_Output()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // 디바이스(CP401) 로드
            g_hDevice = CDDLL.COMI_LoadDevice((int)CDDLL.TCmDeviceID.SD424, 0);
            if (g_hDevice == IntPtr.Zero)
            {
                MessageBox.Show("Device CP401 로드 실패");
                Close();
            }
            else
            {
                // 32점을 출력으로 설정
                CDDLL.COMI_DIO_SetUsage(g_hDevice, 2);
                // In/Out 모드 설정 참고
                //public enum TCmDioUsage // DIO Usage
                //{
                //    cmDI_ONLY = 0,// All channels are digital input                                                
                //    cmDI_DO = 1,  // The first half channels are input and the latter half channels are for output 
                //    cmDO_DI = 2,  // The first half channels are output and the latter half channels are for input 
                //    cmDO_ONLY = 3 // All channels are digital output                                               
                //}

            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            CDDLL.COMI_UnloadDevice(g_hDevice);
        }

        private void chkCh_CheckedChanged(object sender, EventArgs e)
        {
            int ch = Convert.ToInt32(((CheckBox)sender).Tag.ToString());
            int outstate = ((CheckBox)sender).Checked ? 1 : 0;
            CDDLL.COMI_DO_PutOne(g_hDevice, ch, outstate);
        }

        private void btnAllOn_Click(object sender, EventArgs e)
        {
            int dwStates = 0xFFFF;
            // cmDO_ONLY 모드인 경우에는 최대 32채널이므로 다음과 같이 하면 됩니다.
            //int dwStates = 0xFFFFFFFF;
            CDDLL.COMI_DO_PutAllEx(g_hDevice, 0, dwStates);
        }

        private void btnAllOff_Click(object sender, EventArgs e)
        {
            int dwStates = 0x0;
            CDDLL.COMI_DO_PutAllEx(g_hDevice, 0, dwStates);
        }

        private void btnEvenOn_Click(object sender, EventArgs e)
        {
            int dwStates = 0x5555;
            // cmDO_ONLY 모드인 경우에는 최대 32채널이므로 다음과 같이 하면 됩니다.
            //int dwStates = 0x55555555;
            CDDLL.COMI_DO_PutAllEx(g_hDevice, 0, dwStates);
        }

        private void btnOddOn_Click(object sender, EventArgs e)
        {
            int dwStates = 0xAAAA;
            // cmDO_ONLY 모드인 경우에는 최대 32채널이므로 다음과 같이 하면 됩니다.
            //int dwStates = 0xAAAAAAAA;
            CDDLL.COMI_DO_PutAllEx(g_hDevice, 0, dwStates);
        }
    }
}
