
using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.Threading;

namespace Runner
{
    static class Program
    {
        /// <summary>
        /// ?대떦 ?묒슜 ?꾨줈洹몃옩??二?吏꾩엯?먯엯?덈떎.
        /// </summary>
        [STAThread]
        public static void Main()
        {
            AppDomain.CurrentDomain.UnhandledException += CurrentDomain_UnhandledException;
 
            InitialiseWinFormsSettings();
 
            try
            {
                Execute();
            }
            catch (Exception ex)
            {
                DumpException(ex, "Unhandled exeception(1)");
            }            
        }

        private static void InitialiseWinFormsSettings()
        {
            Application.ThreadException += Application_ThreadException;
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
        }
 
        static void Application_ThreadException(object sender, ThreadExceptionEventArgs e)
        {
            DumpException(e.Exception, "Thread Exception");
        }
 
        static void CurrentDomain_UnhandledException(object sender, UnhandledExceptionEventArgs e)
        {
            DumpException((Exception)e.ExceptionObject, "Unhandeld execption (2)");
        }
 
        static void DumpException (Exception exception, string title)
        {
            MessageBox.Show(exception.ToString(), title);
        }
 
        private static void Execute()
        {
            Application.Run(new MainForm());
        }
    }
}