--[[
	Configuration Area
--]]

-- ############################################################################################################
-- UDP Message
   this.SetUdpPort(this,35032);

-- Control Message
   this.SetTCPPort(this,35033);		
   this.SetSendTimeOut(this, 2000 * 200); 	-- Unit : us
   this.SetRecvTimeOut(this, 2000 * 200);      -- Unit : us
   this.SetConnectTimeOut(this, 1000 * 1000);	-- Unit : us

   this.SetUpdownDelay(this,10);		-- Unit : ms

-- System Logging Option
   this.SetDaemonLog(this,0);
   this.SetCnCoreLog(this,0);
   this.SetCeUserLog(this,0);
   this.SetLogDir(this,"c:\\comizoa_log");

-- Initialize Broadcast Retry (Count)
   this.SetBroadCastCount(this,1);

-- Prime Number Processing Rule(roundup,roundoff)
   this.SetPrimeNumberProc(this,"roundoff");

-- Disconnect Checker Control
   this.SetDisconnectChecker(this,1);
   this.SetICMPInterval(this, 1000);	-- Unit : ms	( input values greater then 1000 )
   this.SetICMPTimeout(this, 1000);	-- Unit : ms	( input values greater then 1000 )

-- Enable or Disable Verbose Message Mode
   this.SetNodeScanMsgVerbose(this,0);
   this.SetIOMsgVerbose(this,0);
   this.SetTCPMsgVerbose(this,0);

-- Installed Firmware Version Information
   this.SetFirmwareVersion(this, "01.13.12.24");

-- ############################################################################################################

--[[
	cnSDK Protocol Parsing Codes
--]]

--[[
function this.CalcCheckSum(this, ...)
	local nChecksum = 0;
	for i,v in ipairs(arg) do
	nChecksum = nChecksum + tonumber(v)
	end
	return nChecksum;
end
--]]

function this.SetControlParamter(this, ...)
	local szParameterArray = {};
	local szTemp = "";
	local n=0;

	for i,v in ipairs(arg) do
	 szParameterArray[n] = string.format("%x",tonumber(v));
	 n = n + 1;
	end
	
	if n == 1 then
		return szParameterArray[0];
	end

	szTemp = szParameterArray[0];
	for i=1, n-1  do
	szTemp = szTemp .."," .. szParameterArray[i]
	end

	return szTemp;
end

function this.SetControlPacket(this, NodeId, CmdSeq, Command, Parameter)
	__STX__ = 0x2;
	__ETX__ = 0x3;
	szSetPacket = string.format("%c%02x%02x%04x:%s:",__STX__,NodeId,CmdSeq,Command, Parameter);
	szSetPacket = string.format("%s%02x%c",szSetPacket, this.getchecksum(this,szSetPacket),__ETX__);
	return szSetPacket;
end

function this.GetControlPacket_NodeId(this, szPacket)
	local szTemp = this.hextoint(this,string.sub(szPacket,2,3));
	return tonumber(szTemp);
end

function this.GetControlPacket_CmdSeq(this, szPacket)
	local szTemp = this.hextoint(this,string.sub(szPacket,4,5));
	return tonumber(szTemp);
end

function this.GetControlPacket_ErrorCode(this, szPacket)
	local szTemp = this.hextoint(this,string.sub(szPacket,6,9));
	return tonumber(szTemp);
end

function this.GetControlPacket_Parameter(this, szPacket)
	local szTemp = string.sub(szPacket,11,-5);
	return szTemp;
end

function this.GetControlPacket_Checksum(this, szPacket)
	local szTemp = this.hextoint(this, string.sub(szPacket, -3,-2));
	return tonumber(szTemp);
end
