﻿using System.Runtime.InteropServices;

namespace ComiLib.EtherCAT.SoftECAT
{
    [System.Security.SuppressUnmanagedCodeSecurity]
    public sealed class SafeNativeMethods
    {
        const string dll = "ComiSWEcatSdk.dll";


        // TEcSlvProdInfo: 하나의 슬레이브에 대한 Product ID 정보 // 
        [StructLayout(LayoutKind.Sequential)]
        public struct TEcSlvState
        {
            public ushort state;					// state of slave
            public ushort ALstatuscode;			// AL status code
            public byte islost;					// TRUE is slave is not responding at all
        }

        // Slave Product Information Extension(SW Master)
        [StructLayout(LayoutKind.Sequential)]
        public struct TEcSlvProdInfoEx
        {
            public ushort state;					// state of slave
            public ushort ALstatuscode;			// AL status code
            public ushort configadr;				// Configured address
            public ushort aliasadr;				// Alias address
            public uint eep_man;				// Manufacturer from EEprom
            public uint eep_id;					// ID from EEprom
            public uint eep_rev;				// revision from EEprom
            public ushort Itype;					// Interface type
            public ushort Dtype;					// Device type
            public byte islost;					// TRUE is slave is not responding at all
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 63)]
            public char[] name;
        } 


        //EC_EXTERN t_ui32		(CECAT_API *ecNet_ScanSlaves)(t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecNet_ScanSlaves")]
        public static extern unsafe uint ecNet_ScanSlaves(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecGn_LoadDevices) (t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecGn_LoadDevices")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_LoadDevices(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecGn_UnloadDevices) (t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecGn_UnloadDevices")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecGn_UnloadDevices(
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecSlv_GetProdInfo_A) (t_i32 NetID, t_i32 SlaveIndex, TEcSlvProdInfo *pProdInfoBuf, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecSlv_GetProdInfo_A")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_GetProdInfo_A(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] int SlaveIndex, 
            ref TEcSlvProdInfoEx pProdInfoBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecSlv_GetState_A) (t_i32 NetID, t_i32 SlaveIdx, TEcSlvState *pSlaveStateBuf, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecSlv_GetState_A")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecSlv_GetState_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIndex, 
            ref TEcSlvState pSlaveStateBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecdiGetSlaveIndex) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecdiGetSlaveIndex")]
        public static extern unsafe int ecdiGetSlaveIndex(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecdiGetSlaveID) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecdiGetSlaveID")]
        public static extern unsafe int ecdiGetSlaveID(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint DiChannel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecdiGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecdiGetNumChannels")]
        public static extern unsafe int ecdiGetNumChannels(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_bool	(CECAT_API *ecdiGetOne) (t_i32 NetID, t_ui32 DiChannel, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecdiGetOne")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdiGetOne(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint DiChannel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword	(CECAT_API *ecdiGetMulti) (t_i32 NetID, t_ui32 IniChannel, t_ui8 NumChannels, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecdiGetMulti")]
        public static extern unsafe uint ecdiGetMulti(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint IniChannel, 
            [MarshalAs(UnmanagedType.U1)] byte NumChannels, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        ////====================== Digital Output FUNCTIONS =======================================================//

        
        //EC_EXTERN t_i32		(CECAT_API *ecdoGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecdoGetNumChannels")]
        public static extern unsafe int ecdoGetNumChannels(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success	(CECAT_API *ecdoPutOne) (t_i32 NetID, t_ui32 DoChannel, t_bool OutState, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecdoPutOne")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdoPutOne(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint DoChannel,
            [MarshalAs(UnmanagedType.I1)] bool OutState,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecdoPutMulti) (t_i32 NetID, t_ui32 IniChannel, t_ui8 NumChannels, t_dword dwOutStates, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecdoPutMulti")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdoPutMulti(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint IniChannel, 
            [MarshalAs(UnmanagedType.U1)] byte NumChannels, 
            [MarshalAs(UnmanagedType.U4)] uint dwOutStates,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
        
        //EC_EXTERN t_bool	(CECAT_API *ecdoGetOne) (t_i32 NetID, t_ui32 DoChannel, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecdoGetOne")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecdoGetOne(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint DoChannel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_dword	(CECAT_API *ecdoGetMulti) (t_i32 NetID, t_ui32 IniChannel, t_ui8 NumChannels, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecdoGetMulti")]
        public static extern unsafe uint ecdoGetMulti(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint IniChannel,
            [MarshalAs(UnmanagedType.U1)] byte NumChannels, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        ////====================== Analog Input FUNCTIONS =======================================================//

        //EC_EXTERN t_i32		(CECAT_API *ecaiGetSlaveIndex) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaiGetSlaveIndex")]
        public static extern unsafe int ecaiGetSlaveIndex(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaiGetSlaveID) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaiGetSlaveID")]
        public static extern unsafe int ecaiGetSlaveID(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaiGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaiGetNumChannels")]
        public static extern unsafe int ecaiGetNumChannels(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaiGetChanVal_I) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaiGetChanVal_I")]
        public static extern unsafe int ecaiGetChanVal_I(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecaiGetChanVal_F) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaiGetChanVal_F")]
        public static extern unsafe double ecaiGetChanVal_F(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecaiGetChanVal_FS) (t_i32 NetID, t_ui32 Channel, t_f32 ScaleMin, t_f32 ScaleMax, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaiGetChanVal_FS")]
        public static extern unsafe double ecaiGetChanVal_FS(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.R4)] float ScaleMin, 
            [MarshalAs(UnmanagedType.R4)] float ScaleMax, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaiL_GetChanVal_I) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        //[DllImport(dll, EntryPoint = "ecaiL_GetChanVal_I")]
        //public static extern unsafe int ecaiL_GetChanVal_I(
        //    [MarshalAs(UnmanagedType.I4)] int NetID,
        //    [MarshalAs(UnmanagedType.U4)] uint Channel, 
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecaiL_GetChanVal_F) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        //[DllImport(dll, EntryPoint = "ecaiL_GetChanVal_F")]
        //public static extern unsafe double ecaiL_GetChanVal_F(
        //    [MarshalAs(UnmanagedType.I4)] int NetID,
        //    [MarshalAs(UnmanagedType.U4)] uint Channel, 
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecaiL_GetChanVal_FS) (t_i32 NetID, t_ui32 Channel, t_f32 ScaleMin, t_f32 ScaleMax, _out t_i32 *ErrCode);
        //[DllImport(dll, EntryPoint = "ecaiL_GetChanVal_FS")]
        //public static extern unsafe double ecaiL_GetChanVal_FS(
        //    [MarshalAs(UnmanagedType.I4)] int NetID,
        //    [MarshalAs(UnmanagedType.U4)] uint Channel,
        //    [MarshalAs(UnmanagedType.R4)] float ScaleMin, 
        //    [MarshalAs(UnmanagedType.R4)] float ScaleMax, 
        //    [MarshalAs(UnmanagedType.I4)] ref int ErrCode);


        ////====================== Analog Output FUNCTIONS =======================================================//

        //EC_EXTERN t_i32		(CECAT_API *ecaoGetSlaveIndex) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaoGetSlaveIndex")]
        public static extern unsafe int ecaoGetSlaveIndex(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaoGetSlaveID) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaoGetSlaveID")]
        public static extern unsafe int ecaoGetSlaveID(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaoGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaoGetNumChannels")]
        public static extern unsafe int ecaoGetNumChannels(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecaoSetChanVal_I) (t_i32 NetID, t_ui32 Channel, t_i32 OutData, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaoSetChanVal_I")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecaoSetChanVal_I(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.I4)] int OutData, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecaoSetChanVal_F) (t_ecmSxCfg_SetMioPropi32 NetID, t_ui32 Channel, t_f64 OutData, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaoSetChanVal_F")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecaoSetChanVal_F(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel,
            [MarshalAs(UnmanagedType.R8)] double OutData, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success (CECAT_API *ecaoSetChanVal_FS) (t_i32 NetID, t_ui32 Channel, t_f64 OutData, t_f64 ScaleMin, t_f64 ScaleMax, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaoSetChanVal_FS")]
        [return: MarshalAs(UnmanagedType.I1)]
        public static extern unsafe bool ecaoSetChanVal_FS(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel,
            [MarshalAs(UnmanagedType.R8)] double ScaleMin,
            [MarshalAs(UnmanagedType.R8)] double ScaleMax,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32		(CECAT_API *ecaoGetOutValue_I) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaoGetOutValue_I")]
        public static extern unsafe int ecaoGetOutValue_I(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecaoGetOutValue_F) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaoGetOutValue_F")]
        public static extern unsafe double ecaoGetOutValue_F(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.U4)] uint Channel,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_f64		(CECAT_API *ecaoGetOutValue_FS) (t_i32 NetID, t_ui32 Channel, t_f64 ScaleMin, t_f64 ScaleMax, _out t_i32 *ErrCode);
        [DllImport(dll, EntryPoint = "ecaoGetOutValue_FS")]
        public static extern unsafe double ecaoGetOutValue_FS(
            [MarshalAs(UnmanagedType.I4)] int NetID, 
            [MarshalAs(UnmanagedType.U4)] uint Channel, 
            [MarshalAs(UnmanagedType.R8)] double ScaleMin, 
            [MarshalAs(UnmanagedType.R8)] double ScaleMax, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);



        //====================== SLAVE I/F FUNCTIONS ============================================================//

        //EC_EXTERN t_i32			(CECAT_API *ecSlv_ReadReg_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 RegAddr, t_i32 DataSize, _out void *pBuf, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_ReadReg_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int RegAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteReg_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 RegAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteReg_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int RegAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecSlv_ReadEEPR_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 EeeprAddr, t_i32 DataSize, _out void  *pBuf, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_ReadEEPR_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int EeeprAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteEEPR_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 EeeprAddr, t_i32 DataSize, void  *pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteEEPR_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int EeeprAddr,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_i32			(CECAT_API *ecSlv_ReadCoeSdo_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pBuf, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_ReadCoeSdo_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int Index,
            [MarshalAs(UnmanagedType.I4)] int SubIdx,
            [MarshalAs(UnmanagedType.I4)] int IsComptAccess,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pBuf, 
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);

        //EC_EXTERN t_success		(CECAT_API *ecSlv_WriteCoeSdo_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pData, _out t_i32 *ErrCode);
        [DllImport(dll)]
        public static extern unsafe int ecSlv_WriteCoeSdo_A(
            [MarshalAs(UnmanagedType.I4)] int NetID,
            [MarshalAs(UnmanagedType.I4)] int SlaveIdx,
            [MarshalAs(UnmanagedType.I4)] int Index,
            [MarshalAs(UnmanagedType.I4)] int SubIdx,
            [MarshalAs(UnmanagedType.I4)] int IsComptAccess,
            [MarshalAs(UnmanagedType.I4)] int DataSize,
            [MarshalAs(UnmanagedType.I4)] ref int pData,
            [MarshalAs(UnmanagedType.I4)] ref int ErrCode);
    }
}
