﻿using System;
using System.Runtime.InteropServices;

namespace ComiLib.MLink2
{
    [System.Security.SuppressUnmanagedCodeSecurity]
    public unsafe partial class SafeNativeMethods
    {
        const string dll = "ComiMLink2.DLL";
        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (AI)
        /////////////////////////////////////////////////////////////////////////

        [DllImport(dll)]
        public  static extern unsafe int AiSetVoltRangeMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int Mode);


        [DllImport(dll)]
        public  static extern unsafe int AiGetVoltRangeMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int Mode);


        [DllImport(dll)]
        public  static extern unsafe int AiGetRangeDigit(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int Dmin, 
            [MarshalAs(UnmanagedType.I4)] ref int Dmax);


        [DllImport(dll)]
        public  static extern unsafe int AiGetDigit(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int Digit);


        [DllImport(dll)]
        public  static extern unsafe int AiGetVolt(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] ref double Volt);


        [DllImport(dll)]
        public  static extern unsafe int AiGetCurrent(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] ref double Current);




        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (AO)
        /////////////////////////////////////////////////////////////////////////


        [DllImport(dll)]
        public  static extern unsafe int AoOutDigit(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int Digit);


        [DllImport(dll)]
        public  static extern unsafe int AoOutVolt(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] double Volt);


        [DllImport(dll)]
        public  static extern unsafe int AoOutCurrent(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] double Current);




        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (DI)
        /////////////////////////////////////////////////////////////////////////


        // [IN] Axis [IN] Channel [OUT] Logic
        [DllImport(dll)]
        public  static extern unsafe int DiGetLogic(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int Logic);


        // [IN] Axis [IN] Channel [IN] Logic
        [DllImport(dll)]
        public  static extern unsafe int DiSetLogic(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int Logic);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
        [DllImport(dll)]
        public  static extern unsafe int DiGetLogicMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int IniChannel, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel, 
            [MarshalAs(UnmanagedType.I4)] ref int Logic);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
        [DllImport(dll)]
        public  static extern unsafe int DiSetLogicMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int IniChannel,
            [MarshalAs(UnmanagedType.I4)] int NumChannel, 
            [MarshalAs(UnmanagedType.I4)] int Logic);


        // [IN] Axis [IN] Channel [OUT] State
        [DllImport(dll)]
        public  static extern unsafe int DiGetOne(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int channel, 
            [MarshalAs(UnmanagedType.I4)] ref int State);


        [DllImport(dll)]
        public  static extern unsafe int DiGetMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int channel, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel, 
            [MarshalAs(UnmanagedType.I4)] ref int State);




        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (DO)
        //////////////////////////////////////////////////////////////////////////


        // [IN] Axis [IN] Channel [OUT] Logic
        [DllImport(dll)]
        public  static extern unsafe int DoGetLogic(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int Logic);


        // [IN] Axis [IN] Channel [IN] Logic
        [DllImport(dll)]
        public  static extern unsafe int DoSetLogic(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Logic);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
        [DllImport(dll)]
        public  static extern unsafe int DoGetLogicMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int IniChannel,
            [MarshalAs(UnmanagedType.I4)] int NumChannel, 
            [MarshalAs(UnmanagedType.I4)] ref int Logic);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
        [DllImport(dll)]
        public  static extern unsafe int DoSetLogicMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int IniChannel, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel, 
            [MarshalAs(UnmanagedType.I4)] int Logic);


        // [IN] Axis [IN] Channel [IN] State
        [DllImport(dll)]
        public  static extern unsafe int DoPutOne(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int Axis,
            [MarshalAs(UnmanagedType.I4)] int channel,
            [MarshalAs(UnmanagedType.I4)] int State);


        // [IN] Axis [IN] Channel [OUT] State
        [DllImport(dll)]
        public  static extern unsafe int DoGetOne(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int channel, 
            [MarshalAs(UnmanagedType.I4)] ref int State);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [IN] State
        [DllImport(dll)]
        public  static extern unsafe int DoPutMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int Inichannel,
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] int State);

        
        // [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
        [DllImport(dll)]
        public  static extern unsafe int DoGetMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int Axis, 
            [MarshalAs(UnmanagedType.I4)] int Inichannel, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel, 
            [MarshalAs(UnmanagedType.I4)] ref int State);


        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (DIO)
        //////////////////////////////////////////////////////////////////////////


        // [IN] Axis [IN] Channel [OUT] InOutMode
        //EXTERN LONG		(WINAPI *cmlDioGetIomode)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG InOutMode);

        [DllImport(dll)]
        public static extern unsafe int DioGetIomode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int InOutMode);


        // [IN] Axis [IN] Channel [IN] InOutMode
        //EXTERN LONG		(WINAPI *cmlDioSetIomode)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG InOutMode);

        [DllImport(dll)]
        public static extern unsafe int DioSetIomode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int InOutMode);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] InOutMode
        //EXTERN LONG		(WINAPI *cmlDioGetIomodeMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG InOutMode);

        [DllImport(dll)]
        public static extern unsafe int DioGetIomodeMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int IniChannel,
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] ref int InOutMode);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [IN] InOutMode
        //EXTERN LONG		(WINAPI *cmlDioSetIomodeMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG InOutMode);

        [DllImport(dll)]
        public static extern unsafe int DioSetIomodeMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int IniChannel,
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] int InOutMode);


        // [IN] Axis [IN] Channel [OUT] Logic
        //EXTERN LONG		(WINAPI *cmlDioGetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Logic);

        [DllImport(dll)]
        public static extern unsafe int DioGetLogic(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int Logic);


        // [IN] Axis [IN] Channel [IN] Logic
        //EXTERN LONG		(WINAPI *cmlDioSetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Logic);

        [DllImport(dll)]
        public static extern unsafe int DioSetLogic(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Logic);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
        //EXTERN LONG		(WINAPI *cmlDioGetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG Logic);

        [DllImport(dll)]
        public static extern unsafe int DioGetLogicMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int IniChannel,
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] ref int Logic);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
        //EXTERN LONG		(WINAPI *cmlDioSetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG Logic);

        [DllImport(dll)]
        public static extern unsafe int DioSetLogicMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int IniChannel,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Logic);


        // [IN] Axis [IN] Channel [IN] State
        //EXTERN LONG		(WINAPI *cmlDioPutOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG State);

        [DllImport(dll)]
        public static extern unsafe int DioPutOne(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int State);


        // [IN] Axis [IN] Channel [OUT] State
        //EXTERN LONG		(WINAPI *cmlDioGetOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG State);

        [DllImport(dll)]
        public static extern unsafe int DioGetOne(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int State);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [IN] State
        //EXTERN LONG		(WINAPI *cmlDioPutMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG State);

        [DllImport(dll)]
        public static extern unsafe int DioPutMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int IniChannel,
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] int State);


        // [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
        //EXTERN LONG		(WINAPI *cmlDioGetMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG State);

        [DllImport(dll)]
        public static extern unsafe int DioGetMulti(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int IniChannel,
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] ref int State);


        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (PM-GN)
        //////////////////////////////////////////////////////////////////////////


        // [IN] NodeId [IN] Channel [IN] IsOn
        [DllImport(dll)]
        public  static extern unsafe int PmGnSetServoOn(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int IsOn);


        // [IN] NodeId [IN] Channel [OUT] pIsOn
        [DllImport(dll)]
        public  static extern unsafe int PmGnGetServoOn(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int pIsOn);


        // [IN] NodeId [IN] Channel [IN] IsReset
        [DllImport(dll)]
        public  static extern unsafe int PmGnAlarmReset(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int IsReset);




        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (PM-CFG)
        //////////////////////////////////////////////////////////////////////////


        // [IN] NodeId [IN] Channel [IN] PropId [IN] PropVal
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetMioProperty(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int PropId,
            [MarshalAs(UnmanagedType.I4)] int PropVal);


        // [IN] NodeId [IN] Channel [IN] PropId [OUT] pPropVal
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetMioProperty(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int PropId,
            [MarshalAs(UnmanagedType.I4)] ref int pPropVal);


        // [IN] NodeId [IN] Channel [IN] IsEnable
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetFilter(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int IsEnable);


        // [IN] NodeId [IN] Channel [OUT] pIsEnable
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetFilter(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int pIsEnable);


        // [IN] NodeId [IN] Channel [IN] Target [IN] IsEnable
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetFilterAB(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Target,
            [MarshalAs(UnmanagedType.I4)] int IsEnable);


        // [IN] NodeId [IN] Channel [IN] Target [OUT] pIsEnable
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetFilterAB(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Target, 
            [MarshalAs(UnmanagedType.I4)] ref int pIsEnable);


        // [IN] NodeId [IN] Channel [IN] InputMode [IN] IsReverse
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetInMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int InputMode, 
            [MarshalAs(UnmanagedType.I4)] int IsReverse);


        // [IN] NodeId [IN] Channel [IN] InputMode [OUT] pIsReverse
        [DllImport(dll)]        
        public  static extern unsafe int PmCfgGetInMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pInputMode,
            [MarshalAs(UnmanagedType.I4)] ref int pIsReverse);


        // [IN] NodeId [IN] Channel [IN] OutputMode
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetOutMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int OutputMode);


        // [IN] NodeId [IN] Channel [OUT] pOutputMode
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetOutMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int pOutputMode);


        // [IN] NodeId [IN] Channel [IN] CtrlMode
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetCtrlMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int CtrlMode);


        // [IN] NodeId [IN] Channel [OUT] pCtrlMode
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetCtrlMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pCtrlMode);


        // [IN] NodeId [IN] Channel [IN] Ratio
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetInOutRatio(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int Ratio);


        // [IN] NodeId [IN] Channel [OUT] pRatio
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetInOutRatio(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pRatio);


        // [IN] NodeId [IN] Channel [IN] UnitDist
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetUnitDist(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] double UnitDist);


        // [IN] NodeId [IN] Channel [OUT] pUnitDist
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetUnitDist(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] ref double pUnitDist);


        // [IN] NodeId [IN] Channel [IN] UnitSpeed
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetUnitSpeed(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] double UnitSpeed);


        // [IN] NodeId [IN] Channel [OUT] pUnitSpeed
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetUnitSpeed(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] ref double pUnitSpeed);


        // [IN] NodeId [IN] Channel [IN] MaxPPS
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetSpeedRange(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int MaxPPS);


        // [IN] NodeId [IN] Channel [OUT] pMaxPPS
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetSpeedRange(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pMaxPPS);


        // [IN] NodeId [IN] Channel [IN] SpeedMode [IN] WorkSpeed [IN] Accel [IN] Decel
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetSpeedPattern(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double WorkSpeed,
            [MarshalAs(UnmanagedType.R8)] double Accel, 
            [MarshalAs(UnmanagedType.R8)] double Decel);


        // [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pWorkSpeed [OUT] pAccel [OUT] pDecel
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetSpeedPattern(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pSpeedMode,
            [MarshalAs(UnmanagedType.R8)] ref double pWorkSpeed, 
            [MarshalAs(UnmanagedType.R8)] ref double pAccel,
            [MarshalAs(UnmanagedType.R8)] ref double pDecel);


        // [IN] NodeId [IN] Channel [IN] SpeedMode [IN] WorkSpeed [IN] AccTime [IN] DecTime
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetSpeedPattern_T(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double WorkSpeed,
            [MarshalAs(UnmanagedType.R8)] double AccTime, 
            [MarshalAs(UnmanagedType.R8)] double DecTime);


        // [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pWorkSpeed [OUT] pAccTime [OUT] pDecTiem
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetSpeedPattern_T(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pSpeedMode, 
            [MarshalAs(UnmanagedType.R8)] ref double pWorkSpeed, 
            [MarshalAs(UnmanagedType.R8)] ref double pAccTime, 
            [MarshalAs(UnmanagedType.R8)] ref double pDecTime);


        // [IN] NodeId [IN] Channel [IN] IsEnable [IN] LimitN [IN] LimitP
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetSoftLimit(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int IsEnable, 
            [MarshalAs(UnmanagedType.R8)] double LimitN,
            [MarshalAs(UnmanagedType.R8)] double LimitP);


        // [IN] NodeId [IN] Channel [OUT] pIsEnable [OUT] pLimitN [OUT] pLimitP
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetSoftLimit(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pIsEnable,
            [MarshalAs(UnmanagedType.R8)] ref double pLimitN,
            [MarshalAs(UnmanagedType.R8)] ref double pLimitP);


        // [IN] NodeId [IN] Channel [IN] TargCntr [IN] IsEnable [IN] CntMax
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetRingCntr(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int TargCntr,
            [MarshalAs(UnmanagedType.I4)] int IsEnable, 
            [MarshalAs(UnmanagedType.I4)] int CntMax);


        // [IN] NodeId [IN] Channel [IN] TargCntr [OUT] pIsEnable [OUT] pCntMax
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetRingCntr(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int TargCntr,
            [MarshalAs(UnmanagedType.I4)] ref int pIsEnable,
            [MarshalAs(UnmanagedType.I4)] ref int pCntMax);


        // [IN] NodeId [IN] Channel [IN] CorrRatio
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetVelCorrRatio(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int CorrRatio);


        // [IN] NodeId [IN] Channel [OUT] pCorrRatio
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetVelCorrRatio(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int CorrRatio);


        // [IN] NodeId [IN] SeqMode
        [DllImport(dll)]
        public  static extern unsafe int PmCfgSetSeqMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int SeqMode);


        // [IN] NodeId [OUT] pSeqMode
        [DllImport(dll)]
        public  static extern unsafe int PmCfgGetSeqMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] ref int pSeqMode);




        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (PM-HOME)
        //////////////////////////////////////////////////////////////////////////


        // [IN] NodeId [IN] Channel [IN] HomeMode [IN] Dir [IN] EzCount [IN] EscDist [IN] Offset
        [DllImport(dll)]
        public  static extern unsafe int PmHomeSetConfig(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int HomeMode,
            [MarshalAs(UnmanagedType.I4)] int Dir,
            [MarshalAs(UnmanagedType.I4)] int EzCount, 
            [MarshalAs(UnmanagedType.I4)] int EscDist,
            [MarshalAs(UnmanagedType.R8)] double Offset);


        // [IN] NodeId [IN] Channel [OUT] pHomeMode [OUT] pDir [OUT] pEzCount [OUT] pEscDist [OUT] pOffset
        [DllImport(dll)]
        public  static extern unsafe int PmHomeGetConfig(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pHomeMode,
            [MarshalAs(UnmanagedType.I4)] ref int Dir,
            [MarshalAs(UnmanagedType.I4)] ref int pEzCount,
            [MarshalAs(UnmanagedType.I4)] ref int pEscDist, 
            [MarshalAs(UnmanagedType.R8)] ref double pOffset);


        // [IN] NodeId [IN] Channel [IN] PosClrMode
        [DllImport(dll)]
        public  static extern unsafe int PmHomeSetPosClrMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int PosClrMode);


        // [IN] NodeId [IN] Channel [OUT] pPosClrMode
        [DllImport(dll)]
        public  static extern unsafe int PmHomeGetPosClrMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pPosClrMode);


        // [IN] NodeId [IN] Channel [IN] SpeedMode [IN] Vel [IN] Accel [IN] Decel [IN] RevVel
        [DllImport(dll)]
        public  static extern unsafe int PmHomeSetSpeedPattern(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int SpeedMode, 
            [MarshalAs(UnmanagedType.R8)] double Vel,
            [MarshalAs(UnmanagedType.R8)] double Accel,
            [MarshalAs(UnmanagedType.R8)] double Decel, 
            [MarshalAs(UnmanagedType.R8)] double RevVel );


        // [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pVel [OUT] pAccel [OUT] pDecel [OUT] pRevVel
        [DllImport(dll)]
        public  static extern unsafe int PmHomeGetSpeedPattern(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pSpeedMode,
            [MarshalAs(UnmanagedType.R8)] ref double pVel,
            [MarshalAs(UnmanagedType.R8)] ref double pAccel,
            [MarshalAs(UnmanagedType.R8)] ref double pDecel,
            [MarshalAs(UnmanagedType.R8)] ref double pRevVel);


        // [IN] NodeId [IN] Channel [IN] SpeedMode [IN] Vel [IN] AccTime [IN] DecTime [IN] RevVel
        [DllImport(dll)]
        public  static extern unsafe int PmHomeSetSpeedPattern_T(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double Vel, 
            [MarshalAs(UnmanagedType.R8)] double AccTime, 
            [MarshalAs(UnmanagedType.R8)] double DecTime, 
            [MarshalAs(UnmanagedType.R8)] double RevVel);


        // [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pVel [OUT] pAccTime [OUT] pDecTime [OUT] pRevVel
        [DllImport(dll)]
        public  static extern unsafe int PmHomeGetSpeedPattern_T(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int pSpeedMode,
            [MarshalAs(UnmanagedType.R8)] ref double pVel,
            [MarshalAs(UnmanagedType.R8)] ref double pAccTime,
            [MarshalAs(UnmanagedType.R8)] ref double pDecTime,
            [MarshalAs(UnmanagedType.R8)] ref double pRevVel);


        // [IN] NodeId [IN] Channel
        [DllImport(dll)]
        public  static extern unsafe int PmHomeMoveStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel);


        // [IN] NodeId [IN] Channel [IN] ChanndelMask
        [DllImport(dll)]
        public  static extern unsafe int PmHomeMoveAllStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int ChannelMask);


        // [IN] NodeId [IN] Channel [IN] IsSuccess
        [DllImport(dll)]
        public  static extern unsafe int PmHomeSetSuccess(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int IsSuccess);


        // [IN] NodeId [IN] Channel [IN] pIsSuccess
        [DllImport(dll)]
        public  static extern unsafe int PmHomeGetSuccess(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pIsSuccess);




        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (PM-SX)
        //////////////////////////////////////////////////////////////////////////

        // [IN] NodeId [IN] Channel [IN] SpeedMode [IN] VelRatio [IN] AccRatio [IN] DecRatio
        [DllImport(dll)]
        public  static extern unsafe int PmSxSetSpeedRatio(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int SpeedMode, 
            [MarshalAs(UnmanagedType.I4)] int VelRatio,
            [MarshalAs(UnmanagedType.I4)] int AccRatio, 
            [MarshalAs(UnmanagedType.I4)] int DecRatio);


        // [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pVelRatio [OUT] pAccRatio [OUT] pDecRatio
        [DllImport(dll)]
        public  static extern unsafe int PmSxGetSpeedRatio(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int pSpeedMode, 
            [MarshalAs(UnmanagedType.I4)] ref int pVelRatio,
            [MarshalAs(UnmanagedType.I4)] ref int pAccRatio, 
            [MarshalAs(UnmanagedType.I4)] ref int pDecRatio);


        // [IN] NodeId [IN] Channel [IN] Distance
        [DllImport(dll)]
        public  static extern unsafe int PmSxMoveStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] double Distance);


        // [IN] NodeId [IN] Channel [IN] Distance [IN] IsBlocking
        [DllImport(dll)]
        public  static extern unsafe int PmSxMove(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] double Distance,
            [MarshalAs(UnmanagedType.I4)] int IsBlocking);


        // [IN] NodeId [IN] Channel [IN] Position
        [DllImport(dll)]
        public  static extern unsafe int PmSxMoveToStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] double Position);


        // [IN] NodeId [IN] Channel [IN] Position [IN] IsBlocking
        [DllImport(dll)]
        public  static extern unsafe int PmSxMoveTo(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] double Position, 
            [MarshalAs(UnmanagedType.I4)] int IsBlocking);


        // [IN] NodeId [IN] Channel [IN] Direction
        [DllImport(dll)]
        public  static extern unsafe int PmSxVMoveStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Direction);


        // [IN] NodeId [IN] Channel [IN] IsWaitComplete
        [DllImport(dll)]
        public  static extern unsafe int PmSxStop(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int IsWaitComplete);


        // [IN] NodeId [IN] Channel [IN] IsWaitComplete
        [DllImport(dll)]
        public  static extern unsafe int PmSxStopEmg(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel);


        // [IN] NodeId [IN] Channel [IN] IsWaitComplete
        [DllImport(dll)]
        public  static extern unsafe int PmSxIsDone(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pIsDone);


        // [IN] NodeId [IN] Channel 
        [DllImport(dll)]
        public  static extern unsafe int PmSxWaitDone(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel);


        // [IN] NodeId [IN] Channel [OUT] pPosition
        [DllImport(dll)]
        public  static extern unsafe int PmSxGetTargetPos(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] ref double pPosition);


        // [IN] NodeId [IN] Channel [IN] IniSpeed
        [DllImport(dll)]
        public  static extern unsafe int PmSxSetOptIniSpeed(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] double IniSpeed);


        // [IN] NodeId [IN] Channel [OUT] pIniSpeed
        [DllImport(dll)]
        public  static extern unsafe int PmSxGetOptIniSpeed(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] ref double pIniSpeed);


        // [IN] NodeId [IN] Channel [IN] OffsetDist
        [DllImport(dll)]
        public  static extern unsafe int PmSxSetOptRdpOffset(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] double OffsetDist);


        // [IN] NodeId [IN] Channel [OUT] pOffsetDist
        [DllImport(dll)]
        public  static extern unsafe int PmSxGetOptRdpOffset(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] ref double pOffsetDist);


        // [IN] NodeId [IN] Channel [IN] CorrMode [IN] CorrAmount [IN] CorrVel [IN] CntrMask
        [DllImport(dll)]
        public  static extern unsafe int PmSxSetCorrection(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int CorrMode,
            [MarshalAs(UnmanagedType.R8)] double CorrAmount, 
            [MarshalAs(UnmanagedType.R8)] double CorrVel, 
            [MarshalAs(UnmanagedType.I4)] int CntrMask);


        // [IN] NodeId [IN] Channel [OUT] pCorrMode [OUT] pCorrAmount [OUT] pCorrVel [OUT] pCntrMask
        [DllImport(dll)]
        public  static extern unsafe int PmSxGetCorrection(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int pCorrMode, 
            [MarshalAs(UnmanagedType.R8)] ref double pCorrAmount, 
            [MarshalAs(UnmanagedType.R8)] ref double pCorrVel,
            [MarshalAs(UnmanagedType.I4)] ref int pCntrMask);


        // [IN] NodeId [IN] Channel [IN] Mode [IN] RefAxis [IN] Condition
        [DllImport(dll)]
        public  static extern unsafe int PmSxSetOptSyncMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Mode, 
            [MarshalAs(UnmanagedType.I4)] int RefAxis,
            [MarshalAs(UnmanagedType.I4)] int Condition);


        // [IN] NodeId [IN] Channel [OUT] pMode [OUT] pRefAxis [OUT] pCondition
        [DllImport(dll)]
        public  static extern unsafe int PmSxGetOptSyncMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int pMode, 
            [MarshalAs(UnmanagedType.I4)] ref int pRefAxis,
            [MarshalAs(UnmanagedType.I4)] ref int pCondition);


        // [IN] NodeId [IN] Channel [IN] Mode [IN] DoChan_local [IN] DoLogic
        [DllImport(dll)]
        public  static extern unsafe int PmSxSetOptSyncOut(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Mode, 
            [MarshalAs(UnmanagedType.I4)] int DoChan_local,
            [MarshalAs(UnmanagedType.I4)] int DoLogic);


        // [IN] NodeId [IN] Channel [OUT] pMode [OUT] pDoChan_local [OUT] pDoLogic
        [DllImport(dll)]
        public  static extern unsafe int PmSxGetOptSyncOut(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pMode, 
            [MarshalAs(UnmanagedType.I4)] ref int pDoChan_local, 
            [MarshalAs(UnmanagedType.I4)] ref int pDoLogic);




        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (PM-MX)
        //////////////////////////////////////////////////////////////////////////


        // [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2]
        [DllImport(dll)]
        public  static extern unsafe int PmMxMoveStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel, 
            [MarshalAs(UnmanagedType.I4)] int ChannelMask,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] DistList);


        // [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2] [IN] IsBlocking
        [DllImport(dll)]
        public  static extern unsafe int PmMxMove(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int NumChannel, 
            [MarshalAs(UnmanagedType.I4)] int ChannelMask,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] DistList, 
            [MarshalAs(UnmanagedType.I4)] int IsBlocking);


        // [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] PosList[2]
        [DllImport(dll)]
        public  static extern unsafe int PmMxMoveToStart
            ([MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel, 
            [MarshalAs(UnmanagedType.I4)] int ChannelMask,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] PosList);


        // [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] PosList[2] [IN] IsBlocking
        [DllImport(dll)]
        public  static extern unsafe int PmMxMoveTo(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] int ChannelMask, 
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] PosList,
            [MarshalAs(UnmanagedType.I4)] int IsBlocking);


        // [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DirMask
        [DllImport(dll)]
        public  static extern unsafe int PmMxVMoveStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] int ChannelMask,
            [MarshalAs(UnmanagedType.I4)] int DirMask);


        // [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] IsWaitComplete
        [DllImport(dll)]
        public  static extern unsafe int PmMxStop(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] int ChannelMask,
            [MarshalAs(UnmanagedType.I4)] int IsWaitComplete);


        // [IN] NodeId [IN] NumChannel [IN] ChannelMask 
        [DllImport(dll)]
        public  static extern unsafe int PmMxStopEmg(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel, 
            [MarshalAs(UnmanagedType.I4)] int ChannelMask);


        // [IN] NodeId [IN] NumChannel [IN] ChannelMask [OUT] pIsDone
        [DllImport(dll)]
        public  static extern unsafe int PmMxIsDone(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] int ChannelMask,
            [MarshalAs(UnmanagedType.I4)] ref int pIsDone);


        // [IN] NodeId [IN] NumChannel [IN] ChannelMask 
        [DllImport(dll)]
        public  static extern unsafe int PmMxWaitDone(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int NumChannel,
            [MarshalAs(UnmanagedType.I4)] int ChannelMask);




        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (PM-IX)
        //////////////////////////////////////////////////////////////////////////


        // [IN] NodeId [IN] MapIndex [IN] MapMask
        [DllImport(dll)]
        public  static extern unsafe int PmIxMapAxes(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] int MapMask);


        // [IN] NodeId [IN] MapIndex 
        [DllImport(dll)]
        public  static extern unsafe int PmIxUnMapAxes(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex);


        // [IN] NodeId [IN] MapIndex [IN] VelCorrOpt1 [IN] VelCorrOpt2
        [DllImport(dll)]
        public  static extern unsafe int PmIxSetVelCorrMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] int VelCorrOpt1, 
            [MarshalAs(UnmanagedType.I4)] int VelCorrOpt2);


        // [IN] NodeId [IN] MapIndex [OUT] pVelCorrOpt1 [OUT] pVelCorrOpt2
        [DllImport(dll)]
        public  static extern unsafe int PmIxGetVelCorrMode(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int VelCorrOpt1, 
            [MarshalAs(UnmanagedType.I4)] ref int VelCorrOpt2);


        // [IN] NodeId [IN] MapIndex [IN] IsVectorSpeed [IN] SpeedMode [IN] Vel [IN] Acc [IN] Dec
        [DllImport(dll)]
        public  static extern unsafe int PmIxSetSpeedPattern(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] int IsVectorSpeed, 
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double Vel,
            [MarshalAs(UnmanagedType.R8)] double Acc,
            [MarshalAs(UnmanagedType.R8)] double Dec);


        // [IN] NodeId [IN] MapIndex [OUT] pIsVectorSpeed [OUT] pSpeedMode [OUT] pVel [OUT] pAcc [OUT] pDec
        [DllImport(dll)]
        public  static extern unsafe int PmIxGetSpeedPattern(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int IsVectorSpeed, 
            [MarshalAs(UnmanagedType.I4)] ref int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] ref double Vel, 
            [MarshalAs(UnmanagedType.R8)] ref double Acc,
            [MarshalAs(UnmanagedType.R8)] ref double Dec);


        // [IN] NodeId [IN] MapIndex [IN] IsVectorSpeed [IN] SpeedMode [IN] Vel [IN] AccTime [IN] DecTime
        [DllImport(dll)]
        public  static extern unsafe int PmIxSetSpeedPattern_T(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.I4)] int IsVectorSpeed, 
            [MarshalAs(UnmanagedType.I4)] int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] double Vel,
            [MarshalAs(UnmanagedType.R8)] double AccTime, 
            [MarshalAs(UnmanagedType.R8)] double DecTime);


        // [IN] NodeId [IN] MapIndex [OUT] pIsVectorSpeed [OUT] pSpeedMode [OUT] pVel [OUT] pAccTime [OUT] pDecTime
        [DllImport(dll)]
        public  static extern unsafe int PmIxSetSpeedPattern_T(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int IsVectorSpeed,
            [MarshalAs(UnmanagedType.I4)] ref int SpeedMode,
            [MarshalAs(UnmanagedType.R8)] ref double Vel, 
            [MarshalAs(UnmanagedType.R8)] ref double AccTime, 
            [MarshalAs(UnmanagedType.R8)] ref double DecTime);


        // [IN] NodeId [IN] MapIndex [IN] pDistList
        [DllImport(dll)]
        public  static extern unsafe int PmIxLineStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] DistList);
        

        // [IN] NodeId [IN] MapIndex [IN] pPosList
        [DllImport(dll)]
        public  static extern unsafe int PmIxLineToStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.LPArray, ArraySubType = UnmanagedType.R8)] double[] pPosList);


        // [IN] NodeId [IN] MapIndex [IN] XCentOffset [IN] YCentOffset [IN] EndAngle
        [DllImport(dll)]
        public  static extern unsafe int PmIxArcAStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double YCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle);


        // [IN] NodeId [IN] MapIndex [IN] XCent [IN] YCent [IN] EndAngle
        [DllImport(dll)]
        public  static extern unsafe int PmIxArcAToStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double XCent,
            [MarshalAs(UnmanagedType.R8)] double YCent, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle);


        // [IN] NodeId [IN] MapIndex [IN] XCentOffset [IN] YCentOffset [IN] XEndPointDist [IN] YEndPointDist [IN] Direction
        [DllImport(dll)]
        public  static extern unsafe int PmIxArcPStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.R8)] double XCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double YCentOffset, 
            [MarshalAs(UnmanagedType.R8)] double XEndPointDist,
            [MarshalAs(UnmanagedType.R8)] double YEndPointDist, 
            [MarshalAs(UnmanagedType.I4)] int Direction);


        // [IN] NodeId [IN] MapIndex [IN] XCent [IN] YCent [IN] XEndPoint [IN] YEndPoint [IN] Direction
        [DllImport(dll)]
        public  static extern unsafe int PmIxArcPToStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double XCent,
            [MarshalAs(UnmanagedType.R8)] double YCent,
            [MarshalAs(UnmanagedType.R8)] double XEndPoint, 
            [MarshalAs(UnmanagedType.R8)] double YEndPoint,
            [MarshalAs(UnmanagedType.I4)] int Direction);


        // [IN] NodeId [IN] MapIndex [IN] P2X [IN] P2Y [IN] P3X [IN] P3Y [IN] EndAngle
        [DllImport(dll)]
        public  static extern unsafe int PmIxArc3PStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double P2X, 
            [MarshalAs(UnmanagedType.R8)] double P2Y,
            [MarshalAs(UnmanagedType.R8)] double P3X, 
            [MarshalAs(UnmanagedType.R8)] double P3Y, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle);


        // [IN] NodeId [IN] MapIndex [IN] P2X [IN] P2Y [IN] P3X [IN] P3Y [IN] EndAngle
        [DllImport(dll)]
        public  static extern unsafe int PmIxArc3PToStart(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex, 
            [MarshalAs(UnmanagedType.R8)] double P2X, 
            [MarshalAs(UnmanagedType.R8)] double P2Y,
            [MarshalAs(UnmanagedType.R8)] double P3X,
            [MarshalAs(UnmanagedType.R8)] double P3Y, 
            [MarshalAs(UnmanagedType.R8)] double EndAngle);


        // [IN] NodeId [IN] MapIndex 
        [DllImport(dll)]
        public  static extern unsafe int PmIxStop(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex);


        // [IN] NodeId [IN] MapIndex 
        [DllImport(dll)]
        public  static extern unsafe int PmIxStopEmg(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int MapIndex);


        // [IN] NodeId [IN] MapIndex 
        [DllImport(dll)]
        public  static extern unsafe int PmIxIsDone(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex,
            [MarshalAs(UnmanagedType.I4)] ref int pIsDone);


        // [IN] NodeId [IN] MapIndex 
        [DllImport(dll)]
        public  static extern unsafe int PmIxWaitDone(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int MapIndex);




        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (PM-Override)
        //////////////////////////////////////////////////////////////////////////


        // [IN] NodeId [IN] Channel 
        [DllImport(dll)]
        public  static extern unsafe int PmOverrideSpeedSet(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel);


        // [IN] NodeId [IN] ChannelMask 
        [DllImport(dll)]
        public  static extern unsafe int PmOverrideSpeedSetAll(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int ChannelMask);


        // [IN] NodeId [IN] Channel [IN] NewDistance [IN] IsHardApply [OUT] pAppliedState
        [DllImport(dll)]
        public  static extern unsafe int PmOverrideMove(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.R8)] double NewDistance,  
            [MarshalAs(UnmanagedType.I4)] int isHardApply, 
            [MarshalAs(UnmanagedType.I4)] ref int pAppliedState);


        // [IN] NodeId [IN] Channel [IN] NewPosition [IN] IsHardApply [OUT] pAppliedState
        [DllImport(dll)]
        public  static extern unsafe int PmOverrideMoveTo(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.R8)] double NewPosition,
            [MarshalAs(UnmanagedType.I4)] int isHardApply,
            [MarshalAs(UnmanagedType.I4)] ref int pAppliedState);




        //////////////////////////////////////////////////////////////////////////
        // NETIO Functions (PM-ST)
        //////////////////////////////////////////////////////////////////////////


        // [IN] NodeId [IN] Channel [IN] Target [IN] Count
        [DllImport(dll)]
        public  static extern unsafe int PmStSetCount(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Target, 
            [MarshalAs(UnmanagedType.I4)] int Count);


        // [IN] NodeId [IN] Channel [IN] Source [OUT] pCount
        [DllImport(dll)]
        public  static extern unsafe int PmStGetCount(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Target, 
            [MarshalAs(UnmanagedType.I4)] ref int pCount);


        // [IN] NodeId [IN] Channel [IN] Target [IN] Position
        [DllImport(dll)]
        public  static extern unsafe int PmStSetPosition(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Target,
            [MarshalAs(UnmanagedType.R8)] double Position);


        // [IN] NodeId [IN] Channel [IN] Target [OUT] pPosition
        [DllImport(dll)]
        public  static extern unsafe int PmStGetPosition(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Target, 
            [MarshalAs(UnmanagedType.R8)] ref double pPosition);


        // [IN] NodeId [IN] Channel [IN] Target [OUT] pSpeed
        [DllImport(dll)]
        public  static extern unsafe int PmStGetSpeed(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] int Target, 
            [MarshalAs(UnmanagedType.R8)] ref double pSpeed);


        // [IN] NodeId [IN] Channel [OUT] pMotStates
        [DllImport(dll)]
        public  static extern unsafe int PmStReadMotionState(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel,
            [MarshalAs(UnmanagedType.I4)] ref int pMotStates);


        // [IN] NodeId [IN] Channel [OUT] pMioStates
        [DllImport(dll)]
        public  static extern unsafe int PmStReadMIOStatus(
            [MarshalAs(UnmanagedType.I4)] int BoardId, 
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int pMioStates);


        // [IN] NodeId [IN] Channel [OUT] pIsLatched
        [DllImport(dll)]
        public  static extern unsafe int PmLtcIsLatched(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId, 
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] ref int pIsLatched);


        // [IN] NodeId [IN] Channel [IN] Counter [OUT] pLatchedPos
        [DllImport(dll)]
        public  static extern unsafe int PmLtcReadLatch(
            [MarshalAs(UnmanagedType.I4)] int BoardId,
            [MarshalAs(UnmanagedType.I4)] int NodeId,
            [MarshalAs(UnmanagedType.I4)] int Channel, 
            [MarshalAs(UnmanagedType.I4)] int Counter,
            [MarshalAs(UnmanagedType.R8)] ref double pLatchedPos);

    }
}