/*******************************************************************************
* [ ComiMLink2_SDK.h ]
* Header file for definitions of constants and data in Mechatrolink-2 library
* - Update Data: 2016/02/01
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#ifndef __COMI_MLINK2_SDK_H__
#define __COMI_MLINK2_SDK_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ComiMLink2_SDK_Def.h"

#if !defined(__in)
#define __in
#endif

#if !defined(__in_opt)
#define __in_opt
#endif

#if !defined(__out)
#define __out
#endif

#if !defined(__out_opt)
#define __out_opt
#endif

#if !defined(__inout)
#define	__inout
#endif

#ifdef __cplusplus
extern "C"{
#endif

#ifdef _DLL_MAIN_CPP_
	#define EXTERN 
#else 
	#define EXTERN extern
#endif

//////////////////////////////////////////////////////////////////////////
// External Functions for DLL(Dynamic Link Library)
//////////////////////////////////////////////////////////////////////////
BOOL cmlLoadDll();
VOID cmlUnloadDll();

//////////////////////////////////////////////////////////////////////////
// Low Level API for Debugging
//////////////////////////////////////////////////////////////////////////
EXTERN VOID 	(WINAPI *cmlGetResources)		(__in LONG BoardId, __out PULONG pdwIntVect, __out PULONG pdwIoPorts, __in INT nNumPorts, __out PULONG pdwMemPorts, __in INT nNumMemPorts);
EXTERN VOID 	(WINAPI *cmlWriteMemPortDW)		(__in LONG BoardId, __in  ULONG dwPortBase, __in ULONG nOffset, __in LONG dwWriteVal);
EXTERN DWORD	(WINAPI *cmlReadMemPortDW)		(__in LONG BoardId, __in  ULONG dwPortBase, __in ULONG nOffset, __out PLONG pdwReadVal);
EXTERN DWORD	(WINAPI *cmlDpramRead)			(__in LONG BoardId, __in LONG StartAddr, __in LONG Size, __out PBYTE pBuffer);
EXTERN DWORD	(WINAPI *cmlDpramWrite)			(__in LONG BoardId, __in LONG StartAddr, __in LONG Size, __in PBYTE pBuffer);
EXTERN DWORD	(WINAPI *cmlDpramBusyEnable)	(__in LONG BoardId, __in LONG SectId, __in LONG IsWaitEnable, __in LONG TimeoutVal);
EXTERN DWORD	(WINAPI *cmlDpramBusyDisable)	(__in LONG BoardId, __in LONG SectId);

//////////////////////////////////////////////////////////////////////////
// Device Load / Unload
//////////////////////////////////////////////////////////////////////////
// [OUT] VT_PI4 NumDevices : ġ ̽  ȯմϴ. , [OUT] VT_PI4 BoardIDList : ġ ̽ ID 迭 ȯմϴ. , [OUT] VT_PI4 NumServos :  ̺  ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnLoadDevice)		(__out PLONG NumDevices, __out PLONG BoardIDList, __out PLONG NumServos);
// ġ εմϴ.
EXTERN LONG		(WINAPI *cmlGnUnloadDevice)		();

//////////////////////////////////////////////////////////////////////////
// General Functions
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 ResetMask : ̽ ʱȭմϴ.
EXTERN LONG		(WINAPI *cmlGnResetDevice)		(__in LONG BoardId, __in LONG ResetMask);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 dwIsOn :  ¸ մϴ.   (1:  , 0:  )
EXTERN LONG		(WINAPI *cmlGnSetServoOn)		(__in LONG BoardId, __in LONG Axis, __in LONG  dwIsOn);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 pdwIsOn :  ¸ ȯմϴ. (1:  , 0:  )
EXTERN LONG		(WINAPI *cmlGnGetServoOn)		(__in LONG BoardId, __in LONG Axis, __out PLONG pdwIsOn);
// [IN] VT_I4 Axis : ȣ :  ˶ ʱȭմϴ.
EXTERN LONG		(WINAPI *cmlGnSetAlarmRes)		(__in LONG BoardId, __in   LONG Axis);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 IsReset :   ˶ ¸ ȯմϴ. (1: ˶ , 0: ˶  )
EXTERN LONG		(WINAPI *cmlGnGetAlarmRes)		(__in LONG BoardId, __in LONG Axis, __out LONG * IsReset);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsDecStop :     θ մϴ.   (1:  , 0: ), [IN] VT_I4 IsEnable : Emergency  θ մϴ.
EXTERN LONG		(WINAPI *cmlGnSetEmergency)		(__in LONG BoardId, __in LONG Axis, __in LONG IsDecStop, __in LONG IsEnable);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 IsDecStop :     θ ȯմϴ. (1:  , 0: ), [OUT] VT_PI4 IsEnabled : Emergency  θ ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnGetEmergency)		(__in LONG BoardId, __in LONG Axis, __out PLONG IsDecStopped, __out PLONG IsEnabled);
// [IN] VT_I4 IsDecStop :     θ մϴ.   (1:  , 0: ), [IN] VT_I4 IsEnable : Emergency  θ մϴ.
EXTERN LONG		(WINAPI *cmlGnSetEmergencyAll)	(__in LONG IsDecStop, __in LONG IsEnable);
// [OUT] VT_PI4 IsDecStop :     θ ȯմϴ. (1:  , 0: ), [OUT] VT_PI4 IsEnabled : Emergency  θ ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnGetEmergencyAll)	(__out PLONG IsDecStopped, __out PLONG IsEnabled);
// [IN] VT_I4 nPeriod : Sampling Period մϴ. (5000/10000/15000)
EXTERN LONG		(WINAPI *cmlGnSetCommPeriod)	(__in LONG BoardId, __in LONG nPeriod);
// [OUT] VT_PI4 nPeriod : Sampling Period ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnGetCommPeriod)	(__in LONG BoardId, __out PLONG nPeriod);
// [OUT] AxisMapMask :  忡  ̺  ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnGetAxisMap)		(__in LONG BoardId, __out PLONG AxisMapMask);
// [NONE]  忡  ̺  ʱȭմϴ.
EXTERN LONG		(WINAPI *cmlGnResetComm)		(__in LONG BoardId);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 cmStsId :   ID մϴ. , [IN] VT_I4 CommStsVal :    մϴ.
EXTERN LONG		(WINAPI *cmlGnSetCommStates)	(__in LONG BoardId, __in LONG Axis, __in LONG cmStsId, __in LONG CommStsVal);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 cmStsId :   ID մϴ. , [OUT] VT_PI4 CommStsVal :    ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnGetCommStates)	(__in LONG BoardId, __in LONG Axis, __in LONG cmStsId, __out PLONG CommStsVal);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_TSlaveInfo SlaveInfo : ̺  ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnGetNodeInfo)		(__in LONG BoardId, __in LONG Axis, __out cmlSlaveInfo* SlaveInfo);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 Channel : DIO ä  ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnTotalDIOChannel)	(__in LONG BoardId, __in LONG Axis, __out PLONG Channel);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 Channel : AI ä  ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnTotalAIChannel)	(__in LONG BoardId, __in LONG Axis, __out PLONG Channel);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 Channel : AO ä  ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnTotalAOChannel)	(__in LONG BoardId, __in LONG Axis, __out PLONG Channel);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 EncoderMode : ڴ 带 մϴ.
EXTERN LONG (WINAPI *cmlGnSetABSMode)			(__in LONG BoardId, __in LONG Axis, __in LONG EncoderMode);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 EncoderMode : ڴ 带 ȯմϴ.
EXTERN LONG (WINAPI *cmlGnGetABSMode)			(__in LONG BoardId, __in LONG Axis, __out PLONG EncoderMode);
// [NONE]  ̽  ̹ ڴ 带 Ȯ, ¸ մϴ.
EXTERN LONG (WINAPI *cmlGnABSUpdate)			(__in LONG BoardId);
// [IN] VT_I4 Axis : ȣ, ġ ڴ   ش   ġ  մϴ.
EXTERN LONG (WINAPI *cmlGnSetABSHome)			(__in LONG BoardId, __in LONG Axis);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 AlarmCode :  ˶ ڵ带 ȯմϴ.
EXTERN LONG (WINAPI *cmlGnGetAlarmCode)			(__in LONG BoardId, __in LONG Axis, __out PLONG AlarmCode);

//////////////////////////////////////////////////////////////////////////
// Log function
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 LogMode : Log Mode մϴ.
EXTERN LONG		(WINAPI *cmlGnSetLogMode)		(__in  LONG LogMode);
// [OUT] VT_PI4 LogMode :  Log Mode ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnGetLogMode)		(__out PLONG LogMode);
// [IN] VT_I4 LogMode : Log Level մϴ.
EXTERN LONG		(WINAPI *cmlGnSetLogLevel)		(__in  LONG LogLevel);
// [OUT] VT_PI4 LogMode :  Log Level ȯմϴ.
EXTERN LONG		(WINAPI *cmlGnGetLogLevel)		(__out PLONG LogLevel);
// [IN] VT_I4 FuncIndex : Լ  ȣ, [IN] VT_I4 LogLevel : ش Լ Log Level մϴ.
EXTERN LONG	(WINAPI *cmlGnSetFuncLevel)		(__in LONG FuncIndex, __in  LONG LogLevel);
// [IN] VT_I4 FuncIndex : Լ  ȣ(ش Լ Log Level ʱⰪ մϴ.)
EXTERN LONG	(WINAPI *cmlGnRestoreFuncLevel)	(__in LONG FuncIndex);
// [IN] VT_I4 FuncIndex : Լ  ȣ, [OUT] VT_PI4 LogLevel : ش Լ Log Level ȯմϴ.
EXTERN LONG	(WINAPI *cmlGnGetFuncLevel)		(__in LONG FuncIndex, __out PLONG LogLevel);

//////////////////////////////////////////////////////////////////////////
// Cfg Functions
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PropId :  id մϴ, [IN] VT_I4 PropVal :  id 
EXTERN	LONG	(WINAPI *cmlCfgSetMioProperty)		(__in LONG BoardId, __in	LONG Axis, __in LONG PropId, __in  LONG  PropVal);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PropId :  id մϴ, [OUT] VT_PI4 PropVal :  id 
EXTERN	LONG	(WINAPI *cmlCfgGetMioProperty)		(__in LONG BoardId, __in	LONG Axis, __in LONG PropId, __out PLONG PropVal);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 UnitDist :  Ÿ  մϴ.
EXTERN	LONG	(WINAPI *cmlCfgSetUnitDist)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE UnitDist);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PR8 UnitDist :  Ÿ  ȯմϴ.
EXTERN	LONG	(WINAPI *cmlCfgGetUnitDist)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE * UnitDist);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 UnitSpeed :  ӵ  մϴ.
EXTERN	LONG	(WINAPI *cmlCfgSetUnitSpeed)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE UnitSpeed);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PR8 UnitSpeed :  ӵ  ȯմϴ.
EXTERN	LONG	(WINAPI *cmlCfgGetUnitSpeed)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE * UnitSpeed);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 SpeedMode([0]Constant, [1]Trapezoidal, [2]S-Curve) [IN] VT_R8 Work/Workspeed, [IN] VT_R8 Acc/Acceleration , [IN] VT_R8 Dec/Deceleration, [IN] VT_R8 Ini/IniSpeed, [IN] VT_R8 End/EndSpeed 
EXTERN  LONG    (WINAPI *cmlCfgSetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __in LONG SpeedMode, __in DOUBLE Work, __in DOUBLE Acc, __in DOUBLE Dec, __in DOUBLE Ini, __in DOUBLE End);	
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 SpeedMode([0]Constant, [1]Trapezoidal, [2]S-Curve) [OUT] VT_PR8 Work/Workspeed, [OUT] VT_PR8 Acc/Acceleration , [OUT] VT_PR8 Dec/Deceleration, [OUT] VT_PR8 Ini/IniSpeed, [OUT] VT_PR8 End/EndSpeed 
EXTERN  LONG    (WINAPI *cmlCfgGetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __out PLONG SpeedMode, __out DOUBLE * Work, __out DOUBLE * Acc, __out DOUBLE * Dec, __out DOUBLE * Ini, __out DOUBLE * End);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 SpeedMode([0]Constant, [1]Trapezoidal, [2]S-Curve) [IN] VT_R8 Work/Workspeed, [IN] VT_R8 Acceleration Time , [IN] VT_R8 Deceleration Time, [IN] VT_R8 Ini/IniSpeed, [IN] VT_R8 End/EndSpeed 
EXTERN LONG		(WINAPI *cmlCfgSetSpeedPattern_T)	(__in LONG BoardId, __in LONG Axis, __in LONG SpeedMode, __in DOUBLE Work, __in DOUBLE AccTime, __in DOUBLE DecTime, __in DOUBLE Ini, __in DOUBLE End);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 SpeedMode([0]Constant, [1]Trapezoidal, [2]S-Curve) [OUT] VT_PR8 Work/Workspeed, [OUT] VT_PR8 Acceleration Time, [OUT] VT_PR8 Deceleration Time, [OUT] VT_PR8 Ini/IniSpeed, [OUT] VT_PR8 End/EndSpeed 
EXTERN LONG		(WINAPI *cmlCfgGetSpeedPattern_T) (__in LONG BoardId, __in LONG Axis, __out PLONG SpeedMode, __out DOUBLE * Work, __out DOUBLE * AccTime, __out DOUBLE * DecTime, __out DOUBLE * Ini, __out DOUBLE * End);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsEnable : Ʈ   Ȱȭ θ մϴ, [IN] VT_R8 LimitN : (-) Limit, [IN] VT_R8 LimitP : (+) Limit
EXTERN	LONG	(WINAPI *cmlCfgSetSoftLimit)		(__in LONG BoardId, __in LONG Axis, __in LONG IsEnable, __in DOUBLE LimitN, __in DOUBLE LimitP);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 IsEnabled : Ʈ   Ȱȭ θ ȯմϴ, [OUT] VT_R8 LimitN : (-) Limit, [OUT] VT_R8 LimitP : (+) Limit
EXTERN	LONG	(WINAPI *cmlCfgGetSoftLimit)		(__in LONG BoardId, __in LONG Axis, __out PLONG IsEnabled, __out DOUBLE * LimitN, __out DOUBLE * LimitP);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 CorrRatio :  ۾ ӵ ʰ մϴ.
EXTERN LONG		(WINAPI *cmlCfgSetVelCorrRatio)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE CorrRatio);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PR8 CorrRatio :  ۾ ӵ ʰ ȯմϴ.
EXTERN LONG		(WINAPI *cmlCfgGetVelCorrRatio)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE * CorrRatio);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 Enable :  ī  Ȱȭ θ մϴ, [IN] VT_I4 nMinCnt : ī ּġ, [IN] VT_I4 nMaxCnt : ī ִġ
EXTERN LONG (WINAPI *cmlCfgSetRingCntr)			(__in LONG BoardId, __in LONG Axis, __in LONG Enable, __in LONG nMinCnt, __in LONG nMaxCnt);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 Enable :  ī  Ȱȭ θ ȯմϴ, [OUT] VT_PI4 nMinCnt : ī ּġ, [OUT] VT_PI4 nMaxCnt : ī ִġ
EXTERN LONG (WINAPI *cmlCfgGetRingCntr)			(__in LONG BoardId, __in LONG Axis, __out PLONG Enable,  __out PLONG nMinCnt, __out PLONG nMaxCnt);

//////////////////////////////////////////////////////////////////////////
// Sx Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Distance : Ÿ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN	LONG	(WINAPI *cmlSxMove)			(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Distance, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Distance : Ÿ
EXTERN	LONG	(WINAPI *cmlSxMoveStart)		(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Distance);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Position : ġ, [IN] VT_I4  IsBlocking :  ޽ ŷ 
EXTERN	LONG	(WINAPI *cmlSxMoveTo)			(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Position, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Position : ġ
EXTERN	LONG	(WINAPI *cmlSxMoveToStart)		(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Position);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 Dir : 
EXTERN	LONG	(WINAPI *cmlSxVMoveStart)		(__in LONG BoardId, __in	LONG Axis, __in LONG Dir);
// [IN] VT_I4 Axis : ȣ
EXTERN  LONG	(WINAPI *cmlSxStop)			(__in LONG BoardId, __in	LONG Axis);
// [IN] VT_I4 Axis : ȣ
EXTERN	LONG	(WINAPI *cmlSxStopEmg)			(__in LONG BoardId, __in	LONG Axis);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 pdwIsDone : ̼ ϷǾ ȯ(0:̼, 1:̼ۿϷ)
EXTERN	LONG	(WINAPI *cmlSxIsDone)			(__in LONG BoardId, __in	LONG Axis, __out PLONG pdwIsDone);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsBlocking :  ޼ ŷ 
EXTERN  LONG	(WINAPI *cmlSxWaitDone)		(__in LONG BoardId, __in	LONG Axis, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 CorrMode :     (0:  Ȱȭ, 1: 鷡  , 2:   ), [IN] VT_R8 CorrAmount :  ޽  ( Ÿ ), [IN] VT_I4 CntrMask :  ޽ ½ÿ  ī    (BIT0 1: Command Counter , BIT1 1: Feedback Counter , BIT2 1: Deviation Counter , BIT3 1: General Counter )
EXTERN	LONG	(WINAPI *cmlSxSetCorrection)		(__in LONG BoardId, __in	LONG Axis, __in  LONG CorrMode,	__in  DOUBLE   CorrAmount,__in   DOUBLE   CorrVel, __in  LONG  CntrMask);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 CorrMode :   ȯ  (0:  Ȱȭ, 1: 鷡  , 2:   ), [IN] VT_R8 CorrAmount :  ޽  ( Ÿ ), [IN] VT_I4 CntrMask :  ޽ ½ÿ  ī    (BIT0 1: Command Counter , BIT1 1: Feedback Counter , BIT2 1: Deviation Counter , BIT3 1: General Counter )
EXTERN	LONG	(WINAPI *cmlSxGetCorrection)		(__in LONG BoardId, __in	LONG Axis, __out PLONG CorrMode,__out DOUBLE * CorrAmount, __out DOUBLE * CorrVel, __out PLONG CntrMask);

//////////////////////////////////////////////////////////////////////////
// Mx Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 DistList : Ÿ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmlMxMove)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * DistList, __in LONG IsBlocking);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 DistList : Ÿ Ʈ
EXTERN LONG	(WINAPI *cmlMxMoveStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * DistList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 PosList : ġ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmlMxMoveTo)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * PosList, __in LONG IsBlocking);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 PosList : ġ Ʈ
EXTERN LONG	(WINAPI *cmlMxMoveToStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * PosList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PI4 DirList :  Ʈ
EXTERN LONG	(WINAPI *cmlMxVMoveStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in PLONG DirList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList :   ȣ Ʈ
EXTERN LONG	(WINAPI *cmlMxStop)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList :   ȣ Ʈ
EXTERN LONG	(WINAPI *cmlMxStopEmg)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_I4 IsDone: Ϸ 
EXTERN LONG	(WINAPI *cmlMxIsDone)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __out PLONG IsDone);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmlMxWaitDone)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in LONG IsBlocking);

//////////////////////////////////////////////////////////////////////////
// Ix Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 MapMask : ʸũ, [IN] VT_I4 IxMode : ̼  (0:, 1:ȣ, 2:︮ú, 3:öκ)
EXTERN LONG	(WINAPI *cmlIxMapAxes)			(__in LONG BoardId, __in LONG MapIndex, __in LONG MapMask, __in LONG IxMode);
// [IN] VT_I4 MapIndex : ʹȣ
EXTERN LONG	(WINAPI *cmlIxUnMapAxes)		(__in LONG BoardId, __in LONG MapIndex);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 IsVectorSpeed : ǵ (0:ͽǵ , 1:ͽǵ ), [IN] VT_I4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [IN] VT_R8 Ini : ʱӵ, [IN] VT_R8 End : ӵ, [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 Acc : ӵ, [IN] VT_R8 Dec : ӵ
EXTERN LONG	(WINAPI *cmlIxSetSpeedPattern)		(__in LONG BoardId, __in LONG MapIndex, __in  LONG  IsVectorSpeed, __in  LONG  SpeedMode, __in  DOUBLE   Ini, __in  DOUBLE   End, __in  DOUBLE   Vel, __in  DOUBLE Acc, __in  DOUBLE Dec);
// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 IsVectorSpeed : ǵ (0:ͽǵ , 1:ͽǵ ), [OUT] VT_PI4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [OUT] VT_PR8 Ini : ʱӵ, [OUT] VT_PR8 End : ӵ, [OUT] VT_PR8 Vel : ۾ӵ, [OUT] VT_PR8 Acc : ӵ, [OUT] VT_PR8 Dec : ӵ
EXTERN LONG	(WINAPI *cmlIxGetSpeedPattern)		(__in LONG BoardId, __in LONG MapIndex, __out PLONG IsVectorSpeed, __out PLONG SpeedMode, __out DOUBLE * Ini, __out DOUBLE * End, __out DOUBLE * Vel, __out DOUBLE * Acc, __out DOUBLE * Dec);

EXTERN LONG	(WINAPI *cmlIxSetSpeedPattern_T)		(__in LONG BoardId, __in LONG MapIndex, __in LONG IsVectorSpeed, __in LONG SpeedMode, __in DOUBLE Ini, __in DOUBLE End, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime);

EXTERN LONG	(WINAPI *cmlIxGetSpeedPattern_T)		(__in LONG BoardId, __in LONG MapIndex, __out PLONG IsVectorSpeed, __out PLONG SpeedMode, __out DOUBLE * Ini, __out DOUBLE * End, __out DOUBLE * Vel, __out DOUBLE * AccTime, __out DOUBLE * DecTime); 

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 DistList : Ÿ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmlIxLine)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * DistList, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 DistList : Ÿ Ʈ
EXTERN LONG	(WINAPI *cmlIxLineStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * DistList);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 PosList : ġ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmlIxLineTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * PosList, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 PosList : ġ Ʈ
EXTERN LONG	(WINAPI *cmlIxLineToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * PosList);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmlIxArcA)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE EndAngle, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree)
EXTERN LONG	(WINAPI *cmlIxArcAStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmlIxArcATo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE EndAngle, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree)
EXTERN LONG	(WINAPI *cmlIxArcAToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 XEndPointDist : ǥ ġκ X Ÿ, [IN] VT_R8 YEndPointDist : ǥ ġκ Y Ÿ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmlIxArcP)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE XEndPointDist, __in DOUBLE YEndPointDist, __in LONG Direction, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 XEndPointDist : ǥ ġκ X Ÿ, [IN] VT_R8 YEndPointDist : ǥ ġκ Y Ÿ
EXTERN LONG	(WINAPI *cmlIxArcPStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE XEndPointDist, __in DOUBLE YEndPointDist, __in LONG Direction);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 XEndPos : ǥ X ǥ, [IN] VT_R8 YEndPos : ǥ Y ǥ, [IN] VT_I4 Direction : ȸ(0:ð(CW), 1:ݽð(CCW)), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmlIxArcPTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE XEndPos, __in DOUBLE YEndPos, __in LONG Direction, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 XEndPos : ǥ X ǥ, [IN] VT_R8 YEndPos : ǥ Y ǥ, [IN] VT_I4 Direction : ȸ(0:ð(CW), 1:ݽð(CCW))
EXTERN LONG	(WINAPI *cmlIxArcPToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE XEndPos, __in DOUBLE YEndPos, __in LONG Direction);

EXTERN LONG	(WINAPI *cmlIxArc3P)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle, __in LONG IsBlocking);
EXTERN LONG	(WINAPI *cmlIxArc3PStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle);
EXTERN LONG (WINAPI *cmlIxArc3PTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle, __in LONG IsBlocking);
EXTERN LONG (WINAPI *cmlIxArc3PToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 IsDone : ̼ ϷǾ ȯ(0:̼, 1:̼ۿϷ)
EXTERN LONG	(WINAPI *cmlIxIsDone)			(__in LONG BoardId, __in LONG MapIndex, __out LONG *IsDone);
// [IN] VT_I4 MapINdex : ʹȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmlIxWaitDone) 		(__in LONG BoardId, __in LONG MapIndex, __in  LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 IsWaitComplete : Ϸ  ٸ  , [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmlIxStop) 			(__in LONG BoardId, __in LONG MapIndex, __in  LONG IsWaitComplete, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ
EXTERN LONG	(WINAPI *cmlIxStopEmg) 		(__in LONG BoardId, __in LONG MapIndex);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PI4 Helcoord : 3 ǥ 迭, [IN] VT_I4 ArcAngle : ̼۰(degree)
EXTERN LONG	(WINAPI *cmlIxHelOnceStart) 		(__in LONG BoardId, __in LONG MapIndex, __in LONG * HelCoord, __in LONG ArcAngle);
EXTERN LONG	(WINAPI *cmlIxSplineStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE InArray[20][2], __in LONG  NumInArray, __in LONG NumOutArray);

EXTERN LONG	(WINAPI *cmlIxSpline2_RegRefPoints)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE InArray[], __in LONG  NumInArray, __in LONG RegAxisIndexInIxMap);
EXTERN LONG	(WINAPI *cmlIxSpline2_MoveStart)		(__in LONG BoardId, __in LONG MapIndex);

// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 MapIndex : ش  ϰ ִ MapIndex ȣ
EXTERN LONG	(WINAPI *cmlIxGetMapIndex)		(__in LONG BoardId, __in LONG Axis, __out PLONG MapIndex);

//////////////////////////////////////////////////////////////////////////
// Return to Home
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 ParamId : ϰ ϴ Ķ ID, [IN] VT_I4 ParamVal : Ϸ  밪
EXTERN LONG	(WINAPI *cmlHomeSetConfig)		(__in LONG BoardId, __in LONG Axis, __in LONG ParamId, __in LONG ParamVal);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 ParamId : Ȯϰ ϴ Ķ ID, [OUT] VT_PI4 ParamVal :  ID  
EXTERN LONG	(WINAPI *cmlHomeGetConfig)		(__in LONG BoardId, __in LONG Axis, __in LONG ParamId, __out LONG * ParamVal);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Offset : Ϸ  ߰ ̼ Ÿ 
EXTERN LONG (WINAPI *cmlHomeSetOffset)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE Offset);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PR8 Offset : Ϸ  ߰ ̼ Ÿ  ȯ
EXTERN LONG (WINAPI *cmlHomeGetOffset)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE *Offset);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PhaseID :  Step ȣ, [IN] VT_I4 SpeedMode : ӵ([0]Constant, [1]Trapezoidal, [2]S-Curve) [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 Accel : ӵ, [IN] VT_R8 Decel : ӵ
EXTERN LONG	(WINAPI *cmlHomeSetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __in LONG PhaseID, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE Accel, __in DOUBLE Decel);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PhaseID :  Step ȣ, [OUT] VT_PI4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [OUT] VT_PR8 Vel : ۾ӵ, [OUT] VT_PR8 Accel : ӵ, [OUT] VT_PR8 Decel : ӵ
EXTERN LONG	(WINAPI *cmlHomeGetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __in LONG PhaseID, __out PLONG SpeedMode, __out DOUBLE * Vel, __out DOUBLE * Accel, __out DOUBLE * Decel);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PhaseID :  Step ȣ, [IN] VT_I4 SpeedMode : ӵ([0]Constant, [1]Trapezoidal, [2]S-Curve) [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 AccTime :  ð, [IN] VT_R8 DecTime :  ð
EXTERN LONG	(WINAPI *cmlHomeSetSpeedPattern_T)		(__in LONG BoardId, __in LONG Axis, __in LONG PhaseID, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PhaseID :  Step ȣ, [OUT] VT_PI4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [OUT] VT_PR8 Vel : ۾ӵ, [OUT] VT_PR8 AccTime :  ð, [OUT] VT_PR8 DecTime :  ð
EXTERN LONG	(WINAPI *cmlHomeGetSpeedPattern_T)		(__in LONG BoardId, __in LONG Axis, __in LONG PhaseID, __in PLONG SpeedMode, __out DOUBLE * Vel, __out DOUBLE * AccTime, __out DOUBLE * DecTime);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmlHomeMove)			(__in LONG BoardId, __in LONG Axis, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ,
EXTERN LONG	(WINAPI *cmlHomeMoveStart)		(__in LONG BoardId, __in LONG Axis);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxesList : ϴ  ȣ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmlHomeMoveAll)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxesList, __in LONG IsBlocking);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxesList : ϴ  ȣ Ʈ
EXTERN LONG	(WINAPI *cmlHomeMoveAllStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxesList);
// [IN] VT_I4 Axis : ȣ, [IN] VT_PI4 : IsBusy :  Ͱ  ȯ(0: , 1:)
EXTERN LONG	(WINAPI *cmlHomeIsBusy)		(__in LONG BoardId, __in LONG Axis, __out PLONG IsBusy);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)   
EXTERN LONG	(WINAPI *cmlHomeWaitDone)		(__in LONG BoardId, __in LONG Axis, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 : IsSuccess :     (0: ̿Ϸ, 1: )
EXTERN LONG	(WINAPI *cmlHomeSetSuccess)		(__in LONG BoardId, __in LONG Axis, __in LONG IsSuccess);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 : IsSuccess :    ȯ(0: ̿Ϸ, 1: )
EXTERN LONG	(WINAPI *cmlHomeGetSuccess)		(__in LONG BoardId, __in LONG Axis, __out PLONG IsSuccess);

//////////////////////////////////////////////////////////////////////////
// Override Motion
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Channel : ȣ
EXTERN LONG	(WINAPI *cmlOverrideSpeedSet)		(__in LONG BoardId, __in LONG Channel);
// [IN] VT_I4 Channel : ȣ, [IN] VT_R8 NewDistance : ο ǥ Ÿ, [OUT] VT_PI4 IsIgnored : OverrideMove  /  ȯ  (0:  , 1: )
EXTERN LONG	(WINAPI *cmlOverrideMove)		(__in LONG BoardId, __in LONG Channel, __in DOUBLE NewDistance, __out PLONG IsIgnored);
// [IN] VT_I4 Channel : ȣ, [IN] VT_R8 NewPosition : ο ǥ Ÿ, [OUT] VT_PI4 IsIgnored : OverrideMove  /  ȯ  (0:  , 1: )
EXTERN LONG	(WINAPI *cmlOverrideMoveTo)		(__in LONG BoardId, __in LONG Channel, __in DOUBLE NewPosition, __out PLONG IsIgnored);

//////////////////////////////////////////////////////////////////////////
// Listed Motion
//////////////////////////////////////////////////////////////////////////
EXTERN LONG	(WINAPI *cmlLmxStart)			(__in LONG BoardId, __in LONG	LmIdx, __in LONG LmStartMode, __in LONG AxisMask);
EXTERN LONG	(WINAPI *cmlLmxSuspend)		(__in LONG BoardId, __in LONG	LmIdx, __in LONG SuspendMode);
EXTERN LONG	(WINAPI *cmlLmxResume)			(__in LONG BoardId, __in LONG	LmIdx, __in	LONG ResumeMode);
EXTERN LONG	(WINAPI *cmlLmxEnd)			(__in LONG BoardId, __in LONG	LmIdx);
EXTERN LONG	(WINAPI *cmlLmxGetStates)		(__in LONG BoardId, __in LONG	LmIdx, __in LONG LmStsId, __out PLONG LmxStsVal);

EXTERN LONG (WINAPI *cmlLmxSetSeqMode)		(__in LONG BoardId, __in LONG  LmIdx, __in  LONG SeqMode);
EXTERN LONG	(WINAPI *cmlLmxGetSeqMode)		(__in LONG BoardId, __in LONG  LmIdx, __out PLONG SeqMode);

EXTERN LONG	(WINAPI *cmlLmxSetNextItemId)		(__in LONG BoardId, __in LONG	LmIdx, __in  LONG SeqId);
EXTERN LONG	(WINAPI *cmlLmxGetNextItemId)		(__in LONG BoardId, __in LONG	LmIdx, __out LONG *SeqId);
EXTERN LONG	(WINAPI *cmlLmxSetNextItemParam)	(__in LONG BoardId, __in LONG	LmIdx, __in  LONG ParamIdx, __in  LONG ParamData);
EXTERN LONG	(WINAPI *cmlLmxGetNextItemParam)	(__in LONG BoardId, __in LONG	LmIdx, __in  LONG ParamIdx, __out  PLONG ParamData);
EXTERN LONG	(WINAPI *cmlLmxGetRunItemParam)	(__in LONG BoardId, __in LONG	LmIdx, __in  LONG ParamIdx, __out  PLONG ParamData);

EXTERN LONG	(WINAPI *cmlLmxGetRunItemStaPos)	(__in LONG BoardId, __in LONG 	LmIdx, __in  LONG Axis,     __out DOUBLE * Position);
EXTERN LONG	(WINAPI *cmlLmxGetRunItemTargPos)	(__in LONG BoardId, __in LONG	LmIdx, __in  LONG Axis,     __out DOUBLE * Position);

EXTERN LONG	(WINAPI *cmlLmxSetSeqId)		(__in LONG BoardId, __in LONG LmIdx, __in  LONG SeqId);
EXTERN LONG	(WINAPI *cmlLmxGetSeqId)		(__in LONG BoardId, __in LONG LmIdx, __out PLONG pSeqId);

//////////////////////////////////////////////////////////////////////////
// Status Monitoring
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_I4 pdwCount :  ī (޽ īƮ)
EXTERN LONG	(WINAPI *cmlStSetCount)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __in  LONG pdwCount);
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [OUT] VT_PI4 pdwcount : ī (޽ īƮ)
EXTERN LONG	(WINAPI *cmlStGetCount)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out PLONG pdwCount);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PI4 pdwcount : ī ( īƮ)
EXTERN LONG	(WINAPI *cmlStSetPosition)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __in  DOUBLE Count);
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [OUT] VT_PI4 pdwcount : ī ( īƮ)
EXTERN LONG	(WINAPI *cmlStGetPosition)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out DOUBLE * Count);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [OUT] VT_PR8 Speed :  ӵ ( ӵ)
EXTERN LONG	(WINAPI *cmlStGetSpeed)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out DOUBLE * Speed);

// [IN] VT_I4 Channel : ȣ, [OUT] VT_PR8 Torque :  ũ ()
EXTERN LONG	(WINAPI *cmlStGetTorque)		(__in LONG BoardId, __in LONG Channel, __out LONG * Torque);

// [IN] VT_I4 Channel : ȣ, [OUT] VT_PI4 MotStates
EXTERN LONG	(WINAPI *cmlStSxReadMotionState)	(__in LONG BoardId, __in LONG Channel, __out PLONG MotStates);
// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 MotStates
EXTERN LONG	(WINAPI *cmlStIxReadMotionState)	(__in LONG BoardId, __in LONG MapIndex, __out PLONG MotStates);

// [IN] VT_I4 Channel : ȣ, [OUT] VT_PI4 MioStates : Machine I/O 
EXTERN LONG 	(WINAPI *cmlStReadMioStatuses)		(__in LONG BoardId, __in LONG Channel, __out PLONG MioStates);

EXTERN LONG	(WINAPI *cmlStGetMotionMode)		(__in LONG BoardId, __in LONG Channel, __out PLONG Mode);

EXTERN LONG	(WINAPI *cmlStSxGetLastError)		(__in LONG BoardId, __in LONG Channel, __out PLONG LastError);

EXTERN LONG	(WINAPI *cmlStIxGetLastError)		(__in LONG BoardId, __in LONG MapIndex,__out PLONG LastError);

EXTERN LONG (WINAPI *cmlStSetMultiRevCnt)		(__in LONG BoardId, __in LONG Axis, __in LONG MultiRevCnt);
EXTERN LONG (WINAPI *cmlStGetMultiRevCnt)		(__in LONG BoardId, __in LONG Axis, __out PLONG pMultiRevCnt);

EXTERN LONG (WINAPI *cmlStSetOneRevPos)		(__in LONG BoardId, __in LONG Axis, __in LONG OneRevPos);
EXTERN LONG (WINAPI *cmlStGetOneRevPos)		(__in LONG BoardId, __in LONG Axis, __out PLONG pOneRevPos);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (DI)
/////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [OUT] Logic
EXTERN LONG	(WINAPI *cmlDiGetLogic)		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Logic);

// [IN] Axis [IN] Channel [IN] Logic
EXTERN LONG	(WINAPI *cmlDiSetLogic)		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
EXTERN LONG	(WINAPI *cmlDiGetLogicMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
EXTERN LONG	(WINAPI *cmlDiSetLogicMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG Logic);

// [IN] Axis [IN] Channel [OUT] State
EXTERN LONG	(WINAPI *cmlDiGetOne)			(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
EXTERN LONG	(WINAPI *cmlDiGetMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG State);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (DO)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [OUT] Logic
EXTERN LONG	(WINAPI *cmlDoGetLogic)		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Logic);

// [IN] Axis [IN] Channel [IN] Logic
EXTERN LONG	(WINAPI *cmlDoSetLogic)		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
EXTERN LONG	(WINAPI *cmlDoGetLogicMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
EXTERN LONG	(WINAPI *cmlDoSetLogicMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG Logic);

// [IN] Axis [IN] Channel [IN] State
EXTERN LONG	(WINAPI *cmlDoPutOne)			(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG State);

// [IN] Axis [IN] Channel [OUT] State
EXTERN LONG	(WINAPI *cmlDoGetOne)			(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] State
EXTERN LONG	(WINAPI *cmlDoPutMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
EXTERN LONG	(WINAPI *cmlDoGetMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG State);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (DIO)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [OUT] InOutMode
EXTERN LONG	(WINAPI *cmlDioGetIomode)		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG InOutMode);

// [IN] Axis [IN] Channel [IN] InOutMode
EXTERN LONG	(WINAPI *cmlDioSetIomode)		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG InOutMode);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] InOutMode
EXTERN LONG	(WINAPI *cmlDioGetIomodeMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG InOutMode);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] InOutMode
EXTERN LONG	(WINAPI *cmlDioSetIomodeMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG InOutMode);

// [IN] Axis [IN] Channel [OUT] Logic
EXTERN LONG	(WINAPI *cmlDioGetLogic)		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Logic);

// [IN] Axis [IN] Channel [IN] Logic
EXTERN LONG	(WINAPI *cmlDioSetLogic)		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
EXTERN LONG	(WINAPI *cmlDioGetLogicMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
EXTERN LONG	(WINAPI *cmlDioSetLogicMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG Logic);

// [IN] Axis [IN] Channel [IN] State
EXTERN LONG	(WINAPI *cmlDioPutOne)			(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG State);

// [IN] Axis [IN] Channel [OUT] State
EXTERN LONG	(WINAPI *cmlDioGetOne)			(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] State
EXTERN LONG	(WINAPI *cmlDioPutMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
EXTERN LONG	(WINAPI *cmlDioGetMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG State);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (AI)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [IN] Mode
EXTERN LONG	(WINAPI *cmlAiSetVoltRangeMode) 	(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Mode);

// [IN] Axis [IN] Channel [OUT] Mode
EXTERN LONG	(WINAPI *cmlAiGetVoltRangeMode) 	(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Mode);

// [IN] Axis [IN] Channel [OUT] Dmin [OUT] Dmax
EXTERN LONG	(WINAPI *cmlAiGetRangeDigit) 		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Dmin, __out PLONG Dmax);

// [IN] Axis [IN] Channel [OUT] Digit
EXTERN LONG	(WINAPI *cmlAiGetDigit)		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Digit);

// [IN] Axis [IN] Channel [OUT] Volt
EXTERN LONG	(WINAPI *cmlAiGetVolt) 		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out DOUBLE * Volt);

// [IN] Axis [IN] Channel [OUT] Current
EXTERN LONG	(WINAPI *cmlAiGetCurrent) 		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out DOUBLE * Current);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (AO)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [IN] Digit
EXTERN LONG	(WINAPI *cmlAoOutDigit)		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Digit);

// [IN] Axis [IN] Channel [IN] Volt
EXTERN LONG	(WINAPI *cmlAoOutVolt) 		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in DOUBLE Volt);

// [IN] Axis [IN] Channel [IN] Current
EXTERN LONG	(WINAPI *cmlAoOutCurrent) 		(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in DOUBLE Current);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-GN)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] IsOn
EXTERN LONG 	(WINAPI *cmlPmGnSetServoOn) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsOn);

// [IN] NodeId [IN] Channel [OUT] pIsOn
EXTERN LONG 	(WINAPI *cmlPmGnGetServoOn) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsOn);

// [IN] NodeId [IN] Channel [IN] IsOn
EXTERN LONG 	(WINAPI *cmlPmGnAlarmReset) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsReset);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-CFG)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] PropId [IN] PropVal
EXTERN LONG 	(WINAPI *cmlPmCfgSetMioProperty) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG PropId, __in LONG PropVal);

// [IN] NodeId [IN] Channel [IN] PropId [OUT] pPropVal
EXTERN LONG 	(WINAPI *cmlPmCfgGetMioProperty) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG PropId, __out PLONG pPropVal);

// [IN] NodeId [IN] Channel [IN] IsEnable
EXTERN LONG 	(WINAPI *cmlPmCfgSetFilter) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsEnable);

// [IN] NodeId [IN] Channel [OUT] pIsEnable
EXTERN LONG 	(WINAPI *cmlPmCfgGetFilter) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsEnable);

// [IN] NodeId [IN] Channel [IN] Target [IN] IsEnable
EXTERN LONG 	(WINAPI *cmlPmCfgSetFilterAB) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __in LONG IsEnable);

// [IN] NodeId [IN] Channel [IN] Target [OUT] pIsEnable
EXTERN LONG 	(WINAPI *cmlPmCfgGetFilterAB) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __out PLONG pIsEnable);

// [IN] NodeId [IN] Channel [IN] InputMode [IN] IsReverse
EXTERN LONG 	(WINAPI *cmlPmCfgSetInMode) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG InputMode, __in LONG IsReverse);

// [IN] NodeId [IN] Channel [OUT] pInputMode [OUT] pIsReverse
EXTERN LONG 	(WINAPI *cmlPmCfgGetInMode) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pInputMode, __out PLONG pIsReverse);

// [IN] NodeId [IN] Channel [IN] OutputMode
EXTERN LONG 	(WINAPI *cmlPmCfgSetOutMode) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG OutputMode);

// [IN] NodeId [IN] Channel [OUT] pOutputMode
EXTERN LONG 	(WINAPI *cmlPmCfgGetOutMode) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pOutputMode);

// [IN] NodeId [IN] Channel [IN] CtrlMode
EXTERN LONG 	(WINAPI *cmlPmCfgSetCtrlMode) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG CtrlMode);

// [IN] NodeId [IN] Channel [OUT] pCtrlMode
EXTERN LONG 	(WINAPI *cmlPmCfgGetCtrlMode) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pCtrlMode);

// [IN] NodeId [IN] Channel [IN] Ratio
EXTERN LONG 	(WINAPI *cmlPmCfgSetInOutRatio) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Ratio);

// [IN] NodeId [IN] Channel [OUT] pRatio
EXTERN LONG 	(WINAPI *cmlPmCfgGetInOutRatio) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pRatio);

// [IN] NodeId [IN] Channel [IN] UnitDist
EXTERN LONG 	(WINAPI *cmlPmCfgSetUnitDist) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE UnitDist);

// [IN] NodeId [IN] Channel [OUT] pUnitDist
EXTERN LONG 	(WINAPI *cmlPmCfgGetUnitDist) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out DOUBLE *pUnitDist);

// [IN] NodeId [IN] Channel [IN] UnitSpeed
EXTERN LONG 	(WINAPI *cmlPmCfgSetUnitSpeed) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE UnitSpeed);

// [IN] NodeId [IN] Channel [OUT] pUnitSpeed
EXTERN LONG 	(WINAPI *cmlPmCfgGetUnitSpeed) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out DOUBLE *pUnitSpeed);

// [IN] NodeId [IN] Channel [IN] MaxPPS
EXTERN LONG 	(WINAPI *cmlPmCfgSetSpeedRange) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG MaxPPS);

// [IN] NodeId [IN] Channel [OUT] pMaxPPS
EXTERN LONG 	(WINAPI *cmlPmCfgGetSpeedRange) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMaxPPS);

// [IN] NodeId [IN] Channel [IN] SpeedMode [IN] WorkSpeed [IN] Accel [IN] Decel
EXTERN LONG 	(WINAPI *cmlPmCfgSetSpeedPattern) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE WorkSpeed, __in DOUBLE Accel, __in DOUBLE Decel);

// [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pWorkSpeed [OUT] pAccel [OUT] pDecel
EXTERN LONG 	(WINAPI *cmlPmCfgGetSpeedPattern) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE *pWorkSpeed, __out DOUBLE *pAccel, __out DOUBLE *pDecel);

EXTERN LONG		(WINAPI *cmlPmCfgSetSpeedPattern_T) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE WorkSpeed, __in DOUBLE AccTime, __in DOUBLE DecTime);

EXTERN LONG		(WINAPI *cmlPmCfgGetSpeedPattern_T) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE * pWorkSpeed, __out DOUBLE * pAccTime, __out DOUBLE * pDecTime);

// [IN] NodeId [IN] Channel [IN] IsEnable [IN] LimitN [IN] LimitP
EXTERN LONG 	(WINAPI *cmlPmCfgSetSoftLimit) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsEnable, __in DOUBLE LimitN, __in DOUBLE LimitP);

// [IN] NodeId [IN] Channel [OUT] pIsEnable [OUT] pLimitN [OUT] pLimitP
EXTERN LONG 	(WINAPI *cmlPmCfgGetSoftLimit) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsEnable, __out DOUBLE *pLimitN, __out DOUBLE *pLimitP);

// [IN] NodeId [IN] Channel [IN] TargCntr [IN] IsEnable [IN] CntMax
EXTERN LONG 	(WINAPI *cmlPmCfgSetRingCntr) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG TargCntr, __in LONG IsEnable, __in LONG CntMax);

// [IN] NodeId [IN] Channel [IN] TargCntr [OUT] pIsEnable [OUT] pCntMax
EXTERN LONG 	(WINAPI *cmlPmCfgGetRingCntr) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG TargCntr, __out PLONG pIsEnable, __out PLONG pCntMax);

// [IN] NodeId [IN] Channel [IN] CorrRatio
EXTERN LONG 	(WINAPI *cmlPmCfgSetVelCorrRatio) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG CorrRatio);

// [IN] NodeId [IN] Channel [OUT] pCorrRatio
EXTERN LONG 	(WINAPI *cmlPmCfgGetVelCorrRatio) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pCorrRatio);

// [IN] NodeId [IN] SeqMode
EXTERN LONG 	(WINAPI *cmlPmCfgSetSeqMode) 		(__in LONG BoardId, __in LONG NodeId, __in LONG SeqMode);

// [IN] NodeId [OUT] pSeqMode
EXTERN LONG 	(WINAPI *cmlPmCfgGetSeqMode) 		(__in LONG BoardId, __in LONG NodeId, __out PLONG pSeqMode);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-HOME)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] HomeMode [IN] Dir [IN] EzCount [IN] EscDist [IN] Offset
EXTERN LONG 	(WINAPI *cmlPmHomeSetConfig) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG HomeMode, __in LONG Dir, __in LONG EzCount, __in LONG EscDist, __in DOUBLE Offset);

// [IN] NodeId [IN] Channel [OUT] pHomeMode [OUT] pDir [OUT] pEzCount [OUT] pEscDist [OUT] pOffset
EXTERN LONG 	(WINAPI *cmlPmHomeGetConfig) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pHomeMode, __out PLONG pDir, __out PLONG pEzCount, __out PLONG pEscDist, __out DOUBLE *pOffset);

// [IN] NodeId [IN] Channel [IN] PosClrMode
EXTERN LONG 	(WINAPI *cmlPmHomeSetPosClrMode) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG PosClrMode);

// [IN] NodeId [IN] Channel [OUT] pPosClrMode
EXTERN LONG 	(WINAPI *cmlPmHomeGetPosClrMode) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pPosClrMode);

// [IN] NodeId [IN] Channel [IN] SpeedMode [IN] Vel [IN] Accel [IN] Decel [IN] RevVel
EXTERN LONG 	(WINAPI *cmlPmHomeSetSpeedPattern) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE Accel, __in DOUBLE Decel, __in DOUBLE RevVel);

// [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pVel [OUT] pAccel [OUT] pDecel [OUT] pRevVel
EXTERN LONG 	(WINAPI *cmlPmHomeGetSpeedPattern) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE *pVel, __out DOUBLE *pAccel, __out DOUBLE *pDecel, __out DOUBLE *pRevVel);

EXTERN LONG 	(WINAPI *cmlPmHomeSetSpeedPattern_T) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime, __in DOUBLE RevVel);

EXTERN LONG 	(WINAPI *cmlPmHomeGetSpeedPattern_T) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE *pVel, __out DOUBLE *pAccTime, __out DOUBLE *pDecTime, __out DOUBLE *pRevVel);

// [IN] NodeId [IN] Channel
EXTERN LONG 	(WINAPI *cmlPmHomeMoveStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] Channel
EXTERN LONG 	(WINAPI *cmlPmHomeMoveAllStart) 	(__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask);

// [IN] NodeId [IN] Channel [IN] IsSuccess
EXTERN LONG 	(WINAPI *cmlPmHomeSetSuccess) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsSuccess);

// [IN] NodeId [IN] Channel [OUT] pIsSuccess
EXTERN LONG 	(WINAPI *cmlPmHomeGetSuccess) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsSuccess);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-SX)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] SpeedMode [IN] VelRatio [IN] AccRatio [IN] DecRatio
EXTERN LONG 	(WINAPI *cmlPmSxSetSpeedRatio) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in LONG VelRatio, __in LONG AccRatio, __in LONG DecRatio);

// [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pVelRatio [OUT] pAccRatio [OUT] pDecRatio
EXTERN LONG 	(WINAPI *cmlPmSxGetSpeedRatio) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out PLONG pVelRatio, __out PLONG pAccRatio, __out PLONG pDecRatio);

// [IN] NodeId [IN] Channel [IN] Distance
EXTERN LONG 	(WINAPI *cmlPmSxMoveStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Distance);

// [IN] NodeId [IN] Channel [IN] Distance [IN] IsBlocking
EXTERN LONG 	(WINAPI *cmlPmSxMove) 			(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Distance, __in LONG IsBlocking);

// [IN] NodeId [IN] Channel [IN] Position
EXTERN LONG 	(WINAPI *cmlPmSxMoveToStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Position);

// [IN] NodeId [IN] Channel [IN] Position [IN] IsBlocking
EXTERN LONG 	(WINAPI *cmlPmSxMoveTo) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Position, __in LONG IsBlocking);

// [IN] NodeId [IN] Channel [IN] Direction
EXTERN LONG 	(WINAPI *cmlPmSxVMoveStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Direction);

// [IN] NodeId [IN] Channel [IN] IsWaitComplete
EXTERN LONG 	(WINAPI *cmlPmSxStop) 			(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsWaitComplete);

// [IN] NodeId [IN] Channel [IN] IsWaitComplete
EXTERN LONG 	(WINAPI *cmlPmSxStopEmg) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] Channel [OUT] pIsDnoe
EXTERN LONG 	(WINAPI *cmlPmSxIsDone) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsDone);

// [IN] NodeId [IN] Channel 
EXTERN LONG 	(WINAPI *cmlPmSxWaitDone) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] Channel [OUT] pPosition
EXTERN LONG 	(WINAPI *cmlPmSxGetTargetPos) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out DOUBLE *pPosition);

// [IN] NodeId [IN] Channel [IN] IniSpeed
EXTERN LONG 	(WINAPI *cmlPmSxSetOptIniSpeed) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE IniSpeed);

// [IN] NodeId [IN] Channel [OUT] pIniSpeed
EXTERN LONG 	(WINAPI *cmlPmSxGetOptIniSpeed) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out DOUBLE *pIniSpeed);

// [IN] NodeId [IN] Channel [IN] OffsetDist
EXTERN LONG 	(WINAPI *cmlPmSxSetOptRdpOffset) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE OffsetDist);

// [IN] NodeId [IN] Channel [OUT] pOffsetDist
EXTERN LONG 	(WINAPI *cmlPmSxGetOptRdpOffset) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out DOUBLE *pOffsetDist);

// [IN] NodeId [IN] Channel [IN] CorrMode [IN] CorrAmount [IN] CorrVel [IN] CntrMask
EXTERN LONG 	(WINAPI *cmlPmSxSetCorrection) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG CorrMode, __in DOUBLE CorrAmount, __in DOUBLE CorrVel, __in LONG CntrMask);

// [IN] NodeId [IN] Channel [OUT] pCorrMode [OUT] pCorrAmount [OUT] pCorrVel [OUT] pCntrMask
EXTERN LONG 	(WINAPI *cmlPmSxGetCorrection) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pCorrMode, __out DOUBLE *pCorrAmount, __out DOUBLE *pCorrVel, __out PLONG pCntrMask);

// [IN] NodeId [IN] Channel [IN] Mode [IN] RefAxis [IN] Condition
EXTERN LONG 	(WINAPI *cmlPmSxSetOptSyncMode) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Mode, __in LONG RefAxis, __in LONG Condition);

// [IN] NodeId [IN] Channel [OUT] pMode [OUT] pRefAxis [OUT] pCondition
EXTERN LONG 	(WINAPI *cmlPmSxGetOptSyncMode) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMode, __out PLONG pRefAxis, __out PLONG pCondition);

// [IN] NodeId [IN] Channel [IN] Mode [IN] DoChan_local [IN] DoLogic
EXTERN LONG 	(WINAPI *cmlPmSxSetOptSyncOut) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Mode, __in LONG DoChan_local, __in LONG DoLogic);

// [IN] NodeId [IN] Channel [OUT] pMode [OUT] pDoChan_local [OUT] pDoLogic
EXTERN LONG 	(WINAPI *cmlPmSxGetOptSyncOut) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMode, __out PLONG pDoChan_local, __out PLONG pDoLogic);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-MX)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2]
EXTERN LONG 	(WINAPI *cmlPmMxMoveStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE *DistList);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2] [IN] IsBlocking
EXTERN LONG 	(WINAPI *cmlPmMxMove) 			(__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE *DistList, __in LONG IsBlocking);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2]
EXTERN LONG 	(WINAPI *cmlPmMxMoveToStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE *PosList);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2] [IN] IsBlocking
EXTERN LONG 	(WINAPI *cmlPmMxMoveTo) 		(__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE *PosList, __in LONG IsBlocking);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DirMask
EXTERN LONG 	(WINAPI *cmlPmMxVMoveStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in LONG DirMask);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] IsWaitComplete
EXTERN LONG 	(WINAPI *cmlPmMxStop) 			(__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in LONG IsWaitComplete);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask
EXTERN LONG 	(WINAPI *cmlPmMxStopEmg) 		(__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [OUT] pIsDone
EXTERN LONG 	(WINAPI *cmlPmMxIsDone) 		(__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __out PLONG pIsDone);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask
EXTERN LONG 	(WINAPI *cmlPmMxWaitDone) 		(__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-IX)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] MapIndex [IN] MapMask
EXTERN LONG 	(WINAPI *cmlPmIxMapAxes) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG MapMask);

// [IN] NodeId [IN] MapIndex
EXTERN LONG		(WINAPI *cmlPmIxUnMapAxes) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] MapIndex [IN] VelCorrOpt1 [IN] VelCorrOpt2
EXTERN LONG 	(WINAPI *cmlPmIxSetVelCorrMode) 	(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG VelCorrOpt1, __in LONG VelCorrOpt2);

// [IN] NodeId [IN] MapIndex [OUT] pVelCorrOpt1 [OUT] pVelCorrOpt2
EXTERN LONG 	(WINAPI *cmlPmIxGetVelCorrMode) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pVelCorrOpt1, __out PLONG pVelCorrOpt2);

// [IN] NodeId [IN] MapIndex [IN] IsVectorSpeed [IN] SpeedMode [IN] Vel [IN] Acc [IN] Dec
EXTERN LONG 	(WINAPI *cmlPmIxSetSpeedPattern) 	(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG IsVectorSpeed, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE Acc, __in DOUBLE Dec);

// [IN] NodeId [IN] MapIndex [OUT] pIsVectorSpeed [OUT] pSpeedMode [OUT] pVel [OUT] pAcc [OUT] pDec
EXTERN LONG 	(WINAPI *cmlPmIxGetSpeedPattern) 	(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __out PLONG pIsVectorSpeed, __out PLONG pSpeedMode, __out DOUBLE *pVel, __out DOUBLE *pAcc, __out DOUBLE *pDec);

// [IN] NodeId [IN] MapIndex [IN] IsVectorSpeed [IN] SpeedMode [IN] Vel [IN] AccTime [IN] DecTime
EXTERN LONG 	(WINAPI *cmlPmIxSetSpeedPattern_T) 	(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG IsVectorSpeed, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime);

// [IN] NodeId [IN] MapIndex [OUT] pIsVectorSpeed [OUT] pSpeedMode [OUT] pVel [OUT] pAccTime [OUT] pDecTime
EXTERN LONG 	(WINAPI *cmlPmIxGetSpeedPattern_T) 	(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __out PLONG pIsVectorSpeed, __out PLONG pSpeedMode, __out DOUBLE *pVel, __out DOUBLE *pAccTime, __out DOUBLE *pDecTime);

// [IN] NodeId [IN] MapIndex [IN] pPosList
EXTERN LONG 	(WINAPI *cmlPmIxLineStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE *pDistList);

// [IN] NodeId [IN] MapIndex [IN] pPosList
EXTERN LONG 	(WINAPI *cmlPmIxLineToStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE *pPosList);

// [IN] NodeId [IN] MapIndex [IN] XCentOffset [IN] YCentOffset [IN] EndAngle
EXTERN LONG 	(WINAPI *cmlPmIxArcAStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE EndAngle);

// [IN] NodeId [IN] MapIndex [IN] XCent [IN] YCent [IN] EndAngle
EXTERN LONG 	(WINAPI *cmlPmIxArcAToStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE EndAngle);

// [IN] NodeId [IN] MapIndex [IN] XCentOffset [IN] YCentOffset [IN] XEndPointDist [IN] YEndPointDist [IN] Direction
EXTERN LONG 	(WINAPI *cmlPmIxArcPStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE XEndPointDist, __in DOUBLE YEndPointDist, __in LONG Direction);

// [IN] NodeId [IN] MapIndex [IN] XCent [IN] YCent [IN] XEndPoint [IN] YEndPoint [IN] Direction
EXTERN LONG 	(WINAPI *cmlPmIxArcPToStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE XEndPoint, __in DOUBLE YEndPoint, __in LONG Direction);

// [IN] NodeId [IN] MapIndex [IN] P2X [IN] P2Y [IN] P3X [IN] P3Y [IN] EndAngle
EXTERN LONG 	(WINAPI *cmlPmIxArc3PStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE P2X, __in DOUBLE P2Y, __in DOUBLE P3X, __in DOUBLE P3Y, __in DOUBLE EndAngle);

// [IN] NodeId [IN] MapIndex [IN] P2X [IN] P2Y [IN] P3X [IN] P3Y [IN] EndAngle
EXTERN LONG 	(WINAPI *cmlPmIxArc3PToStart) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in DOUBLE P2X, __in DOUBLE P2Y, __in DOUBLE P3X, __in DOUBLE P3Y, __in DOUBLE EndAngle);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG 	(WINAPI *cmlPmIxStop) 			(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG 	(WINAPI *cmlPmIxStopEmg) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG 	(WINAPI *cmlPmIxIsDone) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __out PLONG pIsDone);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG 	(WINAPI *cmlPmIxWaitDone) 		(__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] Channel 
EXTERN LONG 	(WINAPI *cmlPmOverrideSpeedSet) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] ChannelMask
EXTERN LONG 	(WINAPI *cmlPmOverrideSpeedSetAll) 	(__in LONG BoardId, __in LONG NodeId, __in LONG ChannelMask);

// [IN] NodeId [IN] Channel [IN] NewDistance [IN] IsHardApply [OUT] pAppliedState
EXTERN LONG 	(WINAPI *cmlPmOverrideMove) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE NewDistance, __in LONG IsHardApply, __out PLONG pAppliedState);

// [IN] NodeId [IN] Channel [IN] NewPosition [IN] IsHardApply
EXTERN LONG 	(WINAPI *cmlPmOverrideMoveTo) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE NewPosition, __in LONG IsHardApply, __out PLONG pAppliedState);

// [IN] NodeId [IN] Channel [IN] Target [IN] Count
EXTERN LONG 	(WINAPI *cmlPmStSetCount) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __in LONG Count);

// [IN] NodeId [IN] Channel [IN] Source [OUT] pCount
EXTERN LONG 	(WINAPI *cmlPmStGetCount) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Source, __out PLONG pCount);

// [IN] NodeId [IN] Channel [IN] Target [IN] Position
EXTERN LONG 	(WINAPI *cmlPmStSetPosition) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __in DOUBLE Position);

// [IN] NodeId [IN] Channel [OUT] pIsLatched
EXTERN LONG 	(WINAPI *cmlPmStGetPosition) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Source, __out DOUBLE *pPosition);

// [IN] NodeId [IN] Channel [IN] Source [OUT] pIsLatched
EXTERN LONG 	(WINAPI *cmlPmStGetSpeed) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Source, __out DOUBLE *pSpeed);

// [IN] NodeId [IN] Channel [OUT] pMotStates
EXTERN LONG 	(WINAPI *cmlPmStReadMotionState) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMotStates);

// [IN] NodeId [IN] Channel [OUT] pMioStates
EXTERN LONG 	(WINAPI *cmlPmStReadMIOStatus) 	(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMioStates);

// [IN] NodeId [IN] Channel [OUT] pIsLatched
EXTERN LONG 	(WINAPI *cmlPmLtcIsLatched) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsLatched);

// [IN] NodeId [IN] Channel [IN] Counter [OUT] pLatchedPos
EXTERN LONG 	(WINAPI *cmlPmLtcReadLatch) 		(__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Counter, __out DOUBLE *pLatchedPos);

//////////////////////////////////////////////////////////////////////////
// Servo Parameter R/W Function
//////////////////////////////////////////////////////////////////////////
EXTERN LONG 	(WINAPI *cmlServoParamRead)		(__in LONG BoardId, __in LONG MacID, __in LONG ParamNo, __in LONG DataSize, __in void *Buffer);
EXTERN LONG 	(WINAPI *cmlServoParamWrite)		(__in LONG BoardId, __in LONG MacID, __in LONG ParamNo, __in LONG DataSize, __in void *Buffer);
EXTERN LONG 	(WINAPI *cmlServoParamSet)			(__in LONG BoardId, __in LONG MacID, __in LONG ParamNo, __in LONG DataSize, __in void *Buffer);
EXTERN LONG 	(WINAPI *cmlServoParamValidate)	(__in LONG BoardId, __in LONG MacID, __in LONG IsWaitCompt);

//////////////////////////////////////////////////////////////////////////
// Advanced Function
//////////////////////////////////////////////////////////////////////////

// [RTS Update Functions]
// RTS Structure ּҸ RtsData Structure Pointer ȯմϴ.
EXTERN LONG	(WINAPI *cmlAdvGetRtsMemPtr)		(__in LONG BoardId, __out cmlRtsData** ppMemPtr);

// RTS Update  Ȱȭ Ұ Ͽ ϰ  RTS Update Ȱ ¸ ȯմϴ.
EXTERN LONG	(WINAPI *cmlAdvSetRtsEnable)		(__in LONG BoardId, __in LONG IsEnable);
EXTERN LONG	(WINAPI *cmlAdvGetRtsEnable)		(__in LONG BoardId, __out LONG *pIsEnable);

// ش Node RTS Update   Ͽ ϰ  Node RTS Update ¸ ȯմϴ.
EXTERN LONG	(WINAPI *cmlAdvSetRtsMode)		(__in LONG BoardId, __in LONG NodeId, __in LONG IsEnable);
EXTERN LONG	(WINAPI *cmlAdvGetRtsMode)		(__in LONG BoardId, __in LONG NodeId, __out LONG *pIsEnable);

// RTS Structure Update Interval  Ǵ ȯմϴ.
EXTERN LONG	(WINAPI *cmlAdvSetRtsUpdateInterval)	(__in LONG BoardId, __in LONG RtsUpdateInterval);
EXTERN LONG	(WINAPI *cmlAdvGetRtsUpdateInterval)	(__in LONG BoardId, __out PLONG pRtsUpdateInterval);

// [Command Acknowledge Setting Functions]
// API Լ  带 ϰ   带 ȯմϴ.
EXTERN LONG 	(WINAPI *cmlAdvSetCmdAckMode)		(__in LONG BoardId, __in LONG AckMode);
EXTERN LONG 	(WINAPI *cmlAdvGetCmdAckMode) 		(__in LONG BoardId, __out PLONG pAckMode);

// [NEMO-ME Node Configuration Functions(Undocumented)]
EXTERN LONG	(WINAPI *cmlAdvM2NodeCfgRead)				(__in LONG BoardId, __out LONG *pT_mcyc, __out LONG *pMa_max, __out UCHAR *pId_table, __out UCHAR *pCrdlen_table, __out UCHAR *pSlv_type);
EXTERN LONG	(WINAPI *cmlAdvM2NodeCfgWrite)				(__in LONG BoardId, __in LONG T_mcyc, __in LONG Ma_max, __in UCHAR *pId_table, __in UCHAR *pCrdlen_table, __in UCHAR *pSlv_type);

// [NEMO Firmware Functions(Undocumented)]
EXTERN LONG	(WINAPI *cmlAdvFwGetVersion)		(__in LONG BoardId, __out PLONG VersionMS, __out PLONG VersionLS);
EXTERN LONG	(WINAPI *cmlAdvDllGetVersion)		(__out PLONG VersionMS, __out PLONG VersionLS);
EXTERN LONG	(WINAPI *cmlAdvDrvGetVersion)		(__out PLONG VersionMS, __out PLONG VersionLS);
EXTERN LONG	(WINAPI *cmlAdvFwGetSystemState)	(__in LONG BoardId, __out PLONG State);
EXTERN LONG	(WINAPI *cmlAdvFwDnFrame)		(__in LONG BoardId, __in LONG FrameType, __in PLONG FrameData, __in LONG FrameSize);
EXTERN LONG	(WINAPI *cmlAdvFwDnFrameVerify)	(__in LONG BoardId, __in LONG FrameType, __in PLONG FrameData, __in LONG FrameSize);
EXTERN LONG	(WINAPI *cmlAdvFwSystemReset)		(__in LONG BoardId, __in LONG IsReset);
EXTERN LONG	(WINAPI *cmlAdvFwSetFwuBit)		(__in LONG BoardId, __in LONG IsAnswer, __in LONG Value);
EXTERN LONG	(WINAPI *cmlAdvFwGetFwuBit)		(__in LONG BoardId, __in LONG IsAnswer, __out PLONG pValue);
EXTERN LONG	(WINAPI *cmlAdvFwSetBootFlag)		(__in LONG BoardId, __in LONG Value);
EXTERN LONG	(WINAPI *cmlAdvFwGetBootFlag)		(__in LONG BoardId, __out PLONG pValue);
EXTERN LONG	(WINAPI *cmlAdvFwUpdateMode)		(__in LONG BoardId, __in LONG IsEnable);

EXTERN LONG	(WINAPI *cmlAdvDeviceIDRead)		(__in LONG BoardId, __in LONG Axis, __in LONG DeviceCode, __in LONG Offset, __in LONG DataSize, __out void *Buffer);

EXTERN LONG (WINAPI *cmlGnInitFromFile)			(__in LONG BoardId, __in char * szFileName);

EXTERN LONG (WINAPI *cmlMsRegisterSlave)		(__in LONG BoardId, __in LONG Axis, __in LONG MasterAxis);
EXTERN LONG (WINAPI *cmlMsUnregisterSlave)		(__in LONG BoardId, __in LONG Axis);
EXTERN LONG (WINAPI *cmlMsGetMasterAxis)		(__in LONG BoardId, __in LONG Axis, __out PLONG MasterAxis);

EXTERN LONG (WINAPI *cmlCfgSetRotateAxis)		(__in LONG BoardId, __in LONG Axis, __in LONG Enable);
EXTERN LONG (WINAPI *cmlCfgGetRotateAxisInfo)	(__in LONG BoardId, __in LONG Axis, __out PLONG Enable, __out PLONG PPR);
EXTERN LONG (WINAPI *cmlSxRMove) 				(__in LONG BoardId, __in LONG Axis, __in DOUBLE Angle, __in LONG IsBlocking);
EXTERN LONG (WINAPI *cmlSxRMoveStart)			(__in LONG BoardId, __in LONG Axis, __in DOUBLE Angle);
EXTERN LONG (WINAPI *cmlSxRMoveTo) 				(__in LONG BoardId, __in LONG Axis, __in DOUBLE Angle, __in LONG IsBlocking);
EXTERN LONG (WINAPI *cmlSxRMoveToStart)			(__in LONG BoardId, __in LONG Axis, __in DOUBLE Angle);
EXTERN LONG (WINAPI *cmlSxRSearch) 				(__in LONG BoardId, __in LONG Axis, __in DOUBLE Angle, __in LONG IsBlocking);
EXTERN LONG (WINAPI *cmlSxRSearchStart)			(__in LONG BoardId, __in LONG Axis, __in DOUBLE Angle);

EXTERN LONG	(WINAPI *cmlAdvFlsWrite)			(__in LONG BoardId, __in LONG nSector, __in LONG nBlock, __in LONG nWriteSize, __in PLONG WriteData);
EXTERN LONG	(WINAPI *cmlAdvFlsRead)				(__in LONG BoardId, __in LONG nSector, __in LONG nBlock, __in LONG nReadSize, __out PLONG ReadData);
EXTERN LONG	(WINAPI *cmlAdvFlsErase)			(__in LONG BoardId, __in LONG nSector);

EXTERN LONG (WINAPI *cmlAdvDataRW)				(__in LONG BoardId, __in LONG Axis, __in LONG Header, __in PLONG CmdData, __out PLONG RspData);

#ifdef __cplusplus
}
#endif


#endif
