/*******************************************************************************
* [ ComiMLink2_SDK_Def.h ]
* Header file for definitions of constants and data in Mechatrolink-2 library
* - Update Data: 2016/02/01
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#ifndef __COMI_MLINK2_SDK_DEF_H__
#define __COMI_MLINK2_SDK_DEF_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// -------------------------------------------------------------------
// Declare Const Values in Mechatrolink-2 Library
// -------------------------------------------------------------------
#define LX530S_MAX_SUPPORT_MASTER_BOARDS				16
#define LX530S_MAX_SUPPORT_SLAVE_AXES					32
#define LX530S_MAX_SUPPORT_INTERPOLATION_MOTION			16
#define	LX530S_MAX_SUPPORT_LISTED_MOTION				16
#define LX530S_MAX_SUPPORT_LISTED_MOTION_USER_PARAM		4
#define LX530S_MAX_MODULE_IN_SLAVE						9
#define LX530S_MAX_SUPPORT_IN_NODE_AXES					2

#ifndef MAX_NUM_PLATFORM
#define MAX_NUM_PLATFORM	5   // RTEX, MLINK3, SSCNET3, MLINK2, SSCNET3/H
#endif

#ifndef MAX_NUM_FUNC
#define MAX_NUM_FUNC		600
#endif

#ifndef FLASH_SECTOR_LEN
#define FLASH_SECTOR_LEN	35
#endif
// -------------------------------------------------------------------
// General Type
// -------------------------------------------------------------------
#ifndef	TRUE
#define TRUE	1
#endif

#ifndef	FALSE
#define FALSE	0
#endif

// -------------------------------------------------------------------
// General BOOLEAN Type Definition
// -------------------------------------------------------------------
typedef enum
{
	cmlFALSE		= 0,
	cmlTRUE			= 1,
	
	//////////////////////////////////////////////////////////////////////////
	cmlBOOLEAN_INVALID		// Used for enumerated type range checking
} cmlBOOLEAN;

// -------------------------------------------------------------------
// Type of  COM State Id (using to GnSetCommStates, GnGetCommStates)
// -------------------------------------------------------------------
typedef enum
{
	cmlCSID_COM_STATES	=	0,
	cmlCSID_RTS_COUNT	=	1,
	cmlCSID_CMD_COUNT	=	2,
	cmlCSID_COM_RST		=	3,	// Only 'Set' Support

	//////////////////////////////////////////////////////////////////////////
	cmlCSID_INVALID				// Used for enumerated type range checking
} cmlCommStates;

// -------------------------------------------------------------------
// Types of [emCOM_STATES] 'States' (using to GnSetCommStates, GnGetCommStates)
// -------------------------------------------------------------------
typedef enum
{
	cmlCOM_STATE_RESET		= -1,
	cmlCOM_STATE_INIT		= 0,
	cmlCOM_STATE_WAITING	= 1,
	cmlCOM_STATE_PREPARE	= 2,
	cmlCOM_STATE_START		= 3,
	cmlCOM_STATE_RUNNING	= 4,

	//////////////////////////////////////////////////////////////////////////
	cmlCOM_STATE_INVALID	// Used for enumerated type range checking
} cmlCOM_STATES;


// -------------------------------------------------------------------
// Types of Motion State(using to StSxReadMotionState, StIxReadMotionState)
// -------------------------------------------------------------------
typedef enum
{
	cmlMST_STOP			=			0,
	cmlMST_IN_ACC		=			1,
	cmlMST_IN_WORKSPD	=			2,
	cmlMST_IN_DEC		=			3,
	cmlMST_IN_INISPD	=			4,
	cmlMST_IN_WAIT		=			5,
	cmlMST_IN_SYNC		=			6,
	
	//////////////////////////////////////////////////////////////////////////
	cmlMST_IN_INVALID				// Used for enumerated type range checking
} cmlMotionState;

// -------------------------------------------------------------------
// Types of Linear Operation Direction (using to SxVMoveStart, MxVMoveStart)
// -------------------------------------------------------------------
typedef enum
{
	cmlDIR_N			=			0,
	cmlDIR_P			=			1,

	//////////////////////////////////////////////////////////////////////////
	cmlDIR_INVALID					// Used for enumerated type range checking
} cmlDir;

// Counter name //
typedef enum { 
	cmlCNT_COMM = 0,	/*Command*/
	cmlCNT_FEED,		/*Feedback*/
	cmlCNT_DEV,			/*Deviation*/
	cmlCNT_GEN,			/*General*/ 

	//////////////////////////////////////////////////////////////////////////
	cmlCNT_INVALID					// Used for enumerated type range checking
}cmlCmCntr;

// Control Mode//
typedef enum {
	cmlCTRL_POS,
	cmlCTRL_VEL,
	cmlCTRL_TOR
}cmlCmControlMode;

// -------------------------------------------------------------------
// Types of Machine I/O Property ID (using to CfgSetMioProperty, CfgGetMioProperty)
// -------------------------------------------------------------------
typedef enum
{
	cmlMIO_PEL_LOGIC =			0,	// Property Val [ cmlLOGIC_A    | cmlLOGIC_B ] (Default : cmlLOGIC_A)
	cmlMIO_NEL_LOGIC =			1,	// Property Val [ cmlLOGIC_A    | cmlLOGIC_B ] (Default : cmlLOGIC_A)
	cmlMIO_ORG_LOGIC =			2,	// Property Val [ cmlLOGIC_A    | cmlLOGIC_B ] (Default : cmlLOGIC_A)
	cmlMIO_EL_MODE	=			3,	// Property Val [ 0 : Emg Stop | 1 : Stop  ] (Default : Emg Stop )
	cmlMIO_INP_EN	=			4,	// Property Val [ 0 : INP[D]   | 1 : INP[E]] (Default : INP[D]   )
	cmlMIO_CFSYNC_EN = 			5,	// Property Val [ 0 : Disable  | 1 : Enable] (Default : Disable  )
	cmlMIO_SVON_MODE =			6,	
	cmlMIO_VELCTRL_MODE =		7,	// Property Val [ 0 : Position Control Mode  | 1 : Velocity Control Mode  (Default : Position Control Mode ) 
	cmlMIO_VELCTRL_MAXRPM =		8,	///<ӵ     ִ RPM
	cmlMIO_VELCTRL_PPR =		9,	///<ӵ     ȸ  ޽ 
	cmlMIO_SWL_MODE	=			10,	// Property Val [ 0 : Emg Stop | 1 : Stop  ] (Default : Emg Stop )

	
	/////////////////////////////////////////////////////////////////////
	cmlMIO_INVALID					// Used for enumerated type range checking
} cmlMIOID;

// -------------------------------------------------------------------
// Types of Machine I/O Property Value (using to CfgSetMioProperty, CfgGetMioProperty)
// -------------------------------------------------------------------
typedef enum
{
	cmlLOGIC_A		=			0,
	cmlLOGIC_B		=			1,
	
	//////////////////////////////////////////////////////////////////////////
	cmlLOGIC_INVALID					// Used for enumerated type range checking
} cmlMIOVALUE;

// -------------------------------------------------------------------
// Types of Speed Mode Value (using to CfgSetSpeedPattern, CfgGetSpeedPattern)
// -------------------------------------------------------------------
typedef enum
{
	cmlSPEED_CONSTANT		=		0,
	cmlSPEED_TRAPEZOIDAL	=		1,
	cmlSPEED_SCURVE			=		2,

	//////////////////////////////////////////////////////////////////////////
	cmlSPEED_INVALID					// Used for enumerated type range checking
} cmlVMode;

// -------------------------------------------------------------------
// Types of Backlash/Slip Correction Mode Value (using to SxSetCorrection, SxGetCorrection)
// -------------------------------------------------------------------
typedef enum
{
	cmlCORR_DISABLE			=		0,
	cmlCORR_BACKLASH		=		1,
	cmlCORR_SLIP			=		2,

	//////////////////////////////////////////////////////////////////////////
	cmlCORR_INVALID					// Used for enumerated type range checking
} cmlCorrMode;

// -------------------------------------------------------------------
// Types of Move Mode Value (using to StGetMotionMode)
// -------------------------------------------------------------------
typedef enum
{
	cmlMODE_NONE			=		0,			///<
	cmlMODE_HOME			=		1,			///<
	cmlMODE_IX_LINEAR		=		2,			///<  ̼
	cmlMODE_IX_CIRCULAR		=		3,			///<ȣ  ̼
	cmlMODE_IX_HELICAL		=		4,			///<︮  ̼
	cmlMODE_IX_SPLINE		=		5,			///<ö  ̼
	cmlMODE_SX				=		6,			///< ̼
	cmlMODE_MS				=		7,			///<Master/Slave ̼

	//////////////////////////////////////////////////////////////////////////
	cmlMODE_INVALID					// Used for enumerated type range checking
} cmlMoveMode;

// -------------------------------------------------------------------
// Types of Machine I/O State Bit Index (using to StReadMioStatuses)
// -------------------------------------------------------------------
typedef enum
{
	cmlIOST_INP				=		0,
	cmlIOST_DIR				=		1,
	cmlIOST_HOMECOMPLETED	=		2,
	cmlIOST_TORQUELIMITED	=		3,
	cmlIOST_WARNING			=		4,
	cmlIOST_ALARM			=		5,
	cmlIOST_SVRDY			=		6,
	cmlIOST_SVON			=		7,
	cmlIOST_ELN				=		8,
	cmlIOST_ELP				=		9,
	cmlIOST_ORG				=		10,
	cmlIOST_EX_IN1			=		11,
	cmlIOST_EX_IN2			=		12,
	cmlIOST_EX_IN3			=		13,
	cmlIOST_EX_IN4			=		14,
	cmlIOST_EMG_STP			=		15,
	cmlIOST_RESERVED_01		=		16,
	cmlIOST_RESERVED_02		=		20,
	cmlIOST_ZSPD			=		28,
	cmlIOST_DEN				=		29,
	cmlIOST_BREAKON			=		30,
	cmlIOST_ZPOINT			=		31,


	/////////////////////////////////////////////////////////////////////////
	cmlIOST_INVALID					// Used for enumerated type range checking
} cmlIoST;

// -------------------------------------------------------------------
// Types of Interpolation Map Index (using to IxMapAxes, IxUnMapAxes, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmlIX_MAP0			=		0,
	cmlIX_MAP1			=		1,
	cmlIX_MAP2			=		2,
	cmlIX_MAP3			=		3,
	cmlIX_MAP4			=		4,
	cmlIX_MAP5			=		5,
	cmlIX_MAP6			=		6,
	cmlIX_MAP7			=		7,
	cmlIX_MAP8			=		8,
	cmlIX_MAP9			=		9,
	cmlIX_MAP10			=		10,
	cmlIX_MAP11			=		11,
	cmlIX_MAP12			=		12,
	cmlIX_MAP13			=		13,
	cmlIX_MAP14			=		14,
	cmlIX_MAP15			=		15,
	//////////////////////////////////////////////////////////////////////////
	cmlIX_MAP_INVALID	=       LX530S_MAX_SUPPORT_INTERPOLATION_MOTION	// Used for enumerated type range checking
} cmlIxMAP;

// -------------------------------------------------------------------
// Types of interpolation mode(using to IxMapAxes)
// -------------------------------------------------------------------
typedef enum 
{
	cmlIX_MODE_LINEAR		= 0,
	cmlIX_MODE_CIRCULAR		= 1,
	cmlIX_MODE_HELICARL		= 2,
	cmlIX_MODE_SPLINE		= 3,
		
	//////////////////////////////////////////////////////////////////////////
	cmlIX_MODE_INVALID					// Used for enumerated type range checking
} cmlIxMODE;

// -------------------------------------------------------------------
// Types of interpolation mode(using to ArcA, ArcP)
// -------------------------------------------------------------------
typedef enum
{
	cmlARC_CW		= 0,
	cmlARC_CCW		= 1,

	//////////////////////////////////////////////////////////////////////////
	cmlARC_INVALID					// Used for enumerated type range checking
} cmlIxARC_DIR;

// -------------------------------------------------------------------
// Types of return to home mode(using to HomeSetConfig, HomeGetConfig)
// -------------------------------------------------------------------
typedef enum
{
	cmlHOME_MODE0	= 0,
	cmlHOME_MODE1	= 1,
	cmlHOME_MODE2	= 2,
	cmlHOME_MODE3	= 3,
	cmlHOME_MODE4	= 4,

	//////////////////////////////////////////////////////////////////////////
	cmlHOME_MODE_INVALID				// Used for enumerated type range checking
} cmlHmMODE;

// -------------------------------------------------------------------
// Types of return to home position clear mode (using to HomeSetPosClrMode, HomeGetPosClrMode)
// -------------------------------------------------------------------
typedef enum
{
	cmlHPCM_M0		= 0,
	cmlHPCM_M1		= 1,
	cmlHPCM_M2		= 2,
	cmlHPCM_KEEP	= 3,

	//////////////////////////////////////////////////////////////////////////
	cmlHPCM_MODE_INVALID				// Used for enumerated type range checking
} cmlHpcMODE;

// -------------------------------------------------------------------
// Types of Listed Motion Map Index (using to LmStart, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmlLM_MAP0			=		0,
	cmlLM_MAP1			=		1,
	cmlLM_MAP2			=		2,
	cmlLM_MAP3			=		3,
	cmlLM_MAP4			=		4,
	cmlLM_MAP5			=		5,
	cmlLM_MAP6			=		6,
	cmlLM_MAP7			=		7,
	cmlLM_MAP8			=		8,
	cmlLM_MAP9			=		9,
	cmlLM_MAP10			=		10,
	cmlLM_MAP11			=		11,
	cmlLM_MAP12			=		12,
	cmlLM_MAP13			=		13,
	cmlLM_MAP14			=		14,
	cmlLM_MAP15			=		15,
	//////////////////////////////////////////////////////////////////////////
	cmlLM_MAP_INVALID	=		LX530S_MAX_SUPPORT_LISTED_MOTION			// Used for enumerated type range checking
} cmlLmMAP;

// -------------------------------------------------------------------
// Types of Listed Motion LmStsId (using to LmxGetStates, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmlLM_STATES_STARTED			= 0,		// Ʈ  ۵Ǿ, TRUE  ȴ.
	cmlLM_STATES_BUSY				= 1,		// Ʈ  ۵Ǿ, ش      TRUE  ȴ.
	cmlLM_STATES_RUN_ITEM_SEQ_ID	= 2,		//   Ʈ   ̵ ȯѴ.
	cmlLM_STATES_NC_BUFFER_STATUS	= 3,		// TRUE : [Buffer FREE], FALSE : [Buffer FULL]
	cmlLM_STATES_FREE_SPACE			= 4,		
	cmlLM_STATES_USED_SPACE			= 5,

	//////////////////////////////////////////////////////////////////////////
	cmlLM_STATES_INVALID				// Used for enumerated type range checking
} cmlLmStsId;

// -------------------------------------------------------------------
// Types of S5 Home operation parameter ID
// -------------------------------------------------------------------
typedef enum
{
		cmlHPID_HOME_MODE				= 0,
		cmlHPID_HOME_DIR				= 1,
		cmlHPID_HOME_OFFSET				= 2,
		cmlHPID_HOME_EZCOUNT			= 3,
		
		//////////////////////////////////////////////////////////////////////////
		cmlHPID_INVALID				// Used for enumerated type range checking
} cmlHomeParamId;

typedef enum
{
	cmlHOME_MODE_ORG_STOP		= 0,
	cmlHOME_MODE_ORG			= 1,
	cmlHOME_MODE_ORG_EZ			= 2,
	cmlHOME_MODE_EL				= 3,
	cmlHOME_MODE_EL_EZ			= 4,

	/////////////////////////////////////////////////////////////////////////
	cmlHOME_INVALID		= 13	// Used for enumerated type range checking
} cmlHOME_MODE;

typedef enum
{
		cmlHOME_PHASE0				= 0,
		cmlHOME_PHASE1				= 1,
		cmlHOME_PHASE2				= 2,
		
		//////////////////////////////////////////////////////////////////////////
		cmlHOME_PHASE_INVALID				// Used for enumerated type range checking
} cmlHomePhaseId;

typedef enum
{
		cmlENC_ABS					= 0,
		cmlENC_INC					= 1,

		//////////////////////////////////////////////////////////////////////////
		cmlENC_MODE_INVALID
} cmlENC_MODE;

// -------------------------------------------------------------------
// Types of Log Mode
// -------------------------------------------------------------------
#define cmlLOG_DISABLE			0
#define cmlLOG_OUTPUTDEBUG		1
#define	cmlLOG_FILE				2
#define cmlLOG_CONSOLE			4
#define cmlLOG_PIPE				8

// -------------------------------------------------------------------
// Types of Reset Configuration(ENVIRONMENT)
// -------------------------------------------------------------------
#define cmlRS_SX_ENV				0x00000001		// Sx Move Environment Restore Factory DEFAULTS
#define cmlRS_IX_ENV				0x00000002		// Ix Move Environment Restore Factory DEFAULTS
#define	cmlRS_LM_ENV				0x00000004		// Lm Move Environment Restore Factory DEFAULTS
#define cmlRS_SPEED_ENV				0x00000008		// Speed Configuration Environment Restore Factory DEFAULTS
#define cmlRS_HOME_ENV				0x00000010		// Hm Move Environment Restore Factory DEFAULTS
#define cmlRS_POS_ENV				0x00000020		// Position Environment Restore Factory DEFAULTS
#define cmlRS_BACKLASH_ENV			0x00000040		// Backlash Configuration Restore Factory Default
#define cmlRS_SWLIMIT_ENV			0x00000080		// S/W Limit Configuration Restore Factory Default
#define cmlRS_UPDATE_INTERVAL_ENV	0x00000040		// Update Interval Restore Factory DEFAULTS	(1msec)
#define cmlALL_RESET			cmlRS_SX_ENV | cmlRS_IX_ENV | cmlRS_LM_ENV | cmlRS_SPEED_ENV | cmlRS_HOME_ENV | cmlRS_POS_ENV | cmlRS_BACKLASH_ENV | cmlRS_SWLIMIT_ENV | cmlRS_UPDATE_INTERVAL_ENV


// -------------------------------------------------------------------
// Types of Log Level
// -------------------------------------------------------------------

// Log Include (Must log always)						: cmlLL_INCLUDE  -1
// No logging at all                                    : cmlLL_NONE	    0
// Log if Error occured in Function                     : cmlLL_ERROR		1
// Log only Command Functions                           : cmlLL_CMD			2
// Log Except Status (GetMotionStatus, etc)	            : cmlLL_STATUS		3
// Log ALL Functions                                    : cmlLL_ALL			4
// Log Exclude (Must Not log)							: cmlLL_EXCLUDE  5

#define cmlLL_INCLUDE	-1
#define cmlLL_NONE		0
#define cmlLL_ERROR	1
#define cmlLL_CMD		2
#define cmlLL_STATUS	3
#define cmlLL_ALL		4
#define cmlLL_EXCLUDE	5

// -------------------------------------------------------------------
// Network AMP Mechanical Input/Output Status 
// -------------------------------------------------------------------
typedef union
{
	struct
	{
		unsigned char INP:1;		// [YASKAWA : PSET]
		unsigned char DIR:1;		// [Move Direction]
		unsigned char HC:1;			// [Home Completed]
		unsigned char TL:1;			// [Toque Limited]
		unsigned char WARN:1;		// [SERVO Warning]
		unsigned char ALARM:1;		// [SERVO Alarm]
		unsigned char SVRDY:1;		// [YASKAWA : M_RDY]
		unsigned char SVON:1;		// [Servo On]
		
		unsigned char ELN:1;		// [YASKAWA : N_OT]
		unsigned char ELP:1;		// [YASKAWA : P_OT]
		unsigned char ORG:1;		// [Home Sensor]
		unsigned char EX_IN1:1;		// [YASKAWA : EXT1]
		unsigned char EX_IN2:1;		// [YASKAWA : EXT2]
		unsigned char EX_IN3:1;		// [YASKAWA : EXT3]
		unsigned char EX_IN4:1;		// [YASKAWA : DEC]
		unsigned char EMG_STP:1;	// [YASKAWA : ESTP]

		unsigned char CMDRDY:1;		// [CMDRDY]
		unsigned char DEN:1;		// [DEN]
		unsigned char ZPOINT:1;		// [ZPOINT]
		unsigned char L_CMP:1;		// [L_CMP]
		unsigned char NEAR:1;		// [NEAR]
		unsigned char P_SOT:1;		// [P_SOT]
		unsigned char N_SOT:1;		// [N_SOT]
		unsigned char Reaserved3:1;

		unsigned char PA:1;			// [PA]
		unsigned char PB:1;			// [PB]
		unsigned char PC:1;			// [PC]
		unsigned char BRK:1;		// [BRK]
		unsigned char HBB:1;		// [HBB]
		unsigned char Reaserved4:3;
	} b;
	unsigned int v;
} cmlMechnicalIO;

// -------------------------------------------------------------------
// NETIO Module Type
// -------------------------------------------------------------------
typedef enum
{
	cmlMT_DO	=0,	// DO
	cmlMT_DI,   	// DI
	cmlMT_DIO,		// DIO
	cmlMT_AI,		// AI
	cmlMT_AO,		// AO
	cmlMT_PM,		// Pulse Motion
	cmlMT_NONE		// None
}cmlNetioModuleType;

// -------------------------------------------------------------------
// Slave Type
// -------------------------------------------------------------------

typedef enum
{
	cmlST_NONE = -1,	// NONE
	cmlST_SERVO=0,		// NETWORK SERVO
	cmlST_IO,			// NETIO
	cmlST_NETC			// NETC01-M2
}cmlSlaveType;



// -------------------------------------------------------------------
// Definition for NETIO
// -------------------------------------------------------------------

// Motion I/O Property ID //
// MIO Property ID //
typedef enum _cmlPmMioPropId{
	cmlPM_ALM_LOGIC, cmlPM_ALM_MODE, cmlPM_CMP_LOGIC, cmlPM_DR_LOGIC, cmlPM_EL_LOGIC, cmlPM_EL_MODE, 
	cmlPM_ERC_LOGIC, cmlPM_ERC_OUT, cmlPM_EZ_LOGIC, cmlPM_INP_EN, cmlPM_INP_LOGIC, cmlPM_LTC_LOGIC, 
	cmlPM_LTC_LTC2SRC, cmlPM_ORG_LOGIC, cmlPM_SD_EN, cmlPM_SD_LOGIC, cmlPM_SD_LATCH, cmlPM_SD_MODE, cmlPM_STA_MODE,
	cmlPM_STA_TRG, cmlPM_STP_MODE, cmlPM_CLR_CNTR, cmlPM_CLR_SIGTYPE, cmlPM_CMP_PWIDTH, cmlPM_ERC_ONTIME, cmlPM_SVON_LOGIC,
}cmlPmMioPropId;

typedef enum _cmlPmMioPropIdEx{
	cmlPM_MPID_ALM_LOGIC,	cmlPM_MPID_ALM_MODE,	cmlPM_MPID_CMP_LOGIC,	cmlPM_MPID_DR_LOGIC,	cmlPM_MPID_EL_LOGIC,	cmlPM_MPID_EL_MODE, 
	cmlPM_MPID_ERC_LOGIC,	cmlPM_MPID_ERC_OUT,		cmlPM_MPID_EZ_LOGIC,	cmlPM_MPID_INP_EN,		cmlPM_MPID_INP_LOGIC,	cmlPM_MPID_LTC_LOGIC, 
	cmlPM_MPID_LTC_LTC2SRC,	cmlPM_MPID_ORG_LOGIC,	cmlPM_MPID_SD_EN,		cmlPM_MPID_SD_LOGIC,	cmlPM_MPID_SD_LATCH,	cmlPM_MPID_SD_MODE, 
	cmlPM_MPID_STA_MODE,	cmlPM_MPID_STA_TRG,		cmlPM_MPID_STP_MODE,	cmlPM_MPID_CLR_CNTR,	cmlPM_MPID_CLR_SIGTYPE,	cmlPM_MPID_CMP_PWIDTH, 
	cmlPM_MPID_ERC_ONTIME,	cmlPM_MPID_SVON_LOGIC,	cmlPM_MPID_ERC_OUT_EL,	cmlPM_MPID_CNT_D_SRC,	cmlPM_MPID_CNT_G_SRC,	cmlPM_MPID_LTC_TRGMODE,
	cmlPM_MPID_SLIM_EN=100,	cmlPM_MPID_OUT_MODE,	cmlPM_MPID_IN_MODE,		cmlPM_MPID_IN_INV,		cmlPM_MPID_cmlPM_G_EN
}cmlPmMioPropIdEx;

// Bit order of StReadMioStatuses() return value  //
typedef enum _cmlPmMioState{
	cmlPM_IOST_RDY, cmlPM_IOST_ALM,	  cmlPM_IOST_ELN,  cmlPM_IOST_ELP, cmlPM_IOST_ORG, 
	cmlPM_IOST_DIR, cmlPM_IOST_EZ,	  cmlPM_IOST_LTC,  cmlPM_IOST_SD,  cmlPM_IOST_INP, 
	cmlPM_IOST_DRN, cmlPM_IOST_DRP,	  cmlPM_IOST_STA,  cmlPM_IOST_STP, cmlPM_IOST_ALMR,
	cmlPM_IOST_EMG, cmlPM_IOST_SVON
}cmlPmMioState;

// Motion operation status ID //
typedef enum _cmlPmMotionState{ 
	cmlPM_MST_STOP,			cmlPM_MST_WAIT_DR,	cmlPM_MST_WAIT_STA,		cmlPM_MST_WAIT_INSYNC,	cmlPM_MST_WAIT_OTHER, 
	cmlPM_MST_WAIT_ERC,		cmlPM_MST_WAIT_DIR, cmlPM_MST_RESERVED1,	cmlPM_MST_WAIT_PLSR,	cmlPM_MST_IN_RVSSPD, 
	cmlPM_MST_IN_INISPD,		cmlPM_MST_IN_ACC,	cmlPM_MST_IN_WORKSPD,	cmlPM_MST_IN_DEC,		cmlPM_MST_WAIT_INP, 
	cmlPM_MST_ERROR,			cmlPM_MST_HOMMING,
}cmlPmMotionState;

// Signal logic definition //
typedef enum _cmlPmSigLogic{ 
	cmlPM_LOGIC_A=0 /*Normal open*/, cmlPM_LOGIC_B=1/*Normal close*/ 
}cmlPmSigLogic;

// Axis index definition //
typedef enum _cmlPmAxis{ 
	cmlPM_X1, cmlPM_Y1, cmlPM_Z1, cmlPM_U1, cmlPM_X2, cmlPM_Y2, cmlPM_Z2, cmlPM_U2 
}cmlPmAxis;

// Definition for axes mask  //
typedef enum _cmlPmAxisMask{ 
	cmlPM_X1_MASK=0x1, cmlPM_Y1_MASK=0x2, cmlPM_Z1_MASK=0x4, cmlPM_U1_MASK=0x8,
	cmlPM_X2_MASK=0x10, cmlPM_Y2_MASK=0x20, cmlPM_Z2_MASK=0x40, cmlPM_U2_MASK=0x80
}cmlPmAxisMask;

// Encoder and PA/PB input mode definition //
typedef enum _cmlPmInMode{ 
	cmlPM_IMODE_AB1X, cmlPM_IMODE_AB2X, cmlPM_IMODE_AB4X, cmlPM_IMODE_CWCCW, cmlPM_IMODE_STEP
}cmlPmInMode;

// Command output mode definition //
typedef enum _cmlPmOutMode{ 
	cmlPM_OMODE_PDIR0, cmlPM_OMODE_PDIR1, cmlPM_OMODE_PDIR2, cmlPM_OMODE_PDIR3,
	cmlPM_OMODE_CWCCW0, cmlPM_OMODE_CWCCW1, cmlPM_OMODE_CCWCW0, cmlPM_OMODE_CCWCW1
}cmlPmOutMode;

// Control Mode //
typedef enum _cmlPmCtrlMode{ 
	cmlPM_CTRL_OPEN, // Open loop control mode
	cmlPM_CTRL_SEMI_C, // Semi-closed loop control mode (applied only to absolute in-position commands)
	cmlPM_CTRL_FULL_C // Full-closed loop control mode (this is not supported at current version)
}cmlPmCtrlMode;

// (Linear)Operation direction //	
typedef enum _cmlPmDir{
	cmlPM_DIR_N /*(-)Dir*/, cmlPM_DIR_P /*(+)Dir*/
}cmlPmDir;

// Counter name //
typedef enum _cmlPmCntr { 
	cmlPM_CNT_COMM/*Command*/, cmlPM_CNT_FEED/*Feedback*/, cmlPM_CNT_DEV/*Deviation*/, 
	cmlPM_CNT_GEN/*General*/, cmlPM_CNT_REM/*Remained*/
}cmlPmCntr;

// Speed mode index definition //	
typedef enum _cmlPmSpeedMode{ 
	cmlPM_SMODE_KEEP=-1/* Keep previous setting*/, cmlPM_SMODE_C=0 /*Constant */, cmlPM_SMODE_T /*Trapeziodal*/, cmlPM_SMODE_S /*S-curve*/
}cmlPmSpeedMode;

// Arc operation direction //
typedef enum _cmlPmArcDir{ 
	cmlPM_ARC_CW, cmlPM_ARC_CCW
}cmlPmArcDir;

// Compare Method //
typedef enum _cmlPmCmpMethod{
	cmlPM_DISABLE, cmlPM_EQ_BIDIR, cmlPM_EQ_PDIR, cmlPM_EQ_NDIR, cmlPM_LESS/*Cnt<Data*/, cmlPM_GREATER/*Cnt>Data*/
}cmlPmCmpMethod;

// Action when general comparator met the condition //
typedef enum _cmlPmCmpAction{
	cmlPM_EVNT_ONLY, cmlPM_EVNT_IS, cmlPM_EVNT_DS, cmlPM_EVNT_SPDCHG
}cmlPmCmpAction;

// Backlash/Slip correction mode //
typedef enum _cmlPmCorrMode{
	cmlPM_CORR_DIS, // Disable correction 
	cmlPM_CORR_BACK, // Backlash correction mode 
	cmlPM_CORR_SLIP // Slip correction mode
}cmlPmCorrMode;

// Using for preregister option
typedef enum _cmlPmExtOptionId{
	cmlPM_EXOPT_SET_USE_PREREG
}cmlPmExtOptionId;

// Interrupt Handler Type //
typedef enum _cmlPmIntHandlerType{
	cmlPM_IHT_MESSAGE=0, cmlPM_IHT_EVENT, cmlPM_IHT_CALLBACK
}cmlPmIntHandlerType;

// Interrupt Handler Type //
typedef enum _cmlPmStringID{
	cmlPM_STR_AXIS_NAME, cmlPM_STR_DIST_UNIT, cmlPM_STR_SPEED_UNIT
}cmlPmStringID;

// Sequence Mode //
typedef enum _cmlPmSeqMode{
	cmlPM_SEQM_SKIP_RUN, cmlPM_SEQM_WAIT_RUN
}cmlPmSeqMode;

// Map Type //
typedef enum _cmlPmDevMapType{
	cmlPM_DMAP_MOTION, cmlPM_DMAP_DIO, cmlPM_DMAP_ALL
}cmlPmDevMapType;

// SetFilterAB  //
typedef enum _cmlPmABFilter{
	cmlPM_AB_ENC, cmlPM_AB_PULSAR
}cmlPmABFilter;

// Axis Capability ID //
typedef enum _cmlPmAxisCapID{
	cmlPM_CAPX_CMD_DIR=0, /* Command direction change function */
	cmlPM_CAPX_EL_MAN_SET, /* -/+EL Manual control function */
	cmlPM_CAPX_CMP_HIGH /* High-speed Compare Output function */
}cmlPmAxisCapID;

// Axis Return to home clear mode //
typedef enum _cmlPmHomePosClrMode{
	cmlPM_HPCM_DISABLE=-1, // Disable HomePosClearMode
	cmlPM_HPCM_M0, // ORG(/EL/EZ) ȣ ߻  COMMAND & FEEDBACK ġ 0 ŬѴ.
	cmlPM_HPCM_M1, // ͸  Ϸϰ  COMMAND & FEEDBACK ġ  0 ŬѴ.
	cmlPM_HPCM_M2  // ͸  Ϸϰ  FEEDBACK ġ ״ ΰ COMMAND ġ FEEDBACK ġ ġŲ.
}cmlPmHomePosClrMode;

typedef enum _cmlPmLatchTrgMode{
	cmlPM_LTM_LTC, // LTC Է ȣ ؼ  ġ ˴ϴ.
	cmlPM_LTM_ORG  // ORG Է ȣ ؼ  ġ ˴ϴ.
}cmlPmLatchTrgMode;

// Sync mode //
typedef enum _cmlPmSyncMode{
	cmlPM_SYNC_DISABLE,
	cmlPM_SYNC_INT_SYNC,
	cmlPM_SYNC_OTHER_STOP
}cmlPmSyncMode;

// Internal sync. conditions //
typedef enum _cmlPmIntSyncCond{
	cmlPM_ISYNC_ACC_STA, // 0: at start of acceleration
	cmlPM_ISYNC_ACC_END, // 1: at end of acceleration
	cmlPM_ISYNC_DEC_STA, // 2: at start of deceleration
	cmlPM_ISYNC_DEC_END, // 3: at end of deceleration
	cmlPM_ISYNC_SLN, // 4: when (-)software limit met
	cmlPM_ISYNC_SLP, // 5: when (+)software limit met
	cmlPM_ISYNC_GCMP, // 6: when General Comparator condition is satisfied
	cmlPM_ISYNC_TCMP // 7: when Trigger Comparator condition is satisfied
}cmlPmIntSyncCond;

// DIO Mode //
typedef enum _cmlDioMode{
	cmlDIOMODE_IN /*Input Mode*/, cmlDIOMODE_OUT /*Output Mode*/
}cmlDioMode;            


// -------------------------------------------------------------------
// Slave Info
// -------------------------------------------------------------------
typedef struct{
	unsigned short	ModuleType[LX530S_MAX_MODULE_IN_SLAVE];	// Connected module type. (cmlModuleType)
	unsigned short	nNumModule;							// Connected module's number.
	unsigned short	nSlaveType;							// Slave Mode (cmlSlaveType)
}cmlSlaveInfo;

// -------------------------------------------------------------------
// Definition of Real Time Status update Structure
// -------------------------------------------------------------------

typedef struct
{
	struct
	{
		unsigned int AxisMask; //  Ʈ   RTS ĵ Ȱȭ  
		struct
		{
			struct
			{
				unsigned int INP: 1;		// [YASKAWA : PSET]
				unsigned int DIR: 1;		// [Move Direction]
				unsigned int HC:1;			// [Home Completed]
				unsigned int TL:1;			// [Toque Limited]
				unsigned int WARN:1;		// [SERVO Warning]
				unsigned int ALARM:1;		// [SERVO Alarm]
				unsigned int SVRDY:1;		// [YASKAWA : M_RDY]
				unsigned int SVON:1;		// [Servo On]
				
				unsigned int ELN:1;			// [YASKAWA : N_OT]
				unsigned int ELP:1;			// [YASKAWA : P_OT]
				unsigned int ORG:1;			// [Home Sensor]
				unsigned int EX_IN1:1;		// [YASKAWA : EXT1]
				unsigned int EX_IN2:1;		// [YASKAWA : EXT2]
				unsigned int EX_IN3:1;		// [YASKAWA : EXT3]
				unsigned int EX_IN4:1;		// [YASKAWA : DEC]
				unsigned int EMG_STP:1;		// [YASKAWA : ESTP]
							
				unsigned char CMDRDY:1;		// [CMDRDY]
				unsigned char DEN:1;		// [DEN]
				unsigned char ZPOINT:1;		// [ZPOINT]
				unsigned char L_CMP:1;		// [L_CMP]
				unsigned char NEAR:1;		// [NEAR]
				unsigned char P_SOT:1;		// [P_SOT]
				unsigned char N_SOT:1;		// [N_SOT]
				unsigned char Reaserved3:1;

				unsigned char PA:1;			// [PA]
				unsigned char PB:1;			// [PB]
				unsigned char PC:1;			// [PC]
				unsigned char BRK:1;		// [BRK]
				unsigned char HBB:1;		// [HBB]
				unsigned char Reaserved4:3;
				
			}DW0;

			struct
			{
				unsigned int Torq: 7;	
				unsigned int FieldMode: 1;
				unsigned int Mst: 4;	
				unsigned int MMode: 4;	
				int  LastError: 8;
				unsigned int Reserved;
			}DW1;

			int CmdCnt;
			int FeedCnt;
			int CmdVel;
			int FeedVel;			
		}Axis[32];
	}NM;

	struct
	{
		unsigned int NodeMask;
		struct
		{
			// DIO
			unsigned int DI0:1;
			unsigned int DI1:1;
			unsigned int DI2:1;
			unsigned int DO0:1;
			unsigned int DO1:1;
			unsigned int DO2:1;

			struct
			{
				struct  
				{
					// Motion Stat.
					unsigned int MOT:4;
					
					// Servo On/Off
					unsigned int SVON:1;
					
					// Motion IO
					unsigned int SVRDY:1;
					unsigned int ALM:1;
					unsigned int ELM:1;
					unsigned int ELP:1;
					unsigned int ORG:1;
					unsigned int DIR:1;
					unsigned int EZ:1;
					unsigned int LTC:1;

					unsigned int SD:1;
					unsigned int INP:1;
					unsigned int DRN:1;
					unsigned int DRP:1;
					unsigned int STA:1;
					unsigned int STP:1;
					unsigned int ALMR:1;
					unsigned int EMG:1;

					int CmdCnt;
					int FeedCnt;
					int CmdVel;
				} Axis[2];
			}Module[9];
		}Node[32];
	}PM;

	struct
	{
		unsigned int NodeMask;
		struct
		{
			unsigned int Di[9];
			unsigned int Do[9];
			unsigned int Dio[9];
		}Node[32];
	}IO;
} cmlRtsData;

// -------------------------------------------------------------------
// Types of SDK(Software Development Kit) Error Codes
// -------------------------------------------------------------------

// The Winerror.h file contains a listing of static error codes used throughout Microsoft Windows operating system products
#include "winerror.h"

#define cmlERR_NONE					0
#define cmlERR_INVALID_BUFFER			-1	// Invalid Buffer range
#define cmlERR_AXIS_MOT_QUEUE_FULL		-2	// Listed Queue Full
#define cmlERR_CALLWDM_ERROR			-3 // WDM ̹  ȯ   
#define cmlERR_IMD_REPLY_FAIL			-5	// Immediately Reply Fail
#define cmlERR_IMD_QUEUE_FULL			-6	// Immediately Queue Full

#define cmlERR_NOT_ENOUGH_MEMORY		-8	// Not Enough memory.
#define cmlERR_INVALID_PARAMETER		-10	// Some of the function parameters are invalid
#define cmlERR_INVALID_AXIS				-11	// The axis setting parameter(s) is (are) invalid
#define cmlERR_INVALID_SPEED_SET		-12	// Speed setting value is not valid

#define cmlERR_INVALID_IXMAP			-13	// Invalid Interpolation Map
#define cmlERR_INVALID_LMMAP			-14	// Invalid Listed-Motion Map
#define cmlERR_INVALID_NUMAXIS			-15	// Invalid number of axis(Mx)

#define cmlERR_INVALID_FILEPATH			-16	// Invalid Config File Path
#define cmlERR_INVALID_CTRLMODE			-17	// Invalid Control Mode Applied

#define cmlERR_STOP_BY_SLP				-50	// Abnormally stopped by positive soft limit
#define cmlERR_STOP_BY_SLN				-51	// Abnormally stopped by negative soft limit
#define cmlERR_STOP_BY_ELP				-52	// Abnormally stopped by (-) external limit
#define cmlERR_STOP_BY_ELN				-53	// Abnormally stopped by (+) external limit
#define cmlERR_STOP_BY_ALM				-54	// Abnormally stopped by alarm input signal
#define cmlERR_STOP_BY_CER				-55	// Abnormally stopped by communication error between NC and Slave nodes

#define cmlERR_MOT_SEQ_SKIPPED			-60	// Motion Command has been skipped because the axis is already running
#define cmlERR_SKIP_BY_ALM				-61	// Motion Command has been skipped by ALM signal.
#define cmlERR_SKIP_BY_SERVO_OFF		-62	// Motion Command has been skipped by the ServoPack state is OFF.
#define cmlERR_FAILED_COMMAND_SERVO_ON	-63	// Motion Command ServoOn has been failed in retry command.
#define cmlERR_FAILED_COMMAND_SERVO_OFF	-64	// Motion Command ServoOff has been failed in retry command.

#define cmlERR_SKIP_BY_SEMG				-71	// Motion Command has been skipped by software emergency.
#define cmlERR_INVALID_LIBPARAM			-87 // Library Command Parameter is Invalid.

#define cmlERR_NODE_IS_NOT_SERVO			-1000	// Slave Device is Not Servo Driver
#define cmlERR_NODE_IS_NOT_NETIO			-1001	// Slave Device is Not NETIO Node Master
#define cmlERR_NODE_NOT_CONNECTED			-1002	// Slave Device is Not Connected

#define cmlERR_CHANNEL_OUT_OF_RANGE			-1010	// Slave Channel in Device is Out of Range
#define cmlERR_PARAMETER_OUT_OF_RANGE		-1011	// Given Parameter is Out of Range
#define cmlERR_PARAMETER_IS_NULL			-1012	// Parameter buffer is NULL
#define cmlERR_IXMAP_OUT_OF_RANGE			-1013	// Motion IxMapIndex is Out of Range

#define cmlERR_SET_AI_VOLT_RANGE_FAIL		-1020	// AiSetVoltRangeMode Failed
#define cmlERR_GET_AI_VOLT_RANGE_FAIL		-1021	// AiGetVoltRangeMode Failed
#define	cmlERR_GET_AI_RANGE_DIGIT_FAIL		-1022	// AiGetRangeDigit Failed

#define cmlERR_GET_AI_VOLT_FAIL				-1031	// AiGetVolt Failed
#define cmlERR_GET_AI_DIGIT_FAIL			-1032	// AiGetDigit Failed
#define cmlERR_GET_AI_CURRENT_FAIL			-1033	// AiGetCurrent Failed

#define cmlERR_AO_OUT_VOLT_FAIL				-1041	// AoOutVolt Failed
#define cmlERR_AO_OUT_DIGIT_FAIL			-1042	// AoOutDigit Failed
#define cmlERR_AO_OUT_CURRENT_FAIL			-1043	// AoOutCurrent Failed

#define cmlERR_DIO_TYPE_IS_NOT_MATCH		-1050	// DI/DO Type is not match

#define cmlERR_INVALID_MIO_PROP_ID			-1060	// CfgMioProperty ID is Invalid
#define cmlERR_CFG_UNIT_IS_ZERO				-1061	// CfgMioProperty Dist/Speed Unit is 0

#define cmlERR_HOME_SET_SUCCESS_FAILED		-1070	// HomeSetSuccess Failed

#define cmlERR_READ_MOTION_STATE_FAILED		-1080	// ReadMotionState Failed
#define cmlERR_READ_MACHINE_IO_FAILED		-1081	// ReadMIOStatus Failed
#define cmlERR_GET_COUNT_FAILED				-1082	// StGetCount Failed
#define cmlERR_GET_SPEED_FAILED				-1083	// StGetSpeed Failed

#define cmlERR_MS_REGISTER_SKIPPED			-1090	// Master/Slave Register Failed
#define cmlERR_MS_INVALID_AXIS_REGISTER		-1091	// Master/Slave Register Axis is Invalid
#define cmlERR_MS_REGISTER_SAME_AXIS		-1092	// Master/Slave Register Axis is same

#define cmlERR_DEVICE_NOT_FOUND				-1168	// MLink2 Device is not detected.
#define cmlERR_DEVICE_NOT_AVAILABLE			-4319	// MLink2 Device is not available.

#endif
