/*******************************************************************************
* [ ComiLX530_SDK_Def.h ]
* Header file for definitions of constants and data in LX530 library
* - Update Data: 2016/07/08
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#ifndef __COMI_LX530_SDK_DEF_H__
#define __COMI_LX530_SDK_DEF_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// -------------------------------------------------------------------
// Declare Const Values in LX530 Library
// -------------------------------------------------------------------
#define LX540_MAX_SUPPORT_MASTER_BOARDS				16
#define LX530_MAX_SUPPORT_SLAVE_AXES					32
#define LX530_MAX_SUPPORT_INTERPOLATION_MOTION		16
#define	LX530_MAX_SUPPORT_LISTED_MOTION				16
#define LX530_MAX_SUPPORT_LISTED_MOTION_USER_PARAM	4
#define LX530_MAX_MODULE_IN_SLAVE						9
#define LX530_MAX_SUPPORT_IN_NODE_AXES				2

#define MAX_NUM_PLATFORM	4   // RTEX, MECHA, SSCNET
#define MAX_NUM_FUNC		600
// -------------------------------------------------------------------
// General Type
// -------------------------------------------------------------------
#ifndef	TRUE
#define TRUE	1
#endif

#ifndef	FALSE
#define FALSE	0
#endif

// -------------------------------------------------------------------
// General BOOLEAN Type Definition
// -------------------------------------------------------------------
typedef enum
{
	cmcFALSE			= 0,
	cmcTRUE			= 1,
	
	//////////////////////////////////////////////////////////////////////////
	cmcBOOLEAN_INVALID		// Used for enumerated type range checking
} cmcBOOLEAN;

// -------------------------------------------------------------------
// Type of  COM State Id (using to GnSetCommStates, GnGetCommStates)
// -------------------------------------------------------------------
typedef enum
{
	cmcCSID_COM_STATES	=	0,
	cmcCSID_RTS_COUNT	=	1,
	cmcCSID_CMD_COUNT	=	2,
	cmcCSID_COM_RST		=	3,	// Only 'Set' Support

	//////////////////////////////////////////////////////////////////////////
	cmcCSID_INVALID				// Used for enumerated type range checking
} cmcCommStates;

// -------------------------------------------------------------------
// Types of [emCOM_STATES] 'States' (using to GnSetCommStates, GnGetCommStates)
// -------------------------------------------------------------------
typedef enum
{
	cmcCOM_STATE_RESET		= -1,
	cmcCOM_STATE_INIT		= 0,
	cmcCOM_STATE_WAITING		= 1,
	cmcCOM_STATE_PREPARE		= 2,
	cmcCOM_STATE_START		= 3,
	cmcCOM_STATE_RUNNING		= 4,

	//////////////////////////////////////////////////////////////////////////
	cmcCOM_STATE_INVALID	// Used for enumerated type range checking
} cmcCOM_STATES;


// -------------------------------------------------------------------
// Types of Motion State(using to StSxReadMotionState, StIxReadMotionState)
// -------------------------------------------------------------------
typedef enum
{
	cmcMST_STOP		=			0,
	cmcMST_IN_ACC	=			1,
	cmcMST_IN_WORKSPD=			2,
	cmcMST_IN_DEC	=			3,
	cmcMST_IN_INISPD	=			4,
	cmcMST_IN_WAIT	=			5,
	
	//////////////////////////////////////////////////////////////////////////
	cmcMST_IN_INVALID				// Used for enumerated type range checking
} cmcMotionState;

// -------------------------------------------------------------------
// Types of Linear Operation Direction (using to SxVMoveStart, MxVMoveStart)
// -------------------------------------------------------------------
typedef enum
{
	cmcDIR_N			=			0,
	cmcDIR_P			=			1,

	//////////////////////////////////////////////////////////////////////////
	cmcDIR_INVALID					// Used for enumerated type range checking
} cmcDir;

// Counter name //
typedef enum { 
	cmcCNT_COMM = 0, /*Command*/
	cmcCNT_FEED,		/*Feedback*/
	cmcCNT_DEV,		/*Deviation*/
	cmcCNT_GEN,		/*General*/ 

	//////////////////////////////////////////////////////////////////////////
	cmcCNT_INVALID					// Used for enumerated type range checking
}cmcCmCntr;


// -------------------------------------------------------------------
// Types of Machine I/O Property ID (using to CfgSetMioProperty, CfgGetMioProperty)
// -------------------------------------------------------------------
typedef enum
{
	cmcMIO_PEL_LOGIC =			0,	// Property Val [ cmcLOGIC_A    | cmcLOGIC_B ] (Default : cmcLOGIC_A)
	cmcMIO_NEL_LOGIC =			1,	// Property Val [ cmcLOGIC_A    | cmcLOGIC_B ] (Default : cmcLOGIC_A)
	cmcMIO_ORG_LOGIC =			2,	// Property Val [ cmcLOGIC_A    | cmcLOGIC_B ] (Default : cmcLOGIC_A)
	cmcMIO_EL_MODE	=			3,	// Property Val [ 0 : Emg Stop | 1 : Stop  ] (Default : Emg Stop )
	cmcMIO_INP_EN	=			4,	// Property Val [ 0 : INP[D]   | 1 : INP[E]] (Default : INP[D]   )
	cmcMIO_CFSYNC_EN = 			5,	// Property Val [ 0 : Disable  | 1 : Enable] (Default : Disable  )
	cmcMIO_SVON_MODE =			6,	
	cmcMIO_VELCTRL_MODE =		7,	// Property Val [ 0 : Position Control Mode  | 1 : Velocity Control Mode  (Default : Position Control Mode ) 
	cmcMIO_VELCTRL_MAXRPM =		8,	///<ӵ     ִ RPM
	cmcMIO_VELCTRL_PPR =		9,	///<ӵ     ȸ  ޽ 

	
	/////////////////////////////////////////////////////////////////////
	cmcMIO_INVALID					// Used for enumerated type range checking
} cmcMIOID;

// -------------------------------------------------------------------
// Types of Machine I/O Property Value (using to CfgSetMioProperty, CfgGetMioProperty)
// -------------------------------------------------------------------
typedef enum
{
	cmcLOGIC_A		=			0,
	cmcLOGIC_B		=			1,
	
	//////////////////////////////////////////////////////////////////////////
	cmcLOGIC_INVALID					// Used for enumerated type range checking
} cmcMIOVALUE;

// -------------------------------------------------------------------
// Types of Speed Mode Value (using to CfgSetSpeedPattern, CfgGetSpeedPattern)
// -------------------------------------------------------------------
typedef enum
{
	cmcSPEED_CONSTANT	=		0,
	cmcSPEED_TRAPEZOIDAL	=		1,
	cmcSPEED_SCURVE		=		2,

	//////////////////////////////////////////////////////////////////////////
	cmcSPEED_INVALID					// Used for enumerated type range checking
} cmcVMode;

// -------------------------------------------------------------------
// Types of Backlash/Slip Correction Mode Value (using to SxSetCorrection, SxGetCorrection)
// -------------------------------------------------------------------
typedef enum
{
	cmcCORR_DISABLE		=		0,
	cmcCORR_BACKLASH		=		1,
	cmcCORR_SLIP			=		2,

	//////////////////////////////////////////////////////////////////////////
	cmcCORR_INVALID					// Used for enumerated type range checking
} cmcCorrMode;

// -------------------------------------------------------------------
// Types of Machine I/O State Bit Index (using to StReadMioStatuses)
// -------------------------------------------------------------------
typedef enum
{
	cmcIOST_INP			=		0,
	cmcIOST_RESERVED_00		=		1,
	cmcIOST_HOMECOMPLETED		=		2,
	cmcIOST_TORQUELIMITED		=		3,
	cmcIOST_WARNING			=		4,
	cmcIOST_ALARM			=		5,
	cmcIOST_SVRDY			=		6,
	cmcIOST_SVON			=		7,
	cmcIOST_ELN			=		8,
	cmcIOST_ELP			=		9,
	cmcIOST_ORG			=		10,
	cmcIOST_EX_IN1			=		11,
	cmcIOST_EX_IN2			=		12,
	cmcIOST_EX_IN3			=		13,
	cmcIOST_EX_IN4			=		14,
	cmcIOST_EMG_STP			=		15,
	cmcIOST_RESERVED_01		=		16,
	cmcIOST_RESERVED_02		=		20,
	cmcIOST_ZSPD			=		28,
	cmcIOST_DEN			=		29,
	cmcIOST_BREAKON			=		30,
	cmcIOST_ZPOINT			=		31,


	/////////////////////////////////////////////////////////////////////////
	cmcIOST_INVALID					// Used for enumerated type range checking
} cmcIoST;

// -------------------------------------------------------------------
// Types of Interpolation Map Index (using to IxMapAxes, IxUnMapAxes, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmcIX_MAP0			=		0,
	cmcIX_MAP1			=		1,
	cmcIX_MAP2			=		2,
	cmcIX_MAP3			=		3,
	cmcIX_MAP4			=		4,
	cmcIX_MAP5			=		5,
	cmcIX_MAP6			=		6,
	cmcIX_MAP7			=		7,
	cmcIX_MAP8			=		8,
	cmcIX_MAP9			=		9,
	cmcIX_MAP10			=		10,
	cmcIX_MAP11			=		11,
	cmcIX_MAP12			=		12,
	cmcIX_MAP13			=		13,
	cmcIX_MAP14			=		14,
	cmcIX_MAP15			=		15,
	//////////////////////////////////////////////////////////////////////////
	cmcIX_MAP_INVALID	=       LX530_MAX_SUPPORT_INTERPOLATION_MOTION	// Used for enumerated type range checking
} cmcixMAP;

// -------------------------------------------------------------------
// Types of interpolation mode(using to IxMapAxes)
// -------------------------------------------------------------------
typedef enum 
{
	cmcIX_MODE_LINEAR		= 0,
	cmcIX_MODE_CIRCULAR	= 1,
	cmcIX_MODE_HELICARL	= 2,
	cmcIX_MODE_SPLINE		= 3,
		
	//////////////////////////////////////////////////////////////////////////
	cmcIX_MODE_INVALID					// Used for enumerated type range checking
} cmcixMODE;

// -------------------------------------------------------------------
// Types of interpolation mode(using to ArcA, ArcP)
// -------------------------------------------------------------------
typedef enum
{
	cmcARC_CW		= 0,
	cmcARC_CCW		= 1,

	//////////////////////////////////////////////////////////////////////////
	cmcARC_INVALID					// Used for enumerated type range checking
} cmcixARC_DIR;

// -------------------------------------------------------------------
// Types of return to home mode(using to HomeSetConfig, HomeGetConfig)
// -------------------------------------------------------------------
typedef enum
{
	cmcHOME_MODE0	= 0,
	cmcHOME_MODE1	= 1,
	cmcHOME_MODE2	= 2,
	cmcHOME_MODE3	= 3,
	cmcHOME_MODE4	= 4,

	//////////////////////////////////////////////////////////////////////////
	cmcHOME_MODE_INVALID				// Used for enumerated type range checking
} cmchmMODE;

// -------------------------------------------------------------------
// Types of return to home position clear mode (using to HomeSetPosClrMode, HomeGetPosClrMode)
// -------------------------------------------------------------------
typedef enum
{
	cmcHPCM_M0		= 0,
	cmcHPCM_M1		= 1,
	cmcHPCM_M2		= 2,
	cmcHPCM_KEEP		= 3,

	//////////////////////////////////////////////////////////////////////////
	cmcHPCM_MODE_INVALID				// Used for enumerated type range checking
} cmchpcMODE;

// -------------------------------------------------------------------
// Types of Listed Motion Map Index (using to LmStart, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmcLM_MAP0			=		0,
	cmcLM_MAP1			=		1,
	cmcLM_MAP2			=		2,
	cmcLM_MAP3			=		3,
	cmcLM_MAP4			=		4,
	cmcLM_MAP5			=		5,
	cmcLM_MAP6			=		6,
	cmcLM_MAP7			=		7,
	cmcLM_MAP8			=		8,
	cmcLM_MAP9			=		9,
	cmcLM_MAP10			=		10,
	cmcLM_MAP11			=		11,
	cmcLM_MAP12			=		12,
	cmcLM_MAP13			=		13,
	cmcLM_MAP14			=		14,
	cmcLM_MAP15			=		15,
	//////////////////////////////////////////////////////////////////////////
	cmcLM_MAP_INVALID	=		LX530_MAX_SUPPORT_LISTED_MOTION			// Used for enumerated type range checking
} cmclmMAP;

// -------------------------------------------------------------------
// Types of Listed Motion LmStsId (using to LmxGetStates, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmcLM_STATES_STARTED				= 0,		// Ʈ  ۵Ǿ, TRUE  ȴ.
	cmcLM_STATES_BUSY				= 1,		// Ʈ  ۵Ǿ, ش      TRUE  ȴ.
	cmcLM_STATES_RUN_ITEM_SEQ_ID		= 2,		//   Ʈ   ̵ ȯѴ.
	cmcLM_STATES_NC_BUFFER_STATUS	= 3,		// TRUE : [Buffer FREE], FALSE : [Buffer FULL]
	cmcLM_STATES_FREE_SPACE			= 4,		
	cmcLM_STATES_USED_SPACE			= 5,

	//////////////////////////////////////////////////////////////////////////
	cmcLM_STATES_INVALID				// Used for enumerated type range checking
} cmcLmStsId;
// -------------------------------------------------------------------
// Types of S5 Home operation parameter ID
// -------------------------------------------------------------------
typedef enum
{
		cmcHPID_HOME_MODE				= 0,
		cmcHPID_HOME_DIR					= 1,

//		emHPID_HOME_OFFSET				= 2,
/*
		emHOME_S5_DIRECTION				= 0,		// 
		emHOME_S5_FINAL_DIST			= 1,		// 
		emHOME_S5_FWD_LTC_AREA			= 2,		
		emHOME_S5_RVS_LTC_AREA			= 3,
		emHOME_S5_LTC_SIG_SEL			= 4,
		emHOME_S5_TORQ_LIMIT			= 5,

		emHOME_S5_HOME_MODE				= 6,
*/		
		//////////////////////////////////////////////////////////////////////////
		cmcHPID_INVALID				// Used for enumerated type range checking
} cmcHomeParamId;

// -------------------------------------------------------------------
// Types of Log Mode
// -------------------------------------------------------------------
#define cmcLOG_DISABLE			0
#define cmcLOG_OUTPUTDEBUG		1
#define	cmcLOG_FILE			2
#define cmcLOG_CONSOLE			4
#define cmcLOG_PIPE			8

// -------------------------------------------------------------------
// Types of Reset Configuration(ENVIRONMENT)
// -------------------------------------------------------------------
#define cmcRS_SX_ENV				0x00000001		// Sx Move Environment Restore Factory DEFAULTS
#define cmcRS_IX_ENV				0x00000002		// Ix Move Environment Restore Factory DEFAULTS
#define	cmcRS_LM_ENV				0x00000004		// Lm Move Environment Restore Factory DEFAULTS
#define cmcRS_SPEED_ENV			0x00000008		// Speed Configuration Environment Restore Factory DEFAULTS
#define cmcRS_HOME_ENV				0x00000010		// Hm Move Environment Restore Factory DEFAULTS
#define cmcRS_POS_ENV				0x00000020		// Position Environment Restore Factory DEFAULTS
#define cmcRS_BACKLASH_ENV			0x00000040		// Backlash Configuration Restore Factory Default
#define cmcRS_SWLIMIT_ENV			0x00000080		// S/W Limit Configuration Restore Factory Default
#define cmcRS_UPDATE_INTERVAL_ENV	0x00000040		// Update Interval Restore Factory DEFAULTS	(1msec)
#define cmcALL_RESET			cmcRS_SX_ENV | cmcRS_IX_ENV | cmcRS_LM_ENV | cmcRS_SPEED_ENV | cmcRS_HOME_ENV | cmcRS_POS_ENV | cmcRS_BACKLASH_ENV | cmcRS_SWLIMIT_ENV | cmcRS_UPDATE_INTERVAL_ENV


// -------------------------------------------------------------------
// Types of Log Level
// -------------------------------------------------------------------

// Log Include (Must log always)												: cmcLL_INCLUDE  -1
// No logging at all                                    : cmcLL_NONE	    0
// Log if Error occured in Function                     : cmcLL_ERROR		1
// Log only Command Functions                           : cmcLL_CMD			2
// Log Except Status (GetMotionStatus, etc)	            : cmcLL_STATUS		3
// Log ALL Functions                                    : cmcLL_ALL			4
// Log Exclude (Must Not log)														: cmcLL_EXCLUDE  5

#define cmcLL_INCLUDE	-1
#define cmcLL_NONE		0
#define cmcLL_ERROR	1
#define cmcLL_CMD		2
#define cmcLL_STATUS	3
#define cmcLL_ALL		4
#define cmcLL_EXCLUDE	5

//#define cmcLL_NONE		0
//#define cmcLL_STATE	1
//#define cmcLL_CLIENTS	1
//#define cmcLL_CONNERR	0
//#define	cmcLL_SOCKERR	4
//#define cmcLL_INTERR	0
//#define	cmcLL_INTWARN	8
//#define cmcLL_INTINFO	9
//#define cmcLL_SOCKINFO	10
//#define cmcLL_ALL		10

// -------------------------------------------------------------------
// Network AMP Mechanical Input/Output Status 
// -------------------------------------------------------------------
typedef union
{
	struct
	{
		unsigned char INP:1;						// [RTEX : INP] , [YASKAWA : PSET]
		unsigned char Reserved_00:1;
		unsigned char HC:1;		// [Home Completed]
		unsigned char TL:1;		// [Toque Limited]
		unsigned char WARN:1;	// [SERVO Warning]
		unsigned char ALARM:1;	// [SERVO Alarm]
		unsigned char SVRDY:1;	// [RTEX : SERVO RDY] , [YASKAWA : M_RDY]
		unsigned char SVON:1;	// [Servo On]
		
		unsigned char ELN:1;	// [RTEX : EL-] , [YASKAWA : N_OT]
		unsigned char ELP:1;	// [RTEX : EL+] , [YASKAWA : P_OT]
		unsigned char ORG:1;	// [Home Sensor]
		unsigned char EX_IN1:1;	// [RTEX : EX_IN1] , [YASKAWA : EXT1]
		unsigned char EX_IN2:1;	// [RTEX : EX_IN2] , [YASKAWA : EXT2]
		unsigned char EX_IN3:1;	// [RTEX : EX_IN3] , [YASKAWA : EXT3]
		unsigned char EX_IN4:1;	// [RTEX : EX_IN4] , [YASKAWA : DEC]
		unsigned char EMG_STP:1;// [RTEX : EMG_STP], [YASKAWA : ESTP]

		unsigned char Reserved_01:4;
		unsigned char Reserved_02:8;
		
		unsigned char ZSPD:1;	// [YASKAWA Only]
		unsigned char DEN:1;	// [YASKAWA Only]
		unsigned char BRK_ON:1;	// [YASKAWA Only]
		unsigned char ZPOINT:1;	// [YASKAWA Only]
	} b;
	unsigned int v;
} cmcMechnicalIO;

// -------------------------------------------------------------------
// NETIO Module Type
// -------------------------------------------------------------------
typedef enum
{
	cmcMT_DO=0,	// DO
	cmcMT_DI,   	// DI
	cmcMT_DIO,	// DIO
	cmcMT_AI,	// AI
	cmcMT_AO,	// AO
	cmcMT_PM,	// Pulse Motion
	cmcMT_NONE	// None
}cmcNetioModuleType;

// -------------------------------------------------------------------
// Slave Type
// -------------------------------------------------------------------

typedef enum
{
	cmcST_SERVO=0,	// NETWORK SERVO
	cmcST_IO,		// NETIO
	cmcST_NONE		// NONE
}cmcSlaveType;



// -------------------------------------------------------------------
// Definition for NETIO
// -------------------------------------------------------------------

// Motion I/O Property ID //
// MIO Property ID //
typedef enum _cmcPmMioPropId{
	cmcPM_ALM_LOGIC, cmcPM_ALM_MODE, cmcPM_CMP_LOGIC, cmcPM_DR_LOGIC, cmcPM_EL_LOGIC, cmcPM_EL_MODE, 
	cmcPM_ERC_LOGIC, cmcPM_ERC_OUT, cmcPM_EZ_LOGIC, cmcPM_INP_EN, cmcPM_INP_LOGIC, cmcPM_LTC_LOGIC, 
	cmcPM_LTC_LTC2SRC, cmcPM_ORG_LOGIC, cmcPM_SD_EN, cmcPM_SD_LOGIC, cmcPM_SD_LATCH, cmcPM_SD_MODE, cmcPM_STA_MODE,
	cmcPM_STA_TRG, cmcPM_STP_MODE, cmcPM_CLR_CNTR, cmcPM_CLR_SIGTYPE, cmcPM_CMP_PWIDTH, cmcPM_ERC_ONTIME, cmcPM_SVON_LOGIC,
}cmcPmMioPropId;

typedef enum _cmcPmMioPropIdEx{
	cmcPM_MPID_ALM_LOGIC,	cmcPM_MPID_ALM_MODE,	cmcPM_MPID_CMP_LOGIC,	cmcPM_MPID_DR_LOGIC,	cmcPM_MPID_EL_LOGIC,	cmcPM_MPID_EL_MODE, 
	cmcPM_MPID_ERC_LOGIC,	cmcPM_MPID_ERC_OUT,		cmcPM_MPID_EZ_LOGIC,	cmcPM_MPID_INP_EN,		cmcPM_MPID_INP_LOGIC,	cmcPM_MPID_LTC_LOGIC, 
	cmcPM_MPID_LTC_LTC2SRC,	cmcPM_MPID_ORG_LOGIC,	cmcPM_MPID_SD_EN,		cmcPM_MPID_SD_LOGIC,	cmcPM_MPID_SD_LATCH,	cmcPM_MPID_SD_MODE, 
	cmcPM_MPID_STA_MODE,	cmcPM_MPID_STA_TRG,		cmcPM_MPID_STP_MODE,	cmcPM_MPID_CLR_CNTR,	cmcPM_MPID_CLR_SIGTYPE,	cmcPM_MPID_CMP_PWIDTH, 
	cmcPM_MPID_ERC_ONTIME,	cmcPM_MPID_SVON_LOGIC,	cmcPM_MPID_ERC_OUT_EL,	cmcPM_MPID_CNT_D_SRC,	cmcPM_MPID_CNT_G_SRC,	cmcPM_MPID_LTC_TRGMODE,
	cmcPM_MPID_SLIM_EN=100,	cmcPM_MPID_OUT_MODE,	cmcPM_MPID_IN_MODE,		cmcPM_MPID_IN_INV,		cmcPM_MPID_cmcPM_G_EN
}cmcPmMioPropIdEx;

// Bit order of StReadMioStatuses() return value  //
typedef enum _cmcPmMioState{
	cmcPM_IOST_RDY, cmcPM_IOST_ALM,	  cmcPM_IOST_ELN,  cmcPM_IOST_ELP, cmcPM_IOST_ORG, 
	cmcPM_IOST_DIR, cmcPM_IOST_EZ,	  cmcPM_IOST_LTC,  cmcPM_IOST_SD,  cmcPM_IOST_INP, 
	cmcPM_IOST_DRN, cmcPM_IOST_DRP,	  cmcPM_IOST_STA,  cmcPM_IOST_STP, cmcPM_IOST_ALMR,
	cmcPM_IOST_EMG, cmcPM_IOST_SVON
}cmcPmMioState;

// Motion operation status ID //
typedef enum _cmcPmMotionState{ 
	cmcPM_MST_STOP,			cmcPM_MST_WAIT_DR,	cmcPM_MST_WAIT_STA,		cmcPM_MST_WAIT_INSYNC,	cmcPM_MST_WAIT_OTHER, 
	cmcPM_MST_WAIT_ERC,		cmcPM_MST_WAIT_DIR, cmcPM_MST_RESERVED1,	cmcPM_MST_WAIT_PLSR,	cmcPM_MST_IN_RVSSPD, 
	cmcPM_MST_IN_INISPD,		cmcPM_MST_IN_ACC,	cmcPM_MST_IN_WORKSPD,	cmcPM_MST_IN_DEC,		cmcPM_MST_WAIT_INP, 
	cmcPM_MST_ERROR,			cmcPM_MST_HOMMING,
}cmcPmMotionState;

// Signal logic definition //
typedef enum _cmcPmSigLogic{ 
	cmcPM_LOGIC_A=0 /*Normal open*/, cmcPM_LOGIC_B=1/*Normal close*/ 
}cmcPmSigLogic;

// Axis index definition //
typedef enum _cmcPmAxis{ 
	cmcPM_X1, cmcPM_Y1, cmcPM_Z1, cmcPM_U1, cmcPM_X2, cmcPM_Y2, cmcPM_Z2, cmcPM_U2 
}cmcPmAxis;

// Definition for axes mask  //
typedef enum _cmcPmAxisMask{ 
	cmcPM_X1_MASK=0x1, cmcPM_Y1_MASK=0x2, cmcPM_Z1_MASK=0x4, cmcPM_U1_MASK=0x8,
	cmcPM_X2_MASK=0x10, cmcPM_Y2_MASK=0x20, cmcPM_Z2_MASK=0x40, cmcPM_U2_MASK=0x80
}cmcPmAxisMask;

// Encoder and PA/PB input mode definition //
typedef enum _cmcPmInMode{ 
	cmcPM_IMODE_AB1X, cmcPM_IMODE_AB2X, cmcPM_IMODE_AB4X, cmcPM_IMODE_CWCCW, cmcPM_IMODE_STEP
}cmcPmInMode;

// Command output mode definition //
typedef enum _cmcPmOutMode{ 
	cmcPM_OMODE_PDIR0, cmcPM_OMODE_PDIR1, cmcPM_OMODE_PDIR2, cmcPM_OMODE_PDIR3,
	cmcPM_OMODE_CWCCW0, cmcPM_OMODE_CWCCW1, cmcPM_OMODE_CCWCW0, cmcPM_OMODE_CCWCW1
}cmcPmOutMode;

// Control Mode //
typedef enum _cmcPmCtrlMode{ 
	cmcPM_CTRL_OPEN, // Open loop control mode
	cmcPM_CTRL_SEMI_C, // Semi-closed loop control mode (applied only to absolute in-position commands)
	cmcPM_CTRL_FULL_C // Full-closed loop control mode (this is not supported at current version)
}cmcPmCtrlMode;

// (Linear)Operation direction //	
typedef enum _cmcPmDir{
	cmcPM_DIR_N /*(-)Dir*/, cmcPM_DIR_P /*(+)Dir*/
}cmcPmDir;

// Counter name //
typedef enum _cmcPmCntr { 
	cmcPM_CNT_COMM/*Command*/, cmcPM_CNT_FEED/*Feedback*/, cmcPM_CNT_DEV/*Deviation*/, 
	cmcPM_CNT_GEN/*General*/, cmcPM_CNT_REM/*Remained*/
}cmcPmCntr;

// Speed mode index definition //	
typedef enum _cmcPmSpeedMode{ 
	cmcPM_SMODE_KEEP=-1/* Keep previous setting*/, cmcPM_SMODE_C=0 /*Constant */, cmcPM_SMODE_T /*Trapeziodal*/, cmcPM_SMODE_S /*S-curve*/
}cmcPmSpeedMode;

// Arc operation direction //
typedef enum _cmcPmArcDir{ 
	cmcPM_ARC_CW, cmcPM_ARC_CCW
}cmcPmArcDir;

// Compare Method //
typedef enum _cmcPmCmpMethod{
	cmcPM_DISABLE, cmcPM_EQ_BIDIR, cmcPM_EQ_PDIR, cmcPM_EQ_NDIR, cmcPM_LESS/*Cnt<Data*/, cmcPM_GREATER/*Cnt>Data*/
}cmcPmCmpMethod;

// Action when general comparator met the condition //
typedef enum _cmcPmCmpAction{
	cmcPM_EVNT_ONLY, cmcPM_EVNT_IS, cmcPM_EVNT_DS, cmcPM_EVNT_SPDCHG
}cmcPmCmpAction;

// Backlash/Slip correction mode //
typedef enum _cmcPmCorrMode{
	cmcPM_CORR_DIS, // Disable correction 
	cmcPM_CORR_BACK, // Backlash correction mode 
	cmcPM_CORR_SLIP // Slip correction mode
}cmcPmCorrMode;

// Using for preregister option
typedef enum _cmcPmExtOptionId{
	cmcPM_EXOPT_SET_USE_PREREG
}cmcPmExtOptionId;

// Interrupt Handler Type //
typedef enum _cmcPmIntHandlerType{
	cmcPM_IHT_MESSAGE=0, cmcPM_IHT_EVENT, cmcPM_IHT_CALLBACK
}cmcPmIntHandlerType;

// Interrupt Handler Type //
typedef enum _cmcPmStringID{
	cmcPM_STR_AXIS_NAME, cmcPM_STR_DIST_UNIT, cmcPM_STR_SPEED_UNIT
}cmcPmStringID;

// Sequence Mode //
typedef enum _cmcPmSeqMode{
	cmcPM_SEQM_SKIP_RUN, cmcPM_SEQM_WAIT_RUN
}cmcPmSeqMode;

// Map Type //
typedef enum _cmcPmDevMapType{
	cmcPM_DMAP_MOTION, cmcPM_DMAP_DIO, cmcPM_DMAP_ALL
}cmcPmDevMapType;

// SetFilterAB  //
typedef enum _cmcPmABFilter{
	cmcPM_AB_ENC, cmcPM_AB_PULSAR
}cmcPmABFilter;

// Axis Capability ID //
typedef enum _cmcPmAxisCapID{
	cmcPM_CAPX_CMD_DIR=0, /* Command direction change function */
	cmcPM_CAPX_EL_MAN_SET, /* -/+EL Manual control function */
	cmcPM_CAPX_CMP_HIGH /* High-speed Compare Output function */
}cmcPmAxisCapID;

// Axis Return to home clear mode //
typedef enum _cmcPmHomePosClrMode{
	cmcPM_HPCM_DISABLE=-1, // Disable HomePosClearMode
	cmcPM_HPCM_M0, // ORG(/EL/EZ) ȣ ߻  COMMAND & FEEDBACK ġ 0 ŬѴ.
	cmcPM_HPCM_M1, // ͸  Ϸϰ  COMMAND & FEEDBACK ġ  0 ŬѴ.
	cmcPM_HPCM_M2  // ͸  Ϸϰ  FEEDBACK ġ ״ ΰ COMMAND ġ FEEDBACK ġ ġŲ.
}cmcPmHomePosClrMode;

typedef enum _cmcPmLatchTrgMode{
	cmcPM_LTM_LTC, // LTC Է ȣ ؼ  ġ ˴ϴ.
	cmcPM_LTM_ORG  // ORG Է ȣ ؼ  ġ ˴ϴ.
}cmcPmLatchTrgMode;

// Sync mode //
typedef enum _cmcPmSyncMode{
	cmcPM_SYNC_DISABLE,
	cmcPM_SYNC_INT_SYNC,
	cmcPM_SYNC_OTHER_STOP
}cmcPmSyncMode;

// Internal sync. conditions //
typedef enum _cmcPmIntSyncCond{
	cmcPM_ISYNC_ACC_STA, // 0: at start of acceleration
	cmcPM_ISYNC_ACC_END, // 1: at end of acceleration
	cmcPM_ISYNC_DEC_STA, // 2: at start of deceleration
	cmcPM_ISYNC_DEC_END, // 3: at end of deceleration
	cmcPM_ISYNC_SLN, // 4: when (-)software limit met
	cmcPM_ISYNC_SLP, // 5: when (+)software limit met
	cmcPM_ISYNC_GCMP, // 6: when General Comparator condition is satisfied
	cmcPM_ISYNC_TCMP // 7: when Trigger Comparator condition is satisfied
}cmcPmIntSyncCond;

// DIO Mode //
typedef enum _cmcDioMode{
	cmcDIOMODE_IN /*Input Mode*/, cmcDIOMODE_OUT /*Output Mode*/
}cmcDioMode;            


// -------------------------------------------------------------------
// Slave Info
// -------------------------------------------------------------------
typedef struct{
	unsigned short	ModuleType[LX530_MAX_MODULE_IN_SLAVE];	// Connected module type. (cmcModuleType)
	unsigned short	nNumModule;							// Connected module's number.
	unsigned short	nSlaveType;							// Slave Mode (cmcSlaveType)
}cmcSlaveInfo;

// -------------------------------------------------------------------
// Definition of Real Time Status update Structure
// -------------------------------------------------------------------

typedef struct
{
	struct
	{
		unsigned int AxisMask; //  Ʈ   RTS ĵ Ȱȭ  
		struct
		{
			struct
			{
				unsigned int INP: 1;						// [RTEX : INP] , [YASKAWA : PSET]
				unsigned int Reserved_00: 1;
				unsigned int HC:1;		// [Home Completed]
				unsigned int TL:1;		// [Toque Limited]
				unsigned int WARN:1;	// [SERVO Warning]
				unsigned int ALARM:1;	// [SERVO Alarm]
				unsigned int SVRDY:1;	// [RTEX : SERVO RDY] , [YASKAWA : M_RDY]
				unsigned int SVON:1;	// [Servo On]
				
				unsigned int ELN:1;	// [RTEX : EL-] , [YASKAWA : N_OT]
				unsigned int ELP:1;	// [RTEX : EL+] , [YASKAWA : P_OT]
				unsigned int ORG:1;	// [Home Sensor]
				unsigned int EX_IN1:1;	// [RTEX : EX_IN1] , [YASKAWA : EXT1]
				unsigned int EX_IN2:1;	// [RTEX : EX_IN2] , [YASKAWA : EXT2]
				unsigned int EX_IN3:1;	// [RTEX : EX_IN3] , [YASKAWA : EXT3]
				unsigned int EX_IN4:1;	// [RTEX : EX_IN4] , [YASKAWA : DEC]
				unsigned int EMG_STP:1;// [RTEX : EMG_STP], [YASKAWA : ESTP]
							
				unsigned int ZSPD:1;	// [YASKAWA Only]
				unsigned int DEN:1;	// [YASKAWA Only]
				unsigned int BRK_ON:1;	// [YASKAWA Only]
				unsigned int ZPOINT:1;	// [YASKAWA Only]

				unsigned int Reserved_01:4;
				unsigned int Reserved_02:8;
				
			}DW0;

			struct
			{
				unsigned int Torq: 7;	
				unsigned int FieldMode: 1;
				unsigned int Mst: 4;	
				unsigned int MMode: 4;	
				int  LastError: 8;
				unsigned int Reserved;
			}DW1;

			int CmdCnt;
			int FeedCnt;
			int CmdVel;
			int FeedVel;			
		}Axis[32];
	}NM;

	struct
	{
		unsigned int NodeMask;
		struct
		{
			// DIO
			unsigned int DI0:1;
			unsigned int DI1:1;
			unsigned int DI2:1;
			unsigned int DO0:1;
			unsigned int DO1:1;
			unsigned int DO2:1;

			struct
			{
				struct  
				{
					// Motion Stat.
					unsigned int MOT:4;
					
					// Servo On/Off
					unsigned int SVON:1;
					
					// Motion IO
					unsigned int SVRDY:1;
					unsigned int ALM:1;
					unsigned int ELM:1;
					unsigned int ELP:1;
					unsigned int ORG:1;
					unsigned int DIR:1;
					unsigned int EZ:1;
					unsigned int LTC:1;

					unsigned int SD:1;
					unsigned int INP:1;
					unsigned int DRN:1;
					unsigned int DRP:1;
					unsigned int STA:1;
					unsigned int STP:1;
					unsigned int ALMR:1;
					unsigned int EMG:1;

					int CmdCnt;
					int FeedCnt;
					int CmdVel;
				} Axis[2];
			}Module[9];
		}Node[32];
	}PM;

	struct
	{
		unsigned int NodeMask;
		struct
		{
			unsigned int Di[9];
			unsigned int Do[9];
			unsigned int Dio[9];
		}Node[32];
	}IO;
} cmcRtsData;

#pragma pack(push, 1)
typedef struct{	
	// Target Axis Information //
	struct{
		double	StartPos; // ù ° (Column)  ġ 
		float	StepSize; //  (Column)  ġ Ÿ .    °   ġ (StartPos+StepSize) ǰ,  °   ġ (StartPos+2*StepSize) Ǵ ̴.
		unsigned int	StepCount; //  ƼĪ Ʈ .   ᱹ (Column)  ǹѴ.
	}TA;

	// Reference Axis information //
	struct{
		unsigned int	Axis; // (Ref. Axis) ȣ
		double	StartPos; // ù ° (Row) شϴ   ġ 
		float	StepSize; //  (Row)  ġ Ÿ .    °    ġ (StartPos+StepSize) ǰ,  °    ġ (StartPos+2*StepSize) Ǵ ̴.
		unsigned int	StepCount; //  ƼĪ Ʈ .   ᱹ (Row) 
	}RA;
}TEcmPC2DHeader;
#pragma pack(pop)

// -------------------------------------------------------------------
// Types of SDK(Software Development Kit) Error Codes
// -------------------------------------------------------------------

// The Winerror.h file contains a listing of static error codes used throughout Microsoft Windows operating system products
#include "winerror.h"

#define cmcERR_NONE					0
#define cmcERR_INVALID_BUFFER			-1	// Invalid Buffer range
#define cmcERR_AXIS_MOT_QUEUE_FULL		-2	// Listed Queue Full
#define cmcERR_CALLWDM_ERROR			-3 // WDM ̹  ȯ   
#define cmcERR_IMD_REPLY_FAIL			-5	// Immediately Queue Full
#define cmcERR_IMD_QUEUE_FULL			-6	// Immediately Reply Fail

#define cmcERR_NOT_ENOUGH_MEMORY	-8	// Not Enough memory.
#define cmcERR_INVALID_PARAMETER		-10	// Some of the function parameters are invalid
#define cmcERR_INVALID_AXIS			-11	// The axis setting parameter(s) is (are) invalid
#define cmcERR_INVALID_SPEED_SET		-12	// Speed setting value is not valid

#define cmcERR_INVALID_IXMAP			-13	// Invalid Interpolation Map
#define cmcERR_INVALID_LMMAP			-14	// Invalid Listed-Motion Map
#define cmcERR_INVALID_NUMAXIS			-15	// Invalid number of axis(Mx)
	
#define cmcERR_STOP_BY_SLP				-50	// Abnormally stopped by positive soft limit
#define cmcERR_STOP_BY_SLN				-51	// Abnormally stopped by negative soft limit
#define cmcERR_STOP_BY_EPL				-52	// Abnormally stopped by (-) external limit
#define cmcERR_STOP_BY_ELN				-53	// Abnormally stopped by (+) external limit
#define cmcERR_STOP_BY_ALM				-54	// Abnormally stopped by alarm input signal
#define cmcERR_STOP_BY_CER				-55	// Abnormally stopped by communication error between NC and Slave nodes

#define cmcERR_MOT_SEQ_SKIPPED			-60	// Motion Command has been skipped because the axis is already running
#define cmcERR_SKIP_BY_ALM				-61	// Motion Command has been skipped by ALM signal.
#define cmcERR_SKIP_BY_SERVO_OFF		-62	// Motion Command has been skipped by the ServoPack state is OFF.
#define cmcERR_FAILED_COMMAND_SERVO_ON		-63	// Motion Command ServoOn has been failed in retry command.
#define cmcERR_FAILED_COMMAND_SERVO_OFF	-64	// Motion Command ServoOff has been failed in retry command.

#define cmcERR_INVALID_LIBPARAM			-87 // Library Command Parameter is Invalid.
#define cmcERR_DEVICE_NOT_FOUND			-1168	// MLink2 Device is not detected.

#define cmcERR_MS_REGISTER_SKIPPED			-1090	// Master/Slave Register Failed
#define cmcERR_MS_INVALID_AXIS_REGISTER	-1091	// Master/Slave Register Axis is Invalid
#define cmcERR_MS_REGISTER_SAME_AXIS		-1092	// Master/Slave Register Axis is same

#endif
