/*******************************************************************************
* [ ComiRTEX_SDK.cpp ]
* CPP file for definitions of constants and data in LX520 library
* - Update Data: 2014/01/13
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#include "stdafx.h"

#if defined(__BCPLUSPLUS__)  // Borland C++ Builder specific
 #include <vcl.h>
 #pragma hdrstop
#endif

#include <windows.h>
#include <stdio.h>

#define _DLL_MAIN_CPP_
#include "ComiRTEX_SDK.h"

#define __DLL_FILE_FULL_PATH__ "ComiRTEX.DLL"

typedef struct{
	char *name;
	FARPROC* ptr;
}LIB_FUNCT;

static HINSTANCE hLibrary=NULL;

BOOL cmxLoadDll(void)
{
	LIB_FUNCT Func[] = {

		//////////////////////////////////////////////////////////////////////////
		// Device Load / Unload
		//////////////////////////////////////////////////////////////////////////
		{"GnLoadDevice", 	(FARPROC*)&cmxGnLoadDevice},
		{"GnUnloadDevice", 	(FARPROC*)&cmxGnUnloadDevice},

		{"GnSetLogMode",	(FARPROC*)&cmxGnSetLogMode},
		{"GnGetLogMode",	(FARPROC*)&cmxGnGetLogMode},

		{"GnSetLogLevel",	(FARPROC*)&cmxGnSetLogLevel},
		{"GnGetLogLevel",	(FARPROC*)&cmxGnGetLogLevel},
		
		{"GnSetFuncLevel",	(FARPROC*)&cmxGnSetFuncLevel},
		{"GnRestoreFuncLevel",	(FARPROC*)&cmxGnRestoreFuncLevel},
		{"GnGetFuncLevel",	(FARPROC*)&cmxGnGetFuncLevel},
		
		//////////////////////////////////////////////////////////////////////////
		// Network Motion Controller Raw Function
		//////////////////////////////////////////////////////////////////////////
		{"GetResources",	(FARPROC*)&cmxGetResources},
		{"WriteMemPortDW",  (FARPROC*)&cmxWriteMemPortDW},
		{"ReadMemPortDW",	(FARPROC*)&cmxReadMemPortDW},
		{"DpramRead",		(FARPROC*)&cmxDpramRead},
		{"DpramWrite",		(FARPROC*)&cmxDpramWrite},
		{"DpramBusyEnable",	(FARPROC*)&cmxDpramBusyEnable},
		{"DpramBusyDisable",	(FARPROC*)&cmxDpramBusyDisable},

		//////////////////////////////////////////////////////////////////////////
		// Network Motion Controller High Level API Function
		//////////////////////////////////////////////////////////////////////////
		{"GnSetCommStates",	(FARPROC*)&cmxGnSetCommStates},
		{"GnGetCommStates", 	(FARPROC*)&cmxGnGetCommStates},

		{"GnResetComm", 	(FARPROC*)&cmxGnResetComm},
	
		{"GnSetServoOn",	(FARPROC*)&cmxGnSetServoOn},
		{"GnGetServoOn",	(FARPROC*)&cmxGnGetServoOn},

		{"GnSetAlarmRes",	(FARPROC*)&cmxGnSetAlarmRes},
		{"GnGetAlarmRes",	(FARPROC*)&cmxGnGetAlarmRes},

		{"GnGetAlarmCode",	(FARPROC*)&cmxGnGetAlarmCode},

		{"GnSetSimulMode",	(FARPROC*)&cmxGnSetSimulMode},
		{"GnGetSimulMode",	(FARPROC*)&cmxGnGetSimulMode},

		{"GnSetEmergency",	(FARPROC*)&cmxGnSetEmergency},
		{"GnGetEmergency",	(FARPROC*)&cmxGnGetEmergency},

		{"GnSetEmergencyAll",	(FARPROC*)&cmxGnSetEmergencyAll},
		{"GnGetEmergencyAll",	(FARPROC*)&cmxGnGetEmergencyAll},

		{"GnSetCommPeriod",	(FARPROC*)&cmxGnSetCommPeriod},
		{"GnGetCommPeriod",	(FARPROC*)&cmxGnGetCommPeriod},

		{"GnResetDevice",	(FARPROC*)&cmxGnResetDevice},

		{"GnSetStatusUpdateInterval", (FARPROC*)&cmxGnSetStatusUpdateInterval},
		{"GnGetStatusUpdateInterval", (FARPROC*)&cmxGnGetStatusUpdateInterval},

		{"GnGetAxisMap", (FARPROC*)&cmxGnGetAxisMap},
		{"GnSetParam520", 		(FARPROC*)&cmxGnSetParam},
		{"GnGetParam520", 		(FARPROC*)&cmxGnGetParam},

		{"GnSetABSMode",		(FARPROC*)&cmxGnSetABSMode},
		{"GnGetABSMode",		(FARPROC*)&cmxGnGetABSMode},
		{"GnABSUpdate",			(FARPROC*)&cmxGnABSUpdate},

		{"GnSetABSHome",		(FARPROC*)&cmxGnSetABSHome},

		{"GnSetControlMode",	(FARPROC*)&cmxGnSetControlMode},
		{"GnGetControlMode",	(FARPROC*)&cmxGnGetControlMode},

		{"GnSetPositionTorqueMode", (FARPROC*)&cmxGnSetPositionTorqueMode},
		{"GnGetPositionTorqueMode", (FARPROC*)&cmxGnGetPositionTorqueMode},
		
		{"GnInitFromFile",		(FARPROC*)&cmxGnInitFromFile},
		
		//////////////////////////////////////////////////////////////////////////
		// Cfg function
		//////////////////////////////////////////////////////////////////////////
		{"CfgSetMioProperty",  (FARPROC*)&cmxCfgSetMioProperty},
		{"CfgGetMioProperty",  (FARPROC*)&cmxCfgGetMioProperty},

		{"CfgSetUnitDist",	   (FARPROC*)&cmxCfgSetUnitDist},
		{"CfgGetUnitDist",	   (FARPROC*)&cmxCfgGetUnitDist},

		{"CfgSetUnitSpeed",	   (FARPROC*)&cmxCfgSetUnitSpeed},
		{"CfgGetUnitSpeed",	   (FARPROC*)&cmxCfgGetUnitSpeed},

		{"CfgSetSpeedPattern", (FARPROC*)&cmxCfgSetSpeedPattern},
		{"CfgGetSpeedPattern", (FARPROC*)&cmxCfgGetSpeedPattern},

		{"CfgSetSoftLimit",	   (FARPROC*)&cmxCfgSetSoftLimit},
		{"CfgGetSoftLimit",	   (FARPROC*)&cmxCfgGetSoftLimit},

		{"CfgSetSvonDevRange", (FARPROC*)&cmxCfgSetSvonDevRange},
		{"CfgGetSvonDevRange", (FARPROC*)&cmxCfgGetSvonDevRange},

		//////////////////////////////////////////////////////////////////////////
		// Sx Control
		//////////////////////////////////////////////////////////////////////////
		{"SxMove",			(FARPROC*)&cmxSxMove},
		{"SxMoveStart",		(FARPROC*)&cmxSxMoveStart},
		{"SxMoveTo",		(FARPROC*)&cmxSxMoveTo},
		{"SxMoveToStart",	(FARPROC*)&cmxSxMoveToStart},
		{"SxVMoveStart",	(FARPROC*)&cmxSxVMoveStart},
		{"SxStop",          (FARPROC*)&cmxSxStop},
		{"SxStopEmg",       (FARPROC*)&cmxSxStopEmg},
		{"SxIsDone",		(FARPROC*)&cmxSxIsDone},
		{"SxWaitDone",		(FARPROC*)&cmxSxWaitDone},

		{"SxSetCorrection", (FARPROC*)&cmxSxSetCorrection},
		{"SxGetCorrection", (FARPROC*)&cmxSxGetCorrection},

		//////////////////////////////////////////////////////////////////////////
		// Mx Control
		//////////////////////////////////////////////////////////////////////////
		{"MxMove",			(FARPROC*)&cmxMxMove},
		{"MxMoveStart",		(FARPROC*)&cmxMxMoveStart},
		{"MxMoveTo",		(FARPROC*)&cmxMxMoveTo},
		{"MxMoveToStart",	(FARPROC*)&cmxMxMoveToStart},
		{"MxVMoveStart",	(FARPROC*)&cmxMxVMoveStart},
		{"MxStop",			(FARPROC*)&cmxMxStop},
		{"MxStopEmg",		(FARPROC*)&cmxMxStopEmg},
		{"MxIsDone",		(FARPROC*)&cmxMxIsDone},
		{"MxWaitDone",		(FARPROC*)&cmxMxWaitDone},

		//////////////////////////////////////////////////////////////////////////
		// Ix Control
		//////////////////////////////////////////////////////////////////////////
		{"IxMapAxes",		 (FARPROC*)&cmxIxMapAxes},
		{"IxUnMapAxes",		 (FARPROC*)&cmxIxUnMapAxes},
		
		{"IxSetSpeedPattern",(FARPROC*)&cmxIxSetSpeedPattern},
		{"IxGetSpeedPattern",(FARPROC*)&cmxIxGetSpeedPattern},
		
		{"IxLine",			 (FARPROC*)&cmxIxLine},
		{"IxLineStart",		 (FARPROC*)&cmxIxLineStart},

		{"IxLineTo",		 (FARPROC*)&cmxIxLineTo},
		{"IxLineToStart",	 (FARPROC*)&cmxIxLineToStart},

		{"IxArcA",			 (FARPROC*)&cmxIxArcA},
		{"IxArcAStart",		 (FARPROC*)&cmxIxArcAStart},

		{"IxArcATo",		 (FARPROC*)&cmxIxArcATo},
		{"IxArcAToStart",	 (FARPROC*)&cmxIxArcAToStart},

		{"IxArcP",			 (FARPROC*)&cmxIxArcP},
		{"IxArcPStart",		 (FARPROC*)&cmxIxArcPStart},

		{"IxArcPTo",		 (FARPROC*)&cmxIxArcPTo},
		{"IxArcPToStart",	 (FARPROC*)&cmxIxArcPToStart},

		{"IxArc3P",			 (FARPROC*)&cmxIxArc3P},
		{"IxArc3PStart",	 (FARPROC*)&cmxIxArc3PStart},

		{"IxArc3PTo",			 (FARPROC*)&cmxIxArc3PTo},
		{"IxArc3PToStart",	 (FARPROC*)&cmxIxArc3PToStart},

		{"IxIsDone",		 (FARPROC*)&cmxIxIsDone},
		{"IxWaitDone",		 (FARPROC*)&cmxIxWaitDone},

		{"IxStop",			 (FARPROC*)&cmxIxStop},
		{"IxStopEmg",		 (FARPROC*)&cmxIxStopEmg},

		{"IxHelOnceStart",	 (FARPROC*)&cmxIxHelOnceStart},
		{"IxSplineStart",    (FARPROC*)&cmxIxSplineStart},
		
		{"IxGetMapIndex",	 (FARPROC*)&cmxIxGetMapIndex},

		{"IxGetMapIndex",	 (FARPROC*)&cmxIxGetMapIndex},

		//////////////////////////////////////////////////////////////////////////
		// Return To Home
		//////////////////////////////////////////////////////////////////////////
		{"HomeSetConfig",		(FARPROC*)&cmxHomeSetConfig},
		{"HomeGetConfig",		(FARPROC*)&cmxHomeGetConfig},
		{"HomeSetOffset",		(FARPROC*)&cmxHomeSetOffset},
		{"HomeGetOffset",		(FARPROC*)&cmxHomeGetOffset},

		{"HomeSetPosClrMode",	(FARPROC*)&cmxHomeSetPosClrMode},
		{"HomeGetPosClrMode",	(FARPROC*)&cmxHomeGetPosClrMode},

		{"HomeSetSpeedPattern",	(FARPROC*)&cmxHomeSetSpeedPattern},
		{"HomeGetSpeedPattern",	(FARPROC*)&cmxHomeGetSpeedPattern},

		{"HomeMove",			(FARPROC*)&cmxHomeMove},
		{"HomeMoveStart",		(FARPROC*)&cmxHomeMoveStart},

		{"HomeMoveAll",			(FARPROC*)&cmxHomeMoveAll},
		{"HomeMoveAllStart",	(FARPROC*)&cmxHomeMoveAllStart},

		{"HomeIsBusy",			(FARPROC*)&cmxHomeIsBusy},
		{"HomeWaitDone",		(FARPROC*)&cmxHomeWaitDone},

		{"HomeSetSuccess",		(FARPROC*)&cmxHomeSetSuccess},
		{"HomeGetSuccess",	    (FARPROC*)&cmxHomeGetSuccess},

		//////////////////////////////////////////////////////////////////////////
		// Override
		//////////////////////////////////////////////////////////////////////////
		{"OverrideSpeedSet",	(FARPROC*)&cmxOverrideSpeedSet},
		{"OverrideMove",		(FARPROC*)&cmxOverrideMove},
		{"OverrideMoveTo",		(FARPROC*)&cmxOverrideMoveTo},

		//////////////////////////////////////////////////////////////////////////
		// Listed Motion
		//////////////////////////////////////////////////////////////////////////
		{"LmxStart",			(FARPROC*)&cmxLmxStart},
		{"LmxSuspend",			(FARPROC*)&cmxLmxSuspend},
		{"LmxResume",			(FARPROC*)&cmxLmxResume},
		{"LmxEnd",				(FARPROC*)&cmxLmxEnd},
		{"LmxGetStates",		(FARPROC*)&cmxLmxGetStates},

		{"LmxSetSeqMode",		(FARPROC*)&cmxLmxSetSeqMode},
		{"LmxGetSeqMode",		(FARPROC*)&cmxLmxGetSeqMode},

		{"LmxSetNextItemId",	(FARPROC*)&cmxLmxSetNextItemId},
		{"LmxGetNextItemId",	(FARPROC*)&cmxLmxGetNextItemId},
		
		{"LmxSetNextItemParam",	(FARPROC*)&cmxLmxSetNextItemParam},
		{"LmxGetNextItemParam", (FARPROC*)&cmxLmxGetNextItemParam},

		{"LmxGetRunItemParam",	(FARPROC*)&cmxLmxGetRunItemParam},
		{"LmxGetRunItemStaPos", (FARPROC*)&cmxLmxGetRunItemStaPos},
		{"LmxGetRunItemTargPos",(FARPROC*)&cmxLmxGetRunItemTargPos},
		
		{"LmxSetSeqId",			(FARPROC*)&cmxLmxSetSeqId},
		{"LmxGetSeqId",			(FARPROC*)&cmxLmxGetSeqId},
		
		//////////////////////////////////////////////////////////////////////////
		// Status Monitoring
		//////////////////////////////////////////////////////////////////////////
		{"StSetCount",          (FARPROC*)&cmxStSetCount},
		{"StGetCount",			(FARPROC*)&cmxStGetCount},

		{"StSetPosition",       (FARPROC*)&cmxStSetPosition},
		{"StGetPosition",		(FARPROC*)&cmxStGetPosition},

		{"StGetSpeed",			(FARPROC*)&cmxStGetSpeed},

		{"StSetTorque",			(FARPROC*)&cmxStSetTorque},
		{"StGetTorque",			(FARPROC*)&cmxStGetTorque},

		{"StSetTorqueVelLimit",	(FARPROC*)&cmxStSetTorqueVelLimit},
		{"StGetTorqueVelLimit",	(FARPROC*)&cmxStGetTorqueVelLimit},

		{"StSetTorqueLimit",	(FARPROC*)&cmxStSetTorqueLimit},
		{"StGetTorqueLimit",	(FARPROC*)&cmxStGetTorqueLimit},

		{"StSetVelocity",		(FARPROC*)&cmxStSetVelocity},
		{"StGetVelocity",		(FARPROC*)&cmxStGetVelocity},

		{"StSxReadMotionState", (FARPROC*)&cmxStSxReadMotionState},
		{"StIxReadMotionState", (FARPROC*)&cmxStIxReadMotionState},

		{"StReadMioStatuses",	(FARPROC*)&cmxStReadMioStatuses},
		{"StGetMotionMode",		(FARPROC*)&cmxStGetMotionMode},

		{"StSxGetLastError",	(FARPROC*)&cmxStSxGetLastError},
		{"StIxGetLastError",	(FARPROC*)&cmxStIxGetLastError},

		{"StSetMultiRevCnt",	(FARPROC*)&cmxStSetMultiRevCnt},
		{"StGetMultiRevCnt",	(FARPROC*)&cmxStGetMultiRevCnt},
		
		{"StSetOneRevPos",		(FARPROC*)&cmxStSetOneRevPos},
		{"StGetOneRevPos",		(FARPROC*)&cmxStGetOneRevPos},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (GN)
		//////////////////////////////////////////////////////////////////////////
		{"GnGetNodeInfo",		(FARPROC*)&cmxGnGetNodeInfo},
		{"GnTotalDIOChannel",	(FARPROC*)&cmxGnTotalDIOChannel},
		{"GnTotalAIChannel",	(FARPROC*)&cmxGnTotalAIChannel},
		{"GnTotalAOChannel",	(FARPROC*)&cmxGnTotalAOChannel},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (DI)
		//////////////////////////////////////////////////////////////////////////
		{"DiGetLogic",			(FARPROC*)&cmxDiGetLogic},
		{"DiSetLogic",			(FARPROC*)&cmxDiSetLogic},
		{"DiGetLogicMulti",		(FARPROC*)&cmxDiGetLogicMulti},
		{"DiSetLogicMulti",		(FARPROC*)&cmxDiSetLogicMulti},
		{"DiGetOne",			(FARPROC*)&cmxDiGetOne},
		{"DiGetMulti",			(FARPROC*)&cmxDiGetMulti},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (DO)
		//////////////////////////////////////////////////////////////////////////
		{"DoGetLogic",			(FARPROC*)&cmxDoGetLogic},
		{"DoSetLogic",			(FARPROC*)&cmxDoSetLogic},
		{"DoGetLogicMulti",		(FARPROC*)&cmxDoGetLogicMulti},
		{"DoSetLogicMulti",		(FARPROC*)&cmxDoSetLogicMulti},
		{"DoPutOne",			(FARPROC*)&cmxDoPutOne},
		{"DoGetOne",			(FARPROC*)&cmxDoGetOne},
		{"DoPutMulti",			(FARPROC*)&cmxDoPutMulti},
		{"DoGetMulti",			(FARPROC*)&cmxDoGetMulti},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (DIO)
		//////////////////////////////////////////////////////////////////////////
		{"DioGetIomode",		(FARPROC*)&cmxDioGetIomode},
		{"DioSetIomode",		(FARPROC*)&cmxDioSetIomode},
		{"DioGetIomodeMulti",	(FARPROC*)&cmxDioGetIomodeMulti},
		{"DioSetIomodeMulti",	(FARPROC*)&cmxDioSetIomodeMulti},
		{"DioGetLogic",			(FARPROC*)&cmxDioGetLogic},
		{"DioSetLogic",			(FARPROC*)&cmxDioSetLogic},
		{"DioGetLogicMulti",	(FARPROC*)&cmxDioGetLogicMulti},
		{"DioSetLogicMulti",	(FARPROC*)&cmxDioSetLogicMulti},
		{"DioPutOne",			(FARPROC*)&cmxDioPutOne},
		{"DioGetOne",			(FARPROC*)&cmxDioGetOne},
		{"DioPutMulti",			(FARPROC*)&cmxDioPutMulti},
		{"DioGetMulti",			(FARPROC*)&cmxDioGetMulti},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (AI)
		//////////////////////////////////////////////////////////////////////////
		{"AiSetVoltRangeMode",	(FARPROC*)&cmxAiSetVoltRangeMode},
		{"AiGetVoltRangeMode",	(FARPROC*)&cmxAiGetVoltRangeMode},
		{"AiGetRangeDigit",		(FARPROC*)&cmxAiGetRangeDigit},
		{"AiGetDigit",			(FARPROC*)&cmxAiGetDigit},
		{"AiGetVolt",			(FARPROC*)&cmxAiGetVolt},
		{"AiGetCurrent",		(FARPROC*)&cmxAiGetCurrent},

		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (AO)
		//////////////////////////////////////////////////////////////////////////
		{"AoOutDigit",			(FARPROC*)&cmxAoOutDigit},
		{"AoOutVolt",			(FARPROC*)&cmxAoOutVolt},
		{"AoOutCurrent",		(FARPROC*)&cmxAoOutCurrent},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-GN)
		//////////////////////////////////////////////////////////////////////////
		{"PmGnSetServoOn",		(FARPROC*)&cmxPmGnSetServoOn},
		{"PmGnGetServoOn",		(FARPROC*)&cmxPmGnGetServoOn},
		{"PmGnAlarmReset",		(FARPROC*)&cmxPmGnAlarmReset},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-CFG)
		//////////////////////////////////////////////////////////////////////////
		{"PmCfgSetMioProperty",	(FARPROC*)&cmxPmCfgSetMioProperty},
		{"PmCfgGetMioProperty",	(FARPROC*)&cmxPmCfgGetMioProperty},
		{"PmCfgSetFilter",		(FARPROC*)&cmxPmCfgSetFilter},
		{"PmCfgGetFilter",		(FARPROC*)&cmxPmCfgGetFilter},
		{"PmCfgSetFilterAB",	(FARPROC*)&cmxPmCfgSetFilterAB},
		{"PmCfgGetFilterAB",	(FARPROC*)&cmxPmCfgGetFilterAB},
		{"PmCfgSetInMode",		(FARPROC*)&cmxPmCfgSetInMode},
		{"PmCfgGetInMode",		(FARPROC*)&cmxPmCfgGetInMode},
		{"PmCfgSetOutMode",		(FARPROC*)&cmxPmCfgSetOutMode},
		{"PmCfgGetOutMode",		(FARPROC*)&cmxPmCfgGetOutMode},
		{"PmCfgSetCtrlMode",	(FARPROC*)&cmxPmCfgSetCtrlMode},
		{"PmCfgGetCtrlMode",	(FARPROC*)&cmxPmCfgGetCtrlMode},
		{"PmCfgSetInOutRatio",	(FARPROC*)&cmxPmCfgSetInOutRatio},
		{"PmCfgGetInOutRatio",	(FARPROC*)&cmxPmCfgGetInOutRatio},
		{"PmCfgSetUnitDist",	(FARPROC*)&cmxPmCfgSetUnitDist},
		{"PmCfgGetUnitDist",	(FARPROC*)&cmxPmCfgGetUnitDist},
		{"PmCfgSetUnitSpeed",	(FARPROC*)&cmxPmCfgSetUnitSpeed},
		{"PmCfgGetUnitSpeed",	(FARPROC*)&cmxPmCfgGetUnitSpeed},
		{"PmCfgSetSpeedRange",	(FARPROC*)&cmxPmCfgSetSpeedRange},
		{"PmCfgGetSpeedRange",	(FARPROC*)&cmxPmCfgGetSpeedRange},
		{"PmCfgSetSpeedPattern",	(FARPROC*)&cmxPmCfgSetSpeedPattern},
		{"PmCfgGetSpeedPattern",	(FARPROC*)&cmxPmCfgGetSpeedPattern},
		{"PmCfgSetSoftLimit",	(FARPROC*)&cmxPmCfgSetSoftLimit},
		{"PmCfgGetSoftLimit",	(FARPROC*)&cmxPmCfgGetSoftLimit},
		{"PmCfgSetRingCntr",	(FARPROC*)&cmxPmCfgSetRingCntr},
		{"PmCfgGetRingCntr",	(FARPROC*)&cmxPmCfgGetRingCntr},
		{"PmCfgSetVelCorrRatio",	(FARPROC*)&cmxPmCfgSetVelCorrRatio},
		{"PmCfgGetVelCorrRatio",	(FARPROC*)&cmxPmCfgGetVelCorrRatio},
		{"PmCfgSetSeqMode",		(FARPROC*)&cmxPmCfgSetSeqMode},
		{"PmCfgGetSeqMode",		(FARPROC*)&cmxPmCfgGetSeqMode},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-HOME)
		//////////////////////////////////////////////////////////////////////////
		{"PmHomeSetConfig",		(FARPROC*)&cmxPmHomeSetConfig},
		{"PmHomeGetConfig",		(FARPROC*)&cmxPmHomeGetConfig},
		{"PmHomeSetPosClrMode",	(FARPROC*)&cmxPmHomeSetPosClrMode},
		{"PmHomeGetPosClrMode",	(FARPROC*)&cmxPmHomeGetPosClrMode},
		{"PmHomeSetSpeedPattern",	(FARPROC*)&cmxPmHomeSetSpeedPattern},
		{"PmHomeGetSpeedPattern",	(FARPROC*)&cmxPmHomeGetSpeedPattern},
		{"PmHomeMoveStart",		(FARPROC*)&cmxPmHomeMoveStart},
		{"PmHomeMoveAllStart",	(FARPROC*)&cmxPmHomeMoveAllStart},
		{"PmHomeSetSuccess",	(FARPROC*)&cmxPmHomeSetSuccess},
		{"PmHomeGetSuccess",	(FARPROC*)&cmxPmHomeGetSuccess},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-SX)
		//////////////////////////////////////////////////////////////////////////
		{"PmSxSetSpeedRatio",	(FARPROC*)&cmxPmSxSetSpeedRatio},
		{"PmSxGetSpeedRatio",	(FARPROC*)&cmxPmSxGetSpeedRatio},
		{"PmSxMoveStart",		(FARPROC*)&cmxPmSxMoveStart},
		{"PmSxMove",		(FARPROC*)&cmxPmSxMove},
		{"PmSxMoveToStart",		(FARPROC*)&cmxPmSxMoveToStart},
		{"PmSxMoveTo",		(FARPROC*)&cmxPmSxMoveTo},
		{"PmSxVMoveStart",		(FARPROC*)&cmxPmSxVMoveStart},
		{"PmSxStop",			(FARPROC*)&cmxPmSxStop},
		{"PmSxStopEmg",			(FARPROC*)&cmxPmSxStopEmg},
		{"PmSxIsDone",		(FARPROC*)&cmxPmSxIsDone},
		{"PmSxWaitDone",		(FARPROC*)&cmxPmSxWaitDone},
		{"PmSxGetTargetPos",	(FARPROC*)&cmxPmSxGetTargetPos},
		{"PmSxSetOptIniSpeed",	(FARPROC*)&cmxPmSxSetOptIniSpeed},
		{"PmSxGetOptIniSpeed",	(FARPROC*)&cmxPmSxGetOptIniSpeed},
		{"PmSxSetOptRdpOffset",	(FARPROC*)&cmxPmSxSetOptRdpOffset},
		{"PmSxGetOptRdpOffset",	(FARPROC*)&cmxPmSxGetOptRdpOffset},
		{"PmSxSetCorrection",	(FARPROC*)&cmxPmSxSetCorrection},
		{"PmSxGetCorrection",	(FARPROC*)&cmxPmSxGetCorrection},
		{"PmSxSetOptSyncMode",	(FARPROC*)&cmxPmSxSetOptSyncMode},
		{"PmSxGetOptSyncMode",	(FARPROC*)&cmxPmSxGetOptSyncMode},
		{"PmSxSetOptSyncOut",	(FARPROC*)&cmxPmSxSetOptSyncOut},
		{"PmSxGetOptSyncOut",	(FARPROC*)&cmxPmSxGetOptSyncOut},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-MX)
		//////////////////////////////////////////////////////////////////////////
		{"PmMxMoveStart",		(FARPROC*)&cmxPmMxMoveStart},
		{"PmMxMove",		(FARPROC*)&cmxPmMxMove},
		{"PmMxMoveToStart",		(FARPROC*)&cmxPmMxMoveToStart},
		{"PmMxMoveTo",		(FARPROC*)&cmxPmMxMoveTo},
		{"PmMxVMoveStart",		(FARPROC*)&cmxPmMxVMoveStart},
		{"PmMxStop",			(FARPROC*)&cmxPmMxStop},
		{"PmMxStopEmg",			(FARPROC*)&cmxPmMxStopEmg},
		{"PmMxIsDone",		(FARPROC*)&cmxPmMxIsDone},
		{"PmMxWaitDone",		(FARPROC*)&cmxPmMxWaitDone},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-IX)
		//////////////////////////////////////////////////////////////////////////
		{"PmIxMapAxes",			(FARPROC*)&cmxPmIxMapAxes},
		{"PmIxUnMapAxes",		(FARPROC*)&cmxPmIxUnMapAxes},
		{"PmIxSetVelCorrMode",	(FARPROC*)&cmxPmIxSetVelCorrMode},
		{"PmIxGetVelCorrMode",	(FARPROC*)&cmxPmIxGetVelCorrMode},
		{"PmIxSetSpeedPattern",	(FARPROC*)&cmxPmIxSetSpeedPattern},
		{"PmIxGetSpeedPattern",	(FARPROC*)&cmxPmIxGetSpeedPattern},
		{"PmIxLineStart",		(FARPROC*)&cmxPmIxLineStart},
		{"PmIxLineToStart",		(FARPROC*)&cmxPmIxLineToStart},
		{"PmIxArcAStart",		(FARPROC*)&cmxPmIxArcAStart},
		{"PmIxArcAToStart",		(FARPROC*)&cmxPmIxArcAToStart},
		{"PmIxArcPStart",		(FARPROC*)&cmxPmIxArcPStart},
		{"PmIxArcPToStart",		(FARPROC*)&cmxPmIxArcPToStart},
		{"PmIxArc3PStart",		(FARPROC*)&cmxPmIxArc3PStart},
		{"PmIxArc3PToStart",	(FARPROC*)&cmxPmIxArc3PToStart},
		{"PmIxStop",			(FARPROC*)&cmxPmIxStop},
		{"PmIxStopEmg",			(FARPROC*)&cmxPmIxStopEmg},
		{"PmIxIsDone",			(FARPROC*)&cmxPmIxIsDone},
		{"PmIxWaitDone",		(FARPROC*)&cmxPmIxWaitDone},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-OVERRIDE)
		//////////////////////////////////////////////////////////////////////////
		{"PmOverrideSpeedSet",	(FARPROC*)&cmxPmOverrideSpeedSet},
		{"PmOverrideSpeedSetAll",	(FARPROC*)&cmxPmOverrideSpeedSetAll},
		{"PmOverrideMove",		(FARPROC*)&cmxPmOverrideMove},
		{"PmOverrideMoveTo",	(FARPROC*)&cmxPmOverrideMoveTo},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-ST)
		//////////////////////////////////////////////////////////////////////////
		{"PmStSetCount",		(FARPROC*)&cmxPmStSetCount},
		{"PmStGetCount",		(FARPROC*)&cmxPmStGetCount},
		{"PmStSetPosition",		(FARPROC*)&cmxPmStSetPosition},
		{"PmStGetPosition",		(FARPROC*)&cmxPmStGetPosition},
		{"PmStGetSpeed",		(FARPROC*)&cmxPmStGetSpeed},
		{"PmStReadMotionState",	(FARPROC*)&cmxPmStReadMotionState},
		{"PmStReadMIOStatus",	(FARPROC*)&cmxPmStReadMIOStatus},
		
		//////////////////////////////////////////////////////////////////////////
		// NETIO Functions (PM-LTC)
		//////////////////////////////////////////////////////////////////////////
		{"PmLtcIsLatched",		(FARPROC*)&cmxPmLtcIsLatched},
		{"PmLtcReadLatch",		(FARPROC*)&cmxPmLtcReadLatch},

		//////////////////////////////////////////////////////////////////////////
		// Advanced Functions
		//////////////////////////////////////////////////////////////////////////
		{"AdvFwGetVersion",		(FARPROC*)&cmxAdvFwGetVersion},
		{"AdvFwGetSystemState",	(FARPROC*)&cmxAdvFwGetSystemState},
		{"AdvFwDnFrame",		(FARPROC*)&cmxAdvFwDnFrame},
		{"AdvFwDnFrameVerify",	(FARPROC*)&cmxAdvFwDnFrameVerify},		
		{"AdvFwSystemReset",	(FARPROC*)&cmxAdvFwSystemReset},
		{"AdvFwSetFwuBit",		(FARPROC*)&cmxAdvFwSetFwuBit},
		{"AdvFwGetFwuBit",		(FARPROC*)&cmxAdvFwGetFwuBit},
		{"AdvFwSetBootFlag",	(FARPROC*)&cmxAdvFwSetBootFlag},
		{"AdvFwGetBootFlag",	(FARPROC*)&cmxAdvFwGetBootFlag},
		{"AdvFwUpdateMode",		(FARPROC*)&cmxAdvFwUpdateMode},
		{"AdvM3NodeCfgRead",	(FARPROC*)&cmxAdvM3NodeCfgRead},
		{"AdvM3NodeCfgWrite",	(FARPROC*)&cmxAdvM3NodeCfgWrite},
		{"AdvSetRtsEnable",		(FARPROC*)&cmxAdvSetRtsEnable},
		{"AdvGetRtsEnable",		(FARPROC*)&cmxAdvGetRtsEnable},
		{"AdvSetRtsMode",		(FARPROC*)&cmxAdvSetRtsMode},
		{"AdvGetRtsMode",		(FARPROC*)&cmxAdvGetRtsMode},
		{"AdvGetRtsMemPtr",		(FARPROC*)&cmxAdvGetRtsMemPtr},
		{"AdvSetRtsUpdateInterval",		(FARPROC*)&cmxAdvSetRtsUpdateInterval},
		{"AdvGetRtsUpdateInterval",		(FARPROC*)&cmxAdvGetRtsUpdateInterval},
		{"AdvSetCmdAckMode",			(FARPROC*)&cmxAdvSetCmdAckMode},
		{"AdvGetCmdAckMode",			(FARPROC*)&cmxAdvGetCmdAckMode},
	
		{NULL, NULL}
	};
	
	LIB_FUNCT *f;

	if((hLibrary = LoadLibrary (__DLL_FILE_FULL_PATH__)) == NULL)
	{
		OutputDebugString("\n The LX520SDK DLL not found");
		return FALSE;
	}

	f = &Func[0];
	while(f->ptr != NULL)
	{
		*(f->ptr) = GetProcAddress ((HMODULE)hLibrary, f->name);

#ifdef _DEBUG
		if(*(f->ptr) == NULL){
			char szMessage[1024] = "";
			sprintf(szMessage,"\n[%08s] function failed to load. LX520 Software Development Kit is incorrectly configured.",f->name);
			OutputDebugString(szMessage);
		}
#endif
		f++;
	}
	return TRUE;
}

void cmxUnloadDll(void)
{
	if(hLibrary){
		FreeLibrary(hLibrary);
		hLibrary = NULL;
	}
}

