/*******************************************************************************
* [ ComiLX520SDK.h ]
* Header file for definitions of constants and data in LX520 library
* - Update Data: 2013/10/25
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#ifndef __COMI_LX520_SDK_H__
#define __COMI_LX520_SDK_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ComiRTEX_SDK_Def.h"

#if !defined(__in)
#define __in
#endif

#if !defined(__in_opt)
#define __in_opt
#endif

#if !defined(__out)
#define __out
#endif

#if !defined(__out_opt)
#define __out_opt
#endif

#if !defined(__inout)
#define	__inout
#endif

#ifdef __cplusplus
extern "C"{
#endif

#ifdef _DLL_MAIN_CPP_
	#define EXTERN 
#else 
	#define EXTERN extern
#endif

//////////////////////////////////////////////////////////////////////////
// External Functions for DLL(Dynamic Link Library)
//////////////////////////////////////////////////////////////////////////
BOOL cmxLoadDll();
VOID cmxUnloadDll();

//////////////////////////////////////////////////////////////////////////
// Low Level API for Debugging
//////////////////////////////////////////////////////////////////////////
EXTERN VOID	(WINAPI *cmxGetResources)		(__in LONG BoardId, __out PULONG pdwIntVect, __out PULONG pdwIoPorts, __in INT nNumPorts, __out PULONG pdwMemPorts, __in INT nNumMemPorts);
EXTERN VOID 	(WINAPI *cmxWriteMemPortDW)		(__in LONG BoardId, __in  ULONG dwPortBase, __in ULONG nOffset, __in LONG dwWriteVal);
EXTERN DWORD	(WINAPI *cmxReadMemPortDW)		(__in LONG BoardId, __in  ULONG dwPortBase, __in ULONG nOffset, __out PLONG pdwReadVal);
EXTERN DWORD	(WINAPI *cmxDpramRead)			(__in LONG BoardId, __in LONG StartAddr, __in LONG Size, __out PBYTE pBuffer);
EXTERN DWORD	(WINAPI *cmxDpramWrite)			(__in LONG BoardId, __in LONG StartAddr, __in LONG Size, __in PBYTE pBuffer);
EXTERN DWORD	(WINAPI *cmxDpramBusyEnable)	(__in LONG BoardId, __in LONG SectId, __in LONG IsWaitEnable, __in LONG TimeoutVal);
EXTERN DWORD	(WINAPI *cmxDpramBusyDisable)	(__in LONG BoardId, __in LONG SectId);

//////////////////////////////////////////////////////////////////////////
// Device Load / Unload
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 IsResetDevice : ̽ ʱȭմϴ, [OUT] VT_PI4 NumServos : ˻   ȯմϴ.  Ķʹ NULL  մϴ.
EXTERN LONG 	(WINAPI *cmxGnLoadDevice)		(__out PLONG NumDevices, __out PLONG BoardIdList, __out_opt PLONG NumServos);
EXTERN LONG 	(WINAPI *cmxGnUnloadDevice) 		();

EXTERN LONG	(WINAPI *cmxGnSetLogMode)		(__in  LONG LogMode);
EXTERN LONG	(WINAPI *cmxGnGetLogMode)		(__out PLONG LogMode);

EXTERN LONG	(WINAPI *cmxGnSetLogLevel)		(__in  LONG LogLevel);
EXTERN LONG	(WINAPI *cmxGnGetLogLevel)		(__out PLONG LogLevel);

EXTERN LONG	(WINAPI *cmxGnSetFuncLevel)		(__in LONG FuncIndex, __in  LONG LogLevel);
EXTERN LONG	(WINAPI *cmxGnRestoreFuncLevel)	(__in LONG FuncIndex);
EXTERN LONG	(WINAPI *cmxGnGetFuncLevel)		(__in LONG FuncIndex, __out PLONG LogLevel);

//////////////////////////////////////////////////////////////////////////
// General Functions
//////////////////////////////////////////////////////////////////////////

EXTERN  LONG    (WINAPI *cmxGnSetCommStates)		(__in LONG BoardId, __in LONG Axis, __in LONG cmStsId, __in  LONG CommStsVal);
EXTERN  LONG    (WINAPI *cmxGnGetCommStates)		(__in LONG BoardId, __in LONG Axis, __in LONG cmStsId, __out PLONG CommStsVal);

EXTERN  LONG    (WINAPI *cmxGnResetComm)		(__in LONG BoardId);


// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 dwIsOn :  ¸ մϴ.   (1: , 0: )
EXTERN	LONG	(WINAPI *cmxGnSetServoOn)		(__in LONG BoardId, __in	LONG Axis, __in LONG  dwIsOn);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 dwIsOn :  ¸ ȯմϴ. (1: , 0: )
EXTERN	LONG	(WINAPI *cmxGnGetServoOn)		(__in LONG BoardId, __in	LONG Axis, __out PLONG pdwIsOn);

EXTERN  LONG	(WINAPI *cmxGnSetAlarmRes)		(__in LONG BoardId, __in   LONG Axis);
EXTERN  LONG 	(WINAPI *cmxGnGetAlarmRes)		(__in LONG BoardId, __in	LONG Axis, __out LONG * IsOn);

EXTERN  LONG 	(WINAPI *cmxGnGetAlarmCode)		(__in LONG BoardId, __in	LONG Axis, __out LONG * AlarmCode);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsSimulMode : ùķ̼  Ȱȭ θ մϴ.   (1: ùķ̼  Ȱȭ, 0: ùķ̼  Ȱȭ)
EXTERN	LONG	(WINAPI *cmxGnSetSimulMode)		(__in LONG BoardId, __in	LONG Axis, __in  LONG  SimulMode);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 IsSimulMode : ùķ̼  Ȱȭ θ ȯմϴ.   (1: ùķ̼  Ȱȭ, 0: ùķ̼  Ȱȭ)
EXTERN	LONG	(WINAPI *cmxGnGetSimulMode)		(__in LONG BoardId, __in	LONG Axis, __out PLONG SimulMode);

EXTERN	LONG	(WINAPI *cmxGnSetEmergency)		(__in LONG BoardId, __in	LONG Axis, __in LONG IsDecStop, __in LONG IsEnable);
EXTERN	LONG	(WINAPI *cmxGnGetEmergency)		(__in LONG BoardId, __in	LONG Axis, __out PLONG IsDecStopped, __out PLONG IsEnabled);
EXTERN	LONG	(WINAPI *cmxGnSetEmergencyAll)		( __in   LONG IsDecStop, __in	LONG IsEnable);
EXTERN	LONG	(WINAPI *cmxGnGetEmergencyAll)		( __out  LONG * IsDecStopped, __out	PLONG IsEnabled);

// (NEMO) Sampling Period  Ǵ ȯմϴ.
// [IN] nPeriod
EXTERN LONG	(WINAPI *cmxGnSetCommPeriod)		(__in LONG BoardId, __in LONG nPeriod);

// (NEMO) Sampling Period Flashκ о´.
// [OUT] nPeriod
EXTERN LONG	(WINAPI *cmxGnGetCommPeriod)		(__in LONG BoardId, __out PLONG nPeriod);

EXTERN	LONG	(WINAPI *cmxGnResetDevice)		(__in LONG BoardId, __in	LONG ResetMask);

// [IN] VT_I4 dwInterval : Ʈ ֱ (500usec Unit)
EXTERN  LONG	(WINAPI *cmxGnSetStatusUpdateInterval)	(__in LONG BoardId, __in	LONG dwInterval);
EXTERN	LONG	(WINAPI *cmxGnGetStatusUpdateInterval)	(__in LONG BoardId, __out	PLONG dwInterval);

// [OUT] AxisMapMask
EXTERN	LONG	(WINAPI *cmxGnGetAxisMap)		(__in LONG BoardId, __out	LONG* AxisMapMask);

// Network Servo Ķ͸ մϴ.
// [IN] Axis, [IN] PrmNo1, [IN] PrmData1, [IN] PrmNo2, [IN] PrmData2
EXTERN LONG 	(WINAPI *cmxGnSetParam) 				(__in LONG BoardId, __in LONG Axis, __in LONG PrmNo1, __in LONG PrmData1, __in LONG PrmNo2, __in LONG PrmData2);

// Network Servo Ķ͸ ɴϴ.
// [IN] Axis, [IN] PrmNo1, [OUT] pPrmData1, [IN] PrmNo2, [OUT] pPrmData2
EXTERN LONG 	(WINAPI *cmxGnGetParam) 				(__in LONG BoardId, __in LONG Axis, __in LONG PrmNo1, __out PLONG pPrmData1, __in LONG PrmNo2, __out PLONG pPrmData2);
// Network Servo ġ ڴ մϴ.( Ķ͵ ˴ϴ.)
EXTERN LONG		(WINAPI *cmxGnSetABSMode)		(__in LONG BoardId, __in LONG Axis, __in LONG EncoderMode);

// Network Servo ġ ڴ ȯմϴ.
EXTERN LONG		(WINAPI *cmxGnGetABSMode)		(__in LONG BoardId, __in LONG Axis, __out PLONG EncoderMode);

// Network Servo Driver ġ  о մϴ.
EXTERN LONG		(WINAPI *cmxGnABSUpdate)		(__in LONG BoardId);

EXTERN LONG		(WINAPI *cmxGnSetABSHome)		(__in LONG BoardId, __in LONG Axis);
// Network Servo  带 մϴ.(ġ, ũ)
EXTERN LONG		(WINAPI *cmxGnSetControlMode)	(__in LONG BoardId, __in LONG Axis, __in LONG ControlMode);

// Network Servo  带 ȯմϴ.(ġ, ӵ, ũ)
EXTERN LONG		(WINAPI *cmxGnGetControlMode)	(__in LONG BoardId, __in LONG Axis, __out PLONG ControlMode);

// Network Servo ġ   ũ  带 մϴ.
EXTERN LONG		(WINAPI *cmxGnSetPositionTorqueMode) (__in LONG BoardId, __in LONG Axis, __in LONG Enable);

// Network Servo ġ   ũ  带 ȯմϴ.
EXTERN LONG		(WINAPI *cmxGnGetPositionTorqueMode) (__in LONG BoardId, __in LONG Axis, __out PLONG Enable);

//   εմϴ.
EXTERN LONG	(WINAPI *cmxGnInitFromFile)		(__in LONG BoardId, __in char * szFileName);

//////////////////////////////////////////////////////////////////////////
// Cfg Functions
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PropId :  id մϴ, [IN] VT_I4 PropVal :  id 
EXTERN	LONG	(WINAPI *cmxCfgSetMioProperty)		(__in LONG BoardId, __in	LONG Axis, __in LONG PropId, __in  LONG  PropVal);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PropId :  id մϴ, [OUT] VT_PI4 PropVal :  id 
EXTERN	LONG	(WINAPI *cmxCfgGetMioProperty)		(__in LONG BoardId, __in	LONG Axis, __in LONG PropId, __out PLONG PropVal);


EXTERN	LONG	(WINAPI *cmxCfgSetUnitDist)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE UnitDist);
EXTERN	LONG	(WINAPI *cmxCfgGetUnitDist)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE * UnitDist);
EXTERN	LONG	(WINAPI *cmxCfgSetUnitSpeed)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE UnitSpeed);
EXTERN	LONG	(WINAPI *cmxCfgGetUnitSpeed)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE * UnitSpeed);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 SpeedMode([0]Constant, [1]Trapezoidal, [2]S-Curve) [IN] VT_R8 Work/Workspeed, [IN] VT_R8 Acc/Acceleration , [IN] VT_R8 Dec/Deceleration, [IN] VT_R8 Ini/IniSpeed, [IN] VT_R8 End/EndSpeed 
EXTERN  LONG    (WINAPI *cmxCfgSetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __in LONG SpeedMode, __in DOUBLE Work, __in DOUBLE Acc, __in DOUBLE Dec, __in DOUBLE Ini, __in DOUBLE End);	

// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 SpeedMode([0]Constant, [1]Trapezoidal, [2]S-Curve) [OUT] VT_PR8 Work/Workspeed, [OUT] VT_PR8 Acc/Acceleration , [OUT] VT_PR8 Dec/Deceleration, [OUT] VT_PR8 Ini/IniSpeed, [OUT] VT_PR8 End/EndSpeed 
EXTERN  LONG    (WINAPI *cmxCfgGetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __out PLONG SpeedMode, __out DOUBLE * Work, __out DOUBLE * Acc, __out DOUBLE * Dec, __out DOUBLE * Ini, __out DOUBLE * End);

// [IN] VT_I4 Axis : ȣ, [OUT] VT_I4 IsEnable : Ʈ   Ȱȭ θ մϴ, [IN] VT_R8 LimitN : (-) Limit, [IN] VT_R8 LimitP : (+) Limit
EXTERN	LONG	(WINAPI *cmxCfgSetSoftLimit)		(__in LONG BoardId, __in LONG Axis, __in LONG IsEnable, __in DOUBLE LimitN, __in DOUBLE LimitP);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_I4 IsEnabled : Ʈ   Ȱȭ θ ȯմϴ, [OUT] VT_R8 LimitN : (-) Limit, [OUT] VT_R8 LimitP : (+) Limit
EXTERN	LONG	(WINAPI *cmxCfgGetSoftLimit)		(__in LONG BoardId, __in LONG Axis, __out PLONG IsEnabled, __out DOUBLE * LimitN, __out DOUBLE * LimitP);

// [IN] Axis, [IN] IsEnable, [IN] DevRange
EXTERN	LONG	(WINAPI *cmxCfgSetSvonDevRange)	(__in LONG BoardId, __in LONG Axis, __in LONG IsEnable, __in LONG DevRange);

// [IN] Axis, [OUT] IsEnable, [OUT] DevRange
EXTERN	LONG	(WINAPI *cmxCfgGetSvonDevRange)	(__in LONG BoardId, __in LONG Axis, __out PLONG IsEnable, __out PLONG DevRange);

//////////////////////////////////////////////////////////////////////////
// Sx Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Distance : Ÿ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN	LONG	(WINAPI *cmxSxMove)			(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Distance, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Distance : Ÿ
EXTERN	LONG	(WINAPI *cmxSxMoveStart)		(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Distance);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Position : ġ, [IN] VT_I4  IsBlocking :  ޽ ŷ 
EXTERN	LONG	(WINAPI *cmxSxMoveTo)			(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Position, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Position : ġ
EXTERN	LONG	(WINAPI *cmxSxMoveToStart)		(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Position);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 Dir : 
EXTERN	LONG	(WINAPI *cmxSxVMoveStart)		(__in LONG BoardId, __in	LONG Axis, __in LONG Dir);
// [IN] VT_I4 Axis : ȣ
EXTERN  LONG	(WINAPI *cmxSxStop)			(__in LONG BoardId, __in	LONG Axis);
// [IN] VT_I4 Axis : ȣ
EXTERN	LONG	(WINAPI *cmxSxStopEmg)			(__in LONG BoardId, __in	LONG Axis);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 pdwIsDone : ̼ ϷǾ ȯ(0:̼, 1:̼ۿϷ)
EXTERN	LONG	(WINAPI *cmxSxIsDone)			(__in LONG BoardId, __in	LONG Axis, __out PLONG pdwIsDone);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsBlocking :  ޼ ŷ 
EXTERN  LONG	(WINAPI *cmxSxWaitDone)		(__in LONG BoardId, __in	LONG Axis, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 CorrMode :     (0:  Ȱȭ, 1: 鷡  , 2:   ), [IN] VT_R8 CorrAmount :  ޽  ( Ÿ ), [IN] VT_I4 CntrMask :  ޽ ½ÿ  ī    (BIT0 1: Command Counter , BIT1 1: Feedback Counter , BIT2 1: Deviation Counter , BIT3 1: General Counter )
EXTERN	LONG	(WINAPI *cmxSxSetCorrection)		(__in LONG BoardId, __in	LONG Axis, __in  LONG CorrMode,	__in  DOUBLE   CorrAmount,__in   DOUBLE   CorrVel, __in  LONG  CntrMask);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 CorrMode :   ȯ  (0:  Ȱȭ, 1: 鷡  , 2:   ), [IN] VT_R8 CorrAmount :  ޽  ( Ÿ ), [IN] VT_I4 CntrMask :  ޽ ½ÿ  ī    (BIT0 1: Command Counter , BIT1 1: Feedback Counter , BIT2 1: Deviation Counter , BIT3 1: General Counter )
EXTERN	LONG	(WINAPI *cmxSxGetCorrection)		(__in LONG BoardId, __in	LONG Axis, __out PLONG CorrMode,__out DOUBLE * CorrAmount, __out DOUBLE * CorrVel, __out PLONG CntrMask);

//////////////////////////////////////////////////////////////////////////
// Mx Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 DistList : Ÿ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmxMxMove)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * DistList, __in LONG IsBlocking);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 DistList : Ÿ Ʈ
EXTERN LONG	(WINAPI *cmxMxMoveStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * DistList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 PosList : ġ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmxMxMoveTo)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * PosList, __in LONG IsBlocking);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 PosList : ġ Ʈ
EXTERN LONG	(WINAPI *cmxMxMoveToStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * PosList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PI4 DirList :  Ʈ
EXTERN LONG	(WINAPI *cmxMxVMoveStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in PLONG DirList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList :   ȣ Ʈ
EXTERN LONG	(WINAPI *cmxMxStop)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList :   ȣ Ʈ
EXTERN LONG	(WINAPI *cmxMxStopEmg)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_I4 IsDone: Ϸ 
EXTERN LONG	(WINAPI *cmxMxIsDone)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __out PLONG IsDone);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmxMxWaitDone)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in LONG IsBlocking);

//////////////////////////////////////////////////////////////////////////
// Ix Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 MapMask : ʸũ, [IN] VT_I4 IxMode : ̼  (0:, 1:ȣ, 2:︮ú, 3:öκ)
EXTERN LONG	(WINAPI *cmxIxMapAxes)			(__in LONG BoardId, __in LONG MapIndex, __in LONG MapMask, __in LONG IxMode);
// [IN] VT_I4 MapIndex : ʹȣ
EXTERN LONG	(WINAPI *cmxIxUnMapAxes)		(__in LONG BoardId, __in LONG MapIndex);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 IsVectorSpeed : ǵ (0:ͽǵ , 1:ͽǵ ), [IN] VT_I4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [IN] VT_R8 Ini : ʱӵ, [IN] VT_R8 End : ӵ, [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 Acc : ӵ, [IN] VT_R8 Dec : ӵ
EXTERN LONG	(WINAPI *cmxIxSetSpeedPattern)		(__in LONG BoardId, __in LONG MapIndex, __in  LONG  IsVectorSpeed, __in  LONG  SpeedMode, __in  DOUBLE   Ini, __in  DOUBLE   End, __in  DOUBLE   Vel, __in  DOUBLE Acc, __in  DOUBLE Dec);
// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 IsVectorSpeed : ǵ (0:ͽǵ , 1:ͽǵ ), [OUT] VT_PI4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [OUT] VT_PR8 Ini : ʱӵ, [OUT] VT_PR8 End : ӵ, [OUT] VT_PR8 Vel : ۾ӵ, [OUT] VT_PR8 Acc : ӵ, [OUT] VT_PR8 Dec : ӵ
EXTERN LONG	(WINAPI *cmxIxGetSpeedPattern)		(__in LONG BoardId, __in LONG MapIndex, __out PLONG IsVectorSpeed, __out PLONG SpeedMode, __out DOUBLE * Ini, __out DOUBLE * End, __out DOUBLE * Vel, __out DOUBLE * Acc, __out DOUBLE * Dec);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 DistList : Ÿ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmxIxLine)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * DistList, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 DistList : Ÿ Ʈ
EXTERN LONG	(WINAPI *cmxIxLineStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * DistList);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 PosList : ġ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmxIxLineTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * PosList, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 PosList : ġ Ʈ
EXTERN LONG	(WINAPI *cmxIxLineToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * PosList);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmxIxArcA)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE EndAngle, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree)
EXTERN LONG	(WINAPI *cmxIxArcAStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmxIxArcATo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE EndAngle, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree)
EXTERN LONG	(WINAPI *cmxIxArcAToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 XEndPointDist : ǥ ġκ X Ÿ, [IN] VT_R8 YEndPointDist : ǥ ġκ Y Ÿ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmxIxArcP)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE XEndPointDist, __in DOUBLE YEndPointDist, __in LONG Direction, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 XEndPointDist : ǥ ġκ X Ÿ, [IN] VT_R8 YEndPointDist : ǥ ġκ Y Ÿ
EXTERN LONG	(WINAPI *cmxIxArcPStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE XEndPointDist, __in DOUBLE YEndPointDist, __in LONG Direction);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 XEndPos : ǥ X ǥ, [IN] VT_R8 YEndPos : ǥ Y ǥ, [IN] VT_I4 Direction : ȸ(0:ð(CW), 1:ݽð(CCW)), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmxIxArcPTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE XEndPos, __in DOUBLE YEndPos, __in LONG Direction, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 XEndPos : ǥ X ǥ, [IN] VT_R8 YEndPos : ǥ Y ǥ, [IN] VT_I4 Direction : ȸ(0:ð(CW), 1:ݽð(CCW))
EXTERN LONG	(WINAPI *cmxIxArcPToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE XEndPos, __in DOUBLE YEndPos, __in LONG Direction);

EXTERN LONG	(WINAPI *cmxIxArc3P)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE *P2, __in DOUBLE *P3, __in DOUBLE EndAngle, __in LONG IsBlocking);
EXTERN LONG	(WINAPI *cmxIxArc3PStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE *P2, __in DOUBLE *P3, __in DOUBLE EndAngle);
EXTERN LONG	(WINAPI *cmxIxArc3PTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE *P2, __in DOUBLE *P3, __in DOUBLE EndAngle, __in LONG IsBlocking);
EXTERN LONG	(WINAPI *cmxIxArc3PToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE *P2, __in DOUBLE *P3, __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 IsDone : ̼ ϷǾ ȯ(0:̼, 1:̼ۿϷ)
EXTERN LONG	(WINAPI *cmxIxIsDone)			(__in LONG BoardId, __in LONG MapIndex, __out LONG *IsDone);
// [IN] VT_I4 MapINdex : ʹȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmxIxWaitDone) 		(__in LONG BoardId, __in LONG MapIndex, __in  LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 IsWaitComplete : Ϸ  ٸ  , [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmxIxStop) 			(__in LONG BoardId, __in LONG MapIndex, __in  LONG IsWaitComplete, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ
EXTERN LONG	(WINAPI *cmxIxStopEmg) 		(__in LONG BoardId, __in LONG MapIndex);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PI4 Helcoord : 3 ǥ 迭, [IN] VT_I4 ArcAngle : ̼۰(degree)
EXTERN LONG	(WINAPI *cmxIxHelOnceStart) 		(__in LONG BoardId, __in LONG MapIndex, __in LONG * HelCoord, __in LONG ArcAngle);
EXTERN LONG	(WINAPI *cmxIxSplineStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE InArray[20][2], __in LONG  NumInArray, __in LONG NumOutArray);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 MapIndex : ش  ϰ ִ MapIndex ȣ
EXTERN LONG	(WINAPI *cmxIxGetMapIndex)		(__in LONG BoardId, __in LONG Axis, __out PLONG MapIndex);

//////////////////////////////////////////////////////////////////////////
// Return to Home
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmxHomeSetOffset)		(__in LONG BoardId, __in LONG Channel, __in DOUBLE Offset);
EXTERN LONG (WINAPI *cmxHomeGetOffset)		(__in LONG BoardId, __in LONG Channel, __out DOUBLE *Offset);

EXTERN LONG	(WINAPI *cmxHomeSetConfig)		(__in LONG BoardId, __in LONG Channel, __in LONG ParamId, __out LONG ParamVal);//(__in LONG BoardId, __in LONG Channel, __in LONG ParamId, __in LONG ParamVal);
EXTERN LONG	(WINAPI *cmxHomeGetConfig)		(__in LONG BoardId, __in LONG Channel, __in LONG ParamId, __out LONG * ParamVal);

EXTERN LONG (WINAPI *cmxHomeSetPosClrMode)		(__in LONG BoardId, __in LONG Channel, __in LONG PosClrMode);
EXTERN LONG	(WINAPI *cmxHomeGetPosClrMode)		(__in LONG BoardId, __in LONG Channel, __out PLONG PosClrMode);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 PhaseID, [IN] VT_I4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 Accel : ӵ, [IN] VT_R8 Decel : ӵ
EXTERN LONG	(WINAPI *cmxHomeSetSpeedPattern)	(__in LONG BoardId, __in LONG Channel, __in LONG PhaseID, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE Accel, __in DOUBLE Decel);
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 PhaseID, [IN] VT_I4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 Accel : ӵ, [IN] VT_R8 Decel : ӵ
EXTERN LONG	(WINAPI *cmxHomeGetSpeedPattern)	(__in LONG BoardId, __in LONG Channel, __in LONG PhaseID, __out PLONG SpeedMode, __out DOUBLE * Vel, __out DOUBLE * Accel, __out DOUBLE * Decel);

// 2013.08.12 yds add
EXTERN LONG	(WINAPI *cmxHomeSetSpeedPattern_T)		(__in LONG BoardId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime, __in DOUBLE RevVel);
EXTERN LONG	(WINAPI *cmxHomeGetSpeedPattern_T)		(__in LONG BoardId, __in LONG Channel, __in PLONG SpeedMode, __out DOUBLE * Vel, __out DOUBLE * AccTime, __out DOUBLE * DecTime, __out DOUBLE RevVel);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmxHomeMove)			(__in LONG BoardId, __in LONG Channel, __in LONG IsBlocking);
// [IN] VT_I4 Channel : ȣ,
EXTERN LONG	(WINAPI *cmxHomeMoveStart)		(__in LONG BoardId, __in LONG Channel);

// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 ChannelList : ϴ  ȣ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmxHomeMoveAll)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG ChannelList, __in LONG IsBlocking);

// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 ChannelList : ϴ  ȣ Ʈ
EXTERN LONG	(WINAPI *cmxHomeMoveAllStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG ChannelList);
// [IN] VT_I4 Channel : ȣ, [IN] VT_PI4 : IsBusy :  Ͱ  ȯ(0: , 1:)
EXTERN LONG	(WINAPI *cmxHomeIsBusy)		(__in LONG BoardId, __in LONG Channel, __out PLONG IsBusy);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)   
EXTERN LONG	(WINAPI *cmxHomeWaitDone)		(__in LONG BoardId, __in LONG Channel, __in LONG IsBlocking);

EXTERN LONG	(WINAPI *cmxHomeSetSuccess)		(__in LONG BoardId, __in LONG Channel, __in LONG IsSuccess);
EXTERN LONG	(WINAPI *cmxHomeGetSuccess)		(__in LONG BoardId, __in LONG Channel, __out PLONG IsSuccess);

//////////////////////////////////////////////////////////////////////////
// Override Motion
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Channel : ȣ
EXTERN LONG	(WINAPI *cmxOverrideSpeedSet)		(__in LONG BoardId, __in LONG Channel);
// [IN] VT_I4 Channel : ȣ, [IN] VT_R8 NewDistance : ο ǥ Ÿ, [OUT] VT_PI4 IsIgnored : OverrideMove  /  ȯ  (0:  , 1: )
EXTERN LONG	(WINAPI *cmxOverrideMove)		(__in LONG BoardId, __in LONG Channel, __in DOUBLE NewDistance, __out PLONG IsIgnored);
// [IN] VT_I4 Channel : ȣ, [IN] VT_R8 NewPosition : ο ǥ Ÿ, [OUT] VT_PI4 IsIgnored : OverrideMove  /  ȯ  (0:  , 1: )
EXTERN LONG	(WINAPI *cmxOverrideMoveTo)		(__in LONG BoardId, __in LONG Channel, __in DOUBLE NewPosition, __out PLONG IsIgnored);

//////////////////////////////////////////////////////////////////////////
// Listed Motion
//////////////////////////////////////////////////////////////////////////
EXTERN LONG	(WINAPI *cmxLmxStart)			(__in LONG BoardId, __in LONG	LmIdx, __in LONG LmStartMode, __in LONG AxisMask);
EXTERN LONG	(WINAPI *cmxLmxSuspend)		(__in LONG BoardId, __in LONG	LmIdx, __in LONG SuspendMode);
EXTERN LONG	(WINAPI *cmxLmxResume)			(__in LONG BoardId, __in LONG	LmIdx, __in	LONG ResumeMode);
EXTERN LONG	(WINAPI *cmxLmxEnd)			(__in LONG BoardId, __in LONG	LmIdx);
EXTERN LONG	(WINAPI *cmxLmxGetStates)		(__in LONG BoardId, __in LONG	LmIdx, __in LONG LmStsId, __out PLONG LmxStsVal);

EXTERN LONG (WINAPI *cmxLmxSetSeqMode)		(__in LONG  LmIdx, __in  LONG SeqMode);
EXTERN LONG	(WINAPI *cmxLmxGetSeqMode)		(__in LONG  LmIdx, __out  LONG SeqMode);

EXTERN LONG	(WINAPI *cmxLmxSetNextItemId)		(__in LONG	LmIdx, __in  LONG SeqId);
EXTERN LONG	(WINAPI *cmxLmxGetNextItemId)		(__in LONG	LmIdx, __out LONG *SeqId);
EXTERN LONG	(WINAPI *cmxLmxSetNextItemParam)	(__in LONG	LmIdx, __in  LONG ParamIdx, __in  LONG ParamData);
EXTERN LONG	(WINAPI *cmxLmxGetNextItemParam)	(__in LONG	LmIdx, __in  LONG ParamIdx, __out  PLONG ParamData);
EXTERN LONG	(WINAPI *cmxLmxGetRunItemParam)	(__in LONG BoardId, __in LONG	LmIdx, __in  LONG ParamIdx, __out  PLONG ParamData);

EXTERN LONG	(WINAPI *cmxLmxGetRunItemStaPos)	(__in LONG 	LmIdx, __in  LONG Axis,     __out DOUBLE * Position);
EXTERN LONG	(WINAPI *cmxLmxGetRunItemTargPos)	(__in LONG	LmIdx, __in  LONG Axis,     __out DOUBLE * Position);

EXTERN LONG	(WINAPI *cmxLmxSetSeqId)		(__in LONG BoardId, __in LONG LmIdx, __in  LONG SeqId);
EXTERN LONG	(WINAPI *cmxLmxGetSeqId)		(__in LONG BoardId, __in LONG LmIdx, __out PLONG pSeqId);

//////////////////////////////////////////////////////////////////////////
// Status Monitoring
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_I4 pdwCount :  ī (޽ īƮ)
EXTERN LONG	(WINAPI *cmxStSetCount)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __in  LONG pdwCount);
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PI4 pdwcount : ī (޽ īƮ)
EXTERN LONG	(WINAPI *cmxStGetCount)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out PLONG pdwCount);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PI4 pdwcount : ī ( īƮ)
EXTERN LONG	(WINAPI *cmxStSetPosition)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __in  DOUBLE Count);
// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PI4 pdwcount : ī ( īƮ)
EXTERN LONG	(WINAPI *cmxStGetPosition)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out DOUBLE * Count);

// [IN] VT_I4 Channel : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PR8 Speed : ī ( īƮ)
EXTERN LONG	(WINAPI *cmxStGetSpeed)		(__in LONG BoardId, __in LONG Channel, __in LONG Source, __out DOUBLE * Speed);

EXTERN LONG	(WINAPI *cmxStSetTorque)			(__in LONG BoardId, __in LONG Channel, __in LONG Torque);

EXTERN LONG	(WINAPI *cmxStGetTorque)		(__in LONG BoardId, __in LONG Channel, __out DOUBLE * Torque);

EXTERN LONG	(WINAPI *cmxStSetTorqueVelLimit)	(__in LONG BoardId, __in LONG Channel, __in LONG TorqueVelLimit);

EXTERN LONG	(WINAPI *cmxStGetTorqueVelLimit)	(__in LONG BoardId, __in LONG Channel, __out LONG * TorqueVelLimit);

EXTERN LONG (WINAPI *cmxStSetTorqueLimit)		(__in LONG BoardId, __in LONG Channel, __in LONG nDir, __in LONG TorqueLimit);

EXTERN LONG (WINAPI *cmxStGetTorqueLimit)		(__in LONG BoardId, __in LONG Channel, __in LONG nDir, __out PLONG TorqueLimit);

EXTERN LONG (WINAPI *cmxStSetVelocity)			(__in LONG BoardId, __in LONG Channel, __in LONG Velocity);

EXTERN LONG (WINAPI *cmxStGetVelocity)			(__in LONG BoardId, __in LONG Channel, __out LONG * Velocity);

// [IN] VT_I4 Channel : ȣ, [OUT] VT_PI4 MotStates
EXTERN LONG	(WINAPI *cmxStSxReadMotionState)	(__in LONG BoardId, __in LONG Channel, __out PLONG MotStates);
// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 MotStates
EXTERN LONG	(WINAPI *cmxStIxReadMotionState)	(__in LONG BoardId, __in LONG MapIndex, __out PLONG MotStates);

// [IN] VT_I4 Channel : ȣ, [OUT] VT_PI4 MioStates : Machine I/O 
EXTERN LONG 	(WINAPI *cmxStReadMioStatuses)		(__in LONG BoardId, __in LONG Channel, __out PLONG MioStates);

EXTERN LONG	(WINAPI *cmxStGetMotionMode)		(__in LONG BoardId, __in LONG Channel, __out PLONG Mode);

EXTERN LONG	(WINAPI *cmxStSxGetLastError)		(__in LONG BoardId, __in LONG Channel, __out PLONG LastError);

EXTERN LONG	(WINAPI *cmxStIxGetLastError)		(__in LONG BoardId, __in LONG MapIndex,__out PLONG LastError);

EXTERN LONG (WINAPI *cmxStSetMultiRevCnt)		(__in LONG BoardId, __in LONG Axis, __in LONG MultiRevCnt);
EXTERN LONG (WINAPI *cmxStGetMultiRevCnt)		(__in LONG BoardId, __in LONG Axis, __out PLONG pMultiRevCnt);

EXTERN LONG (WINAPI *cmxStSetOneRevPos)		(__in LONG BoardId, __in LONG Axis, __in LONG OneRevPos);
EXTERN LONG (WINAPI *cmxStGetOneRevPos)		(__in LONG BoardId, __in LONG Axis, __out PLONG pOneRevPos);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (GN)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [OUT] SlaveInfo
EXTERN LONG		(WINAPI *cmxGnGetNodeInfo)			(__in LONG BoardId, __in LONG Axis, __out cmxSlaveInfo* SlaveInfo);

// [IN] Axis,	[OUT] Channel 
EXTERN LONG		(WINAPI *cmxGnTotalDIOChannel)		(__in LONG BoardId, __in LONG Axis, __out PLONG Channel);

// [IN] Axis,	[OUT] Channel 
EXTERN LONG		(WINAPI *cmxGnTotalAIChannel)			(__in LONG BoardId, __in LONG Axis, __out PLONG Channel);

// [IN] Axis,	[OUT] Channel 
EXTERN LONG		(WINAPI *cmxGnTotalAOChannel)			(__in LONG BoardId, __in LONG Axis, __out PLONG Channel);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (DI)
/////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [OUT] Logic
EXTERN LONG		(WINAPI *cmxDiGetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Logic);

// [IN] Axis [IN] Channel [IN] Logic
EXTERN LONG		(WINAPI *cmxDiSetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
EXTERN LONG		(WINAPI *cmxDiGetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
EXTERN LONG		(WINAPI *cmxDiSetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG Logic);

// [IN] Axis [IN] Channel [OUT] State
EXTERN LONG		(WINAPI *cmxDiGetOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
EXTERN LONG		(WINAPI *cmxDiGetMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG State);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (DO)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [OUT] Logic
EXTERN LONG		(WINAPI *cmxDoGetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Logic);

// [IN] Axis [IN] Channel [IN] Logic
EXTERN LONG		(WINAPI *cmxDoSetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
EXTERN LONG		(WINAPI *cmxDoGetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
EXTERN LONG		(WINAPI *cmxDoSetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG Logic);

// [IN] Axis [IN] Channel [IN] State
EXTERN LONG		(WINAPI *cmxDoPutOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG State);

// [IN] Axis [IN] Channel [OUT] State
EXTERN LONG		(WINAPI *cmxDoGetOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] State
EXTERN LONG		(WINAPI *cmxDoPutMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
EXTERN LONG		(WINAPI *cmxDoGetMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG State);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (DIO)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [OUT] InOutMode
EXTERN LONG		(WINAPI *cmxDioGetIomode)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG InOutMode);

// [IN] Axis [IN] Channel [IN] InOutMode
EXTERN LONG		(WINAPI *cmxDioSetIomode)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG InOutMode);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] InOutMode
EXTERN LONG		(WINAPI *cmxDioGetIomodeMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG InOutMode);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] InOutMode
EXTERN LONG		(WINAPI *cmxDioSetIomodeMulti)		(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG InOutMode);

// [IN] Axis [IN] Channel [OUT] Logic
EXTERN LONG		(WINAPI *cmxDioGetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Logic);

// [IN] Axis [IN] Channel [IN] Logic
EXTERN LONG		(WINAPI *cmxDioSetLogic)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] Logic
EXTERN LONG		(WINAPI *cmxDioGetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG Logic);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] Logic
EXTERN LONG		(WINAPI *cmxDioSetLogicMulti)			(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG Logic);

// [IN] Axis [IN] Channel [IN] State
EXTERN LONG		(WINAPI *cmxDioPutOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG State);

// [IN] Axis [IN] Channel [OUT] State
EXTERN LONG		(WINAPI *cmxDioGetOne)					(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [IN] State
EXTERN LONG		(WINAPI *cmxDioPutMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __in LONG State);

// [IN] Axis [IN] IniChannel [IN] NumChannel [OUT] State
EXTERN LONG		(WINAPI *cmxDioGetMulti)				(__in LONG BoardId, __in LONG Axis, __in LONG IniChannel, __in LONG NumChannel, __out PLONG State);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (AI)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [IN] Mode
EXTERN LONG		(WINAPI *cmxAiSetVoltRangeMode) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Mode);

// [IN] Axis [IN] Channel [OUT] Mode
EXTERN LONG		(WINAPI *cmxAiGetVoltRangeMode) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Mode);

// [IN] Axis [IN] Channel [OUT] Dmin [OUT] Dmax
EXTERN LONG		(WINAPI *cmxAiGetRangeDigit) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Dmin, __out PLONG Dmax);

// [IN] Axis [IN] Channel [OUT] Digit
EXTERN LONG		(WINAPI *cmxAiGetDigit)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out PLONG Digit);

// [IN] Axis [IN] Channel [OUT] Volt
EXTERN LONG		(WINAPI *cmxAiGetVolt) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out DOUBLE * Volt);

// [IN] Axis [IN] Channel [OUT] Current
EXTERN LONG		(WINAPI *cmxAiGetCurrent) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __out DOUBLE * Current);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (AO)
//////////////////////////////////////////////////////////////////////////

// [IN] Axis [IN] Channel [IN] Digit
EXTERN LONG		(WINAPI *cmxAoOutDigit)				(__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in LONG Digit);

// [IN] Axis [IN] Channel [IN] Volt
EXTERN LONG		(WINAPI *cmxAoOutVolt) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in DOUBLE Volt);

// [IN] Axis [IN] Channel [IN] Current
EXTERN LONG		(WINAPI *cmxAoOutCurrent) (__in LONG BoardId, __in LONG Axis, __in LONG Channel, __in DOUBLE Current);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-GN)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] IsOn
EXTERN LONG (WINAPI *cmxPmGnSetServoOn) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsOn);

// [IN] NodeId [IN] Channel [OUT] pIsOn
EXTERN LONG (WINAPI *cmxPmGnGetServoOn) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsOn);

// [IN] NodeId [IN] Channel [IN] IsOn
EXTERN LONG (WINAPI *cmxPmGnAlarmReset) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsReset);

// [IN] NodeId [IN] Channel [OUT] AlarmCode
EXTERN LONG	(*GnGetAlarmCode) (__in LONG NodeId, __in LONG Channel, __out LONG * AlarmCode);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-CFG)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] PropId [IN] PropVal
EXTERN LONG (WINAPI *cmxPmCfgSetMioProperty) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG PropId, __in LONG PropVal);

// [IN] NodeId [IN] Channel [IN] PropId [OUT] pPropVal
EXTERN LONG (WINAPI *cmxPmCfgGetMioProperty) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG PropId, __out PLONG pPropVal);

// [IN] NodeId [IN] Channel [IN] IsEnable
EXTERN LONG (WINAPI *cmxPmCfgSetFilter) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsEnable);

// [IN] NodeId [IN] Channel [OUT] pIsEnable
EXTERN LONG (WINAPI *cmxPmCfgGetFilter) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsEnable);

// [IN] NodeId [IN] Channel [IN] Target [IN] IsEnable
EXTERN LONG (WINAPI *cmxPmCfgSetFilterAB) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __in LONG IsEnable);

// [IN] NodeId [IN] Channel [IN] Target [OUT] pIsEnable
EXTERN LONG (WINAPI *cmxPmCfgGetFilterAB) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __out PLONG pIsEnable);

// [IN] NodeId [IN] Channel [IN] InputMode [IN] IsReverse
EXTERN LONG (WINAPI *cmxPmCfgSetInMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG InputMode, __in LONG IsReverse);

// [IN] NodeId [IN] Channel [OUT] pInputMode [OUT] pIsReverse
EXTERN LONG (WINAPI *cmxPmCfgGetInMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pInputMode, __out PLONG pIsReverse);

// [IN] NodeId [IN] Channel [IN] OutputMode
EXTERN LONG (WINAPI *cmxPmCfgSetOutMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG OutputMode);

// [IN] NodeId [IN] Channel [OUT] pOutputMode
EXTERN LONG (WINAPI *cmxPmCfgGetOutMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pOutputMode);

// [IN] NodeId [IN] Channel [IN] CtrlMode
EXTERN LONG (WINAPI *cmxPmCfgSetCtrlMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG CtrlMode);

// [IN] NodeId [IN] Channel [OUT] pCtrlMode
EXTERN LONG (WINAPI *cmxPmCfgGetCtrlMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pCtrlMode);

// [IN] NodeId [IN] Channel [IN] Ratio
EXTERN LONG (WINAPI *cmxPmCfgSetInOutRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Ratio);

// [IN] NodeId [IN] Channel [OUT] pRatio
EXTERN LONG (WINAPI *cmxPmCfgGetInOutRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pRatio);

// [IN] NodeId [IN] Channel [IN] UnitDist
EXTERN LONG (WINAPI *cmxPmCfgSetUnitDist) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE UnitDist);

// [IN] NodeId [IN] Channel [OUT] pUnitDist
EXTERN LONG (WINAPI *cmxPmCfgGetUnitDist) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out DOUBLE * pUnitDist);

// [IN] NodeId [IN] Channel [IN] UnitSpeed
EXTERN LONG (WINAPI *cmxPmCfgSetUnitSpeed) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE UnitSpeed);

// [IN] NodeId [IN] Channel [OUT] pUnitSpeed
EXTERN LONG (WINAPI *cmxPmCfgGetUnitSpeed) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out DOUBLE * pUnitSpeed);

// [IN] NodeId [IN] Channel [IN] MaxPPS
EXTERN LONG (WINAPI *cmxPmCfgSetSpeedRange) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG MaxPPS);

// [IN] NodeId [IN] Channel [OUT] pMaxPPS
EXTERN LONG (WINAPI *cmxPmCfgGetSpeedRange) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMaxPPS);

// [IN] NodeId [IN] Channel [IN] SpeedMode [IN] WorkSpeed [IN] Accel [IN] Decel
EXTERN LONG (WINAPI *cmxPmCfgSetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in LONG WorkSpeed, __in LONG Accel, __in LONG Decel);

// [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pWorkSpeed [OUT] pAccel [OUT] pDecel
EXTERN LONG (WINAPI *cmxPmCfgGetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE * pWorkSpeed, __out DOUBLE * pAccel, __out DOUBLE * pDecel);

// [IN] NodeId [IN] Channel [IN] IsEnable [IN] LimitN [IN] LimitP
EXTERN LONG (WINAPI *cmxPmCfgSetSoftLimit) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsEnable, __in DOUBLE LimitN, __in DOUBLE LimitP);

// [IN] NodeId [IN] Channel [OUT] pIsEnable [OUT] pLimitN [OUT] pLimitP
EXTERN LONG (WINAPI *cmxPmCfgGetSoftLimit) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsEnable, __out DOUBLE * pLimitN, __out DOUBLE * pLimitP);

// [IN] NodeId [IN] Channel [IN] TargCntr [IN] IsEnable [IN] CntMax
EXTERN LONG (WINAPI *cmxPmCfgSetRingCntr) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG TargCntr, __in LONG IsEnable, __in LONG CntMax);

// [IN] NodeId [IN] Channel [IN] TargCntr [OUT] pIsEnable [OUT] pCntMax
EXTERN LONG (WINAPI *cmxPmCfgGetRingCntr) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG TargCntr, __out PLONG pIsEnable, __out PLONG pCntMax);

// [IN] NodeId [IN] Channel [IN] CorrRatio
EXTERN LONG (WINAPI *cmxPmCfgSetVelCorrRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG CorrRatio);

// [IN] NodeId [IN] Channel [OUT] pCorrRatio
EXTERN LONG (WINAPI *cmxPmCfgGetVelCorrRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pCorrRatio);

// [IN] NodeId [IN] SeqMode
EXTERN LONG (WINAPI *cmxPmCfgSetSeqMode) (__in LONG BoardId, __in LONG NodeId, __in LONG SeqMode);

// [IN] NodeId [OUT] pSeqMode
EXTERN LONG (WINAPI *cmxPmCfgGetSeqMode) (__in LONG BoardId, __in LONG NodeId, __out PLONG pSeqMode);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-HOME)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] HomeMode [IN] Dir [IN] EzCount [IN] EscDist [IN] Offset
EXTERN LONG (WINAPI *cmxPmHomeSetConfig) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG HomeMode, __in LONG Dir, __in LONG EzCount, __in LONG EscDist, __in DOUBLE Offset);

// [IN] NodeId [IN] Channel [OUT] pHomeMode [OUT] pDir [OUT] pEzCount [OUT] pEscDist [OUT] pOffset
EXTERN LONG (WINAPI *cmxPmHomeGetConfig) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pHomeMode, __out PLONG pDir, __out PLONG pEzCount, __out PLONG pEscDist, __out DOUBLE * pOffset);

// [IN] NodeId [IN] Channel [IN] PosClrMode
EXTERN LONG (WINAPI *cmxPmHomeSetPosClrMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG PosClrMode);

// [IN] NodeId [IN] Channel [OUT] pPosClrMode
EXTERN LONG (WINAPI *cmxPmHomeGetPosClrMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pPosClrMode);

// [IN] NodeId [IN] Channel [IN] SpeedMode [IN] Vel [IN] Accel [IN] Decel [IN] RevVel
EXTERN LONG (WINAPI *cmxPmHomeSetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE Accel, __in DOUBLE Decel, __in DOUBLE RevVel);

// [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pVel [OUT] pAccel [OUT] pDecel [OUT] pRevVel
EXTERN LONG (WINAPI *cmxPmHomeGetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE * pVel, __out DOUBLE * pAccel, __out DOUBLE * pDecel, __out DOUBLE *pRevVel);

//20130812
EXTERN LONG (WINAPI *cmxPmHomeSetSpeedPattern_T) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime, __in DOUBLE RevVel);
EXTERN LONG (WINAPI *cmxPmHomeGetSpeedPattern_T) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out DOUBLE * pVel, __out DOUBLE * pAccTime, __out DOUBLE * pDecTime, __out DOUBLE * pRevVel);

// [IN] NodeId [IN] Channel
EXTERN LONG (WINAPI *cmxPmHomeMoveStart) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] Channel
EXTERN LONG (WINAPI *cmxPmHomeMoveAllStart) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG ChannelMask);

// [IN] NodeId [IN] Channel [IN] IsSuccess
EXTERN LONG (WINAPI *cmxPmHomeSetSuccess) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsSuccess);

// [IN] NodeId [IN] Channel [OUT] pIsSuccess
EXTERN LONG (WINAPI *cmxPmHomeGetSuccess) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsSuccess);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-SX)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] Channel [IN] SpeedMode [IN] VelRatio [IN] AccRatio [IN] DecRatio
EXTERN LONG (WINAPI *cmxPmSxSetSpeedRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG SpeedMode, __in LONG VelRatio, __in LONG AccRatio, __in LONG DecRatio);

// [IN] NodeId [IN] Channel [OUT] pSpeedMode [OUT] pVelRatio [OUT] pAccRatio [OUT] pDecRatio
EXTERN LONG (WINAPI *cmxPmSxGetSpeedRatio) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pSpeedMode, __out PLONG pVelRatio, __out PLONG pAccRatio, __out PLONG pDecRatio);

// [IN] NodeId [IN] Channel [IN] Distance
EXTERN LONG (WINAPI *cmxPmSxMoveStart) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Distance);

// [IN] NodeId [IN] Channel [IN] Distance [IN] IsBlocking
EXTERN LONG (WINAPI *cmxPmSxMove) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Distance, __in LONG IsBlocking);

// [IN] NodeId [IN] Channel [IN] Position
EXTERN LONG (WINAPI *cmxPmSxMoveToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Position);

// [IN] NodeId [IN] Channel [IN] Position [IN] IsBlocking
EXTERN LONG (WINAPI *cmxPmSxMoveTo) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE Position, __in LONG IsBlocking);

// [IN] NodeId [IN] Channel [IN] Direction
EXTERN LONG (WINAPI *cmxPmSxVMoveStart) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Direction);

// [IN] NodeId [IN] Channel [IN] IsWaitComplete
EXTERN LONG (WINAPI *cmxPmSxStop) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IsWaitComplete);

// [IN] NodeId [IN] Channel [IN] IsWaitComplete
EXTERN LONG (WINAPI *cmxPmSxStopEmg) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] Channel [OUT] pIsDnoe
EXTERN LONG (WINAPI *cmxPmSxIsDone) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsDone);

// [IN] NodeId [IN] Channel 
EXTERN LONG (WINAPI *cmxPmSxWaitDone) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] Channel [OUT] pPosition
EXTERN LONG (WINAPI *cmxPmSxGetTargetPos) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pPosition);

// [IN] NodeId [IN] Channel [IN] IniSpeed
EXTERN LONG (WINAPI *cmxPmSxSetOptIniSpeed) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG IniSpeed);

// [IN] NodeId [IN] Channel [OUT] pIniSpeed
EXTERN LONG (WINAPI *cmxPmSxGetOptIniSpeed) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIniSpeed);

// [IN] NodeId [IN] Channel [IN] OffsetDist
EXTERN LONG (WINAPI *cmxPmSxSetOptRdpOffset) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG OffsetDist);

// [IN] NodeId [IN] Channel [OUT] pOffsetDist
EXTERN LONG (WINAPI *cmxPmSxGetOptRdpOffset) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pOffsetDist);

// [IN] NodeId [IN] Channel [IN] CorrMode [IN] CorrAmount [IN] CorrVel [IN] CntrMask
EXTERN LONG (WINAPI *cmxPmSxSetCorrection) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG CorrMode, __in LONG CorrAmount, __in LONG CorrVel, __in LONG CntrMask);

// [IN] NodeId [IN] Channel [OUT] pCorrMode [OUT] pCorrAmount [OUT] pCorrVel [OUT] pCntrMask
EXTERN LONG (WINAPI *cmxPmSxGetCorrection) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pCorrMode, __out PLONG pCorrAmount, __out PLONG pCorrVel, __out PLONG pCntrMask);

// [IN] NodeId [IN] Channel [IN] Mode [IN] RefAxis [IN] Condition
EXTERN LONG (WINAPI *cmxPmSxSetOptSyncMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Mode, __in LONG RefAxis, __in LONG Condition);

// [IN] NodeId [IN] Channel [OUT] pMode [OUT] pRefAxis [OUT] pCondition
EXTERN LONG (WINAPI *cmxPmSxGetOptSyncMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMode, __out PLONG pRefAxis, __out PLONG pCondition);

// [IN] NodeId [IN] Channel [IN] Mode [IN] DoChan_local [IN] DoLogic
EXTERN LONG (WINAPI *cmxPmSxSetOptSyncOut) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Mode, __in LONG DoChan_local, __in LONG DoLogic);

// [IN] NodeId [IN] Channel [OUT] pMode [OUT] pDoChan_local [OUT] pDoLogic
EXTERN LONG (WINAPI *cmxPmSxGetOptSyncOut) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMode, __out PLONG pDoChan_local, __out PLONG pDoLogic);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-MX)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2]
EXTERN LONG (WINAPI *cmxPmMxMoveStart) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE* DistList);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2] [IN] IsBlocking
EXTERN LONG (WINAPI *cmxPmMxMove) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE* DistList, __in LONG IsBlocking);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2]
EXTERN LONG (WINAPI *cmxPmMxMoveToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE* PosList);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DistList[2] [IN] IsBlocking
EXTERN LONG (WINAPI *cmxPmMxMoveTo) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in DOUBLE* PosList, __in LONG IsBlocking);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] DirMask
EXTERN LONG (WINAPI *cmxPmMxVMoveStart) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in LONG DirMask);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [IN] IsWaitComplete
EXTERN LONG (WINAPI *cmxPmMxStop) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __in LONG IsWaitComplete);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask
EXTERN LONG (WINAPI *cmxPmMxStopEmg) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask [OUT] pIsDone
EXTERN LONG (WINAPI *cmxPmMxIsDone) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask, __out PLONG pIsDone);

// [IN] NodeId [IN] NumChannel [IN] ChannelMask
EXTERN LONG (WINAPI *cmxPmMxWaitDone) (__in LONG BoardId, __in LONG NodeId, __in LONG NumChannel, __in LONG ChannelMask);

//////////////////////////////////////////////////////////////////////////
// NETIO Functions (PM-IX)
//////////////////////////////////////////////////////////////////////////

// [IN] NodeId [IN] MapIndex [IN] MapMask
EXTERN LONG (WINAPI *cmxPmIxMapAxes) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG MapMask);
// [IN] NodeId [IN] MapIndex
EXTERN LONG (WINAPI *cmxPmIxUnMapAxes) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] MapIndex [IN] VelCorrOpt1 [IN] VelCorrOpt2
EXTERN LONG (WINAPI *cmxPmIxSetVelCorrMode) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG VelCorrOpt1, __in LONG VelCorrOpt2);

// [IN] NodeId [IN] MapIndex [OUT] pVelCorrOpt1 [OUT] pVelCorrOpt2
EXTERN LONG (WINAPI *cmxPmIxGetVelCorrMode) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pVelCorrOpt1, __out PLONG pVelCorrOpt2);

// [IN] NodeId [IN] MapIndex [IN] IsVectorSpeed [IN] SpeedMode [IN] Vel [IN] Acc [IN] Dec
EXTERN LONG (WINAPI *cmxPmIxSetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG IsVectorSpeed, __in LONG SpeedMode, __in LONG Vel, __in LONG Acc, __in LONG Dec);

// [IN] NodeId [IN] MapIndex [OUT] pIsVectorSpeed [OUT] pSpeedMode [OUT] pVel [OUT] pAcc [OUT] pDec
EXTERN LONG (WINAPI *cmxPmIxGetSpeedPattern) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __out PLONG pIsVectorSpeed, __out PLONG pSpeedMode, __out PLONG pVel, __out PLONG pAcc, __out PLONG pDec);

// [IN] NodeId [IN] MapIndex [IN] pPosList
EXTERN LONG (WINAPI *cmxPmIxLineStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in PLONG pDistList);

// [IN] NodeId [IN] MapIndex [IN] pPosList
EXTERN LONG (WINAPI *cmxPmIxLineToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in PLONG pPosList);

// [IN] NodeId [IN] MapIndex [IN] XCentOffset [IN] YCentOffset [IN] EndAngle
EXTERN LONG (WINAPI *cmxPmIxArcAStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG XCentOffset, __in LONG YCentOffset, __in LONG EndAngle);

// [IN] NodeId [IN] MapIndex [IN] XCent [IN] YCent [IN] EndAngle
EXTERN LONG (WINAPI *cmxPmIxArcAToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG XCent, __in LONG YCent, __in LONG EndAngle);

// [IN] NodeId [IN] MapIndex [IN] XCentOffset [IN] YCentOffset [IN] XEndPointDist [IN] YEndPointDist [IN] Direction
EXTERN LONG (WINAPI *cmxPmIxArcPStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG XCentOffset, __in LONG YCentOffset, __in LONG XEndPointDist, __in LONG YEndPointDist, __in LONG Direction);

// [IN] NodeId [IN] MapIndex [IN] XCent [IN] YCent [IN] XEndPoint [IN] YEndPoint [IN] Direction
EXTERN LONG (WINAPI *cmxPmIxArcPToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG XCent, __in LONG YCent, __in LONG XEndPoint, __in LONG YEndPoint, __in LONG Direction);

// [IN] NodeId [IN] MapIndex [IN] P2X [IN] P2Y [IN] P3X [IN] P3Y [IN] EndAngle
EXTERN LONG (WINAPI *cmxPmIxArc3PStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG P2X, __in LONG P2Y, __in LONG P3X, __in LONG P3Y, __in LONG EndAngle);

// [IN] NodeId [IN] MapIndex [IN] P2X [IN] P2Y [IN] P3X [IN] P3Y [IN] EndAngle
EXTERN LONG (WINAPI *cmxPmIxArc3PToStart) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __in LONG P2X, __in LONG P2Y, __in LONG P3X, __in LONG P3Y, __in LONG EndAngle);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG (WINAPI *cmxPmIxStop) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG (WINAPI *cmxPmIxStopEmg) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG (WINAPI *cmxPmIxIsDone) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex, __out PLONG pIsDone);

// [IN] NodeId [IN] MapIndex 
EXTERN LONG (WINAPI *cmxPmIxWaitDone) (__in LONG BoardId, __in LONG NodeId, __in LONG MapIndex);

// [IN] NodeId [IN] Channel 
EXTERN LONG (WINAPI *cmxPmOverrideSpeedSet) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel);

// [IN] NodeId [IN] ChannelMask
EXTERN LONG (WINAPI *cmxPmOverrideSpeedSetAll) (__in LONG BoardId, __in LONG NodeId, __in LONG ChannelMask);

// [IN] NodeId [IN] Channel [IN] NewDistance [IN] IsHardApply [OUT] pAppliedState
EXTERN LONG (WINAPI *cmxPmOverrideMove) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE NewDistance, __in LONG IsHardApply, __out PLONG pAppliedState);

// [IN] NodeId [IN] Channel [IN] NewPosition [IN] IsHardApply
EXTERN LONG (WINAPI *cmxPmOverrideMoveTo) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in DOUBLE NewPosition, __in LONG IsHardApply, __out PLONG pAppliedState);

// [IN] NodeId [IN] Channel [IN] Target [IN] Count
EXTERN LONG (WINAPI *cmxPmStSetCount) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __in LONG Count);

// [IN] NodeId [IN] Channel [IN] Source [OUT] pCount
EXTERN LONG (WINAPI *cmxPmStGetCount) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Source, __out PLONG pCount);

// [IN] NodeId [IN] Channel [IN] Target [IN] Position
EXTERN LONG (WINAPI *cmxPmStSetPosition) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Target, __in DOUBLE Position);

// [IN] NodeId [IN] Channel [OUT] pIsLatched
EXTERN LONG (WINAPI *cmxPmStGetPosition) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Source, __out DOUBLE * pPosition);

// [IN] NodeId [IN] Channel [IN] Source [OUT] pIsLatched
EXTERN LONG (WINAPI *cmxPmStGetSpeed) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Source, __out DOUBLE * pSpeed);

// [IN] NodeId [IN] Channel [OUT] pMotStates
EXTERN LONG (WINAPI *cmxPmStReadMotionState) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMotStates);

// [IN] NodeId [IN] Channel [OUT] pMioStates
EXTERN LONG (WINAPI *cmxPmStReadMIOStatus) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pMioStates);

// [IN] NodeId [IN] Channel [OUT] pIsLatched
EXTERN LONG (WINAPI *cmxPmLtcIsLatched) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __out PLONG pIsLatched);

// [IN] NodeId [IN] Channel [IN] Counter [OUT] pLatchedPos
EXTERN LONG (WINAPI *cmxPmLtcReadLatch) (__in LONG BoardId, __in LONG NodeId, __in LONG Channel, __in LONG Counter, __out PLONG pLatchedPos);

//////////////////////////////////////////////////////////////////////////
// Advanced Function
//////////////////////////////////////////////////////////////////////////

// [RTS Update Functions]
// RTS Structure ּҸ RtsData Structure Pointer ȯմϴ.
EXTERN LONG	(WINAPI *cmxAdvGetRtsMemPtr)		(__in LONG BoardId, __out cmxRtsData** ppMemPtr);

// RTS Update  Ȱȭ Ұ Ͽ ϰ  RTS Update Ȱ ¸ ȯմϴ.
EXTERN LONG	(WINAPI *cmxAdvSetRtsEnable)		(__in LONG BoardId, __in LONG IsEnable);
EXTERN LONG	(WINAPI *cmxAdvGetRtsEnable)		(__in LONG BoardId, __out LONG *pIsEnable);

// ش Node RTS Update   Ͽ ϰ  Node RTS Update ¸ ȯմϴ.
EXTERN LONG	(WINAPI *cmxAdvSetRtsMode)		(__in LONG BoardId, __in LONG NodeId, __in LONG IsEnable);
EXTERN LONG	(WINAPI *cmxAdvGetRtsMode)		(__in LONG BoardId, __in LONG NodeId, __out LONG *pIsEnable);

// RTS Structure Update Interval  Ǵ ȯմϴ.
EXTERN LONG	(WINAPI *cmxAdvSetRtsUpdateInterval)	(__in LONG BoardId, __in LONG RtsUpdateInterval);
EXTERN LONG	(WINAPI *cmxAdvGetRtsUpdateInterval)	(__in LONG BoardId, __out PLONG pRtsUpdateInterval);

// [Command Acknowledge Setting Functions]
// API Լ  带 ϰ   带 ȯմϴ.
EXTERN LONG 	(WINAPI *cmxAdvSetCmdAckMode)		(__in LONG BoardId, __in LONG AckMode);
EXTERN LONG 	(WINAPI *cmxAdvGetCmdAckMode) 		(__in LONG BoardId, __out PLONG pAckMode);

// [NEMO Firmware Functions(Undocumented)]
EXTERN LONG	(WINAPI *cmxAdvFwGetVersion)		(__in LONG BoardId, __out PLONG VersionMS, __out PLONG VersionLS);
EXTERN LONG	(WINAPI *cmxAdvFwGetSystemState)	(__in LONG BoardId, __out PLONG State);
EXTERN LONG	(WINAPI *cmxAdvFwDnFrame)		(__in LONG BoardId, __in LONG FrameType, __in PLONG FrameData, __in LONG FrameSize);
EXTERN LONG	(WINAPI *cmxAdvFwDnFrameVerify)	(__in LONG BoardId, __in LONG FrameType, __in PLONG FrameData, __in LONG FrameSize);
EXTERN LONG	(WINAPI *cmxAdvFwSystemReset)		(__in LONG BoardId, __in LONG IsReset);
EXTERN LONG	(WINAPI *cmxAdvFwSetFwuBit)		(__in LONG BoardId, __in LONG IsAnswer, __in LONG Value);
EXTERN LONG	(WINAPI *cmxAdvFwGetFwuBit)		(__in LONG BoardId, __in LONG IsAnswer, __out PLONG pValue);
EXTERN LONG	(WINAPI *cmxAdvFwSetBootFlag)		(__in LONG BoardId, __in LONG Value);
EXTERN LONG	(WINAPI *cmxAdvFwGetBootFlag)		(__in LONG BoardId, __out PLONG pValue);
EXTERN LONG	(WINAPI *cmxAdvFwUpdateMode)		(__in LONG BoardId, __in LONG IsEnable);
// (NEMO-ME) Node Configuration info Flashκ о´.
// [OUT] pT_mcyc,	[OUT] pMa_max,	[OUT] pId_table,	[OUT] pCrdlen_table,	[OUT] pSlv_type 
EXTERN LONG	(WINAPI *cmxAdvM3NodeCfgRead)		(__in LONG BoardId, __out LONG *pT_mcyc, __out LONG *pMa_max, __out LONG *pId_table, __out LONG *pCrdlen_table, __out LONG *pSlv_type);

// (NEMO-ME) Node Configuration info Flash Ѵ.
// [IN] T_mcyc,		[IN] Ma_max,	[IN] pId_table,		[IN] pCrdlen_table,		[IN] pSlv_type 
EXTERN LONG	(WINAPI *cmxAdvM3NodeCfgWrite)	(__in LONG BoardId, __in LONG T_mcyc, __in LONG Ma_max, __in LONG *pId_table, __in LONG *pCrdlen_table, __in LONG *pSlv_type);

#ifdef __cplusplus
}
#endif


#endif
