/*******************************************************************************
* [ ComiLX520_SDK_Def.h ]
* Header file for definitions of constants and data in LX520 library
* - Update Data: 2013/10/25
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#ifndef __COMI_LX520_SDK_DEF_H__
#define __COMI_LX520_SDK_DEF_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// -------------------------------------------------------------------
// Declare Const Values in LX520 Library
// -------------------------------------------------------------------
#define LX540_MAX_SUPPORT_MASTER_BOARDS				16
#define LX520_MAX_SUPPORT_SLAVE_AXES					32
#define LX520_MAX_SUPPORT_INTERPOLATION_MOTION		16
#define	LX520_MAX_SUPPORT_LISTED_MOTION				16
#define LX520_MAX_SUPPORT_LISTED_MOTION_USER_PARAM	4
#define LX520_MAX_MODULE_IN_SLAVE						9
#define LX520_MAX_SUPPORT_IN_NODE_AXES				2

#define MAX_NUM_PLATFORM	5   // RTEX, MLINK3, SSCNET3, MLINK2, SSCNET3/H
#define MAX_NUM_FUNC		600
// -------------------------------------------------------------------
// General Type
// -------------------------------------------------------------------
#ifndef	TRUE
#define TRUE	1
#endif

#ifndef	FALSE
#define FALSE	0
#endif

// -------------------------------------------------------------------
// General BOOLEAN Type Definition
// -------------------------------------------------------------------
typedef enum
{
	cmxFALSE			= 0,
	cmxTRUE			= 1,
	
	//////////////////////////////////////////////////////////////////////////
	cmxBOOLEAN_INVALID		// Used for enumerated type range checking
} cmxBOOLEAN;

// -------------------------------------------------------------------
// Type of  COM State Id (using to GnSetCommStates, GnGetCommStates)
// -------------------------------------------------------------------
typedef enum
{
	cmxCSID_COM_STATES	=	0,
	cmxCSID_RTS_COUNT	=	1,
	cmxCSID_CMD_COUNT	=	2,
	cmxCSID_COM_RST		=	3,	// Only 'Set' Support

	//////////////////////////////////////////////////////////////////////////
	cmxCSID_INVALID				// Used for enumerated type range checking
} cmxCommStates;

// -------------------------------------------------------------------
// Types of [emCOM_STATES] 'States' (using to GnSetCommStates, GnGetCommStates)
// -------------------------------------------------------------------
typedef enum
{
	cmxCOM_STATE_RESET		= -1,
	cmxCOM_STATE_INIT		= 0,
	cmxCOM_STATE_WAITING		= 1,
	cmxCOM_STATE_PREPARE		= 2,
	cmxCOM_STATE_START		= 3,
	cmxCOM_STATE_RUNNING		= 4,

	//////////////////////////////////////////////////////////////////////////
	cmxCOM_STATE_INVALID	// Used for enumerated type range checking
} cmxCOM_STATES;


// -------------------------------------------------------------------
// Types of Motion State(using to StSxReadMotionState, StIxReadMotionState)
// -------------------------------------------------------------------
typedef enum
{
	cmxMST_STOP		=			0,
	cmxMST_IN_ACC	=			1,
	cmxMST_IN_WORKSPD=			2,
	cmxMST_IN_DEC	=			3,
	cmxMST_IN_INISPD	=		4,
	cmxMST_IN_WAIT	=			5,
	
	//////////////////////////////////////////////////////////////////////////
	cmxMST_IN_INVALID				// Used for enumerated type range checking
} cmxMotionState;

// -------------------------------------------------------------------
// Types of Linear Operation Direction (using to SxVMoveStart, MxVMoveStart)
// -------------------------------------------------------------------
typedef enum
{
	cmxDIR_N			=			0,
	cmxDIR_P			=			1,

	//////////////////////////////////////////////////////////////////////////
	cmxDIR_INVALID					// Used for enumerated type range checking
} cmxDir;

// Counter name //
typedef enum { 
	cmxCNT_COMM = 0, /*Command*/
	cmxCNT_FEED,		/*Feedback*/
	cmxCNT_DEV,		/*Deviation*/
	cmxCNT_GEN,		/*General*/ 

	//////////////////////////////////////////////////////////////////////////
	cmxCNT_INVALID					// Used for enumerated type range checking
}cmxCmCntr;

// Encoder Mode//
typedef enum {
	cmxENC_ABS,
	cmxENC_INC
}cmxCmEncoderMode;

// Control Mode//
typedef enum {
	cmxCTRL_POS,
	cmxCTRL_VEL,
	cmxCTRL_TOR
}cmxCmControlMode;

// -------------------------------------------------------------------
// Types of Machine I/O Property ID (using to CfgSetMioProperty, CfgGetMioProperty)
// -------------------------------------------------------------------
typedef enum
{
	cmxMIO_PEL_LOGIC =			0,	// Property Val [ cmxLOGIC_A    | cmxLOGIC_B ] (Default : cmxLOGIC_A)
	cmxMIO_NEL_LOGIC =			1,	// Property Val [ cmxLOGIC_A    | cmxLOGIC_B ] (Default : cmxLOGIC_A)
	cmxMIO_ORG_LOGIC =			2,	// Property Val [ cmxLOGIC_A    | cmxLOGIC_B ] (Default : cmxLOGIC_A)
	cmxMIO_EL_MODE	=			3,	// Property Val [ 0 : Emg Stop | 1 : Stop  ] (Default : Emg Stop )
	cmxMIO_INP_EN	=			4,	// Property Val [ 0 : INP[D]   | 1 : INP[E]] (Default : INP[D]   )
	cmxMIO_CFSYNC_EN = 			5,	// Property Val [ 0 : Disable  | 1 : Enable] (Default : Disable  )
	cmxMIO_SVON_MODE =			6,	
	cmxMIO_VELCTRL_MODE =		7,	// Property Val [ 0 : Position Control Mode  | 1 : Velocity Control Mode  (Default : Position Control Mode ) 
	cmxMIO_VELCTRL_MAXRPM =		8,	///<ӵ     ִ RPM
	cmxMIO_VELCTRL_PPR =		9,	///<ӵ     ȸ  ޽ 
	cmxMIO_SWL_MODE	=			10,	// Property Val [ 0 : Emg Stop | 1 : Stop  ] (Default : Emg Stop )
	
	/////////////////////////////////////////////////////////////////////
	cmxMIO_INVALID					// Used for enumerated type range checking
} cmxMIOID;

// -------------------------------------------------------------------
// Types of Machine I/O Property Value (using to CfgSetMioProperty, CfgGetMioProperty)
// -------------------------------------------------------------------
typedef enum
{
	cmxLOGIC_A		=			0,
	cmxLOGIC_B		=			1,
	
	//////////////////////////////////////////////////////////////////////////
	cmxLOGIC_INVALID					// Used for enumerated type range checking
} cmxMIOVALUE;

// -------------------------------------------------------------------
// Types of Speed Mode Value (using to CfgSetSpeedPattern, CfgGetSpeedPattern)
// -------------------------------------------------------------------
typedef enum
{
	cmxSPEED_CONSTANT	=		0,
	cmxSPEED_TRAPEZOIDAL	=		1,
	cmxSPEED_SCURVE		=		2,

	//////////////////////////////////////////////////////////////////////////
	cmxSPEED_INVALID					// Used for enumerated type range checking
} cmxVMode;

// -------------------------------------------------------------------
// Types of Backlash/Slip Correction Mode Value (using to SxSetCorrection, SxGetCorrection)
// -------------------------------------------------------------------
typedef enum
{
	cmxCORR_DISABLE		=		0,
	cmxCORR_BACKLASH		=		1,
	cmxCORR_SLIP			=		2,

	//////////////////////////////////////////////////////////////////////////
	cmxCORR_INVALID					// Used for enumerated type range checking
} cmxCorrMode;

// -------------------------------------------------------------------
// Types of Machine I/O State Bit Index (using to StReadMioStatuses)
// -------------------------------------------------------------------
typedef enum
{
	cmxIOST_INP			=		0,
	cmxIOST_RESERVED_00		=		1,
	cmxIOST_HOMECOMPLETED		=		2,
	cmxIOST_TORQUELIMITED		=		3,
	cmxIOST_WARNING			=		4,
	cmxIOST_ALARM			=		5,
	cmxIOST_SVRDY			=		6,
	cmxIOST_SVON			=		7,
	cmxIOST_ELN			=		8,
	cmxIOST_ELP			=		9,
	cmxIOST_ORG			=		10,
	cmxIOST_EX_IN1			=		11,
	cmxIOST_EX_IN2			=		12,
	cmxIOST_EX_IN3			=		13,
	cmxIOST_EX_IN4			=		14,
	cmxIOST_EMG_STP			=		15,
	cmxIOST_RESERVED_01		=		16,
	cmxIOST_RESERVED_02		=		20,
	cmxIOST_ZSPD			=		28,
	cmxIOST_DEN			=		29,
	cmxIOST_BREAKON			=		30,
	cmxIOST_ZPOINT			=		31,


	/////////////////////////////////////////////////////////////////////////
	cmxIOST_INVALID					// Used for enumerated type range checking
} cmxIoST;

// -------------------------------------------------------------------
// Types of Interpolation Map Index (using to IxMapAxes, IxUnMapAxes, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmxIX_MAP0			=		0,
	cmxIX_MAP1			=		1,
	cmxIX_MAP2			=		2,
	cmxIX_MAP3			=		3,
	cmxIX_MAP4			=		4,
	cmxIX_MAP5			=		5,
	cmxIX_MAP6			=		6,
	cmxIX_MAP7			=		7,
	cmxIX_MAP8			=		8,
	cmxIX_MAP9			=		9,
	cmxIX_MAP10			=		10,
	cmxIX_MAP11			=		11,
	cmxIX_MAP12			=		12,
	cmxIX_MAP13			=		13,
	cmxIX_MAP14			=		14,
	cmxIX_MAP15			=		15,
	//////////////////////////////////////////////////////////////////////////
	cmxIX_MAP_INVALID	=       LX520_MAX_SUPPORT_INTERPOLATION_MOTION	// Used for enumerated type range checking
} cmxixMAP;

// -------------------------------------------------------------------
// Types of interpolation mode(using to IxMapAxes)
// -------------------------------------------------------------------
typedef enum 
{
	cmxIX_MODE_LINEAR		= 0,
	cmxIX_MODE_CIRCULAR	= 1,
	cmxIX_MODE_HELICARL	= 2,
	cmxIX_MODE_SPLINE		= 3,
		
	//////////////////////////////////////////////////////////////////////////
	cmxIX_MODE_INVALID					// Used for enumerated type range checking
} cmxixMODE;

// -------------------------------------------------------------------
// Types of interpolation mode(using to ArcA, ArcP)
// -------------------------------------------------------------------
typedef enum
{
	cmxARC_CW		= 0,
	cmxARC_CCW		= 1,

	//////////////////////////////////////////////////////////////////////////
	cmxARC_INVALID					// Used for enumerated type range checking
} cmxixARC_DIR;

// -------------------------------------------------------------------
// Types of return to home mode(using to HomeSetConfig, HomeGetConfig)
// -------------------------------------------------------------------
typedef enum
{
	cmxHOME_MODE0	= 0,
	cmxHOME_MODE1	= 1,
	cmxHOME_MODE2	= 2,
	cmxHOME_MODE3	= 3,
	cmxHOME_MODE4	= 4,

	//////////////////////////////////////////////////////////////////////////
	cmxHOME_MODE_INVALID				// Used for enumerated type range checking
} cmxhmMODE;

// -------------------------------------------------------------------
// Types of return to home position clear mode (using to HomeSetPosClrMode, HomeGetPosClrMode)
// -------------------------------------------------------------------
typedef enum
{
	cmxHPCM_M0		= 0,
	cmxHPCM_M1		= 1,
	cmxHPCM_M2		= 2,
	cmxHPCM_KEEP		= 3,

	//////////////////////////////////////////////////////////////////////////
	cmxHPCM_MODE_INVALID				// Used for enumerated type range checking
} cmxhpcMODE;

// -------------------------------------------------------------------
// Types of Listed Motion Map Index (using to LmStart, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmxLM_MAP0			=		0,
	cmxLM_MAP1			=		1,
	cmxLM_MAP2			=		2,
	cmxLM_MAP3			=		3,
	cmxLM_MAP4			=		4,
	cmxLM_MAP5			=		5,
	cmxLM_MAP6			=		6,
	cmxLM_MAP7			=		7,
	cmxLM_MAP8			=		8,
	cmxLM_MAP9			=		9,
	cmxLM_MAP10			=		10,
	cmxLM_MAP11			=		11,
	cmxLM_MAP12			=		12,
	cmxLM_MAP13			=		13,
	cmxLM_MAP14			=		14,
	cmxLM_MAP15			=		15,
	//////////////////////////////////////////////////////////////////////////
	cmxLM_MAP_INVALID	=		LX520_MAX_SUPPORT_LISTED_MOTION			// Used for enumerated type range checking
} cmxlmMAP;

// -------------------------------------------------------------------
// Types of Listed Motion LmStsId (using to LmxGetStates, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmxLM_STATES_STARTED				= 0,		// Ʈ  ۵Ǿ, TRUE  ȴ.
	cmxLM_STATES_BUSY				= 1,		// Ʈ  ۵Ǿ, ش      TRUE  ȴ.
	cmxLM_STATES_RUN_ITEM_SEQ_ID		= 2,		//   Ʈ   ̵ ȯѴ.
	cmxLM_STATES_NC_BUFFER_STATUS	= 3,		// TRUE : [Buffer FREE], FALSE : [Buffer FULL]
	cmxLM_STATES_FREE_SPACE			= 4,		
	cmxLM_STATES_USED_SPACE			= 5,

	//////////////////////////////////////////////////////////////////////////
	cmxLM_STATES_INVALID				// Used for enumerated type range checking
} cmxLmStsId;

// -------------------------------------------------------------------
// Types of S5 Home operation parameter ID
// -------------------------------------------------------------------
typedef enum
{
		cmxHPID_HOME_MODE				= 0,
		cmxHPID_HOME_DIR					= 1,

		cmxHPID_HOME_OFFSET				= 2,
		cmxHPID_HOME_EZ_COUNT			= 3,
/*
		emHOME_S5_DIRECTION				= 0,		// 
		emHOME_S5_FINAL_DIST			= 1,		// 
		emHOME_S5_FWD_LTC_AREA			= 2,		
		emHOME_S5_RVS_LTC_AREA			= 3,
		emHOME_S5_LTC_SIG_SEL			= 4,
		emHOME_S5_TORQ_LIMIT			= 5,

		emHOME_S5_HOME_MODE				= 6,
*/		
		//////////////////////////////////////////////////////////////////////////
		cmxHPID_INVALID				// Used for enumerated type range checking
} cmxHomeParamId;

// -------------------------------------------------------------------
// Types of Log Mode
// -------------------------------------------------------------------
#define cmxLOG_DISABLE			0
#define cmxLOG_OUTPUTDEBUG		1
#define	cmxLOG_FILE				2
#define cmxLOG_CONSOLE			4
#define LOG_PIPE				8

// -------------------------------------------------------------------
// Types of Reset Configuration(ENVIRONMENT)
// -------------------------------------------------------------------
#define cmxRS_SX_ENV				0x00000001		// Sx Move Environment Restore Factory DEFAULTS
#define cmxRS_IX_ENV				0x00000002		// Ix Move Environment Restore Factory DEFAULTS
#define	cmxRS_LM_ENV				0x00000004		// Lm Move Environment Restore Factory DEFAULTS
#define cmxRS_SPEED_ENV				0x00000008		// Speed Configuration Environment Restore Factory DEFAULTS
#define cmxRS_HOME_ENV				0x00000010		// Hm Move Environment Restore Factory DEFAULTS
#define cmxRS_POS_ENV				0x00000020		// Position Environment Restore Factory DEFAULTS
#define cmxRS_BACKLASH_ENV			0x00000040		// Backlash Configuration Restore Factory Default
#define cmxRS_SWLIMIT_ENV			0x00000080		// S/W Limit Configuration Restore Factory Default
#define cmxRS_UPDATE_INTERVAL_ENV	0x00000040		// Update Interval Restore Factory DEFAULTS	(1msec)
#define cmxALL_RESET			cmxRS_SX_ENV | cmxRS_IX_ENV | cmxRS_LM_ENV | cmxRS_SPEED_ENV | cmxRS_HOME_ENV | cmxRS_POS_ENV | cmxRS_BACKLASH_ENV | cmxRS_SWLIMIT_ENV | cmxRS_UPDATE_INTERVAL_ENV


// -------------------------------------------------------------------
// Types of Log Level
// -------------------------------------------------------------------

// Log Include (Must log always)												: cmxLL_INCLUDE  -1
// No logging at all                                    : cmxLL_NONE	    0
// Log if Error occured in Function                     : cmxLL_ERROR		1
// Log only Command Functions                           : cmxLL_CMD			2
// Log Except Status (GetMotionStatus, etc)	            : cmxLL_STATUS		3
// Log ALL Functions                                    : cmxLL_ALL			4
// Log Exclude (Must Not log)														: cmxLL_EXCLUDE  5

#define cmxLL_INCLUDE	-1
#define cmxLL_NONE		0
#define cmxLL_ERROR	1
#define cmxLL_CMD		2
#define cmxLL_STATUS	3
#define cmxLL_ALL		4
#define cmxLL_EXCLUDE	5

//#define cmxLL_NONE		0
//#define cmxLL_STATE	1
//#define cmxLL_CLIENTS	1
//#define cmxLL_CONNERR	0
//#define	cmxLL_SOCKERR	4
//#define cmxLL_INTERR	0
//#define	cmxLL_INTWARN	8
//#define cmxLL_INTINFO	9
//#define cmxLL_SOCKINFO	10
//#define cmxLL_ALL		10

// -------------------------------------------------------------------
// Network AMP Mechanical Input/Output Status 
// -------------------------------------------------------------------
typedef union
{
	struct
	{
		unsigned char INP:1;		// [RTEX : INP]
		unsigned char Reserved_00:1;
		unsigned char HC:1;		// [Home Completed]
		unsigned char TL:1;		// [Toque Limited]
		unsigned char WARN:1;		// [SERVO Warning]
		unsigned char ALARM:1;		// [SERVO Alarm]
		unsigned char SVRDY:1;		// [RTEX : SERVO RDY]
		unsigned char SVON:1;		// [Servo On]
		
		unsigned char ELN:1;		// [RTEX : EL-]
		unsigned char ELP:1;		// [RTEX : EL+]
		unsigned char ORG:1;		// [Home Sensor]
		unsigned char EX_IN1:1;		// [RTEX : EX_IN1]
		unsigned char EX_IN2:1;		// [RTEX : EX_IN2]
		unsigned char EX_IN3:1;		// [RTEX : EX_IN3]
		unsigned char EX_IN4:1;		// [RTEX : EX_IN4]
		unsigned char EMG_STP:1;	// [RTEX : EMG_STP]

		unsigned char Reserved_01:4;
		unsigned char Reserved_02:8;
		
		unsigned char Reserved_03:1;
		unsigned char Reserved_04:1;
		unsigned char Reserved_05:1;
		unsigned char Reserved_06:1;
	} b;
	unsigned int v;
} cmxMechnicalIO;

// -------------------------------------------------------------------
// NETIO Module Type
// -------------------------------------------------------------------
typedef enum
{
	cmxMT_DO=0,	// DO
	cmxMT_DI,   	// DI
	cmxMT_DIO,	// DIO
	cmxMT_AI,	// AI
	cmxMT_AO,	// AO
	cmxMT_PM,	// Pulse Motion
	cmxMT_NONE	// None
}cmxNetioModuleType;

// -------------------------------------------------------------------
// Slave Type
// -------------------------------------------------------------------

typedef enum
{
	cmxST_SERVO=0,	// NETWORK SERVO
	cmxST_IO,		// NETIO
	cmxST_NONE		// NONE
}cmxSlaveType;



// -------------------------------------------------------------------
// Definition for NETIO
// -------------------------------------------------------------------

// Motion I/O Property ID //
// MIO Property ID //
typedef enum _cmxPmMioPropId{
	cmxPM_ALM_LOGIC, cmxPM_ALM_MODE, cmxPM_CMP_LOGIC, cmxPM_DR_LOGIC, cmxPM_EL_LOGIC, cmxPM_EL_MODE, 
	cmxPM_ERC_LOGIC, cmxPM_ERC_OUT, cmxPM_EZ_LOGIC, cmxPM_INP_EN, cmxPM_INP_LOGIC, cmxPM_LTC_LOGIC, 
	cmxPM_LTC_LTC2SRC, cmxPM_ORG_LOGIC, cmxPM_SD_EN, cmxPM_SD_LOGIC, cmxPM_SD_LATCH, cmxPM_SD_MODE, cmxPM_STA_MODE,
	cmxPM_STA_TRG, cmxPM_STP_MODE, cmxPM_CLR_CNTR, cmxPM_CLR_SIGTYPE, cmxPM_CMP_PWIDTH, cmxPM_ERC_ONTIME, cmxPM_SVON_LOGIC,
}cmxPmMioPropId;

typedef enum _cmxPmMioPropIdEx{
	cmxPM_MPID_ALM_LOGIC,	cmxPM_MPID_ALM_MODE,	cmxPM_MPID_CMP_LOGIC,	cmxPM_MPID_DR_LOGIC,	cmxPM_MPID_EL_LOGIC,	cmxPM_MPID_EL_MODE, 
	cmxPM_MPID_ERC_LOGIC,	cmxPM_MPID_ERC_OUT,		cmxPM_MPID_EZ_LOGIC,	cmxPM_MPID_INP_EN,		cmxPM_MPID_INP_LOGIC,	cmxPM_MPID_LTC_LOGIC, 
	cmxPM_MPID_LTC_LTC2SRC,	cmxPM_MPID_ORG_LOGIC,	cmxPM_MPID_SD_EN,		cmxPM_MPID_SD_LOGIC,	cmxPM_MPID_SD_LATCH,	cmxPM_MPID_SD_MODE, 
	cmxPM_MPID_STA_MODE,	cmxPM_MPID_STA_TRG,		cmxPM_MPID_STP_MODE,	cmxPM_MPID_CLR_CNTR,	cmxPM_MPID_CLR_SIGTYPE,	cmxPM_MPID_CMP_PWIDTH, 
	cmxPM_MPID_ERC_ONTIME,	cmxPM_MPID_SVON_LOGIC,	cmxPM_MPID_ERC_OUT_EL,	cmxPM_MPID_CNT_D_SRC,	cmxPM_MPID_CNT_G_SRC,	cmxPM_MPID_LTC_TRGMODE,
	cmxPM_MPID_SLIM_EN=100,	cmxPM_MPID_OUT_MODE,	cmxPM_MPID_IN_MODE,		cmxPM_MPID_IN_INV,		cmxPM_MPID_cmxPM_G_EN
}cmxPmMioPropIdEx;

// Bit order of StReadMioStatuses() return value  //
typedef enum _cmxPmMioState{
	cmxPM_IOST_RDY, cmxPM_IOST_ALM,	  cmxPM_IOST_ELN,  cmxPM_IOST_ELP, cmxPM_IOST_ORG, 
	cmxPM_IOST_DIR, cmxPM_IOST_EZ,	  cmxPM_IOST_LTC,  cmxPM_IOST_SD,  cmxPM_IOST_INP, 
	cmxPM_IOST_DRN, cmxPM_IOST_DRP,	  cmxPM_IOST_STA,  cmxPM_IOST_STP, cmxPM_IOST_ALMR,
	cmxPM_IOST_EMG, cmxPM_IOST_SVON
}cmxPmMioState;

// Motion operation status ID //
typedef enum _cmxPmMotionState{ 
	cmxPM_MST_STOP,			cmxPM_MST_WAIT_DR,	cmxPM_MST_WAIT_STA,		cmxPM_MST_WAIT_INSYNC,	cmxPM_MST_WAIT_OTHER, 
	cmxPM_MST_WAIT_ERC,		cmxPM_MST_WAIT_DIR, cmxPM_MST_RESERVED1,	cmxPM_MST_WAIT_PLSR,	cmxPM_MST_IN_RVSSPD, 
	cmxPM_MST_IN_INISPD,		cmxPM_MST_IN_ACC,	cmxPM_MST_IN_WORKSPD,	cmxPM_MST_IN_DEC,		cmxPM_MST_WAIT_INP, 
	cmxPM_MST_ERROR,			cmxPM_MST_HOMMING,
}cmxPmMotionState;

// Signal logic definition //
typedef enum _cmxPmSigLogic{ 
	cmxPM_LOGIC_A=0 /*Normal open*/, cmxPM_LOGIC_B=1/*Normal close*/ 
}cmxPmSigLogic;

// Axis index definition //
typedef enum _cmxPmAxis{ 
	cmxPM_X1, cmxPM_Y1, cmxPM_Z1, cmxPM_U1, cmxPM_X2, cmxPM_Y2, cmxPM_Z2, cmxPM_U2 
}cmxPmAxis;

// Definition for axes mask  //
typedef enum _cmxPmAxisMask{ 
	cmxPM_X1_MASK=0x1, cmxPM_Y1_MASK=0x2, cmxPM_Z1_MASK=0x4, cmxPM_U1_MASK=0x8,
	cmxPM_X2_MASK=0x10, cmxPM_Y2_MASK=0x20, cmxPM_Z2_MASK=0x40, cmxPM_U2_MASK=0x80
}cmxPmAxisMask;

// Encoder and PA/PB input mode definition //
typedef enum _cmxPmInMode{ 
	cmxPM_IMODE_AB1X, cmxPM_IMODE_AB2X, cmxPM_IMODE_AB4X, cmxPM_IMODE_CWCCW, cmxPM_IMODE_STEP
}cmxPmInMode;

// Command output mode definition //
typedef enum _cmxPmOutMode{ 
	cmxPM_OMODE_PDIR0, cmxPM_OMODE_PDIR1, cmxPM_OMODE_PDIR2, cmxPM_OMODE_PDIR3,
	cmxPM_OMODE_CWCCW0, cmxPM_OMODE_CWCCW1, cmxPM_OMODE_CCWCW0, cmxPM_OMODE_CCWCW1
}cmxPmOutMode;

// Control Mode //
typedef enum _cmxPmCtrlMode{ 
	cmxPM_CTRL_OPEN, // Open loop control mode
	cmxPM_CTRL_SEMI_C, // Semi-closed loop control mode (applied only to absolute in-position commands)
	cmxPM_CTRL_FULL_C // Full-closed loop control mode (this is not supported at current version)
}cmxPmCtrlMode;

// (Linear)Operation direction //	
typedef enum _cmxPmDir{
	cmxPM_DIR_N /*(-)Dir*/, cmxPM_DIR_P /*(+)Dir*/
}cmxPmDir;

// Counter name //
typedef enum _cmxPmCntr { 
	cmxPM_CNT_COMM/*Command*/, cmxPM_CNT_FEED/*Feedback*/, cmxPM_CNT_DEV/*Deviation*/, 
	cmxPM_CNT_GEN/*General*/, cmxPM_CNT_REM/*Remained*/
}cmxPmCntr;

// Speed mode index definition //	
typedef enum _cmxPmSpeedMode{ 
	cmxPM_SMODE_KEEP=-1/* Keep previous setting*/, cmxPM_SMODE_C=0 /*Constant */, cmxPM_SMODE_T /*Trapeziodal*/, cmxPM_SMODE_S /*S-curve*/
}cmxPmSpeedMode;

// Arc operation direction //
typedef enum _cmxPmArcDir{ 
	cmxPM_ARC_CW, cmxPM_ARC_CCW
}cmxPmArcDir;

// Compare Method //
typedef enum _cmxPmCmpMethod{
	cmxPM_DISABLE, cmxPM_EQ_BIDIR, cmxPM_EQ_PDIR, cmxPM_EQ_NDIR, cmxPM_LESS/*Cnt<Data*/, cmxPM_GREATER/*Cnt>Data*/
}cmxPmCmpMethod;

// Action when general comparator met the condition //
typedef enum _cmxPmCmpAction{
	cmxPM_EVNT_ONLY, cmxPM_EVNT_IS, cmxPM_EVNT_DS, cmxPM_EVNT_SPDCHG
}cmxPmCmpAction;

// Backlash/Slip correction mode //
typedef enum _cmxPmCorrMode{
	cmxPM_CORR_DIS, // Disable correction 
	cmxPM_CORR_BACK, // Backlash correction mode 
	cmxPM_CORR_SLIP // Slip correction mode
}cmxPmCorrMode;

// Using for preregister option
typedef enum _cmxPmExtOptionId{
	cmxPM_EXOPT_SET_USE_PREREG
}cmxPmExtOptionId;

// Interrupt Handler Type //
typedef enum _cmxPmIntHandlerType{
	cmxPM_IHT_MESSAGE=0, cmxPM_IHT_EVENT, cmxPM_IHT_CALLBACK
}cmxPmIntHandlerType;

// Interrupt Handler Type //
typedef enum _cmxPmStringID{
	cmxPM_STR_AXIS_NAME, cmxPM_STR_DIST_UNIT, cmxPM_STR_SPEED_UNIT
}cmxPmStringID;

// Sequence Mode //
typedef enum _cmxPmSeqMode{
	cmxPM_SEQM_SKIP_RUN, cmxPM_SEQM_WAIT_RUN
}cmxPmSeqMode;

// Map Type //
typedef enum _cmxPmDevMapType{
	cmxPM_DMAP_MOTION, cmxPM_DMAP_DIO, cmxPM_DMAP_ALL
}cmxPmDevMapType;

// SetFilterAB  //
typedef enum _cmxPmABFilter{
	cmxPM_AB_ENC, cmxPM_AB_PULSAR
}cmxPmABFilter;

// Axis Capability ID //
typedef enum _cmxPmAxisCapID{
	cmxPM_CAPX_CMD_DIR=0, /* Command direction change function */
	cmxPM_CAPX_EL_MAN_SET, /* -/+EL Manual control function */
	cmxPM_CAPX_CMP_HIGH /* High-speed Compare Output function */
}cmxPmAxisCapID;

// Axis Return to home clear mode //
typedef enum _cmxPmHomePosClrMode{
	cmxPM_HPCM_DISABLE=-1, // Disable HomePosClearMode
	cmxPM_HPCM_M0, // ORG(/EL/EZ) ȣ ߻  COMMAND & FEEDBACK ġ 0 ŬѴ.
	cmxPM_HPCM_M1, // ͸  Ϸϰ  COMMAND & FEEDBACK ġ  0 ŬѴ.
	cmxPM_HPCM_M2  // ͸  Ϸϰ  FEEDBACK ġ ״ ΰ COMMAND ġ FEEDBACK ġ ġŲ.
}cmxPmHomePosClrMode;

typedef enum _cmxPmLatchTrgMode{
	cmxPM_LTM_LTC, // LTC Է ȣ ؼ  ġ ˴ϴ.
	cmxPM_LTM_ORG  // ORG Է ȣ ؼ  ġ ˴ϴ.
}cmxPmLatchTrgMode;

// Sync mode //
typedef enum _cmxPmSyncMode{
	cmxPM_SYNC_DISABLE,
	cmxPM_SYNC_INT_SYNC,
	cmxPM_SYNC_OTHER_STOP
}cmxPmSyncMode;

// Internal sync. conditions //
typedef enum _cmxPmIntSyncCond{
	cmxPM_ISYNC_ACC_STA, // 0: at start of acceleration
	cmxPM_ISYNC_ACC_END, // 1: at end of acceleration
	cmxPM_ISYNC_DEC_STA, // 2: at start of deceleration
	cmxPM_ISYNC_DEC_END, // 3: at end of deceleration
	cmxPM_ISYNC_SLN, // 4: when (-)software limit met
	cmxPM_ISYNC_SLP, // 5: when (+)software limit met
	cmxPM_ISYNC_GCMP, // 6: when General Comparator condition is satisfied
	cmxPM_ISYNC_TCMP // 7: when Trigger Comparator condition is satisfied
}cmxPmIntSyncCond;

// DIO Mode //
typedef enum _cmxDioMode{
	cmxDIOMODE_IN /*Input Mode*/, cmxDIOMODE_OUT /*Output Mode*/
}cmxDioMode;            


// -------------------------------------------------------------------
// Slave Info
// -------------------------------------------------------------------
typedef struct{
	unsigned short	ModuleType[LX520_MAX_MODULE_IN_SLAVE];	// Connected module type. (cmxModuleType)
	unsigned short	nNumModule;							// Connected module's number.
	unsigned short	nSlaveType;							// Slave Mode (cmxSlaveType)
}cmxSlaveInfo;

// -------------------------------------------------------------------
// Definition of Real Time Status update Structure
// -------------------------------------------------------------------

typedef struct
{
	struct
	{
		unsigned int AxisMask; //  Ʈ   RTS ĵ Ȱȭ  
		struct
		{
			struct
			{
				unsigned int INP: 1;		// [RTEX : INP]
				unsigned int Reserved_00: 1;
				unsigned int HC:1;		// [Home Completed]
				unsigned int TL:1;		// [Toque Limited]
				unsigned int WARN:1;		// [SERVO Warning]
				unsigned int ALARM:1;		// [SERVO Alarm]
				unsigned int SVRDY:1;		// [RTEX : SERVO RDY]
				unsigned int SVON:1;		// [Servo On]
				
				unsigned int ELN:1;		// [RTEX : EL-]
				unsigned int ELP:1;		// [RTEX : EL+]
				unsigned int ORG:1;		// [Home Sensor]
				unsigned int EX_IN1:1;		// [RTEX : EX_IN1]
				unsigned int EX_IN2:1;		// [RTEX : EX_IN2]
				unsigned int EX_IN3:1;		// [RTEX : EX_IN3]
				unsigned int EX_IN4:1;		// [RTEX : EX_IN4]
				unsigned int EMG_STP:1;		// [RTEX : EMG_STP]
							
				unsigned int Reserved_01:1;
				unsigned int Reserved_02:1;
				unsigned int Reserved_03:1;
				unsigned int Reserved_04:1;

				unsigned int Reserved_05: 4;
				unsigned int Reserved_06: 8;
				
			}DW0;

			struct
			{
				unsigned int Torq: 7;	
				unsigned int FieldMode: 1;
				unsigned int Mst: 4;	
				unsigned int MMode: 4;	
				int  LastError: 8;
				unsigned int Reserved;
			}DW1;

			int CmdCnt;
			int FeedCnt;
			int CmdVel;
			int FeedVel;			
		}Axis[32];
	}NM;

	struct
	{
		unsigned int NodeMask;
		struct
		{
			// DIO
			unsigned int DI0:1;
			unsigned int DI1:1;
			unsigned int DI2:1;
			unsigned int DO0:1;
			unsigned int DO1:1;
			unsigned int DO2:1;

			struct
			{
				struct  
				{
					// Motion Stat.
					unsigned int MOT:4;
					
					// Servo On/Off
					unsigned int SVON:1;
					
					// Motion IO
					unsigned int SVRDY:1;
					unsigned int ALM:1;
					unsigned int ELM:1;
					unsigned int ELP:1;
					unsigned int ORG:1;
					unsigned int DIR:1;
					unsigned int EZ:1;
					unsigned int LTC:1;

					unsigned int SD:1;
					unsigned int INP:1;
					unsigned int DRN:1;
					unsigned int DRP:1;
					unsigned int STA:1;
					unsigned int STP:1;
					unsigned int ALMR:1;
					unsigned int EMG:1;

					int CmdCnt;
					int FeedCnt;
					int CmdVel;
				} Axis[2];
			}Module[9];
		}Node[32];
	}PM;

	struct
	{
		unsigned int NodeMask;
		struct
		{
			unsigned int Di[9];
			unsigned int Do[9];
			unsigned int Dio[9];
		}Node[32];
	}IO;
} cmxRtsData;

// -------------------------------------------------------------------
// Types of SDK(Software Development Kit) Error Codes
// -------------------------------------------------------------------

// The Winerror.h file contains a listing of static error codes used throughout Microsoft Windows operating system products
#include "winerror.h"

#define cmxERR_NONE						0
#define cmxERR_INVALID_BUFFER			-1	// Invalid Buffer range
#define cmxERR_AXIS_MOT_QUEUE_FULL		-2	// Listed Queue Full
#define cmxERR_CALLWDM_ERROR			-3 // WDM ̹  ȯ   
#define cmxERR_IMD_REPLY_FAIL			-5	// Immediately Reply Fail
#define cmxERR_IMD_QUEUE_FULL			-6	// Immediately Queue Full

#define cmxERR_NOT_ENOUGH_MEMORY		-8	// Not Enough memory.
#define cmxERR_INVALID_PARAMETER		-10	// Some of the function parameters are invalid
#define cmxERR_INVALID_AXIS				-11	// The axis setting parameter(s) is (are) invalid
#define cmxERR_INVALID_SPEED_SET		-12	// Speed setting value is not valid

#define cmxERR_INVALID_IXMAP			-13	// Invalid Interpolation Map
#define cmxERR_INVALID_LMMAP			-14	// Invalid Listed-Motion Map
#define cmxERR_INVALID_NUMAXIS			-15	// Invalid number of axis(Mx)
	
#define cmxERR_STOP_BY_SLP				-50	// Abnormally stopped by positive soft limit
#define cmxERR_STOP_BY_SLN				-51	// Abnormally stopped by negative soft limit
#define cmxERR_STOP_BY_EPL				-52	// Abnormally stopped by (-) external limit
#define cmxERR_STOP_BY_ELN				-53	// Abnormally stopped by (+) external limit
#define cmxERR_STOP_BY_ALM				-54	// Abnormally stopped by alarm input signal
#define cmxERR_STOP_BY_CER				-55	// Abnormally stopped by communication error between NC and Slave nodes

#define cmxERR_MOT_SEQ_SKIPPED			-60	// Motion Command has been skipped because the axis is already running
#define cmxERR_SKIP_BY_ALM				-61	// Motion Command has been skipped by ALM signal.
#define cmxERR_SKIP_BY_SERVO_OFF		-62	// Motion Command has been skipped by the ServoPack state is OFF.
#define cmxERR_FAILED_COMMAND_SERVO_ON	-63	// Motion Command ServoOn has been failed in retry command.
#define cmxERR_FAILED_COMMAND_SERVO_OFF	-64	// Motion Command ServoOff has been failed in retry command.

#define cmxERR_FAILED_TORQUE_LIMIT_MODE	-65

#define cmxERR_SKIP_BY_SEMG					-71	// Motion Command has been skipped by software emergency.

#define cmxERR_SLAVE_MODULE_INDEX			-77	// Slave module Index is invalid.
#define cmxERR_SLAVE_LOCAL_CHANNEL			-78	// Local Channel is out of range.
#define cmxERR_SLAVE_TYPE_IS_NOT_NIO		-79	// Command Axis type is not Network-IO module.
#define cmxERR_INVALID_LIBPARAM				-87 // Library Command Parameter is Invalid.
#define cmxERR_DIO_INVALID_LOC_CHAN			-90	// DIO Local channel is invalid.
#define cmxERR_DIO_MODULE_ID_FAILED			-91	// DO Module Id is less then 0.
#define cmxERR_DIO_MODULE_IS_NOT_DIO_OR_DO	-92	// Module is not output type.
#define cmxERR_DIO_CHANNLE_IS_INCORRECT		-93	// Channel no. is overflow.
#define cmxERR_DIO_RTDO_BUF_IS_NULL			-94 // RTDO Buf Allocation failed.
#define cmxERR_DIO_OUTPUT_IS_FAILED			-95 // Output DO but Channel state is not same as command state.
#define cmxERR_DEVICE_NOT_FOUND				-1168	// Device is not detected.
#define cmxERR_DEVICE_NOT_AVAILABLE			-4319	// Device is not available.

#endif
