/*******************************************************************************
* [ ComiSSCNET3_SDK_Def.h ]
* Header file for definitions of constants and data in SSCNET-3 library
* - Update Data: 2016/06/04
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#ifndef __COMI_SSCNET3_SDK_DEF_H__
#define __COMI_SSCNET3_SDK_DEF_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// -------------------------------------------------------------------
// Declare Const Values in SSCNET-3 Library
// -------------------------------------------------------------------
#define LX540_MAX_SUPPORT_MASTER_BOARDS				16
#define LX540_MAX_SUPPORT_SLAVE_AXES				32
#define LX540_MAX_SUPPORT_INTERPOLATION_MOTION		16
#define LX540_MAX_SUPPORT_LISTED_MOTION				16
#define LX540_MAX_SUPPORT_LISTED_MOTION_USER_PARAM	4
#define LX540_MAX_MODULE_IN_SLAVE					9
#define LX540_MAX_SUPPORT_IN_NODE_AXES				2

#ifndef MAX_NUM_PLATFORM
#define MAX_NUM_PLATFORM	5   // RTEX, MLINK3, SSCNET3, MLINK2, SSCNET3/H
#endif

#ifndef MAX_NUM_FUNC
#define MAX_NUM_FUNC		600
#endif

#ifndef FLASH_SECTOR_LEN
#define FLASH_SECTOR_LEN	35
#endif
// -------------------------------------------------------------------
// General Type
// -------------------------------------------------------------------
#ifndef	TRUE
#define TRUE	1
#endif

#ifndef	FALSE
#define FALSE	0
#endif

// -------------------------------------------------------------------
// General BOOLEAN Type Definition
// -------------------------------------------------------------------
typedef enum
{
	cmsFALSE		= 0,
	cmsTRUE			= 1,
	
	//////////////////////////////////////////////////////////////////////////
	cmsBOOLEAN_INVALID		// Used for enumerated type range checking
} cmsBOOLEAN;

// -------------------------------------------------------------------
// Type of  COM State Id (using to GnSetCommStates, GnGetCommStates)
// -------------------------------------------------------------------
typedef enum
{
	cmsCSID_COM_STATES	=	0,
	cmsCSID_RTS_COUNT	=	1,
	cmsCSID_CMD_COUNT	=	2,
	cmsCSID_COM_RST		=	3,	// Only 'Set' Support

	//////////////////////////////////////////////////////////////////////////
	cmsCSID_INVALID				// Used for enumerated type range checking
} cmsCommStates;

// -------------------------------------------------------------------
// Types of [emCOM_STATES] 'States' (using to GnSetCommStates, GnGetCommStates)
// -------------------------------------------------------------------
typedef enum
{
	cmsCOM_STATE_RESET		= -1,
	cmsCOM_STATE_INIT		= 0,
	cmsCOM_STATE_WAITING	= 1,
	cmsCOM_STATE_PREPARE	= 2,
	cmsCOM_STATE_START		= 3,
	cmsCOM_STATE_RUNNING	= 4,

	//////////////////////////////////////////////////////////////////////////
	cmsCOM_STATE_INVALID	// Used for enumerated type range checking
} cmsCOM_STATES;


// -------------------------------------------------------------------
// Types of Motion State(using to StSxReadMotionState, StIxReadMotionState)
// -------------------------------------------------------------------
typedef enum
{
	cmsMST_STOP			=			0,	///<
	cmsMST_IN_ACC		=			1,	///<
	cmsMST_IN_WORKSPD	=			2,	///<۾ӵ
	cmsMST_IN_DEC		=			3,	///<
	cmsMST_IN_INISPD	=			4,	///<ʱӵ
	cmsMST_IN_WAIT_INP	=			5,	///<INP(CMD ϷǾ  FEED INP_RANGE ȿ   )
	cmsMST_IN_SYNC		=			6,	///<Master/Slave 
	cmsMST_IN_HOME_IDLE	=			10,  ///<Homing߿  Stop ϶( ٲٴ  ) 
	cmsMST_IN_WAIT		=			14,	///< ϴ޵Ǿ  ø    .
	cmsMST_UNKNOWN		=			15,	///<Unknown

	//////////////////////////////////////////////////////////////////////////
	cmsMST_IN_INVALID				// Used for enumerated type range checking
} cmsMotionState;

// -------------------------------------------------------------------
// Types of Linear Operation Direction (using to SxVMoveStart, MxVMoveStart)
// -------------------------------------------------------------------
typedef enum
{
	cmsDIR_N			=			0,
	cmsDIR_P			=			1,

	//////////////////////////////////////////////////////////////////////////
	cmsDIR_INVALID					// Used for enumerated type range checking
} cmsDir;

// Counter name //
typedef enum { 
	cmsCNT_COMM = 0, /*Command*/
	cmsCNT_FEED,		/*Feedback*/
	cmsCNT_DEV,		/*Deviation*/
	cmsCNT_GEN,		/*General*/ 

	//////////////////////////////////////////////////////////////////////////
	cmsCNT_INVALID					// Used for enumerated type range checking
}cmsCmCntr;

// Encoder Mode//
typedef enum {
	cmsENC_ABS,
	cmsENC_INC
}cmsCmEncoderMode;

// Control Mode//
typedef enum {
	cmsCTRL_POS,
	cmsCTRL_VEL,
	cmsCTRL_TOR
}cmsCmControlMode;

// -------------------------------------------------------------------
// Types of Machine I/O Property ID (using to CfgSetMioProperty, CfgGetMioProperty)
// -------------------------------------------------------------------
typedef enum
{
	cmsMIO_PEL_LOGIC =			0,	// Property Val [ cmsLOGIC_A    | cmsLOGIC_B ] (Default : cmsLOGIC_A)
	cmsMIO_NEL_LOGIC =			1,	// Property Val [ cmsLOGIC_A    | cmsLOGIC_B ] (Default : cmsLOGIC_A)
	cmsMIO_ORG_LOGIC =			2,	// Property Val [ cmsLOGIC_A    | cmsLOGIC_B ] (Default : cmsLOGIC_A)
	cmsMIO_EL_MODE	=			3,	// Property Val [ 0 : Emg Stop | 1 : Stop  ] (Default : Emg Stop )
	cmsMIO_INP_EN	=			4,	// Property Val [ 0 : INP[D]   | 1 : INP[E]] (Default : INP[D]   )
	cmsMIO_CFSYNC_EN = 			5,	// Property Val [ 0 : Disable  | 1 : Enable] (Default : Disable  )
	cmsMIO_SVON_MODE =			6,	
	cmsMIO_VELCTRL_MODE =		7,	// Property Val [ 0 : Position Control Mode  | 1 : Velocity Control Mode  (Default : Position Control Mode ) 
	cmsMIO_VELCTRL_MAXRPM =		8,	///<ӵ     ִ RPM
	cmsMIO_VELCTRL_PPR =		9,	///<ӵ     ȸ  ޽ 
	cmsMIO_SWL_MODE	=			10,	// Property Val [ 0 : Emg Stop | 1 : Stop  ] (Default : Emg Stop )

	
	/////////////////////////////////////////////////////////////////////
	cmsMIO_INVALID					// Used for enumerated type range checking
} cmsMIOID;

// -------------------------------------------------------------------
// Types of Machine I/O Property Value (using to CfgSetMioProperty, CfgGetMioProperty)
// -------------------------------------------------------------------
typedef enum
{
	cmsLOGIC_A		=			0,
	cmsLOGIC_B		=			1,
	
	//////////////////////////////////////////////////////////////////////////
	cmsLOGIC_INVALID					// Used for enumerated type range checking
} cmsMIOVALUE;

// -------------------------------------------------------------------
// Types of Speed Mode Value (using to CfgSetSpeedPattern, CfgGetSpeedPattern)
// -------------------------------------------------------------------
typedef enum
{
	cmsSPEED_CONSTANT	=		0,
	cmsSPEED_TRAPEZOIDAL	=		1,
	cmsSPEED_SCURVE		=		2,

	//////////////////////////////////////////////////////////////////////////
	cmsSPEED_INVALID					// Used for enumerated type range checking
} cmsVMode;

// -------------------------------------------------------------------
// Types of Backlash/Slip Correction Mode Value (using to SxSetCorrection, SxGetCorrection)
// -------------------------------------------------------------------
typedef enum
{
	cmsCORR_DISABLE		=		0,
	cmsCORR_BACKLASH		=		1,
	cmsCORR_SLIP			=		2,

	//////////////////////////////////////////////////////////////////////////
	cmsCORR_INVALID					// Used for enumerated type range checking
} cmsCorrMode;
// -------------------------------------------------------------------
// Types of Move Mode Value (using to StGetMotionMode)
// -------------------------------------------------------------------
typedef enum
{
	cmsMODE_NONE			=		0,			///<
	cmsMODE_HOME			=		1,			///<
	cmsMODE_IX_LINEAR		=		2,			///<  ̼
	cmsMODE_IX_CIRCULAR		=		3,			///<ȣ  ̼
	cmsMODE_IX_HELICAL		=		4,			///<︮  ̼
	cmsMODE_IX_SPLINE		=		5,			///<ö  ̼
	cmsMODE_SX				=		6,			///< ̼
	cmsMODE_MS				=		7,			///<Master/Slave ̼

	//////////////////////////////////////////////////////////////////////////
	cmsMODE_INVALID					// Used for enumerated type range checking
} cmsMoveMode;

// -------------------------------------------------------------------
// Types of Machine I/O State Bit Index (using to StReadMioStatuses)
// -------------------------------------------------------------------
typedef enum
{
	cmsIOST_INP			=		0,
	cmsIOST_DIR		=		1,
	cmsIOST_HOMECOMPLETED		=		2,
	cmsIOST_TORQUELIMITED		=		3,
	cmsIOST_WARNING			=		4,
	cmsIOST_ALARM			=		5,
	cmsIOST_SVRDY			=		6,
	cmsIOST_SVON			=		7,
	cmsIOST_ELN			=		8,
	cmsIOST_ELP			=		9,
	cmsIOST_ORG			=		10,
	cmsIOST_EX_IN1			=		11,
	cmsIOST_EX_IN2			=		12,
	cmsIOST_EX_IN3			=		13,
	cmsIOST_EX_IN4			=		14,
	cmsIOST_EMG_STP			=		15,
	cmsIOST_AbsHome_Request =		16,
	cmsIOST_RESERVED_01		=		17,
	cmsIOST_RESERVED_02		=		20,
	cmsIOST_ZSPD			=		28,
	cmsIOST_DEN			=		29,
	cmsIOST_BREAKON			=		30,
	cmsIOST_ZPOINT			=		31,


	/////////////////////////////////////////////////////////////////////////
	cmsIOST_INVALID					// Used for enumerated type range checking
} cmsIoST;

// -------------------------------------------------------------------
// Types of Interpolation Map Index (using to IxMapAxes, IxUnMapAxes, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmsIX_MAP0			=		0,
	cmsIX_MAP1			=		1,
	cmsIX_MAP2			=		2,
	cmsIX_MAP3			=		3,
	cmsIX_MAP4			=		4,
	cmsIX_MAP5			=		5,
	cmsIX_MAP6			=		6,
	cmsIX_MAP7			=		7,
	cmsIX_MAP8			=		8,
	cmsIX_MAP9			=		9,
	cmsIX_MAP10			=		10,
	cmsIX_MAP11			=		11,
	cmsIX_MAP12			=		12,
	cmsIX_MAP13			=		13,
	cmsIX_MAP14			=		14,
	cmsIX_MAP15			=		15,
	//////////////////////////////////////////////////////////////////////////
	cmsIX_MAP_INVALID	=       LX540_MAX_SUPPORT_INTERPOLATION_MOTION	// Used for enumerated type range checking
} cmsIxMAP;

// -------------------------------------------------------------------
// Types of interpolation mode(using to IxMapAxes)
// -------------------------------------------------------------------
typedef enum 
{
	cmsIX_MODE_LINEAR		= 0,
	cmsIX_MODE_CIRCULAR	= 1,
	cmsIX_MODE_HELICARL	= 2,
	cmsIX_MODE_SPLINE		= 3,
		
	//////////////////////////////////////////////////////////////////////////
	cmsIX_MODE_INVALID					// Used for enumerated type range checking
} cmsIxMODE;

// -------------------------------------------------------------------
// Types of interpolation mode(using to ArcA, ArcP)
// -------------------------------------------------------------------
typedef enum
{
	cmsARC_CW		= 0,
	cmsARC_CCW		= 1,

	//////////////////////////////////////////////////////////////////////////
	cmsARC_INVALID					// Used for enumerated type range checking
} cmsIxARC_DIR;

// -------------------------------------------------------------------
// Types of return to home mode(using to HomeSetConfig, HomeGetConfig)
// -------------------------------------------------------------------
typedef enum
{
	cmsHOME_MODE0	= 0,
	cmsHOME_MODE1	= 1,
	cmsHOME_MODE2	= 2,
	cmsHOME_MODE3	= 3,
	cmsHOME_MODE4	= 4,

	//////////////////////////////////////////////////////////////////////////
	cmsHOME_MODE_INVALID				// Used for enumerated type range checking
} cmsHmMODE;

// -------------------------------------------------------------------
// Types of return to home position clear mode (using to HomeSetPosClrMode, HomeGetPosClrMode)
// -------------------------------------------------------------------
typedef enum
{
	cmsHPCM_M0		= 0,
	cmsHPCM_M1		= 1,
	cmsHPCM_M2		= 2,
	cmsHPCM_KEEP		= 3,

	//////////////////////////////////////////////////////////////////////////
	cmsHPCM_MODE_INVALID				// Used for enumerated type range checking
} cmsHpcMODE;

// -------------------------------------------------------------------
// Types of Listed Motion Map Index (using to LmStart, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmsLM_MAP0			=		0,
	cmsLM_MAP1			=		1,
	cmsLM_MAP2			=		2,
	cmsLM_MAP3			=		3,
	cmsLM_MAP4			=		4,
	cmsLM_MAP5			=		5,
	cmsLM_MAP6			=		6,
	cmsLM_MAP7			=		7,
	cmsLM_MAP8			=		8,
	cmsLM_MAP9			=		9,
	cmsLM_MAP10			=		10,
	cmsLM_MAP11			=		11,
	cmsLM_MAP12			=		12,
	cmsLM_MAP13			=		13,
	cmsLM_MAP14			=		14,
	cmsLM_MAP15			=		15,
	//////////////////////////////////////////////////////////////////////////
	cmsLM_MAP_INVALID	=		LX540_MAX_SUPPORT_LISTED_MOTION			// Used for enumerated type range checking
} cmslmMAP;

// -------------------------------------------------------------------
// Types of Listed Motion LmStsId (using to LmxGetStates, ...)
// -------------------------------------------------------------------
typedef enum
{
	cmsLM_STATES_STARTED				= 0,		// Ʈ  ۵Ǿ, TRUE  ȴ.
	cmsLM_STATES_BUSY				= 1,		// Ʈ  ۵Ǿ, ش      TRUE  ȴ.
	cmsLM_STATES_RUN_ITEM_SEQ_ID		= 2,		//   Ʈ   ̵ ȯѴ.
	cmsLM_STATES_NC_BUFFER_STATUS	= 3,		// TRUE : [Buffer FREE], FALSE : [Buffer FULL]
	cmsLM_STATES_FREE_SPACE			= 4,		
	cmsLM_STATES_USED_SPACE			= 5,

	//////////////////////////////////////////////////////////////////////////
	cmsLM_STATES_INVALID				// Used for enumerated type range checking
} cmsLmStsId;

// -------------------------------------------------------------------
// Types of S5 Home operation parameter ID
// -------------------------------------------------------------------
typedef enum
{
		cmsHPID_HOME_MODE				= 0,
		cmsHPID_HOME_DIR					= 1,
		cmsHPID_HOME_OFFSET				= 2,
		cmsHPID_HOME_EZ_CNT				= 3,
		
		//////////////////////////////////////////////////////////////////////////
		cmsHPID_INVALID				// Used for enumerated type range checking
} cmsHomeParamId;

typedef enum
{
	cmsHOME_MODE_ORG_ONCE		= 0,
	cmsHOME_MODE_ORG				= 1,
	cmsHOME_MODE_EL				= 3,
	cmsHOME_MODE_EZ_COUNT		= 4,

	/////////////////////////////////////////////////////////////////////////
	cmsHOME_INVALID		= 13	// Used for enumerated type range checking
} cmsHOME_MODE;

typedef enum
{
		cmsHOME_PHASE0				= 0,
		cmsHOME_PHASE1				= 1,
		cmsHOME_PHASE2				= 2,
		
		//////////////////////////////////////////////////////////////////////////
		cmsHOME_PHASE_INVALID				// Used for enumerated type range checking
} cmsHomePhaseId;

// -------------------------------------------------------------------
// Types of Log Mode
// -------------------------------------------------------------------
#define cmsLOG_DISABLE			0
#define cmsLOG_OUTPUTDEBUG		1
#define	cmsLOG_FILE			2
#define cmsLOG_CONSOLE			4
#define cmsLOG_PIPE			8

// -------------------------------------------------------------------
// Types of Reset Configuration(ENVIRONMENT)
// -------------------------------------------------------------------
#define cmsRS_SX_ENV				0x00000001		// Sx Move Environment Restore Factory DEFAULTS
#define cmsRS_IX_ENV				0x00000002		// Ix Move Environment Restore Factory DEFAULTS
#define	cmsRS_LM_ENV				0x00000004		// Lm Move Environment Restore Factory DEFAULTS
#define cmsRS_SPEED_ENV			0x00000008		// Speed Configuration Environment Restore Factory DEFAULTS
#define cmsRS_HOME_ENV				0x00000010		// Hm Move Environment Restore Factory DEFAULTS
#define cmsRS_POS_ENV				0x00000020		// Position Environment Restore Factory DEFAULTS
#define cmsRS_BACKLASH_ENV			0x00000040		// Backlash Configuration Restore Factory Default
#define cmsRS_SWLIMIT_ENV			0x00000080		// S/W Limit Configuration Restore Factory Default
#define cmsRS_UPDATE_INTERVAL_ENV	0x00000040		// Update Interval Restore Factory DEFAULTS	(1msec)
#define cmsALL_RESET			cmsRS_SX_ENV | cmsRS_IX_ENV | cmsRS_LM_ENV | cmsRS_SPEED_ENV | cmsRS_HOME_ENV | cmsRS_POS_ENV | cmsRS_BACKLASH_ENV | cmsRS_SWLIMIT_ENV | cmsRS_UPDATE_INTERVAL_ENV


// -------------------------------------------------------------------
// Types of Log Level
// -------------------------------------------------------------------

// Log Include (Must log always)												: cmsLL_INCLUDE  -1
// No logging at all                                    : cmsLL_NONE	    0
// Log if Error occured in Function                     : cmsLL_ERROR		1
// Log only Command Functions                           : cmsLL_CMD			2
// Log Except Status (GetMotionStatus, etc)	            : cmsLL_STATUS		3
// Log ALL Functions                                    : cmsLL_ALL			4
// Log Exclude (Must Not log)														: cmsLL_EXCLUDE  5

#define cmsLL_INCLUDE	-1
#define cmsLL_NONE		0
#define cmsLL_ERROR	1
#define cmsLL_CMD		2
#define cmsLL_STATUS	3
#define cmsLL_ALL		4
#define cmsLL_EXCLUDE	5

//#define cmsLL_NONE		0
//#define cmsLL_STATE	1
//#define cmsLL_CLIENTS	1
//#define cmsLL_CONNERR	0
//#define	cmsLL_SOCKERR	4
//#define cmsLL_INTERR	0
//#define	cmsLL_INTWARN	8
//#define cmsLL_INTINFO	9
//#define cmsLL_SOCKINFO	10
//#define cmsLL_ALL		10

// -------------------------------------------------------------------
// Network AMP Mechanical Input/Output Status 
// -------------------------------------------------------------------
typedef union
{
	struct
	{
		unsigned char INP:1;		// [YASKAWA : PSET]
		unsigned char DIR:1;		// [Move Direction]
		unsigned char HC:1;			// [Home Completed]
		unsigned char TL:1;			// [Toque Limited]
		unsigned char WARN:1;		// [SERVO Warning]
		unsigned char ALARM:1;		// [SERVO Alarm]
		unsigned char SVRDY:1;		// [YASKAWA : M_RDY]
		unsigned char SVON:1;		// [Servo On]
		
		unsigned char ELN:1;		// [YASKAWA : N_OT]
		unsigned char ELP:1;		// [YASKAWA : P_OT]
		unsigned char ORG:1;		// [Home Sensor]
		unsigned char EX_IN1:1;		// [YASKAWA : EXT1]
		unsigned char EX_IN2:1;		// [YASKAWA : EXT2]
		unsigned char EX_IN3:1;		// [YASKAWA : EXT3]
		unsigned char EX_IN4:1;		// [YASKAWA : DEC]
		unsigned char EMG_STP:1;	// [YASKAWA : ESTP]

		unsigned char AbsHome_Request:1; //[MITSUBISHI : SABSV] // 181128 Abs Position Lost Bit
		unsigned char Reserved_01:3;
		unsigned char Reserved_02:8;
		
		unsigned char ZSPD:1;
		unsigned char DEN:1;
		unsigned char BRK_ON:1;
		unsigned char ZPOINT:1;
	} b;
	unsigned int v;
} cmsMechnicalIO;

// -------------------------------------------------------------------
// NETIO Module Type
// -------------------------------------------------------------------
typedef enum
{
	cmsMT_DO=0,	// DO
	cmsMT_DI,   	// DI
	cmsMT_DIO,	// DIO
	cmsMT_AI,	// AI
	cmsMT_AO,	// AO
	cmsMT_PM,	// Pulse Motion
	cmsMT_NONE	// None
}cmsNetioModuleType;

// -------------------------------------------------------------------
// Slave Type
// -------------------------------------------------------------------

typedef enum
{
	cmsST_SERVO=0,	// NETWORK SERVO
	cmsST_IO,		// NETIO
	cmsST_NONE		// NONE
}cmsSlaveType;



// -------------------------------------------------------------------
// Slave Info
// -------------------------------------------------------------------
typedef struct{
	unsigned short	ModuleType[LX540_MAX_MODULE_IN_SLAVE];	// Connected module type. (cmsModuleType)
	unsigned short	nNumModule;							// Connected module's number.
	unsigned short	nSlaveType;							// Slave Mode (cmsSlaveType)
}cmsSlaveInfo;

// -------------------------------------------------------------------
// Definition of Real Time Status update Structure
// -------------------------------------------------------------------

typedef struct
{
	struct
	{
		unsigned int AxisMask; //  Ʈ   RTS ĵ Ȱȭ  
		struct
		{
			struct
			{
				unsigned int INP: 1;		// [YASKAWA : PSET]
				unsigned int Reserved_00: 1;
				unsigned int HC:1;		// [Home Completed]
				unsigned int TL:1;		// [Toque Limited]
				unsigned int WARN:1;		// [SERVO Warning]
				unsigned int ALARM:1;		// [SERVO Alarm]
				unsigned int SVRDY:1;		// [YASKAWA : M_RDY]
				unsigned int SVON:1;		// [Servo On]
				
				unsigned int ELN:1;		// [YASKAWA : N_OT]
				unsigned int ELP:1;		// [YASKAWA : P_OT]
				unsigned int ORG:1;		// [Home Sensor]
				unsigned int EX_IN1:1;		// [YASKAWA : EXT1]
				unsigned int EX_IN2:1;		// [YASKAWA : EXT2]
				unsigned int EX_IN3:1;		// [YASKAWA : EXT3]
				unsigned int EX_IN4:1;		// [YASKAWA : DEC]
				unsigned int EMG_STP:1;		// [YASKAWA : ESTP]
							
				unsigned int ZSPD:1;
				unsigned int DEN:1;
				unsigned int BRK_ON:1;
				unsigned int ZPOINT:1;

				unsigned int Reserved_01:4;
				unsigned int Reserved_02:8;
				
			}DW0;

			struct
			{
				unsigned int Torq: 7;	
				unsigned int FieldMode: 1;
				unsigned int Mst: 4;	
				unsigned int MMode: 4;	
				int  LastError: 8;
				unsigned int Reserved;
			}DW1;

			int CmdCnt;
			int FeedCnt;
			int CmdVel;
			int FeedVel;			
		}Axis[32];
	}NM;

	struct
	{
		unsigned int NodeMask;
		struct
		{
			// DIO
			unsigned int DI0:1;
			unsigned int DI1:1;
			unsigned int DI2:1;
			unsigned int DO0:1;
			unsigned int DO1:1;
			unsigned int DO2:1;

			struct
			{
				struct  
				{
					// Motion Stat.
					unsigned int MOT:4;
					
					// Servo On/Off
					unsigned int SVON:1;
					
					// Motion IO
					unsigned int SVRDY:1;
					unsigned int ALM:1;
					unsigned int ELM:1;
					unsigned int ELP:1;
					unsigned int ORG:1;
					unsigned int DIR:1;
					unsigned int EZ:1;
					unsigned int LTC:1;

					unsigned int SD:1;
					unsigned int INP:1;
					unsigned int DRN:1;
					unsigned int DRP:1;
					unsigned int STA:1;
					unsigned int STP:1;
					unsigned int ALMR:1;
					unsigned int EMG:1;

					int CmdCnt;
					int FeedCnt;
					int CmdVel;
				} Axis[2];
			}Module[9];
		}Node[32];
	}PM; // Not used in NEMO-SS

	struct
	{
		unsigned int NodeMask;
		struct
		{
			unsigned int Di[9];
			unsigned int Do[9];
			unsigned int Dio[9];
		}Node[32];
	}IO; // Not used in NEMO-SS
} cmsRtsData;

// KKJ_20161104
///@brief		Firmware Statistics Data
///@remarks		Feedback ޸𸮸  Ʈ
typedef struct
{
	unsigned int ISR_MNM1221_RX_EntryPeriod;
	unsigned int sscMainProcessingTime;
	unsigned int SampingProcessingTime;
	unsigned int SysTmr0EntryPeriod;
	unsigned int SysTmr0ProcessingTime;
	unsigned int taskMainProcessingTime;
	unsigned int taskRTEXStatusProcessingTime;
	unsigned int taskCmdCntProcessingTime;
} cmsTNCFWStatistics;

typedef enum
{
	dpaddrSTS			= 0,								/// (0	 ~	 11) : System Status Space	  (12 bytes)
	dpaddrPC_TO_DSP_CMD = (dpaddrSTS			+ 12),		/// (12	 ~	267) : PC to DSP (Command)    (256 bytes)
	dpaddrPC_TO_DSP_RTN = (dpaddrPC_TO_DSP_CMD	+ 256),		/// (268  ~	523) : DSP to PC (Answer)     (256 bytes)

	dpaddrBUSY_STATE	= (dpaddrPC_TO_DSP_RTN	+ 256),		/// (524 ~ 531) : Busy State				(8 bytes)

	dpaddrDBGLOG        = (dpaddrBUSY_STATE		+ 8),		/// (532  ~ 2999) : Empty Space            (2468 bytes left)

	dpaddrFW_UPDATE		= (dpaddrDBGLOG		+ 2468)		/// (3000 ~ 8191) : Firmware Update		  (5192 bytes)
} eDPADDR;

typedef enum
{
	NDBG_MAIN_CNT=0,
	NDBG_MAIN_TIMERDPC,
	NDBG_MAIN_INWAIT
} eNDbg;

typedef enum
{
	NDBG_CNT_ALL=-1,
	NDBG_CNT_ISR_ENTER,
	NDBG_CNT_ISR_EXIT,
	NDBG_CNT_DPC_ENTER,
	NDBG_CNT_DPC_EXIT,
	NDBG_CNT_TIMERDPC_ENTER,
	NDBG_CNT_TIMERDPC_EXIT,
	NDBG_CNT_WDM_ENTER,
	NDBG_CNT_WDM_EXIT,
	NDBG_CNT_WDM_PENDING,
	NDBG_CNT_WDM_PENDING_OK,
	NDBG_CNT_WDM_PENDING_NOIRP,
	NDBG_CNT_WDM_PENDING_NOANS
} eNDbgCnt;

typedef enum
{
	FWV_MAIN_CFG,
	FWV_MAIN_DISCON_CURRENT,
	FWV_MAIN_DISCON_MAX,
	FWV_MAIN_DISCON_TOTAL,
	FWV_MAIN_INWAIT,
	FWV_MAIN_QUECLR,
	FWV_MAIN_CNT,
	FWV_MAIN_COMM_MAX,
	FWV_MAIN_FEED_MAX,
	FWV_MAIN_RAWCMD,
	FWV_MAIN_RAWSPD,
	FWV_MAIN_LASTTARPOS,
	FWV_MAIN_NREV,
	FWV_MAIN_NMUL,
	FWV_MAIN_NSIN,
	FWV_MAIN_INIPOS,
	FWV_MAIN_ENDPOS,
	FWV_MAIN_PHASE
} eFWVMain;

typedef enum
{
	FWV_CFG_DISCON_TIMEOUT,
	FWV_CFG_DISCON_ACTION,
	FWV_CFG_DISCON_RECOVERY,
	FWV_CFG_DLOG
} eFWVSubSetting;

typedef enum
{
	FWV_CNT_MAINTASK,
	FWV_CNT_PRDTICK,
	FWV_CNT_HWI_PCI_ENTER,
	FWV_CNT_HWI_PCI_EXIT,
	FWV_CNT_HWI_COMM_ENTER,
	FWV_CNT_HWI_COMM_EXIT,
	FWV_CNT_SWI_1MS_ENTER,
	FWV_CNT_SWI_1MS_EXIT,
	FWV_CNT_SWI_3MS_ENTER,
	FWV_CNT_SWI_3MS_EXIT,
	FWV_CNT_SWI_100MS_ENTER,
	FWV_CNT_SWI_100MS_EXIT,
	FWV_CNT_SWI_PCI_ENTER,
	FWV_CNT_SWI_PCI_EXIT,
	FWV_CNT_SWI_COMM_ENTER,
	FWV_CNT_SWI_COMM_EXIT,
	FWV_CNT_UTILQUE_INPUT,
	FWV_CNT_UTILQUE_OUTPUT,
	FWV_CNT_CHIPERR_CURRENT,
	FWV_CNT_CHIPERR_MAX,
	FWV_CNT_CHIPERR_TOTAL
} eFWVSubCnt;

// -------------------------------------------------------------------
// Types of SDK(Software Development Kit) Error Codes
// -------------------------------------------------------------------

// The Winerror.h file contains a listing of static error codes used throughout Microsoft Windows operating system products
#include "winerror.h"

#define cmsERR_NONE					0
#define cmsERR_INVALID_BUFFER			-1	// Invalid Buffer range
#define cmsERR_AXIS_MOT_QUEUE_FULL		-2	// Listed Queue Full
#define cmsERR_CALLWDM_ERROR			-3 // WDM ̹  ȯ   
#define cmsERR_IMD_REPLY_FAIL			-5	// Immediately Reply Fail
#define cmsERR_IMD_QUEUE_FULL			-6	// Immediately Queue Full

#define cmsERR_NOT_ENOUGH_MEMORY		-8	// Not Enough memory.
#define cmsERR_INVALID_PARAMETER		-10	// Some of the function parameters are invalid
#define cmsERR_INVALID_AXIS			-11	// The axis setting parameter(s) is (are) invalid
#define cmsERR_INVALID_SPEED_SET		-12	// Speed setting value is not valid

#define cmsERR_INVALID_IXMAP			-13	// Invalid Interpolation Map
#define cmsERR_INVALID_LMMAP			-14	// Invalid Listed-Motion Map
#define cmsERR_INVALID_NUMAXIS			-15	// Invalid number of axis(Mx)
	
#define cmsERR_INVALID_FILEPATH			-16	// Invalid Config File Path
#define cmsERR_INVALID_CTRLMODE			-17	// Invalid Control Mode Applied

#define cmsERR_STOP_BY_SLP				-50	// Abnormally stopped by positive soft limit
#define cmsERR_STOP_BY_SLN				-51	// Abnormally stopped by negative soft limit
#define cmsERR_STOP_BY_ELP				-52	// Abnormally stopped by (-) external limit
#define cmsERR_STOP_BY_ELN				-53	// Abnormally stopped by (+) external limit
#define cmsERR_STOP_BY_ALM				-54	// Abnormally stopped by alarm input signal
#define cmsERR_STOP_BY_CER				-55	// Abnormally stopped by communication error between NC and Slave nodes

#define cmsERR_MOT_SEQ_SKIPPED			-60	// Motion Command has been skipped because the axis is already running
#define cmsERR_SKIP_BY_ALM				-61	// Motion Command has been skipped by ALM signal.
#define cmsERR_SKIP_BY_SERVO_OFF		-62	// Motion Command has been skipped by the ServoPack state is OFF.
#define cmsERR_FAILED_COMMAND_SERVO_ON		-63	// Motion Command ServoOn has been failed in retry command.
#define cmsERR_FAILED_COMMAND_SERVO_OFF	-64	// Motion Command ServoOff has been failed in retry command.

#define cmsERR_FAILED_TORQUE_LIMIT_MODE		-65// Motion Command Position torque mode has been failed. ( Only Position use mode )

#define cmsERR_SKIP_BY_SEMG			-71	// Motion Command has been skipped by software emergency.
#define cmsERR_INVALID_LIBPARAM			-87 // Library Command Parameter is Invalid.

#define cmsERR_NODE_IS_NOT_SERVO			-1000	// Slave Device is Not Servo Driver
#define cmsERR_NODE_IS_NOT_NETIO			-1001	// Slave Device is Not NETIO Node Master
#define cmsERR_NODE_NOT_CONNECTED			-1002	// Slave Device is Not Connected

#define cmsERR_CHANNEL_OUT_OF_RANGE		-1010	// Slave Channel in Device is Out of Range
#define cmsERR_PARAMETER_OUT_OF_RANGE		-1011	// Given Parameter is Out of Range
#define cmsERR_PARAMETER_IS_NULL			-1012	// Parameter buffer is NULL
#define cmsERR_IXMAP_OUT_OF_RANGE			-1013	// Motion IxMapIndex is Out of Range

#define cmsERR_INVALID_MIO_PROP_ID			-1060	// CfgMioProperty ID is Invalid
#define cmsERR_CFG_UNIT_IS_ZERO			-1061	// CfgMioProperty Dist/Speed Unit is 0

#define cmsERR_HOME_SET_SUCCESS_FAILED		-1070	// HomeSetSuccess Failed

#define cmsERR_READ_MOTION_STATE_FAILED	-1080	// ReadMotionState Failed
#define cmsERR_READ_MACHINE_IO_FAILED		-1081	// ReadMIOStatus Failed
#define cmsERR_GET_COUNT_FAILED			-1082	// StGetCount Failed
#define cmsERR_GET_SPEED_FAILED			-1083	// StGetSpeed Failed

#define cmsERR_MS_REGISTER_SKIPPED			-1090	// Master/Slave Register Failed
#define cmsERR_MS_INVALID_AXIS_REGISTER	-1091	// Master/Slave Register Axis is Invalid
#define cmsERR_MS_REGISTER_SAME_AXIS		-1092	// Master/Slave Register Axis is same

#define cmsERR_DEVICE_NOT_FOUND			-1168	// SSCNET3 Device is not detected.
#define cmsERR_DEVICE_NOT_AVAILABLE		-4319	// SSCNET3 Device is not available.

#endif
