﻿using System.Runtime.InteropServices;

namespace ComiLib.NEMO_Def
{
    [System.Security.SuppressUnmanagedCodeSecurity]
    public unsafe partial class SafeNativeMethods
    {
        //----------------------------------------------------------
        //Declare Const Values in NEMO Library
        //----------------------------------------------------------
        const int LX530S_MAX_SUPPORT_MASTER_BOARDS = 16;
        const int LX530S_MAX_SUPPORT_SLAVE_AXES = 32;
        const int LX530S_MAX_SUPPORT_INTERPOLATION_MOTION = 16;
        const int LX530S_MAX_SUPPORT_LISTED_MOTION = 16;
        const int LX530S_MAX_SUPPORT_LISTED_MOTION_USER_PARAM = 4;
        const int LX530S_MAX_MODULE_IN_SLAVE = 9;
        const int LX530S_MAX_SUPPORT_IN_NODE_AXES = 2;
        const int MAX_NUM_PLATFORM = 5; //RTEM, MLINK2, MLINK3, SSCNET3, SSCNET3/H

        const int MAX_NUM_FUNC = 600;

        // -------------------------------------------------------------------
        // Types of Log Mode
        // -------------------------------------------------------------------
        const int LOG_DISABLE = 0;
        const int LOG_OUTPUTDEBUG = 1;
        const int LOG_FILE = 2;
        const int LOG_CONSOLE = 4;
        const int LOG_PIPE = 8;

        // -------------------------------------------------------------------
        // Types of Reset Configuration(ENVIRONMENT)
        // -------------------------------------------------------------------
        const int RS_SX_ENV = 0x00000001;		// Sx Move Environment Restore Factory DEFAULTS
        const int RS_IX_ENV = 0x00000002;		// Ix Move Environment Restore Factory DEFAULTS
        const int RS_LM_ENV = 0x00000004;		// Lm Move Environment Restore Factory DEFAULTS
        const int RS_SPEED_ENV = 0x00000008;		// Speed Configuration Environment Restore Factory DEFAULTS
        const int RS_HOME_ENV = 0x00000010;		// Hm Move Environment Restore Factory DEFAULTS
        const int RS_POS_ENV = 0x00000020;		// Position Environment Restore Factory DEFAULTS
        const int RS_BACKLASH_ENV = 0x00000040;		// Backlash Configuration Restore Factory Default
        const int RS_SWLIMIT_ENV = 0x00000080;		// S/W Limit Configuration Restore Factory Default
        const int RS_UPDATE_INTERVAL_ENV = 0x00000040;		// Update Interval Restore Factory DEFAULTS	(1msec)
        const int ALL_RESET = RS_SX_ENV | RS_IX_ENV | RS_LM_ENV | RS_SPEED_ENV | RS_HOME_ENV | RS_POS_ENV | RS_BACKLASH_ENV | RS_SWLIMIT_ENV | RS_UPDATE_INTERVAL_ENV;


        // -------------------------------------------------------------------
        // Types of Log Level
        // -------------------------------------------------------------------

        const int LL_INCLUDE = -1;
        const int LL_NONE = 0;
        const int LL_ERROR = 1;
        const int LL_CMD = 2;
        const int LL_STATUS = 3;
        const int LL_ALL = 4;
        const int LL_EXCLUDE = 5;


        public enum ERROR_CODES
        {
            ERR_NONE = 0,
            ERR_INVALID_BUFFER = -1,	// Invalid Buffer range
            ERR_AXIS_MOT_QUEUE_FULL = -2,	// Listed Queue Full
            ERR_CALLWDM_ERROR = -3, // WDM 드라이버와의 데이터 교환 실패  
            ERR_IMD_REPLY_FAIL = -5,	// Immediately Reply Fail
            ERR_IMD_QUEUE_FULL = -6,	// Immediately Queue Full

            ERR_NOT_ENOUGH_MEMORY = -8,	// Not Enough memory.
            ERR_INVALID_PARAMETER = -10,	// Some of the function parameters are invalid
            ERR_INVALID_AXIS = -11,	// The axis setting parameter(s) is (are) invalid
            ERR_INVALID_SPEED_SET = -12,	// Speed setting value is not valid
            ERR_INVALID_IXMAP = -13,	// Invalid Interpolation Map
            ERR_INVALID_LMMAP = -14,	// Invalid Listed= -Motion Map
            ERR_INVALID_NUMAXIS = -15,	// Invalid number of axis(Mx)
            ERR_INVALID_FILEPATH = -16,	// Invalid Config File Path
            ERR_INVALID_CTRLMODE = -17,	// Invalid Control Mode Applied
            ERR_STOP_BY_SLP = -50,	// Abnormally stopped by positive soft limit
            ERR_STOP_BY_SLN = -51,	// Abnormally stopped by negative soft limit
            ERR_STOP_BY_ELP = -52,	// Abnormally stopped by (= -) external limit
            ERR_STOP_BY_ELN = -53,	// Abnormally stopped by (+) external limit
            ERR_STOP_BY_ALM = -54,	// Abnormally stopped by alarm input signal
            ERR_STOP_BY_CER = -55,	// Abnormally stopped by communication error between NC and Slave nodes

            ERR_MOT_SEQ_SKIPPED = -60,	// Motion Command has been skipped because the axis is already running
            ERR_SKIP_BY_ALM = -61,	// Motion Command has been skipped by ALM signal.
            ERR_SKIP_BY_SERVO_OFF = -62,	// Motion Command has been skipped by the ServoPack state is OFF.
            ERR_FAILED_COMMAND_SERVO_ON = -63,	// Motion Command ServoOn has been failed in retry command.
            ERR_FAILED_COMMAND_SERVO_OFF = -64,	// Motion Command ServoOff has been failed in retry command.

            ERR_SKIP_BY_SEMG = -71,	// Motion Command has been skipped by software emergency.
            ERR_INVALID_LIBPARAM = -87, // Library Command Parameter is Invalid.

            ERR_NODE_IS_NOT_SERVO = -1000,	// Slave Device is Not Servo Driver
            ERR_NODE_IS_NOT_NETIO = -1001,	// Slave Device is Not NETIO Node Master
            ERR_NODE_NOT_CONNECTED = -1002,	// Slave Device is Not Connected
            ERR_CHANNEL_OUT_OF_RANGE = -1010,	// Slave Channel in Device is Out of Range
            ERR_PARAMETER_OUT_OF_RANGE = -1011,	// Given Parameter is Out of Range
            ERR_PARAMETER_IS_NULL = -1012,	// Parameter buffer is NULL
            ERR_IXMAP_OUT_OF_RANGE = -1013,	// Motion IxMapIndex is Out of Range

            ERR_SET_AI_VOLT_RANGE_FAIL = -1020,	// AiSetVoltRangeMode Failed
            ERR_GET_AI_VOLT_RANGE_FAIL = -1021,	// AiGetVoltRangeMode Failed
            ERR_GET_AI_RANGE_DIGIT_FAIL = -1022,	// AiGetRangeDigit Failed

            ERR_GET_AI_VOLT_FAIL = -1031,	// AiGetVolt Failed
            ERR_GET_AI_DIGIT_FAIL = -1032,	// AiGetDigit Failed
            ERR_GET_AI_CURRENT_FAIL = -1033,	// AiGetCurrent Failed

            ERR_AO_OUT_VOLT_FAIL = -1041,	// AoOutVolt Failed
            ERR_AO_OUT_DIGIT_FAIL = -1042,	// AoOutDigit Failed
            ERR_AO_OUT_CURRENT_FAIL = -1043,	// AoOutCurrent Failed

            ERR_DIO_TYPE_IS_NOT_MATCH = -1050,	// DI/DO Type is not match

            ERR_INVALID_MIO_PROP_ID = -1060,	// CfgMioProperty ID is Invalid
            ERR_CFG_UNIT_IS_ZERO = -1061,	// CfgMioProperty Dist/Speed Unit is 0

            ERR_HOME_SET_SUCCESS_FAILED = -1070,	// HomeSetSuccess Failed

            ERR_READ_MOTION_STATE_FAILED = -1080,	// ReadMotionState Failed
            ERR_READ_MACHINE_IO_FAILED = -1081,	// ReadMIOStatus Failed
            ERR_GET_COUNT_FAILED = -1082,	// StGetCount Failed
            ERR_GET_SPEED_FAILED = -1083,	// StGetSpeed Failed

            ERR_MS_register_SKIPPED = -1090,	// Master/Slave register Failed
            ERR_MS_INVALID_AXIS_register = -1091,	// Master/Slave register Axis is Invalid
            ERR_MS_register_SAME_AXIS = -1092,	// Master/Slave register Axis is same

            ERR_DEVICE_NOT_FOUND = -1168,	// MLink2 Device is not detected.
            ERR_DEVICE_NOT_AVAILABLE = -4319,	// MLink2 Device is not available.
        }

        public enum SWITCH
        {
            OFF = 0,
            ON = 1
        }


        //----------------------------------------------------------------------------------
        //Types of Machine I/O Property ID (using to CfgSetMioProperty, CfgGetMioProperty)
        //----------------------------------------------------------------------------------

        public enum MIOID
        {
            PEL_LOGIC = 0,       //Property Val [ LOGIC_A | LOGIC_B ] (Default : LOGIC_A)
            NEL_LOGIC = 1,       //Property Val [ LOGIC_A | LOGIC_B ] (Default : LOGIC_A)
            ORG_LOGIC = 2,       //Property Val [ LOGIC_A | LOGIC_B ] (Default : LOGIC_A)
            EL_MODE = 3,         //Property Val [ 0 : Emg Stop | 1 : Stop ] (Default : Emg Stop)
            INP_EN = 4,          //Property Val [ 0 : Inp[D] | 1 : Inp[E]] (Default : Inp[D]
            CFSYNC_EN = 5,       //Property Val [ 0 : Disable | 1 : Enable ] (Default : Disable)
            SVON_MODE = 6,
            VELCTRL_MODE = 7,    //Property Val [ 0 : Position Control Mode | 1 : Velocity Control Mode ] (Default : Position Mode)
            VELCTRL_MAXRPM = 8,  //<속도 제어 모드 시 모터 최대 rpm>
            VELCTRL_PPR = 9,     //<속도 제어 모드 시 모터 회전 당 펄스 수>
            SWL_MODE = 10,       //Property Val [0 : Emg Stop | 1 : Stop ] (Default : Emg Stop)

            INVALID              //Used for enumerated type range checking
        }

        //----------------------------------------------------------------------------------
        //Types of Machine I/O State Bit Index (using to StReadMioStatuses)
        //----------------------------------------------------------------------------------


        public enum IoST
        {
            Inposition = 0,
            Reserved_00 = 1,
            HomeCompeted = 2,
            TorqueLimited = 3,
            Warning = 4,
            Alarm = 5,
            Ready = 6,
            ServoOn = 7,
            ExternalLimit_N = 8,
            ExternalLimit_P = 9,
            Origin = 10,
            EX_IN1 = 11,
            EX_IN2 = 12,
            EX_IN3 = 13,
            EX_IN4 = 14,
            Emergency_Stop = 15,
            Reserved_01 = 16,
            Reserved_02 = 20,
            ZSPD = 28,
            DEN = 29,
            BreakON = 30,
            ZeroPOINT = 31,
        }

        public enum IoST_S
        {
            INP = 0,
            RSV0 = 1,
            HC = 2,
            TL = 3,
            WARN = 4,
            ALM = 5,
            RDY = 6,
            SVON = 7,
            ELN = 8,
            ELP = 9,
            ORG = 10,
            EXI1 = 11,
            EXI2 = 12,
            EXI3 = 13,
            EXI4 = 14,
            ESTP = 15,
            RSV1 = 16,
            RSV2 = 20,
            ZSPD = 28,
            DEN = 29,
            BKON = 30,
            ZPT = 31,
        }

        //----------------------------------------------------------------------------------
        //Types of Machine I/O Property ID (using to CfgSetMioProperty, CfgGetMioProperty)
        //----------------------------------------------------------------------------------

        public enum MIOVALUE
        {
            LOGIC_A = 0,
            LOGIC_B = 1,

            LOGIC_INVALID        //Used for enumerated type range checking
        }


        //----------------------------------------------------------------------------------
        //Types of Motion State (using to StSxReadMotionState, StIxReadMotinState)
        //----------------------------------------------------------------------------------

        public enum MotorState
        {
            STOP = 0,
            ACCEL = 1,
            WORK_SPEED = 2,
            DECEL = 3,
            INIT_SPEED = 4,
            IN_WAIT = 5,
            SLAVE_MODE = 6,
            INVALID,
        }


        //----------------------------------------------------------------------------------
        //Types of Linear Operation Direction (using to SxVMoveStart, MxVMoveStart)
        //----------------------------------------------------------------------------------
        public enum Dir
        {
            N = 0,
            P = 1,

            INVALID
        }

        //Counter name//
        public enum CmCntr
        {
            COMM = 0,   /*Command*/
            FEED,    /*Feedback*/
            DEV,     //Deviation
            GEN,     //General

            INVALID  //Used for enumerated type range checking
        }

        //Encoder Mode
        public enum EncoderMode
        {
            ABS,
            INC
        }

        //Control Mode
        public enum ControlMode
        {
            POS,
            VEL,
            TOR
        }

        //----------------------------------------------------------------------------------
        //Types of Speed Mode Value (using to CfgSetSpeedPattern, CfGetSpeedPatern)
        //----------------------------------------------------------------------------------
        public enum SpeedMode
        {
            CONSTANT = 0,
            TRAPEZOIDAL = 1,
            SCURVE = 2,

            INVALID            //Used for enumerated type range checking
        }

        //----------------------------------------------------------------------------------
        //Types of Backlash/Slip Correction Mode Value (using to SxSetCorrection, SxGetCorrection)
        //----------------------------------------------------------------------------------
        public enum CorrMode
        {
            DISABLE = 0,
            BACKLASH = 1,
            SLIP = 2,

            INVALID             //Used for enumerated type range checking
        }


        //----------------------------------------------------------------------------------
        //Types of Interpolation Map Index (using to IxMapAxes, IxUnManAxes)
        //----------------------------------------------------------------------------------
        public enum IxMODE
        {
            LINEAR = 0,
            CIRCULAR = 1,
            HELICARL = 2,
            SPLINE = 3,

            INVALID          //Used for enumerated type range checking
        }

        //----------------------------------------------------------------------------------
        //Types of Interpolation Mode (using to ArcAm ArcP)
        //----------------------------------------------------------------------------------
        public enum IxARC_DIR
        {
            CW = 0,
            CCW = 1,

            INVALID              //Used for enumerated type range checking
        }


        //----------------------------------------------------------------------------------
        //Types of Return Home Mode (using to HomeSetConfig, HomeGetConfig)
        //----------------------------------------------------------------------------------
        public enum HomeMode
        {
            //PCI : 0번 모드
            //ORG On → Stop
            MODE0 = 0,
            //PCI : 1번 모드
            //ORG On → Back(Vr) → ORG OFF → Foward(Vr) → ORG ON → Stop
            MODE1 = 1,
            //PCI : 2번 모드
            //ORG On → Slow Down(Vini) → Stop in EZ Count
            MODE2 = 2,
            //PCI : 6번 모드
            //EL On → Stop → Back(Vr) → EL OFF → Stop
            MODE3 = 3,
            //PCI : 7번 모드
            //EL On → Stop → Back(Vr) → Stop on EZ Count2
            MODE4 = 4,

            INVALID        //Used for enumerated type range checking
        }

        // -------------------------------------------------------------------
        // Types of S5 Home operation parameter ID
        // -------------------------------------------------------------------
        public enum HomeParamId
        {
            MODE = 0,
            DIR = 1,
            OFFSET = 2,
            EZCOUNT = 3,

            INVALID             //Used for enumerated type range checking
        }


        //----------------------------------------------------------------------------------
        //Types of Listed Motion LmStsId (using to LmxGetStates, ...)
        //----------------------------------------------------------------------------------
        public enum LmStsId
        {
            STARTED = 0,           //리스트 모션이 시작되었으면, TRUE가 된다.
            BUSY = 1,              //리스트 모션이 시작되었고, 해당 축이 구동중 일 경우 TRUE가 된다
            RUN_TEM_SEQ_ID = 2,    //현재 구동중인 리스트 모션 시퀀스 아이디를 반환한다
            NC_BUFFER_STATUS = 3,  //TRUE : [Buffer FREE ], FALSE : [Buffer Full]
            USED_SPACE = 5,

            INVALID                //Used for enumerated type range checking
        }

        //----------------------------------------------------------------------------------
        //Types of COM State Id (Using to GnSetCommStates, GnGetCommStates)
        //----------------------------------------------------------------------------------
        public enum COMMStates
        {
            COM_STATES = 0,
            RTS_COUNT = 1,
            CMD_COUNT = 2,
            COM_RST = 3,            //Only 'Set' Support

            INVALID                 //Used for enumerated type range checking
        }

        // -------------------------------------------------------------------
        // Types of [emCOM_STATES] 'States' (using to GnSetCommStates, GnGetCommStates)
        // -------------------------------------------------------------------
        public enum STATE
        {
            RESET = -1,
            INIT = 0,
            WAITING = 1,
            PREPARE = 2,
            START = 3,
            RUNNING = 4,

            INVALID            //Used for enumerated type range checking
        }

        public enum HomePhaseId
        {
            PHASE0 = 0,
            PHASE1 = 1,
            PHASE2 = 2,
            PHASE_INVALID		// Used for enumerated type range checking		
        }

        //[StructLayoutAttribute(LayoutKind.Sequential)]
        //[BitFieldAttribute(32)]
        //public struct cmlMechnicalIO
        //{
        //    public uint bitvector1;
        //    [BitFieldInfo(0, 1)]    public bool INP { get; set; }
        //    [BitFieldInfo(1, 1)]    public bool DIR { get; set; }
        //    [BitFieldInfo(2, 1)]    public bool HC { get; set; }
        //    [BitFieldInfo(3, 1)]    public bool TL { get; set; }
        //    [BitFieldInfo(4, 1)]    public bool WARN { get; set; }
        //    [BitFieldInfo(5, 1)]    public bool ALARM { get; set; }
        //    [BitFieldInfo(6, 1)]    public bool SVRDY { get; set; }
        //    [BitFieldInfo(7, 1)]    public bool SVON { get; set; }
        //    [BitFieldInfo(8, 1)]    public bool ELN { get; set; }
        //    [BitFieldInfo(9, 1)]    public bool ELP { get; set; }
        //    [BitFieldInfo(10, 1)]   public bool ORG { get; set; }
        //    [BitFieldInfo(11, 1)]   public bool EX_IN1 { get; set; }
        //    [BitFieldInfo(12, 1)]   public bool EX_IN2 { get; set; }
        //    [BitFieldInfo(13, 1)]   public bool EX_IN3 { get; set; }
        //    [BitFieldInfo(14, 1)]   public bool EX_IN4 { get; set; }
        //    [BitFieldInfo(15, 1)]   public bool EMG_STP { get; set; }
        //    [BitFieldInfo(16, 1)]   public byte Reserved_01 { get; set; }
        //    [BitFieldInfo(17, 4)]   public byte Reserved_02 { get; set; }
        //    [BitFieldInfo(21, 8)]   public bool ZSPD { get; set; }
        //    [BitFieldInfo(29, 1)]   public bool DEN { get; set; }
        //    [BitFieldInfo(30, 1)]   public bool BRK_ON { get; set; }
        //    [BitFieldInfo(31, 1)]   public bool ZPOINT { get; set; }

        //    public uint v;
        //}

        const int MAX_MODULE_IN_SLAVE = 9;

        // -------------------------------------------------------------------
        // NETIO Module Type
        // -------------------------------------------------------------------

        public struct SlaveInfo
        {
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
            internal ushort[] ModuleType;	                    // Connected module type. (cmlModuleType)
            internal ushort nNumModule;							// Connected module's number.
            internal ushort nSlaveType;							// Slave Mode (cmlSlaveType)
        };


        public enum NetioModuleType
        {
            MT_DO, // DO
            MT_DI, // DI
            MT_DIO, // DIO
            MT_AI, // AI
            MT_AO, // AO
            MT_PM, // Pulse Motion
            MT_NONE // None
        }


        // Motion I/O Property ID //
        public enum PmMioPropId
        {
            PM_ALM_LOGIC,
            PM_ALM_MODE,
            PM_CMP_LOGIC,
            PM_DR_LOGIC,
            PM_EL_LOGIC,
            PM_EL_MODE,
            PM_ERC_LOGIC,
            PM_ERC_OUT,
            PM_EZ_LOGIC,
            PM_INP_EN,
            PM_INP_LOGIC,
            PM_LTC_LOGIC,
            PM_LTC_LTC2SRC,
            PM_ORG_LOGIC,
            PM_SD_EN,
            PM_SD_LOGIC,
            PM_SD_LATCH,
            PM_SD_MODE,
            PM_STA_MODE,
            PM_STA_TRG,
            PM_STP_MODE,
            PM_CLR_CNTR,
            PM_CLR_SIGTYPE,
            PM_CMP_PWIDTH,
            PM_ERC_ONTIME,
            PM_SVON_LOGIC,
        };


        public enum PmMioPropIdEx
        {
            ALM_LOGIC,
            ALM_MODE,
            CMP_LOGIC,
            DR_LOGIC,
            EL_LOGIC,
            EL_MODE,
            ERC_LOGIC,
            ERC_OUT,
            EZ_LOGIC,
            INP_EN,
            INP_LOGIC,
            LTC_LOGIC,
            LTC_LTC2SRC,
            ORG_LOGIC,
            SD_EN,
            SD_LOGIC,
            SD_LATCH,
            SD_MODE,
            STA_MODE,
            STA_TRG,
            STP_MODE,
            CLR_CNTR,
            CLR_SIGTYPE,
            CMP_PWIDTH,
            ERC_ONTIME,
            SVON_LOGIC,
            ERC_OUT_EL,
            CNT_D_SRC,
            CNT_G_SRC,
            LTC_TRGMODE,
            SLIM_EN = 100,
            OUT_MODE,
            IN_MODE,
            IN_INV,
            PM_G_EN
        };


        // Bit order of StReadMioStatuses() return value  //
        public enum PmMioState
        {
            RDY,
            ALM,
            ELN,
            ELP,
            ORG,
            DIR,
            EZ,
            LTC,
            SD,
            INP,
            DRN,
            DRP,
            STA,
            STP,
            ALMR,
            EMG,
            SVON
        };


        // Motion operation status ID //
        public enum PmMotionState
        {
            PM_MST_STOP,
            PM_MST_WAIT_DR,
            PM_MST_WAIT_STA,
            PM_MST_WAIT_INSYNC,
            PM_MST_WAIT_OTHER,
            PM_MST_WAIT_ERC,
            PM_MST_WAIT_DIR,
            PM_MST_RESERVED1,
            PM_MST_WAIT_PLSR,
            PM_MST_IN_RVSSPD,
            PM_MST_IN_INISPD,
            PM_MST_IN_ACC,
            PM_MST_IN_WORKSPD,
            PM_MST_IN_DEC,
            PM_MST_WAIT_INP,
            PM_MST_ERROR,
            PM_MST_HOMMING,
        };


        // Signal logic definition //
        public enum PmSigLogic
        {
            PM_LOGIC_A = 0 /*Normal open*/,
            PM_LOGIC_B = 1/*Normal close*/
        };

        // Encoder and PA/PB input mode definition //
        public enum PmInMode
        {
            PM_IMODE_AB1X,
            PM_IMODE_AB2X,
            PM_IMODE_AB4X,
            PM_IMODE_CWCCW,
            PM_IMODE_STEP
        };


        // Command output mode definition //
        public enum PmOutMode
        {
            PM_OMODE_PDIR0,
            PM_OMODE_PDIR1,
            PM_OMODE_PDIR2,
            PM_OMODE_PDIR3,
            PM_OMODE_CWCCW0,
            PM_OMODE_CWCCW1,
            PM_OMODE_CCWCW0,
            PM_OMODE_CCWCW1
        };


        // Control Mode //
        public enum PmCtrlMode
        {
            PM_CTRL_OPEN, // Open loop control mode
            PM_CTRL_SEMI_C, // Semi-closed loop control mode (applied only to absolute in-position commands)
            PM_CTRL_FULL_C // Full-closed loop control mode (this is not supported at current version)
        };


        // (Linear)Operation direction //	
        public enum PmDir
        {
            PM_DIR_N /*(-)Dir*/,
            PM_DIR_P /*(+)Dir*/
        };


        // Counter name //
        public enum PmCntr
        {
            PM_CNT_COMM/*Command*/,
            PM_CNT_FEED/*Feedback*/,
            PM_CNT_DEV/*Deviation*/,
            PM_CNT_GEN/*General*/,
            PM_CNT_REM/*Remained*/
        };


        // Speed mode index definition //	
        public enum PmSpeedMode
        {
            PM_SMODE_KEEP = -1/* Keep previous setting*/,
            PM_SMODE_C = 0 /*Constant */,
            PM_SMODE_T /*Trapeziodal*/,
            PM_SMODE_S /*S-curve*/
        };


        public enum PmArcDir
        {
            PM_ARC_CW,
            PM_ARC_CCW
        };


        // Compare Method //
        public enum PmCmpMethod
        {
            PM_DISABLE,
            PM_EQ_BIDIR,
            PM_EQ_PDIR,
            PM_EQ_NDIR,
            PM_LESS/*Cnt<Data*/,
            PM_GREATER/*Cnt>Data*/
        };


        // Action when general comparator met the condition //
        public enum PmCmpAction
        {
            PM_EVNT_ONLY,
            PM_EVNT_IS,
            PM_EVNT_DS,
            PM_EVNT_SPDCHG
        };


        // Backlash/Slip correction mode //
        public enum PmCorrMode
        {
            PM_CORR_DIS, // Disable correction 
            PM_CORR_BACK, // Backlash correction mode 
            PM_CORR_SLIP // Slip correction mode
        };


        // Using for preregister option
        public enum PmExtOptionId
        {
            PM_EXOPT_SET_USE_PREREG
        };


        // Interrupt Handler Type //
        public enum PmIntHandlerType
        {
            PM_IHT_MESSAGE = 0,
            PM_IHT_EVENT,
            PM_IHT_CALLBACK
        };


        // Interrupt Handler Type //
        public enum PmStringID
        {
            PM_STR_AXIS_NAME,
            PM_STR_DIST_UNIT,
            PM_STR_SPEED_UNIT
        };


        // Sequence Mode //
        public enum PmSeqMode
        {
            PM_SEQM_SKIP_RUN,
            PM_SEQM_WAIT_RUN
        };


        // Map Type //
        public enum PmDevMapType
        {
            PM_DMAP_MOTION,
            PM_DMAP_DIO,
            PM_DMAP_ALL
        };


        // SetFilterAB의 대상 //
        public enum PmABFilter
        {
            PM_AB_ENC,
            PM_AB_PULSAR
        };


        // Axis Return to home clear mode //
        public enum PmHomePosClrMode
        {
            PM_HPCM_DISABLE = -1, // Disable HomePosClearMode
            PM_HPCM_M0, // ORG(/EL/EZ) 신호가 발생할 때 COMMAND & FEEDBACK 위치를 0으로 클리어한다.
            PM_HPCM_M1, // 원점복귀를 모두 완료하고 나서 COMMAND & FEEDBACK 위치를 모두 0으로 클리어한다.
            PM_HPCM_M2  // 원점복귀를 모두 완료하고 나서 FEEDBACK 위치는 그대로 두고 COMMAND 위치를 FEEDBACK 위치에 일치시킨다.
        };


        public enum PmLatchTrgMode
        {
            PM_LTM_LTC, // LTC 입력 신호에 의해서 포지션 래치가 수행됩니다.
            PM_LTM_ORG  // ORG 입력 신호에 의해서 포지션 래치가 수행됩니다.
        };


        // Sync mode //
        public enum PmSyncMode
        {
            PM_SYNC_DISABLE,
            PM_SYNC_INT_SYNC,
            PM_SYNC_OTHER_STOP
        };


        // public  sync. conditions //
        public enum PmIntSyncCond
        {
            PM_ISYNC_ACC_STA, // 0: at start of acceleration
            PM_ISYNC_ACC_END, // 1: at end of acceleration
            PM_ISYNC_DEC_STA, // 2: at start of deceleration
            PM_ISYNC_DEC_END, // 3: at end of deceleration
            PM_ISYNC_SLN, // 4: when (-)software limit met
            PM_ISYNC_SLP, // 5: when (+)software limit met
            PM_ISYNC_GCMP, // 6: when General Comparator condition is satisfied
            PM_ISYNC_TCMP // 7: when Trigger Comparator condition is satisfied
        };


        // DIO Mode //
        public enum DioMode
        {
            DIOMODE_IN /*Input Mode*/,
            DIOMODE_OUT /*Output Mode*/
        };

        public enum SlaveType : ushort
        {
            ST_SERVO = 0,	// NETWORK SERVO
            ST_IO,		// NETIO
            ST_NONE,		// NONE
            ST_INVALID = 0xFFFF,
        }
    }
}
