/*******************************************************************************
* [ ComiSSCNET3_SDK.h ]
* Header file for definitions of constants and data in SSCNET-3 library
* - Update Data: 2016/06/04
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#ifndef __COMI_SSCNET3_SDK_H__
#define __COMI_SSCNET3_SDK_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ComiSSCNET3_SDK_Def.h"

#if !defined(__in)
#define __in
#endif

#if !defined(__in_opt)
#define __in_opt
#endif

#if !defined(__out)
#define __out
#endif

#if !defined(__out_opt)
#define __out_opt
#endif

#if !defined(__inout)
#define	__inout
#endif

#ifdef __cplusplus
extern "C"{
#endif

#ifdef _DLL_MAIN_CPP_
	#define EXTERN 
#else 
	#define EXTERN extern
#endif

//////////////////////////////////////////////////////////////////////////
// External Functions for DLL(Dynamic Link Library)
//////////////////////////////////////////////////////////////////////////
BOOL cmsLoadDll();
VOID cmsUnloadDll();

//////////////////////////////////////////////////////////////////////////
// Low Level API for Debugging
//////////////////////////////////////////////////////////////////////////
EXTERN VOID		(WINAPI *cmsGetResources)		(__in LONG BoardId, __out PULONG pdwIntVect, __out PULONG pdwIoPorts, __in INT nNumPorts, __out PULONG pdwMemPorts, __in INT nNumMemPorts);
EXTERN VOID 	(WINAPI *cmsWriteMemPortDW)		(__in LONG BoardId, __in  ULONG dwPortBase, __in ULONG nOffset, __in LONG dwWriteVal);
EXTERN DWORD	(WINAPI *cmsReadMemPortDW)		(__in LONG BoardId, __in  ULONG dwPortBase, __in ULONG nOffset, __out PLONG pdwReadVal);
EXTERN DWORD	(WINAPI *cmsDpramRead)			(__in LONG BoardId, __in LONG StartAddr, __in LONG Size, __out PBYTE pBuffer);
EXTERN DWORD	(WINAPI *cmsDpramWrite)			(__in LONG BoardId, __in LONG StartAddr, __in LONG Size, __in PBYTE pBuffer);
EXTERN DWORD	(WINAPI *cmsDpramBusyEnable)	(__in LONG BoardId, __in LONG SectId, __in LONG IsWaitEnable, __in LONG TimeoutVal);
EXTERN DWORD	(WINAPI *cmsDpramBusyDisable)	(__in LONG BoardId, __in LONG SectId);

//////////////////////////////////////////////////////////////////////////
// Device Load / Unload
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmsGnLoadDevice)		(__out PLONG NumDevices, __out PLONG BoardIdList, __out_opt PLONG NumServos);
EXTERN LONG (WINAPI *cmsGnUnloadDevice) 	();

EXTERN LONG	(WINAPI *cmsGnLoadParameter)	(__in LONG BoardId);

EXTERN LONG	(WINAPI *cmsGnSetLogMode)		(__in  LONG LogMode);
EXTERN LONG	(WINAPI *cmsGnGetLogMode)		(__out PLONG LogMode);

EXTERN LONG	(WINAPI *cmsGnSetLogLevel)		(__in  LONG LogLevel);
EXTERN LONG	(WINAPI *cmsGnGetLogLevel)		(__out PLONG LogLevel);

EXTERN LONG	(WINAPI *cmsGnSetFuncLevel)		(__in LONG FuncIndex, __in  LONG LogLevel);
EXTERN LONG	(WINAPI *cmsGnRestoreFuncLevel)	(__in LONG FuncIndex);
EXTERN LONG	(WINAPI *cmsGnGetFuncLevel)		(__in LONG FuncIndex, __out PLONG LogLevel);

//////////////////////////////////////////////////////////////////////////
// General Functions
//////////////////////////////////////////////////////////////////////////

EXTERN  LONG    (WINAPI *cmsGnSetCommStates)		(__in LONG BoardId, __in LONG Axis, __in LONG cmStsId, __in  LONG CommStsVal);
EXTERN  LONG    (WINAPI *cmsGnGetCommStates)		(__in LONG BoardId, __in LONG Axis, __in LONG cmStsId, __out PLONG CommStsVal);

EXTERN  LONG    (WINAPI *cmsGnResetComm)		(__in LONG BoardId);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 dwIsOn :  ¸ մϴ.   (1: , 0: )
EXTERN	LONG	(WINAPI *cmsGnSetServoOn)		(__in LONG BoardId, __in	LONG Axis, __in LONG  dwIsOn);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 dwIsOn :  ¸ ȯմϴ. (1: , 0: )
EXTERN	LONG	(WINAPI *cmsGnGetServoOn)		(__in LONG BoardId, __in	LONG Axis, __out PLONG pdwIsOn);

EXTERN  LONG	(WINAPI *cmsGnSetAlarmRes)		(__in LONG BoardId, __in   LONG Axis);
EXTERN  LONG 	(WINAPI *cmsGnGetAlarmRes)		(__in LONG BoardId, __in	LONG Axis, __out LONG * IsOn);
EXTERN	LONG	(WINAPI *cmsGnSetEmergency)		(__in LONG BoardId, __in	LONG Axis, __in LONG IsDecStop, __in LONG IsEnable);
EXTERN	LONG	(WINAPI *cmsGnGetEmergency)		(__in LONG BoardId, __in	LONG Axis, __out PLONG IsDecStopped, __out PLONG IsEnabled);
EXTERN	LONG	(WINAPI *cmsGnSetEmergencyAll)		(__in   LONG IsDecStop, __in	LONG IsEnable);
EXTERN	LONG	(WINAPI *cmsGnGetEmergencyAll)		(__out  LONG * IsDecStopped, __out	PLONG IsEnabled);

// (NEMO) Sampling Period  Ǵ ȯմϴ.
// [IN] nPeriod
EXTERN LONG	(WINAPI *cmsGnSetCommPeriod)		(__in LONG BoardId, __in LONG nPeriod);

// (NEMO) Sampling Period Flashκ о´.
// [OUT] nPeriod
EXTERN LONG	(WINAPI *cmsGnGetCommPeriod)		(__in LONG BoardId, __out PLONG nPeriod);

EXTERN	LONG	(WINAPI *cmsGnResetDevice)		(__in LONG BoardId, __in	LONG ResetMask);

// [IN] VT_I4 dwInterval : Ʈ ֱ (500usec Unit)
EXTERN  LONG	(WINAPI *cmsGnSetStatusUpdateInterval)	(__in LONG BoardId, __in	LONG dwInterval);
EXTERN	LONG	(WINAPI *cmsGnGetStatusUpdateInterval)	(__in LONG BoardId, __out	PLONG dwInterval);

// [OUT] AxisMapMask
EXTERN	LONG	(WINAPI *cmsGnGetAxisMap)		(__in LONG BoardId, __out	LONG* AxisMapMask);

// Network Servo Ķ͸ մϴ.
// [IN] Axis, [IN] PrmNo1, [IN] PrmData1, [IN] PrmNo2, [IN] PrmData2
EXTERN LONG 	(WINAPI *cmsGnSetParam) 		(__in LONG BoardId, __in LONG Axis, __in LONG PrmNo1, __in LONG PrmData1, __in LONG PrmNo2, __in LONG PrmData2);

// Network Servo Ķ͸ ɴϴ.
// [IN] Axis, [IN] PrmNo1, [OUT] pPrmData1, [IN] PrmNo2, [OUT] pPrmData2
EXTERN LONG 	(WINAPI *cmsGnGetParam) 		(__in LONG BoardId, __in LONG Axis, __in LONG PrmNo1, __out PLONG pPrmData1, __in LONG PrmNo2, __out PLONG pPrmData2);

// Network Servo ġ ڴ մϴ.( Ķ͵ ˴ϴ.)
EXTERN LONG		(WINAPI *cmsGnSetABSMode)		(__in LONG BoardId, __in LONG Axis, __in LONG EncoderMode);

// Network Servo ġ ڴ ȯմϴ.
EXTERN LONG		(WINAPI *cmsGnGetABSMode)		(__in LONG BoardId, __in LONG Axis, __out PLONG EncoderMode);

// Network Servo Driver ġ  о մϴ.
EXTERN LONG		(WINAPI *cmsGnABSUpdate)		(__in LONG BoardId);

EXTERN LONG		(WINAPI *cmsGnSetABSHome)		(__in LONG BoardId, __in LONG Axis);
// Network Servo  带 մϴ.(ġ, ũ)
EXTERN LONG		(WINAPI *cmsGnSetControlMode)	(__in LONG BoardId, __in LONG Axis, __in LONG ControlMode);

// Network Servo  带 ȯմϴ.(ġ, ӵ, ũ)
EXTERN LONG		(WINAPI *cmsGnGetControlMode)	(__in LONG BoardId, __in LONG Axis, __out PLONG ControlMode);

// Network Servo ġ   ũ  带 մϴ.
EXTERN LONG		(WINAPI *cmsGnSetPositionTorqueMode) (__in LONG BoardId, __in LONG Axis, __in LONG Enable);

// Network Servo ġ   ũ  带 ȯմϴ.
EXTERN LONG		(WINAPI *cmsGnGetPositionTorqueMode) (__in LONG BoardId, __in LONG Axis, __out PLONG Enable);

// Network Servo ˶ڵ带 ȯմϴ.
EXTERN LONG		(WINAPI *cmsGnGetAlarmCode)		(__in LONG BoardId, __in LONG Axis, __out PLONG AlmCode);

// Network Servo ڴ ش ȯմϴ.
EXTERN LONG		(WINAPI *cmsGnGetEncResolution)	(__in LONG BoardId, __in LONG Axis, __out PLONG Resolution);

// Network Servo  ȯմϴ.
EXTERN LONG		(WINAPI *cmsGnGetServoLoad)		(__in LONG BoardId, __in LONG Axis, __out PLONG RegenLoad, __out PLONG EffectLoad, __out PLONG PeakLoad);

EXTERN LONG		(WINAPI *cmsGnGetServoRev)		(__in LONG BoardId, __in LONG Axis, __out PLONG RevCnt, __out PLONG CmdCnt);

// Network Servo ڱ մϴ.
EXTERN LONG		(WINAPI *cmsGnSetElectronicGearRatio) (__in LONG BoardId, __in LONG Axis, __in LONG CMX, __in LONG CDV);

// Network Servo ڱ ȯմϴ.
EXTERN LONG		(WINAPI *cmsGnGetElectronicGearRatio) (__in LONG BoardId, __in LONG Axis, __out PLONG CMX, __out PLONG CDV);
//////////////////////////////////////////////////////////////////////////
// Cfg Functions
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PropId :  id մϴ, [IN] VT_I4 PropVal :  id 
EXTERN	LONG	(WINAPI *cmsCfgSetMioProperty)		(__in LONG BoardId, __in	LONG Axis, __in LONG PropId, __in  LONG  PropVal);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PropId :  id մϴ, [OUT] VT_PI4 PropVal :  id 
EXTERN	LONG	(WINAPI *cmsCfgGetMioProperty)		(__in LONG BoardId, __in	LONG Axis, __in LONG PropId, __out PLONG PropVal);

EXTERN	LONG	(WINAPI *cmsCfgSetUnitDist)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE UnitDist);
EXTERN	LONG	(WINAPI *cmsCfgGetUnitDist)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE * UnitDist);
EXTERN	LONG	(WINAPI *cmsCfgSetUnitSpeed)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE UnitSpeed);
EXTERN	LONG	(WINAPI *cmsCfgGetUnitSpeed)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE * UnitSpeed);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 SpeedMode([0]Constant, [1]Trapezoidal, [2]S-Curve) [IN] VT_R8 Work/Workspeed, [IN] VT_R8 Acc/Acceleration , [IN] VT_R8 Dec/Deceleration, [IN] VT_R8 Ini/IniSpeed, [IN] VT_R8 End/EndSpeed 
EXTERN  LONG    (WINAPI *cmsCfgSetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __in LONG SpeedMode, __in DOUBLE Work, __in DOUBLE Acc, __in DOUBLE Dec, __in DOUBLE Ini, __in DOUBLE End);	

// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 SpeedMode([0]Constant, [1]Trapezoidal, [2]S-Curve) [OUT] VT_PR8 Work/Workspeed, [OUT] VT_PR8 Acc/Acceleration , [OUT] VT_PR8 Dec/Deceleration, [OUT] VT_PR8 Ini/IniSpeed, [OUT] VT_PR8 End/EndSpeed 
EXTERN  LONG    (WINAPI *cmsCfgGetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __out PLONG SpeedMode, __out DOUBLE * Work, __out DOUBLE * Acc, __out DOUBLE * Dec, __out DOUBLE * Ini, __out DOUBLE * End);

EXTERN LONG		(WINAPI *cmsCfgSetSpeedPattern_T)	(__in LONG BoardId, __in LONG Axis, __in LONG SpeedMode, __in DOUBLE Work, __in DOUBLE AccTime, __in DOUBLE DecTime, __in DOUBLE Ini, __in DOUBLE End);
EXTERN LONG		(WINAPI *cmsCfgGetSpeedPattern_T) (__in LONG BoardId, __in LONG Axis, __out PLONG SpeedMode, __out DOUBLE * Work, __out DOUBLE * AccTime, __out DOUBLE * DecTime, __out DOUBLE * Ini, __out DOUBLE * End);

// [IN] VT_I4 Axis : ȣ, [OUT] VT_I4 IsEnable : Ʈ   Ȱȭ θ մϴ, [IN] VT_R8 LimitN : (-) Limit, [IN] VT_R8 LimitP : (+) Limit
EXTERN	LONG	(WINAPI *cmsCfgSetSoftLimit)		(__in LONG BoardId, __in LONG Axis, __in LONG IsEnable, __in DOUBLE LimitN, __in DOUBLE LimitP);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_I4 IsEnabled : Ʈ   Ȱȭ θ ȯմϴ, [OUT] VT_R8 LimitN : (-) Limit, [OUT] VT_R8 LimitP : (+) Limit
EXTERN	LONG	(WINAPI *cmsCfgGetSoftLimit)		(__in LONG BoardId, __in LONG Axis, __out PLONG IsEnabled, __out DOUBLE * LimitN, __out DOUBLE * LimitP);

EXTERN LONG		(WINAPI *cmsCfgSetVelCorrRatio)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE CorrRatio);
EXTERN LONG		(WINAPI *cmsCfgGetVelCorrRatio)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE * CorrRatio);

EXTERN LONG 	(WINAPI *cmsCfgSetRingCntr)			(__in LONG BoardId, __in LONG Axis, __in LONG Enable, __in LONG nMinCnt, __in LONG nMaxCnt);
EXTERN LONG 	(WINAPI *cmsCfgGetRingCntr)			(__in LONG BoardId, __in LONG Axis, __out PLONG Enable,  __out PLONG nMinCnt, __out PLONG nMaxCnt);

EXTERN LONG   (WINAPI *cmsLmxGetQSize)  (__in LONG BoardId, __in LONG nLmMap, __out PLONG Resistered, __out PLONG QQuatity, __out PLONG QCapacity);

//////////////////////////////////////////////////////////////////////////
// Sx Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Distance : Ÿ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN	LONG	(WINAPI *cmsSxMove)			(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Distance, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Distance : Ÿ
EXTERN	LONG	(WINAPI *cmsSxMoveStart)		(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Distance);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Position : ġ, [IN] VT_I4  IsBlocking :  ޽ ŷ 
EXTERN	LONG	(WINAPI *cmsSxMoveTo)			(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Position, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 Position : ġ
EXTERN	LONG	(WINAPI *cmsSxMoveToStart)		(__in LONG BoardId, __in	LONG Axis, __in	DOUBLE Position);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 Dir : 
EXTERN	LONG	(WINAPI *cmsSxVMoveStart)		(__in LONG BoardId, __in	LONG Axis, __in LONG Dir);
// [IN] VT_I4 Axis : ȣ
EXTERN  LONG	(WINAPI *cmsSxStop)			(__in LONG BoardId, __in	LONG Axis);
// [IN] VT_I4 Axis : ȣ
EXTERN	LONG	(WINAPI *cmsSxStopEmg)			(__in LONG BoardId, __in	LONG Axis);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 pdwIsDone : ̼ ϷǾ ȯ(0:̼, 1:̼ۿϷ)
EXTERN	LONG	(WINAPI *cmsSxIsDone)			(__in LONG BoardId, __in	LONG Axis, __out PLONG pdwIsDone);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsBlocking :  ޼ ŷ 
EXTERN  LONG	(WINAPI *cmsSxWaitDone)		(__in LONG BoardId, __in	LONG Axis, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 CorrMode :     (0:  Ȱȭ, 1: 鷡  , 2:   ), [IN] VT_R8 CorrAmount :  ޽  ( Ÿ ), [IN] VT_I4 CntrMask :  ޽ ½ÿ  ī    (BIT0 1: Command Counter , BIT1 1: Feedback Counter , BIT2 1: Deviation Counter , BIT3 1: General Counter )
EXTERN	LONG	(WINAPI *cmsSxSetCorrection)		(__in LONG BoardId, __in	LONG Axis, __in  LONG CorrMode,	__in  DOUBLE   CorrAmount,__in   DOUBLE   CorrVel, __in  LONG  CntrMask);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 CorrMode :   ȯ  (0:  Ȱȭ, 1: 鷡  , 2:   ), [IN] VT_R8 CorrAmount :  ޽  ( Ÿ ), [IN] VT_I4 CntrMask :  ޽ ½ÿ  ī    (BIT0 1: Command Counter , BIT1 1: Feedback Counter , BIT2 1: Deviation Counter , BIT3 1: General Counter )
EXTERN	LONG	(WINAPI *cmsSxGetCorrection)		(__in LONG BoardId, __in	LONG Axis, __out PLONG CorrMode,__out DOUBLE * CorrAmount, __out DOUBLE * CorrVel, __out PLONG CntrMask);

//////////////////////////////////////////////////////////////////////////
// Mx Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 DistList : Ÿ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmsMxMove)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * DistList, __in LONG IsBlocking);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 DistList : Ÿ Ʈ
EXTERN LONG	(WINAPI *cmsMxMoveStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * DistList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 PosList : ġ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmsMxMoveTo)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * PosList, __in LONG IsBlocking);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PR8 PosList : ġ Ʈ
EXTERN LONG	(WINAPI *cmsMxMoveToStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in DOUBLE * PosList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_PI4 DirList :  Ʈ
EXTERN LONG	(WINAPI *cmsMxVMoveStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in PLONG DirList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList :   ȣ Ʈ
EXTERN LONG	(WINAPI *cmsMxStop)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList :   ȣ Ʈ
EXTERN LONG	(WINAPI *cmsMxStopEmg)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_I4 IsDone: Ϸ 
EXTERN LONG	(WINAPI *cmsMxIsDone)			(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __out PLONG IsDone);
// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 AxisList : ϴ  ȣ Ʈ, [IN] VT_I4  IsBlocking :  ޽ ŷ  
EXTERN LONG	(WINAPI *cmsMxWaitDone)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG AxisList, __in LONG IsBlocking);

//////////////////////////////////////////////////////////////////////////
// Ix Control
//////////////////////////////////////////////////////////////////////////

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 MapMask : ʸũ, [IN] VT_I4 IxMode : ̼  (0:, 1:ȣ, 2:︮ú, 3:öκ)
EXTERN LONG	(WINAPI *cmsIxMapAxes)			(__in LONG BoardId, __in LONG MapIndex, __in LONG MapMask, __in LONG IxMode);
// [IN] VT_I4 MapIndex : ʹȣ
EXTERN LONG	(WINAPI *cmsIxUnMapAxes)		(__in LONG BoardId, __in LONG MapIndex);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 IsVectorSpeed : ǵ (0:ͽǵ , 1:ͽǵ ), [IN] VT_I4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [IN] VT_R8 Ini : ʱӵ, [IN] VT_R8 End : ӵ, [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 Acc : ӵ, [IN] VT_R8 Dec : ӵ
EXTERN LONG	(WINAPI *cmsIxSetSpeedPattern)		(__in LONG BoardId, __in LONG MapIndex, __in  LONG  IsVectorSpeed, __in  LONG  SpeedMode, __in  DOUBLE   Ini, __in  DOUBLE   End, __in  DOUBLE   Vel, __in  DOUBLE Acc, __in  DOUBLE Dec);
// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 IsVectorSpeed : ǵ (0:ͽǵ , 1:ͽǵ ), [OUT] VT_PI4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [OUT] VT_PR8 Ini : ʱӵ, [OUT] VT_PR8 End : ӵ, [OUT] VT_PR8 Vel : ۾ӵ, [OUT] VT_PR8 Acc : ӵ, [OUT] VT_PR8 Dec : ӵ
EXTERN LONG	(WINAPI *cmsIxGetSpeedPattern)		(__in LONG BoardId, __in LONG MapIndex, __out PLONG IsVectorSpeed, __out PLONG SpeedMode, __out DOUBLE * Ini, __out DOUBLE * End, __out DOUBLE * Vel, __out DOUBLE * Acc, __out DOUBLE * Dec);

EXTERN LONG	(WINAPI *cmsIxSetSpeedPattern_T)		(__in LONG BoardId, __in LONG MapIndex, __in LONG IsVectorSpeed, __in LONG SpeedMode, __in DOUBLE Ini, __in DOUBLE End, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime);

EXTERN LONG	(WINAPI *cmsIxGetSpeedPattern_T)		(__in LONG BoardId, __in LONG MapIndex, __out PLONG IsVectorSpeed, __out PLONG SpeedMode, __out DOUBLE * Ini, __out DOUBLE * End, __out DOUBLE * Vel, __out DOUBLE * AccTime, __out DOUBLE * DecTime); 

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 DistList : Ÿ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmsIxLine)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * DistList, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 DistList : Ÿ Ʈ
EXTERN LONG	(WINAPI *cmsIxLineStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * DistList);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 PosList : ġ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmsIxLineTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * PosList, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PR8 PosList : ġ Ʈ
EXTERN LONG	(WINAPI *cmsIxLineToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE * PosList);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmsIxArcA)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE EndAngle, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree)
EXTERN LONG	(WINAPI *cmsIxArcAStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmsIxArcATo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE EndAngle, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 EndAngle : ̼۰(Degree)
EXTERN LONG	(WINAPI *cmsIxArcAToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 XEndPointDist : ǥ ġκ X Ÿ, [IN] VT_R8 YEndPointDist : ǥ ġκ Y Ÿ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmsIxArcP)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE XEndPointDist, __in DOUBLE YEndPointDist, __in LONG Direction, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 YCentOffset :  ġ( ġ)κ  ߽ɱ X ǥ, [IN] VT_R8 XEndPointDist : ǥ ġκ X Ÿ, [IN] VT_R8 YEndPointDist : ǥ ġκ Y Ÿ
EXTERN LONG	(WINAPI *cmsIxArcPStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCentOffset, __in DOUBLE YCentOffset, __in DOUBLE XEndPointDist, __in DOUBLE YEndPointDist, __in LONG Direction);

// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 XEndPos : ǥ X ǥ, [IN] VT_R8 YEndPos : ǥ Y ǥ, [IN] VT_I4 Direction : ȸ(0:ð(CW), 1:ݽð(CCW)), [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmsIxArcPTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE XEndPos, __in DOUBLE YEndPos, __in LONG Direction, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_R8 XCent : ߽ X ǥ, [IN] VT_R8 YCent : ߽ Y ǥ, [IN] VT_R8 XEndPos : ǥ X ǥ, [IN] VT_R8 YEndPos : ǥ Y ǥ, [IN] VT_I4 Direction : ȸ(0:ð(CW), 1:ݽð(CCW))
EXTERN LONG	(WINAPI *cmsIxArcPToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE XCent, __in DOUBLE YCent, __in DOUBLE XEndPos, __in DOUBLE YEndPos, __in LONG Direction);

EXTERN LONG	(WINAPI *cmsIxArc3P)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle, __in LONG IsBlocking);
EXTERN LONG	(WINAPI *cmsIxArc3PStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle);
EXTERN LONG (WINAPI *cmsIxArc3PTo)			(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle, __in LONG IsBlocking);
EXTERN LONG (WINAPI *cmsIxArc3PToStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE P2[], __in DOUBLE P3[], __in DOUBLE EndAngle);

// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 IsDone : ̼ ϷǾ ȯ(0:̼, 1:̼ۿϷ)
EXTERN LONG	(WINAPI *cmsIxIsDone)			(__in LONG BoardId, __in LONG MapIndex, __out LONG *IsDone);
// [IN] VT_I4 MapINdex : ʹȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)
EXTERN LONG	(WINAPI *cmsIxWaitDone) 		(__in LONG BoardId, __in LONG MapIndex, __in  LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_I4 IsWaitComplete : Ϸ  ٸ  , [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmsIxStop) 			(__in LONG BoardId, __in LONG MapIndex, __in  LONG IsWaitComplete, __in LONG IsBlocking);
// [IN] VT_I4 MapIndex : ʹȣ
EXTERN LONG	(WINAPI *cmsIxStopEmg) 		(__in LONG BoardId, __in LONG MapIndex);
// [IN] VT_I4 MapIndex : ʹȣ, [IN] VT_PI4 Helcoord : 3 ǥ 迭, [IN] VT_I4 ArcAngle : ̼۰(degree)
EXTERN LONG	(WINAPI *cmsIxHelOnceStart) 		(__in LONG BoardId, __in LONG MapIndex, __in LONG * HelCoord, __in LONG ArcAngle);
EXTERN LONG	(WINAPI *cmsIxSplineStart)		(__in LONG BoardId, __in LONG MapIndex, __in DOUBLE InArray[20][2], __in LONG  NumInArray, __in LONG NumOutArray);
// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 MapIndex : ش  ϰ ִ MapIndex ȣ
EXTERN LONG	(WINAPI *cmsIxGetMapIndex)		(__in LONG BoardId, __in LONG Axis, __out PLONG MapIndex);

//////////////////////////////////////////////////////////////////////////
// Return to Home
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmsHomeSetOffset)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE Offset);
EXTERN LONG (WINAPI *cmsHomeGetOffset)		(__in LONG BoardId, __in LONG Axis, __out DOUBLE *Offset);

EXTERN LONG	(WINAPI *cmsHomeSetConfig)		(__in LONG BoardId, __in LONG Axis, __in LONG ParamId, __in LONG ParamVal);
EXTERN LONG	(WINAPI *cmsHomeGetConfig)		(__in LONG BoardId, __in LONG Axis, __in LONG ParamId, __out LONG * ParamVal);

EXTERN LONG 	(WINAPI *cmsHomeSetPosClrMode)		(__in LONG BoardId, __in LONG Axis, __in LONG PosClrMode);
EXTERN LONG	(WINAPI *cmsHomeGetPosClrMode)		(__in LONG BoardId, __in LONG Axis, __out PLONG PosClrMode);

EXTERN LONG	(WINAPI *cmsHomeSetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __in LONG PhaseID, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE Accel, __in DOUBLE Decel);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 PhaseID, [IN] VT_I4 SpeedMode : ӵ(0:Constant, 1:Trapezoidal, 2:S-Curve), [IN] VT_R8 Vel : ۾ӵ, [IN] VT_R8 Accel : ӵ, [IN] VT_R8 Decel : ӵ
EXTERN LONG	(WINAPI *cmsHomeGetSpeedPattern)	(__in LONG BoardId, __in LONG Axis, __in LONG PhaseID, __out PLONG SpeedMode, __out DOUBLE * Vel, __out DOUBLE * Accel, __out DOUBLE * Decel);

EXTERN LONG	(WINAPI *cmsHomeSetSpeedPattern_T)		(__in LONG BoardId, __in LONG Axis, __in LONG PhaseID, __in LONG SpeedMode, __in DOUBLE Vel, __in DOUBLE AccTime, __in DOUBLE DecTime);
EXTERN LONG	(WINAPI *cmsHomeGetSpeedPattern_T)		(__in LONG BoardId, __in LONG Axis, __in LONG PhaseID, __in PLONG SpeedMode, __out DOUBLE * Vel, __out DOUBLE * AccTime, __out DOUBLE * DecTime);
 
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmsHomeMove)			(__in LONG BoardId, __in LONG Axis, __in LONG IsBlocking);
// [IN] VT_I4 Axis : ȣ,
EXTERN LONG	(WINAPI *cmsHomeMoveStart)		(__in LONG BoardId, __in LONG Axis);

// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 ChannelList : ϴ  ȣ Ʈ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:) 
EXTERN LONG	(WINAPI *cmsHomeMoveAll)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG ChannelList, __in LONG IsBlocking);

// [IN] VT_I4 NumAxes : ϴ  , [IN] VT_PI4 ChannelList : ϴ  ȣ Ʈ
EXTERN LONG	(WINAPI *cmsHomeMoveAllStart)		(__in LONG BoardId, __in LONG NumAxes, __in PLONG ChannelList);
// [IN] VT_I4 Axis : ȣ, [IN] VT_PI4 : IsBusy :  Ͱ  ȯ(0: , 1:)
EXTERN LONG	(WINAPI *cmsHomeIsBusy)		(__in LONG BoardId, __in LONG Axis, __out PLONG IsBusy);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 IsBlocking :  ޽ (0: , 1:)   
EXTERN LONG	(WINAPI *cmsHomeWaitDone)		(__in LONG BoardId, __in LONG Axis, __in LONG IsBlocking);

EXTERN LONG	(WINAPI *cmsHomeSetSuccess)		(__in LONG BoardId, __in LONG Axis, __in LONG IsSuccess);
EXTERN LONG	(WINAPI *cmsHomeGetSuccess)		(__in LONG BoardId, __in LONG Axis, __out PLONG IsSuccess);

//////////////////////////////////////////////////////////////////////////
// Override Motion
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Axis : ȣ
EXTERN LONG	(WINAPI *cmsOverrideSpeedSet)		(__in LONG BoardId, __in LONG Axis);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 NewDistance : ο ǥ Ÿ, [OUT] VT_PI4 IsIgnored : OverrideMove  /  ȯ  (0:  , 1: )
EXTERN LONG	(WINAPI *cmsOverrideMove)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE NewDistance, __out PLONG IsIgnored);
// [IN] VT_I4 Axis : ȣ, [IN] VT_R8 NewPosition : ο ǥ Ÿ, [OUT] VT_PI4 IsIgnored : OverrideMove  /  ȯ  (0:  , 1: )
EXTERN LONG	(WINAPI *cmsOverrideMoveTo)		(__in LONG BoardId, __in LONG Axis, __in DOUBLE NewPosition, __out PLONG IsIgnored);

//////////////////////////////////////////////////////////////////////////
// Listed Motion
//////////////////////////////////////////////////////////////////////////
EXTERN LONG	(WINAPI *cmsLmxStart)			(__in LONG BoardId, __in LONG	LmIdx, __in LONG LmStartMode, __in LONG AxisMask);
EXTERN LONG	(WINAPI *cmsLmxSuspend)		(__in LONG BoardId, __in LONG	LmIdx, __in LONG SuspendMode);
EXTERN LONG	(WINAPI *cmsLmxResume)			(__in LONG BoardId, __in LONG	LmIdx, __in	LONG ResumeMode);
EXTERN LONG	(WINAPI *cmsLmxEnd)			(__in LONG BoardId, __in LONG	LmIdx);
EXTERN LONG	(WINAPI *cmsLmxGetStates)		(__in LONG BoardId, __in LONG	LmIdx, __in LONG LmStsId, __out PLONG LmxStsVal);

EXTERN LONG (WINAPI *cmsLmxSetSeqMode)		(__in LONG BoardId, __in LONG  LmIdx, __in  LONG SeqMode);
EXTERN LONG	(WINAPI *cmsLmxGetSeqMode)		(__in LONG BoardId, __in LONG  LmIdx, __out  LONG SeqMode);

EXTERN LONG	(WINAPI *cmsLmxSetNextItemId)		(__in LONG BoardId, __in LONG	LmIdx, __in  LONG SeqId);
EXTERN LONG	(WINAPI *cmsLmxGetNextItemId)		(__in LONG BoardId, __in LONG	LmIdx, __out LONG *SeqId);
EXTERN LONG	(WINAPI *cmsLmxSetNextItemParam)	(__in LONG BoardId, __in LONG	LmIdx, __in  LONG ParamIdx, __in  LONG ParamData);
EXTERN LONG	(WINAPI *cmsLmxGetNextItemParam)	(__in LONG BoardId, __in LONG	LmIdx, __in  LONG ParamIdx, __out  PLONG ParamData);
EXTERN LONG	(WINAPI *cmsLmxGetRunItemParam)	(__in LONG BoardId, __in LONG	LmIdx, __in  LONG ParamIdx, __out  PLONG ParamData);

EXTERN LONG	(WINAPI *cmsLmxGetRunItemStaPos)	(__in LONG BoardId, __in LONG 	LmIdx, __in  LONG Axis,     __out DOUBLE * Position);
EXTERN LONG	(WINAPI *cmsLmxGetRunItemTargPos)	(__in LONG BoardId, __in LONG	LmIdx, __in  LONG Axis,     __out DOUBLE * Position);

EXTERN LONG	(WINAPI *cmsLmxSetSeqId)		(__in LONG BoardId, __in LONG LmIdx, __in  LONG SeqId);
EXTERN LONG	(WINAPI *cmsLmxGetSeqId)		(__in LONG BoardId, __in LONG LmIdx, __out PLONG pSeqId);

//////////////////////////////////////////////////////////////////////////



EXTERN LONG (WINAPI *cmsGnInitFromFile)			(__in LONG BoardId, __in char * szFileName);
// Master-Slave
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmsMsRegisterSlave)		(__in LONG BoardId, __in LONG Axis, __in LONG MasterAxis);
EXTERN LONG (WINAPI *cmsMsUnregisterSlave)		(__in LONG BoardId, __in LONG Axis);
EXTERN LONG (WINAPI *cmsMsGetMasterAxis)		(__in LONG BoardId, __in LONG Axis, __out PLONG MasterAxis);

//////////////////////////////////////////////////////////////////////////
// Status Monitoring
//////////////////////////////////////////////////////////////////////////
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_I4 pdwCount :  ī (޽ īƮ)
EXTERN LONG	(WINAPI *cmsStSetCount)		(__in LONG BoardId, __in LONG Axis, __in LONG Source, __in  LONG pdwCount);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [OUT] VT_PI4 pdwcount : ī (޽ īƮ)
EXTERN LONG	(WINAPI *cmsStGetCount)		(__in LONG BoardId, __in LONG Axis, __in LONG Source, __out PLONG pdwCount);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [IN] VT_PI4 pdwcount : ī ( īƮ)
EXTERN LONG	(WINAPI *cmsStSetPosition)		(__in LONG BoardId, __in LONG Axis, __in LONG Source, __in  DOUBLE Count);
// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [OUT] VT_PI4 pdwcount : ī ( īƮ)
EXTERN LONG	(WINAPI *cmsStGetPosition)		(__in LONG BoardId, __in LONG Axis, __in LONG Source, __out DOUBLE * Count);

// [IN] VT_I4 Axis : ȣ, [IN] VT_I4 Source : ī ȣ(0:Command Counter, 1:Feedback Counter), [OUT] VT_PR8 Speed :  ӵ ( ӵ)
EXTERN LONG	(WINAPI *cmsStGetSpeed)		(__in LONG BoardId, __in LONG Axis, __in LONG Source, __out DOUBLE * Speed);

EXTERN LONG	(WINAPI *cmsStSetTorque)			(__in LONG BoardId, __in LONG Axis, __in LONG Torque);

EXTERN LONG	(WINAPI *cmsStGetTorque)			(__in LONG BoardId, __in LONG Axis, __out LONG * Torque);

EXTERN LONG	(WINAPI *cmsStSetTorqueVelLimit)	(__in LONG BoardId, __in LONG Axis, __in LONG TorqueVelLimit);

EXTERN LONG	(WINAPI *cmsStGetTorqueVelLimit)	(__in LONG BoardId, __in LONG Axis, __out LONG * TorqueVelLimit);

EXTERN LONG (WINAPI *cmsStSetTorqueLimit)		(__in LONG BoardId, __in LONG Axis, __in LONG nDir, __in LONG TorqueLimit);

EXTERN LONG (WINAPI *cmsStGetTorqueLimit)		(__in LONG BoardId, __in LONG Axis, __in LONG nDir, __out PLONG TorqueLimit);

EXTERN LONG (WINAPI *cmsStSetVelocity)			(__in LONG BoardId, __in LONG Axis, __in LONG Velocity);

EXTERN LONG (WINAPI *cmsStGetVelocity)			(__in LONG BoardId, __in LONG Axis, __out LONG * Velocity);

// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 MotStates
EXTERN LONG	(WINAPI *cmsStSxReadMotionState)	(__in LONG BoardId, __in LONG Axis, __out PLONG MotStates);
// [IN] VT_I4 MapIndex : ʹȣ, [OUT] VT_PI4 MotStates
EXTERN LONG	(WINAPI *cmsStIxReadMotionState)	(__in LONG BoardId, __in LONG MapIndex, __out PLONG MotStates);

// [IN] VT_I4 Axis : ȣ, [OUT] VT_PI4 MioStates : Machine I/O 
EXTERN LONG 	(WINAPI *cmsStReadMioStatuses)		(__in LONG BoardId, __in LONG Axis, __out PLONG MioStates);

EXTERN LONG	(WINAPI *cmsStGetMotionMode)		(__in LONG BoardId, __in LONG Axis, __out PLONG Mode);

EXTERN LONG	(WINAPI *cmsStSxGetLastError)		(__in LONG BoardId, __in LONG Axis, __out PLONG LastError);

EXTERN LONG	(WINAPI *cmsStIxGetLastError)		(__in LONG BoardId, __in LONG MapIndex,__out PLONG LastError);

EXTERN LONG (WINAPI *cmsStSetMultiRevCnt)		(__in LONG BoardId, __in LONG Axis, __in LONG MultiRevCnt);
EXTERN LONG (WINAPI *cmsStGetMultiRevCnt)		(__in LONG BoardId, __in LONG Axis, __out PLONG pMultiRevCnt);

EXTERN LONG (WINAPI *cmsStSetOneRevPos)			(__in LONG BoardId, __in LONG Axis, __in LONG OneRevPos);
EXTERN LONG (WINAPI *cmsStGetOneRevPos)			(__in LONG BoardId, __in LONG Axis, __out PLONG pOneRevPos);

EXTERN LONG (WINAPI *cmsStGetAbsHomeRequest)	(__in LONG BoardID, __in LONG Axis, __out PLONG IsRequest);

//////////////////////////////////////////////////////////////////////////
// Advanced Function
//////////////////////////////////////////////////////////////////////////

// [RTS Update Functions]
// RTS Structure ּҸ RtsData Structure Pointer ȯմϴ.
EXTERN LONG	(WINAPI *cmsAdvGetRtsMemPtr)			(__in LONG BoardId, __out cmsRtsData** ppMemPtr);

// RTS Update  Ȱȭ Ұ Ͽ ϰ  RTS Update Ȱ ¸ ȯմϴ.
EXTERN LONG	(WINAPI *cmsAdvSetRtsEnable)			(__in LONG BoardId, __in LONG IsEnable);
EXTERN LONG	(WINAPI *cmsAdvGetRtsEnable)			(__in LONG BoardId, __out LONG *pIsEnable);

// ش Node RTS Update   Ͽ ϰ  Node RTS Update ¸ ȯմϴ.
EXTERN LONG	(WINAPI *cmsAdvSetRtsMode)				(__in LONG BoardId, __in LONG NodeId, __in LONG IsEnable);
EXTERN LONG	(WINAPI *cmsAdvGetRtsMode)				(__in LONG BoardId, __in LONG NodeId, __out LONG *pIsEnable);

// RTS Structure Update Interval  Ǵ ȯմϴ.
EXTERN LONG	(WINAPI *cmsAdvSetRtsUpdateInterval)	(__in LONG BoardId, __in LONG RtsUpdateInterval);
EXTERN LONG	(WINAPI *cmsAdvGetRtsUpdateInterval)	(__in LONG BoardId, __out PLONG pRtsUpdateInterval);

// [Command Acknowledge Setting Functions]
// API Լ  带 ϰ   带 ȯմϴ.
EXTERN LONG 	(WINAPI *cmsAdvSetCmdAckMode)		(__in LONG BoardId, __in LONG AckMode);
EXTERN LONG 	(WINAPI *cmsAdvGetCmdAckMode) 		(__in LONG BoardId, __out PLONG pAckMode);

// [NEMO Firmware Functions(Undocumented)]
EXTERN LONG	(WINAPI *cmsAdvFwGetVersion)		(__in LONG BoardId, __out PLONG VersionMS, __out PLONG VersionLS);
EXTERN LONG	(WINAPI *cmsAdvFwGetSystemState)	(__in LONG BoardId, __out PLONG State);
EXTERN LONG	(WINAPI *cmsAdvFwDnFrame)			(__in LONG BoardId, __in LONG FrameType, __in PLONG FrameData, __in LONG FrameSize);
EXTERN LONG	(WINAPI *cmsAdvFwDnFrameVerify)		(__in LONG BoardId, __in LONG FrameType, __in PLONG FrameData, __in LONG FrameSize);
EXTERN LONG	(WINAPI *cmsAdvFwSystemReset)		(__in LONG BoardId, __in LONG IsReset);
EXTERN LONG	(WINAPI *cmsAdvFwSetFwuBit)			(__in LONG BoardId, __in LONG IsAnswer, __in LONG Value);
EXTERN LONG	(WINAPI *cmsAdvFwGetFwuBit)			(__in LONG BoardId, __in LONG IsAnswer, __out PLONG pValue);
EXTERN LONG	(WINAPI *cmsAdvFwSetBootFlag)		(__in LONG BoardId, __in LONG Value);
EXTERN LONG	(WINAPI *cmsAdvFwGetBootFlag)		(__in LONG BoardId, __out PLONG pValue);
EXTERN LONG	(WINAPI *cmsAdvFwUpdateMode)		(__in LONG BoardId, __in LONG IsEnable);
EXTERN LONG	(WINAPI *cmsAdvFwGetStatistics)		(__in LONG BoardId, __out cmsTNCFWStatistics* pValue);

EXTERN LONG (WINAPI *cmsAdvFlsWrite)			(__in LONG BoardId, __in LONG nSector, __in LONG nBlock, __in LONG nWriteSize, __in PLONG WriteData);
EXTERN LONG	(WINAPI *cmsAdvFlsRead)				(__in LONG BoardId, __in LONG nSector, __in LONG nBlock, __in LONG nReadSize, __out PLONG ReadData);
EXTERN LONG	(WINAPI *cmsAdvFlsErase)			(__in LONG BoardId, __in LONG nSector);

EXTERN LONG (WINAPI *cmsAdvNDbgSet)				(__in LONG BoardId, __in LONG MainId, __in LONG SubId, __in LONG Data);
EXTERN LONG (WINAPI *cmsAdvNDbgGet)				(__in LONG BoardId, __in LONG MainId, __in LONG SubId, __out PLONG Data);

EXTERN LONG (WINAPI *cmsAdvFWVSet) 				(__in LONG BoardId, __in LONG MainId, __in LONG SubId, __in LONG Data);
EXTERN LONG (WINAPI *cmsAdvFWVGet)				(__in LONG BoardId, __in LONG MainId, __in LONG SubId, __out PLONG Data);

#ifdef __cplusplus
}
#endif


#endif
