/*******************************************************************************
* [ ComiSSCNET3_SDK.cpp ]
* CPP file for definitions of constants and data in SSCNET-3 SDK library
* - Update Data: 2016/06/04
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr, http://www.comizoa.com
********************************************************************************/

#include "stdafx.h"

#if defined(__BCPLUSPLUS__)  // Borland C++ Builder specific
 #include <vcl.h>
 #pragma hdrstop
#endif

#include <windows.h>
#include <stdio.h>

#define _DLL_MAIN_CPP_
#include "ComiSSCNET3_SDK.h"

#if defined(_WIN64)
#ifdef UNICODE
#define __DLL_FILE_FULL_PATH__ L"ComiSSCNET3_x64.DLL"
#else
#define __DLL_FILE_FULL_PATH__ "ComiSSCNET3_x64.DLL"
#endif
#else
#ifdef UNICODE
#define __DLL_FILE_FULL_PATH__ L"ComiSSCNET3.DLL"
#else
#define __DLL_FILE_FULL_PATH__ "ComiSSCNET3.DLL"
#endif
#endif

typedef struct{
	char *name;
	FARPROC* ptr;
}LIB_FUNCT;

static HINSTANCE hLibrary=NULL;

BOOL cmsLoadDll(void)
{
	LIB_FUNCT Func[] = {

		//////////////////////////////////////////////////////////////////////////
		// Device Load / Unload
		//////////////////////////////////////////////////////////////////////////
		{"GnLoadDevice", 	(FARPROC*)&cmsGnLoadDevice},
		{"GnUnloadDevice", 	(FARPROC*)&cmsGnUnloadDevice},

		{"GnLoadParameter",		(FARPROC*)&cmsGnLoadParameter},

		{"GnSetLogMode",		(FARPROC*)&cmsGnSetLogMode},
		{"GnGetLogMode",		(FARPROC*)&cmsGnGetLogMode},

		{"GnSetLogLevel",		(FARPROC*)&cmsGnSetLogLevel},
		{"GnGetLogLevel",		(FARPROC*)&cmsGnGetLogLevel},
		
		{"GnSetFuncLevel",		(FARPROC*)&cmsGnSetFuncLevel},
		{"GnRestoreFuncLevel",	(FARPROC*)&cmsGnRestoreFuncLevel},
		{"GnGetFuncLevel",		(FARPROC*)&cmsGnGetFuncLevel},
		
		//////////////////////////////////////////////////////////////////////////
		// Network Motion Controller Raw Function
		//////////////////////////////////////////////////////////////////////////
		{"GetResources",	(FARPROC*)&cmsGetResources},
		{"WriteMemPortDW",  (FARPROC*)&cmsWriteMemPortDW},
		{"ReadMemPortDW",	(FARPROC*)&cmsReadMemPortDW},
		{"DpramRead",		(FARPROC*)&cmsDpramRead},
		{"DpramWrite",		(FARPROC*)&cmsDpramWrite},
		{"DpramBusyEnable",	(FARPROC*)&cmsDpramBusyEnable},
		{"DpramBusyDisable",	(FARPROC*)&cmsDpramBusyDisable},

		//////////////////////////////////////////////////////////////////////////
		// Network Motion Controller High Level API Function
		//////////////////////////////////////////////////////////////////////////
		{"GnSetCommStates",	(FARPROC*)&cmsGnSetCommStates},
		{"GnGetCommStates", 	(FARPROC*)&cmsGnGetCommStates},

		{"GnResetComm", 	(FARPROC*)&cmsGnResetComm},
	
		{"GnSetServoOn",	(FARPROC*)&cmsGnSetServoOn},
		{"GnGetServoOn",	(FARPROC*)&cmsGnGetServoOn},

		{"GnSetAlarmRes",	(FARPROC*)&cmsGnSetAlarmRes},
		{"GnGetAlarmRes",	(FARPROC*)&cmsGnGetAlarmRes},

		{"GnSetEmergency",	(FARPROC*)&cmsGnSetEmergency},
		{"GnGetEmergency",	(FARPROC*)&cmsGnGetEmergency},

		{"GnSetEmergencyAll",	(FARPROC*)&cmsGnSetEmergencyAll},
		{"GnGetEmergencyAll",	(FARPROC*)&cmsGnGetEmergencyAll},

		{"GnSetCommPeriod",	(FARPROC*)&cmsGnSetCommPeriod},
		{"GnGetCommPeriod",	(FARPROC*)&cmsGnGetCommPeriod},

		{"GnResetDevice",	(FARPROC*)&cmsGnResetDevice},

		{"GnSetStatusUpdateInterval", (FARPROC*)&cmsGnSetStatusUpdateInterval},
		{"GnGetStatusUpdateInterval", (FARPROC*)&cmsGnGetStatusUpdateInterval},

		{"GnGetAxisMap",		(FARPROC*)&cmsGnGetAxisMap},
		
		{"GnSetParam540", 		(FARPROC*)&cmsGnSetParam},
		{"GnGetParam540", 		(FARPROC*)&cmsGnGetParam},
		{"GnSetABSMode",		(FARPROC*)&cmsGnSetABSMode},
		{"GnGetABSMode",		(FARPROC*)&cmsGnGetABSMode},
		{"GnABSUpdate",			(FARPROC*)&cmsGnABSUpdate},

		{"GnSetABSHome",		(FARPROC*)&cmsGnSetABSHome},

		{"GnSetControlMode",	(FARPROC*)&cmsGnSetControlMode},
		{"GnGetControlMode",	(FARPROC*)&cmsGnGetControlMode},

		{"GnSetPositionTorqueMode", (FARPROC*)&cmsGnSetPositionTorqueMode},
		{"GnGetPositionTorqueMode", (FARPROC*)&cmsGnGetPositionTorqueMode},
		
		{"GnGetAlarmCode",			(FARPROC*)&cmsGnGetAlarmCode},

		{"GnGetEncResolution",			(FARPROC*)&cmsGnGetEncResolution},
		{"GnGetServoLoad",		(FARPROC*)&cmsGnGetServoLoad},
		{"GnGetServoRev",		(FARPROC*)&cmsGnGetServoRev},
		{"GnSetElectronicGearRatio", (FARPROC*)&cmsGnSetElectronicGearRatio},
		{"GnGetElectronicGearRatio", (FARPROC*)&cmsGnGetElectronicGearRatio},
		//////////////////////////////////////////////////////////////////////////
		// Cfg function
		//////////////////////////////////////////////////////////////////////////
		{"CfgSetMioProperty",  (FARPROC*)&cmsCfgSetMioProperty},
		{"CfgGetMioProperty",  (FARPROC*)&cmsCfgGetMioProperty},

		{"CfgSetUnitDist",	   (FARPROC*)&cmsCfgSetUnitDist},
		{"CfgGetUnitDist",	   (FARPROC*)&cmsCfgGetUnitDist},

		{"CfgSetUnitSpeed",	   (FARPROC*)&cmsCfgSetUnitSpeed},
		{"CfgGetUnitSpeed",	   (FARPROC*)&cmsCfgGetUnitSpeed},

		{"CfgSetSpeedPattern", (FARPROC*)&cmsCfgSetSpeedPattern},
		{"CfgGetSpeedPattern", (FARPROC*)&cmsCfgGetSpeedPattern},

		{"CfgSetSpeedPattern_T", (FARPROC*)&cmsCfgSetSpeedPattern_T},
		{"CfgGetSpeedPattern_T", (FARPROC*)&cmsCfgGetSpeedPattern_T},
		
		{"CfgSetSoftLimit",	   (FARPROC*)&cmsCfgSetSoftLimit},
		{"CfgGetSoftLimit",	   (FARPROC*)&cmsCfgGetSoftLimit},

		{"CfgSetVelCorrRatio",	   (FARPROC*)&cmsCfgSetVelCorrRatio},
		{"CfgGetVelCorrRatio",	   (FARPROC*)&cmsCfgGetVelCorrRatio},

		{"CfgSetRingCntr",		(FARPROC*)&cmsCfgSetRingCntr},
		{"CfgGetRingCntr",		(FARPROC*)&cmsCfgGetRingCntr},
		//////////////////////////////////////////////////////////////////////////
		// Sx Control
		//////////////////////////////////////////////////////////////////////////
		{"SxMove",			(FARPROC*)&cmsSxMove},
		{"SxMoveStart",		(FARPROC*)&cmsSxMoveStart},
		{"SxMoveTo",		(FARPROC*)&cmsSxMoveTo},
		{"SxMoveToStart",	(FARPROC*)&cmsSxMoveToStart},
		{"SxMoveToStart_ODM",	(FARPROC*)&cmsSxMoveToStart_ODM},
		{"SxVMoveStart",	(FARPROC*)&cmsSxVMoveStart},
		{"SxStop",          (FARPROC*)&cmsSxStop},
		{"SxStopEmg",       (FARPROC*)&cmsSxStopEmg},
		{"SxIsDone",		(FARPROC*)&cmsSxIsDone},
		{"SxWaitDone",		(FARPROC*)&cmsSxWaitDone},

		{"SxSetCorrection", (FARPROC*)&cmsSxSetCorrection},
		{"SxGetCorrection", (FARPROC*)&cmsSxGetCorrection},

		//////////////////////////////////////////////////////////////////////////
		// Mx Control
		//////////////////////////////////////////////////////////////////////////
		{"MxMove",			(FARPROC*)&cmsMxMove},
		{"MxMoveStart",		(FARPROC*)&cmsMxMoveStart},
		{"MxMoveTo",		(FARPROC*)&cmsMxMoveTo},
		{"MxMoveToStart",	(FARPROC*)&cmsMxMoveToStart},
		{"MxVMoveStart",	(FARPROC*)&cmsMxVMoveStart},
		{"MxStop",			(FARPROC*)&cmsMxStop},
		{"MxStopEmg",		(FARPROC*)&cmsMxStopEmg},
		{"MxIsDone",		(FARPROC*)&cmsMxIsDone},
		{"MxWaitDone",		(FARPROC*)&cmsMxWaitDone},

		//////////////////////////////////////////////////////////////////////////
		// Ix Control
		//////////////////////////////////////////////////////////////////////////
		{"IxMapAxes",		 (FARPROC*)&cmsIxMapAxes},
		{"IxUnMapAxes",		 (FARPROC*)&cmsIxUnMapAxes},
		
		{"IxSetSpeedPattern",(FARPROC*)&cmsIxSetSpeedPattern},
		{"IxGetSpeedPattern",(FARPROC*)&cmsIxGetSpeedPattern},
		
		{"IxSetSpeedPattern_T", (FARPROC*)&cmsIxSetSpeedPattern_T},
		{"IxGetSpeedPattern_T", (FARPROC*)&cmsIxGetSpeedPattern_T},

		{"IxLine",			 (FARPROC*)&cmsIxLine},
		{"IxLineStart",		 (FARPROC*)&cmsIxLineStart},

		{"IxLineTo",		 (FARPROC*)&cmsIxLineTo},
		{"IxLineToStart",	 (FARPROC*)&cmsIxLineToStart},

		{"IxArcA",			 (FARPROC*)&cmsIxArcA},
		{"IxArcAStart",		 (FARPROC*)&cmsIxArcAStart},

		{"IxArcATo",		 (FARPROC*)&cmsIxArcATo},
		{"IxArcAToStart",	 (FARPROC*)&cmsIxArcAToStart},

		{"IxArcP",			 (FARPROC*)&cmsIxArcP},
		{"IxArcPStart",		 (FARPROC*)&cmsIxArcPStart},

		{"IxArcPTo",		 (FARPROC*)&cmsIxArcPTo},
		{"IxArcPToStart",	 (FARPROC*)&cmsIxArcPToStart},

		{"IxArc3P",			 (FARPROC*)&cmsIxArc3P},
		{"IxArc3PStart",	 (FARPROC*)&cmsIxArc3PStart},

		{"IxArc3PTo",		 (FARPROC*)&cmsIxArc3PTo},
		{"IxArc3PToStart",	 (FARPROC*)&cmsIxArc3PToStart},

		{"IxIsDone",		 (FARPROC*)&cmsIxIsDone},
		{"IxWaitDone",		 (FARPROC*)&cmsIxWaitDone},

		{"IxStop",			 (FARPROC*)&cmsIxStop},
		{"IxStopEmg",		 (FARPROC*)&cmsIxStopEmg},

		{"IxHelOnceStart",	 (FARPROC*)&cmsIxHelOnceStart},
		{"IxSplineStart",    (FARPROC*)&cmsIxSplineStart},
		
		{"IxGetMapIndex",	 (FARPROC*)&cmsIxGetMapIndex},

		//////////////////////////////////////////////////////////////////////////
		// Return To Home
		//////////////////////////////////////////////////////////////////////////
		{"HomeSetConfig",		(FARPROC*)&cmsHomeSetConfig},
		{"HomeGetConfig",		(FARPROC*)&cmsHomeGetConfig},

		{"HomeSetOffset",		(FARPROC*)&cmsHomeSetOffset},
		{"HomeGetOffset",		(FARPROC*)&cmsHomeGetOffset},

		{"HomeSetSpeedPattern",	(FARPROC*)&cmsHomeSetSpeedPattern},
		{"HomeGetSpeedPattern",	(FARPROC*)&cmsHomeGetSpeedPattern},

		{"HomeSetSpeedPattern_T", (FARPROC*)&cmsHomeSetSpeedPattern_T},
		{"HomeGetSpeedPattern_T", (FARPROC*)&cmsHomeGetSpeedPattern_T},

		{"HomeMove",			(FARPROC*)&cmsHomeMove},
		{"HomeMoveStart",		(FARPROC*)&cmsHomeMoveStart},

		{"HomeMoveAll",			(FARPROC*)&cmsHomeMoveAll},
		{"HomeMoveAllStart",	(FARPROC*)&cmsHomeMoveAllStart},

		{"HomeIsBusy",			(FARPROC*)&cmsHomeIsBusy},
		{"HomeWaitDone",		(FARPROC*)&cmsHomeWaitDone},

		{"HomeSetSuccess",		(FARPROC*)&cmsHomeSetSuccess},
		{"HomeGetSuccess",	    (FARPROC*)&cmsHomeGetSuccess},

		//////////////////////////////////////////////////////////////////////////
		// Override
		//////////////////////////////////////////////////////////////////////////
		{"OverrideSpeedSet",	(FARPROC*)&cmsOverrideSpeedSet},
		{"OverrideMove",		(FARPROC*)&cmsOverrideMove},
		{"OverrideMoveTo",		(FARPROC*)&cmsOverrideMoveTo},

		//////////////////////////////////////////////////////////////////////////
		// Listed Motion
		//////////////////////////////////////////////////////////////////////////
		{"LmxStart",			(FARPROC*)&cmsLmxStart},
		{"LmxSuspend",			(FARPROC*)&cmsLmxSuspend},
		{"LmxResume",			(FARPROC*)&cmsLmxResume},
		{"LmxEnd",				(FARPROC*)&cmsLmxEnd},
		{"LmxGetStates",		(FARPROC*)&cmsLmxGetStates},

		{"LmxSetSeqMode",		(FARPROC*)&cmsLmxSetSeqMode},
		{"LmxGetSeqMode",		(FARPROC*)&cmsLmxGetSeqMode},

		{"LmxSetNextItemId",	(FARPROC*)&cmsLmxSetNextItemId},
		{"LmxGetNextItemId",	(FARPROC*)&cmsLmxGetNextItemId},
		
		{"LmxSetNextItemParam",	(FARPROC*)&cmsLmxSetNextItemParam},
		{"LmxGetNextItemParam", (FARPROC*)&cmsLmxGetNextItemParam},

		{"LmxGetRunItemParam",	(FARPROC*)&cmsLmxGetRunItemParam},
		{"LmxGetRunItemStaPos", (FARPROC*)&cmsLmxGetRunItemStaPos},
		{"LmxGetRunItemTargPos",(FARPROC*)&cmsLmxGetRunItemTargPos},
		
		{"LmxSetSeqId",			(FARPROC*)&cmsLmxSetSeqId},
		{"LmxGetSeqId",			(FARPROC*)&cmsLmxGetSeqId},
	
		//////////////////////////////////////////////////////////////////////////


		{"GnInitFromFile",		(FARPROC*)&cmsGnInitFromFile},
		// Master-Slave
		//////////////////////////////////////////////////////////////////////////
		{"MsRegisterSlave",		(FARPROC*)&cmsMsRegisterSlave},
		{"MsUnregisterSlave",	(FARPROC*)&cmsMsUnregisterSlave},
		{"MsGetMasterAxis",		(FARPROC*)&cmsMsGetMasterAxis},
	
		//////////////////////////////////////////////////////////////////////////
		// Status Monitoring
		//////////////////////////////////////////////////////////////////////////
		{"StSetCount",          (FARPROC*)&cmsStSetCount},
		{"StGetCount",			(FARPROC*)&cmsStGetCount},

		{"StSetPosition",       (FARPROC*)&cmsStSetPosition},
		{"StGetPosition",		(FARPROC*)&cmsStGetPosition},

		{"StGetSpeed",			(FARPROC*)&cmsStGetSpeed},

		{"StSetTorque",			(FARPROC*)&cmsStSetTorque},
		{"StGetTorque",			(FARPROC*)&cmsStGetTorque},

		{"StSetTorqueVelLimit",	(FARPROC*)&cmsStSetTorqueVelLimit},
		{"StGetTorqueVelLimit",	(FARPROC*)&cmsStGetTorqueVelLimit},

		{"StSetTorqueLimit",	(FARPROC*)&cmsStSetTorqueLimit},
		{"StGetTorqueLimit",	(FARPROC*)&cmsStGetTorqueLimit},

		{"StSetVelocity",		(FARPROC*)&cmsStSetVelocity},
		{"StGetVelocity",		(FARPROC*)&cmsStGetVelocity},

		{"StSxReadMotionState", (FARPROC*)&cmsStSxReadMotionState},
		{"StIxReadMotionState", (FARPROC*)&cmsStIxReadMotionState},

		{"StReadMioStatuses",	(FARPROC*)&cmsStReadMioStatuses},
		{"StGetMotionMode",		(FARPROC*)&cmsStGetMotionMode},

		{"StSxGetLastError",	(FARPROC*)&cmsStSxGetLastError},
		{"StIxGetLastError",	(FARPROC*)&cmsStIxGetLastError},
		
		{"StSetMultiRevCnt",	(FARPROC*)&cmsStSetMultiRevCnt},
		{"StGetMultiRevCnt",	(FARPROC*)&cmsStGetMultiRevCnt},
		
		{"StSetOneRevPos",		(FARPROC*)&cmsStSetOneRevPos},
		{"StGetOneRevPos",		(FARPROC*)&cmsStGetOneRevPos},
		{"StGetAbsHomeRequest",			(FARPROC*)&cmsStGetAbsHomeRequest},

		//////////////////////////////////////////////////////////////////////////
		// Advanced Functions
		//////////////////////////////////////////////////////////////////////////
		{"AdvFwGetVersion",		(FARPROC*)&cmsAdvFwGetVersion},
		{"AdvFwGetSystemState",	(FARPROC*)&cmsAdvFwGetSystemState},
		{"AdvFwDnFrame",		(FARPROC*)&cmsAdvFwDnFrame},
		{"AdvFwDnFrameVerify",	(FARPROC*)&cmsAdvFwDnFrameVerify},		
		{"AdvFwSystemReset",	(FARPROC*)&cmsAdvFwSystemReset},
		{"AdvFwSetFwuBit",		(FARPROC*)&cmsAdvFwSetFwuBit},
		{"AdvFwGetFwuBit",		(FARPROC*)&cmsAdvFwGetFwuBit},
		{"AdvFwSetBootFlag",	(FARPROC*)&cmsAdvFwSetBootFlag},
		{"AdvFwGetBootFlag",	(FARPROC*)&cmsAdvFwGetBootFlag},
		{"AdvFwUpdateMode",		(FARPROC*)&cmsAdvFwUpdateMode},
		{"AdvFwGetStatistics",	(FARPROC*)&cmsAdvFwGetStatistics},
		{"AdvSetRtsEnable",		(FARPROC*)&cmsAdvSetRtsEnable},
		{"AdvGetRtsEnable",		(FARPROC*)&cmsAdvGetRtsEnable},
		{"AdvSetRtsMode",		(FARPROC*)&cmsAdvSetRtsMode},
		{"AdvGetRtsMode",		(FARPROC*)&cmsAdvGetRtsMode},
		{"AdvGetRtsMemPtr",		(FARPROC*)&cmsAdvGetRtsMemPtr},
		{"AdvSetRtsUpdateInterval",		(FARPROC*)&cmsAdvSetRtsUpdateInterval},
		{"AdvGetRtsUpdateInterval",		(FARPROC*)&cmsAdvGetRtsUpdateInterval},
		{"AdvSetCmdAckMode",			(FARPROC*)&cmsAdvSetCmdAckMode},
		{"AdvGetCmdAckMode",			(FARPROC*)&cmsAdvGetCmdAckMode},
		{"AdvFlsWrite",			(FARPROC*)&cmsAdvFlsWrite},
		{"AdvFlsRead",			(FARPROC*)&cmsAdvFlsRead},
		{"AdvFlsErase",			(FARPROC*)&cmsAdvFlsErase},
		{"LmxGetQSize", (FARPROC*)&cmsLmxGetQSize},
		{"AdvNSet",			(FARPROC*)&cmsAdvNDbgSet},
		{"AdvNGet",			(FARPROC*)&cmsAdvNDbgGet},
		{"AdvFWSet",	(FARPROC*)&cmsAdvFWVSet},
		{"AdvFWGet",	(FARPROC*)&cmsAdvFWVGet},
		
		{NULL, NULL}
	};
	
	LIB_FUNCT *f;

	if((hLibrary = LoadLibrary (__DLL_FILE_FULL_PATH__)) == NULL)
	{
		OutputDebugString(L"\n The SSCNET3 SDK DLL not found");
		return FALSE;
	}

	f = &Func[0];
	while(f->ptr != NULL)
	{
		*(f->ptr) = GetProcAddress ((HMODULE)hLibrary, f->name);

#ifdef _DEBUG
		if(*(f->ptr) == NULL){
			char szMessage[1024] = "";
			//sprintf(szMessage,"\n[%08s] function failed to load. LX540 Software Development Kit is incorrectly configured.",f->name);
			//OutputDebugString(szMessage);
		}
#endif
		f++;
	}
	return TRUE;
}

void cmsUnloadDll(void)
{
	if(hLibrary){
		FreeLibrary(hLibrary);
		hLibrary = NULL;
	}
}

