// Initialize.cpp : implementation file
//

#include "stdafx.h"
#include "EtherCAT_Example.h"
#include "Initialize.h"

#include "ComiEcatSdk_Api.h"
#include "ComiEcatSdk_Def.h"
#include "ComiEcatSdk_Err.h"
#include "ComiEcatSdk_SysDef.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Initialize dialog


Initialize::Initialize(CWnd* pParent /*=NULL*/)
	: CDialog(Initialize::IDD, pParent)
{
	//{{AFX_DATA_INIT(Initialize)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void Initialize::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(Initialize)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(Initialize, CDialog)
	//{{AFX_MSG_MAP(Initialize)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Initialize message handlers

int Initialize::DoModal() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CDialog::DoModal();
}

void Initialize::OnButton1() 
{
	// TODO: Add your control notification handler code here
	int netID = 0;
	int errCode;

	ecDll_Load();

	if(ecGn_LoadDevices(&errCode)) {

		// Config  Slave  ȮѴ.
		// Configuration ܰ迡  ̺    ̺ ʹ  .
		int cfgCount = ecNet_GetCfgSlaveCount(netID, &errCode);
		if(errCode != 0)
		{
			MessageBox("Config Slvae  Ȯο Ͽϴ.", "Error");
			return;
		}

		//  Ʈũ Ǿ ִ slvae  ȮѴ.
		int slaveCount = ecNet_ScanSlaves(netID, &errCode);
		if(errCode != 0)
		{
			MessageBox("Config Slvae  Ȯο Ͽϴ.", "Error");
			return;
		}

		//   ŭ ĵǾ ȮѴ.
		if(slaveCount != cfgCount) {
			MessageBox(" ĵ ̺    ̺   ٸϴ.", "Error");
			return ;
		}

		// SW Version(FW, WDM, SDK)  ȣȯǴ  ȮѴ.
		// ȣȯ ʴ  ġǾ ִ     ִ.
		TEcFileVerInfo_FW fwInfo;
		TEcFileVerInfo_SDK sdkInfo;
		TEcFileVerInfo_WDM driverInfo;

		boolean versionComp = ecNet_GetVerInfo(netID, &sdkInfo, &driverInfo, &fwInfo, &errCode);

		if(!versionComp) {
			// FW-SDK ȣȯ 
			switch(sdkInfo.nFwCompResult)
			{
				case ecVER_MISMATCH_LOWER: versionComp = false;
					break;
				case ecVER_MISMATCH_HIGHER: versionComp = false;
					break;
				case ecVER_MATCH: versionComp = true;
					break;
				default: versionComp = false;
					break;
			}

			// FW-WDM ȣȯ 
			switch(driverInfo.nFwCompResult)
			{
				case ecVER_MISMATCH_LOWER: versionComp = false;
					break;
				case ecVER_MISMATCH_HIGHER: versionComp = false;
					break;
				case ecVER_MATCH: versionComp = true;
					break;
				default: versionComp = false;
					break;
			}

			// SDK-WDM ȣȯ 
			switch(sdkInfo.nWdmCompResult)
			{
				case ecVER_MISMATCH_LOWER: versionComp = false;
					break;
				case ecVER_MISMATCH_HIGHER: versionComp = false;
					break;
				case ecVER_MATCH: versionComp = true;
					break;
				default: versionComp = false;
					break;
			}
		}

		//    ִ ȮѴ.

		//    DLL: 1.5.3.2(FW : 1.92 / WDM : 1.5.0.6) ̻󿡼  
		//      ִ ȮѴ.
		CString sdkVer;
		sdkVer.Format("%d%d%d%d", sdkInfo.CurVer.MajorVer, sdkInfo.CurVer.MinorVer, sdkInfo.CurVer.BuildNo, sdkInfo.CurVer.RevNo);
		int curVer = atoi(sdkVer);

		if(curVer < 1532)
		{
			MessageBox("CheckReverseConnection : Not Supported version", "Error");
		}

		int scanSlaveCount = 0;
		int reverseConnectionCount = ecNet_CheckReverseConnections(netID, &scanSlaveCount, &errCode);

		if(reverseConnectionCount != 0) {
			boolean isReverseConnected = false;
			for(int i = 0; i < scanSlaveCount; i++) {
				isReverseConnected = ecSlv_IsReverseConnected_A(netID, i, &errCode);

				if(isReverseConnected) {
					CString temp;
					temp.Format("Check SlaveIndex %d : ReverseConnected", i);
					MessageBox(temp);
				}
					
			}
		}

		//   alState OP Ѵ. 
		// alState OP ƴ ̺ pdo    ʴ´.
		ecNet_SetAlState(netID, ecAL_STATE_OP, &errCode);
		bool alSuccese = true;
		for(int TimeOut = 1000; TimeOut > 0; TimeOut--) {
			alSuccese = true;

			//   alState OP Ǿ ȮѴ.
			for(int i = 0; i < slaveCount; i++) {	
				int alState = ecSlv_GetAlState_A(netID, i, &errCode);

				if(alState != ecAL_STATE_OP || errCode != 0) {
					alSuccese = false;
					break;
				}
			}

			if(alSuccese == true)
				break;

			Sleep(200);
		}

		if(alSuccese)
			MessageBox("Initialize Success" "Success");
		else
			MessageBox("Initialize Fail" "Fail");
	}
}
