// ??-------------------------------------------------------------??
// ??          Copyright (C) 2000-2008 COMIZOA Co., LTD.          ??
// ??-------------------------------------------------------------??

// DATE	: 2018-10-16
// TIME	: 18:02:17



unit ComiEcatSdk;

interface

uses
	Windows,
	Messages,
	SysUtils,
	Classes,
	Graphics,
	Controls,
	Forms,
	Dialogs;

const
//******************************************************************************
//* [ ComiEcatSdk_SysDef.h ]
//* Header file for definitions of constants and data in ComiEcatSdk library
//* - Update Data: 2018/10/16
//* - Provider: COMIZOA Co., Ltd.
//* - Phone: +82-42-936-6500~6
//* - Fax  : +82-42-936-6507
//* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
//*******************************************************************************

	//*******************************************************************************

// Device ID definition //
	DEVID_LX550	=	$A55F;
	DEVID_LX551	=	$A550;
	DEVID_LX552	=	$A551;
	DEVID_LX554	=	$A552;

	ecMAX_NUM_NET_PER_DEVICE		=  2;
	ecMAX_NUM_ONBOARD_INPUT			=  8; // Onboard Digital Input ä 
	ecMAX_NUM_ONBOARD_OUTPUT		=  4;// Onboard Digital Output ä 
	ecMAX_NUM_SLAVES				=  1000;
	ecMAX_NUM_AXES_PER_NET			=  64;  // ϳ Network ϴ ִ    
	ecMAX_NUM_IX_AXES				=  32;  // ϳ ʿ   ִ ִ   
	ecMAX_NUM_SMMU					=  8;
	ecMAX_NUM_FMMU					=  8;
	ecMAX_NUM_PDO_UNIT				=  4; // OutPDO / InPDO  ҴǴ SyncManager ִ밹 (In / Out  Ҵ  ִ ִ  )
	ecMAX_NUM_PDO_ASSIGN			=  8;
	ecMAX_NUM_InQUE_DATA_DESC		=  32; ///< ϳ InQUEäο Ҵ  ִ   ִ 
	ecmMAX_NUM_MOT_IX_MAP			=  32; ///< ִ     
	ecmMAX_NUM_LIST_MOT_MAP			=  8;
	ecmMAX_NUM_PT_MOT_MAP			=  8;
	ecmMAX_NUM_AXES_PER_NET			=  ecMAX_NUM_AXES_PER_NET;
	ecmMAX_NUM_IX_AXES				=  ecMAX_NUM_IX_AXES; // ϳ ʿ   ִ ִ   
	ecmMAX_NUM_PTM_AXES				=  8;	// ϳ PT-Motion ʿ   ִ ִ  
	ecmMAX_NUM_SPLINE_AXES			=  8; 
	ecmMAX_NUM_SPLINE_OBJ			=  100;
	ecmMAX_NUM_SPLINE_INPUT_POINTS	=  10000; 
	ecmMAX_NUM_ATRQ_MULTIVALS		=  1000;	// ִ   AutoTorq  Multi-Value Items  
	ecmMAX_NUM_EMG_INPUTS			=  8;		// ִ   EmgStop Input ä 
	ecmMAX_NUM_COLLAS				=  16;
	ecmMAX_POSCORR_TABLE_SIZE		=  10000; ///<  ະ Ҵ  ִ Position Correction Table ִ ũ 
	ecmMAX_CMPCONT_TABLE_SIZE		=  32768;
	ecmDEFAULT_LM_QUE_DEPTH			=  50000; // default list motion queue depth

	ecVER_MISMATCH_HIGHER	= -2;	// ش    Ǵ ϰ ȣȯ ʴ   Ÿ
	ecVER_MISMATCH_LOWER	= -1;	// ش    Ǵ ϰ ȣȯ ʴ   Ÿ
	ecVER_NOT_FOUND			= 0;	// ش   ã  ( ų,      )
	ecVER_MATCH				= 1;	// ش    Ǵ ϰ ȣȯ Ǵ  Ÿ


	ecFF_TYPE1 = 1;
	ecFF_TYPE2 = 2;

	ecCMD_APRD = $1;
	ecCMD_APWR = $2;
	ecCMD_FPRD = $4;
	ecCMD_FPWR = $5;
	ecCMD_BRD  = $7;
	ecCMD_BWR  = $8;
	ecCMD_LRD  = $a;
	ecCMD_LWR  = $b;
	ecCMD_LRW  = $c;
	ecCMD_ARMW = $d;
	ecCMD_FRMW = $e;

	ecSLV_INFO_VENDOR_ID = 0;
	ecSLV_INFO_PROD_CODE = 1;
	ecSLV_INFO_REV_NO	 = 2;
	ecSLV_INFO_SER_NO	 = 3;



	ecAL_STATE_DISCON	 = 0;
	ecAL_STATE_INITIAL	 = 1;
	ecAL_STATE_PREOP	 = 2;
	ecAL_STATE_BOOTSTRAP = 3;
	ecAL_STATE_SAFEOP	 = 4;
	ecAL_STATE_OP		 = 8;

	ecOPDO_INIT_KEEPLAST = 0;	//  ° ״ Ѵ.
	ecOPDO_INIT_ZERO	 = 1;	//   0 Ѵ.
	ecOPDO_INIT_USERDEF  = 2;	// ڰ ̸  ʱⰪ Ѵ.
	ecOPDO_INIT_INVALID  = 3;

	ecIOCH_TYPE_GLOBAL   = 0;//< Global Channel  (̺ о ӵ ä ȣ οϿ ǥϴ )
	ecIOCH_TYPE_LOCAL	 = 1;//< Local Channel  (̺긦 ϰ, ش ̺   ä ȣ ǥϴ 
	ecIOCH_TYPE_ONBOARD  = 2;//< Onboard Cahnnel (ͺ峻 ϴ I/O ä ǥ) 
	ecIOCH_TYPE_UNDEF	 = 3;//< ä Ư  ʾ ǹ.



	ecDLOG_TYPE_FILE		= 0; // Text file α  ϴ  
	ecDLOG_TYPE_TRACE		= 1; // Debug Ʈ  ؼ α   ִ  
	ecDLOG_TYPE_COMITOOL	= 2; // COMIZOA    Ͽ α  ִ  (     )
	ecDLOG_TYPE_MEMORY		= 3; // ޸𸮿 αϰ ʿÿ ϴ 
	ecDLOG_TYPE_INVALID     = 4;


	ecDLOG_LEVEL_DISALBE	= 0; // No debug logging
	ecDLOG_LEVEL_ERR		= 1; //  ߻  α 
	ecDLOG_LEVEL_CMD		= 2; // ecDLOG_LEVEL_ERR ϸ ؼ Set Լ   Ŀǵ Լ α 
	ecDLOG_LEVEL_GET		= 3; // ecDLOG_LEVEL_CMD ϸ ؼ Get Լ α ( Ϻ  üũ Լ )
	ecDLOG_LEVEL_ALL		= 4; //  Լ ؼ α 
	ecDLOG_LEVEL_INVALID	= 5;

	ecDLOG_ERR_LOG_NONE	= 0; //  ߻ϴ α  ʴ´. 
	ecDLOG_ERR_LOG_CMD	= 1; // Command Լ  ߻  α .
	ecDLOG_ERR_LOG_GET	= 2; //  Լ ؼ  ߻  α .


	ecTRG_MODE_NONE		= 0;	// ƮŸ  .
	ecTRG_MODE_COMMON 	= 1;	//  ä  Ʈ ҽ .   TInPDOQueChannel::Cfg.StaTrg.pCommonTrgSig Ͱ Ű Signal   1 Ǹ 
	ecTRG_MODE_COUNT 	= 2;	// InputPDO   ̺Ʈ īƮ ̿ؼ Ʈ.   Count   TInPDOQueChannel::Cfg.StaTrg.TrgRefVal   ؼ Ѵ. 
	ecTRG_MODE_PDODATA 	= 3;	// Ư PDO   üũϿ Ʈ  ϴ . 
	ecTRG_MODE_INVALID	= 4;
	
	
	
	
	
	
	ecCOMTRG_MODE_NONE 		= 0;	// ƮŸ  .
	ecCOMTRG_MODE_MANUAL 	= 1;	// Manual trigger  
	ecCOMTRG_MODE_COUNT 	= 2;	// InputPDO   ̺Ʈ īƮ ̿ؼ Ʈ.   Count   TInPDOQueChannel::Cfg.StaTrg.TrgRefVal   ؼ Ѵ. 
	ecCOMTRG_MODE_PDODATA	= 3;	 // Ư PDO   üũϿ Ʈ  ϴ . 
	ecCOMTRG_MODE_INVALID   = 4;

	ecTRG_LEV_TYPE_EQ      = 0; // 񱳵Ͱ Ref Ϳ (Equal) Ʈ 
	ecTRG_LEV_TYPE_GT      = 1; // 񱳵Ͱ Ref ͺ ũ(Greater than) Ʈ 
	ecTRG_LEV_TYPE_GE      = 2; // 񱳵Ͱ Ref ͺ ũų  Ʈ 
	ecTRG_LEV_TYPE_LT      = 3; // 񱳵Ͱ Ref ͺ (Less than) Ʈ 
	ecTRG_LEV_TYPE_LE      = 4; // 񱳵Ͱ Ref ͺ ۰ų  Ʈ 
	ecTRG_LEV_TYPE_RE      = 5; // 񱳵Ͱ Ref ͸  ¿(Rising edge, 񱳵   /  Ref   ¿ ū · ȭ ) ߻ϸ Ʈ 
	ecTRG_LEV_TYPE_FE      = 6; // 񱳵Ͱ Ref ͸  ϰ(Rising edge, 񱳵   /  Ref  ū ¿  · ȭ ) ߻ϸ Ʈ 
	ecTRG_LEV_TYPE_INVALID = 7;
	
	
	
	ecmCONN_STS_NOCONFIG	= -1; // ش ȣ ε Slave Network Configuration ǵ .
	ecmCONN_STS_DISCONN		= 0; // ش   
	ecmCONN_STS_INITIAL		= 1; // ش  Ǿ , AL State INITIAL ܰ.
	ecmCONN_STS_PREOP		= 2; // ش  Ǿ , AL State PreOP ܰ.
	ecmCONN_STS_BOOTSTRAP	= 3; // ش  Ǿ , AL State BOOTSTRAP ܰ.
	ecmCONN_STS_SAFEOP		= 4; // ش  Ǿ , AL State SafeOP ܰ.
	ecmCONN_STS_OP			= 8;  // ش  Ǿ , AL State OP ܰ.

	
	ecmOPMODE_CP = 8; // cyclic synchronous position mode
	ecmOPMODE_CV = 9; // cyclic synchronous velocity mode
	ecmOPMODE_CT = 10; // cyclic synchronous torque mode
	
	
	
	
	ecmMPID_EL_STOP_MODE		= 0; ///< External Limit      [ 0:(Default), 1:]
	ecmMPID_SWL_STOP_MODE		= 10; ///< Software Limit    : [ 0:(Default), 1:]
	ecmMPID_ALM_STOP_MODE		= 20; ///< Servo Alarm    : [ 0:(Default), 1:]
	ecmMPID_INP_ENABLE			= 30; ///< ̹ INP ȣ  Ϸ  üũ ݿ  . [ 0:Disable(Default), 1:Enable]
	ecmMPID_SVOFF_MOVE_MODE		= 40; ///<  OFF ¿ ̼  (0: ( ̼ ߿ Servo-off Ұ), 1:)
	ecmMPID_CLEAR_INITIAL_ALARM	= 50; ///< ECAT AL State OP ȯ  1ȸ ؼ  ˶ Ŭ   . [0:Disable, 1:Enable(Default)]
	ecmMPID_INPUTPDO_TYPE		= 60; ///<   InputPDO͸ ġ PC     .
	ecmMPID_IGNORE_ELN			= 70; ///< (-)Limit ȣ ϶ ɼǿ  . [ 0:Disable(Default), 1:Enable]
	ecmMPID_IGNORE_ELP			= 71; ///< (+)Limit ȣ ϶ ɼǿ  . [ 0:Disable(Default), 1:Enable]
	ecmMPID_ELN_INPUT_SEL		= 72; ///< (-)Limit ȣ  ȣ Է  ϴ ɼ [ 0:NOTȣ(Default), 1:SIMON1/EXT1ȣ, 2:SIMON2/EXT2ȣ, 3:SIMON3, 4:SIMON4, 5:SIMON5] <= ĳҴм̹ 
	ecmMPID_ELP_INPUT_SEL		= 73; ///< (+)Limit ȣ  ȣ Է  ϴ ɼ [ 0:POTȣ(Default), 1:SIMON1/EXT1ȣ, 2:SIMON2/EXT2ȣ, 3:SIMON3, 4:SIMON4, 5:SIMON5] <= ĳҴм̹ 
	ecmMPID_NULL				= 74;			

	
	
	
	
	ecmHOID_TPROB_EDGE_SEL	= 0; ///< Hommingÿ Ǵ Touch Probe Trigger Edge .
	ecmHOID_NULL			= 1;
	
	
	ecmLOGIC_A	= 0;
	ecmLOGIC_B	= 1;	
	
	
	
	
	ecmEDGE_NEG	= 0; // Positive Edge
	ecmEDGE_POS	= 1;	 // Negative Edge	
	
	ecmDIR_N	= 0;
	ecmDIR_P	= 1;
	
	ecmSMODE_CONST	 = 0;
	ecmSMODE_TRAPE	 = 1;
	ecmSMODE_SCURVE  = 2; ///< Linear Section  Ͽ ϴ S-CURVE 
	ecmSMODE_INVALID = 3;
	
	ecmJERK_MODE_LR1 = 0;	///< Linear Section  Ͽ Jerk ϴ  (ӵ  ü   ð ϵ ϴ ڷ Ǵ )
	ecmJERK_MODE_LR2 = 1;	///< Linear Section  Ͽ Jerk ϴ  (ӵ  ӱ ִ밡ӵ Ǵ )
	ecmJERK_MODE_JT  = 2;	///< Jerk Time Ͽ Jerk ϴ  
	ecmJERK_MODE_JV  = 3;	///< Jerk Value Ͽ Jerk ϴ  
	ecmJERK_INVALID  = 4;
	
	ecmSYNC_OTHER_START	  	= 0;
	ecmSYNC_OTHER_ACC_INI 	= 1;
	ecmSYNC_OTHER_ACC_END 	= 2;
	ecmSYNC_OTHER_DEC_INI 	= 3;
	ecmSYNC_OTHER_DEC_END 	= 4;
	ecmSYNC_OTHER_POSITION  = 5;
	ecmSYNC_OTHER_INVALID	= 6;
	
	
	ecmPOS_SYNC_GT    		= 0; // sync position ref. position ū(Greater Than) .
	ecmPOS_SYNC_GE    		= 1; // sync position ref. position ũų (Greater or Equal) .
	ecmPOS_SYNC_LT    		= 2; // sync position ref. position (Less Than) .
	ecmPOS_SYNC_LE    		= 3; // sync position ref. position ũų (Less or Equal) .
	ecmPOS_SYNC_POS_CROSS 	= 4; // sync position ref. position   ū  ϴ .
	ecmPOS_SYNC_NEG_CROSS 	= 5; // sync position ref. position ū    ϴ .
	ecmPOS_SYNC_INVALID 	= 6;
	
	ecmATRQ_VAL_SINGLE  = 1;	// single torque value output mode
	ecmATRQ_VAL_MULTI   = 2;	// Multiple level torque value output mode
	ecmATRQ_VAL_INVALID = 3;
	
	ecmATRQ_LMBIT_HIGHSPD = 0;
	ecmATRQ_LMBIT_LOWSPD  = 1;
	ecmATRQ_LMBIT_TIME    = 2;
	
	
	
	ecmCNT_COMM     	= 0; // ǥ Command ġ ( ,  ǥ , PosCorrTable    ġ)
	ecmCNT_FEED     	= 1; // ǥ Feedback ġ ( ,  ǥ , PosCorrTable    ġ)
	ecmCNT_COMM_CORR    = 2; // PosCorrTable  ǥ Command ġ (  ǥ  ǰ, PosCorrTable   ġ)
	ecmCNT_FEED_CORR    = 3; // PosCorrTable  ǥ Feedback ġ (  ǥ  ǰ, PosCorrTable   ġ)
	ecmCNT_COMM_MOTOR   = 4; // ǥ Command ġ (Ϳ ޹ ״ ġ.   ϱ  ġ)
	ecmCNT_FEED_MOTOR   = 5; // ǥ Command ġ (Ϳ ޹ ״ ġ.   ϱ  ġ)

	
	ecmCNT_COMM_PRECORR		= ecmCNT_COMM_CORR;
	ecmCNT_FEED_PRECORR		= ecmCNT_FEED_CORR;
	ecmCNT_COMM_RAW			  = ecmCNT_COMM_PRECORR;
	ecmCNT_FEED_RAW			  = ecmCNT_FEED_PRECORR;



	ecmMST_STOP			= 0; ///<  
	ecmMST_IN_ACCEL		= 1; ///< 
	ecmMST_IN_WORKSPD	= 2; ///< ۾ӵ ̼
	ecmMST_IN_DECEL		= 3; ///< 
	ecmMST_IN_INISPD	= 4; ///< ʱӵ ̼ 
	ecmMST_IN_WAIT_INP	= 5; ///< Inposition  ϱ⸦ ٸ  
	ecmMST_IN_SDSPD		= 6; ///< SD(Slow Down) ӵ ̼
	ecmMST_IN_HOMMING	= 10;///<  ̼ 
	ecmMST_IN_SLAVE_MODE		= 13; ///< ش  Master/Slave  Slave ϴ 
	ecmMST_IN_WAIT				= 14; ///< ̼  ϴ޵Ǿ, ̼ غ  .
	ecmMST_IN_AUTO_TORQ_MDOE	= 15; ///< AutoTorque 尡 Ȱȭ ¿ ũ¸尡 ǰ ִ 
	ecmMST_IN_PTMOTION			= 16; ///< PT-Motion  
	ecmMST_IN_NORMAL_TORQ_MODE	= 17; ///< Normal Torque Control Mode  
	ecmMST_IN_MULTORQ1_MODE		= 18; ///< Multi-Torque1  Ȱȭ 
	ecmMST_IN_NORMAL_CV_MODE	= 21; ///< Normal cyclic velocity control mode   

	ecmIX_MAP0			=		0;
	ecmIX_MAP1			=		1;
	ecmIX_MAP2			=		2;
	ecmIX_MAP3			=		3;
	ecmIX_MAP4			=		4;
	ecmIX_MAP5			=		5;
	ecmIX_MAP6			=		6;
	ecmIX_MAP7			=		7;
	ecmIX_MAP8			=		8;
	ecmIX_MAP9			=		9;
	ecmIX_MAP10			=		10;
	ecmIX_MAP11			=		11;
	ecmIX_MAP12			=		12;
	ecmIX_MAP13			=		13;
	ecmIX_MAP14			=		14;
	ecmIX_MAP15			=		15;
	
	
	ecmIX_MODE_NONE		= 0;
	ecmIX_MODE_LINEAR	= 1;
	ecmIX_MODE_CIRCULAR	= 2;
	ecmIX_MODE_HELICARL	= 3;
	ecmIX_MODE_SPLINE	= 4;
	
	
	ecmIXSPT_VECTOR		  = 0;	//  ӵ ϴ 
	ecmIXSPT_MASTSPD	  = 1;	//   ӵ ϴ 
	ecmIXSPT_MASTRATIO	= 2;    //   ӵ ϴ .
	ecmIXSPT_INVALID    = 3;
	
	
	ecmARC_CW  = 0;
	ecmARC_CCW = 1;
	
	
	ecmJSPROP_DEC_TIME_ms   = 0; //  Ҷ  ð msec  Ѵ.
	ecmJSPROP_LOWVEL_RATIO  = 1; // ӱ ӵ ӱ ӵ   Ѵ.
	ecmJSPROP_LOWVEL_DUR_ms = 2; // ӱ ð msec Ѵ. 
	ecmJSPROP_INVALID       = 3;
	
	
	ecmROUND_DT_NONE	= 0;
	ecmROUND_DT_RADIUS	= 1;
	ecmROUND_DT_OFFSET	= 2;
	ecmROUND_DT_INVALID = 3;
	
	
	ecmROUND_PT_START	= 0; //  ȣ ۵
	ecmROUND_PT_END		= 1; //  ȣ 
	ecmROUND_PT_INVALID = 2;
	
	ecmLM_QUEFULL_SKIP	  = 0;
	ecmLM_QUEFULL_WAIT 	  = 1;
	ecmLM_QUEFULL_INVALID = 2;
	
	ecmLM_STS_DISABLED 	   = 0;		// List Motion  Ȱȭ  (LmCtl_Begin() ϱ )
	ecmLM_STS_PAUSED   	   = 1;		// List Motion  Ȱȭ(LmCtl_Begin()) Ǿ  Run (LmCtl_Run())   
	ecmLM_STS_RUN   		   = 2;		// List Motion  Ȱȭ(LmCtl_Begin()) ǰ,   Run (LmCtl_Run())  .
	ecmLM_STS_STOPPING	   = 3;	    // List Motion  (ecmLmCtl_Stop) ϴ޵Ǿ  ۾ ϰ ִ ()
	ecmLM_STS_STEPCOMPTING = 4; 	// IsComptCurStepڸ true Ͽ  List Motion  (ecmLmCtl_Stop) ϴ޵Ǿ   ǰ ִ  ״ ϰ ִ  Ÿ
	ecmLM_STS_INVALID      = 5;
	
	ecmLM_CMDITEM_STS_READY 		= 0;	//   
	ecmLM_CMDITEM_STS_BUSY			= 1;	//  ǰ .
	ecmLM_CMDITEM_STS_PAUSED		= 2;	//  ߿(ϷǱ ) .
	ecmLM_CMDITEM_STS_COMPLETED		= 3;	// ش Ŀǵ   ϷǾ.
	ecmLM_CMDITEM_STS_INVALID       = 4;	
	
	ecmPTM_STS_DISABLED		 = 0;// PT-Motion  Ȱȭ  (ecmPtmCtl_Begin() ϱ )
	ecmPTM_STS_PAUSED		 = 1;// PT-Motion  Ȱȭ(ecmPtmCtl_Begin()) Ǿ Hold 
	ecmPTM_STS_RUN_IDLE		 = 2;// PT-Motion  Ȱȭ(ecmPtmCtl_Begin()) ǰ Holdµ ƴ  ϵ Ŀǵ尡 ϳ  .
	ecmPTM_STS_RUN_BUSY		 = 3;// PT-Motion  Ȱȭ(ecmPtmCtl_Begin()) ǰ Holdµ ƴ ¿ ϵ Ŀǵ尡 ߿ ִ .
	ecmPTM_STS_RUN_COMPT	 = 4;// PT-Motion  Ȱȭ(ecmPtmCtl_Begin()) ǰ Holdµ ƴ ¿ ϵ Ŀǵ尡   ( ecmPTM_STS_RUN_COMPT 1 ̻ ϵ Ŀǵ尡 ־ 쿡 شϸ, ϵ Ŀǵ尡 ƿ   ecmPTM_STS_RUN_IDLE · ȯȴ)
	ecmPTM_STS_INVALID		 = 5;
	
	ecmPTM_CMDITEM_STS_READY     = 0; //   
	ecmPTM_CMDITEM_STS_BUSY		 = 1; //  ǰ .
	ecmPTM_CMDITEM_STS_PAUSED	 = 2; //  ߿(ϷǱ ) .
	ecmPTM_CMDITEM_STS_COMPLETED = 3; // ش Ŀǵ   ϷǾ.
	ecmPTM_CMDITEM_STS_INVALID   = 4;
	
	
	ecmRING_DIR_NEG  	= 0;	// (-) ̼Ͽ   ġ ̼
	ecmRING_DIR_POS  	= 1;		// (+) ̼Ͽ   ġ ̼
	ecmRING_DIR_NEAR 	= 2;		// (-) (+) ߿  ġκ   ġ Ÿ    ̼.
	ecmRING_DIR_FAR  	= 3;		// (-) (+) ߿  ġκ   ġ Ÿ    ̼.
	ecmRING_DIR_INVALID = 4;
	
	ecmHT_DISABLE	 = 0;// Handler  ʴ´( ϵ ڵ鷯 ȴ)
	ecmHT_MESSAGE	 = 1;// Window Message 
	ecmHT_EVENT		 = 2;// Event 
	ecmHT_CALLBACK	 = 3;// Callback 
	
	ecmCMP_CNTR_COMM    = 0;
	ecmCMP_CNTR_FEED    = 1;
	ecmCMP_CNTR_INVALID = 2;
	
	ecmCMP_METH_EQ_NDIR		 = 0;// (-) ̼ ߿ CP == RP ϶ Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmCMP_METH_EQ_PDIR		 = 1;// (+) ̼ ߿ CP == RP ϶ Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmCMP_METH_EQ_BIDIR	 = 2;// ⿡  CP == RP ϶ Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmCMP_METH_LT			 = 3;// CP < RP ϶  Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmCMP_METH_GT			 = 4;// CP > RP ϶  Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmCMP_METH_LE			 = 5;// CP <= RP ϶  Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmCMP_METH_GE			 = 6;// CP >= RP ϶  Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmCMP_METH_INVALID		 = 7;
	
	ecmMTQ1_CMP_LT			 = 0;// CP < RP ϶  Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmMTQ1_CMP_GT			 = 1;// CP > RP ϶  Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmMTQ1_CMP_LE			 = 2;// CP <= RP ϶  Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmMTQ1_CMP_GE			 = 3;// CP >= RP ϶  Compare Output Active Ǵ . ⼭ CP:ġ(Current Position),  RP:ġ(Reference Position).
	ecmMTQ1_CMP_INVALID		 = 4;
	
	ecmSD_OFS_NONE   	= 0; // offset  
	ecmSD_OFS_TIME   	= 1; // time offset (msec )
	ecmSD_OFS_CMDPOS  	= 2;// command position offset 
	ecmSD_OFS_FEEDPOS 	= 3; // feedback position offset 
	ecmSD_OFS_INVALID  	= 4;




	
	type
// * [ ComiEcatSdk.h ]
// * Header file for API fuctions in CMMSDK library
// * - Update Data: 2018/10/16
// * - Provider: COMIZOA Co., Ltd.
// * - Phone: +82-42-936-6500~6
// * - Fax  : +82-42-936-6507
// * - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com

//====================== DLL LOAD/UNLOAD FUNCTIONS ============================================//

//EC_EXTERN t_success ecDll_Load (void);
//EC_EXTERN t_success ecDll_Unload (void);
//EC_EXTERN BOOL		ecDll_IsLoaded(void);

//====================== GENERAL FUNCTIONS ==============================================================//
//EC_EXTERN t_success (CECAT_API *ecGn_LoadDevices) (t_i32 *ErrCode);
TEC_Gn_LoadDevices = function(ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecGn_UnloadDevices) (t_i32 *ErrCode);
TEC_Gn_UnloadDevices = function(ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecGn_SetBootWaitMode) (t_bool IsWaitBootCompt, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecGn_GetBootWaitMode) (t_i32 *ErrCode);
//EC_EXTERN BOOL		(CECAT_API *ecGn_IsDevLoaded) (t_i32 DevIdx, t_i32 *ErrCode);
TEC_Gn_IsDevLoaded = function(DevIdx : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecGn_GetNumDevices) (t_i32 *ErrCode);
TEC_Gn_GetNumDevices = function(ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecGn_GetNumNetworks) (t_i32 *ErrCode);
TEC_Gn_GetNumNetworks = function(ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecGn_GetDevInfo) (t_i32 DevIdx, TEcDevInfo *pDevInfo, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecGn_SetEnableTimerResolSet) (t_bool IsEnable, t_i32 *ErrCode); // ̺귯 ο Sleep()   Ÿ̸ ش 1msec ϰ Sleep()  Ѵ. 0-1msecش   Sleep, 1(default)-1msecش ϰ Sleep ش   
//EC_EXTERN t_bool	(CECAT_API *ecGn_GetEnableTimerResolSet) (t_i32 *ErrCode);

//====================== GENERAL UNTILITY FUNCTIONS ============================================//
//EC_EXTERN void		(CECAT_API *ecUtl_ShowError_A) (HWND hParentWnd, char *szFormat, ...);
//EC_EXTERN void		(CECAT_API *ecUtl_ShowError_W) (HWND hParentWnd, WCHAR *szFormat, ...);
//EC_EXTERN void		(CECAT_API *ecUtl_ShowMessage_A) (HWND hParentWnd, char *szFormat, ...);
//EC_EXTERN void		(CECAT_API *ecUtl_ShowMessage_W) (HWND hParentWnd, WCHAR *szFormat, ...);
//EC_EXTERN t_ui32	(CECAT_API *ecUtl_GetCntDiff_UI32) (t_ui32 PrvVal, t_ui32 CurVal);
//EC_EXTERN t_ui16	(CECAT_API *ecUtl_GetCntDiff_UI16) (t_ui16 PrvVal, t_ui16 CurVal);
//EC_EXTERN t_bool	(CECAT_API *ecUtl_IsTimeOut) (t_ui32 dwStartTime_ms, t_ui32 dwTimeOutVal_ms);

//====================== NET INTERFACE FUNCTIONS =========================================================//
//EC_EXTERN t_bool	(CECAT_API *ecNet_IsBootCompt) (t_i32 NetID, t_i32 *ErrCode);
TEC_Net_IsBootCompt = function(NetID : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecNet_GetDevIdx) (t_i32 NetID);
TEC_Net_GetDevIdx = function(NetID : LongInt) : LongInt; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecNet_GetLocNetIdx) (t_i32 NetID);
TEC_Net_GetLocNetIdx = function(NetID : LongInt) : LongInt; stdcall;
//EC_EXTERN t_success (CECAT_API *ecNet_GetVerInfo) (t_i32 NetID, TEcFileVerInfo_SDK *pVerInfo_SDK, TEcFileVerInfo_WDM *pVerInfo_WDM, TEcFileVerInfo_FW *pVerInfo_FW, t_i32 *ErrCode);
//TEC_Net_GetVerInfo = function

//EC_EXTERN t_ui32	(CECAT_API *ecNet_ScanSlaves) (t_i32 NetID, t_i32 *ErrCode);
TEC_Net_ScanSlaves = function(NetID : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_ui32	(CECAT_API *ecNet_GetCfgSlaveCount) (t_i32 NetID, t_i32 *ErrCode);
TEC_Net_GetCfgSlaveCount = function(NetID : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_success (CECAT_API *ecNet_SetCfgSlaveCount) (t_i32 NetID, t_ui32 SlaveCount, t_i32 *ErrCode);
TEC_Net_SetCfgSlaveCount = function(NetID : LongInt; SlaveCount : Word; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecNet_SetAlState) (t_i32 NetID, EEcAlState AlState, t_i32 *ErrCode);
TEC_Net_SetAlState = function(NetID : LongInt; AlState : Byte; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecNet_SetAlState_FF) (t_i32 NetID, EEcAlState AlState, t_i32 *ErrCode);
//EC_EXTERN EEcAlState	(CECAT_API *ecNet_GetAlState) (t_i32 NetID, t_i32 *ErrCode);
TEC_Net_GetAlState = function(NetID : LongInt; ErrCode : PLongInt) : Byte; stdcall;
//EC_EXTERN t_bool	(CECAT_API *ecNet_SlvComErrSum_GetEnable) (t_i32 NetID, int *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_SlvComErrSum_SetEnable) (t_i32 NetID, t_bool IsEnable, int *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_SlvComErrSum_ClearAll) (t_i32 NetID, int *ErrCode);

//EC_EXTERN void*		(CECAT_API *ecNet_InPDO_GetBufPtr) (t_i32 NetID, t_i32 OfsPos, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecNet_InPDO_GetData) (t_i32 NetID, t_i32 OfsPos, t_ui16 Size, void *pBuf, t_i32 *ErrCode);
//EC_EXTERN t_byte	(CECAT_API *ecNet_InPDO_GetData_B) (t_i32 NetID, t_i32 OfsPos, t_i32 *ErrCode);
//EC_EXTERN t_word	(CECAT_API *ecNet_InPDO_GetData_W) (t_i32 NetID, t_i32 OfsPos, t_i32 *ErrCode);
//EC_EXTERN t_dword	(CECAT_API *ecNet_InPDO_GetData_D) (t_i32 NetID, t_i32 OfsPos, t_i32 *ErrCode);
//EC_EXTERN void*		(CECAT_API *ecNet_OutPDO_GetBufPtr) (t_i32 NetID, t_i32 OfsPos, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecNet_OutPDO_SetData) (t_i32 NetID, t_i32 OfsPos, t_ui16 Size, void *pBuf, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_OutPDO_SetData_B) (t_i32 NetID, t_i32 OfsPos, t_byte Data, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_OutPDO_SetData_W) (t_i32 NetID, t_i32 OfsPos, t_word Data, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_OutPDO_SetData_D) (t_i32 NetID, t_i32 OfsPos, t_dword Data, t_i32 *ErrCode);

//====================== SLAVE I/F FUNCTIONS ============================================================//
//EC_EXTERN t_i32			(CECAT_API *ecSlv_SlvIdx2PhysAddr) (t_i32 NetID, t_ui16 SlaveIndex, t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_PhysAddr2SlvIdx) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecSlv_GetProdInfo_A) (t_i32 NetID, t_i32 SlaveIndex, TEcSlvProdInfo *pProdInfoBuf, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecSlv_GetProdInfo) (t_i32 NetID, t_i32 SlvPhysAddr, TEcSlvProdInfo *pProdInfoBuf, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecSlv_GetTypeInfo) (t_i32 NetID, t_ui16 SlvPhysAddr, TEcSlvTypeInfo *pTypeInfoBuf, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecSlv_GetTypeInfo_A) (t_i32 NetID, t_i32 SlaveIndex, TEcSlvTypeInfo *pTypeInfoBuf, t_i32 *ErrCode);
//EC_EXTERN EEcAlState	(CECAT_API *ecSlv_GetAlState) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 *ErrCode);
TEC_Slv_GetAlState = function(NetID : LongInt; SlvPhysAddr : Word; ErrCode : PLongInt) : Byte; stdcall;
//EC_EXTERN EEcAlState	(CECAT_API *ecSlv_GetAlState_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 *ErrCode);
TEC_Slv_GetAlState_A = function(NetID : LongInt; SlaveIdx : LongInt; ErrCode : PLongInt) : Byte; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecSlv_ReadReg) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 RegAddr, t_i32 DataSize, _out void *pBuf, _out t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_ReadReg_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 RegAddr, t_i32 DataSize, _out void *pBuf, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteReg) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 RegAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteReg_FF) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 RegAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteReg_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 RegAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteReg_A_FF) (t_i32 NetID, t_i32 SlaveIdx, t_i32 RegAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_ReadCoeSdo) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pBuf, _out t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_ReadCoeSdo_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pBuf, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteCoeSdo) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pData, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteCoeSdo_FF) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pData, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteCoeSdo_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pData, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteCoeSdo_A_FF) (t_i32 NetID, t_i32 SlaveIdx, t_i32 Index, t_i32 SubIdx, t_i32 IsComptAccess, t_i32 DataSize, void* pData, _out t_i32 *ErrCode);
//EC_EXTERN void*			(CECAT_API *ecSlv_InPDO_GetBufPtr) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 InPdoUnitIdx, t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_InPDO_GetOffset) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 InPdoUnitIdx, int *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_InPDO_GetBufLen) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 InPdoUnitIdx, t_i32 *ErrCode);
//EC_EXTERN void*			(CECAT_API *ecSlv_OutPDO_GetBufPtr) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_OutPDO_GetOffset) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, int *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_OutPDO_GetBufLen) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecSlv_OutPDO_SetInitValMode) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 OutPDOInitMode, t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_OutPDO_GetInitValMode) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecSlv_OutPDO_SetInitVal) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 OfsPos, t_i32 DataSize, void *pData, t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_OutPDO_GetInitVal) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui8 OutPdoUnitIdx, t_i32 OfsPos, t_i32 BufSize, void *pBuf, t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_GetComErrSum_A) (t_i32 NetID, t_ui16 SlaveIndex, t_i32 *ErrCode);
TEC_Slv_GetComErrSum_A = function(NetID : LongInt; SlaveIdx : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_ui16		(CECAT_API *ecSlv_GetComErrSum) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecSlv_ClearComErrSum_A) (t_i32 NetID, t_i32 SlaveIndex, t_i32 *ErrCode);
TEC_Slv_ClearComErrSum_A = function(NetID : LongInt; SlaveIdx : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success		(CECAT_API *ecSlv_ClearComErrSum) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 *ErrCode);

//====================== Digital Input FUNCTIONS =======================================================//

 //--------------- Global Channel ̿ϴ Լ ----------------------------------------------//
//EC_EXTERN t_i32			(CECAT_API *ecdiGetSlaveIndex) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
TEC_diGetSlaveIndex = function(NetID : LongInt; DiChannel : LongWord; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecdiGetSlaveID) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
TEC_diGetSlaveID = function(NetID : LongInt; DiChannel : LongWord; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecdiGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
TEC_diGetNumChannels = function(NetID : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_bool		(CECAT_API *ecdiGetOne) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
TEC_diGetOne = function(NetID : LongInt; DiChannel : LongWord; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_dword		(CECAT_API *ecdiGetMulti) (t_i32 NetID, t_ui32 IniChannel, t_ui8 NumChannels, t_i32 *ErrCode);
TEC_diGetMulti = function(NetID : LongInt; IniChannel : LongWord; NumChannels : Byte; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_dword		(CECAT_API *ecdiGetLogicAddr) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);\
TEC_diGetLogicAddr = function(NetID : LongInt; DiChannel : LongWord; Errcode : PLongInt) : LongWord; stdcall;

//EC_EXTERN t_success		(CECAT_API *ecdiLtc_AddChannel) (t_i32 NetID, t_ui16 DiChannel, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecdiLtc_DelChannel) (t_i32 NetID, t_ui16 DiChannel, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecdiLtc_SetFilter) (t_i32 NetID, t_ui16 DiChannel, t_i32 FilterCycles, t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecdiLtc_GetFilter) (t_i32 NetID, t_ui16 DiChannel, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecdiLtc_SetLogicInvert) (t_i32 NetID, t_ui16 DiChannel, t_bool IsInvertLogic, t_i32 *ErrCode);
//EC_EXTERN t_bool		(CECAT_API *ecdiLtc_GetLogicInvert) (t_i32 NetID, t_ui16 DiChannel, t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecdiLtc_GetOnCount) (t_i32 NetID, t_ui16 DiChannel, t_bool IsResetOnCount, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecdiLtc_ResetOnCount) (t_i32 NetID, t_ui16 DiChannel, t_i32 *ErrCode);


 //--------------- Slave Address Local Channel ̿ϴ Լ ------------------------------////--------------- Global Channel ̿ϴ Լ ----------------------------------------------//
//EC_EXTERN t_bool		(CECAT_API *ecdiGetOne_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
TEC_diGetOne_L = function(NetID : LongInt; SlvPhysAddr : Word; LocalChannel : LongInt; Errcode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_dword		(CECAT_API *ecdiGetMulti_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui32 IniLocalChannel, t_ui8 NumChannels, t_i32 *ErrCode);
TEC_diGetMulti_L = function(NetID : LongInt; SlvPhysAddr : Word; IniLocalChannel : LongWord; NumChannels : Byte; ErrCode : PLongInt) : Longword; stdcall;
//EC_EXTERN t_success		(CECAT_API *ecdiLtc_AddChannel_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecdiLtc_DelChannel_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecdiLtc_SetFilter_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 FilterCycles, t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecdiLtc_GetFilter_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecdiLtc_SetLogicInvert_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_bool IsInvertLogic, t_i32 *ErrCode);
//EC_EXTERN t_bool		(CECAT_API *ecdiLtc_GetLogicInvert_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecdiLtc_GetOnCount_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_bool IsResetOnCount, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecdiLtc_ResetOnCount_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);

 //--------------- Ʈּ(Logic Bit Address) ȯ Լ ------------------------------//
//EC_EXTERN t_dword		(CECAT_API *ecdiLogBitAddr_FromGlobalChannel) (t_i32 NetID, t_i32 GlobalChannel, t_i32 *ErrCode); // Global Input Channel Ʈּҷ ȯ
TEC_diLogBitAddr_FromGlobalChannel = function(NetID : LongInt; GlobalChannel : LongInt; ErrCode : PLongInt) : LongWord; stdcall; 
//EC_EXTERN t_dword		(CECAT_API *ecdiLogBitAddr_FromLocalChannel) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode); // Local Input Channel Ʈּҷ ȯ
TEC_diLogBitAddr_FromLocalChannel = function(NetID : LongInt; SlvPhysAddr : Word; LocalChannel : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_dword		(CECAT_API *ecdiLogBitAddr_FromOnboardChannel) (t_i32 NetID, t_i32 OnboardChannel, t_i32 *ErrCode); // Onboard Input Channel Ʈּҷ ȯ
TEC_diLogBitAddr_FromOnboardChannel = function(NetID : LongInt; OnBoardChannel : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecdiLogBitAddr_ToGlobalChannel) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode); // ƮּҸ Global Input Channel ȯ
TEC_diLogBitAddr_ToGlobalChannel = function(NetID : LongInt; LogBitAddr : LongWord; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecdiLogBitAddr_ToLocalChannel) (t_i32 NetID, t_dword LogBitAddr, t_ui16 *SlvPhysAddr, t_i32 *ErrCode); // ƮּҸ Global Input Channel ȯ
TEC_diLogBitAddr_ToLocalChannel = function(NetID : LongInt; LogBitAddr : LongWord; SlvPhysAddr : PWord; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecdiLogBitAddr_ToOnboardChannel) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode); // ƮּҸ Onboard Input Channel ȯ
TEC_diLogBitAddr_ToOnboardChannel = function(NetID : LongInt; LogBitAddr : LongWord; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN EEcIoChanType (CECAT_API *ecdiLogBitAddr_GetChanType) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode);
TEC_diLogBitAddr_GetChanType = function(NetID : LongInt; LogBitAddr : LongWord; ErrCode : PLongInt) : Byte; stdcall;
//====================== Digital Output FUNCTIONS =======================================================//
 
 //--------------- Global Channel ̿ϴ Լ ----------------------------------------------//
//EC_EXTERN t_i32			(CECAT_API *ecdoGetSlaveIndex) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
TEC_doGetSlaveIndex = function(NetID : LongInt; DiChannel : LongWord; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecdoGetSlaveID) (t_i32 NetID, t_ui32 DiChannel, t_i32 *ErrCode);
TEC_doGetSlaveID = function(NetID : LongInt; DiChannel : LongWord; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecdoGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
TEC_doGetNumChannels = function(NetID : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_success		(CECAT_API *ecdoPutOne) (t_i32 NetID, t_ui32 DoChannel, t_bool OutState, t_i32 *ErrCode);
TEC_doPutOne = function(NetID : LongInt; DoChannel : LongWord; OutState : Boolean; ErrCode: PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success		(CECAT_API *ecdoPutMulti) (t_i32 NetID, t_ui32 IniChannel, t_ui8 NumChannels, t_dword dwOutStates, t_i32 *ErrCode);
TEC_doPutMulti = function(NetID : LongInt; IniChannel : Longword; NumChannels : Byte; dwOutStates : LongWord; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_bool		(CECAT_API *ecdoGetOne) (t_i32 NetID, t_ui32 DoChannel, t_i32 *ErrCode);
TEC_doGetOne = function(NetID : LongInt; DoChannel : LongWord; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_dword		(CECAT_API *ecdoGetMulti) (t_i32 NetID, t_ui32 IniChannel, t_ui8 NumChannels, t_i32 *ErrCode);
TEC_doGetMulti = function(NetID : LongInt; IniChannel : Longword; NumChannels : Byte; ErrCode : PLongInt) : LongWord; stdcall;

 //--------------- Slave Address Local Channel ̿ϴ Լ ------------------------------//
//EC_EXTERN t_success		(CECAT_API *ecdoPutOne_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_bool OutState, t_i32 *ErrCode);
TEC_doPutOne_L = function(NetID : LongInt; SlvPhysAddr : Word; LocalChannel : LongInt; OutState : Boolean; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success		(CECAT_API *ecdoPutMulti_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui32 IniLocalChannel, t_ui8 NumChannels, t_dword dwOutStates, t_i32 *ErrCode);
TEC_doPutMulti_L = function(NetID : LongInt; SlvPhysAddr : Word; IniLocalChannel : LongWord; NumChannels : Byte; dwOutStates : LongWord; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_bool		(CECAT_API *ecdoGetOne_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode);
TEC_doGetOne_L = function(NetID : LongInt; SlvPhyAddr : Word; LocalChannel : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_dword		(CECAT_API *ecdoGetMulti_L) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui32 IniLocalChannel, t_ui8 NumChannels, t_i32 *ErrCode);
TEC_doGetMulti_L = function(NetID : LongInt; SlvPhysAddr : Word; IniLocalChannel : LongWord; NumChannels : Byte; ErrCode : PLongInt) : LongWord; stdcall;

 //--------------- Ʈּ(Logic Bit Address) ȯ Լ ------------------------------//
//EC_EXTERN t_dword		(CECAT_API *ecdoLogBitAddr_FromGlobalChannel) (t_i32 NetID, t_i32 GlobalChannel, t_i32 *ErrCode); // Global Ouput Channel Ʈּҷ ȯ 
TEC_doLogBitAddr_FromGlobalChannel = function(NetID : LongInt; GlobalChannel : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_dword		(CECAT_API *ecdoLogBitAddr_FromLocalChannel) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 LocalChannel, t_i32 *ErrCode); // Local Output Channel Ʈּҷ ȯ 
TEC_doLogBitAddr_FromLocalChannel = function(NetID : LongInt; SlvPhysAddr : Word; LocalChannel : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_dword		(CECAT_API *ecdoLogBitAddr_FromOnboardChannel) (t_i32 NetID, int OnboardChannel, t_i32 *ErrCode); // Onboard Output Channel Ʈּҷ ȯ
TEC_doLogBitAddr_FromOnboardChannel = function(NetID : LongInt; OnBoardChannel : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecdoLogBitAddr_ToGlobalChannel) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode);  // ƮּҸ Global Output Channel ȯ
TEC_doLogBitAddr_ToGlobalChannel = function(NetID : LongInt; LogBitAddr : LongWord; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecdoLogBitAddr_ToLocalChannel) (t_i32 NetID, t_dword LogBitAddr, t_ui16 *SlvPhysAddr, t_i32 *ErrCode); // ƮּҸ Global Output Channel ȯ
TEC_doLogBitAddr_ToLocalChannel = function(NetID : LongInt; LogBitAddr : LongWord; SlvPhysAddr : PWord; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32			(CECAT_API *ecdoLogBitAddr_ToOnboardChannel) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode); // ƮּҸ Onboard Output Channel ȯ
TEC_doLogBitAddr_ToOnboardChannel = function(NetID : LongInt; LogBitAddr : LongWord; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN EEcIoChanType (CECAT_API *ecdoLogBitAddr_GetChanType) (t_i32 NetID, t_dword LogBitAddr, t_i32 *ErrCode);
TEC_doLogBitAddr_GetChanType = function(NetID : LongInt; LogBitAddr : LongWord; ErrCode : PLongInt) : Byte; stdcall;

//====================== Analog Input FUNCTIONS =======================================================//
//EC_EXTERN t_i32		(CECAT_API *ecaiGetSlaveIndex) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecaiGetSlaveID) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecaiGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecaiGetChanVal_I) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecaiGetChanVal_F) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecaiGetChanVal_FS) (t_i32 NetID, t_ui32 Channel, t_f32 ScaleMin, t_f32 ScaleMax, _out t_i32 *ErrCode);


//EC_EXTERN t_i32		(CECAT_API *ecaiL_GetChanVal_I) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecaiL_GetChanVal_F) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecaiL_GetChanVal_FS) (t_i32 NetID, t_ui32 Channel, t_f32 ScaleMin, t_f32 ScaleMax, _out t_i32 *ErrCode);


//====================== Analog Output FUNCTIONS =======================================================//
//EC_EXTERN t_i32		(CECAT_API *ecaoGetSlaveIndex) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecaoGetSlaveID) (t_i32 NetID, t_ui32 Channel, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecaoGetNumChannels) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecaoSetChanVal_I) (t_i32 NetID, t_ui32 Channel, t_i32 OutData, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecaoSetChanVal_F) (t_i32 NetID, t_ui32 Channel, t_f64 OutData, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecaoSetChanVal_FS) (t_i32 NetID, t_ui32 Channel, t_f64 OutData, t_f64 ScaleMin, t_f64 ScaleMax, _out t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecaoGetOutValue_I) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecaoGetOutValue_F) (t_i32 NetID, t_ui32 Channel, _out t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecaoGetOutValue_FS) (t_i32 NetID, t_ui32 Channel, t_f64 ScaleMin, t_f64 ScaleMax, _out t_i32 *ErrCode);

//====================== MOTION - GENEAL FUNCTIONS =======================================================//
//EC_EXTERN t_i32		(CECAT_API *ecmGn_GetAxisList) (t_i32 NetID, t_ui8 AxisListBuf[], t_ui8 AxisListBufSize, t_i32 *ErrCode);
TEC_mGn_GetAxisList = function(NetID : LongInt; AxisListBuf : PByte; AxisListBufSize : Byte; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN TEcmInPDO_Header* (CECAT_API *ecmGn_GetInPDOHeader) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmGn_AxisToSlaveIndex) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mGn_AxisToSlaveIndex = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmGn_AxisToSlaveID) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mGn_AxisToSlaveID = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmGn_SlaveIndexToAxis) (t_i32 NetID, t_i32 SlaveIndex, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmGn_SlaveIDToAxis) (t_i32 NetID, t_i32 SlaveID, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmGn_InitFromFile) (t_i32 NetID, t_i32 AxisCnt, char *szMotCfgFile, t_i32 *ErrCode);
TEC_mGn_InitFromFile = function(NetID : LongInt; AxisCnt : LongInt; szMotCfgFile : PChar; ErrCode : PLongInt) : Boolean; stdcall;

//------ Hardware Emergency Stop --------------------------------------------------------//
//EC_EXTERN t_success	(CECAT_API *ecmHEMG_SetInputEnv) (t_i32 NetID, t_dword LogBitAddr, t_bool IsInvertLogic, t_i32 FilterCount, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmHEMG_GetInputEnv) (t_i32 NetID, t_dword *LogBitAddr, t_bool *IsInvertLogic, t_i32 *FilterCount, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmHEMG_SetInputEnv_Multi) (t_i32 NetID, t_i32 NumInputs, TEcmEmgInputEnv *pInputList, t_i32 FilterCount, t_i32 *ErrCode); 
//EC_EXTERN t_i32		(CECAT_API *ecmHEMG_GetInputEnv_Multi) (t_i32 NetID, t_i32 MaxNumInputsToCopy, TEcmEmgInputEnv *pInputListBuf, t_i32 *FilterCount, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmHEMG_GetNumInputs) (t_i32 NetID, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmHEMG_SetStopMode) (t_i32 NetID, t_bool IsDecelStop, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmHEMG_GetStopMode) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmHEMG_SetEnable) (t_i32 NetID, t_bool IsEnable, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmHEMG_GetEnable) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmHEMG_GetState) (t_i32 NetID, t_i32 *ErrCode);

//------ Software Emergnecy Stop --------------------------------------------------------//
//EC_EXTERN t_success	(CECAT_API *ecmSEMG_SetStopMode) (t_i32 NetID, t_bool IsDecelStop, t_i32 *ErrCode); 
//EC_EXTERN t_bool	(CECAT_API *ecmSEMG_GetStopMode) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSEMG_SetState) (t_i32 NetID, t_bool State, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSEMG_GetState) (t_i32 NetID, t_i32 *ErrCode);


//------ Collision Avoidance (CollA) ----------------------------------------------------//
//EC_EXTERN t_success	(CECAT_API *ecmCollA_SetEnv) (t_i32 NetID, t_i32 CollAIdx, t_i32 MasterAxis, t_i32 SalveAxis, t_i32 SubOrAdd, t_i32 LessOrGreater, t_f64 Limit, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmCollA_GetEnv) (t_i32 NetID, t_i32 CollAIdx, t_i32* MasterAxis, t_i32* SlaveAxis, t_i32* SubOrAdd, t_i32* LessOrGreater, t_f64* Limit, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmCollA_SetStopMode) (t_i32 NetID, t_i32 CollAIdx, t_bool IsDecelStop_M, t_bool IsDecelStop_S, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmCollA_GetStopMode) (t_i32 NetID, t_i32 CollAIdx, t_bool* IsDecelStop_M, t_bool* IsDecelStop_S, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmCollA_SetEnable) (t_i32 NetID, t_i32 CollAIdx, t_bool IsEnable, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmCollA_GetEnable) (t_i32 NetID, t_i32 CollAIdx, t_i32 *ErrCode);

//====================== MOTION - SINGLE AXIS FUNCTIONS ==================================================//
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetUnitDist) (t_i32 NetID, t_i32 Axis, t_f64 UnitDist, _out t_i32 *ErrCode);
TEC_mSxCfg_SetUnitDist = function(NetID : LongInt; Axis : LongInt; UnitDist : Double; ErrCode : PLongInt) : Boolean; stdcall; 
//EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_GetUnitDist) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxCfg_GetUnitDist = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Double; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetUnitSpeed) (t_i32 NetID, t_i32 Axis, t_f64 UnitSpeed, _out t_i32 *ErrCode);
TEC_mSxCfg_SetUnitSpeed = function(NetID : LongInt; Axis : LongInt; UnitSpeed : Double; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_GetUnitSpeed) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxCfg_GetUnitSpeed = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Double; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetMioProp) (t_i32 NetID, t_i32 Axis, EEcmMioPropId PropId, t_i32 PropVal, _out t_i32 *ErrCode);
TEC_mSxCfg_SetMioProp = function(NetID : LongInt; Axis : LongInt; PropId : Byte; PropVal : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_GetMioProp) (t_i32 NetID, t_i32 Axis, EEcmMioPropId PropId, _out t_i32 *ErrCode);
TEC_mSxCfg_GetMioProp = function(NetID : LongInt; Axis : LongInt; ProId : Byte; PropVal : PLongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMastInp) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_f64 InpRange, t_i32 *ErrCode);
TEC_mSxCfg_SetMastInp = function(NetID : LongInt; Axis : LongInt; IsEnable : Boolean; InpRange : Double; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_GetMastInp) (t_i32 NetID, t_i32 Axis, t_bool* IsEnable, t_f64* InpRange, t_i32 *ErrCode);
TEC_mSxCfg_GetMastInp = function(NetID : LongInt; Axis : LongInt; IsEnable : PBoolean; InpRange : PDouble; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMastInp_Cnt) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 InpRangeCnt, t_i32 *ErrCode);
TEC_mSxCfg_SetMastInp_Cnt = function(NetID : LongInt; Axis : LongInt; IsEnable : Boolean; InpRangeCnt : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_GetMastInp_Cnt) (t_i32 NetID, t_i32 Axis, t_bool* IsEnable, t_i32* InpRangeCnt, t_i32 *ErrCode);
TEC_mSxCfg_GetMastInp_Cnt = function(NetID : LongInt; Axis : LongInt; IsEnable : PBoolean; InpRangeCnt : PLongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_GetSoftLimit) (t_i32 NetID, t_i32 Axis, BOOL* IsEnable, double* NegLimit, double* PosLimit, BOOL* IsDecelStop, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetSoftLimit) (t_i32 NetID, t_i32 Axis, BOOL IsEnable, double NegLimit, double PosLimit, BOOL IsDecelStop, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetOperMode) (t_i32 NetID, t_i32 Axis, EEcmOperMode OperMode, _out t_i32 *ErrCode);
TEC_mSxCfg_SetOperMode = function(NetID : LongInt; Axis : LongInt; OperMode : Byte; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_GetOperMode) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxCfg_GetOperMode = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedPatt) (t_i32 NetID, t_i32 Axis, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 Acc, t_f64 Dec, t_i32 *ErrCode);
TEC_mSxCfg_SetSpeedPatt = function(NetID : LongInt; Axis : LongInt; SpeedMode : LongInt; VIni : Double; VEnd : Double; VWork : Double; Acc : Double; Dec : Double; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedPatt_FF) (t_i32 NetID, t_i32 Axis, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 Acc, t_f64 Dec, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_GetSpeedPatt) (t_i32 NetID, t_i32 Axis, t_i32 *SpeedMode, t_f64 *VIni, t_f64 *VEnd, t_f64 *VWork, t_f64 *Acc, t_f64 *Dec, t_i32 *ErrCode);
TEC_mSxCfg_GetSpeedPatt = function(NetID : LongInt; Axis : LongInt; SpeedMode : PLongInt; VIni : PDouble; VEnd : PDouble; VWork : PDouble; Acc : PDouble; Dec : PDouble; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedPatt_Time) (t_i32 NetID, t_i32 Axis, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 AccTime, t_f64 DecTime, t_i32 *ErrCode);
TEC_mSxCfg_SetSpeedPatt_Time = function(NetID : LongInt; Axis : LongInt; SpeedMode : LongInt; VIni : Double; VEnd : Double; AccTime : Double; DecTime : Double; Errcode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedPatt_Time_FF) (t_i32 NetID, t_i32 Axis, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 AccTime, t_f64 DecTime, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_GetSpeedPatt_Time) (t_i32 NetID, t_i32 Axis, t_i32 *SpeedMode, t_f64 *VIni, t_f64 *VEnd, t_f64 *VWork, t_f64 *AccTime, t_f64 *DecTime, t_i32 *ErrCode);
TEC_mSxCfg_GetSpeedPatt_Time = function(NetID : LongInt; Axis : LongInt; SpeedMode : PLongInt; VIni : PDouble; VEnd : PDouble; VWork : PDouble; AccTime : PDouble; DecTime : PDouble; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedRatio) (t_i32 NetID, t_i32 Axis, t_f64 SpeedRatio, t_i32 *ErrCode);
TEC_mSxCfg_SetSpeedRatio = function(NetID : LongInt; Axis : LongInt; SpeedRatio : Double; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedRatio_FF) (t_i32 NetID, t_i32 Axis, t_f64 SpeedRatio, t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_GetSpeedRatio) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mSxCfg_GetSpeedRatio = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Double; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetJerkRatio) (t_i32 NetID, t_i32 Axis, t_f64 JerkTimeRatio, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetJerkRatio_FF) (t_i32 NetID, t_i32 Axis, t_f64 JerkTimeRatio, t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_GetJerkRatio) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMinAccDecTime) (t_i32 NetID, t_i32 Axis, t_f64 MinAccTime, t_f64 MinDecTime, t_f64 LowLimitVel, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_GetMinAccDecTime) (t_i32 NetID, t_i32 Axis, t_f64 *MinAccTime, t_f64 *MinDecTime, t_f64 *LowLimitVel, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetTouchProbeFunc) (t_i32 NetID, t_i32 Axis, t_ui8 TouchProbeIndex, t_byte TouchProbeFuncVal, _out t_i32 *ErrCode);
//EC_EXTERN t_byte	(CECAT_API *ecmSxCfg_GetTouchProbeFunc) (t_i32 NetID, t_i32 Axis, t_ui8 TouchProbeIndex, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSyncOtherEnv) (t_i32 NetID, t_i32 Axis, t_i32 SyncAxis, t_i32 SyncType, t_i32 PosSyncMethod, t_f64 SyncPosition, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_GetSyncOtherEnv) (t_i32 NetID, t_i32 Axis, t_i32 *SyncAxis, t_i32 *SyncType, t_i32 *PosSyncMethod, t_f64 *SyncPosition, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSyncOtherEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_bool IsOneShot, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_GetSyncOtherEnable) (t_i32 NetID, t_i32 Axis, t_bool* IsEnable, t_bool* IsOneShot, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr_SetTableSize) (t_i32 NetID, t_i32 Axis, t_i32 TableSize, t_i32 *ErrCode);
TEC_mSxCfg_PosCorr_SetTableSize = function(NetID : LongInt; Axis : LongInt; TableSize : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_PosCorr_GetTableSize) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mSxCfg_PosCorr_GetTableSize = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr_SetTableData) (t_i32 NetID, t_i32 Axis, t_i32 TableIndex, t_f64 RefCmdPos, t_f64 ActMotorPos, t_i32 *ErrCode);
TEC_mSxCfg_PosCorr_SetTableData = function(NetID : LongInt; Axis : LongInt; TableIndex : LongInt; RefCmdPos : Double; ActMotorPos : Double; ErrCode : LongInt) : Boolean; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr_GetTableData) (t_i32 NetID, t_i32 Axis, t_i32 TableIndex, t_f64* RefCmdPos, t_f64* ActMotorPos, t_i32 *ErrCode);
TEC_mSxCfg_PosCorr_GetTableData = function(NetID : LongInt; Axis : LongInt; TableIndex : LongInt; RefCmdPos : PDouble; ActMotorPos : PDouble; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_PosCorr_SetTableFromFile) (t_i32 NetID, t_i32 Axis, char *szFilePath, t_i32 *ErrCode);
TEC_mSxCfg_PosCorr_SetTableFromFile = function(NetID : LongInt; Axis : LongInt; szFilePath : PChar; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
TEC_mSxCfg_PosCorr_SetEnable = function(NetID : LongInt; Axis : LongInt; IsEnable : Boolean; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_PosCorr_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mSxCfg_PosCorr_GetEnable = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr_ClearTable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mSxCfg_PosCorr_ClearTable = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Boolean; stdcall;

//EC_EXTERN t_success (CECAT_API *ecmSxCfg_PosCorr2D_Reset) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_PosCorr2D_SetTableHeader) (t_i32 NetID, t_i32 Axis, TEcmPC2DHeader PC2DHeader, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_PosCorr2D_GetTableHeader) (t_i32 NetID, t_i32 Axis, TEcmPC2DHeader* pPC2DHeader, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_PosCorr2D_SetTableData) (t_i32 NetID, t_i32 Axis, t_i32 Row, t_i32 Col, t_f32 CorrOfsData, t_i32 *ErrCode);
//EC_EXTERN t_f32		(CECAT_API *ecmSxCfg_PosCorr2D_GetTableData) (t_i32 NetID, t_i32 Axis, t_i32 Row, t_i32 Col, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr2D_SetTableFromFile) (t_i32 NetID, t_i32 Axis, char *szFilePath, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_PosCorr2D_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_PosCorr2D_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);

//EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_SetValMode) (t_i32 NetID, t_i32 Axis, t_i32 ValMode, t_i32 NumMultiVals, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_AutoTorq_GetValMode) (t_i32 NetID, t_i32 Axis, t_i32 *NumMultiVals, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_SetMultiVal) (t_i32 NetID, t_i32 Axis, t_i32 ValIndex, t_i32 TorqVal, t_i32 Duration, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_GetMultiVal) (t_i32 NetID, t_i32 Axis, t_i32 ValIndex, t_i32* TorqVal, t_i32* Duration, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_SetValue) (t_i32 NetID, t_i32 Axis, t_i32 OutTorqVal, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_AutoTorq_GetValue) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_SetLimit) (t_i32 NetID, t_i32 Axis, t_ui32 LimitMask, t_f64 HighSpeedLimit, t_f64 LowSpeedLimit, t_i32 TimeLimit, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_GetLimit) (t_i32 NetID, t_i32 Axis, t_ui32 *LimitMask, t_f64 *HighSpeedLimit, t_f64 *LowSpeedLimit, t_i32 *TimeLimit, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_AutoTorq_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_bool IsOneShotEnable, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_AutoTorq_GetEnable) (t_i32 NetID, t_i32 Axis, t_bool *IsOneShotEnable, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_Ring_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mSxCfg_Ring_GetEnable = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_Ring_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
TEC_mSxCfg_Ring_SetEnable = function(NetID : LongInt; Axis : LongInt; IsEnable : Boolean; Errcode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_Ring_GetPosRange) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mSxCfg_Ring_GetPosRange = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Double; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_Ring_SetPosRange) (t_i32 NetID, t_i32 Axis, t_f64 RingPosRange, t_i32 *ErrCode);
TEC_mSxCfg_Ring_SetPosRange = function(NetID : LongInt; Axis : LongInt; RingPosRange : Double; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_Ring_GetDirMode) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mSxCfg_Ring_GetDirMode = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_Ring_SetDirMode) (t_i32 NetID, t_i32 Axis, t_i32 RingDirMode, t_i32 *ErrCode);
TEC_mSxCfg_Ring_SetDirMode = function(NetID : LongInt; Axis : LongInt; RingDirMode : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_ExtStop_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_ExtStop_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_ExtStop_SetEnv) (t_i32 NetID, t_i32 Axis, TEcLogicAddr SigAddr, t_i32 ActiveState, t_i32 DelayTime, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_ExtStop_GetEnv) (t_i32 NetID, t_i32 Axis, TEcLogicAddr *pSigAddr, t_i32 *pActiveState, t_i32 *pDelayTime, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_ExtStop_SetEnv2) (t_i32 NetID, t_i32 Axis, TEcLogicAddr SigAddr, t_i32 ActiveLogic, t_f64 OfsDist, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_ExtStop_GetEnv2) (t_i32 NetID, t_i32 Axis, TEcLogicAddr *pSigAddr, t_i32 *ActiveLogic, t_f64 *pOfsDist, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_ExtStop_SetEnv3) (t_i32 NetID, t_i32 Axis, t_ui8 TouchProbeIndex, t_i32 ActiveLogic, t_f64 OfsDist, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_ExtStop_GetEnv3) (t_i32 NetID, t_i32 Axis, t_ui8 *TouchProbeIndex, t_i32 *ActiveLogic, t_f64 *pOfsDist, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_ExtStop_SetOfsDistMode) (t_i32 NetID, t_i32 Axis, t_bool IsHardOfsDistMode, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxCfg_ExtStop_GetOfsDistMode) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMaxTorqOfCV) (t_i32 NetID, t_i32 Axis, t_ui16 MaxTorq, t_i32 *ErrCode);
TEC_mSxCfg_SetMaxTorqOfCV = function(NetID : LongInt; Axis : LongInt; MaxTorq : Word; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_ui16	(CECAT_API *ecmSxCfg_GetMaxTorqOfCV) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mSxCfg_GetMaxTorqOfCV = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Word; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMaxSpdOfCT) (t_i32 NetID, t_i32 Axis, t_ui32 MaxSpd, t_i32 *ErrCode);
TEC_mSxCfg_SetMaxSpdOfCT = function(NetID : LongInt; Axis : LongInt; MaxSpd : LongWord; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_ui32	(CECAT_API *ecmSxCfg_GetMaxSpdOfCT) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxCfg_GetMaxSpdOfCT = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmSxCfg_SetMaxProfSpdOfCT) (t_i32 NetID, t_i32 Axis, t_f64 MaxProfSpd, t_i32 *ErrCode);
TEC_mSxCfg_SetMaxProfSpdOfCT = function(NetID : LongInt; Axis : LongInt; MaxProfSpd : Double; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_f64		(CECAT_API *ecmSxCfg_GetMaxProfSpdOfCT) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mSxCfg_GetMaxProfSpdOfCT = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Double; stdcall;

//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_SetSvon) (t_i32 NetID, t_i32 Axis, t_i32 SvonVal, _out t_i32 *ErrCode);
TEC_mSxCtl_SetSvon = function(NetID : LongInt; Axis : LongInt; SvonVal : LongInt; ErrCode : PLongInt) : Longword; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_SetSvon_FF) (t_i32 NetID, t_i32 Axis, t_i32 SvonVal, _out t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxCtl_GetSvon) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
TEC_mSxCtl_GetSvon = function(NetID : LongInt; Axis : LongInt; Errcode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_SetAlmRst) (t_i32 NetID, t_i32 Axis, t_i32 IsSetAlmRst, _out t_i32 *ErrCode);
TEC_mSxCtl_SetAlmRst = function(NetID : LongInt; Axis : LongInt; IsSetAlmRst : LongInt; Errcode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_SetAlmRst_FF) (t_i32 NetID, t_i32 Axis, t_i32 IsSetAlmRst, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_ResetAlm) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxCtl_ResetAlm = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCtl_ResetAlm_FF) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);

//EC_EXTERN t_success	(CECAT_API *ecmSxMot_SetTargTorq) (t_i32 NetID, t_i32 Axis, t_i32 TargTorq, _out t_i32 *ErrCode);
TEC_mSxMot_SetTargTorq = function(NetID : LongInt; Axis : LongInt; TargTorq : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmSxMot_GetTargTorq) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxMot_GetTargTorq = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxMot_SetTargVel) (t_i32 NetID, t_i32 Axis, t_f64 TargVel, _out t_i32 *ErrCode);
TEC_mSxMot_SetTargVel = function(NetID : LongInt; Axis : LongInt; TargVel : Double; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_f64		(CECAT_API *ecmSxMot_GetTargVel) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxMot_GetTargVel = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Double; stdcall;

//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_VMoveStart) (t_i32 NetID, t_i32 Axis, t_i32 Dir, _out t_i32 *ErrCode);
TEC_mSxMot_VMoveStart = function(NetID : LongInt; Axis : LongInt; Dir : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_VMoveStart_FF) (t_i32 NetID, t_i32 Axis, t_i32 Dir, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_MoveStart) (t_i32 NetID, t_i32 Axis, t_f64 Distance, _out t_i32 *ErrCode);
TEC_mSxMot_MoveStart = function(NetID : LongInt; Axis : LongInt; Distance : Double; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_MoveStart_FF) (t_i32 NetID, t_i32 Axis, t_f64 Distance, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxMot_Move) (t_i32 NetID, t_i32 Axis, t_f64 Distance, _out t_i32 *ErrCode);
TEC_mSxMot_Move = function(NetID : LongInt; Axis : LongInt; Distance : Double; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxMot_Move_NB) (t_i32 NetID, t_i32 Axis, t_f64 Distance, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_MoveToStart) (t_i32 NetID, t_i32 Axis, t_f64 Position, _out t_i32 *ErrCode);
TEC_mSxMot_MoveToStart = function(NetID : LongInt; Axis : LongInt; Position : Double; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_MoveToStart_FF) (t_i32 NetID, t_i32 Axis, t_f64 Position, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxMot_MoveTo) (t_i32 NetID, t_i32 Axis, t_f64 Position, _out t_i32 *ErrCode);
TEC_mSxMot_MoveTo = function(NetID : LongInt; Axis : LongInt; Position : Double; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmSxMot_MoveTo_NB) (t_i32 NetID, t_i32 Axis, t_f64 Position, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_OverrideSpeed) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxMot_OverrideSpeed = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_OverrideMove) (t_i32 NetID, t_i32 Axis, t_f64 NewDist, _out t_bool *IsIgnored, _out t_i32 *ErrCode);
TEC_mSxMot_OverrideMove = function(NetID : LongInt; Axis : LongInt; NewDist : Double; IsIgnored : PBoolean; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_OverrideMoveTo) (t_i32 NetID, t_i32 Axis, t_f64 NewPos, _out t_bool *IsIgnored, _out t_i32 *ErrCode);
TEC_mSxMot_OverrideMoveTo = function(NetID : LongInt; Axis : LongInt; NewPos : Double; IsIgnored : Pboolean; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_Stop) (t_i32 NetID, t_i32 Axis, t_i32 IsDecStop, t_i32 IsWaitCompt, _out t_i32 *ErrCode);
TEC_mSxMot_Stop = function(NetID : LongInt; Axis : LongInt; IsDecStop : LongInt; IsWaitCompt : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMot_Stop_FF) (t_i32 NetID, t_i32 Axis, t_i32 IsDecStop, _out t_i32 *ErrCode);

//EC_EXTERN t_bool	(CECAT_API *ecmSxSt_IsConnected)(t_i32 NetID, t_i32 Axis, EEcmConnStsDetail *ConnStsDetail, t_i32 *ErrCode);
//EC_EXTERN void*		(CECAT_API *ecmSxSt_GetInPDOPtr)(t_i32 NetID, t_i32 Axis, t_ui8 *PDODataType, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxSt_IsBusy) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxSt_IsBusy = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Boolean; stdcall;

//EC_EXTERN t_success (CECAT_API *ecmSxSt_WaitCompt) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxSt_WaitCompt = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmSxSt_WaitCompt_NB) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxSt_SetCount) (t_i32 NetID, t_i32 Axis, t_i32 NewPosCount, _out t_i32 *ErrCode);
TEC_mSxSt_SetCount = function(NetID : LongInt; Axis : LongInt; NewPosCount : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_i32 	(CECAT_API *ecmSxSt_GetCount) (t_i32 NetID, t_i32 Axis, t_i32 TargCntr, _out t_i32 *ErrCode);
TEC_mSxSt_GetCount = function(NetID : LongInt; Axis : LongInt; TargCntr : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxSt_SetPosition) (t_i32 NetID, t_i32 Axis, t_f64 NewPosition, _out t_i32 *ErrCode);
TEC_mSxSt_SetPosition = function(NetID : LongInt; Axis : LongInt; NewPosition : Double; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_f64		(CECAT_API *ecmSxSt_GetPosition) (t_i32 NetID, t_i32 Axis, t_i32 TargCntr, _out t_i32 *ErrCode);
TEC_mSxSt_GetPosition = function(NetID : LongInt; Axis : LongInt; TargCntr : LongInt; ErrCode : PLongInt) : Double; stdcall;
//EC_EXTERN t_f64		(CECAT_API *ecmSxSt_GetCurSpeed) (t_i32 NetID, t_i32 Axis, t_i32 TargCntr, _out t_i32 *ErrCode);
TEC_mSxSt_GetCurSpeed = function(NetID : LongInt; Axis : LongInt; TargCntr : LongInt; ErrCode : PLongInt) : Double; stdcall;
//EC_EXTERN t_f64		(CECAT_API *ecmSxSt_GetCurTorque) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxSt_GetCurTorque = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Double; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmSxSt_GetMotState) (t_i32 NetID, t_i32 Axis, _out t_i32 *SubErrData); 
TEC_mSxSt_GetMotState = function(NetID : LongInt; Axis : LongInt; SubErrData : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_word	(CECAT_API *ecmSxSt_GetFlags) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxSt_GetFlags = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Word; stdcall;
//EC_EXTERN t_word	(CECAT_API *ecmSxSt_GetDI) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mSxSt_GetDI = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Word; stdcall;
//EC_EXTERN t_byte	(CECAT_API *ecmSxSt_GetTouchProbeSts) (t_i32 NetID, t_i32 Axis, t_i32 TouchProbeIndex, _out t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecmSxSt_GetTouchProbePos) (t_i32 NetID, t_i32 Axis, t_i32 TouchProbeIndex, _out t_i32 *ErrCode);
//EC_EXTERN t_ui8		(CECAT_API *ecmSxSt_GetOpModeDisp) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmSxSt_GetLmMapIdx) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode); 
//EC_EXTERN t_i32		(CECAT_API *ecmSxSt_GetPtmMapIdx) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode); 

//====================== MOTION - POSITION COMPARE OUTPUT FUNCTIONS =================================================//
//EC_EXTERN t_success (CECAT_API *ecmSxCmpOne_SetHandler) (t_i32 NetID, t_i32 Axis, t_i32 HandlerType, HANDLE Handler, UINT nMessage, LPARAM lParam, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpOne_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 GdoChanIdx, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxCmpOne_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32* GdoChanIdx, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpOne_SetEnv) (t_i32 NetID, t_i32 Axis, t_i32 CmpCntrType, t_i32 CmpMethod, t_f64 CmpRefPos, t_i32 OutSigLogic, t_i32 OutSigOnTime, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpOne_GetEnv) (t_i32 NetID, t_i32 Axis, t_i32* CmpCntrType, t_i32* CmpMethod, t_f64* CmpRefPos, t_i32* OutSigLogic, t_i32* OutSigOnTime, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpOne_GetOutSts) (t_i32 NetID, t_i32 Axis, t_i32 *OutCount, t_f64 *LastOutPos, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpOne_ResetOutSts) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 GdoChanIdx, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxCmpCont_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32* GdoChanIdx, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_SetTableSize) (t_i32 NetID, t_i32 Axis, t_i32 TableSize, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmSxCmpCont_GetTableSize) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_SetTableData) (t_i32 NetID, t_i32 Axis, t_i32 TableIndex, t_i32 CmpCntrType, t_i32 CmpMethod, t_f64 CmpRefPos, t_i32 OutSigLogic, t_i32 OutSigOnTime, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_GetTableData) (t_i32 NetID, t_i32 Axis, t_i32 TableIndex, t_i32* CmpCntrType, t_i32* CmpMethod, t_f64* CmpRefPos, t_i32* OutSigLogic, t_i32* OutSigOnTime, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmSxCmpCont_GetActTblIdx) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_SetActTblIdx) (t_i32 NetID, t_i32 Axis, t_i32 TableIndex, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_GetOutSts) (t_i32 NetID, t_i32 Axis, t_i32 *OutCount, t_f64 *LastOutPos, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCmpCont_ResetOutSts) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);

//====================== MOTION - MultiTorq FUNCTIONS =================================================//
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMulTorq1_Start) (t_i32 NetID, t_i32 Axis, t_i16 InitialTorq, TEcmMTQ1Item NextTorqList[], t_ui16 NumNextTorqItems, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxMulTorq1_Stop) (t_i32 NetID, t_i32 Axis, t_i16 StopTorq, t_bool IsApplyStopTorq, t_i32 *ErrCode);

//====================== MOTION - Slow Down(SD) FUNCTIONS =================================================//
//EC_EXTERN t_success	(CECAT_API *ecmSxSD_SetInputEnv) (t_i32 NetID, t_i32 Axis, t_dword LogBitAddr, t_bool IsInvertLogic, t_i32 FilterCount, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmSxSD_GetInputEnv) (t_i32 NetID, t_i32 Axis, t_dword *LogBitAddr, t_bool *IsInvertLogic, t_i32 *FilterCount, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmSxSD_SetSpeed) (t_i32 NetID, t_i32 Axis, t_f64 SdSpeed, t_i32 *ErrCode); 
//EC_EXTERN t_f64		(CECAT_API *ecmSxSD_GetSpeed) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmSxSD_SetOffset) (t_i32 NetID, t_i32 Axis, t_i32 OffsetMode, t_f64 Offset, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmSxSD_GetOffset) (t_i32 NetID, t_i32 Axis, t_i32 *OffsetMode, t_f64 *Offset, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxSD_SetLatchMode) (t_i32 NetID, t_i32 Axis, t_bool IsLatchMode, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxSD_GetLatchMode) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode); 
//EC_EXTERN t_success	(CECAT_API *ecmSxSD_SetEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmSxSD_GetEnable) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxSD_RestoreSpeed) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode); 
//EC_EXTERN t_bool	(CECAT_API *ecmSxSD_GetInputStatus) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode); 
//EC_EXTERN t_bool	(CECAT_API *ecmSxSD_GetActStatus) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);

//====================== MOTION - MULTIPLE AXES FUNCTIONS =================================================//
//EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_VMoveStart) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 DirList[], _out t_i32 *ErrCode);
TEC_mMxMot_VMoveStart = function(NetID : LongInt; NumAxes : LongInt; AxisList : PLongInt; DirList : PLongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_VMoveStart_FF) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 DirList[], _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_MoveStart) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_f64 DistList[], _out t_i32 *ErrCode);
TEC_mMxMot_MoveStart = function(NetID : LongInt; NumAxes : LongInt; AxisList : PLongInt; DistList : PDouble; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_MoveStart_FF) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_f64 DistList[], _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_MoveToStart) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_f64 PosList[], _out t_i32 *ErrCode);
TEC_mMxMot_MoveToStart = function(NetID : LongInt; NumAxes : LongInt; AxisList : PLongInt; DistList : PDouble; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_MoveToStart_FF) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_f64 PosList[], _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_Stop) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 IsDecStop, t_i32 IsWaitCompt, _out t_i32 *ErrCode);
TEC_mMxMot_Stop = function(NetID : LongInt; NumAxes : LongInt; AxisList : PLongInt; IsDecStop : LongInt; IsWaitCompt : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmMxMot_Stop_FF) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 IsDecStop, _out t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecmMxSt_IsBusy) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], _out t_i32 *ErrCode);
TEC_mMxSt_IsBusy = function(NetID : LongInt; NumAxes : LongInt; AxisList : PLongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmMxSt_WaitCompt) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 *ErrCode);
TEC_mMxSt_WaitCompt = function(NetID : LongInt; NumAxes : LongInt; AxisList : PLongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmMxSt_WaitCompt_NB) (t_i32 NetID, t_i32 NumAxes, t_i32 AxisList[], t_i32 *ErrCode);

//====================== MOTION - INTERPOLATION FUNCTIONS ================================================//
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_MapAxes) (t_i32 NetID, t_i32 MapIndex, t_i32 NumAxes, t_i32 AxisList[], _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_MapAxes_FF) (t_i32 NetID, t_i32 MapIndex, t_i32 NumAxes, t_i32 AxisList[], _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_UnmapAxes) (t_i32 NetID, t_i32 MapIndex, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_UnmapAxes_FF) (t_i32 NetID, t_i32 MapIndex, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetSpeedPatt) (t_i32 NetID, t_i32 MapIndex, t_i32 IxSpdPattType, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 Acc, t_f64 Dec, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetSpeedPatt_FF) (t_i32 NetID, t_i32 MapIndex, t_i32 IxSpdPattType, t_i32 SpeedMode, t_f64 VIni, t_f64 VEnd, t_f64 VWork, t_f64 Acc, t_f64 Dec, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxCfg_GetSpeedPatt) (t_i32 NetID, t_i32 MapIndex, t_i32 *IxSpdPattType, t_i32 *SpeedMode, t_f64 *VIni, t_f64 *VEnd, t_f64 *VWork, t_f64 *Acc, t_f64 *Dec, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetJerkRatio) (t_i32 NetID, t_i32 MapIndex, t_f64 JerkTimeRatio, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetJerkRatio_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 JerkTimeRatio, t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecmIxCfg_GetJerkRatio) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetSpeedPatt_MR) (t_i32 NetID, t_i32 MapIndex, t_i32 SpeedMode, t_f64 MasterRatio, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetSpeedPatt_MR_FF) (t_i32 NetID, t_i32 MapIndex, t_i32 SpeedMode, t_f64 MasterRatio, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxCfg_GetSpeedPatt_MR) (t_i32 NetID, t_i32 MapIndex, t_i32 *SpeedMode, t_f64 *MasterRatio, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxCfg_SetMastWeight) (t_i32 NetID, t_i32 MapIndex, t_f64 *MastWeightList, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxCfg_GetMastWeight) (t_i32 NetID, t_i32 MapIndex, t_f64 *MastWeightList, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_ClearPool) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode);
//EC_EXTERN t_handle32 (CECAT_API *ecmIxCfg_Spline_AddNewObj) (t_i32 NetID, t_i32 MapIndex,  t_ui32 NumRefPoints, t_bool IsAbsPosMode, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxCfg_Spline_SetRefPoint) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 PointIndex, t_f64 Point[], t_i32 NumPointData, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxCfg_Spline_BuildObj) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_SetTrgOutEnv) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_bool IsEnableTrgOut, t_i16 TrgOfsTime_ms, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_GetTrgOutEnv) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_bool* IsEnableTrgOut, t_i16* TrgOfsTime_ms, t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecmIxCfg_Spline_GetTrgOutPos) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 Axis, t_i32 PointIndex, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_SetJsType) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 JerkSmoothType, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmIxCfg_Spline_GetJsType) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_SetJsProp_F) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 PropId, t_f64 PropVal, t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecmIxCfg_Spline_GetJsProp_F) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 PropId, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxCfg_Spline_SetJerkThresh) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 Axis, t_f64 JerkThreshold, t_i32 *ErrCode);
//EC_EXTERN t_f64		(CECAT_API *ecmIxCfg_Spline_GetJerkThresh) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_i32 Axis, t_i32 *ErrCode);

//EC_EXTERN t_success	(CECAT_API *ecmIxCfg_MPRLin2X_ClearPool) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode);
//EC_EXTERN t_handle32 (CECAT_API *ecmIxCfg_MPRLin2X_AddNewObj) (t_i32 NetID, t_i32 MapIndex,  t_ui32 NumRefPoints, t_bool IsAbsPosMode, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxCfg_MPRLin2X_SetRefPoint) (t_i32 NetID, t_i32 MapIndex, t_handle32 hMPRLin2XObj, t_i32 PointIndex, t_f64 Point[], t_f64 RoundData, t_i32 RoundDataType, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxCfg_MPRLin2X_BuildObj) (t_i32 NetID, t_i32 MapIndex, t_handle32 hMPRLin2XObj, _out t_f64 LastPointBuf[], _out t_i32 *ErrCode);

//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_LineStart) (t_i32 NetID, t_i32 MapIndex, t_f64 DistList[], _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_LineStart_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 DistList[], _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxMot_Line) (t_i32 NetID, t_i32 MapIndex, t_f64 DistList[], _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxMot_Line_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 DistList[], _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_LineToStart) (t_i32 NetID, t_i32 MapIndex, t_f64 PosList[], _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_LineToStart_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 PosList[], _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxMot_LineTo) (t_i32 NetID, t_i32 MapIndex, t_f64 PosList[], _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxMot_LineTo_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 PosList[], _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_ArcAng_R_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_ArcAng_R_Start_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxMot_ArcAng_R) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxMot_ArcAng_R_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_ArcAng_A_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_ArcAng_A_Start_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcAng_A) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcAng_A_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_ArcPos_R_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 XEndOffset, t_f64 YEndOffset, t_i32 Direction, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_ArcPos_R_Start_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 XEndOffset, t_f64 YEndOffset, t_i32 Direction, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcPos_R) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 XEndOffset, t_f64 YEndOffset, t_i32 Direction, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcPos_R_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentOffset, t_f64 YCentOffset, t_f64 XEndOffset, t_f64 YEndOffset, t_i32 Direction, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_ArcPos_A_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 XEndPos, t_f64 YEndPos, t_i32 Direction, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_ArcPos_A_Start_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 XEndPos, t_f64 YEndPos, t_i32 Direction, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcPos_A) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 XEndPos, t_f64 YEndPos, t_i32 Direction, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxMot_ArcPos_A_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 XCentPos, t_f64 YCentPos, t_f64 XEndPos, t_f64 YEndPos, t_i32 Direction, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_Arc3P_R_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XOffset, t_f64 P2_YOffset, t_f64 P3_XOffset, t_f64 P3_YOffset, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_Arc3P_R_Start_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XOffset, t_f64 P2_YOffset, t_f64 P3_XOffset, t_f64 P3_YOffset, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxMot_Arc3P_R) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XOffset, t_f64 P2_YOffset, t_f64 P3_XOffset, t_f64 P3_YOffset, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxMot_Arc3P_R_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XOffset, t_f64 P2_YOffset, t_f64 P3_XOffset, t_f64 P3_YOffset, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_Arc3P_A_Start) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XPos, t_f64 P2_YPos, t_f64 P3_XPos, t_f64 P3_YPos, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx 	(CECAT_API *ecmIxMot_Arc3P_A_FF) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XPos, t_f64 P2_YPos, t_f64 P3_XPos, t_f64 P3_YPos, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxMot_Arc3P_A) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XPos, t_f64 P2_YPos, t_f64 P3_XPos, t_f64 P3_YPos, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmIxMot_Arc3P_A_NB) (t_i32 NetID, t_i32 MapIndex, t_f64 P2_XPos, t_f64 P2_YPos, t_f64 P3_XPos, t_f64 P3_YPos, t_f64 RotAngle_Deg, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_Spline_Start) (t_i32 NetID, t_i32 MapIndex, t_handle32 hSplineObj, t_bool IsReverseDir, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_MPRLin2X_Start) (t_i32 NetID, t_i32 MapIndex, t_handle32 hMPRLin2XObj, t_bool IsReverseDir, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_MoveVia2X_Start) (t_i32 NetID, t_ui16 MapIndex, t_f64 P2[], t_f64 P3[], t_bool IsAbsPosMode, t_i32 RoundPosType, t_f64 NormRadius, t_f64 MinRadius, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_MoveVia2X_OverrideTP) (t_i32 NetID, t_ui16 MapIndex, t_f64 TP_new[], t_f64 RoundRadius, _out t_bool *IsIgnored, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_Stop) (t_i32 NetID, t_i32 MapIndex, t_i32 IsDecStop, t_i32 IsWaitCompt, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmIxMot_Stop_FF) (t_i32 NetID, t_i32 MapIndex, t_i32 IsDecStop, _out t_i32 *ErrCode);

//EC_EXTERN t_bool	(CECAT_API *ecmIxSt_IsBusy) (t_i32 NetID, t_i32 MapIndex, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxSt_WaitCompt) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmIxSt_WaitCompt_NB) (t_i32 NetID, t_i32 MapIndex, t_i32 *ErrCode);

//====================== MOTION - HOMING OPERATION FUNCTIONS ============================================//
//EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeCfg_SetMode) (t_i32 NetID, t_i32 Axis, t_i32 HomeOpMode, _out t_i32 *ErrCode);
TEC_mHomeCfg_SetMode = function(NetID : LongInt; Axis : LongInt; HomeOpMode : LongInt; Errcode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmHomeCfg_GetMode) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mHomeCfg_GetMode = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : LongInt; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeCfg_SetOffset) (t_i32 NetID, t_i32 Axis, t_f64 Offset, _out t_i32 *ErrCode);
TEC_mHomeCfg_SetOffset = function(NetID : LongInt; Axis : LongInt; OffSet : Double; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_f64		(CECAT_API *ecmHomeCfg_GetOffset) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mHomeCfg_GetOffset = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Double; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeCfg_SetSpeedPatt) (t_i32 NetID, t_i32 Axis, t_i32 SpeedMode, t_f64 Vel, t_f64 Acc, t_f64 Dec, t_f64 HomeSpecVel, _out t_i32 *ErrCode);
TEC_mHomeCfg_SetSpeedPatt = function(NetID : LongInt; Axis : LongInt; SpeedMode : LongInt; Vel : Double; Acc : Double; Dec : Double; HomeSpecVel : Double; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmHomeCfg_GetSpeedPatt) (t_i32 NetID, t_i32 Axis, t_i32* SpeedMode, t_f64* Vel, t_f64* Acc, t_f64* Dec, t_f64* HomeSpecVel, _out t_i32 *ErrCode);
TEC_mHomeCfg_GetSpeedPatt = function(NetID : LongInt; Axis : LongInt; SpeeMode : PLongInt; Vel : PDouble; Acc : PDouble; Dec : PDouble; HomeSpecVel : PDouble; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeCfg_SetOption) (t_i32 NetID, t_i32 Axis, EEcmHomeOptID OptionID, t_i32 OptionVal, t_i32 *ErrCode);
TEC_mHomeCfg_SetOption = function(NetID : LongInt; Axis : LongInt; OptionID : Byte; OptionVal : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_i32		(CECAT_API *ecmHomeCfg_GetOption) (t_i32 NetID, t_i32 Axis, EEcmHomeOptID OptionID, t_i32 *ErrCode);
TEC_mHomeCfg_GetOption = function(NetID : LongInt; Axis : LongInt; OptionID : LongInt; ErrCode : PLongInt) : LongInt; stdcall;

//EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeMot_MoveStart) (t_i32 NetID, t_i32 Axis, t_i32 Direction, _out t_i32 *ErrCode);
TEC_mHomeMot_MoveStart = function(NetID : LongInt; Axis : LongInt; Direction : LongInt; ErrCode : PLongInt) : LongWord; stdcall;
//EC_EXTERN t_cmdidx	(CECAT_API *ecmHomeMot_MoveStart_FF) (t_i32 NetID, t_i32 Axis, t_i32 Direction, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmHomeMot_Move) (t_i32 NetID, t_i32 Axis, t_i32 Direction, _out t_i32 *ErrCode);
TEC_mHomeMot_Move = function(NetID : LongInt; Axis : LongInt; Direction : LongInt; ErrCode : PLongInt) : Boolean; stdcall;

//EC_EXTERN t_bool	(CECAT_API *ecmHomeSt_IsBusy) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mHomeSt_IsBusy = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success	(CECAT_API *ecmHomeSt_WaitCompt) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mHomeSt_WaitCompt = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_word	(CECAT_API *ecmHomeSt_GetFlags) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mHomeSt_GetFlags = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Word; stdcall;
//====================== MOTION - Master/Slave FUNCTIONS ============================================//
//EC_EXTERN t_success (CECAT_API *ecmMsCfg_SetSlvEnv) (t_i32 NetID, t_i32 Axis, t_i32 MasterAxis, t_f64 PosRatio, _out t_i32 *ErrCode);
TEC_mMsCfg_SetSlvEnv = function(NetID : LongInt; Axis : LongInt; MastAxis : LongInt; PosRatio : Double; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmMsCfg_GetSlvEnv) (t_i32 NetID, t_i32 Axis, t_i32* MasterAxis, t_f64* PosRatio, _out t_i32 *ErrCode);
TEC_mMsCfg_GetSlvEnv = function(NetID : LongInt; Axis : LongInt; MasterAxis : PLongInt; PosRatio : PDouble; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmMsCtl_StartSlv) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mMsCtl_StartSlv = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmMsCtl_StopSlv) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mMsCtl_StopSlv = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_success (CECAT_API *ecmMsCtl_SynchSlv) (t_i32 NetID, t_i32 Axis, t_f64 MastPosOfs, t_bool IsWaitMoveCompt, _out t_i32 *ErrCode);
TEC_mMsCtl_SynchSlv = function(NetID : LongInt; Axis : LongInt; MastPosOfs : Double; IsWaitMoveCompt : Boolean; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN t_bool	(CECAT_API *ecmMsSt_IsSlvStarted) (t_i32 NetID, t_i32 Axis, _out t_i32 *ErrCode);
TEC_mMsSt_IsSlvStarted = function(NetID : LongInt; Axis : LongInt; ErrCode : PLongInt) : Boolean; stdcall;


//====================== MOTION - ListMotion FUNCTIONS ============================================//
//EC_EXTERN t_success	(CECAT_API *ecmLmResetAll) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCtl_Begin) (t_i32 NetID, t_i32 LmMapIndex, t_ui32 AxisMask1, t_ui32 AxisMask2, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCtl_End) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCtl_Run) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCtl_Stop) (t_i32 NetID, t_i32 LmMapIndex, t_bool IsComptCurStep, t_i32 DecelTime_ms, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCtl_ClearQue) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCfg_SetQueFullMode) (t_i32 NetID, t_i32 LmMapIndex, t_i32 QueFullMode, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmLmCfg_GetQueFullMode) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCfg_SetQueDepth) (t_i32 NetID, t_i32 LmMapIndex, t_i32 QueDepth, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmLmCfg_GetQueDepth) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCfg_SetStepId) (t_i32 NetID, t_i32 LmMapIndex, t_i32 StepId, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmLmCfg_GetStepId) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCfg_SetStepParam) (t_i32 NetID, t_i32 LmMapIndex, t_i32 StepParam1, t_i32 StepParam2, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCfg_GetStepParam) (t_i32 NetID, t_i32 LmMapIndex, t_dword *StepParam1, t_dword *StepParam2, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmLmSt_GetRunSts) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmLmSt_GetRemStepCount) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmSt_GetRunStepInfo) (t_i32 NetID, t_i32 LmMapIndex, t_i32 *RunStepCount, t_i32 *RunStepId, t_i32 *RunStepSts, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmSt_GetRunStepParam) (t_i32 NetID, t_i32 LmMapIndex, t_dword *StepParam1, t_dword *StepParam2, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmLmCmd_Delay) (t_i32 NetID, t_i32 LmMapIndex, t_i32 DelayTime_ms, t_i32 *ErrCode);

//====================== MOTION - PT-Motion FUNCTIONS ============================================//
//EC_EXTERN t_success	(CECAT_API *ecmPtmResetAll) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmPtmCtl_Begin) (t_i32 NetID, t_i32 PtmMapIndex, t_ui32 AxisMask1, t_ui32 AxisMask2, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmPtmCtl_End) (t_i32 NetID, t_i32 PtmMapIndex, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmPtmCtl_SetHold) (t_i32 NetID, t_i32 PtmMapIndex, t_bool IsHold, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmPtmCmd_AddItem_PT) (t_i32 NetID, t_i32 PtmMapIndex, t_f64 DurTime, t_f64 PosDataList[], t_i32 NumPosData, t_bool IsAbsPos, t_i32 *ErrCode);
//EC_EXTERN EEcmPtmSts (CECAT_API *ecmPtmSt_GetRunSts) (t_i32 NetID, t_i32 PtmMapIndex, t_i32 *RunStepCount, t_i32 *RemStepCount, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmPtmSt_GetRunStepInfo) (t_i32 NetID, t_i32 PtmMapIndex, t_i32 *RunStepCount, t_i32 *RunStepSts, t_i32 *ErrCode);


//*****************************************************************************************************************************
//*
//*							Functions for Advanced Users
//*
//*****************************************************************************************************************************
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetJerkMode) (t_i32 NetID, t_i32 Axis, t_i32 JerkMode, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmSxCfg_GetJerkMode) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetJerk) (t_i32 NetID, t_i32 Axis, t_f64 AccJerk1, t_f64 AccJerk2, t_f64 DecJerk1, t_f64 DecJerk2, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_GetJerk) (t_i32 NetID, t_i32 Axis, t_f64 *AccJerk1, t_f64 *AccJerk2, t_f64 *DecJerk1, t_f64 *DecJerk2, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetSecondaryAcc) (t_i32 NetID, t_i32 Axis, BOOL IsEnable, t_f64 SecondaryAcc, t_f64 ThesholdVel, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_GetSecondaryAcc) (t_i32 NetID, t_i32 Axis, BOOL *IsEnable, t_f64 *SecondaryAcc, t_f64 *ThesholdVel, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_SetSecondaryDec) (t_i32 NetID, t_i32 Axis, BOOL IsEnable, t_f64 SecondaryDec, t_f64 ThesholdVel, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmSxCfg_GetSecondaryDec) (t_i32 NetID, t_i32 Axis, BOOL *IsEnable, t_f64 *SecondaryDec, t_f64 *ThesholdVel, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecmSxCfg_SetSpeedPatt_Ex1) (t_i32 NetID, t_i32 Axis, t_f64 VMid, t_f64 Acc2, t_bool IsApplyToDecelAlso, t_f64 Jerk, t_i32 *ErrCode);
//====================== DEBUG LOGGING FUNCTIONS =========================================================//
//EC_EXTERN t_success (CECAT_API *ecDlog_SetFilePath) (char* szLogFilePath, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecDlog_GetFilePath) (char *pszLogFilePath, t_i32 BufLen, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecDlog_SetLogType) (int LogType, t_i32 *ErrCode);
//EC_EXTERN int		(CECAT_API *ecDlog_GetLogType) (t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecDlog_SetLogLevel) (int LogLevel, t_i32 *ErrCode);
//EC_EXTERN int		(CECAT_API *ecDlog_GetLogLevel) (t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecDlog_SetLogMemSize) (int SizeKB, int *ErrCode);
//EC_EXTERN t_ui32	(CECAT_API *ecDlog_GetLogMemSize) (t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecDlog_DumpMemoryLog) (int *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecDlog_DumpMemoryLog2) (char* szFilePath, int *ErrCode);
//EC_EXTERN char*		(CECAT_API *ecDlog_GetLastDumpFilePath) (t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecDlog_GetMemoryLogSts) (ULONGLONG *pBufSize, ULONGLONG *pWriteCount,  t_i32 *ErrCode);

//====================== NET INTERFACE FUNCTIONS =========================================================//
//EC_EXTERN t_success (CECAT_API *ecNet_SetFastFuncType) (t_i32 NetID, t_ui8 FastCmdType, t_i32 *ErrCode);
//EC_EXTERN t_ui8		(CECAT_API *ecNet_GetFastFuncType) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecNet_InPDO_GetSectPos) (t_i32 NetID, t_ui16 SectionID, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecNet_OutPDO_GetSectPos) (t_i32 NetID, t_ui16 SectionID, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_InQue_ClearChanList) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN HANDLE 	(CECAT_API *ecNet_InQue_AddChannel) (t_i32 NetID, TEcInQueDataDesc *pDataDescList, int NumDataDescLisItems, t_i32 QueBufDepth, t_bool IsCircular, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_InQue_DelChannel) (t_i32 NetID, HANDLE QueChanHandle, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecNet_InQue_GetNumDataDescItems) (t_i32 NetID, HANDLE QueChanHandle, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_InQue_GetDataDesc) (t_i32 NetID, HANDLE QueChanHandle, t_i32 ItemIndex, TEcInQueDataDesc *pDataDesc, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_InQue_GetQueSizeInfo)	(t_i32 NetID, HANDLE QueChanHandle, t_i32 *QueItemSize, t_i32 *QueBufDepth, t_bool *IsCircular, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_InQue_SetStaTrgEnv) (t_i32 NetID, HANDLE QueChanHandle, TEcInQueTrgCfg *pTrgCfgData, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_InQue_GetStaTrgEnv) (t_i32 NetID, HANDLE QueChanHandle, TEcInQueTrgCfg *pTrgCfgBuf, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_InQue_SetStopTrgEnv) (t_i32 NetID, HANDLE QueChanHandle, TEcInQueTrgCfg *pTrgCfgData, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_InQue_GetStopTrgEnv) (t_i32 NetID, HANDLE QueChanHandle, TEcInQueTrgCfg *pTrgCfgBuf, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_InQue_StartChannel) (t_i32 NetID, HANDLE QueChanHandle, t_i32 SamplingInterval, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_InQue_StopChannel) (t_i32 NetID, HANDLE QueChanHandle, t_i32 *ErrCode);
//EC_EXTERN t_i32 	(CECAT_API *ecNet_InQue_GetQueuedCount) (t_i32 NetID, HANDLE QueChanHandle, t_i32 *ErrCode);
//EC_EXTERN t_i32 	(CECAT_API *ecNet_InQue_Deque) (t_i32 NetID, HANDLE QueChanHandle, void *pBuf, int nBufSize, t_i32 ReqDequeCnt, t_i32 *ErrCode);
//EC_EXTERN t_i32 	(CECAT_API *ecNet_InQue_PeekData) (t_i32 NetID, HANDLE QueChanHandle, void *pBuf, int nBufSize, int nStartIndex, t_i32 ReqPeekCnt, t_i32 *ErrCode);
//EC_EXTERN HANDLE	(CECAT_API *ecNet_InQue_AddCommonTrg) (t_i32 NetID, TEcInQueCommonTrg *pCommonTrgObj, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_InQue_DelCommonTrg) (t_i32 NetID, HANDLE CommTrgHandle, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_InQue_EnableCommonTrg) (t_i32 NetID, HANDLE CommTrgHandle, t_bool IsEanble, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_InQue_SetCommonTrgState) (t_i32 NetID, HANDLE CommTrgHandle, t_bool State, t_i32 *ErrCode);
//EC_EXTERN t_pdoidx	(CECAT_API *ecNet_GetLastPDOIdx) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecNet_IsPDOIdxCompt) (t_i32 NetID, t_pdoidx PDOIdx, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_WaitPDOIdxCompt) (t_i32 NetID, t_pdoidx PDOIdx, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_WaitPDOIdxCompt_NB) (t_i32 NetID, t_pdoidx PDOIdx, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecNet_IsCmdIdxCompt) (t_i32 NetID, t_cmdidx CmdIdx, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_WaitCmdIdxCompt) (t_i32 NetID, t_cmdidx CmdIdx, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecNet_WaitCmdIdxCompt_NB) (t_i32 NetID, t_cmdidx CmdIdx, t_i32 *ErrCode);
//EC_EXTERN t_ui32	(CECAT_API *ecNet_GetCycleProcessTime) (t_i32 NetID, t_ui8 ProcTimeType, t_i32 *ErrCode);

//====================== ECAT CONFIG FUNCTIONS ==========================================================//
//EC_EXTERN t_success (CECAT_API *ecCfgFile_Download) (char *szFilePath, t_i32 DevIdx, t_i32 LocNetIdx, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecCfgFile_Verify) (char *szFilePath, t_i32 DevIdx, t_i32 LocNetIdx, t_i32 *ErrCode);

//====================== MOTION - Motor Performance Monitor(MPMon) FUNCTIONS ============================================//
//EC_EXTERN t_success (CECAT_API *ecmMPMon_AddAxis) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmMPMon_DelAxis) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecmMPMon_SetAxisEnable) (t_i32 NetID, t_i32 Axis, t_bool IsEnable, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecmMPMon_GetAxisStatus) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmMPMon_ResetAxisData) (t_i32 NetID, t_i32 Axis, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmMPMon_ResetSectData) (t_i32 NetID, t_i32 Axis, t_ui16 SectIdx, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmMPMon_SetTorqThreshVal) (t_i32 NetID, t_i32 Axis, t_ui16 SectIdx, t_ui16 TorqThresholdVal, t_i32 *ErrCode);
//EC_EXTERN t_ui16	(CECAT_API *ecmMPMon_GetTorqThreshVal) (t_i32 NetID, t_i32 Axis, t_ui16 SectIdx, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmMPMon_SetDevThreshVal) (t_i32 NetID, t_i32 Axis, t_ui16 SectIdx, t_ui32 DevThresholdVal, t_i32 *ErrCode);
//EC_EXTERN t_ui32	(CECAT_API *ecmMPMon_GetDevThreshVal) (t_i32 NetID, t_i32 Axis, t_ui16 SectIdx, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmMPMon_ReadAxisData) (t_i32 NetID, t_i32 Axis, TMPMonData *pBuffer, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecmMPMon_WriteAxisData) (t_i32 NetID, t_i32 Axis, TMPMonData *pMPMonData, t_i32 *ErrCode);

//*****************************************************************************************************************************
//*
//*							Functions for Internal System Users
//*
//*****************************************************************************************************************************

//====================== GENERAL FUNCTIONS ==============================================================//
//EC_EXTERN ULONG		(CECAT_API *ecGn_GetDebugData) (t_i32 DevIdx, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_OutpB) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_byte Data, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_OutpsB) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_i32 Count, t_byte* pData, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_OutpW) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_word Data, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_OutpsW) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_i32 Count, t_word* pData, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_OutpD) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_dword Data, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_OutpsD) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_i32 Count, t_dword* pData, t_i32 *ErrCode);
//EC_EXTERN t_byte	(CECAT_API *ecGn_InpB) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_InpsB) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_i32 Count, t_byte* pBuffer, t_i32 *ErrCode);
//EC_EXTERN t_word	(CECAT_API *ecGn_InpW) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_InpsW) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_i32 Count, t_word* pBuffer, t_i32 *ErrCode);
//EC_EXTERN t_dword	(CECAT_API *ecGn_InpD) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_InpsD) (t_i32 DevIdx, t_i32 CS, t_i32 ByteOffset, t_i32 Count, t_dword* pBuffer, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_DbgTempCmd) (t_i32 DevIdx, t_i32 Data1, t_i32 Data2, t_i32 Data3, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecGn_ReadInPDO) (t_i32 NetID, t_ui32 StartAddr, t_ui32 Size, void* pBuf, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecGn_ReadDspDbgData_I) (t_i32 NetID, t_ui8 DspCoreIdx, t_ui16 IniArrayIdx, t_ui16 NumData, t_i32* pBuf, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecGn_WriteDspDbgData_I) (t_i32 NetID, t_ui8 DspCoreIdx, t_ui16 IniArrayIdx, t_ui16 NumData, t_i32* pBuf, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecGn_ReadDspDbgData_F) (t_i32 NetID, t_ui8 DspCoreIdx, t_ui16 IniArrayIdx, t_ui16 NumData, t_f64* pBuf, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecGn_WriteDspDbgData_F) (t_i32 NetID, t_ui8 DspCoreIdx, t_ui16 IniArrayIdx, t_ui16 NumData, t_f64* pBuf, t_i32 *ErrCode);

//====================== NET INTERFACE FUNCTIONS =========================================================//
//EC_EXTERN t_success (CECAT_API *ecNet_SetEnableSTM) (t_i32 NetID, t_bool IsEnable, t_i32 *ErrCode);
//EC_EXTERN t_cmdidx	(CECAT_API *ecNet_SendRcvEcatCmd) (t_i32 NetID, EEcEcatCmd EcatCmd, t_ui16 ADP, t_ui16 ADO, t_ui16 DataSize, t_byte *pDataBuf, t_ui32 Timeout, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_FWDnld_Process) (t_i32 NetID, t_char szFilePath[], t_bool IsVerify, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_FWDnld_Cancel) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_FWDnld_GetSts) (t_i32 NetID, TEcFwuStatus *pStsBuf, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_FWDnld_ResetSts) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_FWUpld_GetFileInfo) (t_i32 NetID, TEcFwuFileInfo *pFileInfo, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_FWUpld_Process) (t_i32 NetID, t_char szFilePath[], t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_FWUpld_Cancel) (t_i32 NetID, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_FWUpld_GetSts) (t_i32 NetID, TEcFwuStatus *pStsBuf, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecNet_FWUpld_ResetSts) (t_i32 NetID, t_i32 *ErrCode);

//====================== ECAT CONFIG FUNCTIONS ==========================================================//
//EC_EXTERN t_success (CECAT_API *ecCfg_Start) (t_i32 NetID, BOOL IsApplyTimeout, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecCfg_End) (t_i32 NetID, BOOL IsSave, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecCfg_SetNetConfig) (t_i32 NetID, _in TEcNetConfig *pNetCfgHeader, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecCfg_GetNetConfig) (t_i32 NetID, _out TEcNetConfig *pNetCfgHeader, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecCfg_SetOutPDOLogicSect) (t_i32 NetID, t_i32 SectIdx, _in TEcLogMemSectCfg *pCfgData, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecCfg_GetOutPDOLogicSect) (t_i32 NetID, t_i32 SectIdx, _out TEcLogMemSectCfg *pCfgData, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecCfg_SetInPDOLogicSect) (t_i32 NetID, t_i32 SectIdx, _in TEcLogMemSectCfg *pCfgData, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecCfg_GetInPDOLogicSect) (t_i32 NetID, t_i32 SectIdx, _out TEcLogMemSectCfg *pCfgData, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecCfg_SetSlaveConfig) (t_i32 NetID, t_i32 SlaveIdx, _in TEcSlaveCfg *pCfgData, _out t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecCfg_GetSlaveConfig) (t_i32 NetID, t_i32 SlaveIdx, _out TEcSlaveCfg *pCfgData, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecCfg_SetChanMap) (t_i32 NetID, t_ui8 MapType, t_i32 ChanMapIdx, _in void* pChanMapData, t_i32 ChanMapDataSize, _out t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecCfg_GetChanMap) (t_i32 NetID, t_ui8 MapType, t_i32 ChanMapIdx, _in void* pChanMapBuf, t_i32 ChanMapBufSize, _out t_i32 *ErrCode);

//====================== XML FILE READING FUNCTIONS ==========================================================//
//EC_EXTERN HANDLE	(CECAT_API *ecXml_LoadByProdInfo) (char *szXmlDirectory, TEcSlvProdInfo *pProdInfo, _out char *szFileNameBuf, t_i32 FileNameBufLen, t_i32 *ErrCode);
//EC_EXTERN HANDLE	(CECAT_API *ecXml_LoadByFileName) (char *szXmlDirectory, char *szFileName, t_i32 *ErrCode);
//EC_EXTERN void		(CECAT_API *ecXml_Unload) (HANDLE XmlHandle, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_GetTagName) (HANDLE XmlHandle, char *szTagNameBuf, t_i32 TagNameBufLen, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecXml_GetNumElem) (HANDLE XmlHandle, t_bool IsResetPos, const char *szElemPath, t_i32 *ErrCode);
//EC_EXTERN t_success	(CECAT_API *ecXml_FindElem) (HANDLE XmlHandle, t_bool IsResetPos, const char *szElemPath, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_IntoElem) (HANDLE XmlHandle, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_OutOfElem) (HANDLE XmlHandle, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_ResetPos) (HANDLE XmlHandle, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_SavePos) (HANDLE XmlHandle, char *szPosName, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_RestorePos) (HANDLE XmlHandle, char *szPosName, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_ReadElemData) (HANDLE XmlHandle, char *szDataBuf, t_i32 DataBufLen, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_ReadElemAttr) (HANDLE XmlHandle, const char *szAttrName, char *szDataBuf, t_i32 DataBufLen, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_FindReadElemData) (HANDLE XmlHandle, t_bool IsResetPos, const char *szElemPath, char *szDataBuf, t_i32 DataBufLen, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_FindReadElemAttr) (HANDLE XmlHandle, t_bool IsResetPos, const char *szElemPath, const char *szElemAttrName, char *szDataBuf, t_i32 DataBufLen, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_FindDeviceByProdInfo) (HANDLE XmlHandle, TEcSlvProdInfo *pProdInfo, t_i32 *ErrCode);
//EC_EXTERN t_bool	(CECAT_API *ecXml_Str2Bool) (char *szString, t_i32 *ErrCode);
//EC_EXTERN t_i32		(CECAT_API *ecXml_Str2HexDec) (char *szString, t_i32 *ErrCode);
//EC_EXTERN t_success (CECAT_API *ecXml_GetProdDesc) (HANDLE XmlHandle, char *szLcId, TEcSlvProdInfo *pProdInfo, TEcSlvProdDesc *pProdDesc, t_i32 *ErrCode);

//====================== SLAVE I/F FUNCTIONS ============================================================//
//EC_EXTERN t_i32			(CECAT_API *ecSlv_ReadEEPR) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 EeeprAddr, t_i32 DataSize, _out void  *pBuf, _out t_i32 *ErrCode);
//EC_EXTERN t_i32			(CECAT_API *ecSlv_ReadEEPR_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 EeeprAddr, t_i32 DataSize, _out void  *pBuf, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteEEPR) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 EeeprAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteEEPR_FF) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 EeeprAddr, t_i32 DataSize, void *pData, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteEEPR_A) (t_i32 NetID, t_i32 SlaveIdx, t_i32 EeeprAddr, t_i32 DataSize, void  *pData, _out t_i32 *ErrCode);
//EC_EXTERN t_cmdidx		(CECAT_API *ecSlv_WriteEEPR_A_FF) (t_i32 NetID, t_i32 SlaveIdx, t_i32 EeeprAddr, t_i32 DataSize, void  *pData, _out t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecSlv_RenewCrcOfEEPR_A) (t_i32 NetID, t_ui16 SlaveIndex, t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecSlv_RenewCrcOfEEPR) (t_i32 NetID, t_ui16 SlvPhysAddr, t_i32 *ErrCode);
//EC_EXTERN t_ui16		(CECAT_API *ecSlv_ReadReg134ID_A) (t_i32 NetID, t_i32 SlaveIdx, _out t_i32 *ErrCode);
//EC_EXTERN t_ui16		(CECAT_API *ecSlv_ReadReg134ID) (t_i32 NetID, t_ui16 SlvPhysAddr, _out t_i32 *ErrCode);
//EC_EXTERN t_success		(CECAT_API *ecSlv_SetAlState_A) (t_i32 NetID, t_ui16 SlaveIdx, EEcAlState AlState, _out t_i32 *ErrCode);
TEC_Slv_SetAlState_A = function(NetID : LongInt; Axis : LongInt; SlvaeIdx : Word; AlState : Byte; ErrCode : PLongInt) : Boolean; stdcall;
//EC_EXTERN TEcSdoiODList*	(CECAT_API *ecSlv_SdoInfo_GetODList) (t_i32 NetID, t_ui16 SlvPhysAddr, EEcSdoiODListType ODListType, _out t_i32 *ErrCode);
//EC_EXTERN TEcSdoiODList*	(CECAT_API *ecSlv_SdoInfo_GetODList_A) (t_i32 NetID, t_ui16 SlaveIdx, EEcSdoiODListType ODListType, _out t_i32 *ErrCode);
//EC_EXTERN TEcSdoiObjDesc*	(CECAT_API *ecSlv_SdoInfo_GetObjDesc) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui16 ObjIndex, _out t_i32 *ErrCode);
//EC_EXTERN TEcSdoiObjDesc*	(CECAT_API *ecSlv_SdoInfo_GetObjDesc_A) (t_i32 NetID, t_ui16 SlaveIdx, t_ui16 ObjIndex, _out t_i32 *ErrCode);
//EC_EXTERN TEcSdoiEntryDesc* (CECAT_API *ecSlv_SdoInfo_GetEntryDesc) (t_i32 NetID, t_ui16 SlvPhysAddr, t_ui16 ObjIndex, t_ui8 SubIndex, t_ui8 ValueInfo, _out t_i32 *ErrCode);
//EC_EXTERN TEcSdoiEntryDesc* (CECAT_API *ecSlv_SdoInfo_GetEntryDesc_A) (t_i32 NetID, t_ui16 SlaveIdx, t_ui16 ObjIndex, t_ui8 SubIndex, t_ui8 ValueInfo, _out t_i32 *ErrCode);
//EC_EXTERN t_success			(CECAT_API *ecSlv_SdoInfo_ReleaseData) (t_i32 NetID, t_ui16 SlaveIdx, void *pSdoiStruct, _out t_i32 *ErrCode);

	var
	
	
	ecGn_LoadDevice					         	: TEC_Gn_LoadDevices;
	ecGn_UnloadDevices					      : TEC_Gn_UnloadDevices;
//	ecGn_SetBootWaitMode			     	: TEC_Gn_SetBootWaitMode
//	ecGn_GetBootWaitMode			     	: TEC_Gn_GetBootWaitMode
//	ecGn_SetEnableTimerResolSet			: TEC_Gn_SetEnableTimerResolSet
//	ecGn_GetEnableTimerResolSet			: TEC_Gn_GetEnableTimerResolSet
	ecGn_IsDevLoaded					        : TEC_Gn_IsDevLoaded;
	ecGn_GetNumDevices					      : TEC_Gn_GetNumDevices;
	ecGn_GetNumNetworks					      : TEC_Gn_GetNumNetworks;
//	ecGn_GetDevInfo						      : TEC_Gn_GetDevInfo
//	ecGn_GetDebugData					      : TEC_Gn_GetDebugData
//	ecGn_OutpB						         	: TEC_Gn_OutpB
//	ecGn_OutpsB						         	: TEC_Gn_OutpsB
//	ecGn_OutpW						         	: TEC_Gn_OutpW
//	ecGn_OutpsW						         	: TEC_Gn_OutpsW
//	ecGn_OutpD						         	: TEC_Gn_OutpD
//	ecGn_OutpsD						         	: TEC_Gn_OutpsD
//	ecGn_InpB							          : TEC_Gn_InpB
//	ecGn_InpsB						         	: TEC_Gn_InpsB
//	ecGn_InpW							          : TEC_Gn_InpW
//	ecGn_InpsW						         	: TEC_Gn_InpsW
//	ecGn_InpD							          : TEC_Gn_InpD
//	ecGn_InpsD						         	: TEC_Gn_InpsD
//	ecGn_DbgTempCmd				      		: TEC_Gn_DbgTempCmd
//	ecGn_ReadInPDO				      		: TEC_Gn_ReadInPDO
//	ecGn_ReadDspDbgData_I				: TEC_Gn_ReadDspDbgData_I
//	ecGn_WriteDspDbgData_I				: TEC_Gn_WriteDspDbgData_I
//	ecGn_ReadDspDbgData_F				: TEC_Gn_ReadDspDbgData_F
//	ecGn_WriteDspDbgData_F				: TEC_Gn_WriteDspDbgData_F
//	ecDlog_SetFilePath					: TEC_Dlog_SetFilePath
//	ecDlog_GetFilePath					: TEC_Dlog_GetFilePath
//	ecDlog_SetLogType					: TEC_Dlog_SetLogType
//	ecDlog_GetLogType					: TEC_Dlog_GetLogType
//	ecDlog_SetLogLevel					: TEC_Dlog_SetLogLevel
//	ecDlog_GetLogLevel					: TEC_Dlog_GetLogLevel	
//	ecDlog_SetLogMemSize				: TEC_Dlog_SetLogMemSize
//	ecDlog_GetLogMemSize				: TEC_Dlog_GetLogMemSize
//	ecDlog_GetMemoryLogSts				: TEC_Dlog_GetMemoryLogSts	
//	ecDlog_DumpMemoryLog				: TEC_Dlog_DumpMemoryLog
//	ecDlog_DumpMemoryLog2				: TEC_Dlog_DumpMemoryLog2
//	ecDlog_GetLastDumpFilePath			: TEC_Dlog_GetLastDumpFilePath
	ecNet_IsBootCompt					: TEC_Net_IsBootCompt;
	ecNet_GetDevIdx						: TEC_Net_GetDevIdx;
	ecNet_GetLocNetIdx					: TEC_Net_GetLocNetIdx;
//	ecNet_GetVerInfo					: TEC_Net_GetVerInfo;
//	ecNet_SetFastFuncType				: TEC_Net_SetFastFuncType
//	ecNet_GetFastFuncType				: TEC_Net_GetFastFuncType
//	ecNet_SendRcvEcatCmd				: TEC_Net_SendRcvEcatCmd
	ecNet_ScanSlaves					: TEC_Net_ScanSlaves;
	ecNet_GetCfgSlaveCount				: TEC_Net_GetCfgSlaveCount;
	ecNet_SetCfgSlaveCount				: TEC_Net_SetCfgSlaveCount;
	ecNet_SetAlState					: TEC_Net_SetAlState;
//	ecNet_SetAlState_FF					: TEC_Net_SetAlState_FF
	ecNet_GetAlState					: TEC_Net_GetAlState;
//	ecNet_SlvComErrSum_GetEnable		: TEC_Net_SlvComErrSum_GetEnable
//	ecNet_SlvComErrSum_SetEnable		: TEC_Net_SlvComErrSum_SetEnable	
//	ecNet_SlvComErrSum_ClearAll			: TEC_Net_SlvComErrSum_ClearAll
//	ecNet_GetLastPDOIdx					: TEC_Net_GetLastPDOIdx
//	ecNet_IsPDOIdxCompt					: TEC_Net_IsPDOIdxCompt
//	ecNet_WaitPDOIdxCompt				: TEC_Net_WaitPDOIdxCompt
//	ecNet_WaitPDOIdxCompt_NB			: TEC_Net_WaitPDOIdxCompt_NB
//	ecNet_IsCmdIdxCompt					: TEC_Net_IsCmdIdxCompt
//	ecNet_WaitCmdIdxCompt				: TEC_Net_WaitCmdIdxCompt
//	ecNet_WaitCmdIdxCompt_NB			: TEC_Net_WaitCmdIdxCompt_NB
//	ecNet_GetCycleProcessTime			: TEC_Net_GetCycleProcessTime
//	ecNet_FWDnld_Process				: TEC_Net_FWDnld_Process
//	ecNet_FWDnld_Cancel					: TEC_Net_FWDnld_Cancel
//	ecNet_FWDnld_GetSts					: TEC_Net_FWDnld_GetSts
//	ecNet_FWDnld_GetSts					: TEC_Net_FWDnld_GetSts
//	ecNet_FWUpld_GetFileInfo			: TEC_Net_FWUpld_GetFileInfo
//	ecNet_FWUpld_Process				: TEC_ecNet_FWUpld_Process
//	ecNet_FWUpld_Cancel					: TEC_ecNet_FWUpld_Cancel
//	ecNet_FWUpld_GetSts					: TEC_ecNet_FWUpld_GetSts
//	ecNet_FWUpld_ResetSts				: TEC_ecNet_FWUpld_ResetSts
//	ecNet_InPDO_GetBufPtr				: TEC_ecNet_InPDO_GetBufPtr
//	ecNet_InPDO_GetData					: TEC_ecNet_InPDO_GetData
//	ecNet_InPDO_GetData_B				: TEC_ecNet_InPDO_GetData_B
//	ecNet_InPDO_GetData_W				: TEC_ecNet_InPDO_GetData_W
//	ecNet_InPDO_GetData_D				: TEC_ecNet_InPDO_GetData_D
//	ecNet_InPDO_GetSectPos				: TEC_ecNet_InPDO_GetSectPos	
//	ecNet_InQue_ClearChanList			: TEC_Net_InQue_ClearChanList
//	ecNet_InQue_AddChannel				: TEC_Net_InQue_AddChannel
//	ecNet_InQue_DelChannel				: TEC_Net_InQue_DelChannel	
//	ecNet_InQue_GetNumDataDescItems		: TEC_Net_InQue_GetNumDataDescItems	
//	ecNet_InQue_GetDataDesc				: TEC_Net_InQue_GetDataDesc	
//	ecNet_InQue_GetQueSizeInfo			: TEC_Net_InQue_GetQueSizeInfo
//	ecNet_InQue_SetStaTrgEnv			: TEC_Net_InQue_SetStaTrgEnv
//	ecNet_InQue_GetStaTrgEnv			: TEC_Net_InQue_GetStaTrgEnv
//	ecNet_InQue_SetStopTrgEnv			: TEC_Net_InQue_SetStopTrgEnv
//	ecNet_InQue_GetStopTrgEnv			: TEC_Net_InQue_GetStopTrgEnv
//	ecNet_InQue_StartChannel			: TEC_Net_InQue_StartChannel
//	ecNet_InQue_StopChannel				: TEC_Net_InQue_StopChannel
//	ecNet_InQue_GetQueuedCount			: TEC_Net_InQue_GetQueuedCount
//	ecNet_InQue_Deque					: TEC_Net_InQue_Deque
//	ecNet_InQue_PeekData				: TEC_Net_InQue_PeekData
//	ecNet_InQue_AddCommonTrg			: TEC_Net_InQue_AddCommonTrg
//	ecNet_InQue_DelCommonTrg			: TEC_Net_InQue_DelCommonTrg
//	ecNet_InQue_EnableCommonTrg			: TEC_Net_InQue_EnableCommonTrg
//	ecNet_InQue_SetCommonTrgState		: TEC_Net_InQue_SetCommonTrgState
//	ecNet_OutPDO_GetBufPtr				: TEC_Net_OutPDO_GetBufPtr
//	ecNet_OutPDO_SetData				: TEC_Net_OutPDO_SetData
//	ecNet_OutPDO_SetData_B				: TEC_Net_OutPDO_SetData_B
//	ecNet_OutPDO_SetData_W				: TEC_Net_OutPDO_SetData_W
//	ecNet_OutPDO_SetData_D				: TEC_Net_OutPDO_SetData_D
//	ecNet_OutPDO_GetSectPos				: TEC_Net_OutPDO_GetSectPos
//	ecCfg_Start							: TEC_Cfg_Start
//	ecCfg_End							: TEC_Cfg_End
//	ecCfg_SetNetConfig					: TEC_Cfg_SetNetConfig
//	ecCfg_GetNetConfig					: TEC_Cfg_GetNetConfig
//	ecCfg_SetOutPDOLogicSect			: TEC_Cfg_SetOutPDOLogicSect
//	ecCfg_GetOutPDOLogicSect			: TEC_Cfg_GetOutPDOLogicSect
//	ecCfg_SetInPDOLogicSect				: TEC_Cfg_SetInPDOLogicSect
//	ecCfg_GetInPDOLogicSect				: TEC_Cfg_GetInPDOLogicSect
//	ecCfg_SetSlaveConfig				: TEC_Cfg_SetSlaveConfig
//	ecCfg_GetSlaveConfig				: TEC_Cfg_GetSlaveConfig
//	ecCfg_SetChanMap					: TEC_Cfg_SetChanMap
//	ecCfg_GetChanMap					: TEC_Cfg_GetChanMap
//	ecCfgFile_Download					: TEC_CfgFile_Download
//	ecCfgFile_Verify					: TEC_CfgFile_Verify
//	ecXml_FindDeviceByProdInfo			: TEC_Xml_FindDeviceByProdInfo
//	ecXml_FindElem						: TEC_Xml_FindElem
//	ecXml_FindReadElemAttr				: TEC_Xml_FindReadElemAttr
//	ecXml_FindReadElemData				: TEC_Xml_FindReadElemData
//	ecXml_GetTagName					: TEC_Xml_GetTagName
//	ecXml_GetNumElem					: TEC_Xml_GetNumElem
//	ecXml_GetProdDesc					: TEC_Xml_GetProdDesc
//	ecXml_IntoElem						: TEC_Xml_IntoElem
//	ecXml_LoadByFileName				: TEC_Xml_LoadByFileName
//	ecXml_LoadByProdInfo				: TEC_Xml_LoadByProdInfo
//	ecXml_OutOfElem						: TEC_Xml_OutOfElem
//	ecXml_ReadElemAttr					: TEC_Xml_ReadElemAttr
//	ecXml_ReadElemData					: TEC_Xml_ReadElemData
//	ecXml_ResetPos						: TEC_Xml_ResetPos
//	ecXml_RestorePos					: TEC_Xml_RestorePos
//	ecXml_SavePos						: TEC_Xml_SavePos
//	ecXml_Str2Bool						: TEC_Xml_Str2Bool
//	ecXml_Str2HexDec					: TEC_Xml_Str2HexDec
//	ecXml_Unload						: TEC_Xml_Unload
//	ecSlv_GetProdInfo_A					: TEC_Slv_GetProdInfo_A
//	ecSlv_GetProdInfo					: TEC_Slv_GetProdInfo
//	ecSlv_GetTypeInfo					: TEC_Slv_GetTypeInfo
//	ecSlv_GetTypeInfo_A					: TEC_Slv_GetTypeInfo_A
	ecSlv_GetAlState_A					: TEC_Slv_GetAlState_A;
	ecSlv_GetAlState					  : TEC_Slv_GetAlState
//	ecSlv_ReadReg						: TEC_Slv_ReadReg
//	ecSlv_ReadReg_A						: TEC_Slv_ReadReg_A
//	ecSlv_WriteReg						: TEC_Slv_WriteReg
//	ecSlv_WriteReg_FF					: TEC_Slv_WriteReg_FF
//	ecSlv_WriteReg_A					: TEC_Slv_WriteReg_A
//	ecSlv_WriteReg_A_FF					: TEC_Slv_WriteReg_A_FF
//	ecSlv_ReadEEPR						: TEC_Slv_ReadEEPR
//	ecSlv_ReadEEPR_A					: TEC_Slv_ReadEEPR_A
//	ecSlv_WriteEEPR						: TEC_Slv_WriteEEPR
//	ecSlv_WriteEEPR_FF					: TEC_Slv_WriteEEPR_FF
//	ecSlv_WriteEEPR_A					: TEC_Slv_WriteEEPR_A
//	ecSlv_WriteEEPR_A_FF				: TEC_Slv_WriteEEPR_A_FF
//	ecSlv_RenewCrcOfEEPR_A				: TEC_Slv_RenewCrcOfEEPR_A
//	ecSlv_RenewCrcOfEEPR				: TEC_Slv_RenewCrcOfEEPR
//	ecSlv_ReadCoeSdo					: TEC_Slv_ReadCoeSdo
//	ecSlv_ReadCoeSdo_A					: TEC_Slv_ReadCoeSdo_A
//	ecSlv_WriteCoeSdo					: TEC_Slv_WriteCoeSdo
//	ecSlv_WriteCoeSdo_FF				: TEC_Slv_WriteCoeSdo_FF
//	ecSlv_WriteCoeSdo_A					: TEC_Slv_WriteCoeSdo_A
//	ecSlv_WriteCoeSdo_A_FF				: TEC_Slv_WriteCoeSdo_A_FF	
//	ecSlv_ReadReg134ID					: TEC_Slv_ReadReg134ID
//	ecSlv_ReadReg134ID_A				: TEC_Slv_ReadReg134ID_A	
//	ecSlv_SdoInfo_GetODList				: TEC_Slv_SdoInfo_GetODList
//	ecSlv_SdoInfo_GetODList_A			: TEC_Slv_SdoInfo_GetODList_A
//	ecSlv_SdoInfo_GetObjDesc			: TEC_Slv_SdoInfo_GetObjDesc
//	ecSlv_SdoInfo_GetObjDesc_A			: TEC_Slv_SdoInfo_GetObjDesc_A
//	ecSlv_SdoInfo_GetEntryDesc			: TEC_Slv_SdoInfo_GetEntryDesc
//	ecSlv_SdoInfo_GetEntryDesc_A 		: TEC_Slv_SdoInfo_GetEntryDesc_A
//	ecSlv_SdoInfo_ReleaseData 			: TEC_Slv_SdoInfo_ReleaseData
//	ecSlv_SlvIdx2PhysAddr				: TEC_Slv_SlvIdx2PhysAddr
//	ecSlv_PhysAddr2SlvIdx				: TEC_Slv_PhysAddr2SlvIdx
//	ecSlv_InPDO_GetBufPtr				: TEC_Slv_InPDO_GetBufPtr
//	ecSlv_InPDO_GetOffset				: TEC_Slv_InPDO_GetOffset
//	ecSlv_InPDO_GetBufLen				: TEC_Slv_InPDO_GetBufLen
//	ecSlv_OutPDO_GetBufPtr				: TEC_Slv_OutPDO_GetBufPtr
//	ecSlv_OutPDO_GetOffset				: TEC_Slv_OutPDO_GetOffset
//	ecSlv_OutPDO_GetBufLen				: TEC_Slv_OutPDO_GetBufLen
//	ecSlv_OutPDO_SetInitValMode			: TEC_Slv_OutPDO_SetInitValMode
//	ecSlv_OutPDO_GetInitValMode			: TEC_Slv_OutPDO_GetInitValMode
//	ecSlv_OutPDO_SetInitVal				: TEC_Slv_OutPDO_SetInitVal
//	ecSlv_OutPDO_GetInitVal				: TEC_Slv_OutPDO_GetInitVal
	ecSlv_GetComErrSum_A				: TEC_Slv_GetComErrSum_A;
//	ecSlv_GetComErrSum					: TEC_Slv_GetComErrSum
	ecSlv_ClearComErrSum_A				: TEC_Slv_ClearComErrSum_A;
//	ecSlv_ClearComErrSum				: TEC_Slv_ClearComErrSum
	ecdiGetSlaveIndex					: TEC_diGetSlaveIndex;
	ecdiGetSlaveID						: TEC_diGetSlaveID;
	ecdiGetNumChannels					: TEC_diGetNumChannels;
	ecdiGetOne							: TEC_diGetOne;
	ecdiGetMulti						: TEC_diGetMulti;
	ecdiGetLogicAddr					: TEC_diGetLogicAddr;
//	ecdiLtc_AddChannel					: TEC_diLtc_AddChannel
//	ecdiLtc_DelChannel					: TEC_diLtc_DelChannel
//	ecdiLtc_SetFilter					: TEC_diLtc_SetFilter
//	ecdiLtc_GetFilter					: TEC_diLtc_GetFilter
//	ecdiLtc_SetLogicInvert				: TEC_diLtc_SetLogicInvert
//	ecdiLtc_GetLogicInvert				: TEC_diLtc_GetLogicInvert
//	ecdiLtc_GetOnCount					: TEC_diLtc_GetOnCount
//	ecdiLtc_ResetOnCount				: TEC_diLtc_ResetOnCount
	ecdiGetOne_L						: TEC_diGetOne_L;
	ecdiGetMulti_L						: TEC_diGetMulti_L;
//	ecdiLtc_AddChannel_L				: TEC_diLtc_AddChannel_L
//	ecdiLtc_DelChannel_L				: TEC_diLtc_DelChannel_L
//	ecdiLtc_SetFilter_L					: TEC_diLtc_SetFilter_L
//	ecdiLtc_GetFilter_L					: TEC_diLtc_GetFilter_L
//	ecdiLtc_SetLogicInvert_L			: TEC_diLtc_SetLogicInvert_L
//	ecdiLtc_GetLogicInvert_L			: TEC_diLtc_GetLogicInvert_L
//	ecdiLtc_GetOnCount_L				: TEC_diLtc_GetOnCount_L
//	ecdiLtc_ResetOnCount_L				: TEC_diLtc_ResetOnCount_L
	ecdiLogBitAddr_FromGlobalChannel	: TEC_diLogBitAddr_FromGlobalChannel;
	ecdiLogBitAddr_FromLocalChannel		: TEC_diLogBitAddr_FromLocalChannel;
	ecdiLogBitAddr_FromOnboardChannel	: TEC_diLogBitAddr_FromOnboardChannel;
	ecdiLogBitAddr_ToGlobalChannel		: TEC_diLogBitAddr_ToGlobalChannel;
	ecdiLogBitAddr_ToLocalChannel		: TEC_diLogBitAddr_ToLocalChannel;
	ecdiLogBitAddr_ToOnboardChannel		: TEC_diLogBitAddr_ToOnboardChannel;
	ecdiLogBitAddr_GetChanType			: TEC_diLogBitAddr_GetChanType;
	ecdoGetSlaveIndex					: TEC_doGetSlaveIndex;
	ecdoGetSlaveID						: TEC_doGetSlaveID;
	ecdoGetNumChannels					: TEC_doGetNumChannels;
	ecdoPutOne							: TEC_doPutOne;
	ecdoPutMulti						: TEC_doPutMulti;
	ecdoGetOne							: TEC_doGetOne;
	ecdoGetMulti						: TEC_doGetMulti;
	ecdoPutOne_L						: TEC_doPutOne_L;
	ecdoPutMulti_L						: TEC_doPutMulti_L;
	ecdoGetOne_L						: TEC_doGetOne_L;
	ecdoGetMulti_L						: TEC_doGetMulti_L;
	ecdoLogBitAddr_FromGlobalChannel	: TEC_doLogBitAddr_FromGlobalChannel;
	ecdoLogBitAddr_FromLocalChannel		: TEC_doLogBitAddr_FromLocalChannel;
	ecdoLogBitAddr_FromOnboardChannel	: TEC_doLogBitAddr_FromOnboardChannel;
	ecdoLogBitAddr_ToGlobalChannel		: TEC_doLogBitAddr_ToGlobalChannel;
	ecdoLogBitAddr_ToLocalChannel		: TEC_doLogBitAddr_ToLocalChannel;
	ecdoLogBitAddr_ToOnboardChannel		: TEC_doLogBitAddr_ToOnboardChannel;
	ecdoLogBitAddr_GetChanType			: TEC_doLogBitAddr_GetChanType;
//	ecaiGetSlaveIndex					: TEC_aiGetSlaveIndex
//	ecaiGetSlaveID						: TEC_aiGetSlaveID
//	ecaiGetNumChannels					: TEC_aiGetNumChannels
//	ecaiGetChanVal_I					: TEC_aiGetChanVal_I
//	ecaiGetChanVal_F					: TEC_aiGetChanVal_F
//	ecaiGetChanVal_FS					: TEC_aiGetChanVal_FS
//	ecaoGetSlaveIndex					: TEC_aoGetSlaveIndex
//	ecaoGetSlaveID						: TEC_aoGetSlaveID
//	ecaoGetNumChannels					: TEC_aoGetNumChannels
//	ecaoSetChanVal_I					: TEC_aoSetChanVal_I
//	ecaoSetChanVal_F					: TEC_aoSetChanVal_F
//	ecaoSetChanVal_FS					: TEC_aoSetChanVal_FS
//	ecaoGetOutValue_I					: TEC_aoGetOutValue_I
//	ecaoGetOutValue_F					: TEC_aoGetOutValue_F
//	ecaoGetOutValue_FS					: TEC_aoGetOutValue_FS
	ecmGn_GetAxisList					: TEC_mGn_GetAxisList;
//	ecmGn_GetInPDOHeader				: TEC_mGn_GetInPDOHeader;
	ecmGn_AxisToSlaveIndex				: TEC_mGn_AxisToSlaveIndex;
//	ecmGn_AxisToSlaveID					: TEC_mGn_AxisToSlaveID;
//	ecmGn_SlaveIndexToAxis				: TEC_mGn_SlaveIndexToAxis;
//	ecmGn_SlaveIDToAxis					: TEC_mGn_SlaveIDToAxis;
//	ecmGn_InitFromFile					: TEC_mGn_InitFromFile;
//	ecmHEMG_SetInputEnv					: TEC_mHEMG_SetInputEnv
//	ecmHEMG_GetInputEnv					: TEC_mHEMG_GetInputEnv
//	ecmHEMG_SetInputEnv_Multi			: TEC_mHEMG_SetInputEnv_Multi
//	ecmHEMG_GetInputEnv_Multi			: TEC_mHEMG_GetInputEnv_Multi
//	ecmHEMG_GetNumInputs				: TEC_mHEMG_GetNumInputs
//	ecmHEMG_SetStopMode					: TEC_mHEMG_SetStopMode
//	ecmHEMG_GetStopMode					: TEC_mHEMG_GetStopMode
//	ecmHEMG_SetEnable					: TEC_mHEMG_SetEnable
//	ecmHEMG_GetEnable					: TEC_mHEMG_GetEnable
//	ecmHEMG_GetState					: TEC_mHEMG_GetState
//	ecmSEMG_SetStopMode					: TEC_mSEMG_SetStopMode
//	ecmSEMG_GetStopMode					: TEC_mSEMG_GetStopMode
//	ecmSEMG_SetState					: TEC_mSEMG_SetState
//	ecmSEMG_GetState					: TEC_mSEMG_GetState
//	ecmCollA_SetEnv						: TEC_mCollA_SetEnv
//	ecmCollA_GetEnv						: TEC_mCollA_GetEnv
//	ecmCollA_SetStopMode				: TEC_mCollA_SetStopMode
//	ecmCollA_GetStopMode				: TEC_mCollA_GetStopMode
//	ecmCollA_SetEnable					: TEC_mCollA_SetEnable
//	ecmCollA_GetEnable					: TEC_mCollA_GetEnable
	ecmSxCfg_SetUnitDist				: TEC_mSxCfg_SetUnitDist;
	ecmSxCfg_GetUnitDist				: TEC_mSxCfg_GetUnitDist;
//	ecmSxCfg_GetSoftLimit				: TEC_mSxCfg_GetSoftLimit;
//	ecmSxCfg_SetSoftLimit				: TEC_mSxCfg_SetSoftLimit;
	ecmSxCfg_SetOperMode				: TEC_mSxCfg_SetOperMode;
	ecmSxCfg_GetOperMode				: TEC_mSxCfg_GetOperMode;
	ecmSxCfg_SetUnitSpeed				: TEC_mSxCfg_SetUnitSpeed;
	ecmSxCfg_GetUnitSpeed				: TEC_mSxCfg_GetUnitSpeed;
	ecmSxCfg_SetMioProp					: TEC_mSxCfg_SetMioProp;
	ecmSxCfg_GetMioProp					: TEC_mSxCfg_GetMioProp;
	ecmSxCfg_SetMastInp					: TEC_mSxCfg_SetMastInp;
	ecmSxCfg_GetMastInp					: TEC_mSxCfg_GetMastInp;
	ecmSxCfg_SetMastInp_Cnt				: TEC_mSxCfg_SetMastInp_Cnt;
	ecmSxCfg_GetMastInp_Cnt				: TEC_mSxCfg_GetMastInp_Cnt;
	ecmSxCfg_SetSpeedPatt				: TEC_mSxCfg_SetSpeedPatt;
//	ecmSxCfg_SetSpeedPatt_FF			: TEC_mSxCfg_SetSpeedPatt_FF
	ecmSxCfg_GetSpeedPatt				: TEC_mSxCfg_GetSpeedPatt;
	ecmSxCfg_SetSpeedPatt_Time			: TEC_mSxCfg_SetSpeedPatt_Time;
//	ecmSxCfg_SetSpeedPatt_Time_FF		: TEC_xCfg_SetSpeedPatt_Time_FF
	ecmSxCfg_GetSpeedPatt_Time			: TEC_mSxCfg_GetSpeedPatt_Time;
	ecmSxCfg_SetSpeedRatio				: TEC_mSxCfg_SetSpeedRatio;
//	ecmSxCfg_SetSpeedRatio_FF			: TEC_xCfg_SetSpeedRatio_FF
//	ecmSxCfg_GetSpeedRatio				: TEC_mSxCfg_GetSpeedRatio;
//	ecmSxCfg_SetJerkRatio				: TEC_mSxCfg_SetJerkRatio;
//	ecmSxCfg_SetJerkRatio_FF			: TEC_xCfg_SetJerkRatio_FF
//	ecmSxCfg_GetJerkRatio				: TEC_xCfg_GetJerkRatio
//	ecmSxCfg_SetJerkMode				: TEC_xCfg_SetJerkMode
//	ecmSxCfg_GetJerkMode				: TEC_xCfg_GetJerkMode
//	ecmSxCfg_SetJerk					: TEC_xCfg_SetJerk
//	ecmSxCfg_GetJerk					: TEC_xCfg_GetJerk
//	ecmSxCfg_SetSecondaryAcc			: TEC_xCfg_SetSecondaryAcc
//	ecmSxCfg_GetSecondaryAcc			: TEC_xCfg_GetSecondaryAcc
//	ecmSxCfg_SetSecondaryDec			: TEC_xCfg_SetSecondaryDec
//	ecmSxCfg_GetSecondaryDec			: TEC_xCfg_GetSecondaryDec
//	ecmSxCfg_SetMinAccDecTime			: TEC_xCfg_SetMinAccDecTime
//	ecmSxCfg_GetMinAccDecTime			: TEC_xCfg_GetMinAccDecTime
//	ecmSxCfg_SetTouchProbeFunc			: TEC_xCfg_SetTouchProbeFunc
//	ecmSxCfg_GetTouchProbeFunc			: TEC_xCfg_GetTouchProbeFunc
//	ecmSxCfg_SetSyncOtherEnv			: TEC_xCfg_SetSyncOtherEnv
//	ecmSxCfg_GetSyncOtherEnv			: TEC_xCfg_GetSyncOtherEnv
//	ecmSxCfg_SetSyncOtherEnable			: TEC_xCfg_SetSyncOtherEnable
//	ecmSxCfg_GetSyncOtherEnable			: TEC_xCfg_GetSyncOtherEnable
	ecmSxCfg_PosCorr_SetTableSize		: TEC_mSxCfg_PosCorr_SetTableSize;
	ecmSxCfg_PosCorr_GetTableSize		: TEC_mSxCfg_PosCorr_GetTableSize;
	ecmSxCfg_PosCorr_SetTableData		: TEC_mSxCfg_PosCorr_SetTableData;
	ecmSxCfg_PosCorr_GetTableData		: TEC_mSxCfg_PosCorr_GetTableData;
	ecmSxCfg_PosCorr_SetTableFromFile	: TEC_mSxCfg_PosCorr_SetTableFromFile;
	ecmSxCfg_PosCorr_SetEnable			: TEC_mSxCfg_PosCorr_SetEnable;
	ecmSxCfg_PosCorr_GetEnable			: TEC_mSxCfg_PosCorr_GetEnable;
	ecmSxCfg_PosCorr_ClearTable			: TEC_mSxCfg_PosCorr_ClearTable;
//	ecmSxCfg_PosCorr2D_Reset			: TEC_xCfg_PosCorr2D_Reset
//	ecmSxCfg_PosCorr2D_SetTableHeader	: TEC_mSxCfg_PosCorr2D_SetTableHeader
//	ecmSxCfg_PosCorr2D_GetTableHeader	: TEC_mSxCfg_PosCorr2D_GetTableHeader
//	ecmSxCfg_PosCorr2D_SetTableData		: TEC_mSxCfg_PosCorr2D_SetTableData
//	ecmSxCfg_PosCorr2D_GetTableData		: TEC_mSxCfg_PosCorr2D_GetTableData
//	ecmSxCfg_PosCorr2D_SetTableFromFile	: TEC_mSxCfg_PosCorr2D_SetTableFromFile
//	ecmSxCfg_PosCorr2D_SetEnable		: TEC_mSxCfg_PosCorr2D_SetEnable
//	ecmSxCfg_PosCorr2D_GetEnable		: TEC_mSxCfg_PosCorr2D_GetEnable
//	ecmSxCfg_AutoTorq_SetValMode		: TEC_mSxCfg_AutoTorq_SetValMode
//	ecmSxCfg_AutoTorq_GetValMode		: TEC_mSxCfg_AutoTorq_GetValMode
//	ecmSxCfg_AutoTorq_SetMultiVal		: TEC_mSxCfg_AutoTorq_SetMultiVal
//	ecmSxCfg_AutoTorq_GetMultiVal		: TEC_mSxCfg_AutoTorq_GetMultiVal
//	ecmSxCfg_AutoTorq_SetValue			: TEC_mSxCfg_AutoTorq_SetValue
//	ecmSxCfg_AutoTorq_GetValue			: TEC_mSxCfg_AutoTorq_GetValue
//	ecmSxCfg_AutoTorq_SetLimit			: TEC_mSxCfg_AutoTorq_SetLimit
//	ecmSxCfg_AutoTorq_GetLimit			: TEC_mSxCfg_AutoTorq_GetLimit
//	ecmSxCfg_AutoTorq_SetEnable			: TEC_mSxCfg_AutoTorq_SetEnable
//	ecmSxCfg_AutoTorq_GetEnable			: TEC_mSxCfg_AutoTorq_GetEnable
	ecmSxCfg_Ring_GetEnable				: TEC_mSxCfg_Ring_GetEnable;
	ecmSxCfg_Ring_SetEnable				: TEC_mSxCfg_Ring_SetEnable;
	ecmSxCfg_Ring_GetPosRange			: TEC_mSxCfg_Ring_GetPosRange;
	ecmSxCfg_Ring_SetPosRange			: TEC_mSxCfg_Ring_SetPosRange;
	ecmSxCfg_Ring_GetDirMode			: TEC_mSxCfg_Ring_GetDirMode;
	ecmSxCfg_Ring_SetDirMode			: TEC_mSxCfg_Ring_SetDirMode;
//	ecmSxCfg_ExtStop_SetEnable			: TEC_mSxCfg_ExtStop_SetEnable
//	ecmSxCfg_ExtStop_GetEnable			: TEC_mSxCfg_ExtStop_GetEnable
//	ecmSxCfg_ExtStop_SetEnv				: TEC_mSxCfg_ExtStop_SetEnv
//	ecmSxCfg_ExtStop_SetEnv2			: TEC_mSxCfg_ExtStop_SetEnv2
//	ecmSxCfg_ExtStop_SetEnv3			: TEC_mSxCfg_ExtStop_SetEnv3
//	ecmSxCfg_ExtStop_GetEnv				: TEC_mSxCfg_ExtStop_GetEnv
//	ecmSxCfg_ExtStop_GetEnv2			: TEC_mSxCfg_ExtStop_GetEnv2
//	ecmSxCfg_ExtStop_GetEnv3			: TEC_mSxCfg_ExtStop_GetEnv3
//	ecmSxCfg_ExtStop_SetOfsDistMode		: TEC_mSxCfg_ExtStop_SetOfsDistMode
//	ecmSxCfg_ExtStop_GetOfsDistMode		: TEC_mSxCfg_ExtStop_GetOfsDistMode
	ecmSxCfg_SetMaxTorqOfCV				: TEC_mSxCfg_SetMaxTorqOfCV;
	ecmSxCfg_GetMaxTorqOfCV				: TEC_mSxCfg_GetMaxTorqOfCV;
	ecmSxCfg_SetMaxSpdOfCT				: TEC_mSxCfg_SetMaxSpdOfCT;
	ecmSxCfg_GetMaxSpdOfCT				: TEC_mSxCfg_GetMaxSpdOfCT;
	ecmSxCfg_SetMaxProfSpdOfCT			: TEC_mSxCfg_SetMaxProfSpdOfCT;
	ecmSxCfg_GetMaxProfSpdOfCT			: TEC_mSxCfg_GetMaxProfSpdOfCT;
	ecmSxCtl_SetSvon					: TEC_mSxCtl_SetSvon;
	ecmSxCtl_GetSvon					: TEC_mSxCtl_GetSvon;
//	ecmSxCtl_SetSvon_FF					: TEC_mSxCtl_SetSvon_FF
	ecmSxCtl_SetAlmRst					: TEC_mSxCtl_SetAlmRst;
//	ecmSxCtl_SetAlmRst_FF				: TEC_mSxCtl_SetAlmRst_FF
	ecmSxCtl_ResetAlm					: TEC_mSxCtl_ResetAlm;
//	ecmSxCtl_ResetAlm_FF				: TEC_mSxCtl_ResetAlm_FF
	ecmSxMot_SetTargTorq				: TEC_mSxMot_SetTargTorq;
	ecmSxMot_GetTargTorq				: TEC_mSxMot_GetTargTorq;
	ecmSxMot_SetTargVel					: TEC_mSxMot_SetTargVel;
	ecmSxMot_GetTargVel					: TEC_mSxMot_GetTargVel;
	ecmSxMot_VMoveStart					: TEC_mSxMot_VMoveStart;
//	ecmSxMot_VMoveStart_FF				: TEC_mSxMot_VMoveStart_FF
	ecmSxMot_MoveStart					: TEC_mSxMot_MoveStart;
//	ecmSxMot_MoveStart_FF				: TEC_mSxMot_MoveStart_FF
	ecmSxMot_Move						: TEC_mSxMot_Move;
//	ecmSxMot_Move_NB					: TEC_mSxMot_Move_NB
	ecmSxMot_MoveToStart				: TEC_mSxMot_MoveToStart;
//	ecmSxMot_MoveToStart_FF				: TEC_mSxMot_MoveToStart_FF
	ecmSxMot_MoveTo						: TEC_mSxMot_MoveTo;
//	ecmSxMot_MoveTo_NB					: TEC_mSxMot_MoveTo_NB
	ecmSxMot_OverrideSpeed				: TEC_mSxMot_OverrideSpeed;
	ecmSxMot_OverrideMove				: TEC_mSxMot_OverrideMove;
	ecmSxMot_OverrideMoveTo				: TEC_mSxMot_OverrideMoveTo;
	ecmSxMot_Stop						: TEC_mSxMot_Stop;
//	ecmSxMot_Stop_FF					: TEC_mSxMot_Stop_FF
	ecmMxMot_VMoveStart					: TEC_mMxMot_VMoveStart;
//	ecmMxMot_VMoveStart_FF				: TEC_mMxMot_VMoveStart_FF
	ecmMxMot_MoveStart					: TEC_mMxMot_MoveStart;
//	ecmMxMot_MoveStart_FF				: TEC_mMxMot_MoveStart_FF
	ecmMxMot_MoveToStart				: TEC_mMxMot_MoveToStart;
//	ecmMxMot_MoveToStart_FF				: TEC_mMxMot_MoveToStart_FF
	ecmMxMot_Stop						: TEC_mMxMot_Stop;
//	ecmMxMot_Stop_FF					: TEC_mMxMot_Stop_FF
	ecmMxSt_IsBusy						: TEC_mMxSt_IsBusy;
	ecmMxSt_WaitCompt					: TEC_mMxSt_WaitCompt;
//	ecmMxSt_WaitCompt_NB				: TEC_mMxSt_WaitCompt_NB
//  ecmSxSt_IsConnected					: TEC_mSxSt_IsConnected;
//	ecmSxSt_GetInPDOPtr					: TEC_mSxSt_GetInPDOPtr
	ecmSxSt_IsBusy						: TEC_mSxSt_IsBusy;
	ecmSxSt_WaitCompt					: TEC_mSxSt_WaitCompt;
//	ecmSxSt_WaitCompt_NB				: TEC_mSxSt_WaitCompt_NB
	ecmSxSt_SetCount					: TEC_mSxSt_SetCount;
	ecmSxSt_GetCount					: TEC_mSxSt_GetCount;
	ecmSxSt_SetPosition					: TEC_mSxSt_SetPosition;
	ecmSxSt_GetPosition					: TEC_mSxSt_GetPosition;
	ecmSxSt_GetCurSpeed					: TEC_mSxSt_GetCurSpeed;
	ecmSxSt_GetCurTorque				: TEC_mSxSt_GetCurTorque;
	ecmSxSt_GetMotState					: TEC_mSxSt_GetMotState;
	ecmSxSt_GetFlags					: TEC_mSxSt_GetFlags;
	ecmSxSt_GetDI						: TEC_mSxSt_GetDI;
//	ecmSxSt_GetTouchProbeSts			: TEC_mSxSt_GetTouchProbeSts
//	ecmSxSt_GetTouchProbePos			: TEC_mSxSt_GetTouchProbePos
//	ecmSxSt_GetOpModeDisp				: TEC_mSxSt_GetOpModeDisp
//	ecmSxSt_GetLmMapIdx					: TEC_mSxSt_GetLmMapIdx
//	ecmSxSt_GetPtmMapIdx				: TEC_mSxSt_GetPtmMapIdx
//	ecmSxCmpOne_SetHandler				: TEC_mSxCmpOne_SetHandler
//	ecmSxCmpOne_SetEnable				: TEC_mSxCmpOne_SetEnable
//	ecmSxCmpOne_GetEnable				: TEC_mSxCmpOne_GetEnable
//	ecmSxCmpOne_SetEnv					: TEC_mSxCmpOne_SetEnv
//	ecmSxCmpOne_GetEnv					: TEC_mSxCmpOne_GetEnv
//	ecmSxCmpOne_GetOutSts				: TEC_mSxCmpOne_GetOutSts
//	ecmSxCmpOne_ResetOutSts				: TEC_mSxCmpOne_ResetOutSts
//	ecmSxCmpCont_SetEnable				: TEC_mSxCmpCont_SetEnable
//	ecmSxCmpCont_GetEnable				: TEC_mSxCmpCont_GetEnable
//	ecmSxCmpCont_SetTableSize			: TEC_mSxCmpCont_SetTableSize
//	ecmSxCmpCont_GetTableSize			: TEC_mSxCmpCont_GetTableSize
//	ecmSxCmpCont_SetTableData			: TEC_mSxCmpCont_SetTableData
//	ecmSxCmpCont_GetTableData			: TEC_mSxCmpCont_GetTableData
//	ecmSxCmpCont_GetActTblIdx			: TEC_mSxCmpCont_GetActTblIdx
//	ecmSxCmpCont_SetActTblIdx			: TEC_mSxCmpCont_SetActTblIdx
//	ecmSxCmpCont_GetOutSts				: TEC_mSxCmpCont_GetOutSts
//	ecmSxCmpCont_ResetOutSts			: TEC_mSxCmpCont_ResetOutSts
//	ecmSxSD_SetInputEnv					: TEC_mSxSD_SetInputEnv
//	ecmSxSD_GetInputEnv					: TEC_mSxSD_GetInputEnv
//	ecmSxSD_SetSpeed					: TEC_mSxSD_SetSpeed
//	ecmSxSD_GetSpeed					: TEC_mSxSD_GetSpeed
//	ecmSxSD_SetOffset					: TEC_mSxSD_SetOffset
//	ecmSxSD_GetOffset					: TEC_mSxSD_GetOffset
//	ecmSxSD_SetLatchMode				: TEC_mSxSD_SetLatchMode
//	ecmSxSD_GetLatchMode				: TEC_mSxSD_GetLatchMode
//	ecmSxSD_SetEnable					: TEC_mSxSD_SetEnable
//	ecmSxSD_GetEnable					: TEC_mSxSD_GetEnable
//	ecmSxSD_RestoreSpeed				: TEC_mSxSD_RestoreSpeed
//	ecmSxSD_GetInputStatus				: TEC_mSxSD_GetInputStatus
//	ecmSxSD_GetActStatus				: TEC_mSxSD_GetActStatus
//	ecmSxMulTorq1_Start					: TEC_mSxMulTorq1_Start
//	ecmSxMulTorq1_Stop					: TEC_mSxMulTorq1_Stop
//	ecmIxCfg_MapAxes					: TEC_mIxCfg_MapAxes
//	ecmIxCfg_MapAxes_FF					: TEC_mIxCfg_MapAxes_FF
//	ecmIxCfg_UnmapAxes					: TEC_mIxCfg_UnmapAxes
//	ecmIxCfg_UnmapAxes_FF				: TEC_mIxCfg_UnmapAxes_FF
//	ecmIxCfg_SetSpeedPatt				: TEC_mIxCfg_SetSpeedPatt
//	ecmIxCfg_SetSpeedPatt_FF			: TEC_mIxCfg_SetSpeedPatt_FF
//	ecmIxCfg_GetSpeedPatt				: TEC_mIxCfg_GetSpeedPatt
//	ecmIxCfg_SetSpeedPatt_MR			: TEC_mIxCfg_SetSpeedPatt_MR
//	ecmIxCfg_SetSpeedPatt_MR_FF			: TEC_mIxCfg_SetSpeedPatt_MR_FF
//	ecmIxCfg_GetSpeedPatt_MR			: TEC_mIxCfg_GetSpeedPatt_MR
//	ecmIxCfg_SetMastWeight				: TEC_mIxCfg_SetMastWeight
//	ecmIxCfg_GetMastWeight				: TEC_mIxCfg_GetMastWeight
//	ecmIxCfg_SetJerkRatio				: TEC_mIxCfg_SetJerkRatio
//	ecmIxCfg_SetJerkRatio_FF 			: TEC_mIxCfg_SetJerkRatio_FF
//	ecmIxCfg_GetJerkRatio				: TEC_mIxCfg_GetJerkRatio
//	ecmIxCfg_Spline_ClearPool			: TEC_mIxCfg_Spline_ClearPool
//	ecmIxCfg_Spline_AddNewObj			: TEC_mIxCfg_Spline_AddNewObj
//	ecmIxCfg_Spline_SetRefPoint			: TEC_mIxCfg_Spline_SetRefPoint
//	ecmIxCfg_Spline_BuildObj			: TEC_mIxCfg_Spline_BuildObj
//	ecmIxCfg_Spline_SetTrgOutEnv		: TEC_mIxCfg_Spline_SetTrgOutEnv
//	ecmIxCfg_Spline_GetTrgOutEnv		: TEC_mIxCfg_Spline_GetTrgOutEnv
//	ecmIxCfg_Spline_GetTrgOutPos		: TEC_mIxCfg_Spline_GetTrgOutPos
//	ecmIxCfg_Spline_SetJsType			: TEC_mIxCfg_Spline_SetJsType
//	ecmIxCfg_Spline_GetJsType			: TEC_mIxCfg_Spline_GetJsType
//	ecmIxCfg_Spline_SetJsProp_F			: TEC_mIxCfg_Spline_SetJsProp_F
//	ecmIxCfg_Spline_GetJsProp_F			: TEC_mIxCfg_Spline_GetJsProp_F
//	ecmIxCfg_Spline_SetJerkThresh		: TEC_mIxCfg_Spline_SetJerkThresh
//	ecmIxCfg_Spline_GetJerkThresh		: TEC_mIxCfg_Spline_GetJerkThresh
//	ecmIxCfg_MPRLin2X_ClearPool			: TEC_mIxCfg_MPRLin2X_ClearPool
//	ecmIxCfg_MPRLin2X_AddNewObj			: TEC_mIxCfg_MPRLin2X_AddNewObj
//	ecmIxCfg_MPRLin2X_SetRefPoint		: TEC_mIxCfg_MPRLin2X_SetRefPoint
//	ecmIxCfg_MPRLin2X_BuildObj			: TEC_mIxCfg_MPRLin2X_BuildObj
//	ecmIxMot_LineStart					: TEC_mIxMot_LineStart
//	ecmIxMot_LineStart_FF				: TEC_mIxMot_LineStart_FF
//	ecmIxMot_Line						: TEC_mIxMot_Line
//	ecmIxMot_Line_NB					: TEC_mIxMot_Line_NB
//	ecmIxMot_LineToStart				: TEC_mIxMot_LineToStart
//	ecmIxMot_LineToStart_FF				: TEC_mIxMot_LineToStart_FF
//	ecmIxMot_LineTo						: TEC_mIxMot_LineTo
//	ecmIxMot_LineTo_NB					: TEC_mIxMot_LineTo_NB
//	ecmIxMot_ArcAng_R_Start				: TEC_mIxMot_ArcAng_R_Start
//	ecmIxMot_ArcAng_R_Start_FF 			: TEC_mIxMot_ArcAng_R_Start_FF
//	ecmIxMot_ArcAng_R					: TEC_mIxMot_ArcAng_R
//	ecmIxMot_ArcAng_R_NB				: TEC_mIxMot_ArcAng_R_NB
//	ecmIxMot_ArcAng_A_Start				: TEC_mIxMot_ArcAng_A_Start
//	ecmIxMot_ArcAng_A_Start_FF			: TEC_mIxMot_ArcAng_A_Start_FF
//	ecmIxMot_ArcAng_A					: TEC_mIxMot_ArcAng_A
//	ecmIxMot_ArcAng_A_NB				: TEC_mIxMot_ArcAng_A_NB
//	ecmIxMot_ArcPos_R_Start				: TEC_mIxMot_ArcPos_R_Start
//	ecmIxMot_ArcPos_R_Start_FF			: TEC_mIxMot_ArcPos_R_Start_FF
//	ecmIxMot_ArcPos_R					: TEC_ecmIxMot_ArcPos_R
//	ecmIxMot_ArcPos_R_NB				: TEC_ecmIxMot_ArcPos_R_NB
//	ecmIxMot_ArcPos_A_Start				: TEC_mIxMot_ArcPos_A_Start
//	ecmIxMot_ArcPos_A_Start_FF			: TEC_mIxMot_ArcPos_A_Start_FF
//	ecmIxMot_ArcPos_A					: TEC_mIxMot_ArcPos_A
//	ecmIxMot_ArcPos_A_NB				: TEC_mIxMot_ArcPos_A_NB
//	ecmIxMot_Arc3P_R_Start				: TEC_mIxMot_Arc3P_R_Start
//	ecmIxMot_Arc3P_R_Start_FF			: TEC_mIxMot_Arc3P_R_Start_FF
//	ecmIxMot_Arc3P_R					: TEC_mIxMot_Arc3P_R
//	ecmIxMot_Arc3P_R_NB					: TEC_mIxMot_Arc3P_R_NB
//	ecmIxMot_Arc3P_A_Start				: TEC_mIxMot_Arc3P_A_Start
//	ecmIxMot_Arc3P_A_FF					: TEC_mIxMot_Arc3P_A_FF
//	ecmIxMot_Arc3P_A					: TEC_mIxMot_Arc3P_A
//	ecmIxMot_Arc3P_A_NB					: TEC_mIxMot_Arc3P_A_NB
//	ecmIxMot_Spline_Start				: TEC_mIxMot_Spline_Start
//	ecmIxMot_MPRLin2X_Start				: TEC_mIxMot_MPRLin2X_Start
//	ecmIxMot_MoveVia2X_Start			: TEC_mIxMot_MoveVia2X_Start
//	ecmIxMot_MoveVia2X_OverrideTP		: TEC_mIxMot_MoveVia2X_OverrideTP
//	ecmIxMot_Stop						: TEC_mIxMot_Stop
//	ecmIxMot_Stop_FF					: TEC_mIxMot_Stop_FF	
//	ecmIxSt_IsBusy						: TEC_mIxSt_IsBusy
//	ecmIxSt_WaitCompt					: TEC_mIxSt_WaitCompt
//	ecmIxSt_WaitCompt_NB				: TEC_mIxSt_WaitCompt_NB
	ecmHomeCfg_SetOption				: TEC_mHomeCfg_SetOption;
	ecmHomeCfg_GetOption				: TEC_mHomeCfg_GetOption;
	ecmHomeCfg_SetMode					: TEC_mHomeCfg_SetMode;
	ecmHomeCfg_GetMode					: TEC_mHomeCfg_GetMode;
	ecmHomeCfg_SetOffset				: TEC_mHomeCfg_SetOffset;
	ecmHomeCfg_GetOffset				: TEC_mHomeCfg_GetOffset;
	ecmHomeCfg_SetSpeedPatt				: TEC_mHomeCfg_SetSpeedPatt;
	ecmHomeCfg_GetSpeedPatt				: TEC_mHomeCfg_GetSpeedPatt;
	ecmHomeMot_MoveStart				: TEC_mHomeMot_MoveStart;
//	ecmHomeMot_MoveStart_FF				: TEC_mHomeMot_MoveStart_FF;
	ecmHomeMot_Move						: TEC_mHomeMot_Move;
	ecmHomeSt_IsBusy					: TEC_mHomeSt_IsBusy;
	ecmHomeSt_WaitCompt					: TEC_mHomeSt_WaitCompt;
	ecmHomeSt_GetFlags					: TEC_mHomeSt_GetFlags;
	ecmMsCfg_SetSlvEnv					: TEC_mMsCfg_SetSlvEnv;
	ecmMsCfg_GetSlvEnv					: TEC_mMsCfg_GetSlvEnv;
	ecmMsCtl_StartSlv					: TEC_mMsCtl_StartSlv;
	ecmMsCtl_StopSlv					: TEC_mMsCtl_StopSlv;
	ecmMsCtl_SynchSlv					: TEC_mMsCtl_SynchSlv;
	ecmMsSt_IsSlvStarted				: TEC_mMsSt_IsSlvStarted;
//	ecmLmResetAll						: TEC_mLmResetAll
//	ecmLmCtl_Begin						: TEC_mLmCtl_Begin
//	ecmLmCtl_End						: TEC_mLmCtl_End
//	ecmLmCtl_Run						: TEC_mLmCtl_Run
//	ecmLmCtl_Stop						: TEC_mLmCtl_Stop
//	ecmLmCtl_ClearQue					: TEC_mLmCtl_ClearQue
//	ecmLmCfg_SetQueFullMode				: TEC_mLmCfg_SetQueFullMode
//	ecmLmCfg_GetQueFullMode				: TEC_mLmCfg_GetQueFullMode
//	ecmLmCfg_SetQueDepth				: TEC_mLmCfg_SetQueDepth
//	ecmLmCfg_GetQueDepth				: TEC_mLmCfg_GetQueDepth
//	ecmLmCfg_SetStepId					: TEC_mLmCfg_SetStepId
//	ecmLmCfg_GetStepId					: TEC_mLmCfg_GetStepId
//	ecmLmCfg_SetStepParam				: TEC_mLmCfg_SetStepParam
//	ecmLmCfg_GetStepParam				: TEC_mLmCfg_GetStepParam
//	ecmLmSt_GetRunSts					: TEC_mLmSt_GetRunSts
//	ecmLmSt_GetRemStepCount				: TEC_mLmSt_GetRemStepCount
//	ecmLmSt_GetRunStepInfo				: TEC_mLmSt_GetRunStepInfo
//	ecmLmSt_GetRunStepParam				: TEC_mLmSt_GetRunStepParam
//	ecmLmCmd_Delay						: TEC_mLmCmd_Delay
//	ecmPtmResetAll						: TEC_mPtmResetAll
//	ecmPtmCtl_Begin						: TEC_mPtmCtl_Begin
//	ecmPtmCtl_End						: TEC_mPtmCtl_End
//	ecmPtmCtl_SetHold					: TEC_mPtmCtl_SetHold
//	ecmPtmCmd_AddItem_PT				: TEC_mPtmCmd_AddItem_PT
//	ecmPtmSt_GetRunSts					: TEC_mPtmSt_GetRunSts
//	ecmPtmSt_GetRunStepInfo				: TEC_mPtmSt_GetRunStepInfo
//	ecmMPMon_AddAxis					: TEC_mMPMon_AddAxis
//	ecmMPMon_DelAxis					: TEC_mMPMon_DelAxis
//	ecmMPMon_SetAxisEnable				: TEC_mMPMon_SetAxisEnable
//	ecmMPMon_GetAxisStatus				: TEC_mMPMon_GetAxisStatus
//	ecmMPMon_ResetAxisData				: TEC_mMPMon_ResetAxisData
//	ecmMPMon_ResetSectData				: TEC_mMPMon_ResetSectData
//	ecmMPMon_SetTorqThreshVal			: TEC_mMPMon_SetTorqThreshVal
//	ecmMPMon_GetTorqThreshVal			: TEC_mMPMon_GetTorqThreshVal
//	ecmMPMon_SetDevThreshVal			: TEC_mMPMon_SetDevThreshVal
//	ecmMPMon_GetDevThreshVal			: TEC_mMPMon_GetDevThreshVal
//	ecmMPMon_ReadAxisData				: TEC_mMPMon_ReadAxisData
//	ecmMPMon_WriteAxisData				: TEC_mMPMon_WriteAxisData
//	ecUtl_ShowError_A					: TEC_Utl_ShowError_A
//	ecUtl_ShowError_W					: TEC_Utl_ShowError_W
//	ecUtl_ShowMessage_A					: TEC_Utl_ShowMessage_A
//	ecUtl_ShowMessage_W					: TEC_Utl_ShowMessage_W
//	ecUtl_GetCntDiff_UI32				: TEC_Utl_GetCntDiff_UI32
//	ecUtl_GetCntDiff_UI16				: TEC_Utl_GetCntDiff_UI16
//	ecUtl_IsTimeOut						: TEC_Utl_IsTimeOut
//	ecNet_SetEnableSTM					: TEC_Net_SetEnableSTM
	ecSlv_SetAlState_A					: TEC_Slv_SetAlState_A;

	FDLLInstance : THandle;

procedure LoadDll;
Procedure UnloadDll;
function cmlGnABSUpdate(BoardId : LongInt) : LongInt;
function cmlGnLoadDevice(NumDevices : PLongInt; BoardIDList : PLongInt; NumServos : PLongInt) : LongInt;
function cmlGnResetDevice(BoardId : LongInt; ResetMask : LongInt) : LongInt;
function cmlGnResetComm(BoardId : LongInt) : LongInt;
function cmlGnSetABSMode(BoardId : LongInt; Axis : LongInt; EncoderMode : LongInt) : LongInt;
function cmlGnSetAlarmRes(BoardId : LongInt; Axis : LongInt) : LongInt;
function cmlCfgSetUnitDist(BoardId : LongInt; Axis : LongInt; UnitDist : Double) : LongInt;
function cmlCfgSetUnitSpeed(BoardId : LongInt; Axis : LongInt; UnitSpeed : Double) : LongInt;
function cmlCfgSetRotateAxis(BoardId : LongInt; Axis : LongInt; Enable : LongInt) : LongInt;
function cmlCfgGetRotateAxisInfo(BoardId : LongInt; Axis : LongInt; Enable : PLongInt; PPR : PLongInt) : LongInt;
function cmlStSxReadMotionState(BoardId : LongInt; Channel : LongInt; MotStates : PLongInt) : LongInt;
function cmlHomeIsBusy(BoardId : LongInt; Channel : LongInt; IsBusy : PLongInt) : LongInt;
function cmlStGetPosition(BoardId : LongInt; Channel : LongInt; Source : LongInt; Count : PDouble) : LongInt;
function cmlStGetSpeed(BoardId : LongInt; Channel : LongInt; Source : LongInt; Speed : PDouble) : LongInt;
function cmlCfgSetSpeedPattern(BoardId : LongInt; Axis : LongInt; SpeedMode : LongInt; Work : Double; Acc : Double; Dec : Double; IniSpeed : Double; EndSpeed : Double) : LongInt;
function cmlOverrideSpeedSet(BoardId : LongInt; Channel : LongInt) : LongInt;
function cmlSxStopEmg(BoardId : LongInt; Axis : LongInt) : LongInt;
function cmlSxStop(BoardId : LongInt; Axis : LongInt) : LongInt;
function cmlGnSetServoOn(BoardId : LongInt; Axis : LongInt; dwlsOn : LongInt) : LongInt;
function cmlGnGetServoOn(BoardId : LongInt; Axis : LongInt; dwlsOn : PLongInt) : LongInt;
function cmlSxMoveToStart(BoardId : LongInt; Axis : LongInt; Position : Double) : LongInt;
function cmlSxRSearchStart(BoardId : LongInt; Axis : LongInt; Angle : Double) : LongInt;
function cmlSxVMoveStart(BoardId : LongInt; Axis : LongInt; Dir : LongInt) : LongInt;
function cmlStReadMioStatuses(BoardId : LongInt; Channel : LongInt; MioStates : PLongInt) : LongInt;
function cmlStGetTorque(BoardId : LongInt; Channel : LongInt; Torque : PLongInt) : LongInt;
function cmlMxMoveToStart(BoardId : LongInt; NumAxes : LongInt; AxisList : PLongInt; PosList : PDouble) : LongInt;

implementation

Const
LIBRARY_FILENAME : UnicodeString = 'ComiEcatSdk.dll';//AnsiString = 'ComiEcatSdk.dll';
                        //array[0..1] of Double;
var
ABS_OFFSET : array[0..15] of Double;
ISROTATEAXIS : array[0..15] of Boolean;
ISABSMODE : array[0..15] of Boolean;

procedure LoadDll;
var
  LibraryFilename : UnicodeString;//AnsiString;
begin
	LibraryFileName := LIBRARY_FILENAME;
	FDLLInstance := LoadLibrary(PChar(LibraryFileName));
		
	if( FDLLInstance <> 0 ) then
	begin
		
	
		  @ecGn_LoadDevice						 := GetProcAddress(FDLLInstance, 'ecGn_LoadDevice');
	    @ecGn_UnloadDevices					     := GetProcAddress(FDLLInstance, 'ecGn_UnloadDevices');					     
	    //@ecGn_SetBootWaitMode				     := GetProcAddress(FDLLInstance, 'ecGn_SetBootWaitMode');				     
	    //@ecGn_GetBootWaitMode				     := GetProcAddress(FDLLInstance, 'ecGn_GetBootWaitMode');				     
	    //@ecGn_SetEnableTimerResolSet			 := GetProcAddress(FDLLInstance, 'ecGn_SetEnableTimerResolSet');			 
	    //@ecGn_GetEnableTimerResolSet			 := GetProcAddress(FDLLInstance, 'ecGn_GetEnableTimerResolSet');			 
	    @ecGn_IsDevLoaded					     := GetProcAddress(FDLLInstance, 'ecGn_IsDevLoaded');					     
	    @ecGn_GetNumDevices					     := GetProcAddress(FDLLInstance, 'ecGn_GetNumDevices');					     
	    @ecGn_GetNumNetworks					 := GetProcAddress(FDLLInstance, 'ecGn_GetNumNetworks');					 
	    //@ecGn_GetDevInfo						 := GetProcAddress(FDLLInstance, 'ecGn_GetDevInfo');
	    //@ecGn_GetDebugData					     := GetProcAddress(FDLLInstance, 'ecGn_GetDebugData');					     
	    //@ecGn_OutpB							     := GetProcAddress(FDLLInstance, 'ecGn_OutpB');							     
	    //@ecGn_OutpsB							 := GetProcAddress(FDLLInstance, 'ecGn_OutpsB');							 
	    //@ecGn_OutpW							     := GetProcAddress(FDLLInstance, 'ecGn_OutpW');							     
	    //@ecGn_OutpsW							 := GetProcAddress(FDLLInstance, 'ecGn_OutpsW');							 
	    //@ecGn_OutpD							     := GetProcAddress(FDLLInstance, 'ecGn_OutpD');							     
	    //@ecGn_OutpsD							 := GetProcAddress(FDLLInstance, 'ecGn_OutpsD');							 
	    //@ecGn_InpB							     := GetProcAddress(FDLLInstance, 'ecGn_InpB');							     
	    //@ecGn_InpsB							     := GetProcAddress(FDLLInstance, 'ecGn_InpsB');							     
	    //@ecGn_InpW							     := GetProcAddress(FDLLInstance, 'ecGn_InpW');							     
        //@ecGn_InpsW							     := GetProcAddress(FDLLInstance, 'ecGn_InpsW');							     
        //@ecGn_InpD							     := GetProcAddress(FDLLInstance, 'ecGn_InpD');							     
        //@ecGn_InpsD							     := GetProcAddress(FDLLInstance, 'ecGn_InpsD');							     
        //@ecGn_DbgTempCmd						 := GetProcAddress(FDLLInstance, 'ecGn_DbgTempCmd');						 
        //@ecGn_ReadInPDO						     := GetProcAddress(FDLLInstance, 'ecGn_ReadInPDO');						     
        //@ecGn_ReadDspDbgData_I				     := GetProcAddress(FDLLInstance, 'ecGn_ReadDspDbgData_I');				     
        //@ecGn_WriteDspDbgData_I				     := GetProcAddress(FDLLInstance, 'ecGn_WriteDspDbgData_I');				     
        //@ecGn_ReadDspDbgData_F				     := GetProcAddress(FDLLInstance, 'ecGn_ReadDspDbgData_F');				     
        //@ecGn_WriteDspDbgData_F				     := GetProcAddress(FDLLInstance, 'ecGn_WriteDspDbgData_F');				     
        //@ecDlog_SetFilePath					     := GetProcAddress(FDLLInstance, 'ecDlog_SetFilePath');					     
        //@ecDlog_GetFilePath					     := GetProcAddress(FDLLInstance, 'ecDlog_GetFilePath');					     
        //@ecDlog_SetLogType					     := GetProcAddress(FDLLInstance, 'ecDlog_SetLogType');					     
        //@ecDlog_GetLogType					     := GetProcAddress(FDLLInstance, 'ecDlog_GetLogType');					     
        //@ecDlog_SetLogLevel					     := GetProcAddress(FDLLInstance, 'ecDlog_SetLogLevel');					     
        //@ecDlog_GetLogLevel					     := GetProcAddress(FDLLInstance, 'ecDlog_GetLogLevel');					     
        //@ecDlog_SetLogMemSize				     := GetProcAddress(FDLLInstance, 'ecDlog_SetLogMemSize');				     
        //@ecDlog_GetLogMemSize				     := GetProcAddress(FDLLInstance, 'ecDlog_GetLogMemSize');				     
        //@ecDlog_GetMemoryLogSts				     := GetProcAddress(FDLLInstance, 'ecDlog_GetMemoryLogSts');				     
        //@ecDlog_DumpMemoryLog				     := GetProcAddress(FDLLInstance, 'ecDlog_DumpMemoryLog');				     
        //@ecDlog_DumpMemoryLog2				     := GetProcAddress(FDLLInstance, 'ecDlog_DumpMemoryLog2');				     
        //@ecDlog_GetLastDumpFilePath			     := GetProcAddress(FDLLInstance, 'ecDlog_GetLastDumpFilePath');			     
        @ecNet_IsBootCompt					     := GetProcAddress(FDLLInstance, 'ecNet_IsBootCompt');
        @ecNet_GetDevIdx						 := GetProcAddress(FDLLInstance, 'ecNet_GetDevIdx');						 
        @ecNet_GetLocNetIdx					     := GetProcAddress(FDLLInstance, 'ecNet_GetLocNetIdx');
        //@ecNet_GetVerInfo					     := GetProcAddress(FDLLInstance, 'ecNet_GetVerInfo');
        //@ecNet_SetFastFuncType				     := GetProcAddress(FDLLInstance, 'ecNet_SetFastFuncType');				     
        //@ecNet_GetFastFuncType				     := GetProcAddress(FDLLInstance, 'ecNet_GetFastFuncType');
        //@ecNet_SendRcvEcatCmd				     := GetProcAddress(FDLLInstance, 'ecNet_SendRcvEcatCmd');				     
        @ecNet_ScanSlaves					     := GetProcAddress(FDLLInstance, 'ecNet_ScanSlaves');					     
        @ecNet_GetCfgSlaveCount				     := GetProcAddress(FDLLInstance, 'ecNet_GetCfgSlaveCount');				     
        @ecNet_SetCfgSlaveCount				     := GetProcAddress(FDLLInstance, 'ecNet_SetCfgSlaveCount');				     
        @ecNet_SetAlState					     := GetProcAddress(FDLLInstance, 'ecNet_SetAlState');					     
        //@ecNet_SetAlState_FF					 := GetProcAddress(FDLLInstance, 'ecNet_SetAlState_FF');					 
        @ecNet_GetAlState					     := GetProcAddress(FDLLInstance, 'ecNet_GetAlState');					     
        //@ecNet_SlvComErrSum_GetEnable		     := GetProcAddress(FDLLInstance, 'ecNet_SlvComErrSum_GetEnable');		     
        //@ecNet_SlvComErrSum_SetEnable		     := GetProcAddress(FDLLInstance, 'ecNet_SlvComErrSum_SetEnable');		     
        //@ecNet_SlvComErrSum_ClearAll			 := GetProcAddress(FDLLInstance, 'ecNet_SlvComErrSum_ClearAll');			 
        //@ecNet_GetLastPDOIdx					 := GetProcAddress(FDLLInstance, 'ecNet_GetLastPDOIdx');					 
        //@ecNet_IsPDOIdxCompt					 := GetProcAddress(FDLLInstance, 'ecNet_IsPDOIdxCompt');					 
        //@ecNet_WaitPDOIdxCompt				     := GetProcAddress(FDLLInstance, 'ecNet_WaitPDOIdxCompt');				     
        //@ecNet_WaitPDOIdxCompt_NB			     := GetProcAddress(FDLLInstance, 'ecNet_WaitPDOIdxCompt_NB');			     
        //@ecNet_IsCmdIdxCompt					 := GetProcAddress(FDLLInstance, 'ecNet_IsCmdIdxCompt');					 
        //@ecNet_WaitCmdIdxCompt				     := GetProcAddress(FDLLInstance, 'ecNet_WaitCmdIdxCompt');				     
        //@ecNet_WaitCmdIdxCompt_NB			     := GetProcAddress(FDLLInstance, 'ecNet_WaitCmdIdxCompt_NB');			     
        //@ecNet_GetCycleProcessTime			     := GetProcAddress(FDLLInstance, 'ecNet_GetCycleProcessTime');			     
        //@ecNet_FWDnld_Process				     := GetProcAddress(FDLLInstance, 'ecNet_FWDnld_Process');				     
        //@ecNet_FWDnld_Cancel					 := GetProcAddress(FDLLInstance, 'ecNet_FWDnld_Cancel');					 
        //@ecNet_FWDnld_GetSts					 := GetProcAddress(FDLLInstance, 'ecNet_FWDnld_GetSts');					 
        //@ecNet_FWDnld_GetSts					 := GetProcAddress(FDLLInstance, 'ecNet_FWDnld_GetSts');					 
        //@ecNet_FWUpld_GetFileInfo			     := GetProcAddress(FDLLInstance, 'ecNet_FWUpld_GetFileInfo');			     
        //@ecNet_FWUpld_Process				     := GetProcAddress(FDLLInstance, 'ecNet_FWUpld_Process');				     
        //@ecNet_FWUpld_Cancel					 := GetProcAddress(FDLLInstance, 'ecNet_FWUpld_Cancel');					 
        //@ecNet_FWUpld_GetSts					 := GetProcAddress(FDLLInstance, 'ecNet_FWUpld_GetSts');					 
        //@ecNet_FWUpld_ResetSts				     := GetProcAddress(FDLLInstance, 'ecNet_FWUpld_ResetSts');			     
        //@ecNet_InPDO_GetBufPtr				     := GetProcAddress(FDLLInstance, 'ecNet_InPDO_GetBufPtr');				     
        //@ecNet_InPDO_GetData					 := GetProcAddress(FDLLInstance, 'ecNet_InPDO_GetData');					 
        //@ecNet_InPDO_GetData_B				     := GetProcAddress(FDLLInstance, 'ecNet_InPDO_GetData_B');				     
        //@ecNet_InPDO_GetData_W				     := GetProcAddress(FDLLInstance, 'ecNet_InPDO_GetData_W');				     
        //@ecNet_InPDO_GetData_D				     := GetProcAddress(FDLLInstance, 'ecNet_InPDO_GetData_D');			     
        //@ecNet_InPDO_GetSectPos				     := GetProcAddress(FDLLInstance, 'ecNet_InPDO_GetSectPos');				     
        //@ecNet_InQue_ClearChanList			     := GetProcAddress(FDLLInstance, 'ecNet_InQue_ClearChanList');			     
        //@ecNet_InQue_AddChannel				     := GetProcAddress(FDLLInstance, 'ecNet_InQue_AddChannel');				     
        //@ecNet_InQue_DelChannel				     := GetProcAddress(FDLLInstance, 'ecNet_InQue_DelChannel');				     
        //@ecNet_InQue_GetNumDataDescItems		 := GetProcAddress(FDLLInstance, 'ecNet_InQue_GetNumDataDescItems');
        //@ecNet_InQue_GetDataDesc				 := GetProcAddress(FDLLInstance, 'ecNet_InQue_GetDataDesc');				 
        //@ecNet_InQue_GetQueSizeInfo			     := GetProcAddress(FDLLInstance, 'ecNet_InQue_GetQueSizeInfo');			     
        //@ecNet_InQue_SetStaTrgEnv			     := GetProcAddress(FDLLInstance, 'ecNet_InQue_SetStaTrgEnv');			     
        //@ecNet_InQue_GetStaTrgEnv			     := GetProcAddress(FDLLInstance, 'ecNet_InQue_GetStaTrgEnv');			     
        //@ecNet_InQue_SetStopTrgEnv			     := GetProcAddress(FDLLInstance, 'ecNet_InQue_SetStopTrgEnv');			     
        //@ecNet_InQue_GetStopTrgEnv			     := GetProcAddress(FDLLInstance, 'ecNet_InQue_GetStopTrgEnv');			     
        //@ecNet_InQue_StartChannel			     := GetProcAddress(FDLLInstance, 'ecNet_InQue_StartChannel');			     
        //@ecNet_InQue_StopChannel				 := GetProcAddress(FDLLInstance, 'ecNet_InQue_StopChannel');				 
        //@ecNet_InQue_GetQueuedCount			     := GetProcAddress(FDLLInstance, 'ecNet_InQue_GetQueuedCount');			     
        //@ecNet_InQue_Deque					     := GetProcAddress(FDLLInstance, 'ecNet_InQue_Deque');					     
        //@ecNet_InQue_PeekData				     := GetProcAddress(FDLLInstance, 'ecNet_InQue_PeekData');				     
        //@ecNet_InQue_AddCommonTrg			     := GetProcAddress(FDLLInstance, 'ecNet_InQue_AddCommonTrg');			     
        //@ecNet_InQue_DelCommonTrg			     := GetProcAddress(FDLLInstance, 'ecNet_InQue_DelCommonTrg');			     
        //@ecNet_InQue_EnableCommonTrg			 := GetProcAddress(FDLLInstance, 'ecNet_InQue_EnableCommonTrg');			 
        //@ecNet_InQue_SetCommonTrgState		     := GetProcAddress(FDLLInstance, 'ecNet_InQue_SetCommonTrgState');		     
        //@ecNet_OutPDO_GetBufPtr				     := GetProcAddress(FDLLInstance, 'ecNet_OutPDO_GetBufPtr');				     
        //@ecNet_OutPDO_SetData				     := GetProcAddress(FDLLInstance, 'ecNet_OutPDO_SetData');				     
        //@ecNet_OutPDO_SetData_B				     := GetProcAddress(FDLLInstance, 'ecNet_OutPDO_SetData_B');				     
        //@ecNet_OutPDO_SetData_W				     := GetProcAddress(FDLLInstance, 'ecNet_OutPDO_SetData_W');				     
        //@ecNet_OutPDO_SetData_D				     := GetProcAddress(FDLLInstance, 'ecNet_OutPDO_SetData_D');				     
        //@ecNet_OutPDO_GetSectPos				 := GetProcAddress(FDLLInstance, 'ecNet_OutPDO_GetSectPos');				 
        //@ecCfg_Start							 := GetProcAddress(FDLLInstance, 'ecCfg_Start');							 
        //@ecCfg_End							     := GetProcAddress(FDLLInstance, 'ecCfg_End');						     
        //@ecCfg_SetNetConfig					     := GetProcAddress(FDLLInstance, 'ecCfg_SetNetConfig');					     
        //@ecCfg_GetNetConfig					     := GetProcAddress(FDLLInstance, 'ecCfg_GetNetConfig');					     
        //@ecCfg_SetOutPDOLogicSect			     := GetProcAddress(FDLLInstance, 'ecCfg_SetOutPDOLogicSect');			     
        //@ecCfg_GetOutPDOLogicSect			     := GetProcAddress(FDLLInstance, 'ecCfg_GetOutPDOLogicSect');			     
        //@ecCfg_SetInPDOLogicSect				 := GetProcAddress(FDLLInstance, 'ecCfg_SetInPDOLogicSect');				 
        //@ecCfg_GetInPDOLogicSect				 := GetProcAddress(FDLLInstance, 'ecCfg_GetInPDOLogicSect');				 
        //@ecCfg_SetSlaveConfig				     := GetProcAddress(FDLLInstance, 'ecCfg_SetSlaveConfig');				     
        //@ecCfg_GetSlaveConfig				     := GetProcAddress(FDLLInstance, 'ecCfg_GetSlaveConfig');				     
        //@ecCfg_SetChanMap					     := GetProcAddress(FDLLInstance, 'ecCfg_SetChanMap');					     
        //@ecCfg_GetChanMap					     := GetProcAddress(FDLLInstance, 'ecCfg_GetChanMap');					     
        //@ecCfgFile_Download					     := GetProcAddress(FDLLInstance, 'ecCfgFile_Download');					     
        //@ecCfgFile_Verify					     := GetProcAddress(FDLLInstance, 'ecCfgFile_Verify');					     
        //@ecXml_FindDeviceByProdInfo			     := GetProcAddress(FDLLInstance, 'ecXml_FindDeviceByProdInfo');			     
        //@ecXml_FindElem						     := GetProcAddress(FDLLInstance, 'ecXml_FindElem');
        //@ecXml_FindReadElemAttr				     := GetProcAddress(FDLLInstance, 'ecXml_FindReadElemAttr');				     
        //@ecXml_FindReadElemData				     := GetProcAddress(FDLLInstance, 'ecXml_FindReadElemData');				     
        //@ecXml_GetTagName					     := GetProcAddress(FDLLInstance, 'ecXml_GetTagName');					     
        //@ecXml_GetNumElem					     := GetProcAddress(FDLLInstance, 'ecXml_GetNumElem');					     
        //@ecXml_GetProdDesc					     := GetProcAddress(FDLLInstance, 'ecXml_GetProdDesc');				     
        //@ecXml_IntoElem						     := GetProcAddress(FDLLInstance, 'ecXml_IntoElem');						     
        //@ecXml_LoadByFileName				     := GetProcAddress(FDLLInstance, 'ecXml_LoadByFileName');				     
        //@ecXml_LoadByProdInfo				     := GetProcAddress(FDLLInstance, 'ecXml_LoadByProdInfo');				     
        //@ecXml_OutOfElem						 := GetProcAddress(FDLLInstance, 'ecXml_OutOfElem');						 
        //@ecXml_ReadElemAttr					     := GetProcAddress(FDLLInstance, 'ecXml_ReadElemAttr');					     
        //@ecXml_ReadElemData					     := GetProcAddress(FDLLInstance, 'ecXml_ReadElemData');					     
        //@ecXml_ResetPos						     := GetProcAddress(FDLLInstance, 'ecXml_ResetPos');						     
        //@ecXml_RestorePos					     := GetProcAddress(FDLLInstance, 'ecXml_RestorePos');					     
        //@ecXml_SavePos						     := GetProcAddress(FDLLInstance, 'ecXml_SavePos');						     
        //@ecXml_Str2Bool						     := GetProcAddress(FDLLInstance, 'ecXml_Str2Bool');						     
        //@ecXml_Str2HexDec					     := GetProcAddress(FDLLInstance, 'ecXml_Str2HexDec');					     
        //@ecXml_Unload						     := GetProcAddress(FDLLInstance, 'ecXml_Unload');						     
        //@ecSlv_GetProdInfo_A					 := GetProcAddress(FDLLInstance, 'ecSlv_GetProdInfo_A');					 
        //@ecSlv_GetProdInfo					     := GetProcAddress(FDLLInstance, 'ecSlv_GetProdInfo');					     
        //@ecSlv_GetTypeInfo					     := GetProcAddress(FDLLInstance, 'ecSlv_GetTypeInfo');					     
        //@ecSlv_GetTypeInfo_A					 := GetProcAddress(FDLLInstance, 'ecSlv_GetTypeInfo_A');
        @ecSlv_GetAlState_A					     := GetProcAddress(FDLLInstance, 'ecSlv_GetAlState_A');
        @ecSlv_GetAlState					       := GetProcAddress(FDLLInstance, 'ecSlv_GetAlState');
        //@ecSlv_ReadReg						     := GetProcAddress(FDLLInstance, 'ecSlv_ReadReg');					     
        //@ecSlv_ReadReg_A						 := GetProcAddress(FDLLInstance, 'ecSlv_ReadReg_A');						 
        //@ecSlv_WriteReg						     := GetProcAddress(FDLLInstance, 'ecSlv_WriteReg');						     
        //@ecSlv_WriteReg_FF					     := GetProcAddress(FDLLInstance, 'ecSlv_WriteReg_FF');					     
        //@ecSlv_WriteReg_A					     := GetProcAddress(FDLLInstance, 'ecSlv_WriteReg_A');					     
        //@ecSlv_WriteReg_A_FF					 := GetProcAddress(FDLLInstance, 'ecSlv_WriteReg_A_FF');					 
        //@ecSlv_ReadEEPR						     := GetProcAddress(FDLLInstance, 'ecSlv_ReadEEPR');						     
        //@ecSlv_ReadEEPR_A					     := GetProcAddress(FDLLInstance, 'ecSlv_ReadEEPR_A');					     
        //@ecSlv_WriteEEPR						 := GetProcAddress(FDLLInstance, 'ecSlv_WriteEEPR');						 
        //@ecSlv_WriteEEPR_FF					     := GetProcAddress(FDLLInstance, 'ecSlv_WriteEEPR_FF');					     
        //@ecSlv_WriteEEPR_A					     := GetProcAddress(FDLLInstance, 'ecSlv_WriteEEPR_A');				     
        //@ecSlv_WriteEEPR_A_FF				     := GetProcAddress(FDLLInstance, 'ecSlv_WriteEEPR_A_FF');				     
        //@ecSlv_RenewCrcOfEEPR_A				     := GetProcAddress(FDLLInstance, 'ecSlv_RenewCrcOfEEPR_A');				     
        //@ecSlv_RenewCrcOfEEPR				     := GetProcAddress(FDLLInstance, 'ecSlv_RenewCrcOfEEPR');
        //@ecSlv_ReadCoeSdo					     := GetProcAddress(FDLLInstance, 'ecSlv_ReadCoeSdo');					     
        //@ecSlv_ReadCoeSdo_A					     := GetProcAddress(FDLLInstance, 'ecSlv_ReadCoeSdo_A');					     
        //@ecSlv_WriteCoeSdo					     := GetProcAddress(FDLLInstance, 'ecSlv_WriteCoeSdo');				     
        //@ecSlv_WriteCoeSdo_FF				     := GetProcAddress(FDLLInstance, 'ecSlv_WriteCoeSdo_FF');				     
        //@ecSlv_WriteCoeSdo_A					 := GetProcAddress(FDLLInstance, 'ecSlv_WriteCoeSdo_A');					 
        //@ecSlv_WriteCoeSdo_A_FF				     := GetProcAddress(FDLLInstance, 'ecSlv_WriteCoeSdo_A_FF');				     
        //@ecSlv_ReadReg134ID					     := GetProcAddress(FDLLInstance, 'ecSlv_ReadReg134ID');					     
        //@ecSlv_ReadReg134ID_A				     := GetProcAddress(FDLLInstance, 'ecSlv_ReadReg134ID_A');				     
        //@ecSlv_SdoInfo_GetODList				 := GetProcAddress(FDLLInstance, 'ecSlv_SdoInfo_GetODList');				 
        //@ecSlv_SdoInfo_GetODList_A			     := GetProcAddress(FDLLInstance, 'ecSlv_SdoInfo_GetODList_A');			     
        //@ecSlv_SdoInfo_GetObjDesc			     := GetProcAddress(FDLLInstance, 'ecSlv_SdoInfo_GetObjDesc');			     
        //@ecSlv_SdoInfo_GetObjDesc_A			     := GetProcAddress(FDLLInstance, 'ecSlv_SdoInfo_GetObjDesc_A');			     
        //@ecSlv_SdoInfo_GetEntryDesc			     := GetProcAddress(FDLLInstance, 'ecSlv_SdoInfo_GetEntryDesc');			     
        //@ecSlv_SdoInfo_GetEntryDesc_A 		     := GetProcAddress(FDLLInstance, 'ecSlv_SdoInfo_GetEntryDesc_A'); 		     
        //@ecSlv_SdoInfo_ReleaseData 			     := GetProcAddress(FDLLInstance, 'ecSlv_SdoInfo_ReleaseData'); 			     
        //@ecSlv_SlvIdx2PhysAddr				     := GetProcAddress(FDLLInstance, 'ecSlv_SlvIdx2PhysAddr');				     
        //@ecSlv_PhysAddr2SlvIdx				     := GetProcAddress(FDLLInstance, 'ecSlv_PhysAddr2SlvIdx');				     
        //@ecSlv_InPDO_GetBufPtr				     := GetProcAddress(FDLLInstance, 'ecSlv_InPDO_GetBufPtr');				     
        //@ecSlv_InPDO_GetOffset				     := GetProcAddress(FDLLInstance, 'ecSlv_InPDO_GetOffset');				     
        //@ecSlv_InPDO_GetBufLen				     := GetProcAddress(FDLLInstance, 'ecSlv_InPDO_GetBufLen');				     
        //@ecSlv_OutPDO_GetBufPtr				     := GetProcAddress(FDLLInstance, 'ecSlv_OutPDO_GetBufPtr');				     
        //@ecSlv_OutPDO_GetOffset				     := GetProcAddress(FDLLInstance, 'ecSlv_OutPDO_GetOffset');				     
        //@ecSlv_OutPDO_GetBufLen				     := GetProcAddress(FDLLInstance, 'ecSlv_OutPDO_GetBufLen');				     
        //@ecSlv_OutPDO_SetInitValMode			 := GetProcAddress(FDLLInstance, 'ecSlv_OutPDO_SetInitValMode');			 
        //@ecSlv_OutPDO_GetInitValMode			 := GetProcAddress(FDLLInstance, 'ecSlv_OutPDO_GetInitValMode');			 
        //@ecSlv_OutPDO_SetInitVal				 := GetProcAddress(FDLLInstance, 'ecSlv_OutPDO_SetInitVal');				 
        //@ecSlv_OutPDO_GetInitVal				 := GetProcAddress(FDLLInstance, 'ecSlv_OutPDO_GetInitVal');				 
        @ecSlv_GetComErrSum_A				     := GetProcAddress(FDLLInstance, 'ecSlv_GetComErrSum_A');
        //@ecSlv_GetComErrSum					     := GetProcAddress(FDLLInstance, 'ecSlv_GetComErrSum');
        @ecSlv_ClearComErrSum_A				     := GetProcAddress(FDLLInstance, 'ecSlv_ClearComErrSum_A');
        //@ecSlv_ClearComErrSum				     := GetProcAddress(FDLLInstance, 'ecSlv_ClearComErrSum');				     
        //@ecdiGetSlaveIndex					     := GetProcAddress(FDLLInstance, 'ecdiGetSlaveIndex');					     
        //@ecdiGetSlaveID						     := GetProcAddress(FDLLInstance, 'ecdiGetSlaveID');						     
        @ecdiGetNumChannels					     := GetProcAddress(FDLLInstance, 'ecdiGetNumChannels');
        //@ecdiGetOne							     := GetProcAddress(FDLLInstance, 'ecdiGetOne');							     
        @ecdiGetMulti						     := GetProcAddress(FDLLInstance, 'ecdiGetMulti');
        //@ecdiGetLogicAddr					     := GetProcAddress(FDLLInstance, 'ecdiGetLogicAddr');
        //@ecdiLtc_AddChannel					     := GetProcAddress(FDLLInstance, 'ecdiLtc_AddChannel');					     
        //@ecdiLtc_DelChannel					     := GetProcAddress(FDLLInstance, 'ecdiLtc_DelChannel');					     
        //@ecdiLtc_SetFilter					     := GetProcAddress(FDLLInstance, 'ecdiLtc_SetFilter');					     
        //@ecdiLtc_GetFilter					     := GetProcAddress(FDLLInstance, 'ecdiLtc_GetFilter');					     
        //@ecdiLtc_SetLogicInvert				     := GetProcAddress(FDLLInstance, 'ecdiLtc_SetLogicInvert');				     
        //@ecdiLtc_GetLogicInvert				     := GetProcAddress(FDLLInstance, 'ecdiLtc_GetLogicInvert');				     
        //@ecdiLtc_GetOnCount					     := GetProcAddress(FDLLInstance, 'ecdiLtc_GetOnCount');					     
        //@ecdiLtc_ResetOnCount				     := GetProcAddress(FDLLInstance, 'ecdiLtc_ResetOnCount');				     
        @ecdiGetOne_L						     := GetProcAddress(FDLLInstance, 'ecdiGetOne_L');						     
        @ecdiGetMulti_L						     := GetProcAddress(FDLLInstance, 'ecdiGetMulti_L');						     
        //@ecdiLtc_AddChannel_L				     := GetProcAddress(FDLLInstance, 'ecdiLtc_AddChannel_L');				     
        //@ecdiLtc_DelChannel_L				     := GetProcAddress(FDLLInstance, 'ecdiLtc_DelChannel_L');			     
        //@ecdiLtc_SetFilter_L					 := GetProcAddress(FDLLInstance, 'ecdiLtc_SetFilter_L');					 
        //@ecdiLtc_GetFilter_L					 := GetProcAddress(FDLLInstance, 'ecdiLtc_GetFilter_L');				 
        //@ecdiLtc_SetLogicInvert_L			     := GetProcAddress(FDLLInstance, 'ecdiLtc_SetLogicInvert_L');			     
        //@ecdiLtc_GetLogicInvert_L			     := GetProcAddress(FDLLInstance, 'ecdiLtc_GetLogicInvert_L');			     
        //@ecdiLtc_GetOnCount_L				     := GetProcAddress(FDLLInstance, 'ecdiLtc_GetOnCount_L');				     
        //@ecdiLtc_ResetOnCount_L				     := GetProcAddress(FDLLInstance, 'ecdiLtc_ResetOnCount_L');				     
        @ecdiLogBitAddr_FromGlobalChannel	     := GetProcAddress(FDLLInstance, 'ecdiLogBitAddr_FromGlobalChannel');	     
        @ecdiLogBitAddr_FromLocalChannel		 := GetProcAddress(FDLLInstance, 'ecdiLogBitAddr_FromLocalChannel');		 
        @ecdiLogBitAddr_FromOnboardChannel	     := GetProcAddress(FDLLInstance, 'ecdiLogBitAddr_FromOnboardChannel');	     
        @ecdiLogBitAddr_ToGlobalChannel		     := GetProcAddress(FDLLInstance, 'ecdiLogBitAddr_ToGlobalChannel');		     
        @ecdiLogBitAddr_ToLocalChannel		     := GetProcAddress(FDLLInstance, 'ecdiLogBitAddr_ToLocalChannel');
        @ecdiLogBitAddr_ToOnboardChannel		 := GetProcAddress(FDLLInstance, 'ecdiLogBitAddr_ToOnboardChannel');		 
        @ecdiLogBitAddr_GetChanType			     := GetProcAddress(FDLLInstance, 'ecdiLogBitAddr_GetChanType');
        @ecdoGetSlaveIndex					     := GetProcAddress(FDLLInstance, 'ecdoGetSlaveIndex');					     
        @ecdoGetSlaveID						     := GetProcAddress(FDLLInstance, 'ecdoGetSlaveID');						     
        @ecdoGetNumChannels					     := GetProcAddress(FDLLInstance, 'ecdoGetNumChannels');
        @ecdoPutOne							     := GetProcAddress(FDLLInstance, 'ecdoPutOne');							     
        @ecdoPutMulti						     := GetProcAddress(FDLLInstance, 'ecdoPutMulti');						     
        @ecdoGetOne							     := GetProcAddress(FDLLInstance, 'ecdoGetOne');							     
        @ecdoGetMulti						     := GetProcAddress(FDLLInstance, 'ecdoGetMulti');
        @ecdoPutOne_L						     := GetProcAddress(FDLLInstance, 'ecdoPutOne_L');						     
        @ecdoPutMulti_L						     := GetProcAddress(FDLLInstance, 'ecdoPutMulti_L');						     
        @ecdoGetOne_L						     := GetProcAddress(FDLLInstance, 'ecdoGetOne_L');						     
        @ecdoGetMulti_L						     := GetProcAddress(FDLLInstance, 'ecdoGetMulti_L');						     
        @ecdoLogBitAddr_FromGlobalChannel	     := GetProcAddress(FDLLInstance, 'ecdoLogBitAddr_FromGlobalChannel');
        @ecdoLogBitAddr_FromLocalChannel		 := GetProcAddress(FDLLInstance, 'ecdoLogBitAddr_FromLocalChannel');		 
        @ecdoLogBitAddr_FromOnboardChannel	     := GetProcAddress(FDLLInstance, 'ecdoLogBitAddr_FromOnboardChannel');	     
        @ecdoLogBitAddr_ToGlobalChannel		     := GetProcAddress(FDLLInstance, 'ecdoLogBitAddr_ToGlobalChannel');		     
        @ecdoLogBitAddr_ToLocalChannel		     := GetProcAddress(FDLLInstance, 'ecdoLogBitAddr_ToLocalChannel');		     
        @ecdoLogBitAddr_ToOnboardChannel		 := GetProcAddress(FDLLInstance, 'ecdoLogBitAddr_ToOnboardChannel');		 
        @ecdoLogBitAddr_GetChanType			     := GetProcAddress(FDLLInstance, 'ecdoLogBitAddr_GetChanType');			     
        //@ecaiGetSlaveIndex					     := GetProcAddress(FDLLInstance, 'ecaiGetSlaveIndex');					     
        //@ecaiGetSlaveID						     := GetProcAddress(FDLLInstance, 'ecaiGetSlaveID');						     
        //@ecaiGetNumChannels					     := GetProcAddress(FDLLInstance, 'ecaiGetNumChannels');					     
        //@ecaiGetChanVal_I					     := GetProcAddress(FDLLInstance, 'ecaiGetChanVal_I');					     
        //@ecaiGetChanVal_F					     := GetProcAddress(FDLLInstance, 'ecaiGetChanVal_F');					     
        //@ecaiGetChanVal_FS					     := GetProcAddress(FDLLInstance, 'ecaiGetChanVal_FS');					     
        //@ecaoGetSlaveIndex					     := GetProcAddress(FDLLInstance, 'ecaoGetSlaveIndex	');				     
        //@ecaoGetSlaveID						     := GetProcAddress(FDLLInstance, 'ecaoGetSlaveID');						     
        //@ecaoGetNumChannels					     := GetProcAddress(FDLLInstance, 'ecaoGetNumChannels');					     
        //@ecaoSetChanVal_I					     := GetProcAddress(FDLLInstance, 'ecaoSetChanVal_I');					     
        //@ecaoSetChanVal_F					     := GetProcAddress(FDLLInstance, 'ecaoSetChanVal_F');					     
        //@ecaoSetChanVal_FS					     := GetProcAddress(FDLLInstance, 'ecaoSetChanVal_FS');					     
        //@ecaoGetOutValue_I					     := GetProcAddress(FDLLInstance, 'ecaoGetOutValue_I');					     
        //@ecaoGetOutValue_F					     := GetProcAddress(FDLLInstance, 'ecaoGetOutValue_F');					     
        //@ecaoGetOutValue_FS					     := GetProcAddress(FDLLInstance, 'ecaoGetOutValue_FS');					     
        @ecmGn_GetAxisList					     := GetProcAddress(FDLLInstance, 'ecmGn_GetAxisList');
        //@ecmGn_GetInPDOHeader				     := GetProcAddress(FDLLInstance, 'ecmGn_GetInPDOHeader');				     
        @ecmGn_AxisToSlaveIndex				     := GetProcAddress(FDLLInstance, 'ecmGn_AxisToSlaveIndex');
        //@ecmGn_AxisToSlaveID					 := GetProcAddress(FDLLInstance, 'ecmGn_AxisToSlaveID');					 
        //@ecmGn_SlaveIndexToAxis				     := GetProcAddress(FDLLInstance, 'ecmGn_SlaveIndexToAxis');				     
        //@ecmGn_SlaveIDToAxis					 := GetProcAddress(FDLLInstance, 'ecmGn_SlaveIDToAxis');					 
        //@ecmGn_InitFromFile					     := GetProcAddress(FDLLInstance, 'ecmGn_InitFromFile');					     
        //@ecmHEMG_SetInputEnv					 := GetProcAddress(FDLLInstance, 'ecmHEMG_SetInputEnv');					 
        //@ecmHEMG_GetInputEnv					 := GetProcAddress(FDLLInstance, 'ecmHEMG_GetInputEnv');					 
        //@ecmHEMG_SetInputEnv_Multi			     := GetProcAddress(FDLLInstance, 'ecmHEMG_SetInputEnv_Multi');			     
        //@ecmHEMG_GetInputEnv_Multi			     := GetProcAddress(FDLLInstance, 'ecmHEMG_GetInputEnv_Multi');			     
        //@ecmHEMG_GetNumInputs				     := GetProcAddress(FDLLInstance, 'ecmHEMG_GetNumInputs');				     
        //@ecmHEMG_SetStopMode					 := GetProcAddress(FDLLInstance, 'ecmHEMG_SetStopMode');					 
        //@ecmHEMG_GetStopMode					 := GetProcAddress(FDLLInstance, 'ecmHEMG_GetStopMode');					 
        //@ecmHEMG_SetEnable					     := GetProcAddress(FDLLInstance, 'ecmHEMG_SetEnable');					     
        //@ecmHEMG_GetEnable					     := GetProcAddress(FDLLInstance, 'ecmHEMG_GetEnable');
        //@ecmHEMG_GetState					     := GetProcAddress(FDLLInstance, 'ecmHEMG_GetState');					     
        //@ecmSEMG_SetStopMode					 := GetProcAddress(FDLLInstance, 'ecmSEMG_SetStopMode');					 
        //@ecmSEMG_GetStopMode					 := GetProcAddress(FDLLInstance, 'ecmSEMG_GetStopMode');					 
        //@ecmSEMG_SetState					     := GetProcAddress(FDLLInstance, 'ecmSEMG_SetState');					     
        //@ecmSEMG_GetState					     := GetProcAddress(FDLLInstance, 'ecmSEMG_GetState');					     
        //@ecmCollA_SetEnv						 := GetProcAddress(FDLLInstance, 'ecmCollA_SetEnv');						 
        //@ecmCollA_GetEnv						 := GetProcAddress(FDLLInstance, 'ecmCollA_GetEnv');						 
        //@ecmCollA_SetStopMode				     := GetProcAddress(FDLLInstance, 'ecmCollA_SetStopMode');				     
        //@ecmCollA_GetStopMode				     := GetProcAddress(FDLLInstance, 'ecmCollA_GetStopMode');				     
        //@ecmCollA_SetEnable					     := GetProcAddress(FDLLInstance, 'ecmCollA_SetEnable');					     
        //@ecmCollA_GetEnable					     := GetProcAddress(FDLLInstance, 'ecmCollA_GetEnable');					     
        @ecmSxCfg_SetUnitDist				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetUnitDist');			     
        @ecmSxCfg_GetUnitDist				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetUnitDist');				     
        //@ecmSxCfg_GetSoftLimit				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetSoftLimit');
        //@ecmSxCfg_SetSoftLimit				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSoftLimit');
        @ecmSxCfg_SetOperMode				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetOperMode');				     
        @ecmSxCfg_GetOperMode				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetOperMode');				     
        @ecmSxCfg_SetUnitSpeed				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetUnitSpeed');				     
        @ecmSxCfg_GetUnitSpeed				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetUnitSpeed');				     
        @ecmSxCfg_SetMioProp					 := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetMioProp');					 
        @ecmSxCfg_GetMioProp					 := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetMioProp');					 
        @ecmSxCfg_SetMastInp					 := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetMastInp');					 
        @ecmSxCfg_GetMastInp					 := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetMastInp');					 
        @ecmSxCfg_SetMastInp_Cnt				 := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetMastInp_Cnt');				 
        @ecmSxCfg_GetMastInp_Cnt				 := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetMastInp_Cnt');				 
        @ecmSxCfg_SetSpeedPatt				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSpeedPatt');				     
        //@ecmSxCfg_SetSpeedPatt_FF			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSpeedPatt_FF');			     
        @ecmSxCfg_GetSpeedPatt				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetSpeedPatt');				     
        @ecmSxCfg_SetSpeedPatt_Time			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSpeedPatt_Time');			     
        //@ecmSxCfg_SetSpeedPatt_Time_FF		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSpeedPatt_Time_FF');		     
        @ecmSxCfg_GetSpeedPatt_Time			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetSpeedPatt_Time');			     
        @ecmSxCfg_SetSpeedRatio				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSpeedRatio');
        //@ecmSxCfg_SetSpeedRatio_FF			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSpeedRatio_FF');
        //@ecmSxCfg_GetSpeedRatio				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetSpeedRatio');
        //@ecmSxCfg_SetJerkRatio				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetJerkRatio');
        //@ecmSxCfg_SetJerkRatio_FF			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetJerkRatio_FF');
        //@ecmSxCfg_GetJerkRatio				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetJerkRatio');
        //@ecmSxCfg_SetJerkMode				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetJerkMode');
        //@ecmSxCfg_GetJerkMode				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetJerkModev');
        //@ecmSxCfg_SetJerk					     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetJerk');
        //@ecmSxCfg_GetJerk					     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetJerk');
        //@ecmSxCfg_SetSecondaryAcc			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSecondaryAcc');
        //@ecmSxCfg_GetSecondaryAcc			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetSecondaryAcc');
        //@ecmSxCfg_SetSecondaryDec			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSecondaryDec');
        //@ecmSxCfg_GetSecondaryDec			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetSecondaryDec');
        //@ecmSxCfg_SetMinAccDecTime			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetMinAccDecTime');
        //@ecmSxCfg_GetMinAccDecTime			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetMinAccDecTime');
        //@ecmSxCfg_SetTouchProbeFunc			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetTouchProbeFunc');
        //@ecmSxCfg_GetTouchProbeFunc			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetTouchProbeFunc');
        //@ecmSxCfg_SetSyncOtherEnv			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSyncOtherEnv');
        //@ecmSxCfg_GetSyncOtherEnv			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetSyncOtherEnv');
        //@ecmSxCfg_SetSyncOtherEnable			 := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetSyncOtherEnable');
        //@ecmSxCfg_GetSyncOtherEnable			 := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetSyncOtherEnable');
        @ecmSxCfg_PosCorr_SetTableSize		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr_SetTableSize');		     
        @ecmSxCfg_PosCorr_GetTableSize		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr_GetTableSize');     
        @ecmSxCfg_PosCorr_SetTableData		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr_SetTableData');		     
        @ecmSxCfg_PosCorr_GetTableData		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr_GetTableData');		     
        @ecmSxCfg_PosCorr_SetTableFromFile	     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr_SetTableFromFile');	     
        @ecmSxCfg_PosCorr_SetEnable			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr_SetEnable');			     
        @ecmSxCfg_PosCorr_GetEnable			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr_GetEnable');			     
        @ecmSxCfg_PosCorr_ClearTable			 := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr_ClearTable');
        //@ecmSxCfg_PosCorr2D_Reset			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr2D_Reset');			     
        //@ecmSxCfg_PosCorr2D_SetTableHeader	     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr2D_SetTableHeader');	     
        //@ecmSxCfg_PosCorr2D_GetTableHeader	     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr2D_GetTableHeader');     
        //@ecmSxCfg_PosCorr2D_SetTableData		 := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr2D_SetTableData');		 
        //@ecmSxCfg_PosCorr2D_GetTableData		 := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr2D_GetTableData');		 
        //@ecmSxCfg_PosCorr2D_SetTableFromFile	 := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr2D_SetTableFromFile');	 
        //@ecmSxCfg_PosCorr2D_SetEnable		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr2D_SetEnable');		     
        //@ecmSxCfg_PosCorr2D_GetEnable		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_PosCorr2D_GetEnable');		     
        //@ecmSxCfg_AutoTorq_SetValMode		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_AutoTorq_SetValMode');		     
        //@ecmSxCfg_AutoTorq_GetValMode		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_AutoTorq_GetValMode');		     
        //@ecmSxCfg_AutoTorq_SetMultiVal		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_AutoTorq_SetMultiVal');		     
        //@ecmSxCfg_AutoTorq_GetMultiVal		     := GetProcAddress(FDLLInstance, 'ecmSxCfg_AutoTorq_GetMultiVal');		     
        //@ecmSxCfg_AutoTorq_SetValue			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_AutoTorq_SetValue');
        //@ecmSxCfg_AutoTorq_GetValue			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_AutoTorq_GetValue');			     
        //@ecmSxCfg_AutoTorq_SetLimit			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_AutoTorq_SetLimit');			     
        //@ecmSxCfg_AutoTorq_GetLimit			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_AutoTorq_GetLimit');			     
        //@ecmSxCfg_AutoTorq_SetEnable			 := GetProcAddress(FDLLInstance, 'ecmSxCfg_AutoTorq_SetEnable');			 
        //@ecmSxCfg_AutoTorq_GetEnable			 := GetProcAddress(FDLLInstance, 'ecmSxCfg_AutoTorq_GetEnable');			 
        @ecmSxCfg_Ring_GetEnable				 := GetProcAddress(FDLLInstance, 'ecmSxCfg_Ring_GetEnable');				 
        @ecmSxCfg_Ring_SetEnable				 := GetProcAddress(FDLLInstance, 'ecmSxCfg_Ring_SetEnable');				 
        @ecmSxCfg_Ring_GetPosRange			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_Ring_GetPosRange');			     
        @ecmSxCfg_Ring_SetPosRange			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_Ring_SetPosRange');			     
        @ecmSxCfg_Ring_GetDirMode			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_Ring_GetDirMode');			     
        @ecmSxCfg_Ring_SetDirMode			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_Ring_SetDirMode');			     
        //@ecmSxCfg_ExtStop_SetEnable			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_ExtStop_SetEnable');			     
        //@ecmSxCfg_ExtStop_GetEnable			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_ExtStop_GetEnable');			     
        //@ecmSxCfg_ExtStop_SetEnv				 := GetProcAddress(FDLLInstance, 'ecmSxCfg_ExtStop_SetEnv');				 
        //@ecmSxCfg_ExtStop_SetEnv2			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_ExtStop_SetEnv2');			     
        //@ecmSxCfg_ExtStop_SetEnv3			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_ExtStop_SetEnv3');			     
        //@ecmSxCfg_ExtStop_GetEnv				 := GetProcAddress(FDLLInstance, 'ecmSxCfg_ExtStop_GetEnv');
        //@ecmSxCfg_ExtStop_GetEnv2			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_ExtStop_GetEnv2');			     
        //@ecmSxCfg_ExtStop_GetEnv3			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_ExtStop_GetEnv3');			     
        //@ecmSxCfg_ExtStop_SetOfsDistMode		 := GetProcAddress(FDLLInstance, 'ecmSxCfg_ExtStop_SetOfsDistMode');		 
        //@ecmSxCfg_ExtStop_GetOfsDistMode		 := GetProcAddress(FDLLInstance, 'ecmSxCfg_ExtStop_GetOfsDistMode');		 
        @ecmSxCfg_SetMaxTorqOfCV				 := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetMaxTorqOfCV');
        @ecmSxCfg_GetMaxTorqOfCV				 := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetMaxTorqOfCV');				 
        @ecmSxCfg_SetMaxSpdOfCT				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetMaxSpdOfCT');				     
        @ecmSxCfg_GetMaxSpdOfCT				     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetMaxSpdOfCT');				     
        @ecmSxCfg_SetMaxProfSpdOfCT			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_SetMaxProfSpdOfCT');			     
        @ecmSxCfg_GetMaxProfSpdOfCT			     := GetProcAddress(FDLLInstance, 'ecmSxCfg_GetMaxProfSpdOfCT');			     
        @ecmSxCtl_SetSvon					     := GetProcAddress(FDLLInstance, 'ecmSxCtl_SetSvon');
        @ecmSxCtl_GetSvon					     := GetProcAddress(FDLLInstance, 'ecmSxCtl_GetSvon');					     
        //@ecmSxCtl_SetSvon_FF					 := GetProcAddress(FDLLInstance, 'ecmSxCtl_SetSvon_FF');					 
        @ecmSxCtl_SetAlmRst					     := GetProcAddress(FDLLInstance, 'ecmSxCtl_SetAlmRst');					     
        //@ecmSxCtl_SetAlmRst_FF				     := GetProcAddress(FDLLInstance, 'ecmSxCtl_SetAlmRst_FF');				     
        @ecmSxCtl_ResetAlm					     := GetProcAddress(FDLLInstance, 'ecmSxCtl_ResetAlm');					     
        //@ecmSxCtl_ResetAlm_FF				     := GetProcAddress(FDLLInstance, 'ecmSxCtl_ResetAlm_FF');				     
        @ecmSxMot_SetTargTorq				     := GetProcAddress(FDLLInstance, 'ecmSxMot_SetTargTorq');				     
        @ecmSxMot_GetTargTorq				     := GetProcAddress(FDLLInstance, 'ecmSxMot_GetTargTorq');				     
        @ecmSxMot_SetTargVel					 := GetProcAddress(FDLLInstance, 'ecmSxMot_SetTargVel');
        @ecmSxMot_GetTargVel					 := GetProcAddress(FDLLInstance, 'ecmSxMot_GetTargVel');					 
        @ecmSxMot_VMoveStart					 := GetProcAddress(FDLLInstance, 'ecmSxMot_VMoveStart');					 
        //@ecmSxMot_VMoveStart_FF				     := GetProcAddress(FDLLInstance, 'ecmSxMot_VMoveStart_FF');				     
        @ecmSxMot_MoveStart					     := GetProcAddress(FDLLInstance, 'ecmSxMot_MoveStart');					     
        //@ecmSxMot_MoveStart_FF				     := GetProcAddress(FDLLInstance, 'ecmSxMot_MoveStart_FF');				     
        @ecmSxMot_Move						     := GetProcAddress(FDLLInstance, 'ecmSxMot_Move');						     
        //@ecmSxMot_Move_NB					     := GetProcAddress(FDLLInstance, 'ecmSxMot_Move_NB');
        @ecmSxMot_MoveToStart				     := GetProcAddress(FDLLInstance, 'ecmSxMot_MoveToStart');				     
        //@ecmSxMot_MoveToStart_FF				 := GetProcAddress(FDLLInstance, 'ecmSxMot_MoveToStart_FF');				 
        @ecmSxMot_MoveTo						 := GetProcAddress(FDLLInstance, 'ecmSxMot_MoveTo');						 
        //@ecmSxMot_MoveTo_NB					     := GetProcAddress(FDLLInstance, 'ecmSxMot_MoveTo_NB');					     
        @ecmSxMot_OverrideSpeed				     := GetProcAddress(FDLLInstance, 'ecmSxMot_OverrideSpeed');				     
        @ecmSxMot_OverrideMove				     := GetProcAddress(FDLLInstance, 'ecmSxMot_OverrideMove');				     
        @ecmSxMot_OverrideMoveTo				 := GetProcAddress(FDLLInstance, 'ecmSxMot_OverrideMoveTo');				 
        @ecmSxMot_Stop						     := GetProcAddress(FDLLInstance, 'ecmSxMot_Stop');						     
        //@ecmSxMot_Stop_FF					     := GetProcAddress(FDLLInstance, 'ecmSxMot_Stop_FF');					     
        @ecmMxMot_VMoveStart					 := GetProcAddress(FDLLInstance, 'ecmMxMot_VMoveStart');
        //@ecmMxMot_VMoveStart_FF				     := GetProcAddress(FDLLInstance, 'ecmMxMot_VMoveStart_FF');
        @ecmMxMot_MoveStart					     := GetProcAddress(FDLLInstance, 'ecmMxMot_MoveStart');
        //@ecmMxMot_MoveStart_FF				     := GetProcAddress(FDLLInstance, 'ecmMxMot_MoveStart_FF');
        @ecmMxMot_MoveToStart				     := GetProcAddress(FDLLInstance, 'ecmMxMot_MoveToStart');
        //@ecmMxMot_MoveToStart_FF				 := GetProcAddress(FDLLInstance, 'ecmMxMot_MoveToStart_FF');
        @ecmMxMot_Stop						     := GetProcAddress(FDLLInstance, 'ecmMxMot_Stop');
        //@ecmMxMot_Stop_FF					     := GetProcAddress(FDLLInstance, 'ecmMxMot_Stop_FF');
        @ecmMxSt_IsBusy						     := GetProcAddress(FDLLInstance, 'ecmMxSt_IsBusy');
        @ecmMxSt_WaitCompt					     := GetProcAddress(FDLLInstance, 'ecmMxSt_WaitCompt');
        //@ecmMxSt_WaitCompt_NB				     := GetProcAddress(FDLLInstance, 'ecmMxSt_WaitCompt_NB');
        //@ecmSxSt_IsConnected					 := GetProcAddress(FDLLInstance, 'ecmSxSt_IsConnected');
        //@ecmSxSt_GetInPDOPtr					 := GetProcAddress(FDLLInstance, 'ecmSxSt_GetInPDOPtr');
        //@ecmSxSt_IsBusy						     := GetProcAddress(FDLLInstance, 'ecmSxSt_IsBusy');						     
        @ecmSxSt_WaitCompt					     := GetProcAddress(FDLLInstance, 'ecmSxSt_WaitCompt');					     
        //@ecmSxSt_WaitCompt_NB				     := GetProcAddress(FDLLInstance, 'ecmSxSt_WaitCompt_NB');				     
        @ecmSxSt_SetCount					     := GetProcAddress(FDLLInstance, 'ecmSxSt_SetCount');					     
        @ecmSxSt_GetCount					     := GetProcAddress(FDLLInstance, 'ecmSxSt_GetCount');					     
        @ecmSxSt_SetPosition					 := GetProcAddress(FDLLInstance, 'ecmSxSt_SetPosition');					 
        @ecmSxSt_GetPosition					 := GetProcAddress(FDLLInstance, 'ecmSxSt_GetPosition');				 
        @ecmSxSt_GetCurSpeed					 := GetProcAddress(FDLLInstance, 'ecmSxSt_GetCurSpeed');
        @ecmSxSt_GetCurTorque				     := GetProcAddress(FDLLInstance, 'ecmSxSt_GetCurTorque');			     
        @ecmSxSt_GetMotState					 := GetProcAddress(FDLLInstance, 'ecmSxSt_GetMotState');				 
        @ecmSxSt_GetFlags					     := GetProcAddress(FDLLInstance, 'ecmSxSt_GetFlags');					     
        @ecmSxSt_GetDI						     := GetProcAddress(FDLLInstance, 'ecmSxSt_GetDI');					     
        //@ecmSxSt_GetTouchProbeSts			     := GetProcAddress(FDLLInstance, 'ecmSxSt_GetTouchProbeSts');			     
        //@ecmSxSt_GetTouchProbePos			     := GetProcAddress(FDLLInstance, 'ecmSxSt_GetTouchProbePos');			     
        //@ecmSxSt_GetOpModeDisp				     := GetProcAddress(FDLLInstance, 'ecmSxSt_GetOpModeDisp');				     
        //@ecmSxSt_GetLmMapIdx					 := GetProcAddress(FDLLInstance, 'ecmSxSt_GetLmMapIdx');					 
        //@ecmSxSt_GetPtmMapIdx				     := GetProcAddress(FDLLInstance, 'ecmSxSt_GetPtmMapIdx');				     
        //@ecmSxCmpOne_SetHandler				     := GetProcAddress(FDLLInstance, 'ecmSxCmpOne_SetHandler');				     
        //@ecmSxCmpOne_SetEnable				     := GetProcAddress(FDLLInstance, 'ecmSxCmpOne_SetEnable');				     
        //@ecmSxCmpOne_GetEnable				     := GetProcAddress(FDLLInstance, 'ecmSxCmpOne_GetEnable');				     
        //@ecmSxCmpOne_SetEnv					     := GetProcAddress(FDLLInstance, 'ecmSxCmpOne_SetEnv');					     
        //@ecmSxCmpOne_GetEnv					     := GetProcAddress(FDLLInstance, 'ecmSxCmpOne_GetEnv');					     
        //@ecmSxCmpOne_GetOutSts				     := GetProcAddress(FDLLInstance, 'ecmSxCmpOne_GetOutSts');				     
        //@ecmSxCmpOne_ResetOutSts				 := GetProcAddress(FDLLInstance, 'ecmSxCmpOne_ResetOutSts');				 
        //@ecmSxCmpCont_SetEnable				     := GetProcAddress(FDLLInstance, 'ecmSxCmpCont_SetEnable');				     
        //@ecmSxCmpCont_GetEnable				     := GetProcAddress(FDLLInstance, 'ecmSxCmpCont_GetEnable');				     
        //@ecmSxCmpCont_SetTableSize			     := GetProcAddress(FDLLInstance, 'ecmSxCmpCont_SetTableSize');			     
        //@ecmSxCmpCont_GetTableSize			     := GetProcAddress(FDLLInstance, 'ecmSxCmpCont_GetTableSize');	     
        //@ecmSxCmpCont_SetTableData			     := GetProcAddress(FDLLInstance, 'ecmSxCmpCont_SetTableData');			     
        //@ecmSxCmpCont_GetTableData			     := GetProcAddress(FDLLInstance, 'ecmSxCmpCont_GetTableData');			     
        //@ecmSxCmpCont_GetActTblIdx			     := GetProcAddress(FDLLInstance, 'ecmSxCmpCont_GetActTblIdx');			     
        //@ecmSxCmpCont_SetActTblIdx			     := GetProcAddress(FDLLInstance, 'ecmSxCmpCont_SetActTblIdx');			     
        //@ecmSxCmpCont_GetOutSts				     := GetProcAddress(FDLLInstance, 'ecmSxCmpCont_GetOutSts');				     
        //@ecmSxCmpCont_ResetOutSts			     := GetProcAddress(FDLLInstance, 'ecmSxCmpCont_ResetOutSts');			     
        //@ecmSxSD_SetInputEnv					 := GetProcAddress(FDLLInstance, 'ecmSxSD_SetInputEnv');					 
        //@ecmSxSD_GetInputEnv					 := GetProcAddress(FDLLInstance, 'ecmSxSD_GetInputEnv');					 
        //@ecmSxSD_SetSpeed					     := GetProcAddress(FDLLInstance, 'ecmSxSD_SetSpeed');					     
        //@ecmSxSD_GetSpeed					     := GetProcAddress(FDLLInstance, 'ecmSxSD_GetSpeed');					     
        //@ecmSxSD_SetOffset					     := GetProcAddress(FDLLInstance, 'ecmSxSD_SetOffset');					     
        //@ecmSxSD_GetOffset					     := GetProcAddress(FDLLInstance, 'ecmSxSD_GetOffset');					     
        //@ecmSxSD_SetLatchMode				     := GetProcAddress(FDLLInstance, 'ecmSxSD_SetLatchMode');				     
        //@ecmSxSD_GetLatchMode				     := GetProcAddress(FDLLInstance, 'ecmSxSD_GetLatchMode');				     
        //@ecmSxSD_SetEnable					     := GetProcAddress(FDLLInstance, 'ecmSxSD_SetEnable');					     
        //@ecmSxSD_GetEnable					     := GetProcAddress(FDLLInstance, 'ecmSxSD_GetEnable');					     
        //@ecmSxSD_RestoreSpeed				     := GetProcAddress(FDLLInstance, 'ecmSxSD_RestoreSpeed');
        //@ecmSxSD_GetInputStatus				     := GetProcAddress(FDLLInstance, 'ecmSxSD_GetInputStatus');				     
        //@ecmSxSD_GetActStatus				     := GetProcAddress(FDLLInstance, 'ecmSxSD_GetActStatus');				     
        //@ecmSxMulTorq1_Start					 := GetProcAddress(FDLLInstance, 'ecmSxMulTorq1_Start');					 
        //@ecmSxMulTorq1_Stop					     := GetProcAddress(FDLLInstance, 'ecmSxMulTorq1_Stop');					     
        //@ecmIxCfg_MapAxes					     := GetProcAddress(FDLLInstance, 'ecmIxCfg_MapAxes');					     
        //@ecmIxCfg_MapAxes_FF					 := GetProcAddress(FDLLInstance, 'ecmIxCfg_MapAxes_FF');					 
        //@ecmIxCfg_UnmapAxes					     := GetProcAddress(FDLLInstance, 'ecmIxCfg_UnmapAxes');					     
        //@ecmIxCfg_UnmapAxes_FF				     := GetProcAddress(FDLLInstance, 'ecmIxCfg_UnmapAxes_FF');				     
        //@ecmIxCfg_SetSpeedPatt				     := GetProcAddress(FDLLInstance, 'ecmIxCfg_SetSpeedPatt');				     
        //@ecmIxCfg_SetSpeedPatt_FF			     := GetProcAddress(FDLLInstance, 'ecmIxCfg_SetSpeedPatt_FF');			     
        //@ecmIxCfg_GetSpeedPatt				     := GetProcAddress(FDLLInstance, 'ecmIxCfg_GetSpeedPatt');				     
        //@ecmIxCfg_SetSpeedPatt_MR			     := GetProcAddress(FDLLInstance, 'ecmIxCfg_SetSpeedPatt_MR');			     
        //@ecmIxCfg_SetSpeedPatt_MR_FF			 := GetProcAddress(FDLLInstance, 'ecmIxCfg_SetSpeedPatt_MR_FF');			 
        //@ecmIxCfg_GetSpeedPatt_MR			     := GetProcAddress(FDLLInstance, 'ecmIxCfg_GetSpeedPatt_MR');			     
        //@ecmIxCfg_SetMastWeight				     := GetProcAddress(FDLLInstance, 'ecmIxCfg_SetMastWeight');				     
        //@ecmIxCfg_GetMastWeight				     := GetProcAddress(FDLLInstance, 'ecmIxCfg_GetMastWeight');				     
        //@ecmIxCfg_SetJerkRatio				     := GetProcAddress(FDLLInstance, 'ecmIxCfg_SetJerkRatio');				     
        //@ecmIxCfg_SetJerkRatio_FF 			     := GetProcAddress(FDLLInstance, 'ecmIxCfg_SetJerkRatio_FF'); 			     
        //@ecmIxCfg_GetJerkRatio				     := GetProcAddress(FDLLInstance, 'ecmIxCfg_GetJerkRatio');				     
        //@ecmIxCfg_Spline_ClearPool			     := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_ClearPool');			     
        //@ecmIxCfg_Spline_AddNewObj			     := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_AddNewObj');			     
        //@ecmIxCfg_Spline_SetRefPoint			 := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_SetRefPoint');			 
        //@ecmIxCfg_Spline_BuildObj			     := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_BuildObj');			     
        //@ecmIxCfg_Spline_SetTrgOutEnv		     := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_SetTrgOutEnv');		     
        //@ecmIxCfg_Spline_GetTrgOutEnv		     := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_GetTrgOutEnv');		     
        //@ecmIxCfg_Spline_GetTrgOutPos		     := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_GetTrgOutPos');		     
        //@ecmIxCfg_Spline_SetJsType			     := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_SetJsType');			     
        //@ecmIxCfg_Spline_GetJsType			     := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_GetJsType');			     
        //@ecmIxCfg_Spline_SetJsProp_F			 := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_SetJsProp_F');			 
        //@ecmIxCfg_Spline_GetJsProp_F			 := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_GetJsProp_F');			 
        //@ecmIxCfg_Spline_SetJerkThresh		     := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_SetJerkThresh');		     
        //@ecmIxCfg_Spline_GetJerkThresh		     := GetProcAddress(FDLLInstance, 'ecmIxCfg_Spline_GetJerkThresh');		     
        //@ecmIxCfg_MPRLin2X_ClearPool			 := GetProcAddress(FDLLInstance, 'ecmIxCfg_MPRLin2X_ClearPool');			 
        //@ecmIxCfg_MPRLin2X_AddNewObj			 := GetProcAddress(FDLLInstance, 'ecmIxCfg_MPRLin2X_AddNewObj');			 
        //@ecmIxCfg_MPRLin2X_SetRefPoint		     := GetProcAddress(FDLLInstance, 'ecmIxCfg_MPRLin2X_SetRefPoint');		     
        //@ecmIxCfg_MPRLin2X_BuildObj			     := GetProcAddress(FDLLInstance, 'ecmIxCfg_MPRLin2X_BuildObj');			     
        //@ecmIxMot_LineStart					     := GetProcAddress(FDLLInstance, 'ecmIxMot_LineStart');
        //@ecmIxMot_LineStart_FF				     := GetProcAddress(FDLLInstance, 'ecmIxMot_LineStart_FF');				     
        //@ecmIxMot_Line						     := GetProcAddress(FDLLInstance, 'ecmIxMot_Line');						     
        //@ecmIxMot_Line_NB					     := GetProcAddress(FDLLInstance, 'ecmIxMot_Line_NB');					     
        //@ecmIxMot_LineToStart				     := GetProcAddress(FDLLInstance, 'ecmIxMot_LineToStart');				     
        //@ecmIxMot_LineToStart_FF				 := GetProcAddress(FDLLInstance, 'ecmIxMot_LineToStart_FF');				 
        //@ecmIxMot_LineTo						 := GetProcAddress(FDLLInstance, 'ecmIxMot_LineTo');						 
        //@ecmIxMot_LineTo_NB					     := GetProcAddress(FDLLInstance, 'ecmIxMot_LineTo_NB');					     
        //@ecmIxMot_ArcAng_R_Start				 := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcAng_R_Start');				 
        //@ecmIxMot_ArcAng_R_Start_FF 			 := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcAng_R_Start_FF'); 			 
        //@ecmIxMot_ArcAng_R					     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcAng_R');					     
        //@ecmIxMot_ArcAng_R_NB				     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcAng_R_NB');				     
        //@ecmIxMot_ArcAng_A_Start				 := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcAng_A_Start');				 
        //@ecmIxMot_ArcAng_A_Start_FF			     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcAng_A_Start_FF');			     
        //@ecmIxMot_ArcAng_A					     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcAng_A');					     
        //@ecmIxMot_ArcAng_A_NB				     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcAng_A_NB');				     
        //@ecmIxMot_ArcPos_R_Start				 := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcPos_R_Start');				 
        //@ecmIxMot_ArcPos_R_Start_FF			     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcPos_R_Start_FF');			     
        //@ecmIxMot_ArcPos_R					     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcPos_R');					     
        //@ecmIxMot_ArcPos_R_NB				     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcPos_R_NB');				     
        //@ecmIxMot_ArcPos_A_Start				 := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcPos_A_Start');				 
        //@ecmIxMot_ArcPos_A_Start_FF			     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcPos_A_Start_FF');			     
        //@ecmIxMot_ArcPos_A					     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcPos_A');					     
        //@ecmIxMot_ArcPos_A_NB				     := GetProcAddress(FDLLInstance, 'ecmIxMot_ArcPos_A_NB');				     
        //@ecmIxMot_Arc3P_R_Start				     := GetProcAddress(FDLLInstance, 'ecmIxMot_Arc3P_R_Start');				     
        //@ecmIxMot_Arc3P_R_Start_FF			     := GetProcAddress(FDLLInstance, 'ecmIxMot_Arc3P_R_Start_FF');			     
        //@ecmIxMot_Arc3P_R					     := GetProcAddress(FDLLInstance, 'ecmIxMot_Arc3P_R');					     
        //@ecmIxMot_Arc3P_R_NB					 := GetProcAddress(FDLLInstance, 'ecmIxMot_Arc3P_R_NB');					 
        //@ecmIxMot_Arc3P_A_Start				     := GetProcAddress(FDLLInstance, 'ecmIxMot_Arc3P_A_Start');				     
        //@ecmIxMot_Arc3P_A_FF					 := GetProcAddress(FDLLInstance, 'ecmIxMot_Arc3P_A_FF');					 
        //@ecmIxMot_Arc3P_A					     := GetProcAddress(FDLLInstance, 'ecmIxMot_Arc3P_A');					     
        //@ecmIxMot_Arc3P_A_NB					 := GetProcAddress(FDLLInstance, 'ecmIxMot_Arc3P_A_NB');					 
        //@ecmIxMot_Spline_Start				     := GetProcAddress(FDLLInstance, 'ecmIxMot_Spline_Start');				     
        //@ecmIxMot_MPRLin2X_Start				 := GetProcAddress(FDLLInstance, 'ecmIxMot_MPRLin2X_Start');				 
        //@ecmIxMot_MoveVia2X_Start			     := GetProcAddress(FDLLInstance, 'ecmIxMot_MoveVia2X_Start');			     
        //@ecmIxMot_MoveVia2X_OverrideTP		     := GetProcAddress(FDLLInstance, 'ecmIxMot_MoveVia2X_OverrideTP');		     
        //@ecmIxMot_Stop						     := GetProcAddress(FDLLInstance, 'ecmIxMot_Stop');						     
        //@ecmIxMot_Stop_FF					     := GetProcAddress(FDLLInstance, 'ecmIxMot_Stop_FF');
        //@ecmIxSt_IsBusy						     := GetProcAddress(FDLLInstance, 'ecmIxSt_IsBusy');						     
        //@ecmIxSt_WaitCompt					     := GetProcAddress(FDLLInstance, 'ecmIxSt_WaitCompt');					     
        //@ecmIxSt_WaitCompt_NB				     := GetProcAddress(FDLLInstance, 'ecmIxSt_WaitCompt_NB');				     
        @ecmHomeCfg_SetOption				     := GetProcAddress(FDLLInstance, 'ecmHomeCfg_SetOption');				     
        @ecmHomeCfg_GetOption				     := GetProcAddress(FDLLInstance, 'ecmHomeCfg_GetOption');				     
        @ecmHomeCfg_SetMode					     := GetProcAddress(FDLLInstance, 'ecmHomeCfg_SetMode');					     
        @ecmHomeCfg_SetOffset				     := GetProcAddress(FDLLInstance, 'ecmHomeCfg_SetOffset');				     
        @ecmHomeCfg_GetOffset				     := GetProcAddress(FDLLInstance, 'ecmHomeCfg_GetOffset');				     
        @ecmHomeCfg_SetSpeedPatt				 := GetProcAddress(FDLLInstance, 'ecmHomeCfg_SetSpeedPatt');				 
        @ecmHomeCfg_GetSpeedPatt				 := GetProcAddress(FDLLInstance, 'ecmHomeCfg_GetSpeedPatt');				 
        @ecmHomeCfg_GetMode					     := GetProcAddress(FDLLInstance, 'ecmHomeCfg_GetMode');					     
        @ecmHomeMot_MoveStart				     := GetProcAddress(FDLLInstance, 'ecmHomeMot_MoveStart');				     
        //@ecmHomeMot_MoveStart_FF				 := GetProcAddress(FDLLInstance, 'ecmHomeMot_MoveStart_FF');
        @ecmHomeMot_Move						 := GetProcAddress(FDLLInstance, 'ecmHomeMot_Move');						 
        @ecmHomeSt_IsBusy					     := GetProcAddress(FDLLInstance, 'ecmHomeSt_IsBusy');					     
        @ecmHomeSt_WaitCompt					 := GetProcAddress(FDLLInstance, 'ecmHomeSt_WaitCompt');					 
        @ecmHomeSt_GetFlags					     := GetProcAddress(FDLLInstance, 'ecmHomeSt_GetFlags');					     
        @ecmMsCfg_SetSlvEnv					     := GetProcAddress(FDLLInstance, 'ecmMsCfg_SetSlvEnv');					     
        @ecmMsCfg_GetSlvEnv					     := GetProcAddress(FDLLInstance, 'ecmMsCfg_GetSlvEnv');					     
        @ecmMsCtl_StartSlv					     := GetProcAddress(FDLLInstance, 'ecmMsCtl_StartSlv');					     
        @ecmMsCtl_StopSlv					     := GetProcAddress(FDLLInstance, 'ecmMsCtl_StopSlv');					     
        @ecmMsCtl_SynchSlv					     := GetProcAddress(FDLLInstance, 'ecmMsCtl_SynchSlv');					     
        @ecmMsSt_IsSlvStarted				     := GetProcAddress(FDLLInstance, 'ecmMsSt_IsSlvStarted');				     
        //@ecmLmResetAll						     := GetProcAddress(FDLLInstance, 'ecmLmResetAll');						     
        //@ecmLmCtl_Begin						     := GetProcAddress(FDLLInstance, 'ecmLmCtl_Begin');						     
        //@ecmLmCtl_End						     := GetProcAddress(FDLLInstance, 'ecmLmCtl_End');						     
        //@ecmLmCtl_Run						     := GetProcAddress(FDLLInstance, 'ecmLmCtl_Run');						     
        //@ecmLmCtl_Stop						     := GetProcAddress(FDLLInstance, 'ecmLmCtl_Stop');						     
        //@ecmLmCtl_ClearQue					     := GetProcAddress(FDLLInstance, 'ecmLmCtl_ClearQue');					     
        //@ecmLmCfg_SetQueFullMode				 := GetProcAddress(FDLLInstance, 'ecmLmCfg_SetQueFullMode');				 
        //@ecmLmCfg_GetQueFullMode				 := GetProcAddress(FDLLInstance, 'ecmLmCfg_GetQueFullMode');				 
        //@ecmLmCfg_SetQueDepth				     := GetProcAddress(FDLLInstance, 'ecmLmCfg_SetQueDepth');				     
        //@ecmLmCfg_GetQueDepth				     := GetProcAddress(FDLLInstance, 'ecmLmCfg_GetQueDepth');				     
        //@ecmLmCfg_SetStepId					     := GetProcAddress(FDLLInstance, 'ecmLmCfg_SetStepId');					     
        //@ecmLmCfg_GetStepId					     := GetProcAddress(FDLLInstance, 'ecmLmCfg_GetStepId');					     
        //@ecmLmCfg_SetStepParam				     := GetProcAddress(FDLLInstance, 'ecmLmCfg_SetStepParam');				     
        //@ecmLmCfg_GetStepParam				     := GetProcAddress(FDLLInstance, 'ecmLmCfg_GetStepParam');
        //@ecmLmSt_GetRunSts					     := GetProcAddress(FDLLInstance, 'ecmLmSt_GetRunSts');					     
        //@ecmLmSt_GetRemStepCount				 := GetProcAddress(FDLLInstance, 'ecmLmSt_GetRemStepCount');				 
        //@ecmLmSt_GetRunStepInfo				     := GetProcAddress(FDLLInstance, 'ecmLmSt_GetRunStepInfo');				     
        //@ecmLmSt_GetRunStepParam				 := GetProcAddress(FDLLInstance, 'ecmLmSt_GetRunStepParam');				 
        //@ecmLmCmd_Delay						     := GetProcAddress(FDLLInstance, 'ecmLmCmd_Delay');						     
        //@ecmPtmResetAll						     := GetProcAddress(FDLLInstance, 'ecmPtmResetAll');						     
        //@ecmPtmCtl_Begin						 := GetProcAddress(FDLLInstance, 'ecmPtmCtl_Begin');						 
        //@ecmPtmCtl_End						     := GetProcAddress(FDLLInstance, 'ecmPtmCtl_End');						     
        //@ecmPtmCtl_SetHold					     := GetProcAddress(FDLLInstance, 'ecmPtmCtl_SetHold');					     
        //@ecmPtmCmd_AddItem_PT				     := GetProcAddress(FDLLInstance, 'ecmPtmCmd_AddItem_PT');				     
        //@ecmPtmSt_GetRunSts					     := GetProcAddress(FDLLInstance, 'ecmPtmSt_GetRunSts');					     
        //@ecmPtmSt_GetRunStepInfo				 := GetProcAddress(FDLLInstance, 'ecmPtmSt_GetRunStepInfo');				 
        //@ecmMPMon_AddAxis					     := GetProcAddress(FDLLInstance, 'ecmMPMon_AddAxis');					     
        //@ecmMPMon_DelAxis					     := GetProcAddress(FDLLInstance, 'ecmMPMon_DelAxis');					     
        //@ecmMPMon_SetAxisEnable				     := GetProcAddress(FDLLInstance, 'ecmMPMon_SetAxisEnable');				     
        //@ecmMPMon_GetAxisStatus				     := GetProcAddress(FDLLInstance, 'ecmMPMon_GetAxisStatus');				     
        //@ecmMPMon_ResetAxisData				     := GetProcAddress(FDLLInstance, 'ecmMPMon_ResetAxisData');				     
        //@ecmMPMon_ResetSectData				     := GetProcAddress(FDLLInstance, 'ecmMPMon_ResetSectData');
        //@ecmMPMon_SetTorqThreshVal			     := GetProcAddress(FDLLInstance, 'ecmMPMon_SetTorqThreshVal');			     
        //@ecmMPMon_GetTorqThreshVal			     := GetProcAddress(FDLLInstance, 'ecmMPMon_GetTorqThreshVal');			     
        //@ecmMPMon_SetDevThreshVal			     := GetProcAddress(FDLLInstance, 'ecmMPMon_SetDevThreshVal');			     
        //@ecmMPMon_GetDevThreshVal			     := GetProcAddress(FDLLInstance, 'ecmMPMon_GetDevThreshVal');			     
        //@ecmMPMon_ReadAxisData				     := GetProcAddress(FDLLInstance, 'ecmMPMon_ReadAxisData');				     
        //@ecmMPMon_WriteAxisData				     := GetProcAddress(FDLLInstance, 'ecmMPMon_WriteAxisData');				     
        //@ecUtl_ShowError_A					     := GetProcAddress(FDLLInstance, 'ecUtl_ShowError_A');					     
        //@ecUtl_ShowError_W					     := GetProcAddress(FDLLInstance, 'ecUtl_ShowError_W');					     
        //@ecUtl_ShowMessage_A					 := GetProcAddress(FDLLInstance, 'ecUtl_ShowMessage_A');					 
        //@ecUtl_ShowMessage_W					 := GetProcAddress(FDLLInstance, 'ecUtl_ShowMessage_W');					 
        //@ecUtl_GetCntDiff_UI32				     := GetProcAddress(FDLLInstance, 'ecUtl_GetCntDiff_UI32');				     
        //@ecUtl_GetCntDiff_UI16				     := GetProcAddress(FDLLInstance, 'ecUtl_GetCntDiff_UI16');				     
        //@ecUtl_IsTimeOut						 := GetProcAddress(FDLLInstance, 'ecUtl_IsTimeOut');						 
        //@ecNet_SetEnableSTM					     := GetProcAddress(FDLLInstance, 'ecNet_SetEnableSTM');					     
        @ecSlv_SetAlState_A					     := GetProcAddress(FDLLInstance, 'ecSlv_SetAlState_A');	

	end;
end;

procedure UnloadDll;
begin
	if not FreeLibrary(FDLLInstance) then exit;
end;

// ߰ 
function cmlGnABSUpdate(BoardId : LongInt) : LongInt;
begin

end;

//
function cmlGnLoadDevice(NumDevices : PLongInt; BoardIDList : PLongInt; NumServos : PLongInt) : LongInt;
var
  Err : LongInt;
  AxisListBuf : PByte;
begin

  ecGn_LoadDevice(@Err);
  NumDevices^ := ecGn_GetNumDevices(@Err);
  BoardIDList^ := 0;
  NumServos^ := ecmGn_GetAxisList(0, @AxisListBuf, 1, @Err);

  Result := Err;
end;

// ش Լ 
function cmlGnResetDevice(BoardId : LongInt; ResetMask : LongInt) : LongInt;
begin

end;

// ش Լ 
function cmlGnResetComm(BoardId : LongInt) : LongInt;
begin

end;

// ߰ 
function cmlGnSetABSMode(BoardId : LongInt; Axis : LongInt; EncoderMode : LongInt) : LongInt;
var

  Err : LongInt;

begin

  ABS_OFFSET[Axis] := (-1) * ecmSxSt_GetPosition(BoardId, Axis, 1, @Err);


  if(Err = 0) then

  begin

    if(EncoderMode = 0) then

      ISABSMODE[Axis] := TRUE

    else

    begin

      ISABSMODE[Axis] := FALSE;
      ABS_OFFSET[Axis] := 0;
    end;

  end
  else
    ABS_OFFSET[Axis] := 0;

  Result := Err;
end;

//  Ȯ  غ
function cmlGnSetAlarmRes(BoardId : LongInt; Axis : LongInt) : LongInt;
var
  Err : LongInt;
begin

  ecmSxCtl_ResetAlm(BoardId, Axis, @Err);

  Result := Err;
end;

//
function cmlCfgSetUnitDist(BoardId : LongInt; Axis : LongInt; UnitDist : Double) : LongInt;
var
  Err : LongInt;
begin

  ecmSxCfg_SetUnitDist(BoardId, Axis, UnitDist, @Err);

  Result := Err;
end;

//
function cmlCfgSetUnitSpeed(BoardId : LongInt; Axis : LongInt; UnitSpeed : Double) : LongInt;
var

  Err : LongInt;
begin

  ecmSxCfg_SetUnitSpeed(BoardId, Axis, UnitSpeed, @Err);

  Result := Err;

end;

//
function cmlCfgSetRotateAxis(BoardId : LongInt; Axis : LongInt; Enable : LongInt) : LongInt;
var

  Err : LongInt;

begin

  if(Enable = 1) then

  begin
    ISROTATEAXIS[Axis] := TRUE;
    cmlCfgSetUnitDist(BoardId, Axis, 1000);
    ecmSxCfg_Ring_SetDirMode(BoardId, Axis, 2, @Err);
    ecmSxCfg_Ring_SetPosRange(BoardId, Axis, 360, @Err);
    ecmSxCfg_Ring_SetEnable(BoardId, Axis, true, @Err);
  end
  else
  begin
    ISROTATEAXIS[Axis] := FALSE;
    cmlCfgSetUnitDist(BoardId, Axis, 1);
    ecmSxCfg_Ring_SetEnable(BoardId, Axis, false, @Err);
  end;

end;

// PPR Ȯ ʿ
function cmlCfgGetRotateAxisInfo(BoardId : LongInt; Axis : LongInt; Enable : PLongInt; PPR : PLongInt) : LongInt;
var

  Err : LongInt;

begin

  if (ecmSxCfg_Ring_GetEnable(BoardId, Axis, @Err)) then
    Enable^ := 1
  else
    Enable^ := 0;

  PPR^ := 360000;

  Result := Err;
end;

//
function cmlStSxReadMotionState(BoardId : LongInt; Channel : LongInt; MotStates : PLongInt) : LongInt;
var

  Err : LongInt;

begin

  MotStates^ := ecmSxSt_GetMotState(BoardId, Channel, @Err);

  Result := Err;
end;
function cmlHomeIsBusy(BoardId : LongInt; Channel : LongInt; IsBusy : PLongInt) : LongInt;
var

  Err : LongInt;

begin

    if(ecmHomeSt_IsBusy(BoardId, Channel, @Err)) then
      IsBusy^ := 1
    else
      IsBusy^ := 0;


    Result := Err;
end;

//
function cmlStGetPosition(BoardId : LongInt; Channel : LongInt; Source : LongInt; Count : PDouble) : LongInt;
var
  Err : LongInt;
begin

  Count^ := ecmSxSt_GetPosition(BoardId, Channel, Source, @Err);


  Result := Err;
end;

//
function cmlStGetSpeed(BoardId : LongInt; Channel : LongInt; Source : LongInt; Speed : PDouble) : LongInt;
var

  Err : LongInt;

begin

  Speed^ := ecmSxSt_GetCurSpeed(BoardId, Channel, Source, @Err);

  Result := Err;
end;

//
function cmlCfgSetSpeedPattern(BoardId : LongInt; Axis : LongInt; SpeedMode : LongInt; Work : Double; Acc : Double; Dec : Double; IniSpeed : Double; EndSpeed : Double) : LongInt;
var

  Err : LongInt;

begin

  ecmSxCfg_SetSpeedPatt(BoardId, Axis, SpeedMode, IniSpeed, EndSpeed, Work, Acc, Dec, @Err);

  Result := Err;
end;

//
function cmlOverrideSpeedSet(BoardId : LongInt; Channel : LongInt) : LongInt;
var

  Err : LongInt;

begin

  ecmSxMot_OverrideSpeed(BoardId, Channel, @Err);

  Result := Err;
end;

//   Ȯ ʿ
function cmlSxStopEmg(BoardId : LongInt; Axis : LongInt) : LongInt;
var

  Err : LongInt;

begin

  ecmSxMot_Stop(BoardId, Axis, 0, 0, @Err);

  Result := Err;
end;

//   Ȯ ʿ
function cmlSxStop(BoardId : LongInt; Axis : LongInt) : LongInt;
var

  Err : LongInt;

begin

  ecmSxMot_Stop(BoardId, Axis, 1, 0, @Err);

  Result := Err;
end;

//
function cmlGnSetServoOn(BoardId : LongInt; Axis : LongInt; dwlsOn : LongInt) : LongInt;
var
  Err : LongInt;
begin
  ecmSxCtl_SetSvon(BoardId, Axis, dwlsOn, @Err);
  Result := Err;
end;

//
function cmlGnGetServoOn(BoardId : LongInt; Axis : LongInt; dwlsOn : PLongInt) : LongInt;
var
  Err : LongInt;
  svon : LongInt;

begin

  if (ecmSxCtl_GetSvon(BoardId, Axis, @Err)) then
    dwlsOn^ := 1
  else
    dwlsOn^ := 0;

  Result := Err;
end;

//
function cmlSxMoveToStart(BoardId : LongInt; Axis : LongInt; Position : Double) : LongInt;
var

  Err : LongInt;

begin

  ecmSxMot_MoveToStart(BoardId, Axis, Position, @Err);

  Result := Err;
end;


function cmlSxRSearchStart(BoardId : LongInt; Axis : LongInt; Angle : Double) : LongInt;
var

  Err : LongInt;

begin

  ecmSxMot_MoveToStart(BoardId, Axis, Angle, @Err);

  Result := Err;

end;

//
function cmlSxVMoveStart(BoardId : LongInt; Axis : LongInt; Dir : LongInt) : LongInt;
var
  Err : LongInt;
begin

  ecmSxMot_VMoveStart(BoardId, Axis, Dir, @Err);

  Result := Err;
end;

// Enum Ȯ ʿ
function cmlStReadMioStatuses(BoardId : LongInt; Channel : LongInt; MioStates : PLongInt) : LongInt;
var

  Err : LongInt;

  temp : word;

begin

  temp := ecmSxSt_GetDI(BoardId, Channel, @Err);

  MioStates^ := temp;

  Result := Err;
end;

// ũ ml LongInt ECAT Double
function cmlStGetTorque(BoardId : LongInt; Channel : LongInt; Torque : PLongInt) : LongInt;
var

  Err : LongInt;

  TorqueTemp : Double;

  //Temp : Str;

begin

  //TorqueTemp := ecmSxSt_GetCurTorque(BoardId, Channel, @Err);

  //Torque^ := Trunc(TorqueTemp);    // 
  //Torque^ := Round(TorqueTemp);      // ݿø

  Torque^ := Round(ecmSxSt_GetCurTorque(BoardId, Channel, @Err));

  Result := Err;
end;

//
function cmlMxMoveToStart(BoardId : LongInt; NumAxes : LongInt; AxisList : PLongInt; PosList : PDouble) : LongInt;
var

  Err : LongInt;

begin

  ecmMxMot_MoveToStart(BoardId, NumAxes, AxisList, PosList, @Err);

  Result := Err;
end;

Initialization

begin
	LoadDll;

end;

Finalization
	UnloadDll;
end.
