unit formInitialize;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls;

type
  TForm2 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    procedure Button1Click(Sender: TObject);
    procedure devInit();
    procedure GetVersionCompResult();
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation
uses ComiEcatSdk, System.Diagnostics;
{$R *.dfm}

Const
netId : Integer = 0;

// ̽ ʱȭ  

procedure TForm2.Button1Click(Sender: TObject);

begin
  devInit();
end;

procedure TForm2.devInit();
var
  errorCode : LongInt;

  cfgCount : Cardinal;
  slaveCount : Cardinal;

  alState : Byte;
  StopWatch : TStopwatch;
  ElapsedMillseconds : Int64;
  isSuccess : Boolean;

  i : Integer;
begin
  // Device loadѴ.
  if(ecGn_LoadDevice(@errorCode)<>TRUE) then
  begin

    ListBox1.Items.add(IntToStr(errorCode));

    if(errorCode = -5) then
    begin
      ListBox1.Items.add('Mater Device 12V  ԷµǾ Ȯ ٶϴ.');
    end
    else if(errorCode = -8) then
    begin
      ListBox1.Items.add('Mater Device õ ʾҽϴ. Windows FastBoot(ѱ) Ȱȭ Ǿ ִ  Ȱȭ ϼ');
    end;

    exit();
  end;

  // Config slave  ȮѴ.
  // Configuration ܰ迡  ̺    ̺ ʹ  .
  cfgCount := ecNet_GetCfgSlaveCount(netId, @errorCode);
  if(errorCode <> 0) then
  begin
    ListBox1.Items.add(IntToStr(errorCode));
    exit();
  end;

  //  Ʈũ Ǿ ִ slave  ȮѴ.
  slaveCount := ecNet_ScanSlaves(netId, @errorCode);
  if(errorCode <> 0) then
  begin
    ListBox1.Items.add(IntToStr(errorCode));
    exit();
  end;

  //   ŭ ĵǾ ȮѴ.
  if(cfgCount <> slaveCount) then
  begin
    ListBox1.Items.add(' ĵ ̺    ̺    ٸϴ.');

    ListBox1.Items.add('ScanSlave : ' + IntToStr(cfgCount) + ', CfgCount : ' + IntToStr(slaveCount));

    ListBox1.Items.add('  ʾҰų Ʈũ   ̺  ִ ȮϽñ ٶϴ.');

    ListBox1.Items.add('͸  ̺   ScanSlave ٸ Configuration   Ͻñ ٶϴ.');
    exit();
  end;

  // version match -  

  //public enum EEcAlState
  //      {
  //          DISCONNECTED = 0,
  //          INITIAL = 1,
  //          PREOP = 2,
  //          BOOTSTRAP = 3,
  //          SAFEOP = 4,
  //          OP = 8
  //      }

  //   alState OP Ѵ.
  ecNet_SetAlState(netId, 8, @errorCode);
  if(errorCode <> 0) then
  begin
    ListBox1.Items.add(IntToStr(errorCode));
    exit();
  end;

  ListBox1.Items.add('Set AlState to OP');


  //   alState OP Ǿ ȮѴ.
  // alState OP ƴ ̺ pdo    ʴ´.
  alState := 0;
  StopWatch := TStopwatch.StartNew;
  ElapsedMillseconds := 0;
  isSuccess := false;

  while((ElapsedMillseconds < 10000) and (isSuccess <> true)) Do
  begin
    isSuccess := true;

    for i := 0 to slaveCount-1 do
    begin
      alState := ecSlv_GetAlState_A(netId, i, @errorCode);
      if((alState <> 8) or (errorCode <> 0)) then
      begin
        isSuccess := false;
        break;
      end;
    end;
    Sleep(200);
    ElapsedMillseconds := StopWatch.ElapsedMilliseconds;
  end;

  if(isSuccess <> true) then
  begin
    for i := 0 to slaveCount-1 do
    begin
      alState := ecSlv_GetAlState_A(netId, i, @errorCode);
      if((alState <> 8) or (errorCode <> 0)) then
      begin
        ListBox1.Items.add('̺ : {' + IntToStr(i) + '}  AlState OP ϴµ Ͽϴ.');
        exit();
      end;
    end;
  end;

  // Scan  Axis IO ä  Ϸ Ʒ ڵ带 Ѵ. -  

  ListBox1.Items.add('Initialize ');
end;

procedure TForm2.GetVersionCompResult();
var
  isSuccess : Boolean;
begin

end;
end.
